; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O3 -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512vp2intersect,+avx512vl < %s | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-unknown"

define void @stack_fold_vp2intersectd(ptr %a, <16 x i32> %b, ptr nocapture %m0, ptr nocapture %m1) {
; CHECK-LABEL: stack_fold_vp2intersectd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    vmovdqa64 (%rdi), %zmm0
; CHECK-NEXT:    vp2intersectd {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %k0 # 64-byte Folded Reload
; CHECK-NEXT:    kmovw %k0, (%rsi)
; CHECK-NEXT:    kmovw %k1, (%rdx)
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load <16 x i32>, ptr %a
  %3 = tail call { <16 x i1>, <16 x i1> } @llvm.x86.avx512.vp2intersect.d.512(<16 x i32> %2, <16 x i32> %b)
  %4 = extractvalue { <16 x i1>, <16 x i1> } %3, 0
  store <16 x i1> %4, ptr %m0
  %5 = extractvalue { <16 x i1>, <16 x i1> } %3, 1
  store <16 x i1> %5, ptr %m1
  ret void
}
declare { <16 x i1>, <16 x i1> } @llvm.x86.avx512.vp2intersect.d.512(<16 x i32>, <16 x i32>)

define void @stack_fold_vp2intersectq(ptr %a, <8 x i64> %b, ptr nocapture %m0, ptr nocapture %m1) {
; CHECK-LABEL: stack_fold_vp2intersectq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    vmovdqa64 (%rdi), %zmm0
; CHECK-NEXT:    vp2intersectq {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %k0 # 64-byte Folded Reload
; CHECK-NEXT:    kmovw %k1, %eax
; CHECK-NEXT:    kmovw %k0, %ecx
; CHECK-NEXT:    movb %cl, (%rsi)
; CHECK-NEXT:    movb %al, (%rdx)
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load <8 x i64>, ptr %a
  %3 = tail call { <8 x i1>, <8 x i1> } @llvm.x86.avx512.vp2intersect.q.512(<8 x i64> %2, <8 x i64> %b)
  %4 = extractvalue { <8 x i1>, <8 x i1> } %3, 0
  store <8 x i1> %4, ptr %m0
  %5 = extractvalue { <8 x i1>, <8 x i1> } %3, 1
  store <8 x i1> %5, ptr %m1
  ret void
}
declare { <8 x i1>, <8 x i1> } @llvm.x86.avx512.vp2intersect.q.512(<8 x i64>, <8 x i64>)

define void @stack_fold_vp2intersectd_256(ptr %a, <8 x i32> %b, ptr nocapture %m0, ptr nocapture %m1) {
; CHECK-LABEL: stack_fold_vp2intersectd_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    vmovdqa (%rdi), %ymm0
; CHECK-NEXT:    vp2intersectd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %k0 # 32-byte Folded Reload
; CHECK-NEXT:    kmovw %k1, %eax
; CHECK-NEXT:    kmovw %k0, %ecx
; CHECK-NEXT:    movb %cl, (%rsi)
; CHECK-NEXT:    movb %al, (%rdx)
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load <8 x i32>, ptr %a
  %3 = tail call { <8 x i1>, <8 x i1> } @llvm.x86.avx512.vp2intersect.d.256(<8 x i32> %2, <8 x i32> %b)
  %4 = extractvalue { <8 x i1>, <8 x i1> } %3, 0
  store <8 x i1> %4, ptr %m0
  %5 = extractvalue { <8 x i1>, <8 x i1> } %3, 1
  store <8 x i1> %5, ptr %m1
  ret void
}
declare { <8 x i1>, <8 x i1> } @llvm.x86.avx512.vp2intersect.d.256(<8 x i32>, <8 x i32>)

define void @stack_fold_vp2intersectq_256(ptr %a, <4 x i64> %b, ptr nocapture %m0, ptr nocapture %m1) {
; CHECK-LABEL: stack_fold_vp2intersectq_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    vmovdqa (%rdi), %ymm0
; CHECK-NEXT:    vp2intersectq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %k0 # 32-byte Folded Reload
; CHECK-NEXT:    kshiftlw $12, %k0, %k2
; CHECK-NEXT:    kshiftrw $12, %k2, %k2
; CHECK-NEXT:    kmovw %k2, %eax
; CHECK-NEXT:    movb %al, (%rsi)
; CHECK-NEXT:    kshiftlw $12, %k1, %k0
; CHECK-NEXT:    kshiftrw $12, %k0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    movb %al, (%rdx)
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load <4 x i64>, ptr %a
  %3 = tail call { <4 x i1>, <4 x i1> } @llvm.x86.avx512.vp2intersect.q.256(<4 x i64> %2, <4 x i64> %b)
  %4 = extractvalue { <4 x i1>, <4 x i1> } %3, 0
  store <4 x i1> %4, ptr %m0
  %5 = extractvalue { <4 x i1>, <4 x i1> } %3, 1
  store <4 x i1> %5, ptr %m1
  ret void
}
declare { <4 x i1>, <4 x i1> } @llvm.x86.avx512.vp2intersect.q.256(<4 x i64>, <4 x i64>)

define void @stack_fold_vp2intersectd_128(ptr %a, <4 x i32> %b, ptr nocapture %m0, ptr nocapture %m1) {
; CHECK-LABEL: stack_fold_vp2intersectd_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    vmovdqa (%rdi), %xmm0
; CHECK-NEXT:    vp2intersectd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %k0 # 16-byte Folded Reload
; CHECK-NEXT:    kshiftlw $12, %k0, %k2
; CHECK-NEXT:    kshiftrw $12, %k2, %k2
; CHECK-NEXT:    kmovw %k2, %eax
; CHECK-NEXT:    movb %al, (%rsi)
; CHECK-NEXT:    kshiftlw $12, %k1, %k0
; CHECK-NEXT:    kshiftrw $12, %k0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    movb %al, (%rdx)
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load <4 x i32>, ptr %a
  %3 = tail call { <4 x i1>, <4 x i1> } @llvm.x86.avx512.vp2intersect.d.128(<4 x i32> %2, <4 x i32> %b)
  %4 = extractvalue { <4 x i1>, <4 x i1> } %3, 0
  store <4 x i1> %4, ptr %m0
  %5 = extractvalue { <4 x i1>, <4 x i1> } %3, 1
  store <4 x i1> %5, ptr %m1
  ret void
}
declare { <4 x i1>, <4 x i1> } @llvm.x86.avx512.vp2intersect.d.128(<4 x i32>, <4 x i32>)

define void @stack_fold_vp2intersectq_128(ptr %a, <2 x i64> %b, ptr nocapture %m0, ptr nocapture %m1) {
; CHECK-LABEL: stack_fold_vp2intersectq_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    vmovdqa (%rdi), %xmm0
; CHECK-NEXT:    vp2intersectq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %k0 # 16-byte Folded Reload
; CHECK-NEXT:    kshiftlw $14, %k0, %k2
; CHECK-NEXT:    kshiftrw $14, %k2, %k2
; CHECK-NEXT:    kmovw %k2, %eax
; CHECK-NEXT:    movb %al, (%rsi)
; CHECK-NEXT:    kshiftlw $14, %k1, %k0
; CHECK-NEXT:    kshiftrw $14, %k0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    movb %al, (%rdx)
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{xmm16},~{xmm17},~{xmm18},~{xmm19},~{xmm20},~{xmm21},~{xmm22},~{xmm23},~{xmm24},~{xmm25},~{xmm26},~{xmm27},~{xmm28},~{xmm29},~{xmm30},~{xmm31},~{flags}"()
  %2 = load <2 x i64>, ptr %a
  %3 = tail call { <2 x i1>, <2 x i1> } @llvm.x86.avx512.vp2intersect.q.128(<2 x i64> %2, <2 x i64> %b)
  %4 = extractvalue { <2 x i1>, <2 x i1> } %3, 0
  store <2 x i1> %4, ptr %m0
  %5 = extractvalue { <2 x i1>, <2 x i1> } %3, 1
  store <2 x i1> %5, ptr %m1
  ret void
}
declare { <2 x i1>, <2 x i1> } @llvm.x86.avx512.vp2intersect.q.128(<2 x i64>, <2 x i64>)
