/*
 * Copyright (C) 2022 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef CPUFEATURES_H
#define CPUFEATURES_H

#ifdef __cplusplus
extern "C" {
#endif

enum lc_cpu_features {
	LC_CPU_FEATURE_NONE = 0,

	/* Intel-specific */
	LC_CPU_FEATURE_INTEL = 1 << 0,
	LC_CPU_FEATURE_INTEL_AVX = 1 << 1,
	LC_CPU_FEATURE_INTEL_AVX2 = 1 << 2,
	LC_CPU_FEATURE_INTEL_AVX512 = 1 << 3,
	LC_CPU_FEATURE_INTEL_AESNI = 1 << 4,
	LC_CPU_FEATURE_INTEL_VPCLMUL = 1 << 5,
	LC_CPU_FEATURE_INTEL_PCLMUL = 1 << 6,
	LC_CPU_FEATURE_INTEL_SHANI = 1 << 7,
	LC_CPU_FEATURE_INTEL_SHANI512 = 1 << 8,

	/* ARM-specific */
	LC_CPU_FEATURE_ARM = 1 << 10,
	LC_CPU_FEATURE_ARM_AES = 1 << 11,
	LC_CPU_FEATURE_ARM_NEON = 1 << 12,
	LC_CPU_FEATURE_ARM_SHA2 = 1 << 13,
	LC_CPU_FEATURE_ARM_SHA2_512 = 1 << 14,
	LC_CPU_FEATURE_ARM_SHA3 = 1 << 15,
	LC_CPU_FEATURE_ARM_PMULL = 1 << 16,

	/* RISC-V-specific */
	LC_CPU_FEATURE_RISCV = 1 << 20,
	LC_CPU_FEATURE_RISCV_ASM_ZBB = 1 << 21,
	LC_CPU_FEATURE_RISCV_ASM_RVV = 1 << 22,

	LC_CPU_FEATURE_UNSET = (1U) << 30
};

void lc_cpu_feature_set(enum lc_cpu_features feature);
void lc_cpu_feature_disable(void);
void lc_cpu_feature_enable(void);
enum lc_cpu_features lc_cpu_feature_available(void);

#ifdef __cplusplus
}
#endif

#endif /* CPUFEATURES_H */
