#!/usr/bin/python3
#
# Title:       Moderate Security Announcement for bind SUSE-SU-2020:2914-1
# Description: Security fixes for SUSE Linux Enterprise 15 SP1
# Source:      Security Announcement Parser v1.5.2
# Modified:    2020 Nov 16
#
##############################################################################
# Copyright (C) 2020 SUSE LLC
##############################################################################
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
#  Authors/Contributors:
#   Jason Record (jason.record@suse.com)
#
##############################################################################

import os
import Core
import SUSE

META_CLASS = "Security"
META_CATEGORY = "SLE"
META_COMPONENT = "bind"
PATTERN_ID = os.path.basename(__file__)
PRIMARY_LINK = "META_LINK_Security"
OVERALL = Core.TEMP
OVERALL_INFO = "NOT SET"
OTHER_LINKS = "META_LINK_Security=https://lists.suse.com/pipermail/sle-security-updates/2020-October/007552.html"
Core.init(META_CLASS, META_CATEGORY, META_COMPONENT, PATTERN_ID, PRIMARY_LINK, OVERALL, OVERALL_INFO, OTHER_LINKS)

LTSS = False
NAME = 'bind'
MAIN = ''
SEVERITY = 'Moderate'
TAG = 'SUSE-SU-2020:2914-1'
PACKAGES = {}
SERVER = SUSE.getHostInfo()

if ( SERVER['DistroVersion'] == 15):
	if ( SERVER['DistroPatchLevel'] == 1 ):
		PACKAGES = {
			'bind': '9.16.6-12.32.1',
			'bind-chrootenv': '9.16.6-12.32.1',
			'bind-debuginfo': '9.16.6-12.32.1',
			'bind-debugsource': '9.16.6-12.32.1',
			'bind-devel': '9.16.6-12.32.1',
			'bind-doc': '9.16.6-12.32.1',
			'bind-utils': '9.16.6-12.32.1',
			'bind-utils-debuginfo': '9.16.6-12.32.1',
			'libbind9-1600': '9.16.6-12.32.1',
			'libbind9-1600-debuginfo': '9.16.6-12.32.1',
			'libdns1605': '9.16.6-12.32.1',
			'libdns1605-debuginfo': '9.16.6-12.32.1',
			'libirs-devel': '9.16.6-12.32.1',
			'libirs1601': '9.16.6-12.32.1',
			'libirs1601-debuginfo': '9.16.6-12.32.1',
			'libisc1606': '9.16.6-12.32.1',
			'libisc1606-debuginfo': '9.16.6-12.32.1',
			'libisccc1600': '9.16.6-12.32.1',
			'libisccc1600-debuginfo': '9.16.6-12.32.1',
			'libisccfg1600': '9.16.6-12.32.1',
			'libisccfg1600-debuginfo': '9.16.6-12.32.1',
			'libns1604': '9.16.6-12.32.1',
			'libns1604-debuginfo': '9.16.6-12.32.1',
			'python3-bind': '9.16.6-12.32.1',
			'sysuser-shadow': '2.0-4.2.8',
			'sysuser-tools': '2.0-4.2.8',
		}
		SUSE.securityAnnouncementPackageCheck(NAME, MAIN, LTSS, SEVERITY, TAG, PACKAGES)
	else:
		Core.updateStatus(Core.ERROR, "ERROR: " + NAME + " Security Announcement: Outside the service pack scope")
else:
	Core.updateStatus(Core.ERROR, "ERROR: " + NAME + " Security Announcement: Outside the distribution scope")
Core.printPatternResults()

