/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XPath
implements Serializable {
    private Expression m_mainExp;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n) throws TransformerException {
        this(string, sourceLocator, prefixResolver, n, null);
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n, ErrorListener errorListener) throws TransformerException {
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser(errorListener, sourceLocator);
        Compiler compiler = new Compiler(errorListener, sourceLocator);
        if (n == 0) {
            xPathParser.initXPath(compiler, string, prefixResolver);
        } else if (n == 1) {
            xPathParser.initMatchPattern(compiler, string, prefixResolver);
        } else {
            throw new RuntimeException("Can not deal with XPath type: " + n);
        }
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
    }

    public void assertion(boolean bl, String string) {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void error(XPathContext xPathContext, Node node, int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (errorListener != null) {
            errorListener.fatalError(new TransformerException(string, (SAXSourceLocator)xPathContext.getSAXLocator()));
        } else {
            SourceLocator sourceLocator = xPathContext.getSAXLocator();
            System.out.println(String.valueOf(string) + "; file " + sourceLocator.getSystemId() + "; line " + sourceLocator.getLineNumber() + "; column " + sourceLocator.getColumnNumber());
        }
    }

    /*
     * Unable to fully structure code
     */
    public XObject execute(XPathContext var1_1, Node var2_2, PrefixResolver var3_3) throws TransformerException {
        var4_4 = var1_1.getNamespaceContext();
        var1_1.m_currentPrefixResolver = var3_3;
        var1_1.pushCurrentNodeAndExpression(var2_2, var2_2);
        var5_5 = null;
        try {
            block9: {
                try {
                    var5_5 = this.m_mainExp.execute(var1_1);
                    break block9;
                }
                catch (TransformerException var8_6) {
                    var8_6.setLocator(this.getLocator());
                    var9_9 = var1_1.getErrorListener();
                    if (var9_9 != null) {
                        var9_9.error(var8_6);
                        break block9;
                    }
                    throw var8_6;
                }
                catch (Exception var8_7) {
                    ** while (var8_8 instanceof WrappedRuntimeException)
                }
lbl-1000:
                // 1 sources

                {
                    var8_8 = ((WrappedRuntimeException)var8_8).getException();
                    continue;
                }
lbl20:
                // 1 sources

                var9_10 = var8_8.getMessage();
                var9_10 = var9_10 == null || var9_10.length() == 0 ? "Unknown error in XPath" : var9_10;
                var10_11 = new TransformerException(var9_10, this.getLocator(), var8_8);
                var11_12 = var1_1.getErrorListener();
                if (var11_12 != null) {
                    var11_12.fatalError(var10_11);
                } else {
                    throw var10_11;
                }
            }
            var7_13 = null;
            var1_1.m_currentPrefixResolver = var4_4;
            var1_1.popCurrentNodeAndExpression();
        }
        catch (Throwable var6_15) {
            var7_14 = null;
            var1_1.m_currentPrefixResolver = var4_4;
            var1_1.popCurrentNodeAndExpression();
            throw var6_15;
        }
        return var5_5;
    }

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp.m_slocator;
    }

    public double getMatchScore(XPathContext xPathContext, Node node) throws TransformerException {
        xPathContext.pushCurrentNode(node);
        xPathContext.pushCurrentExpressionNode(node);
        try {
            XObject xObject = this.m_mainExp.execute(xPathContext);
            double d = xObject.num();
            Object var6_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public void installFunction(String string, int n, Function function) {
        FunctionTable.installFunction(function, n);
    }

    public void setExpression(Expression expression) {
        this.m_mainExp = expression;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.m_mainExp.setSourceLocator(sourceLocator);
    }

    public void warn(XPathContext xPathContext, Node node, int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (errorListener != null) {
            errorListener.warning(new TransformerException(string, (SAXSourceLocator)xPathContext.getSAXLocator()));
        }
    }
}

