/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils.synthetic.reflection;

import java.lang.reflect.Modifier;
import org.apache.xml.utils.synthetic.Class;
import org.apache.xml.utils.synthetic.SynthesisException;
import org.apache.xml.utils.synthetic.reflection.Constructor;
import org.apache.xml.utils.synthetic.reflection.Member;
import org.apache.xml.utils.synthetic.reflection.Method;

public abstract class EntryPoint
implements Member {
    protected Object realep;
    private Class declaringclass = null;
    protected Class returntype = null;
    private String[] parameternames = new String[0];
    private Class[] parametertypes = new Class[0];
    private Class[] exceptiontypes = new Class[0];
    private int modifiers;
    protected String name = null;
    private StringBuffer body = null;
    private String language = null;
    java.lang.Class[] realE;
    java.lang.Class[] realP;

    protected EntryPoint(Object object) throws IllegalArgumentException {
        this(object, null);
    }

    protected EntryPoint(Object object, Class clazz) throws IllegalArgumentException {
        this.realep = object;
        this.declaringclass = clazz;
        if (object instanceof java.lang.reflect.Method) {
            java.lang.reflect.Method method = (java.lang.reflect.Method)object;
            if (clazz == null) {
                clazz = Class.forClass(method.getDeclaringClass());
            }
            this.name = method.getName();
            this.modifiers = method.getModifiers();
            this.returntype = Class.forClass(method.getReturnType());
            this.realP = method.getParameterTypes();
            this.realE = method.getExceptionTypes();
        } else if (object instanceof java.lang.reflect.Constructor) {
            java.lang.reflect.Constructor constructor = (java.lang.reflect.Constructor)object;
            if (clazz == null) {
                clazz = Class.forClass(constructor.getDeclaringClass());
            }
            this.name = clazz.getShortName();
            this.modifiers = constructor.getModifiers();
            this.returntype = clazz;
            this.realP = constructor.getParameterTypes();
            this.realE = constructor.getExceptionTypes();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public EntryPoint(Class clazz) {
        this.declaringclass = clazz;
    }

    public void addExceptionType(Class clazz) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        Class[] classArray = new Class[this.exceptiontypes.length + 1];
        System.arraycopy(this.exceptiontypes, 0, classArray, 0, this.exceptiontypes.length);
        classArray[this.exceptiontypes.length] = clazz;
        this.exceptiontypes = classArray;
    }

    public void addParameter(Class clazz, String string) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        Class[] classArray = new Class[this.parametertypes.length + 1];
        System.arraycopy(this.parametertypes, 0, classArray, 0, this.parametertypes.length);
        classArray[this.parametertypes.length] = clazz;
        this.parametertypes = classArray;
        String[] stringArray = new String[this.parameternames.length + 1];
        System.arraycopy(this.parameternames, 0, stringArray, 0, this.parameternames.length);
        stringArray[this.parameternames.length] = string;
        this.parameternames = stringArray;
    }

    public boolean equals(Object object) {
        EntryPoint entryPoint = null;
        if (object instanceof EntryPoint) {
            entryPoint = (EntryPoint)object;
        } else if (object instanceof java.lang.reflect.Constructor || object instanceof java.lang.reflect.Method) {
            entryPoint = (EntryPoint)object;
        }
        return entryPoint != null && (this instanceof Constructor && entryPoint instanceof Constructor || this instanceof Method && entryPoint instanceof Method && this.getName().equals(entryPoint.getName())) && entryPoint.getDeclaringClass().equals(this.declaringclass) && entryPoint.getParameterTypes().equals(this.parametertypes);
    }

    public StringBuffer getBody() {
        if (this.body == null) {
            this.body = new StringBuffer();
        }
        return this.body;
    }

    public Class getDeclaringClass() {
        return this.declaringclass;
    }

    public Class[] getExceptionTypes() {
        if (this.realep != null && this.exceptiontypes == null) {
            this.exceptiontypes = new Class[this.realE.length];
            int n = 0;
            while (n < this.realE.length) {
                this.exceptiontypes[n] = Class.forClass(this.realE[n]);
                ++n;
            }
            this.realE = null;
        }
        return this.exceptiontypes;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        if (this instanceof Constructor) {
            return this.declaringclass.getShortName();
        }
        return this.name;
    }

    public String[] getParameterNames() {
        return this.parameternames;
    }

    public Class[] getParameterTypes() {
        if (this.realep != null && this.parametertypes == null) {
            this.parametertypes = new Class[this.realP.length];
            int n = 0;
            while (n < this.realP.length) {
                this.parametertypes[n] = Class.forClass(this.realP[n]);
                ++n;
            }
            this.realP = null;
        }
        return this.parametertypes;
    }

    public Class getReturnType() {
        return this.returntype;
    }

    public abstract int hashCode();

    public void setBody(String string, StringBuffer stringBuffer) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.language = string;
        this.body = stringBuffer;
    }

    public void setDeclaringClass(Class clazz) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.declaringclass = clazz;
    }

    public void setModifiers(int n) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.modifiers = n;
    }

    public void setName(String string) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.name = string;
    }

    public String toSource(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(Modifier.toString(this.getModifiers()));
        if (this instanceof Method) {
            if (this.returntype != null) {
                stringBuffer.append(" ").append(this.getReturnType().getJavaName());
            } else {
                stringBuffer.append(" void");
            }
        }
        stringBuffer.append(" ").append(this.getName()).append("(");
        Class[] classArray = this.getParameterTypes();
        if (classArray != null & classArray.length > 0) {
            stringBuffer.append(classArray[0].getJavaName());
            if (this.parameternames != null) {
                stringBuffer.append(' ').append(this.parameternames[0]);
            }
            n = 1;
            while (n < classArray.length) {
                stringBuffer.append(',').append(classArray[n].getJavaName());
                if (this.parameternames != null) {
                    stringBuffer.append(' ').append(this.parameternames[n]);
                }
                ++n;
            }
        }
        stringBuffer.append(')');
        classArray = this.getExceptionTypes();
        if (classArray != null & classArray.length > 0) {
            stringBuffer.append(" throws ").append(classArray[0].getJavaName());
            n = 1;
            while (n < classArray.length) {
                stringBuffer.append(',').append(classArray[n].getJavaName());
                ++n;
            }
        }
        if (this.body == null) {
            stringBuffer.append("; // No method body available\n");
        } else {
            stringBuffer.append("\n" + string + "{\n");
            if (this.language == null || "java".equals(this.language)) {
                stringBuffer.append(String.valueOf(string) + "// ***** Should prettyprint this code...\n");
                stringBuffer.append(String.valueOf(string) + this.body + "\n");
            } else {
                stringBuffer.append(String.valueOf(string) + "// ***** Generate BSF invocation!?\n");
            }
            stringBuffer.append(String.valueOf(string) + "}\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(Modifier.toString(this.getModifiers()));
        if (this instanceof Method) {
            stringBuffer.append(' ').append(this.getReturnType()).append(this.getDeclaringClass().getName()).append('.').append(this.getName());
        } else {
            stringBuffer.append(this.getDeclaringClass().getName());
        }
        stringBuffer.append('(');
        Class[] classArray = this.getParameterTypes();
        if (classArray != null && classArray.length > 0) {
            stringBuffer.append(classArray[0].getName());
            n = 1;
            while (n < classArray.length) {
                stringBuffer.append(',').append(classArray[n].getName());
                ++n;
            }
        }
        stringBuffer.append(')');
        if (this instanceof Method && (classArray = this.getExceptionTypes()) != null && classArray.length > 0) {
            stringBuffer.append(" throws ").append(classArray[0].getName());
            n = 1;
            while (n < classArray.length) {
                stringBuffer.append(',').append(classArray[n].getName());
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

