/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.DefaultConnectionPool;
import org.apache.xalan.lib.sql.ExtensionError;
import org.apache.xalan.lib.sql.QueryParameter;
import org.apache.xalan.lib.sql.SQLExtensionError;
import org.apache.xalan.lib.sql.XConnectionPoolManager;
import org.apache.xalan.lib.sql.XStatement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XConnection {
    private static final boolean DEBUG = false;
    public Connection m_connection = null;
    private ConnectionPool m_ConnectionPool = null;
    private String m_ConnectionPoolName;
    private boolean m_IsDefaultPool = false;
    private boolean m_DefaultPoolingEnabled = false;
    private XConnectionPoolManager m_PoolMgr = new XConnectionPoolManager();
    private Vector m_ParameterList = new Vector();
    private boolean m_ShouldCacheNodes = true;

    public XConnection(String string) {
        this.connect(string);
    }

    public XConnection(String string, String string2) {
        this.connect(string, string2);
    }

    public XConnection(String string, String string2, String string3, String string4) {
        this.connect(string, string2, string3, string4);
    }

    public XConnection(String string, String string2, Element element) {
        this.connect(string, string2, element);
    }

    public XConnection(NodeList nodeList) {
        this.connect(nodeList);
    }

    public void addParameter(String string) {
        this.addParameterWithType(string, null);
    }

    public void addParameterFromElement(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("type");
        Node node2 = element.getFirstChild();
        if (node2 != null) {
            String string = node2.getNodeValue();
            if (string == null) {
                string = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(string, node.getNodeValue()));
        }
    }

    public void addParameterFromElement(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.addParameters((Element)nodeList.item(n2));
            ++n2;
        }
    }

    public void addParameterWithType(String string, String string2) {
        this.m_ParameterList.addElement(new QueryParameter(string, string2));
    }

    private void addParameters(Element element) {
        Node node = element.getFirstChild();
        if (node == null) {
            return;
        }
        do {
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("type");
            String string = node2 == null ? "string" : node2.getNodeValue();
            Node node3 = node.getFirstChild();
            if (node3 == null) continue;
            String string2 = node3.getNodeValue();
            if (string2 == null) {
                string2 = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(string2, string));
        } while ((node = node.getNextSibling()) != null);
    }

    public void clearParameters() {
        this.m_ParameterList.removeAllElements();
    }

    public void close() throws SQLException {
        if (this.m_connection != null) {
            if (this.m_ConnectionPool != null) {
                this.m_ConnectionPool.releaseConnection(this.m_connection);
            } else {
                this.m_connection.close();
            }
        }
        this.m_connection = null;
    }

    public NodeIterator connect(String string) {
        try {
            if (this.m_ConnectionPool != null && this.m_IsDefaultPool) {
                this.m_PoolMgr.removePool(this.m_ConnectionPoolName);
            }
            this.m_ConnectionPool = this.m_PoolMgr.getPool(string);
            this.m_ConnectionPoolName = string;
            this.m_connection = this.m_ConnectionPool.getConnection();
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        return null;
    }

    public NodeIterator connect(String string, String string2) {
        try {
            this.init(string, string2, new Properties());
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
        return null;
    }

    public NodeIterator connect(String string, String string2, String string3, String string4) {
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", string3);
            ((Hashtable)properties).put("password", string4);
            this.init(string, string2, properties);
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
        return null;
    }

    public NodeIterator connect(String string, String string2, Element element) {
        try {
            Properties properties = new Properties();
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                ((Hashtable)properties).put(namedNodeMap.item(n).getNodeName(), namedNodeMap.item(n).getNodeValue());
                ++n;
            }
            this.init(string, string2, properties);
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
        return null;
    }

    public NodeIterator connect(Element element) {
        try {
            this.initFromElement(element);
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
        return null;
    }

    public NodeIterator connect(NodeList nodeList) {
        try {
            this.initFromElement((Element)nodeList.item(0));
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
        return null;
    }

    public void disableCacheNodes() {
        this.m_ShouldCacheNodes = false;
    }

    public void disableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = false;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (!this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.disablePool();
    }

    public void enableCacheNodes() {
        this.m_ShouldCacheNodes = true;
    }

    public void enableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = true;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (!this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.enablePool();
    }

    protected void finalize() {
    }

    private void init(String string, String string2, Properties properties) throws SQLException {
        String string3;
        String string4 = properties.getProperty("user");
        if (string4 == null) {
            string4 = "";
        }
        if ((string3 = properties.getProperty("password")) == null) {
            string3 = "";
        }
        String string5 = String.valueOf(string) + string2 + string4 + string3;
        ConnectionPool connectionPool = this.m_PoolMgr.getPool(string5);
        if (this.m_ConnectionPool != null && this.m_IsDefaultPool && connectionPool != this.m_ConnectionPool) {
            this.m_PoolMgr.removePool(this.m_ConnectionPoolName);
        }
        if (connectionPool == null) {
            DefaultConnectionPool defaultConnectionPool = new DefaultConnectionPool();
            defaultConnectionPool.setDriver(string);
            defaultConnectionPool.setURL(string2);
            defaultConnectionPool.setProtocol(properties);
            if (this.m_DefaultPoolingEnabled) {
                defaultConnectionPool.enablePool();
            }
            this.m_PoolMgr.registerPool(string5, defaultConnectionPool);
            this.m_ConnectionPool = defaultConnectionPool;
            this.m_ConnectionPoolName = string5;
        } else {
            this.m_ConnectionPool = connectionPool;
            this.m_ConnectionPoolName = string5;
        }
        this.m_ConnectionPool.testConnection();
        this.m_connection = this.m_ConnectionPool.getConnection();
    }

    private void initFromElement(Element element) throws SQLException {
        Properties properties = new Properties();
        String string = "";
        String string2 = "";
        Node node = element.getFirstChild();
        if (node == null) {
            return;
        }
        do {
            Object object;
            Object object2;
            String string3;
            if ((string3 = node.getNodeName()).equalsIgnoreCase("dbdriver")) {
                string = "";
                object2 = node.getFirstChild();
                if (object2 != null) {
                    string = object2.getNodeValue();
                }
            }
            if (string3.equalsIgnoreCase("dburl")) {
                string2 = "";
                object2 = node.getFirstChild();
                if (object2 != null) {
                    string2 = object2.getNodeValue();
                }
            }
            if (string3.equalsIgnoreCase("password")) {
                object2 = "";
                object = node.getFirstChild();
                if (object != null) {
                    object2 = object.getNodeValue();
                }
                ((Hashtable)properties).put("password", object2);
            }
            if (string3.equalsIgnoreCase("user")) {
                object2 = "";
                object = node.getFirstChild();
                if (object != null) {
                    object2 = object.getNodeValue();
                }
                ((Hashtable)properties).put("user", object2);
            }
            if (!string3.equalsIgnoreCase("protocol")) continue;
            object2 = "";
            object = node.getAttributes();
            Node node2 = object.getNamedItem("name");
            if (node2 == null) continue;
            String string4 = "";
            object2 = node2.getNodeValue();
            Node node3 = node.getFirstChild();
            if (node3 != null) {
                string4 = node3.getNodeValue();
            }
            ((Hashtable)properties).put(object2, string4);
        } while ((node = node.getNextSibling()) != null);
        this.init(string, string2, properties);
    }

    public NodeIterator pquery(String string) {
        try {
            return new XStatement(this, string, this.m_ParameterList, this.m_ShouldCacheNodes);
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
    }

    public NodeIterator pquery(String string, String string2) {
        try {
            int n = 0;
            QueryParameter queryParameter = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                queryParameter = (QueryParameter)this.m_ParameterList.elementAt(n);
                if (queryParameter == null) continue;
                queryParameter.setType(string3);
            }
            return new XStatement(this, string, this.m_ParameterList, this.m_ShouldCacheNodes);
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
    }

    public NodeIterator query(String string) {
        try {
            return new XStatement(this, string, this.m_ShouldCacheNodes);
        }
        catch (SQLException sQLException) {
            SQLExtensionError sQLExtensionError = new SQLExtensionError(sQLException);
            return sQLExtensionError;
        }
        catch (Exception exception) {
            ExtensionError extensionError = new ExtensionError(exception);
            return extensionError;
        }
    }
}

