# -*- coding: utf-8 -*-
#
# Copyright 2018 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generated by synthtool. DO NOT EDIT!

import os
import sys

import nox


HERE = os.path.dirname(__file__)

@nox.session(python=["3.9", "3.10", "3.11", "3.12", "3.13", "3.14"])
def build_libcrc32c(session):
    session.env["PY_BIN"] = f"python{session.python}"
    session.env["REPO_ROOT"] = HERE

    if sys.platform.startswith("win"):
        session.run("cmd", "-c", "scripts\\windows\\build.bat")
    elif sys.platform == "linux":
        session.run("bash", "scripts/local-linux/build_libcrc32c.sh")
    elif sys.platform == "darwin":
        session.run("bash", "scripts/osx/build.sh")
    else:
        raise Exception("Unsupported")


@nox.session(python=["3.9", "3.10", "3.11", "3.12", "3.13", "3.14"])
def check(session):
    session.install("pytest")
    session.install("--no-index", f"--find-links={HERE}/wheels", "google-crc32c")

    # Run py.test against the unit tests.
    session.run("py.test", "tests")
    session.run("python", f"{HERE}/scripts/check_crc32c_extension.py", *session.posargs)


@nox.session(python="3.13")
def mypy(session):
    """Verify type hints are mypy compatible."""
    session.install(
        "mypy",
        "types-mock",
        "types-setuptools",
    )
    session.env["MYPYPATH"] = "src"
    session.run("mypy", "src/google_crc32c/", "tests/")