sys.version_info(major=3, minor=9, micro=16, releaselevel='final', serial=0)

### Timing comparison of `int` functions

| Input type        | builtin (ms)       | fastnumbers (ms)   |
| ----------------: | -----------------: | -----------------: |
|  Small Int String |   14.997 ± 0.434   | **14.018 ± 2.790** |
|        Int String |   23.327 ± 7.867   | **13.616 ± 0.262** |
| Medium Int String |   17.902 ± 0.398   | **14.068 ± 0.825** |
|  Large Int String | **24.640 ± 2.254** |   25.575 ± 1.652   |
|               Int |  **8.333 ± 1.625** |    9.363 ± 0.175   |
|             Float | **19.303 ± 2.990** |   22.910 ± 1.930   |

### Timing comparison of `float` functions

| Input type         | builtin (ms)       | fastnumbers (ms)   |
| -----------------: | -----------------: | -----------------: |
|   Small Int String |   14.326 ± 2.367   | **13.208 ± 0.423** |
|         Int String |   14.852 ± 1.044   | **14.455 ± 2.289** |
|  Medium Int String |   16.340 ± 1.965   | **14.287 ± 1.063** |
|   Large Int String |   38.373 ± 2.658   | **19.939 ± 0.690** |
| Small Float String | **14.539 ± 1.334** |   15.580 ± 3.611   |
|       Float String |   35.869 ± 4.851   | **15.618 ± 0.280** |
| Large Float String |   56.531 ± 3.044   | **15.768 ± 0.032** |
|                Int |  **8.973 ± 0.583** |   11.129 ± 0.696   |
|              Float |  **8.123 ± 4.439** |    9.971 ± 0.492   |

### Timing comparison of `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)     | fastnumbers (ms)   |
| -----------------: | -----------------: | -------------: | -----------------: |
|  Non-number String |  135.188 ± 1.080   | 27.664 ± 0.038 | **22.554 ± 0.061** |
|   Small Int String | **22.869 ± 0.386** | 45.568 ± 0.043 |   23.109 ± 1.645   |
|         Int String |   25.552 ± 2.800   | 50.471 ± 0.322 | **24.084 ± 0.014** |
|  Medium Int String | **25.681 ± 0.290** | 58.940 ± 0.387 |   26.209 ± 0.081   |
|   Large Int String | **31.870 ± 0.385** | 79.735 ± 0.296 |   35.253 ± 0.028   |
| Small Float String |  129.276 ± 1.550   | 31.566 ± 0.204 | **22.605 ± 0.036** |
|       Float String |  134.571 ± 0.506   | 37.984 ± 0.021 | **22.955 ± 0.024** |
| Large Float String |  142.807 ± 1.673   | 38.035 ± 0.134 | **23.006 ± 0.021** |
|                Int | **14.107 ± 0.130** | 71.135 ± 1.558 |   19.149 ± 0.004   |
|              Float | **26.562 ± 0.228** | 83.172 ± 3.429 |   32.680 ± 0.020   |

### Timing comparison of `float` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |   74.710 ± 1.160   |  34.759 ± 0.076 | **24.943 ± 0.132** |
|   Small Int String | **22.437 ± 1.125** |  61.343 ± 0.345 |   24.479 ± 0.057   |
|         Int String | **23.412 ± 0.878** |  64.373 ± 0.912 |   24.805 ± 0.043   |
|  Medium Int String | **22.294 ± 0.788** |  73.289 ± 1.202 |   25.609 ± 0.178   |
|   Large Int String |   44.904 ± 1.067   | 109.586 ± 0.671 | **29.928 ± 0.034** |
| Small Float String | **21.213 ± 0.819** |  59.789 ± 0.232 |   25.000 ± 0.136   |
|       Float String |   40.613 ± 0.968   |  94.837 ± 0.219 | **27.487 ± 1.760** |
| Large Float String |   62.987 ± 0.666   | 124.797 ± 0.285 | **26.953 ± 0.025** |
|                Int | **15.153 ± 0.003** |  78.140 ± 0.627 |   22.203 ± 0.059   |
|              Float | **14.918 ± 0.460** |  74.202 ± 0.294 |   20.739 ± 0.043   |

### Timing comparison of `float` (but coerce to `int` if possible) functions with error handling

| Input type         | try/except (ms) | regex (ms)       | fastnumbers (ms)   |
| -----------------: | --------------: | ---------------: | -----------------: |
|  Non-number String |  74.253 ± 1.112 |  59.159 ± 0.388  | **25.424 ± 0.024** |
|   Small Int String |  35.815 ± 0.341 |  53.409 ± 10.710 | **24.777 ± 1.247** |
|         Int String |  40.447 ± 0.064 |  53.884 ± 0.707  | **26.213 ± 0.198** |
|  Medium Int String |  43.105 ± 0.299 |  61.849 ± 0.265  | **26.523 ± 0.070** |
|   Large Int String |  80.090 ± 3.192 |  82.827 ± 0.204  | **37.790 ± 0.253** |
| Small Float String |  36.760 ± 0.894 |  85.120 ± 0.619  | **26.820 ± 0.131** |
|       Float String |  75.596 ± 0.701 | 124.704 ± 0.259  | **34.749 ± 0.084** |
| Large Float String | 130.958 ± 0.822 | 154.539 ± 0.588  | **50.478 ± 0.205** |
|                Int |  32.430 ± 0.086 |  76.971 ± 1.314  | **21.101 ± 0.095** |
|              Float |  54.644 ± 3.767 |  75.466 ± 0.682  | **33.594 ± 0.060** |

### Timing comparison of forced `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  205.174 ± 2.702   |  59.974 ± 0.942 | **26.201 ± 0.430** |
|   Small Int String | **25.146 ± 0.048** |  52.203 ± 0.079 |   25.731 ± 0.064   |
|         Int String | **27.995 ± 3.330** |  59.969 ± 0.830 |   29.174 ± 0.092   |
|  Medium Int String |   29.871 ± 0.559   | 116.564 ± 1.557 | **28.495 ± 0.059** |
|   Large Int String | **34.623 ± 0.605** | 164.539 ± 0.814 |   44.977 ± 5.870   |
| Small Float String |  174.006 ± 0.952   | 104.031 ± 0.909 | **28.136 ± 0.018** |
|       Float String |  214.486 ± 1.186   | 159.277 ± 2.497 | **36.639 ± 0.659** |
| Large Float String |  274.092 ± 15.225  | 214.138 ± 3.989 | **55.283 ± 1.041** |
|                Int | **17.252 ± 1.366** |  79.299 ± 1.623 |   21.354 ± 0.122   |
|              Float | **28.138 ± 0.778** |  91.926 ± 1.646 |   35.835 ± 0.555   |

### Timing comparison of forced `int` functions with error handling and denoising

| Input type         | Python (ms)        | fastnumbers (ms)    |
| -----------------: | -----------------: | ------------------: |
|   Small Int String |  139.155 ± 2.891   |  **42.096 ± 0.895** |
|         Int String |  141.688 ± 3.845   |  **43.934 ± 0.110** |
|  Medium Int String |  151.455 ± 7.514   |  **47.526 ± 0.937** |
|   Large Int String |  175.798 ± 4.186   |  **55.993 ± 0.167** |
| Small Float String |  218.123 ± 4.170   |  **43.292 ± 0.012** |
|       Float String |  243.042 ± 1.174   | **105.386 ± 2.502** |
| Large Float String |  708.739 ± 15.768  | **167.589 ± 1.997** |
|                Int | **20.989 ± 0.017** |    34.775 ± 0.017   |
|              Float | **51.168 ± 0.327** |   211.781 ± 10.027  |

### Timing comparison to check if value can be converted to `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String | 162.500 ± 0.821 | 57.524 ± 0.579  | **13.200 ± 0.072** |
|   Small Int String |  33.044 ± 0.659 | 58.430 ± 0.208  | **13.127 ± 0.010** |
|         Int String |  34.497 ± 0.446 | 62.851 ± 0.536  | **13.696 ± 0.218** |
|  Medium Int String |  36.946 ± 0.507 | 71.509 ± 0.918  | **13.851 ± 0.303** |
|   Large Int String |  44.025 ± 0.839 | 91.023 ± 1.234  | **14.071 ± 0.012** |
| Small Float String | 149.048 ± 2.551 | 67.669 ± 17.644 | **14.341 ± 0.006** |
|       Float String | 152.656 ± 0.528 | 67.468 ± 0.081  | **15.579 ± 0.007** |
| Large Float String | 159.648 ± 2.064 | 67.402 ± 0.060  | **15.758 ± 0.313** |
|                Int |  25.753 ± 0.673 | 23.614 ± 0.004  | **10.742 ± 0.079** |
|              Float |  35.217 ± 0.038 | 21.387 ± 0.306  | **11.540 ± 0.009** |

### Timing comparison to check if value can be converted to `float`

| Input type         | try/except (ms) | regex (ms)     | fastnumbers (ms)   |
| -----------------: | --------------: | -------------: | -----------------: |
|  Non-number String | 87.321 ± 2.868  | 62.996 ± 0.336 | **14.846 ± 0.210** |
|   Small Int String | 32.417 ± 0.414  | 70.644 ± 1.597 | **14.537 ± 0.017** |
|         Int String | 40.054 ± 10.624 | 76.115 ± 4.201 | **14.928 ± 0.136** |
|  Medium Int String | 36.179 ± 0.918  | 84.745 ± 0.449 | **15.198 ± 0.137** |
|   Large Int String | 60.911 ± 1.412  | 99.820 ± 1.930 | **15.142 ± 0.143** |
| Small Float String | 32.841 ± 0.914  | 67.629 ± 0.009 | **15.445 ± 0.007** |
|       Float String | 55.696 ± 0.476  | 85.962 ± 0.192 | **16.495 ± 0.248** |
| Large Float String | 79.934 ± 0.996  | 93.587 ± 0.189 | **16.298 ± 0.132** |
|                Int | 24.863 ± 0.576  | 23.510 ± 0.004 | **12.225 ± 0.211** |
|              Float | 23.384 ± 0.034  | 22.305 ± 0.012 | **12.422 ± 0.220** |

### Timing comparison to check if value can be converted to `float` or `int`

| Input type         | try/except (ms) | regex (ms)     | fastnumbers (ms)   |
| -----------------: | --------------: | -------------: | -----------------: |
|  Non-number String |  85.659 ± 1.103 | 63.752 ± 2.247 | **15.080 ± 0.394** |
|   Small Int String |  29.747 ± 3.240 | 74.806 ± 2.443 | **14.324 ± 0.208** |
|         Int String |  28.252 ± 0.750 | 75.374 ± 3.088 | **15.513 ± 0.270** |
|  Medium Int String |  32.280 ± 1.265 | 89.925 ± 1.655 | **15.933 ± 0.595** |
|   Large Int String |  56.354 ± 1.231 | 97.999 ± 2.261 | **14.459 ± 0.010** |
| Small Float String |  25.361 ± 1.221 | 69.460 ± 0.793 | **15.189 ± 0.007** |
|       Float String |  47.095 ± 1.031 | 85.079 ± 0.238 | **16.165 ± 0.275** |
| Large Float String |  69.972 ± 0.692 | 96.825 ± 7.692 | **16.563 ± 0.009** |
|                Int |  19.474 ± 1.661 | 22.666 ± 0.006 | **12.168 ± 0.015** |
|              Float |  16.010 ± 0.036 | 20.284 ± 0.349 | **11.919 ± 0.006** |

### Timing comparison to check if value can be coerced losslessly to `int`

| Input type         | try/except (ms) | regex (ms)       | fastnumbers (ms)   |
| -----------------: | --------------: | ---------------: | -----------------: |
|  Non-number String | 239.708 ± 4.075 |  57.467 ± 0.773  | **13.042 ± 0.118** |
|   Small Int String |  47.358 ± 0.232 |  37.252 ± 0.034  | **12.965 ± 0.008** |
|         Int String |  55.595 ± 0.899 |  44.371 ± 0.778  | **14.021 ± 0.532** |
|  Medium Int String |  59.703 ± 0.556 |  50.370 ± 1.636  | **13.294 ± 0.024** |
|   Large Int String |  98.855 ± 1.340 |  63.297 ± 0.862  | **12.973 ± 0.024** |
| Small Float String | 174.138 ± 2.861 |  95.834 ± 1.925  | **13.682 ± 0.014** |
|       Float String | 202.825 ± 8.634 | 146.522 ± 2.990  | **15.325 ± 0.058** |
| Large Float String | 234.110 ± 3.789 | 174.578 ± 3.566  | **15.499 ± 0.129** |
|                Int |  37.158 ± 4.050 |  96.383 ± 18.034 | **13.116 ± 0.276** |
|              Float |  65.431 ± 1.585 | 120.151 ± 2.707  | **11.280 ± 0.003** |

### Timing comparison of `map` option vs. iterating over `try_float` for a 50 element list

| Input type         | [try_float(x) for x in iterable] (ms) | list(map(try_float, iterable)) (ms) | list(try_float(iterable, map=True)) (ms) | try_float(iterable, map=list) (ms) |
| -----------------: | ------------------------------------: | ----------------------------------: | ---------------------------------------: | ---------------------------------: |
|  Non-number String |                   1544.535 ± 33.270   |                  1718.628 ± 336.746 |                        709.207 ± 74.856  |              **588.775 ± 74.396**  |
|   Small Int String |                   1864.281 ± 260.557  |                  1391.718 ± 22.098  |                        569.029 ± 12.391  |              **551.698 ± 20.607**  |
|         Int String |                   2006.434 ± 628.710  |                  1429.793 ± 72.702  |                        858.732 ± 199.618 |              **750.096 ± 130.048** |
|  Medium Int String |                   1604.968 ± 14.954   |                  1741.884 ± 408.565 |                        952.376 ± 312.120 |              **660.700 ± 133.739** |
|   Large Int String |                   2634.942 ± 1011.794 |                  2769.373 ± 610.573 |                       1496.633 ± 337.482 |             **1185.537 ± 157.885** |
| Small Float String |                   2075.113 ± 161.513  |                  1800.332 ± 251.616 |                        692.011 ± 78.144  |              **538.998 ± 31.837**  |
|       Float String |                   2065.716 ± 367.832  |                  1735.385 ± 113.789 |                        731.085 ± 78.617  |              **702.787 ± 149.784** |
| Large Float String |                   1943.154 ± 105.208  |                  1725.349 ± 277.956 |                        686.610 ± 22.227  |              **598.690 ± 17.655**  |
|                Int |                   1262.734 ± 43.827   |                  1144.253 ± 9.204   |                        409.536 ± 0.862   |              **351.136 ± 2.926**   |
|              Float |                   1200.244 ± 57.008   |                  1080.316 ± 8.646   |                        356.837 ± 1.087   |              **311.554 ± 11.670**  |

### Timing comparison of `try_array` vs. `map` option for a 50 element list to a numpy array

| Input type         | np.array(try_float(iterable, map=True)) (ms) | try_array(iterable) (ms) | try_array(iterable, output) (ms) |
| -----------------: | -------------------------------------------: | -----------------------: | -------------------------------: |
|   Small Int String |                            739.682 ± 137.044 |       390.639 ± 43.090   |            **358.663 ± 24.093**  |
|         Int String |                            743.279 ± 10.494  |       370.635 ± 10.382   |            **350.745 ± 3.081**   |
|  Medium Int String |                            772.731 ± 22.109  |       382.183 ± 5.391    |            **362.129 ± 4.341**   |
|   Large Int String |                           1008.874 ± 15.525  |       632.274 ± 18.978   |            **605.948 ± 3.563**   |
| Small Float String |                            770.579 ± 28.231  |       368.148 ± 1.745    |            **350.156 ± 7.886**   |
|       Float String |                            833.215 ± 23.822  |       628.725 ± 140.157  |            **586.456 ± 115.026** |
| Large Float String |                            860.126 ± 22.166  |       684.593 ± 80.410   |            **511.977 ± 94.349**  |
|                Int |                            633.647 ± 2.328   |     **443.879 ± 24.318** |              651.288 ± 124.036   |
|              Float |                            841.120 ± 273.540 |     **331.534 ± 6.559**  |              515.037 ± 62.076    |

