"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Test {
    constructor(name, line, values, meta) {
        this.name = name;
        this.line = line;
        this.values = values;
        this.meta = meta;
    }
    toJSON() {
        const values = {};
        this.values.forEach((value, key) => {
            values[key] = value;
        });
        const meta = {};
        this.meta.forEach((mvalue, key) => {
            meta[key] = mvalue;
        });
        return {
            line: this.line,
            meta,
            name: this.name,
            values,
        };
    }
}
exports.Test = Test;
//# sourceMappingURL=test.js.map