import * as frontend from 'llparse-frontend';
import { Compilation } from '../compilation';
export interface INodeEdge {
    readonly node: frontend.IWrap<frontend.node.Node>;
    readonly noAdvance: boolean;
    readonly value?: number;
}
export declare abstract class Node<T extends frontend.node.Node> {
    readonly ref: T;
    protected cachedDecl: string | undefined;
    protected privCompilation: Compilation | undefined;
    constructor(ref: T);
    build(compilation: Compilation): string;
    protected get compilation(): Compilation;
    protected prologue(out: string[]): void;
    protected pause(out: string[]): void;
    protected tailTo(out: string[], edge: INodeEdge): void;
    protected abstract doBuild(out: string[]): void;
}
