"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Compiler = void 0;
const debugAPI = require("debug");
const frontend = require("llparse-frontend");
const cImpl = require("../implementation/c");
const header_builder_1 = require("./header-builder");
const debug = debugAPI('llparse:compiler');
class Compiler {
    prefix;
    options;
    constructor(prefix, options) {
        this.prefix = prefix;
        this.options = options;
    }
    compile(root, properties) {
        debug('Combining implementations');
        const container = new frontend.Container();
        const c = new cImpl.CCompiler(container, Object.assign({
            debug: this.options.debug,
        }, this.options.c));
        debug('Running frontend pass');
        const f = new frontend.Frontend(this.prefix, container.build(), this.options.frontend);
        const info = f.compile(root, properties);
        debug('Building header');
        const hb = new header_builder_1.HeaderBuilder();
        const header = hb.build({
            headerGuard: this.options.headerGuard,
            prefix: this.prefix,
            properties,
            spans: info.spans,
        });
        debug('Building C');
        return {
            header,
            c: c.compile(info),
        };
    }
}
exports.Compiler = Compiler;
//# sourceMappingURL=index.js.map