import * as frontend from 'llparse-frontend';
import source = frontend.source;
import { ICompilerOptions, ICompilerResult } from './compiler';
export { source, ICompilerOptions, ICompilerResult };
/**
 * LLParse graph builder and compiler.
 */
export declare class LLParse extends source.Builder {
    private readonly prefix;
    /**
     * The prefix controls the names of methods and state struct in generated
     * public C headers:
     *
     * ```c
     * // state struct
     * struct PREFIX_t {
     *   ...
     * }
     *
     * int PREFIX_init(PREFIX_t* state);
     * int PREFIX_execute(PREFIX_t* state, const char* p, const char* endp);
     * ```
     *
     * @param prefix  Prefix to be used when generating public API.
     */
    constructor(prefix?: string);
    /**
     * Compile LLParse graph to the C code and C headers
     *
     * @param root  Root node of the parse graph (see `.node()`)
     * @param options Compiler options.
     */
    build(root: source.node.Node, options?: ICompilerOptions): ICompilerResult;
}
