"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toCacheKey = exports.Identifier = void 0;
var identifier_1 = require("./identifier");
Object.defineProperty(exports, "Identifier", { enumerable: true, get: function () { return identifier_1.Identifier; } });
function toCacheKey(value) {
    if (typeof value === 'number') {
        if (value < 0) {
            return 'm' + (-value);
        }
        else {
            return value.toString();
        }
    }
    else if (typeof value === 'boolean') {
        if (value === true) {
            return 'true';
        }
        else {
            return 'false';
        }
    }
    else {
        throw new Error(`Unsupported value: "${value}"`);
    }
}
exports.toCacheKey = toCacheKey;
//# sourceMappingURL=index.js.map