"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MulAdd = void 0;
const utils_1 = require("../utils");
const field_1 = require("./field");
function toOptionsKey(options) {
    let res = `base_${utils_1.toCacheKey(options.base)}`;
    if (options.max !== undefined) {
        res += `_max_${utils_1.toCacheKey(options.max)}`;
    }
    if (options.signed !== undefined) {
        res += `_signed_${utils_1.toCacheKey(options.signed)}`;
    }
    return res;
}
class MulAdd extends field_1.Field {
    constructor(name, field, options) {
        super('value', `mul_add_${field}_${toOptionsKey(options)}`, name, field);
        this.options = options;
    }
}
exports.MulAdd = MulAdd;
//# sourceMappingURL=mul-add.js.map