export declare type Signature = 'match' | 'value';
/**
 * Base code class.
 */
export declare abstract class Code {
    readonly signature: Signature;
    readonly name: string;
    /**
     * @param signature  Code signature to be used. `match` means that code takes
     *                   no input value (from `.select()`), otherwise it must be
     *                   `value`
     * @param name       External function or intrinsic name.
     */
    constructor(signature: Signature, name: string);
}
