import constants from './llhttp/constants';
import { HTTP } from './llhttp/http';
import { URL } from './llhttp/url';
import { CHeaders } from './llhttp/c-headers';
export { constants, HTTP, URL, CHeaders, };
declare const _default: {
    constants: {
        ERROR: import("./llhttp/constants").IntDict;
        TYPE: import("./llhttp/constants").IntDict;
        FLAGS: import("./llhttp/constants").IntDict;
        LENIENT_FLAGS: import("./llhttp/constants").IntDict;
        METHODS: import("./llhttp/constants").IntDict;
        STATUSES: import("./llhttp/constants").IntDict;
        FINISH: import("./llhttp/constants").IntDict;
        HEADER_STATE: import("./llhttp/constants").IntDict;
        ALPHA: import("./llhttp/constants").CharList;
        NUM_MAP: {
            0: number;
            1: number;
            2: number;
            3: number;
            4: number;
            5: number;
            6: number;
            7: number;
            8: number;
            9: number;
        };
        HEX_MAP: {
            0: number;
            1: number;
            2: number;
            3: number;
            4: number;
            5: number;
            6: number;
            7: number;
            8: number;
            9: number;
            A: number;
            B: number;
            C: number;
            D: number;
            E: number;
            F: number;
            a: number;
            b: number;
            c: number;
            d: number;
            e: number;
            f: number;
        };
        NUM: import("./llhttp/constants").CharList;
        ALPHANUM: import("./llhttp/constants").CharList;
        MARK: import("./llhttp/constants").CharList;
        USERINFO_CHARS: import("./llhttp/constants").CharList;
        URL_CHAR: import("./llhttp/constants").CharList;
        HEX: import("./llhttp/constants").CharList;
        TOKEN: import("./llhttp/constants").CharList;
        HEADER_CHARS: import("./llhttp/constants").CharList;
        CONNECTION_TOKEN_CHARS: import("./llhttp/constants").CharList;
        QUOTED_STRING: import("./llhttp/constants").CharList;
        HTAB_SP_VCHAR_OBS_TEXT: import("./llhttp/constants").CharList;
        MAJOR: {
            0: number;
            1: number;
            2: number;
            3: number;
            4: number;
            5: number;
            6: number;
            7: number;
            8: number;
            9: number;
        };
        MINOR: {
            0: number;
            1: number;
            2: number;
            3: number;
            4: number;
            5: number;
            6: number;
            7: number;
            8: number;
            9: number;
        };
        SPECIAL_HEADERS: {
            connection: number;
            'content-length': number;
            'proxy-connection': number;
            'transfer-encoding': number;
            upgrade: number;
        };
        METHODS_HTTP: number[];
        METHODS_ICE: number[];
        METHODS_RTSP: number[];
        METHOD_MAP: import("./llhttp/constants").IntDict;
        H_METHOD_MAP: {
            [k: string]: number;
        };
        STATUSES_HTTP: number[];
    };
    HTTP: typeof HTTP;
    URL: typeof URL;
    CHeaders: typeof CHeaders;
};
export default _default;
