/*
 * Copyright 2004-2025 the Pacemaker project contributors
 *
 * The version control history for this file may have further details.
 *
 * This source code is licensed under the GNU Lesser General Public License
 * version 2.1 or later (LGPLv2.1+) WITHOUT ANY WARRANTY.
 */

#ifndef XML_CRM_MESSAGES__H
#  define XML_CRM_MESSAGES__H

#include <stdbool.h>

#  include <crm/crm.h>
#  include <crm/common/ipc_internal.h>
#  include <crm/common/xml.h>
#  include <crm/cluster/internal.h>
#  include <controld_fsa.h>

extern void delete_ha_msg_input(ha_msg_input_t * orig);

void register_fsa_error_adv(enum crmd_fsa_input input, fsa_data_t *cur_data,
                            ha_msg_input_t *new_data, const char *raised_from);

#define register_fsa_error(input, cur_data) \
    register_fsa_error_adv((input), (cur_data), NULL, __func__)

void register_fsa_input_adv(enum crmd_fsa_cause cause,
                            enum crmd_fsa_input input, ha_msg_input_t *data,
                            uint64_t with_actions, gboolean prepend,
                            const char *raised_from);

extern void route_message(enum crmd_fsa_cause cause, xmlNode * input);

/*!
 * \internal
 * \brief Append an input to the FSA message queue without actions
 *
 * \param[in] cause  Cause of input creation (<tt>enum crmd_fsa_cause</tt>)
 * \param[in] input  Input type (<tt>enum crmd_fsa_input</tt>)
 * \param[in] data   Message data (\c ha_msg_input_t)
 */
#define controld_fsa_append(cause, input, data) \
    register_fsa_input_adv(cause, input, data, A_NOTHING, false, __func__)

/*!
 * \internal
 * \brief Prepend an input to the FSA message queue without actions
 *
 * \param[in] cause  Cause of input creation (<tt>enum crmd_fsa_cause</tt>)
 * \param[in] input  Input type (<tt>enum crmd_fsa_input</tt>)
 * \param[in] data   Message data (\c ha_msg_input_t)
 */
#define controld_fsa_prepend(cause, input, data)    \
    register_fsa_input_adv(cause, input, data, A_NOTHING, true, __func__)

void controld_fsa_stall_as(const char *function, fsa_data_t *cur_data,
                           uint64_t with_actions);

#define controld_fsa_stall(cur_data, with_actions)  \
    controld_fsa_stall_as(__func__, (cur_data), (with_actions));

void delete_fsa_input(fsa_data_t * fsa_data);

extern gboolean relay_message(xmlNode * relay_message, gboolean originated_locally);

gboolean crmd_is_proxy_session(const char *session);
void crmd_proxy_send(const char *session, xmlNode *msg);

bool controld_authorize_ipc_message(const xmlNode *client_msg,
                                    pcmk__client_t *curr_client,
                                    const char *proxy_session);

extern gboolean send_request(xmlNode * msg, char **msg_reference);

extern ha_msg_input_t *copy_ha_msg_input(ha_msg_input_t * orig);

void broadcast_remote_state_message(const char *node_name, bool node_up);

#endif
