/*
 * Copyright (C) 2023 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This code is derived in parts from the code distribution provided with
 * https://github.com/psanal2018/kyber-arm64
 *
 * That code is released under MIT license.
 */

#include "ext_headers_internal.h"
#include "kyber_ntt_armv8.h"

#if 0
const int16_t zetas_armv8[128] = {
  -1044,  -758,  -359, -1517,  1493,  1422,   287,   202,
   -171,   622,  1577,   182,   962, -1202, -1474,  1468,
    573, -1325,   264,   383,  -829,  1458, -1602,  -130,
   -681,  1017,   732,   608, -1542,   411,  -205, -1571,
   1223,   652,  -552,  1015, -1293,  1491,  -282, -1544,
    516,    -8,  -320,  -666, -1618, -1162,   126,  1469,
   -853,   -90,  -271,   830,   107, -1421,  -247,  -951,
   -398,   961, -1508,  -725,   448, -1065,   677, -1275,
  -1103,   430,   555,   843, -1251,   871,  1550,   105,
    422,   587,   177,  -235,  -291,  -460,  1574,  1653,
   -246,   778,  1159,  -147,  -777,  1483,  -602,  1119,
  -1590,   644,  -872,   349,   418,   329,  -156,   -75,
    817,  1097,   603,   610,  1322, -1285, -1465,   384,
  -1215,  -136,  1218, -1335,  -874,   220, -1187, -1659,
  -1185, -1530, -1278,   794, -1510,  -854,  -870,   478,
   -108,  -308,   996,   991,   958, -1460,  1522,  1628
};

const int16_t zetas_inv[128] = {
    1701, 1807, 1460, 2371, 2338, 2333, 308, 108, 2851, 870, 854, 1510, 2535, 1278, 1530, 1185,
    1659, 1187, 3109, 874, 1335, 2111, 136, 1215, 2945, 1465, 1285, 2007, 2719, 2726, 2232, 2512,
    75, 156, 3000, 2911, 2980, 872, 2685, 1590, 2210, 602, 1846, 777, 147, 2170, 2551, 246,
    1676, 1755, 460, 291, 235, 3152, 2742, 2907, 3224, 1779, 2458, 1251, 2486, 2774, 2899, 1103,
    1275, 2652, 1065, 2881, 725, 1508, 2368, 398, 951, 247, 1421, 3222, 2499, 271, 90, 853,
    1860, 3203, 1162, 1618, 666, 320, 8, 2813, 1544, 282, 1838, 1293, 2314, 552, 2677, 2106,
    1571, 205, 2918, 1542, 2721, 2597, 2312, 681, 130, 1602, 1871, 829, 2946, 3065, 1325, 2756,
    1861, 1474, 1202, 2367, 3147, 1752, 2707, 171, 3127, 3042, 1907, 1836, 1517, 359, 758, 1441
};
#endif

// zetas for ntt_arm
LC_FIPS_RODATA_SECTION
const int16_t kyber_zetas_armv8[287] = {
	-758,  -359,  1493,  1422,  -171,  622,	  1577,	 182,	573,   -1325,
	264,   383,   -829,  1458,  -1602, -130,

	1223,  1223,  1223,  1223,  652,   652,	  652,	 652,	-552,  -552,
	-552,  -552,  1015,  1015,  1015,  1015,  -1293, -1293, -1293, -1293,
	1491,  1491,  1491,  1491,  -282,  -282,  -282,	 -282,	-1544, -1544,
	-1544, -1544, 516,   516,   516,   516,	  -8,	 -8,	-8,    -8,
	-320,  -320,  -320,  -320,  -666,  -666,  -666,	 -666,	-1618, -1618,
	-1618, -1618, -1162, -1162, -1162, -1162, 126,	 126,	126,   126,
	1469,  1469,  1469,  1469,

	-1103, -1103, 430,   430,   555,   555,	  843,	 843,	-1251, -1251,
	871,   871,   1550,  1550,  105,   105,	  422,	 422,	587,   587,
	177,   177,   -235,  -235,  -291,  -291,  -460,	 -460,	1574,  1574,
	1653,  1653,  -246,  -246,  778,   778,	  1159,	 1159,	-147,  -147,
	-777,  -777,  1483,  1483,  -602,  -602,  1119,	 1119,	-1590, -1590,
	644,   644,   -872,  -872,  349,   349,	  418,	 418,	329,   329,
	-156,  -156,  -75,   -75,

	-1517, 287,   202,   962,   -1202, -1474, 1468,	 -681,	1017,  732,
	608,   -1542, 411,   -205,  -1571,

	-853,  -853,  -853,  -853,  -90,   -90,	  -90,	 -90,	-271,  -271,
	-271,  -271,  830,   830,   830,   830,	  107,	 107,	107,   107,
	-1421, -1421, -1421, -1421, -247,  -247,  -247,	 -247,	-951,  -951,
	-951,  -951,  -398,  -398,  -398,  -398,  961,	 961,	961,   961,
	-1508, -1508, -1508, -1508, -725,  -725,  -725,	 -725,	448,   448,
	448,   448,   -1065, -1065, -1065, -1065, 677,	 677,	677,   677,
	-1275, -1275, -1275, -1275,

	817,   817,   1097,  1097,  603,   603,	  610,	 610,	1322,  1322,
	-1285, -1285, -1465, -1465, 384,   384,	  -1215, -1215, -136,  -136,
	1218,  1218,  -1335, -1335, -874,  -874,  220,	 220,	-1187, -1187,
	-1659, -1659, -1185, -1185, -1530, -1530, -1278, -1278, 794,   794,
	-1510, -1510, -854,  -854,  -870,  -870,  478,	 478,	-108,  -108,
	-308,  -308,  996,   996,   991,   991,	  958,	 958,	-1460, -1460,
	1522,  1522,  1628,  1628
};

LC_FIPS_RODATA_SECTION
const int16_t kyber_zetas_inv_armv8[287] = {
	1628,  1628,  1522,  1522,  -1460, -1460, 958,	 958,	991,   991,
	996,   996,   -308,  -308,  -108,  -108,  478,	 478,	-870,  -870,
	-854,  -854,  -1510, -1510, 794,   794,	  -1278, -1278, -1530, -1530,
	-1185, -1185, -1659, -1659, -1187, -1187, 220,	 220,	-874,  -874,
	-1335, -1335, 1218,  1218,  -136,  -136,  -1215, -1215, 384,   384,
	-1465, -1465, -1285, -1285, 1322,  1322,  610,	 610,	603,   603,
	1097,  1097,  817,   817,

	-1275, -1275, -1275, -1275, 677,   677,	  677,	 677,	-1065, -1065,
	-1065, -1065, 448,   448,   448,   448,	  -725,	 -725,	-725,  -725,
	-1508, -1508, -1508, -1508, 961,   961,	  961,	 961,	-398,  -398,
	-398,  -398,  -951,  -951,  -951,  -951,  -247,	 -247,	-247,  -247,
	-1421, -1421, -1421, -1421, 107,   107,	  107,	 107,	830,   830,
	830,   830,   -271,  -271,  -271,  -271,  -90,	 -90,	-90,   -90,
	-853,  -853,  -853,  -853,

	-1571, -205,  411,   -1542, 608,   732,	  1017,	 -681,	1468,  -1474,
	-1202, 962,   202,   287,   -1517,

	-75,   -75,   -156,  -156,  329,   329,	  418,	 418,	349,   349,
	-872,  -872,  644,   644,   -1590, -1590, 1119,	 1119,	-602,  -602,
	1483,  1483,  -777,  -777,  -147,  -147,  1159,	 1159,	778,   778,
	-246,  -246,  1653,  1653,  1574,  1574,  -460,	 -460,	-291,  -291,
	-235,  -235,  177,   177,   587,   587,	  422,	 422,	105,   105,
	1550,  1550,  871,   871,   -1251, -1251, 843,	 843,	555,   555,
	430,   430,   -1103, -1103, 1469,  1469,  1469,	 1469,	126,   126,
	126,   126,   -1162, -1162, -1162, -1162, -1618, -1618, -1618, -1618,
	-666,  -666,  -666,  -666,  -320,  -320,  -320,	 -320,	-8,    -8,
	-8,    -8,    516,   516,   516,   516,	  -1544, -1544, -1544, -1544,
	-282,  -282,  -282,  -282,  1491,  1491,  1491,	 1491,	-1293, -1293,
	-1293, -1293, 1015,  1015,  1015,  1015,  -552,	 -552,	-552,  -552,
	652,   652,   652,   652,   1223,  1223,  1223,	 1223,	-130,  -1602,
	1458,  -829,  383,   264,   -1325, 573,	  182,	 1577,	622,   -171,
	1422,  1493,  -359,  -758
};
