/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Out;

public final class Action {
    String content;
    int priority;
    boolean isLookAction;

    public Action(String content, int priority) {
        this.content = content;
        this.priority = priority;
    }

    public Action(String content, int priority, boolean isLookAction) {
        this(content, priority);
        this.isLookAction = isLookAction;
    }

    public Action getHigherPriority(Action other) {
        if (other == null) {
            return this;
        }
        if (other.priority > this.priority) {
            return this;
        }
        return other;
    }

    public String toString() {
        return "Action (priority " + this.priority + ", lookahead " + this.isLookAction + ") :" + Out.NL + this.content;
    }

    public boolean isEquiv(Action a) {
        return this == a || this.content.trim().equals(a.content.trim());
    }

    public int hashCode() {
        if (this.content.length() < 1) {
            return 0;
        }
        return this.content.charAt(0) + this.content.charAt(this.content.length() / 2);
    }
}

