// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_egress.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type EncodedFileType int32

const (
	EncodedFileType_DEFAULT_FILETYPE EncodedFileType = 0 // file type chosen based on codecs
	EncodedFileType_MP4              EncodedFileType = 1
	EncodedFileType_OGG              EncodedFileType = 2
)

// Enum value maps for EncodedFileType.
var (
	EncodedFileType_name = map[int32]string{
		0: "DEFAULT_FILETYPE",
		1: "MP4",
		2: "OGG",
	}
	EncodedFileType_value = map[string]int32{
		"DEFAULT_FILETYPE": 0,
		"MP4":              1,
		"OGG":              2,
	}
)

func (x EncodedFileType) Enum() *EncodedFileType {
	p := new(EncodedFileType)
	*p = x
	return p
}

func (x EncodedFileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncodedFileType) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[0].Descriptor()
}

func (EncodedFileType) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[0]
}

func (x EncodedFileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncodedFileType.Descriptor instead.
func (EncodedFileType) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{0}
}

type SegmentedFileProtocol int32

const (
	SegmentedFileProtocol_DEFAULT_SEGMENTED_FILE_PROTOCOL SegmentedFileProtocol = 0
	SegmentedFileProtocol_HLS_PROTOCOL                    SegmentedFileProtocol = 1
)

// Enum value maps for SegmentedFileProtocol.
var (
	SegmentedFileProtocol_name = map[int32]string{
		0: "DEFAULT_SEGMENTED_FILE_PROTOCOL",
		1: "HLS_PROTOCOL",
	}
	SegmentedFileProtocol_value = map[string]int32{
		"DEFAULT_SEGMENTED_FILE_PROTOCOL": 0,
		"HLS_PROTOCOL":                    1,
	}
)

func (x SegmentedFileProtocol) Enum() *SegmentedFileProtocol {
	p := new(SegmentedFileProtocol)
	*p = x
	return p
}

func (x SegmentedFileProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SegmentedFileProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[1].Descriptor()
}

func (SegmentedFileProtocol) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[1]
}

func (x SegmentedFileProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SegmentedFileProtocol.Descriptor instead.
func (SegmentedFileProtocol) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{1}
}

type SegmentedFileSuffix int32

const (
	SegmentedFileSuffix_INDEX     SegmentedFileSuffix = 0
	SegmentedFileSuffix_TIMESTAMP SegmentedFileSuffix = 1
)

// Enum value maps for SegmentedFileSuffix.
var (
	SegmentedFileSuffix_name = map[int32]string{
		0: "INDEX",
		1: "TIMESTAMP",
	}
	SegmentedFileSuffix_value = map[string]int32{
		"INDEX":     0,
		"TIMESTAMP": 1,
	}
)

func (x SegmentedFileSuffix) Enum() *SegmentedFileSuffix {
	p := new(SegmentedFileSuffix)
	*p = x
	return p
}

func (x SegmentedFileSuffix) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SegmentedFileSuffix) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[2].Descriptor()
}

func (SegmentedFileSuffix) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[2]
}

func (x SegmentedFileSuffix) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SegmentedFileSuffix.Descriptor instead.
func (SegmentedFileSuffix) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{2}
}

type ImageFileSuffix int32

const (
	ImageFileSuffix_IMAGE_SUFFIX_INDEX     ImageFileSuffix = 0
	ImageFileSuffix_IMAGE_SUFFIX_TIMESTAMP ImageFileSuffix = 1
)

// Enum value maps for ImageFileSuffix.
var (
	ImageFileSuffix_name = map[int32]string{
		0: "IMAGE_SUFFIX_INDEX",
		1: "IMAGE_SUFFIX_TIMESTAMP",
	}
	ImageFileSuffix_value = map[string]int32{
		"IMAGE_SUFFIX_INDEX":     0,
		"IMAGE_SUFFIX_TIMESTAMP": 1,
	}
)

func (x ImageFileSuffix) Enum() *ImageFileSuffix {
	p := new(ImageFileSuffix)
	*p = x
	return p
}

func (x ImageFileSuffix) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImageFileSuffix) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[3].Descriptor()
}

func (ImageFileSuffix) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[3]
}

func (x ImageFileSuffix) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImageFileSuffix.Descriptor instead.
func (ImageFileSuffix) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{3}
}

type StreamProtocol int32

const (
	StreamProtocol_DEFAULT_PROTOCOL StreamProtocol = 0 // protocol chosen based on urls
	StreamProtocol_RTMP             StreamProtocol = 1
)

// Enum value maps for StreamProtocol.
var (
	StreamProtocol_name = map[int32]string{
		0: "DEFAULT_PROTOCOL",
		1: "RTMP",
	}
	StreamProtocol_value = map[string]int32{
		"DEFAULT_PROTOCOL": 0,
		"RTMP":             1,
	}
)

func (x StreamProtocol) Enum() *StreamProtocol {
	p := new(StreamProtocol)
	*p = x
	return p
}

func (x StreamProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[4].Descriptor()
}

func (StreamProtocol) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[4]
}

func (x StreamProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamProtocol.Descriptor instead.
func (StreamProtocol) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{4}
}

type EncodingOptionsPreset int32

const (
	EncodingOptionsPreset_H264_720P_30           EncodingOptionsPreset = 0 //  1280x720, 30fps, 3000kpbs, H.264_MAIN / OPUS
	EncodingOptionsPreset_H264_720P_60           EncodingOptionsPreset = 1 //  1280x720, 60fps, 4500kbps, H.264_MAIN / OPUS
	EncodingOptionsPreset_H264_1080P_30          EncodingOptionsPreset = 2 // 1920x1080, 30fps, 4500kbps, H.264_MAIN / OPUS
	EncodingOptionsPreset_H264_1080P_60          EncodingOptionsPreset = 3 // 1920x1080, 60fps, 6000kbps, H.264_MAIN / OPUS
	EncodingOptionsPreset_PORTRAIT_H264_720P_30  EncodingOptionsPreset = 4 //  720x1280, 30fps, 3000kpbs, H.264_MAIN / OPUS
	EncodingOptionsPreset_PORTRAIT_H264_720P_60  EncodingOptionsPreset = 5 //  720x1280, 60fps, 4500kbps, H.264_MAIN / OPUS
	EncodingOptionsPreset_PORTRAIT_H264_1080P_30 EncodingOptionsPreset = 6 // 1080x1920, 30fps, 4500kbps, H.264_MAIN / OPUS
	EncodingOptionsPreset_PORTRAIT_H264_1080P_60 EncodingOptionsPreset = 7 // 1080x1920, 60fps, 6000kbps, H.264_MAIN / OPUS
)

// Enum value maps for EncodingOptionsPreset.
var (
	EncodingOptionsPreset_name = map[int32]string{
		0: "H264_720P_30",
		1: "H264_720P_60",
		2: "H264_1080P_30",
		3: "H264_1080P_60",
		4: "PORTRAIT_H264_720P_30",
		5: "PORTRAIT_H264_720P_60",
		6: "PORTRAIT_H264_1080P_30",
		7: "PORTRAIT_H264_1080P_60",
	}
	EncodingOptionsPreset_value = map[string]int32{
		"H264_720P_30":           0,
		"H264_720P_60":           1,
		"H264_1080P_30":          2,
		"H264_1080P_60":          3,
		"PORTRAIT_H264_720P_30":  4,
		"PORTRAIT_H264_720P_60":  5,
		"PORTRAIT_H264_1080P_30": 6,
		"PORTRAIT_H264_1080P_60": 7,
	}
)

func (x EncodingOptionsPreset) Enum() *EncodingOptionsPreset {
	p := new(EncodingOptionsPreset)
	*p = x
	return p
}

func (x EncodingOptionsPreset) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncodingOptionsPreset) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[5].Descriptor()
}

func (EncodingOptionsPreset) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[5]
}

func (x EncodingOptionsPreset) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncodingOptionsPreset.Descriptor instead.
func (EncodingOptionsPreset) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{5}
}

type EgressStatus int32

const (
	EgressStatus_EGRESS_STARTING      EgressStatus = 0
	EgressStatus_EGRESS_ACTIVE        EgressStatus = 1
	EgressStatus_EGRESS_ENDING        EgressStatus = 2
	EgressStatus_EGRESS_COMPLETE      EgressStatus = 3
	EgressStatus_EGRESS_FAILED        EgressStatus = 4
	EgressStatus_EGRESS_ABORTED       EgressStatus = 5
	EgressStatus_EGRESS_LIMIT_REACHED EgressStatus = 6
)

// Enum value maps for EgressStatus.
var (
	EgressStatus_name = map[int32]string{
		0: "EGRESS_STARTING",
		1: "EGRESS_ACTIVE",
		2: "EGRESS_ENDING",
		3: "EGRESS_COMPLETE",
		4: "EGRESS_FAILED",
		5: "EGRESS_ABORTED",
		6: "EGRESS_LIMIT_REACHED",
	}
	EgressStatus_value = map[string]int32{
		"EGRESS_STARTING":      0,
		"EGRESS_ACTIVE":        1,
		"EGRESS_ENDING":        2,
		"EGRESS_COMPLETE":      3,
		"EGRESS_FAILED":        4,
		"EGRESS_ABORTED":       5,
		"EGRESS_LIMIT_REACHED": 6,
	}
)

func (x EgressStatus) Enum() *EgressStatus {
	p := new(EgressStatus)
	*p = x
	return p
}

func (x EgressStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EgressStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[6].Descriptor()
}

func (EgressStatus) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[6]
}

func (x EgressStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EgressStatus.Descriptor instead.
func (EgressStatus) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{6}
}

type StreamInfo_Status int32

const (
	StreamInfo_ACTIVE   StreamInfo_Status = 0
	StreamInfo_FINISHED StreamInfo_Status = 1
	StreamInfo_FAILED   StreamInfo_Status = 2
)

// Enum value maps for StreamInfo_Status.
var (
	StreamInfo_Status_name = map[int32]string{
		0: "ACTIVE",
		1: "FINISHED",
		2: "FAILED",
	}
	StreamInfo_Status_value = map[string]int32{
		"ACTIVE":   0,
		"FINISHED": 1,
		"FAILED":   2,
	}
)

func (x StreamInfo_Status) Enum() *StreamInfo_Status {
	p := new(StreamInfo_Status)
	*p = x
	return p
}

func (x StreamInfo_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamInfo_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_egress_proto_enumTypes[7].Descriptor()
}

func (StreamInfo_Status) Type() protoreflect.EnumType {
	return &file_livekit_egress_proto_enumTypes[7]
}

func (x StreamInfo_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamInfo_Status.Descriptor instead.
func (StreamInfo_Status) EnumDescriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{22, 0}
}

// composite using a web browser
type RoomCompositeEgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RoomName      string `protobuf:"bytes,1,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`                  // required
	Layout        string `protobuf:"bytes,2,opt,name=layout,proto3" json:"layout,omitempty"`                                      // (optional)
	AudioOnly     bool   `protobuf:"varint,3,opt,name=audio_only,json=audioOnly,proto3" json:"audio_only,omitempty"`              // (default false)
	VideoOnly     bool   `protobuf:"varint,4,opt,name=video_only,json=videoOnly,proto3" json:"video_only,omitempty"`              // (default false)
	CustomBaseUrl string `protobuf:"bytes,5,opt,name=custom_base_url,json=customBaseUrl,proto3" json:"custom_base_url,omitempty"` // template base url (default https://recorder.livekit.io)
	// Types that are assignable to Output:
	//
	//	*RoomCompositeEgressRequest_File
	//	*RoomCompositeEgressRequest_Stream
	//	*RoomCompositeEgressRequest_Segments
	Output isRoomCompositeEgressRequest_Output `protobuf_oneof:"output"`
	// Types that are assignable to Options:
	//
	//	*RoomCompositeEgressRequest_Preset
	//	*RoomCompositeEgressRequest_Advanced
	Options        isRoomCompositeEgressRequest_Options `protobuf_oneof:"options"`
	FileOutputs    []*EncodedFileOutput                 `protobuf:"bytes,11,rep,name=file_outputs,json=fileOutputs,proto3" json:"file_outputs,omitempty"`
	StreamOutputs  []*StreamOutput                      `protobuf:"bytes,12,rep,name=stream_outputs,json=streamOutputs,proto3" json:"stream_outputs,omitempty"`
	SegmentOutputs []*SegmentedFileOutput               `protobuf:"bytes,13,rep,name=segment_outputs,json=segmentOutputs,proto3" json:"segment_outputs,omitempty"`
	ImageOutputs   []*ImageOutput                       `protobuf:"bytes,14,rep,name=image_outputs,json=imageOutputs,proto3" json:"image_outputs,omitempty"`
}

func (x *RoomCompositeEgressRequest) Reset() {
	*x = RoomCompositeEgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoomCompositeEgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoomCompositeEgressRequest) ProtoMessage() {}

func (x *RoomCompositeEgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoomCompositeEgressRequest.ProtoReflect.Descriptor instead.
func (*RoomCompositeEgressRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{0}
}

func (x *RoomCompositeEgressRequest) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *RoomCompositeEgressRequest) GetLayout() string {
	if x != nil {
		return x.Layout
	}
	return ""
}

func (x *RoomCompositeEgressRequest) GetAudioOnly() bool {
	if x != nil {
		return x.AudioOnly
	}
	return false
}

func (x *RoomCompositeEgressRequest) GetVideoOnly() bool {
	if x != nil {
		return x.VideoOnly
	}
	return false
}

func (x *RoomCompositeEgressRequest) GetCustomBaseUrl() string {
	if x != nil {
		return x.CustomBaseUrl
	}
	return ""
}

func (m *RoomCompositeEgressRequest) GetOutput() isRoomCompositeEgressRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *RoomCompositeEgressRequest) GetFile() *EncodedFileOutput {
	if x, ok := x.GetOutput().(*RoomCompositeEgressRequest_File); ok {
		return x.File
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *RoomCompositeEgressRequest) GetStream() *StreamOutput {
	if x, ok := x.GetOutput().(*RoomCompositeEgressRequest_Stream); ok {
		return x.Stream
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *RoomCompositeEgressRequest) GetSegments() *SegmentedFileOutput {
	if x, ok := x.GetOutput().(*RoomCompositeEgressRequest_Segments); ok {
		return x.Segments
	}
	return nil
}

func (m *RoomCompositeEgressRequest) GetOptions() isRoomCompositeEgressRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *RoomCompositeEgressRequest) GetPreset() EncodingOptionsPreset {
	if x, ok := x.GetOptions().(*RoomCompositeEgressRequest_Preset); ok {
		return x.Preset
	}
	return EncodingOptionsPreset_H264_720P_30
}

func (x *RoomCompositeEgressRequest) GetAdvanced() *EncodingOptions {
	if x, ok := x.GetOptions().(*RoomCompositeEgressRequest_Advanced); ok {
		return x.Advanced
	}
	return nil
}

func (x *RoomCompositeEgressRequest) GetFileOutputs() []*EncodedFileOutput {
	if x != nil {
		return x.FileOutputs
	}
	return nil
}

func (x *RoomCompositeEgressRequest) GetStreamOutputs() []*StreamOutput {
	if x != nil {
		return x.StreamOutputs
	}
	return nil
}

func (x *RoomCompositeEgressRequest) GetSegmentOutputs() []*SegmentedFileOutput {
	if x != nil {
		return x.SegmentOutputs
	}
	return nil
}

func (x *RoomCompositeEgressRequest) GetImageOutputs() []*ImageOutput {
	if x != nil {
		return x.ImageOutputs
	}
	return nil
}

type isRoomCompositeEgressRequest_Output interface {
	isRoomCompositeEgressRequest_Output()
}

type RoomCompositeEgressRequest_File struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	File *EncodedFileOutput `protobuf:"bytes,6,opt,name=file,proto3,oneof"`
}

type RoomCompositeEgressRequest_Stream struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Stream *StreamOutput `protobuf:"bytes,7,opt,name=stream,proto3,oneof"`
}

type RoomCompositeEgressRequest_Segments struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Segments *SegmentedFileOutput `protobuf:"bytes,10,opt,name=segments,proto3,oneof"`
}

func (*RoomCompositeEgressRequest_File) isRoomCompositeEgressRequest_Output() {}

func (*RoomCompositeEgressRequest_Stream) isRoomCompositeEgressRequest_Output() {}

func (*RoomCompositeEgressRequest_Segments) isRoomCompositeEgressRequest_Output() {}

type isRoomCompositeEgressRequest_Options interface {
	isRoomCompositeEgressRequest_Options()
}

type RoomCompositeEgressRequest_Preset struct {
	Preset EncodingOptionsPreset `protobuf:"varint,8,opt,name=preset,proto3,enum=livekit.EncodingOptionsPreset,oneof"` // (default H264_720P_30)
}

type RoomCompositeEgressRequest_Advanced struct {
	Advanced *EncodingOptions `protobuf:"bytes,9,opt,name=advanced,proto3,oneof"` // (optional)
}

func (*RoomCompositeEgressRequest_Preset) isRoomCompositeEgressRequest_Options() {}

func (*RoomCompositeEgressRequest_Advanced) isRoomCompositeEgressRequest_Options() {}

// record any website
type WebEgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Url              string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	AudioOnly        bool   `protobuf:"varint,2,opt,name=audio_only,json=audioOnly,proto3" json:"audio_only,omitempty"`
	VideoOnly        bool   `protobuf:"varint,3,opt,name=video_only,json=videoOnly,proto3" json:"video_only,omitempty"`
	AwaitStartSignal bool   `protobuf:"varint,12,opt,name=await_start_signal,json=awaitStartSignal,proto3" json:"await_start_signal,omitempty"`
	// Types that are assignable to Output:
	//
	//	*WebEgressRequest_File
	//	*WebEgressRequest_Stream
	//	*WebEgressRequest_Segments
	Output isWebEgressRequest_Output `protobuf_oneof:"output"`
	// Types that are assignable to Options:
	//
	//	*WebEgressRequest_Preset
	//	*WebEgressRequest_Advanced
	Options        isWebEgressRequest_Options `protobuf_oneof:"options"`
	FileOutputs    []*EncodedFileOutput       `protobuf:"bytes,9,rep,name=file_outputs,json=fileOutputs,proto3" json:"file_outputs,omitempty"`
	StreamOutputs  []*StreamOutput            `protobuf:"bytes,10,rep,name=stream_outputs,json=streamOutputs,proto3" json:"stream_outputs,omitempty"`
	SegmentOutputs []*SegmentedFileOutput     `protobuf:"bytes,11,rep,name=segment_outputs,json=segmentOutputs,proto3" json:"segment_outputs,omitempty"`
	ImageOutputs   []*ImageOutput             `protobuf:"bytes,13,rep,name=image_outputs,json=imageOutputs,proto3" json:"image_outputs,omitempty"`
}

func (x *WebEgressRequest) Reset() {
	*x = WebEgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebEgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebEgressRequest) ProtoMessage() {}

func (x *WebEgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebEgressRequest.ProtoReflect.Descriptor instead.
func (*WebEgressRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{1}
}

func (x *WebEgressRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *WebEgressRequest) GetAudioOnly() bool {
	if x != nil {
		return x.AudioOnly
	}
	return false
}

func (x *WebEgressRequest) GetVideoOnly() bool {
	if x != nil {
		return x.VideoOnly
	}
	return false
}

func (x *WebEgressRequest) GetAwaitStartSignal() bool {
	if x != nil {
		return x.AwaitStartSignal
	}
	return false
}

func (m *WebEgressRequest) GetOutput() isWebEgressRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *WebEgressRequest) GetFile() *EncodedFileOutput {
	if x, ok := x.GetOutput().(*WebEgressRequest_File); ok {
		return x.File
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *WebEgressRequest) GetStream() *StreamOutput {
	if x, ok := x.GetOutput().(*WebEgressRequest_Stream); ok {
		return x.Stream
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *WebEgressRequest) GetSegments() *SegmentedFileOutput {
	if x, ok := x.GetOutput().(*WebEgressRequest_Segments); ok {
		return x.Segments
	}
	return nil
}

func (m *WebEgressRequest) GetOptions() isWebEgressRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *WebEgressRequest) GetPreset() EncodingOptionsPreset {
	if x, ok := x.GetOptions().(*WebEgressRequest_Preset); ok {
		return x.Preset
	}
	return EncodingOptionsPreset_H264_720P_30
}

func (x *WebEgressRequest) GetAdvanced() *EncodingOptions {
	if x, ok := x.GetOptions().(*WebEgressRequest_Advanced); ok {
		return x.Advanced
	}
	return nil
}

func (x *WebEgressRequest) GetFileOutputs() []*EncodedFileOutput {
	if x != nil {
		return x.FileOutputs
	}
	return nil
}

func (x *WebEgressRequest) GetStreamOutputs() []*StreamOutput {
	if x != nil {
		return x.StreamOutputs
	}
	return nil
}

func (x *WebEgressRequest) GetSegmentOutputs() []*SegmentedFileOutput {
	if x != nil {
		return x.SegmentOutputs
	}
	return nil
}

func (x *WebEgressRequest) GetImageOutputs() []*ImageOutput {
	if x != nil {
		return x.ImageOutputs
	}
	return nil
}

type isWebEgressRequest_Output interface {
	isWebEgressRequest_Output()
}

type WebEgressRequest_File struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	File *EncodedFileOutput `protobuf:"bytes,4,opt,name=file,proto3,oneof"`
}

type WebEgressRequest_Stream struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Stream *StreamOutput `protobuf:"bytes,5,opt,name=stream,proto3,oneof"`
}

type WebEgressRequest_Segments struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Segments *SegmentedFileOutput `protobuf:"bytes,6,opt,name=segments,proto3,oneof"`
}

func (*WebEgressRequest_File) isWebEgressRequest_Output() {}

func (*WebEgressRequest_Stream) isWebEgressRequest_Output() {}

func (*WebEgressRequest_Segments) isWebEgressRequest_Output() {}

type isWebEgressRequest_Options interface {
	isWebEgressRequest_Options()
}

type WebEgressRequest_Preset struct {
	Preset EncodingOptionsPreset `protobuf:"varint,7,opt,name=preset,proto3,enum=livekit.EncodingOptionsPreset,oneof"`
}

type WebEgressRequest_Advanced struct {
	Advanced *EncodingOptions `protobuf:"bytes,8,opt,name=advanced,proto3,oneof"`
}

func (*WebEgressRequest_Preset) isWebEgressRequest_Options() {}

func (*WebEgressRequest_Advanced) isWebEgressRequest_Options() {}

// record audio and video from a single participant
type ParticipantEgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RoomName    string `protobuf:"bytes,1,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`           // required
	Identity    string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`                           // required
	ScreenShare bool   `protobuf:"varint,3,opt,name=screen_share,json=screenShare,proto3" json:"screen_share,omitempty"` // (default false)
	// Types that are assignable to Options:
	//
	//	*ParticipantEgressRequest_Preset
	//	*ParticipantEgressRequest_Advanced
	Options        isParticipantEgressRequest_Options `protobuf_oneof:"options"`
	FileOutputs    []*EncodedFileOutput               `protobuf:"bytes,6,rep,name=file_outputs,json=fileOutputs,proto3" json:"file_outputs,omitempty"`
	StreamOutputs  []*StreamOutput                    `protobuf:"bytes,7,rep,name=stream_outputs,json=streamOutputs,proto3" json:"stream_outputs,omitempty"`
	SegmentOutputs []*SegmentedFileOutput             `protobuf:"bytes,8,rep,name=segment_outputs,json=segmentOutputs,proto3" json:"segment_outputs,omitempty"`
	ImageOutputs   []*ImageOutput                     `protobuf:"bytes,9,rep,name=image_outputs,json=imageOutputs,proto3" json:"image_outputs,omitempty"`
}

func (x *ParticipantEgressRequest) Reset() {
	*x = ParticipantEgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParticipantEgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParticipantEgressRequest) ProtoMessage() {}

func (x *ParticipantEgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParticipantEgressRequest.ProtoReflect.Descriptor instead.
func (*ParticipantEgressRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{2}
}

func (x *ParticipantEgressRequest) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *ParticipantEgressRequest) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *ParticipantEgressRequest) GetScreenShare() bool {
	if x != nil {
		return x.ScreenShare
	}
	return false
}

func (m *ParticipantEgressRequest) GetOptions() isParticipantEgressRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *ParticipantEgressRequest) GetPreset() EncodingOptionsPreset {
	if x, ok := x.GetOptions().(*ParticipantEgressRequest_Preset); ok {
		return x.Preset
	}
	return EncodingOptionsPreset_H264_720P_30
}

func (x *ParticipantEgressRequest) GetAdvanced() *EncodingOptions {
	if x, ok := x.GetOptions().(*ParticipantEgressRequest_Advanced); ok {
		return x.Advanced
	}
	return nil
}

func (x *ParticipantEgressRequest) GetFileOutputs() []*EncodedFileOutput {
	if x != nil {
		return x.FileOutputs
	}
	return nil
}

func (x *ParticipantEgressRequest) GetStreamOutputs() []*StreamOutput {
	if x != nil {
		return x.StreamOutputs
	}
	return nil
}

func (x *ParticipantEgressRequest) GetSegmentOutputs() []*SegmentedFileOutput {
	if x != nil {
		return x.SegmentOutputs
	}
	return nil
}

func (x *ParticipantEgressRequest) GetImageOutputs() []*ImageOutput {
	if x != nil {
		return x.ImageOutputs
	}
	return nil
}

type isParticipantEgressRequest_Options interface {
	isParticipantEgressRequest_Options()
}

type ParticipantEgressRequest_Preset struct {
	Preset EncodingOptionsPreset `protobuf:"varint,4,opt,name=preset,proto3,enum=livekit.EncodingOptionsPreset,oneof"` // (default H264_720P_30)
}

type ParticipantEgressRequest_Advanced struct {
	Advanced *EncodingOptions `protobuf:"bytes,5,opt,name=advanced,proto3,oneof"` // (optional)
}

func (*ParticipantEgressRequest_Preset) isParticipantEgressRequest_Options() {}

func (*ParticipantEgressRequest_Advanced) isParticipantEgressRequest_Options() {}

// containerize up to one audio and one video track
type TrackCompositeEgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RoomName     string `protobuf:"bytes,1,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`               // required
	AudioTrackId string `protobuf:"bytes,2,opt,name=audio_track_id,json=audioTrackId,proto3" json:"audio_track_id,omitempty"` // (optional)
	VideoTrackId string `protobuf:"bytes,3,opt,name=video_track_id,json=videoTrackId,proto3" json:"video_track_id,omitempty"` // (optional)
	// Types that are assignable to Output:
	//
	//	*TrackCompositeEgressRequest_File
	//	*TrackCompositeEgressRequest_Stream
	//	*TrackCompositeEgressRequest_Segments
	Output isTrackCompositeEgressRequest_Output `protobuf_oneof:"output"`
	// Types that are assignable to Options:
	//
	//	*TrackCompositeEgressRequest_Preset
	//	*TrackCompositeEgressRequest_Advanced
	Options        isTrackCompositeEgressRequest_Options `protobuf_oneof:"options"`
	FileOutputs    []*EncodedFileOutput                  `protobuf:"bytes,11,rep,name=file_outputs,json=fileOutputs,proto3" json:"file_outputs,omitempty"`
	StreamOutputs  []*StreamOutput                       `protobuf:"bytes,12,rep,name=stream_outputs,json=streamOutputs,proto3" json:"stream_outputs,omitempty"`
	SegmentOutputs []*SegmentedFileOutput                `protobuf:"bytes,13,rep,name=segment_outputs,json=segmentOutputs,proto3" json:"segment_outputs,omitempty"`
	ImageOutputs   []*ImageOutput                        `protobuf:"bytes,14,rep,name=image_outputs,json=imageOutputs,proto3" json:"image_outputs,omitempty"`
}

func (x *TrackCompositeEgressRequest) Reset() {
	*x = TrackCompositeEgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrackCompositeEgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrackCompositeEgressRequest) ProtoMessage() {}

func (x *TrackCompositeEgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrackCompositeEgressRequest.ProtoReflect.Descriptor instead.
func (*TrackCompositeEgressRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{3}
}

func (x *TrackCompositeEgressRequest) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *TrackCompositeEgressRequest) GetAudioTrackId() string {
	if x != nil {
		return x.AudioTrackId
	}
	return ""
}

func (x *TrackCompositeEgressRequest) GetVideoTrackId() string {
	if x != nil {
		return x.VideoTrackId
	}
	return ""
}

func (m *TrackCompositeEgressRequest) GetOutput() isTrackCompositeEgressRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *TrackCompositeEgressRequest) GetFile() *EncodedFileOutput {
	if x, ok := x.GetOutput().(*TrackCompositeEgressRequest_File); ok {
		return x.File
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *TrackCompositeEgressRequest) GetStream() *StreamOutput {
	if x, ok := x.GetOutput().(*TrackCompositeEgressRequest_Stream); ok {
		return x.Stream
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *TrackCompositeEgressRequest) GetSegments() *SegmentedFileOutput {
	if x, ok := x.GetOutput().(*TrackCompositeEgressRequest_Segments); ok {
		return x.Segments
	}
	return nil
}

func (m *TrackCompositeEgressRequest) GetOptions() isTrackCompositeEgressRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *TrackCompositeEgressRequest) GetPreset() EncodingOptionsPreset {
	if x, ok := x.GetOptions().(*TrackCompositeEgressRequest_Preset); ok {
		return x.Preset
	}
	return EncodingOptionsPreset_H264_720P_30
}

func (x *TrackCompositeEgressRequest) GetAdvanced() *EncodingOptions {
	if x, ok := x.GetOptions().(*TrackCompositeEgressRequest_Advanced); ok {
		return x.Advanced
	}
	return nil
}

func (x *TrackCompositeEgressRequest) GetFileOutputs() []*EncodedFileOutput {
	if x != nil {
		return x.FileOutputs
	}
	return nil
}

func (x *TrackCompositeEgressRequest) GetStreamOutputs() []*StreamOutput {
	if x != nil {
		return x.StreamOutputs
	}
	return nil
}

func (x *TrackCompositeEgressRequest) GetSegmentOutputs() []*SegmentedFileOutput {
	if x != nil {
		return x.SegmentOutputs
	}
	return nil
}

func (x *TrackCompositeEgressRequest) GetImageOutputs() []*ImageOutput {
	if x != nil {
		return x.ImageOutputs
	}
	return nil
}

type isTrackCompositeEgressRequest_Output interface {
	isTrackCompositeEgressRequest_Output()
}

type TrackCompositeEgressRequest_File struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	File *EncodedFileOutput `protobuf:"bytes,4,opt,name=file,proto3,oneof"`
}

type TrackCompositeEgressRequest_Stream struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Stream *StreamOutput `protobuf:"bytes,5,opt,name=stream,proto3,oneof"`
}

type TrackCompositeEgressRequest_Segments struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Segments *SegmentedFileOutput `protobuf:"bytes,8,opt,name=segments,proto3,oneof"`
}

func (*TrackCompositeEgressRequest_File) isTrackCompositeEgressRequest_Output() {}

func (*TrackCompositeEgressRequest_Stream) isTrackCompositeEgressRequest_Output() {}

func (*TrackCompositeEgressRequest_Segments) isTrackCompositeEgressRequest_Output() {}

type isTrackCompositeEgressRequest_Options interface {
	isTrackCompositeEgressRequest_Options()
}

type TrackCompositeEgressRequest_Preset struct {
	Preset EncodingOptionsPreset `protobuf:"varint,6,opt,name=preset,proto3,enum=livekit.EncodingOptionsPreset,oneof"` // (default H264_720P_30)
}

type TrackCompositeEgressRequest_Advanced struct {
	Advanced *EncodingOptions `protobuf:"bytes,7,opt,name=advanced,proto3,oneof"` // (optional)
}

func (*TrackCompositeEgressRequest_Preset) isTrackCompositeEgressRequest_Options() {}

func (*TrackCompositeEgressRequest_Advanced) isTrackCompositeEgressRequest_Options() {}

// record tracks individually, without transcoding
type TrackEgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RoomName string `protobuf:"bytes,1,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"` // required
	TrackId  string `protobuf:"bytes,2,opt,name=track_id,json=trackId,proto3" json:"track_id,omitempty"`    // required
	// Types that are assignable to Output:
	//
	//	*TrackEgressRequest_File
	//	*TrackEgressRequest_WebsocketUrl
	Output isTrackEgressRequest_Output `protobuf_oneof:"output"`
}

func (x *TrackEgressRequest) Reset() {
	*x = TrackEgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrackEgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrackEgressRequest) ProtoMessage() {}

func (x *TrackEgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrackEgressRequest.ProtoReflect.Descriptor instead.
func (*TrackEgressRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{4}
}

func (x *TrackEgressRequest) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *TrackEgressRequest) GetTrackId() string {
	if x != nil {
		return x.TrackId
	}
	return ""
}

func (m *TrackEgressRequest) GetOutput() isTrackEgressRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *TrackEgressRequest) GetFile() *DirectFileOutput {
	if x, ok := x.GetOutput().(*TrackEgressRequest_File); ok {
		return x.File
	}
	return nil
}

func (x *TrackEgressRequest) GetWebsocketUrl() string {
	if x, ok := x.GetOutput().(*TrackEgressRequest_WebsocketUrl); ok {
		return x.WebsocketUrl
	}
	return ""
}

type isTrackEgressRequest_Output interface {
	isTrackEgressRequest_Output()
}

type TrackEgressRequest_File struct {
	File *DirectFileOutput `protobuf:"bytes,3,opt,name=file,proto3,oneof"`
}

type TrackEgressRequest_WebsocketUrl struct {
	WebsocketUrl string `protobuf:"bytes,4,opt,name=websocket_url,json=websocketUrl,proto3,oneof"`
}

func (*TrackEgressRequest_File) isTrackEgressRequest_Output() {}

func (*TrackEgressRequest_WebsocketUrl) isTrackEgressRequest_Output() {}

type EncodedFileOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FileType        EncodedFileType `protobuf:"varint,1,opt,name=file_type,json=fileType,proto3,enum=livekit.EncodedFileType" json:"file_type,omitempty"` // (optional)
	Filepath        string          `protobuf:"bytes,2,opt,name=filepath,proto3" json:"filepath,omitempty"`                                               // see egress docs for templating (default {room_name}-{time})
	DisableManifest bool            `protobuf:"varint,6,opt,name=disable_manifest,json=disableManifest,proto3" json:"disable_manifest,omitempty"`         // disable upload of manifest file (default false)
	// Types that are assignable to Output:
	//
	//	*EncodedFileOutput_S3
	//	*EncodedFileOutput_Gcp
	//	*EncodedFileOutput_Azure
	//	*EncodedFileOutput_AliOSS
	Output isEncodedFileOutput_Output `protobuf_oneof:"output"`
}

func (x *EncodedFileOutput) Reset() {
	*x = EncodedFileOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncodedFileOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncodedFileOutput) ProtoMessage() {}

func (x *EncodedFileOutput) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncodedFileOutput.ProtoReflect.Descriptor instead.
func (*EncodedFileOutput) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{5}
}

func (x *EncodedFileOutput) GetFileType() EncodedFileType {
	if x != nil {
		return x.FileType
	}
	return EncodedFileType_DEFAULT_FILETYPE
}

func (x *EncodedFileOutput) GetFilepath() string {
	if x != nil {
		return x.Filepath
	}
	return ""
}

func (x *EncodedFileOutput) GetDisableManifest() bool {
	if x != nil {
		return x.DisableManifest
	}
	return false
}

func (m *EncodedFileOutput) GetOutput() isEncodedFileOutput_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *EncodedFileOutput) GetS3() *S3Upload {
	if x, ok := x.GetOutput().(*EncodedFileOutput_S3); ok {
		return x.S3
	}
	return nil
}

func (x *EncodedFileOutput) GetGcp() *GCPUpload {
	if x, ok := x.GetOutput().(*EncodedFileOutput_Gcp); ok {
		return x.Gcp
	}
	return nil
}

func (x *EncodedFileOutput) GetAzure() *AzureBlobUpload {
	if x, ok := x.GetOutput().(*EncodedFileOutput_Azure); ok {
		return x.Azure
	}
	return nil
}

func (x *EncodedFileOutput) GetAliOSS() *AliOSSUpload {
	if x, ok := x.GetOutput().(*EncodedFileOutput_AliOSS); ok {
		return x.AliOSS
	}
	return nil
}

type isEncodedFileOutput_Output interface {
	isEncodedFileOutput_Output()
}

type EncodedFileOutput_S3 struct {
	S3 *S3Upload `protobuf:"bytes,3,opt,name=s3,proto3,oneof"`
}

type EncodedFileOutput_Gcp struct {
	Gcp *GCPUpload `protobuf:"bytes,4,opt,name=gcp,proto3,oneof"`
}

type EncodedFileOutput_Azure struct {
	Azure *AzureBlobUpload `protobuf:"bytes,5,opt,name=azure,proto3,oneof"`
}

type EncodedFileOutput_AliOSS struct {
	AliOSS *AliOSSUpload `protobuf:"bytes,7,opt,name=aliOSS,proto3,oneof"`
}

func (*EncodedFileOutput_S3) isEncodedFileOutput_Output() {}

func (*EncodedFileOutput_Gcp) isEncodedFileOutput_Output() {}

func (*EncodedFileOutput_Azure) isEncodedFileOutput_Output() {}

func (*EncodedFileOutput_AliOSS) isEncodedFileOutput_Output() {}

// Used to generate HLS segments or other kind of segmented output
type SegmentedFileOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Protocol         SegmentedFileProtocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=livekit.SegmentedFileProtocol" json:"protocol,omitempty"`                                  // (optional)
	FilenamePrefix   string                `protobuf:"bytes,2,opt,name=filename_prefix,json=filenamePrefix,proto3" json:"filename_prefix,omitempty"`                                    // (optional)
	PlaylistName     string                `protobuf:"bytes,3,opt,name=playlist_name,json=playlistName,proto3" json:"playlist_name,omitempty"`                                          // (optional)
	LivePlaylistName string                `protobuf:"bytes,11,opt,name=live_playlist_name,json=livePlaylistName,proto3" json:"live_playlist_name,omitempty"`                           // (optional, disabled if not provided). Path of a live playlist
	SegmentDuration  uint32                `protobuf:"varint,4,opt,name=segment_duration,json=segmentDuration,proto3" json:"segment_duration,omitempty"`                                // in seconds (optional)
	FilenameSuffix   SegmentedFileSuffix   `protobuf:"varint,10,opt,name=filename_suffix,json=filenameSuffix,proto3,enum=livekit.SegmentedFileSuffix" json:"filename_suffix,omitempty"` // (optional, default INDEX)
	DisableManifest  bool                  `protobuf:"varint,8,opt,name=disable_manifest,json=disableManifest,proto3" json:"disable_manifest,omitempty"`                                // disable upload of manifest file (default false)
	// Types that are assignable to Output:
	//
	//	*SegmentedFileOutput_S3
	//	*SegmentedFileOutput_Gcp
	//	*SegmentedFileOutput_Azure
	//	*SegmentedFileOutput_AliOSS
	Output isSegmentedFileOutput_Output `protobuf_oneof:"output"`
}

func (x *SegmentedFileOutput) Reset() {
	*x = SegmentedFileOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentedFileOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentedFileOutput) ProtoMessage() {}

func (x *SegmentedFileOutput) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentedFileOutput.ProtoReflect.Descriptor instead.
func (*SegmentedFileOutput) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{6}
}

func (x *SegmentedFileOutput) GetProtocol() SegmentedFileProtocol {
	if x != nil {
		return x.Protocol
	}
	return SegmentedFileProtocol_DEFAULT_SEGMENTED_FILE_PROTOCOL
}

func (x *SegmentedFileOutput) GetFilenamePrefix() string {
	if x != nil {
		return x.FilenamePrefix
	}
	return ""
}

func (x *SegmentedFileOutput) GetPlaylistName() string {
	if x != nil {
		return x.PlaylistName
	}
	return ""
}

func (x *SegmentedFileOutput) GetLivePlaylistName() string {
	if x != nil {
		return x.LivePlaylistName
	}
	return ""
}

func (x *SegmentedFileOutput) GetSegmentDuration() uint32 {
	if x != nil {
		return x.SegmentDuration
	}
	return 0
}

func (x *SegmentedFileOutput) GetFilenameSuffix() SegmentedFileSuffix {
	if x != nil {
		return x.FilenameSuffix
	}
	return SegmentedFileSuffix_INDEX
}

func (x *SegmentedFileOutput) GetDisableManifest() bool {
	if x != nil {
		return x.DisableManifest
	}
	return false
}

func (m *SegmentedFileOutput) GetOutput() isSegmentedFileOutput_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *SegmentedFileOutput) GetS3() *S3Upload {
	if x, ok := x.GetOutput().(*SegmentedFileOutput_S3); ok {
		return x.S3
	}
	return nil
}

func (x *SegmentedFileOutput) GetGcp() *GCPUpload {
	if x, ok := x.GetOutput().(*SegmentedFileOutput_Gcp); ok {
		return x.Gcp
	}
	return nil
}

func (x *SegmentedFileOutput) GetAzure() *AzureBlobUpload {
	if x, ok := x.GetOutput().(*SegmentedFileOutput_Azure); ok {
		return x.Azure
	}
	return nil
}

func (x *SegmentedFileOutput) GetAliOSS() *AliOSSUpload {
	if x, ok := x.GetOutput().(*SegmentedFileOutput_AliOSS); ok {
		return x.AliOSS
	}
	return nil
}

type isSegmentedFileOutput_Output interface {
	isSegmentedFileOutput_Output()
}

type SegmentedFileOutput_S3 struct {
	S3 *S3Upload `protobuf:"bytes,5,opt,name=s3,proto3,oneof"`
}

type SegmentedFileOutput_Gcp struct {
	Gcp *GCPUpload `protobuf:"bytes,6,opt,name=gcp,proto3,oneof"`
}

type SegmentedFileOutput_Azure struct {
	Azure *AzureBlobUpload `protobuf:"bytes,7,opt,name=azure,proto3,oneof"`
}

type SegmentedFileOutput_AliOSS struct {
	AliOSS *AliOSSUpload `protobuf:"bytes,9,opt,name=aliOSS,proto3,oneof"`
}

func (*SegmentedFileOutput_S3) isSegmentedFileOutput_Output() {}

func (*SegmentedFileOutput_Gcp) isSegmentedFileOutput_Output() {}

func (*SegmentedFileOutput_Azure) isSegmentedFileOutput_Output() {}

func (*SegmentedFileOutput_AliOSS) isSegmentedFileOutput_Output() {}

type DirectFileOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filepath        string `protobuf:"bytes,1,opt,name=filepath,proto3" json:"filepath,omitempty"`                                       // see egress docs for templating (default {track_id}-{time})
	DisableManifest bool   `protobuf:"varint,5,opt,name=disable_manifest,json=disableManifest,proto3" json:"disable_manifest,omitempty"` // disable upload of manifest file (default false)
	// Types that are assignable to Output:
	//
	//	*DirectFileOutput_S3
	//	*DirectFileOutput_Gcp
	//	*DirectFileOutput_Azure
	//	*DirectFileOutput_AliOSS
	Output isDirectFileOutput_Output `protobuf_oneof:"output"`
}

func (x *DirectFileOutput) Reset() {
	*x = DirectFileOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectFileOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectFileOutput) ProtoMessage() {}

func (x *DirectFileOutput) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectFileOutput.ProtoReflect.Descriptor instead.
func (*DirectFileOutput) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{7}
}

func (x *DirectFileOutput) GetFilepath() string {
	if x != nil {
		return x.Filepath
	}
	return ""
}

func (x *DirectFileOutput) GetDisableManifest() bool {
	if x != nil {
		return x.DisableManifest
	}
	return false
}

func (m *DirectFileOutput) GetOutput() isDirectFileOutput_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *DirectFileOutput) GetS3() *S3Upload {
	if x, ok := x.GetOutput().(*DirectFileOutput_S3); ok {
		return x.S3
	}
	return nil
}

func (x *DirectFileOutput) GetGcp() *GCPUpload {
	if x, ok := x.GetOutput().(*DirectFileOutput_Gcp); ok {
		return x.Gcp
	}
	return nil
}

func (x *DirectFileOutput) GetAzure() *AzureBlobUpload {
	if x, ok := x.GetOutput().(*DirectFileOutput_Azure); ok {
		return x.Azure
	}
	return nil
}

func (x *DirectFileOutput) GetAliOSS() *AliOSSUpload {
	if x, ok := x.GetOutput().(*DirectFileOutput_AliOSS); ok {
		return x.AliOSS
	}
	return nil
}

type isDirectFileOutput_Output interface {
	isDirectFileOutput_Output()
}

type DirectFileOutput_S3 struct {
	S3 *S3Upload `protobuf:"bytes,2,opt,name=s3,proto3,oneof"`
}

type DirectFileOutput_Gcp struct {
	Gcp *GCPUpload `protobuf:"bytes,3,opt,name=gcp,proto3,oneof"`
}

type DirectFileOutput_Azure struct {
	Azure *AzureBlobUpload `protobuf:"bytes,4,opt,name=azure,proto3,oneof"`
}

type DirectFileOutput_AliOSS struct {
	AliOSS *AliOSSUpload `protobuf:"bytes,6,opt,name=aliOSS,proto3,oneof"`
}

func (*DirectFileOutput_S3) isDirectFileOutput_Output() {}

func (*DirectFileOutput_Gcp) isDirectFileOutput_Output() {}

func (*DirectFileOutput_Azure) isDirectFileOutput_Output() {}

func (*DirectFileOutput_AliOSS) isDirectFileOutput_Output() {}

type ImageOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CaptureInterval uint32          `protobuf:"varint,1,opt,name=capture_interval,json=captureInterval,proto3" json:"capture_interval,omitempty"`                           // in seconds (required)
	Width           int32           `protobuf:"varint,2,opt,name=width,proto3" json:"width,omitempty"`                                                                      // (optional, defaults to track width)
	Height          int32           `protobuf:"varint,3,opt,name=height,proto3" json:"height,omitempty"`                                                                    // (optional, defaults to track height)
	FilenamePrefix  string          `protobuf:"bytes,4,opt,name=filename_prefix,json=filenamePrefix,proto3" json:"filename_prefix,omitempty"`                               // (optional)
	FilenameSuffix  ImageFileSuffix `protobuf:"varint,5,opt,name=filename_suffix,json=filenameSuffix,proto3,enum=livekit.ImageFileSuffix" json:"filename_suffix,omitempty"` // (optional, default INDEX)
	ImageCodec      ImageCodec      `protobuf:"varint,6,opt,name=image_codec,json=imageCodec,proto3,enum=livekit.ImageCodec" json:"image_codec,omitempty"`                  // (optional)
	DisableManifest bool            `protobuf:"varint,7,opt,name=disable_manifest,json=disableManifest,proto3" json:"disable_manifest,omitempty"`                           // disable upload of manifest file (default false)
	// Types that are assignable to Output:
	//
	//	*ImageOutput_S3
	//	*ImageOutput_Gcp
	//	*ImageOutput_Azure
	//	*ImageOutput_AliOSS
	Output isImageOutput_Output `protobuf_oneof:"output"`
}

func (x *ImageOutput) Reset() {
	*x = ImageOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageOutput) ProtoMessage() {}

func (x *ImageOutput) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageOutput.ProtoReflect.Descriptor instead.
func (*ImageOutput) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{8}
}

func (x *ImageOutput) GetCaptureInterval() uint32 {
	if x != nil {
		return x.CaptureInterval
	}
	return 0
}

func (x *ImageOutput) GetWidth() int32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *ImageOutput) GetHeight() int32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *ImageOutput) GetFilenamePrefix() string {
	if x != nil {
		return x.FilenamePrefix
	}
	return ""
}

func (x *ImageOutput) GetFilenameSuffix() ImageFileSuffix {
	if x != nil {
		return x.FilenameSuffix
	}
	return ImageFileSuffix_IMAGE_SUFFIX_INDEX
}

func (x *ImageOutput) GetImageCodec() ImageCodec {
	if x != nil {
		return x.ImageCodec
	}
	return ImageCodec_IC_DEFAULT
}

func (x *ImageOutput) GetDisableManifest() bool {
	if x != nil {
		return x.DisableManifest
	}
	return false
}

func (m *ImageOutput) GetOutput() isImageOutput_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *ImageOutput) GetS3() *S3Upload {
	if x, ok := x.GetOutput().(*ImageOutput_S3); ok {
		return x.S3
	}
	return nil
}

func (x *ImageOutput) GetGcp() *GCPUpload {
	if x, ok := x.GetOutput().(*ImageOutput_Gcp); ok {
		return x.Gcp
	}
	return nil
}

func (x *ImageOutput) GetAzure() *AzureBlobUpload {
	if x, ok := x.GetOutput().(*ImageOutput_Azure); ok {
		return x.Azure
	}
	return nil
}

func (x *ImageOutput) GetAliOSS() *AliOSSUpload {
	if x, ok := x.GetOutput().(*ImageOutput_AliOSS); ok {
		return x.AliOSS
	}
	return nil
}

type isImageOutput_Output interface {
	isImageOutput_Output()
}

type ImageOutput_S3 struct {
	S3 *S3Upload `protobuf:"bytes,8,opt,name=s3,proto3,oneof"`
}

type ImageOutput_Gcp struct {
	Gcp *GCPUpload `protobuf:"bytes,9,opt,name=gcp,proto3,oneof"`
}

type ImageOutput_Azure struct {
	Azure *AzureBlobUpload `protobuf:"bytes,10,opt,name=azure,proto3,oneof"`
}

type ImageOutput_AliOSS struct {
	AliOSS *AliOSSUpload `protobuf:"bytes,11,opt,name=aliOSS,proto3,oneof"`
}

func (*ImageOutput_S3) isImageOutput_Output() {}

func (*ImageOutput_Gcp) isImageOutput_Output() {}

func (*ImageOutput_Azure) isImageOutput_Output() {}

func (*ImageOutput_AliOSS) isImageOutput_Output() {}

type S3Upload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccessKey      string            `protobuf:"bytes,1,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	Secret         string            `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	Region         string            `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	Endpoint       string            `protobuf:"bytes,4,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Bucket         string            `protobuf:"bytes,5,opt,name=bucket,proto3" json:"bucket,omitempty"`
	ForcePathStyle bool              `protobuf:"varint,6,opt,name=force_path_style,json=forcePathStyle,proto3" json:"force_path_style,omitempty"`
	Metadata       map[string]string `protobuf:"bytes,7,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Tagging        string            `protobuf:"bytes,8,opt,name=tagging,proto3" json:"tagging,omitempty"`
	// Content-Disposition header
	ContentDisposition string `protobuf:"bytes,9,opt,name=content_disposition,json=contentDisposition,proto3" json:"content_disposition,omitempty"`
}

func (x *S3Upload) Reset() {
	*x = S3Upload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *S3Upload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*S3Upload) ProtoMessage() {}

func (x *S3Upload) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use S3Upload.ProtoReflect.Descriptor instead.
func (*S3Upload) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{9}
}

func (x *S3Upload) GetAccessKey() string {
	if x != nil {
		return x.AccessKey
	}
	return ""
}

func (x *S3Upload) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *S3Upload) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *S3Upload) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *S3Upload) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *S3Upload) GetForcePathStyle() bool {
	if x != nil {
		return x.ForcePathStyle
	}
	return false
}

func (x *S3Upload) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *S3Upload) GetTagging() string {
	if x != nil {
		return x.Tagging
	}
	return ""
}

func (x *S3Upload) GetContentDisposition() string {
	if x != nil {
		return x.ContentDisposition
	}
	return ""
}

type GCPUpload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// service account credentials serialized in JSON "credentials.json"
	Credentials string `protobuf:"bytes,1,opt,name=credentials,proto3" json:"credentials,omitempty"`
	Bucket      string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *GCPUpload) Reset() {
	*x = GCPUpload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCPUpload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCPUpload) ProtoMessage() {}

func (x *GCPUpload) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCPUpload.ProtoReflect.Descriptor instead.
func (*GCPUpload) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{10}
}

func (x *GCPUpload) GetCredentials() string {
	if x != nil {
		return x.Credentials
	}
	return ""
}

func (x *GCPUpload) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

type AzureBlobUpload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccountName   string `protobuf:"bytes,1,opt,name=account_name,json=accountName,proto3" json:"account_name,omitempty"`
	AccountKey    string `protobuf:"bytes,2,opt,name=account_key,json=accountKey,proto3" json:"account_key,omitempty"`
	ContainerName string `protobuf:"bytes,3,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
}

func (x *AzureBlobUpload) Reset() {
	*x = AzureBlobUpload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureBlobUpload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureBlobUpload) ProtoMessage() {}

func (x *AzureBlobUpload) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureBlobUpload.ProtoReflect.Descriptor instead.
func (*AzureBlobUpload) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{11}
}

func (x *AzureBlobUpload) GetAccountName() string {
	if x != nil {
		return x.AccountName
	}
	return ""
}

func (x *AzureBlobUpload) GetAccountKey() string {
	if x != nil {
		return x.AccountKey
	}
	return ""
}

func (x *AzureBlobUpload) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

type AliOSSUpload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccessKey string `protobuf:"bytes,1,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	Secret    string `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	Region    string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	Endpoint  string `protobuf:"bytes,4,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Bucket    string `protobuf:"bytes,5,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *AliOSSUpload) Reset() {
	*x = AliOSSUpload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AliOSSUpload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AliOSSUpload) ProtoMessage() {}

func (x *AliOSSUpload) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AliOSSUpload.ProtoReflect.Descriptor instead.
func (*AliOSSUpload) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{12}
}

func (x *AliOSSUpload) GetAccessKey() string {
	if x != nil {
		return x.AccessKey
	}
	return ""
}

func (x *AliOSSUpload) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *AliOSSUpload) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AliOSSUpload) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *AliOSSUpload) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

type StreamOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Protocol StreamProtocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=livekit.StreamProtocol" json:"protocol,omitempty"` // required
	Urls     []string       `protobuf:"bytes,2,rep,name=urls,proto3" json:"urls,omitempty"`                                      // required
}

func (x *StreamOutput) Reset() {
	*x = StreamOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamOutput) ProtoMessage() {}

func (x *StreamOutput) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamOutput.ProtoReflect.Descriptor instead.
func (*StreamOutput) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{13}
}

func (x *StreamOutput) GetProtocol() StreamProtocol {
	if x != nil {
		return x.Protocol
	}
	return StreamProtocol_DEFAULT_PROTOCOL
}

func (x *StreamOutput) GetUrls() []string {
	if x != nil {
		return x.Urls
	}
	return nil
}

type EncodingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Width            int32      `protobuf:"varint,1,opt,name=width,proto3" json:"width,omitempty"`                                                     // (default 1920)
	Height           int32      `protobuf:"varint,2,opt,name=height,proto3" json:"height,omitempty"`                                                   // (default 1080)
	Depth            int32      `protobuf:"varint,3,opt,name=depth,proto3" json:"depth,omitempty"`                                                     // (default 24)
	Framerate        int32      `protobuf:"varint,4,opt,name=framerate,proto3" json:"framerate,omitempty"`                                             // (default 30)
	AudioCodec       AudioCodec `protobuf:"varint,5,opt,name=audio_codec,json=audioCodec,proto3,enum=livekit.AudioCodec" json:"audio_codec,omitempty"` // (default OPUS)
	AudioBitrate     int32      `protobuf:"varint,6,opt,name=audio_bitrate,json=audioBitrate,proto3" json:"audio_bitrate,omitempty"`                   // (default 128)
	AudioQuality     int32      `protobuf:"varint,11,opt,name=audio_quality,json=audioQuality,proto3" json:"audio_quality,omitempty"`                  // quality setting on audio encoder
	AudioFrequency   int32      `protobuf:"varint,7,opt,name=audio_frequency,json=audioFrequency,proto3" json:"audio_frequency,omitempty"`             // (default 44100)
	VideoCodec       VideoCodec `protobuf:"varint,8,opt,name=video_codec,json=videoCodec,proto3,enum=livekit.VideoCodec" json:"video_codec,omitempty"` // (default H264_MAIN)
	VideoBitrate     int32      `protobuf:"varint,9,opt,name=video_bitrate,json=videoBitrate,proto3" json:"video_bitrate,omitempty"`                   // (default 4500)
	VideoQuality     int32      `protobuf:"varint,12,opt,name=video_quality,json=videoQuality,proto3" json:"video_quality,omitempty"`                  // quality setting on video encoder
	KeyFrameInterval float64    `protobuf:"fixed64,10,opt,name=key_frame_interval,json=keyFrameInterval,proto3" json:"key_frame_interval,omitempty"`   // in seconds (default 4s for streaming, segment duration for segmented output, encoder default for files)
}

func (x *EncodingOptions) Reset() {
	*x = EncodingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncodingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncodingOptions) ProtoMessage() {}

func (x *EncodingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncodingOptions.ProtoReflect.Descriptor instead.
func (*EncodingOptions) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{14}
}

func (x *EncodingOptions) GetWidth() int32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *EncodingOptions) GetHeight() int32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *EncodingOptions) GetDepth() int32 {
	if x != nil {
		return x.Depth
	}
	return 0
}

func (x *EncodingOptions) GetFramerate() int32 {
	if x != nil {
		return x.Framerate
	}
	return 0
}

func (x *EncodingOptions) GetAudioCodec() AudioCodec {
	if x != nil {
		return x.AudioCodec
	}
	return AudioCodec_DEFAULT_AC
}

func (x *EncodingOptions) GetAudioBitrate() int32 {
	if x != nil {
		return x.AudioBitrate
	}
	return 0
}

func (x *EncodingOptions) GetAudioQuality() int32 {
	if x != nil {
		return x.AudioQuality
	}
	return 0
}

func (x *EncodingOptions) GetAudioFrequency() int32 {
	if x != nil {
		return x.AudioFrequency
	}
	return 0
}

func (x *EncodingOptions) GetVideoCodec() VideoCodec {
	if x != nil {
		return x.VideoCodec
	}
	return VideoCodec_DEFAULT_VC
}

func (x *EncodingOptions) GetVideoBitrate() int32 {
	if x != nil {
		return x.VideoBitrate
	}
	return 0
}

func (x *EncodingOptions) GetVideoQuality() int32 {
	if x != nil {
		return x.VideoQuality
	}
	return 0
}

func (x *EncodingOptions) GetKeyFrameInterval() float64 {
	if x != nil {
		return x.KeyFrameInterval
	}
	return 0
}

type UpdateLayoutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EgressId string `protobuf:"bytes,1,opt,name=egress_id,json=egressId,proto3" json:"egress_id,omitempty"`
	Layout   string `protobuf:"bytes,2,opt,name=layout,proto3" json:"layout,omitempty"`
}

func (x *UpdateLayoutRequest) Reset() {
	*x = UpdateLayoutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateLayoutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLayoutRequest) ProtoMessage() {}

func (x *UpdateLayoutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLayoutRequest.ProtoReflect.Descriptor instead.
func (*UpdateLayoutRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateLayoutRequest) GetEgressId() string {
	if x != nil {
		return x.EgressId
	}
	return ""
}

func (x *UpdateLayoutRequest) GetLayout() string {
	if x != nil {
		return x.Layout
	}
	return ""
}

type UpdateStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EgressId         string   `protobuf:"bytes,1,opt,name=egress_id,json=egressId,proto3" json:"egress_id,omitempty"`
	AddOutputUrls    []string `protobuf:"bytes,2,rep,name=add_output_urls,json=addOutputUrls,proto3" json:"add_output_urls,omitempty"`
	RemoveOutputUrls []string `protobuf:"bytes,3,rep,name=remove_output_urls,json=removeOutputUrls,proto3" json:"remove_output_urls,omitempty"`
}

func (x *UpdateStreamRequest) Reset() {
	*x = UpdateStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStreamRequest) ProtoMessage() {}

func (x *UpdateStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateStreamRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateStreamRequest) GetEgressId() string {
	if x != nil {
		return x.EgressId
	}
	return ""
}

func (x *UpdateStreamRequest) GetAddOutputUrls() []string {
	if x != nil {
		return x.AddOutputUrls
	}
	return nil
}

func (x *UpdateStreamRequest) GetRemoveOutputUrls() []string {
	if x != nil {
		return x.RemoveOutputUrls
	}
	return nil
}

type ListEgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RoomName string `protobuf:"bytes,1,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"` // (optional, filter by room name)
	EgressId string `protobuf:"bytes,2,opt,name=egress_id,json=egressId,proto3" json:"egress_id,omitempty"` // (optional, filter by egress ID)
	Active   bool   `protobuf:"varint,3,opt,name=active,proto3" json:"active,omitempty"`                    // (optional, list active egress only)
}

func (x *ListEgressRequest) Reset() {
	*x = ListEgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEgressRequest) ProtoMessage() {}

func (x *ListEgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEgressRequest.ProtoReflect.Descriptor instead.
func (*ListEgressRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{17}
}

func (x *ListEgressRequest) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *ListEgressRequest) GetEgressId() string {
	if x != nil {
		return x.EgressId
	}
	return ""
}

func (x *ListEgressRequest) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

type ListEgressResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Items []*EgressInfo `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListEgressResponse) Reset() {
	*x = ListEgressResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEgressResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEgressResponse) ProtoMessage() {}

func (x *ListEgressResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEgressResponse.ProtoReflect.Descriptor instead.
func (*ListEgressResponse) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{18}
}

func (x *ListEgressResponse) GetItems() []*EgressInfo {
	if x != nil {
		return x.Items
	}
	return nil
}

type StopEgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EgressId string `protobuf:"bytes,1,opt,name=egress_id,json=egressId,proto3" json:"egress_id,omitempty"`
}

func (x *StopEgressRequest) Reset() {
	*x = StopEgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopEgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopEgressRequest) ProtoMessage() {}

func (x *StopEgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopEgressRequest.ProtoReflect.Descriptor instead.
func (*StopEgressRequest) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{19}
}

func (x *StopEgressRequest) GetEgressId() string {
	if x != nil {
		return x.EgressId
	}
	return ""
}

type EgressInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EgressId  string       `protobuf:"bytes,1,opt,name=egress_id,json=egressId,proto3" json:"egress_id,omitempty"`
	RoomId    string       `protobuf:"bytes,2,opt,name=room_id,json=roomId,proto3" json:"room_id,omitempty"`
	RoomName  string       `protobuf:"bytes,13,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`
	Status    EgressStatus `protobuf:"varint,3,opt,name=status,proto3,enum=livekit.EgressStatus" json:"status,omitempty"`
	StartedAt int64        `protobuf:"varint,10,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	EndedAt   int64        `protobuf:"varint,11,opt,name=ended_at,json=endedAt,proto3" json:"ended_at,omitempty"`
	UpdatedAt int64        `protobuf:"varint,18,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	Error     string       `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	// Types that are assignable to Request:
	//
	//	*EgressInfo_RoomComposite
	//	*EgressInfo_Web
	//	*EgressInfo_Participant
	//	*EgressInfo_TrackComposite
	//	*EgressInfo_Track
	Request isEgressInfo_Request `protobuf_oneof:"request"`
	// Types that are assignable to Result:
	//
	//	*EgressInfo_Stream
	//	*EgressInfo_File
	//	*EgressInfo_Segments
	Result         isEgressInfo_Result `protobuf_oneof:"result"`
	StreamResults  []*StreamInfo       `protobuf:"bytes,15,rep,name=stream_results,json=streamResults,proto3" json:"stream_results,omitempty"`
	FileResults    []*FileInfo         `protobuf:"bytes,16,rep,name=file_results,json=fileResults,proto3" json:"file_results,omitempty"`
	SegmentResults []*SegmentsInfo     `protobuf:"bytes,17,rep,name=segment_results,json=segmentResults,proto3" json:"segment_results,omitempty"`
	ImageResults   []*ImagesInfo       `protobuf:"bytes,20,rep,name=image_results,json=imageResults,proto3" json:"image_results,omitempty"`
}

func (x *EgressInfo) Reset() {
	*x = EgressInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EgressInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressInfo) ProtoMessage() {}

func (x *EgressInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressInfo.ProtoReflect.Descriptor instead.
func (*EgressInfo) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{20}
}

func (x *EgressInfo) GetEgressId() string {
	if x != nil {
		return x.EgressId
	}
	return ""
}

func (x *EgressInfo) GetRoomId() string {
	if x != nil {
		return x.RoomId
	}
	return ""
}

func (x *EgressInfo) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *EgressInfo) GetStatus() EgressStatus {
	if x != nil {
		return x.Status
	}
	return EgressStatus_EGRESS_STARTING
}

func (x *EgressInfo) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *EgressInfo) GetEndedAt() int64 {
	if x != nil {
		return x.EndedAt
	}
	return 0
}

func (x *EgressInfo) GetUpdatedAt() int64 {
	if x != nil {
		return x.UpdatedAt
	}
	return 0
}

func (x *EgressInfo) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (m *EgressInfo) GetRequest() isEgressInfo_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *EgressInfo) GetRoomComposite() *RoomCompositeEgressRequest {
	if x, ok := x.GetRequest().(*EgressInfo_RoomComposite); ok {
		return x.RoomComposite
	}
	return nil
}

func (x *EgressInfo) GetWeb() *WebEgressRequest {
	if x, ok := x.GetRequest().(*EgressInfo_Web); ok {
		return x.Web
	}
	return nil
}

func (x *EgressInfo) GetParticipant() *ParticipantEgressRequest {
	if x, ok := x.GetRequest().(*EgressInfo_Participant); ok {
		return x.Participant
	}
	return nil
}

func (x *EgressInfo) GetTrackComposite() *TrackCompositeEgressRequest {
	if x, ok := x.GetRequest().(*EgressInfo_TrackComposite); ok {
		return x.TrackComposite
	}
	return nil
}

func (x *EgressInfo) GetTrack() *TrackEgressRequest {
	if x, ok := x.GetRequest().(*EgressInfo_Track); ok {
		return x.Track
	}
	return nil
}

func (m *EgressInfo) GetResult() isEgressInfo_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *EgressInfo) GetStream() *StreamInfoList {
	if x, ok := x.GetResult().(*EgressInfo_Stream); ok {
		return x.Stream
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *EgressInfo) GetFile() *FileInfo {
	if x, ok := x.GetResult().(*EgressInfo_File); ok {
		return x.File
	}
	return nil
}

// Deprecated: Marked as deprecated in livekit_egress.proto.
func (x *EgressInfo) GetSegments() *SegmentsInfo {
	if x, ok := x.GetResult().(*EgressInfo_Segments); ok {
		return x.Segments
	}
	return nil
}

func (x *EgressInfo) GetStreamResults() []*StreamInfo {
	if x != nil {
		return x.StreamResults
	}
	return nil
}

func (x *EgressInfo) GetFileResults() []*FileInfo {
	if x != nil {
		return x.FileResults
	}
	return nil
}

func (x *EgressInfo) GetSegmentResults() []*SegmentsInfo {
	if x != nil {
		return x.SegmentResults
	}
	return nil
}

func (x *EgressInfo) GetImageResults() []*ImagesInfo {
	if x != nil {
		return x.ImageResults
	}
	return nil
}

type isEgressInfo_Request interface {
	isEgressInfo_Request()
}

type EgressInfo_RoomComposite struct {
	RoomComposite *RoomCompositeEgressRequest `protobuf:"bytes,4,opt,name=room_composite,json=roomComposite,proto3,oneof"`
}

type EgressInfo_Web struct {
	Web *WebEgressRequest `protobuf:"bytes,14,opt,name=web,proto3,oneof"`
}

type EgressInfo_Participant struct {
	Participant *ParticipantEgressRequest `protobuf:"bytes,19,opt,name=participant,proto3,oneof"`
}

type EgressInfo_TrackComposite struct {
	TrackComposite *TrackCompositeEgressRequest `protobuf:"bytes,5,opt,name=track_composite,json=trackComposite,proto3,oneof"`
}

type EgressInfo_Track struct {
	Track *TrackEgressRequest `protobuf:"bytes,6,opt,name=track,proto3,oneof"`
}

func (*EgressInfo_RoomComposite) isEgressInfo_Request() {}

func (*EgressInfo_Web) isEgressInfo_Request() {}

func (*EgressInfo_Participant) isEgressInfo_Request() {}

func (*EgressInfo_TrackComposite) isEgressInfo_Request() {}

func (*EgressInfo_Track) isEgressInfo_Request() {}

type isEgressInfo_Result interface {
	isEgressInfo_Result()
}

type EgressInfo_Stream struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Stream *StreamInfoList `protobuf:"bytes,7,opt,name=stream,proto3,oneof"`
}

type EgressInfo_File struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	File *FileInfo `protobuf:"bytes,8,opt,name=file,proto3,oneof"`
}

type EgressInfo_Segments struct {
	// Deprecated: Marked as deprecated in livekit_egress.proto.
	Segments *SegmentsInfo `protobuf:"bytes,12,opt,name=segments,proto3,oneof"`
}

func (*EgressInfo_Stream) isEgressInfo_Result() {}

func (*EgressInfo_File) isEgressInfo_Result() {}

func (*EgressInfo_Segments) isEgressInfo_Result() {}

// Deprecated: Marked as deprecated in livekit_egress.proto.
type StreamInfoList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info []*StreamInfo `protobuf:"bytes,1,rep,name=info,proto3" json:"info,omitempty"`
}

func (x *StreamInfoList) Reset() {
	*x = StreamInfoList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamInfoList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamInfoList) ProtoMessage() {}

func (x *StreamInfoList) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamInfoList.ProtoReflect.Descriptor instead.
func (*StreamInfoList) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{21}
}

func (x *StreamInfoList) GetInfo() []*StreamInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

type StreamInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Url       string            `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	StartedAt int64             `protobuf:"varint,2,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	EndedAt   int64             `protobuf:"varint,3,opt,name=ended_at,json=endedAt,proto3" json:"ended_at,omitempty"`
	Duration  int64             `protobuf:"varint,4,opt,name=duration,proto3" json:"duration,omitempty"`
	Status    StreamInfo_Status `protobuf:"varint,5,opt,name=status,proto3,enum=livekit.StreamInfo_Status" json:"status,omitempty"`
	Error     string            `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *StreamInfo) Reset() {
	*x = StreamInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamInfo) ProtoMessage() {}

func (x *StreamInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamInfo.ProtoReflect.Descriptor instead.
func (*StreamInfo) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{22}
}

func (x *StreamInfo) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *StreamInfo) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *StreamInfo) GetEndedAt() int64 {
	if x != nil {
		return x.EndedAt
	}
	return 0
}

func (x *StreamInfo) GetDuration() int64 {
	if x != nil {
		return x.Duration
	}
	return 0
}

func (x *StreamInfo) GetStatus() StreamInfo_Status {
	if x != nil {
		return x.Status
	}
	return StreamInfo_ACTIVE
}

func (x *StreamInfo) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type FileInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filename  string `protobuf:"bytes,1,opt,name=filename,proto3" json:"filename,omitempty"`
	StartedAt int64  `protobuf:"varint,2,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	EndedAt   int64  `protobuf:"varint,3,opt,name=ended_at,json=endedAt,proto3" json:"ended_at,omitempty"`
	Duration  int64  `protobuf:"varint,6,opt,name=duration,proto3" json:"duration,omitempty"`
	Size      int64  `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	Location  string `protobuf:"bytes,5,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *FileInfo) Reset() {
	*x = FileInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileInfo) ProtoMessage() {}

func (x *FileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileInfo.ProtoReflect.Descriptor instead.
func (*FileInfo) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{23}
}

func (x *FileInfo) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *FileInfo) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *FileInfo) GetEndedAt() int64 {
	if x != nil {
		return x.EndedAt
	}
	return 0
}

func (x *FileInfo) GetDuration() int64 {
	if x != nil {
		return x.Duration
	}
	return 0
}

func (x *FileInfo) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *FileInfo) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

type SegmentsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PlaylistName         string `protobuf:"bytes,1,opt,name=playlist_name,json=playlistName,proto3" json:"playlist_name,omitempty"`
	LivePlaylistName     string `protobuf:"bytes,8,opt,name=live_playlist_name,json=livePlaylistName,proto3" json:"live_playlist_name,omitempty"`
	Duration             int64  `protobuf:"varint,2,opt,name=duration,proto3" json:"duration,omitempty"`
	Size                 int64  `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	PlaylistLocation     string `protobuf:"bytes,4,opt,name=playlist_location,json=playlistLocation,proto3" json:"playlist_location,omitempty"`
	LivePlaylistLocation string `protobuf:"bytes,9,opt,name=live_playlist_location,json=livePlaylistLocation,proto3" json:"live_playlist_location,omitempty"`
	SegmentCount         int64  `protobuf:"varint,5,opt,name=segment_count,json=segmentCount,proto3" json:"segment_count,omitempty"`
	StartedAt            int64  `protobuf:"varint,6,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	EndedAt              int64  `protobuf:"varint,7,opt,name=ended_at,json=endedAt,proto3" json:"ended_at,omitempty"`
}

func (x *SegmentsInfo) Reset() {
	*x = SegmentsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentsInfo) ProtoMessage() {}

func (x *SegmentsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentsInfo.ProtoReflect.Descriptor instead.
func (*SegmentsInfo) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{24}
}

func (x *SegmentsInfo) GetPlaylistName() string {
	if x != nil {
		return x.PlaylistName
	}
	return ""
}

func (x *SegmentsInfo) GetLivePlaylistName() string {
	if x != nil {
		return x.LivePlaylistName
	}
	return ""
}

func (x *SegmentsInfo) GetDuration() int64 {
	if x != nil {
		return x.Duration
	}
	return 0
}

func (x *SegmentsInfo) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *SegmentsInfo) GetPlaylistLocation() string {
	if x != nil {
		return x.PlaylistLocation
	}
	return ""
}

func (x *SegmentsInfo) GetLivePlaylistLocation() string {
	if x != nil {
		return x.LivePlaylistLocation
	}
	return ""
}

func (x *SegmentsInfo) GetSegmentCount() int64 {
	if x != nil {
		return x.SegmentCount
	}
	return 0
}

func (x *SegmentsInfo) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *SegmentsInfo) GetEndedAt() int64 {
	if x != nil {
		return x.EndedAt
	}
	return 0
}

type ImagesInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ImageCount int64 `protobuf:"varint,1,opt,name=image_count,json=imageCount,proto3" json:"image_count,omitempty"`
	StartedAt  int64 `protobuf:"varint,2,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	EndedAt    int64 `protobuf:"varint,3,opt,name=ended_at,json=endedAt,proto3" json:"ended_at,omitempty"`
}

func (x *ImagesInfo) Reset() {
	*x = ImagesInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImagesInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImagesInfo) ProtoMessage() {}

func (x *ImagesInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImagesInfo.ProtoReflect.Descriptor instead.
func (*ImagesInfo) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{25}
}

func (x *ImagesInfo) GetImageCount() int64 {
	if x != nil {
		return x.ImageCount
	}
	return 0
}

func (x *ImagesInfo) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *ImagesInfo) GetEndedAt() int64 {
	if x != nil {
		return x.EndedAt
	}
	return 0
}

type AutoParticipantEgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Options:
	//
	//	*AutoParticipantEgress_Preset
	//	*AutoParticipantEgress_Advanced
	Options        isAutoParticipantEgress_Options `protobuf_oneof:"options"`
	FileOutputs    []*EncodedFileOutput            `protobuf:"bytes,3,rep,name=file_outputs,json=fileOutputs,proto3" json:"file_outputs,omitempty"`
	SegmentOutputs []*SegmentedFileOutput          `protobuf:"bytes,4,rep,name=segment_outputs,json=segmentOutputs,proto3" json:"segment_outputs,omitempty"`
}

func (x *AutoParticipantEgress) Reset() {
	*x = AutoParticipantEgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoParticipantEgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoParticipantEgress) ProtoMessage() {}

func (x *AutoParticipantEgress) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoParticipantEgress.ProtoReflect.Descriptor instead.
func (*AutoParticipantEgress) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{26}
}

func (m *AutoParticipantEgress) GetOptions() isAutoParticipantEgress_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *AutoParticipantEgress) GetPreset() EncodingOptionsPreset {
	if x, ok := x.GetOptions().(*AutoParticipantEgress_Preset); ok {
		return x.Preset
	}
	return EncodingOptionsPreset_H264_720P_30
}

func (x *AutoParticipantEgress) GetAdvanced() *EncodingOptions {
	if x, ok := x.GetOptions().(*AutoParticipantEgress_Advanced); ok {
		return x.Advanced
	}
	return nil
}

func (x *AutoParticipantEgress) GetFileOutputs() []*EncodedFileOutput {
	if x != nil {
		return x.FileOutputs
	}
	return nil
}

func (x *AutoParticipantEgress) GetSegmentOutputs() []*SegmentedFileOutput {
	if x != nil {
		return x.SegmentOutputs
	}
	return nil
}

type isAutoParticipantEgress_Options interface {
	isAutoParticipantEgress_Options()
}

type AutoParticipantEgress_Preset struct {
	Preset EncodingOptionsPreset `protobuf:"varint,1,opt,name=preset,proto3,enum=livekit.EncodingOptionsPreset,oneof"` // (default H264_720P_30)
}

type AutoParticipantEgress_Advanced struct {
	Advanced *EncodingOptions `protobuf:"bytes,2,opt,name=advanced,proto3,oneof"` // (optional)
}

func (*AutoParticipantEgress_Preset) isAutoParticipantEgress_Options() {}

func (*AutoParticipantEgress_Advanced) isAutoParticipantEgress_Options() {}

type AutoTrackEgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filepath        string `protobuf:"bytes,1,opt,name=filepath,proto3" json:"filepath,omitempty"`                                       // see docs for templating (default {track_id}-{time})
	DisableManifest bool   `protobuf:"varint,5,opt,name=disable_manifest,json=disableManifest,proto3" json:"disable_manifest,omitempty"` // disables upload of json manifest file (default false)
	// Types that are assignable to Output:
	//
	//	*AutoTrackEgress_S3
	//	*AutoTrackEgress_Gcp
	//	*AutoTrackEgress_Azure
	Output isAutoTrackEgress_Output `protobuf_oneof:"output"`
}

func (x *AutoTrackEgress) Reset() {
	*x = AutoTrackEgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_egress_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoTrackEgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoTrackEgress) ProtoMessage() {}

func (x *AutoTrackEgress) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_egress_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoTrackEgress.ProtoReflect.Descriptor instead.
func (*AutoTrackEgress) Descriptor() ([]byte, []int) {
	return file_livekit_egress_proto_rawDescGZIP(), []int{27}
}

func (x *AutoTrackEgress) GetFilepath() string {
	if x != nil {
		return x.Filepath
	}
	return ""
}

func (x *AutoTrackEgress) GetDisableManifest() bool {
	if x != nil {
		return x.DisableManifest
	}
	return false
}

func (m *AutoTrackEgress) GetOutput() isAutoTrackEgress_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *AutoTrackEgress) GetS3() *S3Upload {
	if x, ok := x.GetOutput().(*AutoTrackEgress_S3); ok {
		return x.S3
	}
	return nil
}

func (x *AutoTrackEgress) GetGcp() *GCPUpload {
	if x, ok := x.GetOutput().(*AutoTrackEgress_Gcp); ok {
		return x.Gcp
	}
	return nil
}

func (x *AutoTrackEgress) GetAzure() *AzureBlobUpload {
	if x, ok := x.GetOutput().(*AutoTrackEgress_Azure); ok {
		return x.Azure
	}
	return nil
}

type isAutoTrackEgress_Output interface {
	isAutoTrackEgress_Output()
}

type AutoTrackEgress_S3 struct {
	S3 *S3Upload `protobuf:"bytes,2,opt,name=s3,proto3,oneof"`
}

type AutoTrackEgress_Gcp struct {
	Gcp *GCPUpload `protobuf:"bytes,3,opt,name=gcp,proto3,oneof"`
}

type AutoTrackEgress_Azure struct {
	Azure *AzureBlobUpload `protobuf:"bytes,4,opt,name=azure,proto3,oneof"`
}

func (*AutoTrackEgress_S3) isAutoTrackEgress_Output() {}

func (*AutoTrackEgress_Gcp) isAutoTrackEgress_Output() {}

func (*AutoTrackEgress_Azure) isAutoTrackEgress_Output() {}

var File_livekit_egress_proto protoreflect.FileDescriptor

var file_livekit_egress_proto_rawDesc = []byte{
	0x0a, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x1a,
	0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe8, 0x05, 0x0a, 0x1a, 0x52, 0x6f, 0x6f, 0x6d, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x26, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x42, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12,
	0x34, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x46,
	0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52,
	0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x02, 0x18, 0x01,
	0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3e, 0x0a, 0x08, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64,
	0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00,
	0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x0a, 0x06, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x48, 0x01, 0x52, 0x06, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x48, 0x01, 0x52, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x0c,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0b,
	0x66, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x0e, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x0f, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x12, 0x39, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xc1, 0x05, 0x0a, 0x10, 0x57, 0x65, 0x62, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x61, 0x77, 0x61, 0x69, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x12, 0x34, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x02, 0x18,
	0x01, 0x48, 0x00, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3e,
	0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x02,
	0x18, 0x01, 0x48, 0x00, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x38,
	0x0a, 0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x48, 0x01,
	0x52, 0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x12, 0x3d, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12,
	0x3c, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0d,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x45, 0x0a,
	0x0f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x42,
	0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf2, 0x03, 0x0a, 0x18, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x63,
	0x72, 0x65, 0x65, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0b, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x38, 0x0a,
	0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x48, 0x00, 0x52,
	0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x12,
	0x3d, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c,
	0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0d, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x0f,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x42, 0x09,
	0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb7, 0x05, 0x0a, 0x1b, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x45, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f,
	0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f,
	0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x72, 0x61, 0x63, 0x6b,
	0x49, 0x64, 0x12, 0x34, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x02, 0x18, 0x01,
	0x48, 0x00, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42,
	0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3e, 0x0a,
	0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x02, 0x18,
	0x01, 0x48, 0x00, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x0a,
	0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x48, 0x01, 0x52,
	0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x12,
	0x3d, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c,
	0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0d, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x0f,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x42, 0x08,
	0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xae, 0x01, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f,
	0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72,
	0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x49, 0x64, 0x12, 0x2f, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x04, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x77, 0x65, 0x62, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x77, 0x65,
	0x62, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x55, 0x72, 0x6c, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x22, 0xcb, 0x02, 0x0a, 0x11, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64,
	0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x35, 0x0a, 0x09, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x46,
	0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x70, 0x61, 0x74, 0x68, 0x12, 0x29, 0x0a,
	0x10, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x02, 0x73, 0x33, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53,
	0x33, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x02, 0x73, 0x33, 0x12, 0x26, 0x0a,
	0x03, 0x67, 0x63, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x47, 0x43, 0x50, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00,
	0x52, 0x03, 0x67, 0x63, 0x70, 0x12, 0x30, 0x0a, 0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00,
	0x52, 0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x61, 0x6c, 0x69, 0x4f, 0x53,
	0x53, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x41, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00,
	0x52, 0x06, 0x61, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x22, 0xa4, 0x04, 0x0a, 0x13, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64,
	0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x3a, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64,
	0x46, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12,
	0x23, 0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x79, 0x6c, 0x69, 0x73, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x6c, 0x61,
	0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x6c, 0x69, 0x76, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a,
	0x0f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12,
	0x23, 0x0a, 0x02, 0x73, 0x33, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x33, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00,
	0x52, 0x02, 0x73, 0x33, 0x12, 0x26, 0x0a, 0x03, 0x67, 0x63, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x47, 0x43, 0x50, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x03, 0x67, 0x63, 0x70, 0x12, 0x30, 0x0a, 0x05,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x12, 0x2f,
	0x0a, 0x06, 0x61, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x42,
	0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x93, 0x02, 0x0a, 0x10, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x1a,
	0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x70, 0x61, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x02, 0x73, 0x33, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x33, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x02, 0x73, 0x33, 0x12, 0x26, 0x0a, 0x03, 0x67, 0x63,
	0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x47, 0x43, 0x50, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x03, 0x67,
	0x63, 0x70, 0x12, 0x30, 0x0a, 0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x42, 0x6c, 0x6f, 0x62, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x05, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x61, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41,
	0x6c, 0x69, 0x4f, 0x53, 0x53, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x06, 0x61,
	0x6c, 0x69, 0x4f, 0x53, 0x53, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22,
	0xed, 0x03, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12,
	0x29, 0x0a, 0x10, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x63, 0x61, 0x70, 0x74, 0x75,
	0x72, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x12, 0x41, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x12, 0x34, 0x0a, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x52, 0x0a,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x02, 0x73, 0x33, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x33, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x02, 0x73, 0x33, 0x12, 0x26, 0x0a, 0x03, 0x67, 0x63,
	0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x47, 0x43, 0x50, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x03, 0x67,
	0x63, 0x70, 0x12, 0x30, 0x0a, 0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x42, 0x6c, 0x6f, 0x62, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x05, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x61, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41,
	0x6c, 0x69, 0x4f, 0x53, 0x53, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x06, 0x61,
	0x6c, 0x69, 0x4f, 0x53, 0x53, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22,
	0xfc, 0x02, 0x0a, 0x08, 0x53, 0x33, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x28, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x73, 0x74,
	0x79, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x33, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x61, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x12, 0x2f, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x45,
	0x0a, 0x09, 0x47, 0x43, 0x50, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x16, 0x0a,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x7c, 0x0a, 0x0f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c,
	0x6f, 0x62, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x25, 0x0a, 0x0e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x0c, 0x41, 0x6c, 0x69, 0x4f, 0x53, 0x53, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x57, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x33, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04,
	0x75, 0x72, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x6c, 0x73,
	0x22, 0xca, 0x03, 0x0a, 0x0f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x65, 0x70, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x64, 0x65, 0x70, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x64, 0x65, 0x63,
	0x52, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x42, 0x69, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12,
	0x34, 0x0a, 0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x52, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x43, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x62,
	0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x42, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12,
	0x2c, 0x0a, 0x12, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x6b, 0x65, 0x79,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0x4a, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49,
	0x64, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x22, 0x88, 0x01, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x26,
	0x0a, 0x0f, 0x61, 0x64, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x6c,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x64, 0x64, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x55, 0x72, 0x6c, 0x73, 0x22, 0x65, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f,
	0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f,
	0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x22, 0x3f, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x29, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x30, 0x0a, 0x11,
	0x53, 0x74, 0x6f, 0x70, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x64, 0x22, 0xe5,
	0x07, 0x0a, 0x0a, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a,
	0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x6f,
	0x6f, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x6f, 0x6f,
	0x6d, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x19,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4c,
	0x0a, 0x0e, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x45, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x72,
	0x6f, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x03,
	0x77, 0x65, 0x62, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x57, 0x65, 0x62, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x03, 0x77, 0x65, 0x62, 0x12, 0x45, 0x0a, 0x0b, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x65, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x12, 0x35, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x02, 0x18, 0x01, 0x48, 0x01, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x2b, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x02, 0x18, 0x01, 0x48, 0x01, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x08,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x02, 0x18, 0x01, 0x48, 0x01, 0x52, 0x08, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x34, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x0f, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x38, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x08, 0x0a, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x3d, 0x0a, 0x0e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x49, 0x6e, 0x66, 0x6f, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66,
	0x6f, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xee, 0x01, 0x0a, 0x0a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x2e, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xac, 0x01, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x19,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd3, 0x02, 0x0a, 0x0c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x79, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70,
	0x6c, 0x61, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6c,
	0x69, 0x76, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x69, 0x76, 0x65, 0x50, 0x6c, 0x61,
	0x79, 0x6c, 0x69, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x6c, 0x61,
	0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x6c, 0x61, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x70,
	0x6c, 0x61, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x50, 0x6c, 0x61, 0x79,
	0x6c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x41, 0x74, 0x22, 0x67, 0x0a, 0x0a, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x65, 0x64, 0x41, 0x74, 0x22, 0x9a, 0x02, 0x0a, 0x15, 0x41, 0x75, 0x74, 0x6f, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x38,
	0x0a, 0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x48, 0x00,
	0x52, 0x06, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x12, 0x3d, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12,
	0x45, 0x0a, 0x0f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0xe1, 0x01, 0x0a, 0x0f, 0x41, 0x75, 0x74, 0x6f, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x70, 0x61, 0x74,
	0x68, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x02,
	0x73, 0x33, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x53, 0x33, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x02, 0x73,
	0x33, 0x12, 0x26, 0x0a, 0x03, 0x67, 0x63, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x47, 0x43, 0x50, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x48, 0x00, 0x52, 0x03, 0x67, 0x63, 0x70, 0x12, 0x30, 0x0a, 0x05, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x48, 0x00, 0x52, 0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x2a, 0x39, 0x0a, 0x0f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64,
	0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x46, 0x41,
	0x55, 0x4c, 0x54, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x4d, 0x50, 0x34, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x47, 0x47, 0x10, 0x02,
	0x2a, 0x4e, 0x0a, 0x15, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x45, 0x46,
	0x41, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x47, 0x4d, 0x45, 0x4e, 0x54, 0x45, 0x44, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x48, 0x4c, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10, 0x01,
	0x2a, 0x2f, 0x0a, 0x13, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x44, 0x45, 0x58,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10,
	0x01, 0x2a, 0x45, 0x0a, 0x0f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x55,
	0x46, 0x46, 0x49, 0x58, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x55, 0x46, 0x46, 0x49, 0x58, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x01, 0x2a, 0x30, 0x0a, 0x0e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45,
	0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x52, 0x54, 0x4d, 0x50, 0x10, 0x01, 0x2a, 0xcf, 0x01, 0x0a, 0x15, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x32, 0x36, 0x34, 0x5f, 0x37, 0x32, 0x30,
	0x50, 0x5f, 0x33, 0x30, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x32, 0x36, 0x34, 0x5f, 0x37,
	0x32, 0x30, 0x50, 0x5f, 0x36, 0x30, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x48, 0x32, 0x36, 0x34,
	0x5f, 0x31, 0x30, 0x38, 0x30, 0x50, 0x5f, 0x33, 0x30, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x48,
	0x32, 0x36, 0x34, 0x5f, 0x31, 0x30, 0x38, 0x30, 0x50, 0x5f, 0x36, 0x30, 0x10, 0x03, 0x12, 0x19,
	0x0a, 0x15, 0x50, 0x4f, 0x52, 0x54, 0x52, 0x41, 0x49, 0x54, 0x5f, 0x48, 0x32, 0x36, 0x34, 0x5f,
	0x37, 0x32, 0x30, 0x50, 0x5f, 0x33, 0x30, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x4f, 0x52,
	0x54, 0x52, 0x41, 0x49, 0x54, 0x5f, 0x48, 0x32, 0x36, 0x34, 0x5f, 0x37, 0x32, 0x30, 0x50, 0x5f,
	0x36, 0x30, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x4f, 0x52, 0x54, 0x52, 0x41, 0x49, 0x54,
	0x5f, 0x48, 0x32, 0x36, 0x34, 0x5f, 0x31, 0x30, 0x38, 0x30, 0x50, 0x5f, 0x33, 0x30, 0x10, 0x06,
	0x12, 0x1a, 0x0a, 0x16, 0x50, 0x4f, 0x52, 0x54, 0x52, 0x41, 0x49, 0x54, 0x5f, 0x48, 0x32, 0x36,
	0x34, 0x5f, 0x31, 0x30, 0x38, 0x30, 0x50, 0x5f, 0x36, 0x30, 0x10, 0x07, 0x2a, 0x9f, 0x01, 0x0a,
	0x0c, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x13, 0x0a,
	0x0f, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x47, 0x52, 0x45,
	0x53, 0x53, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x11, 0x0a,
	0x0d, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x12, 0x0a, 0x0e, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x41, 0x42, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x4c,
	0x49, 0x4d, 0x49, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x43, 0x48, 0x45, 0x44, 0x10, 0x06, 0x32, 0x9c,
	0x05, 0x0a, 0x06, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54, 0x0a, 0x18, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x23, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x52, 0x6f, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x45, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x40, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x57, 0x65, 0x62, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x19, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x57, 0x65, 0x62, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x50, 0x0a, 0x16, 0x53, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x21, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x56, 0x0a, 0x19, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x72, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x24, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x44, 0x0a, 0x10, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x41, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x12, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x41, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d,
	0x0a, 0x0a, 0x53, 0x74, 0x6f, 0x70, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1a, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x46, 0x5a,
	0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x2e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x3a, 0x3a,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_egress_proto_rawDescOnce sync.Once
	file_livekit_egress_proto_rawDescData = file_livekit_egress_proto_rawDesc
)

func file_livekit_egress_proto_rawDescGZIP() []byte {
	file_livekit_egress_proto_rawDescOnce.Do(func() {
		file_livekit_egress_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_egress_proto_rawDescData)
	})
	return file_livekit_egress_proto_rawDescData
}

var file_livekit_egress_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_livekit_egress_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_livekit_egress_proto_goTypes = []interface{}{
	(EncodedFileType)(0),                // 0: livekit.EncodedFileType
	(SegmentedFileProtocol)(0),          // 1: livekit.SegmentedFileProtocol
	(SegmentedFileSuffix)(0),            // 2: livekit.SegmentedFileSuffix
	(ImageFileSuffix)(0),                // 3: livekit.ImageFileSuffix
	(StreamProtocol)(0),                 // 4: livekit.StreamProtocol
	(EncodingOptionsPreset)(0),          // 5: livekit.EncodingOptionsPreset
	(EgressStatus)(0),                   // 6: livekit.EgressStatus
	(StreamInfo_Status)(0),              // 7: livekit.StreamInfo.Status
	(*RoomCompositeEgressRequest)(nil),  // 8: livekit.RoomCompositeEgressRequest
	(*WebEgressRequest)(nil),            // 9: livekit.WebEgressRequest
	(*ParticipantEgressRequest)(nil),    // 10: livekit.ParticipantEgressRequest
	(*TrackCompositeEgressRequest)(nil), // 11: livekit.TrackCompositeEgressRequest
	(*TrackEgressRequest)(nil),          // 12: livekit.TrackEgressRequest
	(*EncodedFileOutput)(nil),           // 13: livekit.EncodedFileOutput
	(*SegmentedFileOutput)(nil),         // 14: livekit.SegmentedFileOutput
	(*DirectFileOutput)(nil),            // 15: livekit.DirectFileOutput
	(*ImageOutput)(nil),                 // 16: livekit.ImageOutput
	(*S3Upload)(nil),                    // 17: livekit.S3Upload
	(*GCPUpload)(nil),                   // 18: livekit.GCPUpload
	(*AzureBlobUpload)(nil),             // 19: livekit.AzureBlobUpload
	(*AliOSSUpload)(nil),                // 20: livekit.AliOSSUpload
	(*StreamOutput)(nil),                // 21: livekit.StreamOutput
	(*EncodingOptions)(nil),             // 22: livekit.EncodingOptions
	(*UpdateLayoutRequest)(nil),         // 23: livekit.UpdateLayoutRequest
	(*UpdateStreamRequest)(nil),         // 24: livekit.UpdateStreamRequest
	(*ListEgressRequest)(nil),           // 25: livekit.ListEgressRequest
	(*ListEgressResponse)(nil),          // 26: livekit.ListEgressResponse
	(*StopEgressRequest)(nil),           // 27: livekit.StopEgressRequest
	(*EgressInfo)(nil),                  // 28: livekit.EgressInfo
	(*StreamInfoList)(nil),              // 29: livekit.StreamInfoList
	(*StreamInfo)(nil),                  // 30: livekit.StreamInfo
	(*FileInfo)(nil),                    // 31: livekit.FileInfo
	(*SegmentsInfo)(nil),                // 32: livekit.SegmentsInfo
	(*ImagesInfo)(nil),                  // 33: livekit.ImagesInfo
	(*AutoParticipantEgress)(nil),       // 34: livekit.AutoParticipantEgress
	(*AutoTrackEgress)(nil),             // 35: livekit.AutoTrackEgress
	nil,                                 // 36: livekit.S3Upload.MetadataEntry
	(ImageCodec)(0),                     // 37: livekit.ImageCodec
	(AudioCodec)(0),                     // 38: livekit.AudioCodec
	(VideoCodec)(0),                     // 39: livekit.VideoCodec
}
var file_livekit_egress_proto_depIdxs = []int32{
	13, // 0: livekit.RoomCompositeEgressRequest.file:type_name -> livekit.EncodedFileOutput
	21, // 1: livekit.RoomCompositeEgressRequest.stream:type_name -> livekit.StreamOutput
	14, // 2: livekit.RoomCompositeEgressRequest.segments:type_name -> livekit.SegmentedFileOutput
	5,  // 3: livekit.RoomCompositeEgressRequest.preset:type_name -> livekit.EncodingOptionsPreset
	22, // 4: livekit.RoomCompositeEgressRequest.advanced:type_name -> livekit.EncodingOptions
	13, // 5: livekit.RoomCompositeEgressRequest.file_outputs:type_name -> livekit.EncodedFileOutput
	21, // 6: livekit.RoomCompositeEgressRequest.stream_outputs:type_name -> livekit.StreamOutput
	14, // 7: livekit.RoomCompositeEgressRequest.segment_outputs:type_name -> livekit.SegmentedFileOutput
	16, // 8: livekit.RoomCompositeEgressRequest.image_outputs:type_name -> livekit.ImageOutput
	13, // 9: livekit.WebEgressRequest.file:type_name -> livekit.EncodedFileOutput
	21, // 10: livekit.WebEgressRequest.stream:type_name -> livekit.StreamOutput
	14, // 11: livekit.WebEgressRequest.segments:type_name -> livekit.SegmentedFileOutput
	5,  // 12: livekit.WebEgressRequest.preset:type_name -> livekit.EncodingOptionsPreset
	22, // 13: livekit.WebEgressRequest.advanced:type_name -> livekit.EncodingOptions
	13, // 14: livekit.WebEgressRequest.file_outputs:type_name -> livekit.EncodedFileOutput
	21, // 15: livekit.WebEgressRequest.stream_outputs:type_name -> livekit.StreamOutput
	14, // 16: livekit.WebEgressRequest.segment_outputs:type_name -> livekit.SegmentedFileOutput
	16, // 17: livekit.WebEgressRequest.image_outputs:type_name -> livekit.ImageOutput
	5,  // 18: livekit.ParticipantEgressRequest.preset:type_name -> livekit.EncodingOptionsPreset
	22, // 19: livekit.ParticipantEgressRequest.advanced:type_name -> livekit.EncodingOptions
	13, // 20: livekit.ParticipantEgressRequest.file_outputs:type_name -> livekit.EncodedFileOutput
	21, // 21: livekit.ParticipantEgressRequest.stream_outputs:type_name -> livekit.StreamOutput
	14, // 22: livekit.ParticipantEgressRequest.segment_outputs:type_name -> livekit.SegmentedFileOutput
	16, // 23: livekit.ParticipantEgressRequest.image_outputs:type_name -> livekit.ImageOutput
	13, // 24: livekit.TrackCompositeEgressRequest.file:type_name -> livekit.EncodedFileOutput
	21, // 25: livekit.TrackCompositeEgressRequest.stream:type_name -> livekit.StreamOutput
	14, // 26: livekit.TrackCompositeEgressRequest.segments:type_name -> livekit.SegmentedFileOutput
	5,  // 27: livekit.TrackCompositeEgressRequest.preset:type_name -> livekit.EncodingOptionsPreset
	22, // 28: livekit.TrackCompositeEgressRequest.advanced:type_name -> livekit.EncodingOptions
	13, // 29: livekit.TrackCompositeEgressRequest.file_outputs:type_name -> livekit.EncodedFileOutput
	21, // 30: livekit.TrackCompositeEgressRequest.stream_outputs:type_name -> livekit.StreamOutput
	14, // 31: livekit.TrackCompositeEgressRequest.segment_outputs:type_name -> livekit.SegmentedFileOutput
	16, // 32: livekit.TrackCompositeEgressRequest.image_outputs:type_name -> livekit.ImageOutput
	15, // 33: livekit.TrackEgressRequest.file:type_name -> livekit.DirectFileOutput
	0,  // 34: livekit.EncodedFileOutput.file_type:type_name -> livekit.EncodedFileType
	17, // 35: livekit.EncodedFileOutput.s3:type_name -> livekit.S3Upload
	18, // 36: livekit.EncodedFileOutput.gcp:type_name -> livekit.GCPUpload
	19, // 37: livekit.EncodedFileOutput.azure:type_name -> livekit.AzureBlobUpload
	20, // 38: livekit.EncodedFileOutput.aliOSS:type_name -> livekit.AliOSSUpload
	1,  // 39: livekit.SegmentedFileOutput.protocol:type_name -> livekit.SegmentedFileProtocol
	2,  // 40: livekit.SegmentedFileOutput.filename_suffix:type_name -> livekit.SegmentedFileSuffix
	17, // 41: livekit.SegmentedFileOutput.s3:type_name -> livekit.S3Upload
	18, // 42: livekit.SegmentedFileOutput.gcp:type_name -> livekit.GCPUpload
	19, // 43: livekit.SegmentedFileOutput.azure:type_name -> livekit.AzureBlobUpload
	20, // 44: livekit.SegmentedFileOutput.aliOSS:type_name -> livekit.AliOSSUpload
	17, // 45: livekit.DirectFileOutput.s3:type_name -> livekit.S3Upload
	18, // 46: livekit.DirectFileOutput.gcp:type_name -> livekit.GCPUpload
	19, // 47: livekit.DirectFileOutput.azure:type_name -> livekit.AzureBlobUpload
	20, // 48: livekit.DirectFileOutput.aliOSS:type_name -> livekit.AliOSSUpload
	3,  // 49: livekit.ImageOutput.filename_suffix:type_name -> livekit.ImageFileSuffix
	37, // 50: livekit.ImageOutput.image_codec:type_name -> livekit.ImageCodec
	17, // 51: livekit.ImageOutput.s3:type_name -> livekit.S3Upload
	18, // 52: livekit.ImageOutput.gcp:type_name -> livekit.GCPUpload
	19, // 53: livekit.ImageOutput.azure:type_name -> livekit.AzureBlobUpload
	20, // 54: livekit.ImageOutput.aliOSS:type_name -> livekit.AliOSSUpload
	36, // 55: livekit.S3Upload.metadata:type_name -> livekit.S3Upload.MetadataEntry
	4,  // 56: livekit.StreamOutput.protocol:type_name -> livekit.StreamProtocol
	38, // 57: livekit.EncodingOptions.audio_codec:type_name -> livekit.AudioCodec
	39, // 58: livekit.EncodingOptions.video_codec:type_name -> livekit.VideoCodec
	28, // 59: livekit.ListEgressResponse.items:type_name -> livekit.EgressInfo
	6,  // 60: livekit.EgressInfo.status:type_name -> livekit.EgressStatus
	8,  // 61: livekit.EgressInfo.room_composite:type_name -> livekit.RoomCompositeEgressRequest
	9,  // 62: livekit.EgressInfo.web:type_name -> livekit.WebEgressRequest
	10, // 63: livekit.EgressInfo.participant:type_name -> livekit.ParticipantEgressRequest
	11, // 64: livekit.EgressInfo.track_composite:type_name -> livekit.TrackCompositeEgressRequest
	12, // 65: livekit.EgressInfo.track:type_name -> livekit.TrackEgressRequest
	29, // 66: livekit.EgressInfo.stream:type_name -> livekit.StreamInfoList
	31, // 67: livekit.EgressInfo.file:type_name -> livekit.FileInfo
	32, // 68: livekit.EgressInfo.segments:type_name -> livekit.SegmentsInfo
	30, // 69: livekit.EgressInfo.stream_results:type_name -> livekit.StreamInfo
	31, // 70: livekit.EgressInfo.file_results:type_name -> livekit.FileInfo
	32, // 71: livekit.EgressInfo.segment_results:type_name -> livekit.SegmentsInfo
	33, // 72: livekit.EgressInfo.image_results:type_name -> livekit.ImagesInfo
	30, // 73: livekit.StreamInfoList.info:type_name -> livekit.StreamInfo
	7,  // 74: livekit.StreamInfo.status:type_name -> livekit.StreamInfo.Status
	5,  // 75: livekit.AutoParticipantEgress.preset:type_name -> livekit.EncodingOptionsPreset
	22, // 76: livekit.AutoParticipantEgress.advanced:type_name -> livekit.EncodingOptions
	13, // 77: livekit.AutoParticipantEgress.file_outputs:type_name -> livekit.EncodedFileOutput
	14, // 78: livekit.AutoParticipantEgress.segment_outputs:type_name -> livekit.SegmentedFileOutput
	17, // 79: livekit.AutoTrackEgress.s3:type_name -> livekit.S3Upload
	18, // 80: livekit.AutoTrackEgress.gcp:type_name -> livekit.GCPUpload
	19, // 81: livekit.AutoTrackEgress.azure:type_name -> livekit.AzureBlobUpload
	8,  // 82: livekit.Egress.StartRoomCompositeEgress:input_type -> livekit.RoomCompositeEgressRequest
	9,  // 83: livekit.Egress.StartWebEgress:input_type -> livekit.WebEgressRequest
	10, // 84: livekit.Egress.StartParticipantEgress:input_type -> livekit.ParticipantEgressRequest
	11, // 85: livekit.Egress.StartTrackCompositeEgress:input_type -> livekit.TrackCompositeEgressRequest
	12, // 86: livekit.Egress.StartTrackEgress:input_type -> livekit.TrackEgressRequest
	23, // 87: livekit.Egress.UpdateLayout:input_type -> livekit.UpdateLayoutRequest
	24, // 88: livekit.Egress.UpdateStream:input_type -> livekit.UpdateStreamRequest
	25, // 89: livekit.Egress.ListEgress:input_type -> livekit.ListEgressRequest
	27, // 90: livekit.Egress.StopEgress:input_type -> livekit.StopEgressRequest
	28, // 91: livekit.Egress.StartRoomCompositeEgress:output_type -> livekit.EgressInfo
	28, // 92: livekit.Egress.StartWebEgress:output_type -> livekit.EgressInfo
	28, // 93: livekit.Egress.StartParticipantEgress:output_type -> livekit.EgressInfo
	28, // 94: livekit.Egress.StartTrackCompositeEgress:output_type -> livekit.EgressInfo
	28, // 95: livekit.Egress.StartTrackEgress:output_type -> livekit.EgressInfo
	28, // 96: livekit.Egress.UpdateLayout:output_type -> livekit.EgressInfo
	28, // 97: livekit.Egress.UpdateStream:output_type -> livekit.EgressInfo
	26, // 98: livekit.Egress.ListEgress:output_type -> livekit.ListEgressResponse
	28, // 99: livekit.Egress.StopEgress:output_type -> livekit.EgressInfo
	91, // [91:100] is the sub-list for method output_type
	82, // [82:91] is the sub-list for method input_type
	82, // [82:82] is the sub-list for extension type_name
	82, // [82:82] is the sub-list for extension extendee
	0,  // [0:82] is the sub-list for field type_name
}

func init() { file_livekit_egress_proto_init() }
func file_livekit_egress_proto_init() {
	if File_livekit_egress_proto != nil {
		return
	}
	file_livekit_models_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_livekit_egress_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoomCompositeEgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebEgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParticipantEgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrackCompositeEgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrackEgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncodedFileOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentedFileOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectFileOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*S3Upload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GCPUpload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureBlobUpload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AliOSSUpload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncodingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateLayoutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEgressResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopEgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EgressInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamInfoList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImagesInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoParticipantEgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_egress_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoTrackEgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_livekit_egress_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*RoomCompositeEgressRequest_File)(nil),
		(*RoomCompositeEgressRequest_Stream)(nil),
		(*RoomCompositeEgressRequest_Segments)(nil),
		(*RoomCompositeEgressRequest_Preset)(nil),
		(*RoomCompositeEgressRequest_Advanced)(nil),
	}
	file_livekit_egress_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*WebEgressRequest_File)(nil),
		(*WebEgressRequest_Stream)(nil),
		(*WebEgressRequest_Segments)(nil),
		(*WebEgressRequest_Preset)(nil),
		(*WebEgressRequest_Advanced)(nil),
	}
	file_livekit_egress_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ParticipantEgressRequest_Preset)(nil),
		(*ParticipantEgressRequest_Advanced)(nil),
	}
	file_livekit_egress_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*TrackCompositeEgressRequest_File)(nil),
		(*TrackCompositeEgressRequest_Stream)(nil),
		(*TrackCompositeEgressRequest_Segments)(nil),
		(*TrackCompositeEgressRequest_Preset)(nil),
		(*TrackCompositeEgressRequest_Advanced)(nil),
	}
	file_livekit_egress_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*TrackEgressRequest_File)(nil),
		(*TrackEgressRequest_WebsocketUrl)(nil),
	}
	file_livekit_egress_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*EncodedFileOutput_S3)(nil),
		(*EncodedFileOutput_Gcp)(nil),
		(*EncodedFileOutput_Azure)(nil),
		(*EncodedFileOutput_AliOSS)(nil),
	}
	file_livekit_egress_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*SegmentedFileOutput_S3)(nil),
		(*SegmentedFileOutput_Gcp)(nil),
		(*SegmentedFileOutput_Azure)(nil),
		(*SegmentedFileOutput_AliOSS)(nil),
	}
	file_livekit_egress_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*DirectFileOutput_S3)(nil),
		(*DirectFileOutput_Gcp)(nil),
		(*DirectFileOutput_Azure)(nil),
		(*DirectFileOutput_AliOSS)(nil),
	}
	file_livekit_egress_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ImageOutput_S3)(nil),
		(*ImageOutput_Gcp)(nil),
		(*ImageOutput_Azure)(nil),
		(*ImageOutput_AliOSS)(nil),
	}
	file_livekit_egress_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*EgressInfo_RoomComposite)(nil),
		(*EgressInfo_Web)(nil),
		(*EgressInfo_Participant)(nil),
		(*EgressInfo_TrackComposite)(nil),
		(*EgressInfo_Track)(nil),
		(*EgressInfo_Stream)(nil),
		(*EgressInfo_File)(nil),
		(*EgressInfo_Segments)(nil),
	}
	file_livekit_egress_proto_msgTypes[26].OneofWrappers = []interface{}{
		(*AutoParticipantEgress_Preset)(nil),
		(*AutoParticipantEgress_Advanced)(nil),
	}
	file_livekit_egress_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*AutoTrackEgress_S3)(nil),
		(*AutoTrackEgress_Gcp)(nil),
		(*AutoTrackEgress_Azure)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_egress_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_livekit_egress_proto_goTypes,
		DependencyIndexes: file_livekit_egress_proto_depIdxs,
		EnumInfos:         file_livekit_egress_proto_enumTypes,
		MessageInfos:      file_livekit_egress_proto_msgTypes,
	}.Build()
	File_livekit_egress_proto = out.File
	file_livekit_egress_proto_rawDesc = nil
	file_livekit_egress_proto_goTypes = nil
	file_livekit_egress_proto_depIdxs = nil
}
