// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the format and S3 location of the parallel data input file.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ParallelDataConfig {
    /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same Region as the API endpoint you are calling.</p>
    pub s3_uri: ::std::option::Option<::std::string::String>,
    /// <p>The format of the parallel data input file.</p>
    pub format: ::std::option::Option<crate::types::ParallelDataFormat>,
}
impl ParallelDataConfig {
    /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same Region as the API endpoint you are calling.</p>
    pub fn s3_uri(&self) -> ::std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>The format of the parallel data input file.</p>
    pub fn format(&self) -> ::std::option::Option<&crate::types::ParallelDataFormat> {
        self.format.as_ref()
    }
}
impl ParallelDataConfig {
    /// Creates a new builder-style object to manufacture [`ParallelDataConfig`](crate::types::ParallelDataConfig).
    pub fn builder() -> crate::types::builders::ParallelDataConfigBuilder {
        crate::types::builders::ParallelDataConfigBuilder::default()
    }
}

/// A builder for [`ParallelDataConfig`](crate::types::ParallelDataConfig).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ParallelDataConfigBuilder {
    pub(crate) s3_uri: ::std::option::Option<::std::string::String>,
    pub(crate) format: ::std::option::Option<crate::types::ParallelDataFormat>,
}
impl ParallelDataConfigBuilder {
    /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same Region as the API endpoint you are calling.</p>
    pub fn s3_uri(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.s3_uri = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same Region as the API endpoint you are calling.</p>
    pub fn set_s3_uri(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.s3_uri = input;
        self
    }
    /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same Region as the API endpoint you are calling.</p>
    pub fn get_s3_uri(&self) -> &::std::option::Option<::std::string::String> {
        &self.s3_uri
    }
    /// <p>The format of the parallel data input file.</p>
    pub fn format(mut self, input: crate::types::ParallelDataFormat) -> Self {
        self.format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The format of the parallel data input file.</p>
    pub fn set_format(mut self, input: ::std::option::Option<crate::types::ParallelDataFormat>) -> Self {
        self.format = input;
        self
    }
    /// <p>The format of the parallel data input file.</p>
    pub fn get_format(&self) -> &::std::option::Option<crate::types::ParallelDataFormat> {
        &self.format
    }
    /// Consumes the builder and constructs a [`ParallelDataConfig`](crate::types::ParallelDataConfig).
    pub fn build(self) -> crate::types::ParallelDataConfig {
        crate::types::ParallelDataConfig {
            s3_uri: self.s3_uri,
            format: self.format,
        }
    }
}
