// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TranslateTextInput {
    /// <p>The text to translate. The text string can be a maximum of 10,000 bytes long. Depending on your character set, this may be fewer than 10,000 characters.</p>
    pub text: ::std::option::Option<::std::string::String>,
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub terminology_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The language code for the language of the source text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateText</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    pub source_language_code: ::std::option::Option<::std::string::String>,
    /// <p>The language code requested for the language of the target text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub target_language_code: ::std::option::Option<::std::string::String>,
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: reduces the length of the translated output for most translations.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub settings: ::std::option::Option<crate::types::TranslationSettings>,
}
impl TranslateTextInput {
    /// <p>The text to translate. The text string can be a maximum of 10,000 bytes long. Depending on your character set, this may be fewer than 10,000 characters.</p>
    pub fn text(&self) -> ::std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.terminology_names.is_none()`.
    pub fn terminology_names(&self) -> &[::std::string::String] {
        self.terminology_names.as_deref().unwrap_or_default()
    }
    /// <p>The language code for the language of the source text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateText</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    pub fn source_language_code(&self) -> ::std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language code requested for the language of the target text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn target_language_code(&self) -> ::std::option::Option<&str> {
        self.target_language_code.as_deref()
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: reduces the length of the translated output for most translations.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn settings(&self) -> ::std::option::Option<&crate::types::TranslationSettings> {
        self.settings.as_ref()
    }
}
impl TranslateTextInput {
    /// Creates a new builder-style object to manufacture [`TranslateTextInput`](crate::operation::translate_text::TranslateTextInput).
    pub fn builder() -> crate::operation::translate_text::builders::TranslateTextInputBuilder {
        crate::operation::translate_text::builders::TranslateTextInputBuilder::default()
    }
}

/// A builder for [`TranslateTextInput`](crate::operation::translate_text::TranslateTextInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TranslateTextInputBuilder {
    pub(crate) text: ::std::option::Option<::std::string::String>,
    pub(crate) terminology_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) source_language_code: ::std::option::Option<::std::string::String>,
    pub(crate) target_language_code: ::std::option::Option<::std::string::String>,
    pub(crate) settings: ::std::option::Option<crate::types::TranslationSettings>,
}
impl TranslateTextInputBuilder {
    /// <p>The text to translate. The text string can be a maximum of 10,000 bytes long. Depending on your character set, this may be fewer than 10,000 characters.</p>
    /// This field is required.
    pub fn text(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.text = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The text to translate. The text string can be a maximum of 10,000 bytes long. Depending on your character set, this may be fewer than 10,000 characters.</p>
    pub fn set_text(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.text = input;
        self
    }
    /// <p>The text to translate. The text string can be a maximum of 10,000 bytes long. Depending on your character set, this may be fewer than 10,000 characters.</p>
    pub fn get_text(&self) -> &::std::option::Option<::std::string::String> {
        &self.text
    }
    /// Appends an item to `terminology_names`.
    ///
    /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
    ///
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn terminology_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.terminology_names.unwrap_or_default();
        v.push(input.into());
        self.terminology_names = ::std::option::Option::Some(v);
        self
    }
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn set_terminology_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.terminology_names = input;
        self
    }
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn get_terminology_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.terminology_names
    }
    /// <p>The language code for the language of the source text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateText</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    /// This field is required.
    pub fn source_language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_language_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The language code for the language of the source text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateText</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    pub fn set_source_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_language_code = input;
        self
    }
    /// <p>The language code for the language of the source text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateText</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    pub fn get_source_language_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_language_code
    }
    /// <p>The language code requested for the language of the target text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// This field is required.
    pub fn target_language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.target_language_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The language code requested for the language of the target text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn set_target_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.target_language_code = input;
        self
    }
    /// <p>The language code requested for the language of the target text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn get_target_language_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.target_language_code
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: reduces the length of the translated output for most translations.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn settings(mut self, input: crate::types::TranslationSettings) -> Self {
        self.settings = ::std::option::Option::Some(input);
        self
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: reduces the length of the translated output for most translations.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn set_settings(mut self, input: ::std::option::Option<crate::types::TranslationSettings>) -> Self {
        self.settings = input;
        self
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: reduces the length of the translated output for most translations.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn get_settings(&self) -> &::std::option::Option<crate::types::TranslationSettings> {
        &self.settings
    }
    /// Consumes the builder and constructs a [`TranslateTextInput`](crate::operation::translate_text::TranslateTextInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::translate_text::TranslateTextInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::translate_text::TranslateTextInput {
            text: self.text,
            terminology_names: self.terminology_names,
            source_language_code: self.source_language_code,
            target_language_code: self.target_language_code,
            settings: self.settings,
        })
    }
}
