// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::start_text_translation_job::_start_text_translation_job_output::StartTextTranslationJobOutputBuilder;

pub use crate::operation::start_text_translation_job::_start_text_translation_job_input::StartTextTranslationJobInputBuilder;

impl crate::operation::start_text_translation_job::builders::StartTextTranslationJobInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::start_text_translation_job::StartTextTranslationJobOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_text_translation_job::StartTextTranslationJobError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.start_text_translation_job();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `StartTextTranslationJob`.
///
/// <p>Starts an asynchronous batch translation job. Use batch translation jobs to translate large volumes of text across multiple documents at once. For batch translation, you can input documents with different source languages (specify <code>auto</code> as the source language). You can specify one or more target languages. Batch translation translates each input document into each of the target languages. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/async.html">Asynchronous batch processing</a>.</p>
/// <p>Batch translation jobs can be described with the <code>DescribeTextTranslationJob</code> operation, listed with the <code>ListTextTranslationJobs</code> operation, and stopped with the <code>StopTextTranslationJob</code> operation.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct StartTextTranslationJobFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::start_text_translation_job::builders::StartTextTranslationJobInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::start_text_translation_job::StartTextTranslationJobOutput,
        crate::operation::start_text_translation_job::StartTextTranslationJobError,
    > for StartTextTranslationJobFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::start_text_translation_job::StartTextTranslationJobOutput,
            crate::operation::start_text_translation_job::StartTextTranslationJobError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl StartTextTranslationJobFluentBuilder {
    /// Creates a new `StartTextTranslationJobFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the StartTextTranslationJob as a reference.
    pub fn as_input(&self) -> &crate::operation::start_text_translation_job::builders::StartTextTranslationJobInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_text_translation_job::StartTextTranslationJobOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_text_translation_job::StartTextTranslationJobError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::start_text_translation_job::StartTextTranslationJob::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::start_text_translation_job::StartTextTranslationJob::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::start_text_translation_job::StartTextTranslationJobOutput,
        crate::operation::start_text_translation_job::StartTextTranslationJobError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the batch translation job to be performed.</p>
    pub fn job_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.job_name(input.into());
        self
    }
    /// <p>The name of the batch translation job to be performed.</p>
    pub fn set_job_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_job_name(input);
        self
    }
    /// <p>The name of the batch translation job to be performed.</p>
    pub fn get_job_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_job_name()
    }
    /// <p>Specifies the format and location of the input documents for the translation job.</p>
    pub fn input_data_config(mut self, input: crate::types::InputDataConfig) -> Self {
        self.inner = self.inner.input_data_config(input);
        self
    }
    /// <p>Specifies the format and location of the input documents for the translation job.</p>
    pub fn set_input_data_config(mut self, input: ::std::option::Option<crate::types::InputDataConfig>) -> Self {
        self.inner = self.inner.set_input_data_config(input);
        self
    }
    /// <p>Specifies the format and location of the input documents for the translation job.</p>
    pub fn get_input_data_config(&self) -> &::std::option::Option<crate::types::InputDataConfig> {
        self.inner.get_input_data_config()
    }
    /// <p>Specifies the S3 folder to which your job output will be saved.</p>
    pub fn output_data_config(mut self, input: crate::types::OutputDataConfig) -> Self {
        self.inner = self.inner.output_data_config(input);
        self
    }
    /// <p>Specifies the S3 folder to which your job output will be saved.</p>
    pub fn set_output_data_config(mut self, input: ::std::option::Option<crate::types::OutputDataConfig>) -> Self {
        self.inner = self.inner.set_output_data_config(input);
        self
    }
    /// <p>Specifies the S3 folder to which your job output will be saved.</p>
    pub fn get_output_data_config(&self) -> &::std::option::Option<crate::types::OutputDataConfig> {
        self.inner.get_output_data_config()
    }
    /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and access management </a>.</p>
    pub fn data_access_role_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.data_access_role_arn(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and access management </a>.</p>
    pub fn set_data_access_role_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_data_access_role_arn(input);
        self
    }
    /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and access management </a>.</p>
    pub fn get_data_access_role_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_data_access_role_arn()
    }
    /// <p>The language code of the input language. Specify the language if all input documents share the same language. If you don't know the language of the source files, or your input documents contains different source languages, select <code>auto</code>. Amazon Translate auto detects the source language for each input document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn source_language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.source_language_code(input.into());
        self
    }
    /// <p>The language code of the input language. Specify the language if all input documents share the same language. If you don't know the language of the source files, or your input documents contains different source languages, select <code>auto</code>. Amazon Translate auto detects the source language for each input document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn set_source_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_source_language_code(input);
        self
    }
    /// <p>The language code of the input language. Specify the language if all input documents share the same language. If you don't know the language of the source files, or your input documents contains different source languages, select <code>auto</code>. Amazon Translate auto detects the source language for each input document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn get_source_language_code(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_source_language_code()
    }
    ///
    /// Appends an item to `TargetLanguageCodes`.
    ///
    /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
    ///
    /// <p>The target languages of the translation job. Enter up to 10 language codes. Each input file is translated into each target language.</p>
    /// <p>Each language code is 2 or 5 characters long. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn target_language_codes(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.target_language_codes(input.into());
        self
    }
    /// <p>The target languages of the translation job. Enter up to 10 language codes. Each input file is translated into each target language.</p>
    /// <p>Each language code is 2 or 5 characters long. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn set_target_language_codes(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_target_language_codes(input);
        self
    }
    /// <p>The target languages of the translation job. Enter up to 10 language codes. Each input file is translated into each target language.</p>
    /// <p>Each language code is 2 or 5 characters long. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn get_target_language_codes(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_target_language_codes()
    }
    ///
    /// Appends an item to `TerminologyNames`.
    ///
    /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
    ///
    /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
    /// <p>This parameter accepts only one custom terminology resource.</p>
    /// <p>If you specify multiple target languages for the job, translate uses the designated terminology for each requested target language that has an entry for the source term in the terminology file.</p>
    /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn terminology_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.terminology_names(input.into());
        self
    }
    /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
    /// <p>This parameter accepts only one custom terminology resource.</p>
    /// <p>If you specify multiple target languages for the job, translate uses the designated terminology for each requested target language that has an entry for the source term in the terminology file.</p>
    /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn set_terminology_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_terminology_names(input);
        self
    }
    /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
    /// <p>This parameter accepts only one custom terminology resource.</p>
    /// <p>If you specify multiple target languages for the job, translate uses the designated terminology for each requested target language that has an entry for the source term in the terminology file.</p>
    /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn get_terminology_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_terminology_names()
    }
    ///
    /// Appends an item to `ParallelDataNames`.
    ///
    /// To override the contents of this collection use [`set_parallel_data_names`](Self::set_parallel_data_names).
    ///
    /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. If you specify multiple target languages for the job, the parallel data file must include translations for all the target languages.</p>
    /// <p>When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.</p>
    /// <p>This parameter accepts only one parallel data resource.</p><note>
    /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
    /// </note>
    /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html"> Customizing your translations with parallel data</a>.</p>
    pub fn parallel_data_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.parallel_data_names(input.into());
        self
    }
    /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. If you specify multiple target languages for the job, the parallel data file must include translations for all the target languages.</p>
    /// <p>When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.</p>
    /// <p>This parameter accepts only one parallel data resource.</p><note>
    /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
    /// </note>
    /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html"> Customizing your translations with parallel data</a>.</p>
    pub fn set_parallel_data_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_parallel_data_names(input);
        self
    }
    /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. If you specify multiple target languages for the job, the parallel data file must include translations for all the target languages.</p>
    /// <p>When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.</p>
    /// <p>This parameter accepts only one parallel data resource.</p><note>
    /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
    /// </note>
    /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html"> Customizing your translations with parallel data</a>.</p>
    pub fn get_parallel_data_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_parallel_data_names()
    }
    /// <p>A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.</p>
    pub fn client_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.client_token(input.into());
        self
    }
    /// <p>A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.</p>
    pub fn set_client_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_client_token(input);
        self
    }
    /// <p>A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.</p>
    pub fn get_client_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_client_token()
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: not supported.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn settings(mut self, input: crate::types::TranslationSettings) -> Self {
        self.inner = self.inner.settings(input);
        self
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: not supported.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn set_settings(mut self, input: ::std::option::Option<crate::types::TranslationSettings>) -> Self {
        self.inner = self.inner.set_settings(input);
        self
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: not supported.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn get_settings(&self) -> &::std::option::Option<crate::types::TranslationSettings> {
        self.inner.get_settings()
    }
}
