// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`TranslateDocument`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document(Document)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::document) / [`set_document(Option<Document>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::set_document):<br>required: **true**<br><p>The content and content type for the document to be translated. The document size must not exceed 100 KB.</p><br>
    ///   - [`terminology_names(impl Into<String>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::terminology_names) / [`set_terminology_names(Option<Vec::<String>>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::set_terminology_names):<br>required: **false**<br><p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p> <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p> <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p><br>
    ///   - [`source_language_code(impl Into<String>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::source_language_code) / [`set_source_language_code(Option<String>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::set_source_language_code):<br>required: **true**<br><p>The language code for the language of the source text. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p> <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>  <p>If you specify <code>auto</code>, you must send the <code>TranslateDocument</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p> </note><br>
    ///   - [`target_language_code(impl Into<String>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::target_language_code) / [`set_target_language_code(Option<String>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::set_target_language_code):<br>required: **true**<br><p>The language code requested for the translated document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p><br>
    ///   - [`settings(TranslationSettings)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::settings) / [`set_settings(Option<TranslationSettings>)`](crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::set_settings):<br>required: **false**<br><p>Settings to configure your translation output. You can configure the following options:</p> <ul>  <li>   <p>Brevity: not supported.</p></li>  <li>   <p>Formality: sets the formality level of the output text.</p></li>  <li>   <p>Profanity: masks profane words and phrases in your translation output.</p></li> </ul><br>
    /// - On success, responds with [`TranslateDocumentOutput`](crate::operation::translate_document::TranslateDocumentOutput) with field(s):
    ///   - [`translated_document(Option<TranslatedDocument>)`](crate::operation::translate_document::TranslateDocumentOutput::translated_document): <p>The document containing the translated content. The document format matches the source document format.</p>
    ///   - [`source_language_code(String)`](crate::operation::translate_document::TranslateDocumentOutput::source_language_code): <p>The language code of the source document.</p>
    ///   - [`target_language_code(String)`](crate::operation::translate_document::TranslateDocumentOutput::target_language_code): <p>The language code of the translated document.</p>
    ///   - [`applied_terminologies(Option<Vec::<AppliedTerminology>>)`](crate::operation::translate_document::TranslateDocumentOutput::applied_terminologies): <p>The names of the custom terminologies applied to the input text by Amazon Translate to produce the translated text document.</p>
    ///   - [`applied_settings(Option<TranslationSettings>)`](crate::operation::translate_document::TranslateDocumentOutput::applied_settings): <p>Settings to configure your translation output. You can configure the following options:</p> <ul>  <li>   <p>Brevity: reduces the length of the translation output for most translations. Available for <code>TranslateText</code> only.</p></li>  <li>   <p>Formality: sets the formality level of the translation output.</p></li>  <li>   <p>Profanity: masks profane words and phrases in the translation output.</p></li> </ul>
    /// - On failure, responds with [`SdkError<TranslateDocumentError>`](crate::operation::translate_document::TranslateDocumentError)
    pub fn translate_document(&self) -> crate::operation::translate_document::builders::TranslateDocumentFluentBuilder {
        crate::operation::translate_document::builders::TranslateDocumentFluentBuilder::new(self.handle.clone())
    }
}
