// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Describes the serialization format of the object.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InputSerialization {
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub csv: ::std::option::Option<crate::types::CsvInput>,
    /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
    pub compression_type: ::std::option::Option<crate::types::CompressionType>,
    /// <p>Specifies JSON as object's input serialization format.</p>
    pub json: ::std::option::Option<crate::types::JsonInput>,
    /// <p>Specifies Parquet as object's input serialization format.</p>
    pub parquet: ::std::option::Option<crate::types::ParquetInput>,
}
impl InputSerialization {
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub fn csv(&self) -> ::std::option::Option<&crate::types::CsvInput> {
        self.csv.as_ref()
    }
    /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
    pub fn compression_type(&self) -> ::std::option::Option<&crate::types::CompressionType> {
        self.compression_type.as_ref()
    }
    /// <p>Specifies JSON as object's input serialization format.</p>
    pub fn json(&self) -> ::std::option::Option<&crate::types::JsonInput> {
        self.json.as_ref()
    }
    /// <p>Specifies Parquet as object's input serialization format.</p>
    pub fn parquet(&self) -> ::std::option::Option<&crate::types::ParquetInput> {
        self.parquet.as_ref()
    }
}
impl InputSerialization {
    /// Creates a new builder-style object to manufacture [`InputSerialization`](crate::types::InputSerialization).
    pub fn builder() -> crate::types::builders::InputSerializationBuilder {
        crate::types::builders::InputSerializationBuilder::default()
    }
}

/// A builder for [`InputSerialization`](crate::types::InputSerialization).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct InputSerializationBuilder {
    pub(crate) csv: ::std::option::Option<crate::types::CsvInput>,
    pub(crate) compression_type: ::std::option::Option<crate::types::CompressionType>,
    pub(crate) json: ::std::option::Option<crate::types::JsonInput>,
    pub(crate) parquet: ::std::option::Option<crate::types::ParquetInput>,
}
impl InputSerializationBuilder {
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub fn csv(mut self, input: crate::types::CsvInput) -> Self {
        self.csv = ::std::option::Option::Some(input);
        self
    }
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub fn set_csv(mut self, input: ::std::option::Option<crate::types::CsvInput>) -> Self {
        self.csv = input;
        self
    }
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub fn get_csv(&self) -> &::std::option::Option<crate::types::CsvInput> {
        &self.csv
    }
    /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
    pub fn compression_type(mut self, input: crate::types::CompressionType) -> Self {
        self.compression_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
    pub fn set_compression_type(mut self, input: ::std::option::Option<crate::types::CompressionType>) -> Self {
        self.compression_type = input;
        self
    }
    /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
    pub fn get_compression_type(&self) -> &::std::option::Option<crate::types::CompressionType> {
        &self.compression_type
    }
    /// <p>Specifies JSON as object's input serialization format.</p>
    pub fn json(mut self, input: crate::types::JsonInput) -> Self {
        self.json = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies JSON as object's input serialization format.</p>
    pub fn set_json(mut self, input: ::std::option::Option<crate::types::JsonInput>) -> Self {
        self.json = input;
        self
    }
    /// <p>Specifies JSON as object's input serialization format.</p>
    pub fn get_json(&self) -> &::std::option::Option<crate::types::JsonInput> {
        &self.json
    }
    /// <p>Specifies Parquet as object's input serialization format.</p>
    pub fn parquet(mut self, input: crate::types::ParquetInput) -> Self {
        self.parquet = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies Parquet as object's input serialization format.</p>
    pub fn set_parquet(mut self, input: ::std::option::Option<crate::types::ParquetInput>) -> Self {
        self.parquet = input;
        self
    }
    /// <p>Specifies Parquet as object's input serialization format.</p>
    pub fn get_parquet(&self) -> &::std::option::Option<crate::types::ParquetInput> {
        &self.parquet
    }
    /// Consumes the builder and constructs a [`InputSerialization`](crate::types::InputSerialization).
    pub fn build(self) -> crate::types::InputSerialization {
        crate::types::InputSerialization {
            csv: self.csv,
            compression_type: self.compression_type,
            json: self.json,
            parquet: self.parquet,
        }
    }
}
