// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `ApiName`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let apiname = unimplemented!();
/// match apiname {
///     ApiName::GetClip => { /* ... */ },
///     ApiName::GetDashStreamingSessionUrl => { /* ... */ },
///     ApiName::GetHlsStreamingSessionUrl => { /* ... */ },
///     ApiName::GetImages => { /* ... */ },
///     ApiName::GetMedia => { /* ... */ },
///     ApiName::GetMediaForFragmentList => { /* ... */ },
///     ApiName::ListFragments => { /* ... */ },
///     ApiName::PutMedia => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `apiname` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `ApiName::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `ApiName::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `ApiName::NewFeature` is defined.
/// Specifically, when `apiname` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `ApiName::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum ApiName {
    #[allow(missing_docs)] // documentation missing in model
    GetClip,
    #[allow(missing_docs)] // documentation missing in model
    GetDashStreamingSessionUrl,
    #[allow(missing_docs)] // documentation missing in model
    GetHlsStreamingSessionUrl,
    #[allow(missing_docs)] // documentation missing in model
    GetImages,
    #[allow(missing_docs)] // documentation missing in model
    GetMedia,
    #[allow(missing_docs)] // documentation missing in model
    GetMediaForFragmentList,
    #[allow(missing_docs)] // documentation missing in model
    ListFragments,
    #[allow(missing_docs)] // documentation missing in model
    PutMedia,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for ApiName {
    fn from(s: &str) -> Self {
        match s {
            "GET_CLIP" => ApiName::GetClip,
            "GET_DASH_STREAMING_SESSION_URL" => ApiName::GetDashStreamingSessionUrl,
            "GET_HLS_STREAMING_SESSION_URL" => ApiName::GetHlsStreamingSessionUrl,
            "GET_IMAGES" => ApiName::GetImages,
            "GET_MEDIA" => ApiName::GetMedia,
            "GET_MEDIA_FOR_FRAGMENT_LIST" => ApiName::GetMediaForFragmentList,
            "LIST_FRAGMENTS" => ApiName::ListFragments,
            "PUT_MEDIA" => ApiName::PutMedia,
            other => ApiName::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for ApiName {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(ApiName::from(s))
    }
}
impl ApiName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiName::GetClip => "GET_CLIP",
            ApiName::GetDashStreamingSessionUrl => "GET_DASH_STREAMING_SESSION_URL",
            ApiName::GetHlsStreamingSessionUrl => "GET_HLS_STREAMING_SESSION_URL",
            ApiName::GetImages => "GET_IMAGES",
            ApiName::GetMedia => "GET_MEDIA",
            ApiName::GetMediaForFragmentList => "GET_MEDIA_FOR_FRAGMENT_LIST",
            ApiName::ListFragments => "LIST_FRAGMENTS",
            ApiName::PutMedia => "PUT_MEDIA",
            ApiName::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "GET_CLIP",
            "GET_DASH_STREAMING_SESSION_URL",
            "GET_HLS_STREAMING_SESSION_URL",
            "GET_IMAGES",
            "GET_MEDIA",
            "GET_MEDIA_FOR_FRAGMENT_LIST",
            "LIST_FRAGMENTS",
            "PUT_MEDIA",
        ]
    }
}
impl ::std::convert::AsRef<str> for ApiName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl ApiName {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for ApiName {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            ApiName::GetClip => write!(f, "GET_CLIP"),
            ApiName::GetDashStreamingSessionUrl => write!(f, "GET_DASH_STREAMING_SESSION_URL"),
            ApiName::GetHlsStreamingSessionUrl => write!(f, "GET_HLS_STREAMING_SESSION_URL"),
            ApiName::GetImages => write!(f, "GET_IMAGES"),
            ApiName::GetMedia => write!(f, "GET_MEDIA"),
            ApiName::GetMediaForFragmentList => write!(f, "GET_MEDIA_FOR_FRAGMENT_LIST"),
            ApiName::ListFragments => write!(f, "LIST_FRAGMENTS"),
            ApiName::PutMedia => write!(f, "PUT_MEDIA"),
            ApiName::Unknown(value) => write!(f, "{}", value),
        }
    }
}
