//
//Copyright 2025 Google LLC
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//https://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.23.4
// source: sharedprotos/gcbdractions/gcbdractions.proto

package gcbdractions

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// *
// GCBDRAction specifies the type of GCBDR action to perform.
type GCBDRAction int32

const (
	GCBDRAction_GCBDR_ACTION_UNSPECIFIED    GCBDRAction = 0
	GCBDRAction_GCBDR_ACTION_DEEP_DISCOVERY GCBDRAction = 1
)

// Enum value maps for GCBDRAction.
var (
	GCBDRAction_name = map[int32]string{
		0: "GCBDR_ACTION_UNSPECIFIED",
		1: "GCBDR_ACTION_DEEP_DISCOVERY",
	}
	GCBDRAction_value = map[string]int32{
		"GCBDR_ACTION_UNSPECIFIED":    0,
		"GCBDR_ACTION_DEEP_DISCOVERY": 1,
	}
)

func (x GCBDRAction) Enum() *GCBDRAction {
	p := new(GCBDRAction)
	*p = x
	return p
}

func (x GCBDRAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GCBDRAction) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_enumTypes[0].Descriptor()
}

func (GCBDRAction) Type() protoreflect.EnumType {
	return &file_sharedprotos_gcbdractions_gcbdractions_proto_enumTypes[0]
}

func (x GCBDRAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GCBDRAction.Descriptor instead.
func (GCBDRAction) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{0}
}

// *
// A GCBDRActionRequest is contained in the body of an UAP message that is sent
// to the agent by the WorkloadActions service.
type GCBDRActionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Commands []*Command `protobuf:"bytes,2,rep,name=commands,proto3" json:"commands,omitempty"`
}

func (x *GCBDRActionRequest) Reset() {
	*x = GCBDRActionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCBDRActionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCBDRActionRequest) ProtoMessage() {}

func (x *GCBDRActionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCBDRActionRequest.ProtoReflect.Descriptor instead.
func (*GCBDRActionRequest) Descriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{0}
}

func (x *GCBDRActionRequest) GetCommands() []*Command {
	if x != nil {
		return x.Commands
	}
	return nil
}

// *
// A GCBDRActionResponse is contained in the body of an Agent Communication
// message that is sent from the agent to the WorkloadActions service.
type GCBDRActionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CommandResults []*CommandResult  `protobuf:"bytes,1,rep,name=command_results,json=commandResults,proto3" json:"command_results,omitempty"`
	Error          *GCBDRActionError `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *GCBDRActionResponse) Reset() {
	*x = GCBDRActionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCBDRActionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCBDRActionResponse) ProtoMessage() {}

func (x *GCBDRActionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCBDRActionResponse.ProtoReflect.Descriptor instead.
func (*GCBDRActionResponse) Descriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{1}
}

func (x *GCBDRActionResponse) GetCommandResults() []*CommandResult {
	if x != nil {
		return x.CommandResults
	}
	return nil
}

func (x *GCBDRActionResponse) GetError() *GCBDRActionError {
	if x != nil {
		return x.Error
	}
	return nil
}

// *
// Command specifies the type of command to execute.
type Command struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to CommandType:
	//
	//	*Command_AgentCommand
	//	*Command_ShellCommand
	CommandType isCommand_CommandType `protobuf_oneof:"command_type"`
}

func (x *Command) Reset() {
	*x = Command{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Command) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Command) ProtoMessage() {}

func (x *Command) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Command.ProtoReflect.Descriptor instead.
func (*Command) Descriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{2}
}

func (m *Command) GetCommandType() isCommand_CommandType {
	if m != nil {
		return m.CommandType
	}
	return nil
}

func (x *Command) GetAgentCommand() *AgentCommand {
	if x, ok := x.GetCommandType().(*Command_AgentCommand); ok {
		return x.AgentCommand
	}
	return nil
}

func (x *Command) GetShellCommand() *ShellCommand {
	if x, ok := x.GetCommandType().(*Command_ShellCommand); ok {
		return x.ShellCommand
	}
	return nil
}

type isCommand_CommandType interface {
	isCommand_CommandType()
}

type Command_AgentCommand struct {
	AgentCommand *AgentCommand `protobuf:"bytes,1,opt,name=agent_command,json=agentCommand,proto3,oneof"`
}

type Command_ShellCommand struct {
	ShellCommand *ShellCommand `protobuf:"bytes,2,opt,name=shell_command,json=shellCommand,proto3,oneof"`
}

func (*Command_AgentCommand) isCommand_CommandType() {}

func (*Command_ShellCommand) isCommand_CommandType() {}

// *
// An AgentCommand specifies a one-time executable program for the agent to run.
type AgentCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// command is the name of the GCBDR action that will be invoked.
	Command string `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	// parameters is a map of key/value pairs that can be used to specify
	// additional one-time executable settings.
	Parameters map[string]string `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AgentCommand) Reset() {
	*x = AgentCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCommand) ProtoMessage() {}

func (x *AgentCommand) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCommand.ProtoReflect.Descriptor instead.
func (*AgentCommand) Descriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{3}
}

func (x *AgentCommand) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *AgentCommand) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// *
// A ShellCommand is invoked via the agent's command line executor
type ShellCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// command is the name of the command to be executed.
	Command string `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	// args is a string of arguments to be passed to the command.
	Args string `protobuf:"bytes,2,opt,name=args,proto3" json:"args,omitempty"`
	// Optional. If not specified, the default timeout is 60 seconds.
	TimeoutSeconds int32 `protobuf:"varint,3,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
}

func (x *ShellCommand) Reset() {
	*x = ShellCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShellCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShellCommand) ProtoMessage() {}

func (x *ShellCommand) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShellCommand.ProtoReflect.Descriptor instead.
func (*ShellCommand) Descriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{4}
}

func (x *ShellCommand) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *ShellCommand) GetArgs() string {
	if x != nil {
		return x.Args
	}
	return ""
}

func (x *ShellCommand) GetTimeoutSeconds() int32 {
	if x != nil {
		return x.TimeoutSeconds
	}
	return 0
}

// *
// CommandResult contains the result of a single command execution.
type CommandResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Command  *Command   `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	Stdout   string     `protobuf:"bytes,2,opt,name=stdout,proto3" json:"stdout,omitempty"`
	Stderr   string     `protobuf:"bytes,3,opt,name=stderr,proto3" json:"stderr,omitempty"`
	ExitCode int32      `protobuf:"varint,4,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	Payload  *anypb.Any `protobuf:"bytes,5,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *CommandResult) Reset() {
	*x = CommandResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandResult) ProtoMessage() {}

func (x *CommandResult) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandResult.ProtoReflect.Descriptor instead.
func (*CommandResult) Descriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{5}
}

func (x *CommandResult) GetCommand() *Command {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *CommandResult) GetStdout() string {
	if x != nil {
		return x.Stdout
	}
	return ""
}

func (x *CommandResult) GetStderr() string {
	if x != nil {
		return x.Stderr
	}
	return ""
}

func (x *CommandResult) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *CommandResult) GetPayload() *anypb.Any {
	if x != nil {
		return x.Payload
	}
	return nil
}

// *
// GCBDRActionError contains details about an error that occurred while
// processing a GCBDRActionRequest.
type GCBDRActionError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ErrorMessage string `protobuf:"bytes,1,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *GCBDRActionError) Reset() {
	*x = GCBDRActionError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCBDRActionError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCBDRActionError) ProtoMessage() {}

func (x *GCBDRActionError) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCBDRActionError.ProtoReflect.Descriptor instead.
func (*GCBDRActionError) Descriptor() ([]byte, []int) {
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP(), []int{6}
}

func (x *GCBDRActionError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

var File_sharedprotos_gcbdractions_gcbdractions_proto protoreflect.FileDescriptor

var file_sharedprotos_gcbdractions_gcbdractions_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x67,
	0x63, 0x62, 0x64, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x63, 0x62, 0x64,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2f,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x67, 0x63, 0x62, 0x64, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x6a, 0x0a, 0x12, 0x47, 0x43,
	0x42, 0x44, 0x52, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x54, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x63, 0x62, 0x64, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x08, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x22, 0xd7, 0x01, 0x0a, 0x13, 0x47, 0x43, 0x42, 0x44, 0x52,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x67,
	0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x63, 0x62,
	0x64, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x63, 0x62, 0x64,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x47, 0x43, 0x42, 0x44, 0x52, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0xe5, 0x01, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x64, 0x0a, 0x0d,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x63, 0x62, 0x64, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x12, 0x64, 0x0a, 0x0d, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67,
	0x63, 0x62, 0x64, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x68, 0x65, 0x6c,
	0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x68, 0x65, 0x6c,
	0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xd6, 0x01, 0x0a, 0x0c, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x12, 0x6d, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x63, 0x62,
	0x64, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x65, 0x0a, 0x0c, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12,
	0x27, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0xe0, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x52, 0x0a, 0x07, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x67, 0x63, 0x62, 0x64, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x12, 0x1b,
	0x0a, 0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x37, 0x0a, 0x10, 0x47,
	0x43, 0x42, 0x44, 0x52, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2a, 0x4c, 0x0a, 0x0b, 0x47, 0x43, 0x42, 0x44, 0x52, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x18, 0x47, 0x43, 0x42, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x43, 0x42, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x44, 0x45, 0x45, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59,
	0x10, 0x01, 0x42, 0x83, 0x01, 0x0a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x63, 0x62, 0x64, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x01, 0x5a, 0x4e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x67, 0x63, 0x62, 0x64,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescOnce sync.Once
	file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescData = file_sharedprotos_gcbdractions_gcbdractions_proto_rawDesc
)

func file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescGZIP() []byte {
	file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescOnce.Do(func() {
		file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescData = protoimpl.X.CompressGZIP(file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescData)
	})
	return file_sharedprotos_gcbdractions_gcbdractions_proto_rawDescData
}

var file_sharedprotos_gcbdractions_gcbdractions_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_sharedprotos_gcbdractions_gcbdractions_proto_goTypes = []interface{}{
	(GCBDRAction)(0),            // 0: workloadagentplatform.sharedprotos.gcbdractions.GCBDRAction
	(*GCBDRActionRequest)(nil),  // 1: workloadagentplatform.sharedprotos.gcbdractions.GCBDRActionRequest
	(*GCBDRActionResponse)(nil), // 2: workloadagentplatform.sharedprotos.gcbdractions.GCBDRActionResponse
	(*Command)(nil),             // 3: workloadagentplatform.sharedprotos.gcbdractions.Command
	(*AgentCommand)(nil),        // 4: workloadagentplatform.sharedprotos.gcbdractions.AgentCommand
	(*ShellCommand)(nil),        // 5: workloadagentplatform.sharedprotos.gcbdractions.ShellCommand
	(*CommandResult)(nil),       // 6: workloadagentplatform.sharedprotos.gcbdractions.CommandResult
	(*GCBDRActionError)(nil),    // 7: workloadagentplatform.sharedprotos.gcbdractions.GCBDRActionError
	nil,                         // 8: workloadagentplatform.sharedprotos.gcbdractions.AgentCommand.ParametersEntry
	(*anypb.Any)(nil),           // 9: google.protobuf.Any
}
var file_sharedprotos_gcbdractions_gcbdractions_proto_depIdxs = []int32{
	3, // 0: workloadagentplatform.sharedprotos.gcbdractions.GCBDRActionRequest.commands:type_name -> workloadagentplatform.sharedprotos.gcbdractions.Command
	6, // 1: workloadagentplatform.sharedprotos.gcbdractions.GCBDRActionResponse.command_results:type_name -> workloadagentplatform.sharedprotos.gcbdractions.CommandResult
	7, // 2: workloadagentplatform.sharedprotos.gcbdractions.GCBDRActionResponse.error:type_name -> workloadagentplatform.sharedprotos.gcbdractions.GCBDRActionError
	4, // 3: workloadagentplatform.sharedprotos.gcbdractions.Command.agent_command:type_name -> workloadagentplatform.sharedprotos.gcbdractions.AgentCommand
	5, // 4: workloadagentplatform.sharedprotos.gcbdractions.Command.shell_command:type_name -> workloadagentplatform.sharedprotos.gcbdractions.ShellCommand
	8, // 5: workloadagentplatform.sharedprotos.gcbdractions.AgentCommand.parameters:type_name -> workloadagentplatform.sharedprotos.gcbdractions.AgentCommand.ParametersEntry
	3, // 6: workloadagentplatform.sharedprotos.gcbdractions.CommandResult.command:type_name -> workloadagentplatform.sharedprotos.gcbdractions.Command
	9, // 7: workloadagentplatform.sharedprotos.gcbdractions.CommandResult.payload:type_name -> google.protobuf.Any
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_sharedprotos_gcbdractions_gcbdractions_proto_init() }
func file_sharedprotos_gcbdractions_gcbdractions_proto_init() {
	if File_sharedprotos_gcbdractions_gcbdractions_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GCBDRActionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GCBDRActionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Command); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShellCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GCBDRActionError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Command_AgentCommand)(nil),
		(*Command_ShellCommand)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sharedprotos_gcbdractions_gcbdractions_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sharedprotos_gcbdractions_gcbdractions_proto_goTypes,
		DependencyIndexes: file_sharedprotos_gcbdractions_gcbdractions_proto_depIdxs,
		EnumInfos:         file_sharedprotos_gcbdractions_gcbdractions_proto_enumTypes,
		MessageInfos:      file_sharedprotos_gcbdractions_gcbdractions_proto_msgTypes,
	}.Build()
	File_sharedprotos_gcbdractions_gcbdractions_proto = out.File
	file_sharedprotos_gcbdractions_gcbdractions_proto_rawDesc = nil
	file_sharedprotos_gcbdractions_gcbdractions_proto_goTypes = nil
	file_sharedprotos_gcbdractions_gcbdractions_proto_depIdxs = nil
}
