// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides information about your AWS account.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AccountInfo {
    /// <p>The identifier of the AWS account that is assigned to the user.</p>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>The display name of the AWS account that is assigned to the user.</p>
    pub account_name: ::std::option::Option<::std::string::String>,
    /// <p>The email address of the AWS account that is assigned to the user.</p>
    pub email_address: ::std::option::Option<::std::string::String>,
}
impl AccountInfo {
    /// <p>The identifier of the AWS account that is assigned to the user.</p>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The display name of the AWS account that is assigned to the user.</p>
    pub fn account_name(&self) -> ::std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p>The email address of the AWS account that is assigned to the user.</p>
    pub fn email_address(&self) -> ::std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl AccountInfo {
    /// Creates a new builder-style object to manufacture [`AccountInfo`](crate::types::AccountInfo).
    pub fn builder() -> crate::types::builders::AccountInfoBuilder {
        crate::types::builders::AccountInfoBuilder::default()
    }
}

/// A builder for [`AccountInfo`](crate::types::AccountInfo).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct AccountInfoBuilder {
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) account_name: ::std::option::Option<::std::string::String>,
    pub(crate) email_address: ::std::option::Option<::std::string::String>,
}
impl AccountInfoBuilder {
    /// <p>The identifier of the AWS account that is assigned to the user.</p>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The identifier of the AWS account that is assigned to the user.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The identifier of the AWS account that is assigned to the user.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The display name of the AWS account that is assigned to the user.</p>
    pub fn account_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The display name of the AWS account that is assigned to the user.</p>
    pub fn set_account_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_name = input;
        self
    }
    /// <p>The display name of the AWS account that is assigned to the user.</p>
    pub fn get_account_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_name
    }
    /// <p>The email address of the AWS account that is assigned to the user.</p>
    pub fn email_address(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.email_address = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The email address of the AWS account that is assigned to the user.</p>
    pub fn set_email_address(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.email_address = input;
        self
    }
    /// <p>The email address of the AWS account that is assigned to the user.</p>
    pub fn get_email_address(&self) -> &::std::option::Option<::std::string::String> {
        &self.email_address
    }
    /// Consumes the builder and constructs a [`AccountInfo`](crate::types::AccountInfo).
    pub fn build(self) -> crate::types::AccountInfo {
        crate::types::AccountInfo {
            account_id: self.account_id,
            account_name: self.account_name,
            email_address: self.email_address,
        }
    }
}
