// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GenerateRandom`](crate::operation::generate_random::builders::GenerateRandomFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`number_of_bytes(i32)`](crate::operation::generate_random::builders::GenerateRandomFluentBuilder::number_of_bytes) / [`set_number_of_bytes(Option<i32>)`](crate::operation::generate_random::builders::GenerateRandomFluentBuilder::set_number_of_bytes):<br>required: **false**<br><p>The length of the random byte string. This parameter is required.</p><br>
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::operation::generate_random::builders::GenerateRandomFluentBuilder::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::operation::generate_random::builders::GenerateRandomFluentBuilder::set_custom_key_store_id):<br>required: **false**<br><p>Generates the random byte string in the CloudHSM cluster that is associated with the specified CloudHSM key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p> <p>External key store IDs are not valid for this parameter. If you specify the ID of an external key store, <code>GenerateRandom</code> throws an <code>UnsupportedOperationException</code>.</p><br>
    ///   - [`recipient(RecipientInfo)`](crate::operation::generate_random::builders::GenerateRandomFluentBuilder::recipient) / [`set_recipient(Option<RecipientInfo>)`](crate::operation::generate_random::builders::GenerateRandomFluentBuilder::set_recipient):<br>required: **false**<br><p>A signed <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave-how.html#term-attestdoc">attestation document</a> from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is <code>RSAES_OAEP_SHA_256</code>.</p> <p>This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the <a href="https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk">Amazon Web Services Nitro Enclaves SDK</a> or any Amazon Web Services SDK.</p> <p>When you use this parameter, instead of returning plaintext bytes, KMS encrypts the plaintext bytes under the public key in the attestation document, and returns the resulting ciphertext in the <code>CiphertextForRecipient</code> field in the response. This ciphertext can be decrypted only with the private key in the enclave. The <code>Plaintext</code> field in the response is null or empty.</p> <p>For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves uses KMS</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`GenerateRandomOutput`](crate::operation::generate_random::GenerateRandomOutput) with field(s):
    ///   - [`plaintext(Option<Blob>)`](crate::operation::generate_random::GenerateRandomOutput::plaintext): <p>The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p> <p>If the response includes the <code>CiphertextForRecipient</code> field, the <code>Plaintext</code> field is null or empty.</p>
    ///   - [`ciphertext_for_recipient(Option<Blob>)`](crate::operation::generate_random::GenerateRandomOutput::ciphertext_for_recipient): <p>The plaintext random bytes encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.</p> <p>This field is included in the response only when the <code>Recipient</code> parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves uses KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<GenerateRandomError>`](crate::operation::generate_random::GenerateRandomError)
    pub fn generate_random(&self) -> crate::operation::generate_random::builders::GenerateRandomFluentBuilder {
        crate::operation::generate_random::builders::GenerateRandomFluentBuilder::new(self.handle.clone())
    }
}
