// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`CreateCustomKeyStore`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`custom_key_store_name(impl Into<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::custom_key_store_name) / [`set_custom_key_store_name(Option<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_custom_key_store_name):<br>required: **true**<br><p>Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account and Region. This parameter is required for all custom key stores.</p><important>  <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important><br>
    ///   - [`cloud_hsm_cluster_id(impl Into<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::cloud_hsm_cluster_id) / [`set_cloud_hsm_cluster_id(Option<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_cloud_hsm_cluster_id):<br>required: **false**<br><p>Identifies the CloudHSM cluster for an CloudHSM key store. This parameter is required for custom key stores with <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p> <p>Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p><br>
    ///   - [`trust_anchor_certificate(impl Into<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::trust_anchor_certificate) / [`set_trust_anchor_certificate(Option<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_trust_anchor_certificate):<br>required: **false**<br><p>Specifies the certificate for an CloudHSM key store. This parameter is required for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p> <p>Enter the content of the trust anchor certificate for the CloudHSM cluster. This is the content of the <code>customerCA.crt</code> file that you created when you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the cluster</a>.</p><br>
    ///   - [`key_store_password(impl Into<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::key_store_password) / [`set_key_store_password(Option<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_key_store_password):<br>required: **false**<br><p>Specifies the <code>kmsuser</code> password for an CloudHSM key store. This parameter is required for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p> <p>Enter the password of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser"> <code>kmsuser</code> crypto user (CU) account</a> in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.</p> <p>The password must be a string of 7 to 32 characters. Its value is case sensitive.</p> <p>This parameter tells KMS the <code>kmsuser</code> account password; it does not change the password in the CloudHSM cluster.</p><br>
    ///   - [`custom_key_store_type(CustomKeyStoreType)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::custom_key_store_type) / [`set_custom_key_store_type(Option<CustomKeyStoreType>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_custom_key_store_type):<br>required: **false**<br><p>Specifies the type of custom key store. The default value is <code>AWS_CLOUDHSM</code>.</p> <p>For a custom key store backed by an CloudHSM cluster, omit the parameter or enter <code>AWS_CLOUDHSM</code>. For a custom key store backed by an external key manager outside of Amazon Web Services, enter <code>EXTERNAL_KEY_STORE</code>. You cannot change this property after the key store is created.</p><br>
    ///   - [`xks_proxy_uri_endpoint(impl Into<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::xks_proxy_uri_endpoint) / [`set_xks_proxy_uri_endpoint(Option<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_xks_proxy_uri_endpoint):<br>required: **false**<br><p>Specifies the endpoint that KMS uses to send requests to the external key store proxy (XKS proxy). This parameter is required for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p> <p>The protocol must be HTTPS. KMS communicates on port 443. Do not specify the port in the <code>XksProxyUriEndpoint</code> value.</p> <p>For external key stores with <code>XksProxyConnectivity</code> value of <code>VPC_ENDPOINT_SERVICE</code>, specify <code>https://</code> followed by the private DNS name of the VPC endpoint service.</p> <p>For external key stores with <code>PUBLIC_ENDPOINT</code> connectivity, this endpoint must be reachable before you create the custom key store. KMS connects to the external key store proxy while creating the custom key store. For external key stores with <code>VPC_ENDPOINT_SERVICE</code> connectivity, KMS connects when you call the <code>ConnectCustomKeyStore</code> operation.</p> <p>The value of this parameter must begin with <code>https://</code>. The remainder can contain upper and lower case letters (A-Z and a-z), numbers (0-9), dots (<code>.</code>), and hyphens (<code>-</code>). Additional slashes (<code>/</code> and <code>\</code>) are not permitted.</p> <p><b>Uniqueness requirements: </b></p> <ul>  <li>   <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p></li>  <li>   <p>An external key store with <code>PUBLIC_ENDPOINT</code> connectivity cannot use the same <code>XksProxyUriEndpoint</code> value as an external key store with <code>VPC_ENDPOINT_SERVICE</code> connectivity in this Amazon Web Services Region.</p></li>  <li>   <p>Each external key store with <code>VPC_ENDPOINT_SERVICE</code> connectivity must have its own private DNS name. The <code>XksProxyUriEndpoint</code> value for external key stores with <code>VPC_ENDPOINT_SERVICE</code> connectivity (private DNS name) must be unique in the Amazon Web Services account and Region.</p></li> </ul><br>
    ///   - [`xks_proxy_uri_path(impl Into<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::xks_proxy_uri_path) / [`set_xks_proxy_uri_path(Option<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_xks_proxy_uri_path):<br>required: **false**<br><p>Specifies the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key store proxy. This parameter is required for all custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p> <p>The value must start with <code>/</code> and must end with <code>/kms/xks/v1</code> where <code>v1</code> represents the version of the KMS external key store proxy API. This path can include an optional prefix between the required elements such as <code>/<i>prefix</i>/kms/xks/v1</code>.</p> <p><b>Uniqueness requirements: </b></p> <ul>  <li>   <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p></li> </ul><br>
    ///   - [`xks_proxy_vpc_endpoint_service_name(impl Into<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::xks_proxy_vpc_endpoint_service_name) / [`set_xks_proxy_vpc_endpoint_service_name(Option<String>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_xks_proxy_vpc_endpoint_service_name):<br>required: **false**<br><p>Specifies the name of the Amazon VPC endpoint service for interface endpoints that is used to communicate with your external key store proxy (XKS proxy). This parameter is required when the value of <code>CustomKeyStoreType</code> is <code>EXTERNAL_KEY_STORE</code> and the value of <code>XksProxyConnectivity</code> is <code>VPC_ENDPOINT_SERVICE</code>.</p> <p>The Amazon VPC endpoint service must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keystore.html#xks-requirements">fulfill all requirements</a> for use with an external key store.</p> <p><b>Uniqueness requirements:</b></p> <ul>  <li>   <p>External key stores with <code>VPC_ENDPOINT_SERVICE</code> connectivity can share an Amazon VPC, but each external key store must have its own VPC endpoint service and private DNS name.</p></li> </ul><br>
    ///   - [`xks_proxy_authentication_credential(XksProxyAuthenticationCredentialType)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::xks_proxy_authentication_credential) / [`set_xks_proxy_authentication_credential(Option<XksProxyAuthenticationCredentialType>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_xks_proxy_authentication_credential):<br>required: **false**<br><p>Specifies an authentication credential for the external key store proxy (XKS proxy). This parameter is required for all custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p> <p>The <code>XksProxyAuthenticationCredential</code> has two required elements: <code>RawSecretAccessKey</code>, a secret key, and <code>AccessKeyId</code>, a unique identifier for the <code>RawSecretAccessKey</code>. For character requirements, see <a href="kms/latest/APIReference/API_XksProxyAuthenticationCredentialType.html">XksProxyAuthenticationCredentialType</a>.</p> <p>KMS uses this authentication credential to sign requests to the external key store proxy on your behalf. This credential is unrelated to Identity and Access Management (IAM) and Amazon Web Services credentials.</p> <p>This parameter doesn't set or change the authentication credentials on the XKS proxy. It just tells KMS the credential that you established on your external key store proxy. If you rotate your proxy authentication credential, use the <code>UpdateCustomKeyStore</code> operation to provide the new credential to KMS.</p><br>
    ///   - [`xks_proxy_connectivity(XksProxyConnectivityType)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::xks_proxy_connectivity) / [`set_xks_proxy_connectivity(Option<XksProxyConnectivityType>)`](crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::set_xks_proxy_connectivity):<br>required: **false**<br><p>Indicates how KMS communicates with the external key store proxy. This parameter is required for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p> <p>If the external key store proxy uses a public endpoint, specify <code>PUBLIC_ENDPOINT</code>. If the external key store proxy uses a Amazon VPC endpoint service for communication with KMS, specify <code>VPC_ENDPOINT_SERVICE</code>. For help making this choice, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/plan-xks-keystore.html#choose-xks-connectivity">Choosing a connectivity option</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>An Amazon VPC endpoint service keeps your communication with KMS in a private address space entirely within Amazon Web Services, but it requires more configuration, including establishing a Amazon VPC with multiple subnets, a VPC endpoint service, a network load balancer, and a verified private DNS name. A public endpoint is simpler to set up, but it might be slower and might not fulfill your security requirements. You might consider testing with a public endpoint, and then establishing a VPC endpoint service for production tasks. Note that this choice does not determine the location of the external key store proxy. Even if you choose a VPC endpoint service, the proxy can be hosted within the VPC or outside of Amazon Web Services such as in your corporate data center.</p><br>
    /// - On success, responds with [`CreateCustomKeyStoreOutput`](crate::operation::create_custom_key_store::CreateCustomKeyStoreOutput) with field(s):
    ///   - [`custom_key_store_id(Option<String>)`](crate::operation::create_custom_key_store::CreateCustomKeyStoreOutput::custom_key_store_id): <p>A unique identifier for the new custom key store.</p>
    /// - On failure, responds with [`SdkError<CreateCustomKeyStoreError>`](crate::operation::create_custom_key_store::CreateCustomKeyStoreError)
    pub fn create_custom_key_store(&self) -> crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder {
        crate::operation::create_custom_key_store::builders::CreateCustomKeyStoreFluentBuilder::new(self.handle.clone())
    }
}
