/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.api.map;

import static org.assertj.core.api.Assertions.assertThat;
import static org.assertj.core.data.MapEntry.entry;
import static org.assertj.core.util.Arrays.array;
import static org.mockito.Mockito.verify;

import java.util.Map;
import java.util.function.Consumer;

import org.assertj.core.api.MapAssert;
import org.assertj.core.api.MapAssertBaseTest;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.Test;

class MapAssert_hasEntrySatisfyingConsumer_Test extends MapAssertBaseTest {

  final MapEntry<String, String>[] entries = array(entry("key1", "value1"), entry("key2", "value2"));
  Consumer<? super Object> valueRequirements = $ -> {};

  @Override
  protected MapAssert<Object, Object> invoke_api_method() {
    return assertions.hasEntrySatisfying("key1", valueRequirements);
  }

  @Override
  protected void verify_internal_effects() {
    verify(maps).assertHasEntrySatisfying(getInfo(assertions), getActual(assertions), "key1", valueRequirements);
  }

  @Test
  void invoke_api_like_user() {
    Map<String, String> map = map("key1", "value1", "key2", "value2");
    assertThat(map).hasEntrySatisfying("key1", v -> assertThat(v).startsWith("val"));
  }
}
