/*
 * Copyright (C) 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]

/// Exposes raw FFI bindings generated by bindgen
pub mod ffi;

/// Module defining error types
pub mod error;

/// Leancrypto wrapper for lc_aead
pub mod lcr_aead;

/// Leancrypto wrapper for lc_bike
pub mod lcr_bike;

/// Leancrypto wrapper for lc_hash
pub mod lcr_hash;

/// Leancrypto wrapper for lc_dilithium
pub mod lcr_dilithium;

/// Leancrypto wrapper for lc_dilithium_ed25519
pub mod lcr_dilithium_ed25519;

/// Leancrypto wrapper for lc_dilithium_ed448
pub mod lcr_dilithium_ed448;

/// Leancrypto wrapper for lc_hmac
pub mod lcr_hmac;

/// Leancrypto wrapper for lc_hqc
pub mod lcr_hqc;

/// Leancrypto wrapper for lc_kmac
pub mod lcr_kmac;

/// Leancrypto wrapper for lc_kyber
pub mod lcr_kyber;

/// Leancrypto wrapper for lc_kyber_x25519
pub mod lcr_kyber_x25519;

/// Leancrypto wrapper for lc_kyber_x448
pub mod lcr_kyber_x448;

/// Leancrypto wrapper for lc_rng
pub mod lcr_rng;

/// Leancrypto wrapper for lc_sphincs
pub mod lcr_sphincs;

/// Leancrypto wrapper for lc_sym
pub mod lcr_sym;
