/*
 * Copyright (C) 2022 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/*
 * This code is derived in parts from the code distribution provided with
 * https://github.com/dilithium-coretexm/dilithium-cortexm.git
 *
 * author: Markus Krausz
 * date: 18.03.18
 *
 * Creative Commons Legal Code
 *
 * CC0 1.0 Universal
 *
 *   CREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE
 *   LEGAL SERVICES. DISTRIBUTION OF THIS DOCUMENT DOES NOT CREATE AN
 *   ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS
 *   INFORMATION ON AN "AS-IS" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES
 *   REGARDING THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS
 *   PROVIDED HEREUNDER, AND DISCLAIMS LIABILITY FOR DAMAGES RESULTING FROM
 *   THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS PROVIDED
 *   HEREUNDER.
 */

#include "dilithium_ntt_consts.h"
#include "ext_headers.h"

/* Roots of unity in order needed by forward ntt */
LC_FIPS_RODATA_SECTION
const uint32_t zetas_interleaved_asm[LC_DILITHIUM_N] = {
	0,	 25847,	  5771523, 7861508, 237124,  1826347, 2353451, 7602457,
	8021166, 6288512, 7504169, 3119733, 5495562, 466468,  3111497, 2680103,
	2725464, 2706023, 95776,   1024112, 3077325, 3530437, 7300517, 6718724,
	4788269, 3585928, 5842901, 3915439, 7830929, 4519302, 5336701, 7260833,
	3574422, 5512770, 2619752, 3539968, 8079950, 6271868, 2348700, 7841118,
	6262231, 6681150, 6736599, 4520680, 3505694, 4558682, 6980856, 3507263,
	6239768, 5102745, 6779997, 3699596, 1757237, 811944,  531354,  8360995,
	954230,	 3881043, 4010497, 3900724, 5823537, 280005,  2071892, 5582638,
	4450022, 2091667, 3407706, 6851714, 2316500, 3817976, 4702672, 5037939,
	2244091, 5339162, 5933984, 4817955, 6927966, 266997,  2434439, 3475950,
	7144689, 3513181, 2176455, 4860065, 4621053, 6795196, 7183191, 5187039,
	7122806, 900702,  1859098, 1939314, 909542,  819034,  4296819, 495491,
	6767243, 7380215, 8337157, 7857917, 5190273, 7725090, 5257975, 5223087,
	2031748, 3207046, 4747489, 4823422, 7855319, 126922,  7611795, 4784579,
	3412210, 342297,  286988,  7396998, 5942594, 4108315, 2147896, 3437287,
	5038140, 2715295, 1735879, 203044,  5412772, 2842341, 2691481, 4686924,
	5790267, 1265009, 7969390, 4055324, 1247620, 5903370, 2486353, 1595974,
	7709315, 4613401, 1250494, 7151892, 2635921, 4832145, 8357436, 5386378,
	1869119, 7072248, 1903435, 7329447, 7998430, 7047359, 1237275, 1349076,
	5062207, 6950192, 1852771, 7929317, 1312455, 6949987, 3306115, 6417775,
	5037034, 7100756, 1917081, 264944,  5834105, 7005614, 508951,  1500165,
	777191,	 3097992, 2235880, 3406031, 44288,   7838005, 5548557, 7280319,
	6709241, 6533464, 904516,  5796124, 4656147, 3958618, 594136,  4603424,
	4656075, 6366809, 2432395, 8371839, 2454455, 8215696, 1653064, 1957272,
	3369112, 5130689, 185531,  7173032, 2389356, 5196991, 162844,  8169440,
	1616392, 3014001, 759969,  810149,  1652634, 7063561, 4686184, 6581310,
	189548,	 5341501, 3523897, 4827145, 3866901, 269760,  3159746, 2213111,
	7404533, 6529015, 1717735, 472078,  5971092, 7953734, 1723600, 8202977,
	6577327, 1910376, 1315589, 6712985, 7276084, 1341330, 8119771, 4546524,
	1285669, 5441381, 6144432, 6795489, 7959518, 6094090, 7567685, 183443,
	7403526, 6940675, 1612842, 4834730, 5361315, 7826001, 3919660, 4499357,
	8332111, 7018208, 4751448, 3937738, 1400424, 3839961, 7534263, 1976782
};

/* Roots of unity in order needed by inverse ntt */
LC_FIPS_RODATA_SECTION
const uint32_t zetas_interleaved_inv_asm[LC_DILITHIUM_N] = {
	6403635, 846154,  4540456, 6979993, 4442679, 3628969, 1362209, 48306,
	3881060, 4460757, 554416,  3019102, 3545687, 6767575, 1439742, 976891,
	8196974, 812732,  2286327, 420899,  1584928, 2235985, 2939036, 7094748,
	3833893, 260646,  7039087, 1104333, 1667432, 7064828, 6470041, 1803090,
	177440,	 6656817, 426683,  2409325, 7908339, 6662682, 1851402, 975884,
	6167306, 5220671, 8110657, 4513516, 3553272, 4856520, 3038916, 8190869,
	1799107, 3694233, 1316856, 6727783, 7570268, 7620448, 5366416, 6764025,
	210977,	 8217573, 3183426, 5991061, 1207385, 8194886, 3249728, 5011305,
	6423145, 6727353, 164721,  5925962, 8578,    5948022, 2013608, 3724342,
	3776993, 7786281, 4421799, 3724270, 2584293, 7475901, 1846953, 1671176,
	1100098, 2831860, 542412,  8336129, 4974386, 6144537, 5282425, 7603226,
	6880252, 7871466, 1374803, 2546312, 8115473, 6463336, 1279661, 3343383,
	1962642, 5074302, 1430430, 7067962, 451100,  6527646, 1430225, 3318210,
	7031341, 7143142, 1333058, 381987,  1050970, 6476982, 1308169, 6511298,
	2994039, 22981,	  3548272, 5744496, 1228525, 7129923, 3767016, 671102,
	6784443, 5894064, 2477047, 7132797, 4325093, 411027,  7115408, 2590150,
	3693493, 5688936, 5538076, 2967645, 8177373, 6644538, 5665122, 3342277,
	4943130, 6232521, 4272102, 2437823, 983419,  8093429, 8038120, 4968207,
	3595838, 768622,  8253495, 525098,  3556995, 3632928, 5173371, 6348669,
	3157330, 3122442, 655327,  3190144, 522500,  43260,   1000202, 1613174,
	7884926, 4083598, 7561383, 7470875, 6441103, 6521319, 7479715, 1257611,
	3193378, 1197226, 1585221, 3759364, 3520352, 6203962, 4867236, 1235728,
	4904467, 5945978, 8113420, 1452451, 3562462, 2446433, 3041255, 6136326,
	3342478, 3677745, 4562441, 6063917, 1528703, 4972711, 6288750, 3930395,
	2797779, 6308525, 8100412, 2556880, 4479693, 4369920, 4499374, 7426187,
	19422,	 7849063, 7568473, 6623180, 4680821, 1600420, 3277672, 2140649,
	4873154, 1399561, 3821735, 4874723, 3859737, 1643818, 1699267, 2118186,
	539299,	 6031717, 2108549, 300467,  4840449, 5760665, 2867647, 4805995,
	1119584, 3043716, 3861115, 549488,  4464978, 2537516, 4794489, 3592148,
	1661693, 1079900, 4849980, 5303092, 7356305, 8284641, 5674394, 5654953,
	5700314, 5268920, 7913949, 2884855, 5260684, 876248,  2091905, 359251,
	777960,	 6026966, 6554070, 8143293, 518909,  2608894, 3975713, 0
};
