/*
 * Copyright (C) 2024 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This file is derived from https://github.com/Ji-Peng/PQRV which uses the
 * following license.
 *
 * The MIT license, the text of which is below, applies to PQRV in general.
 *
 * Copyright (c) 2024 - 2025 Jipeng Zhang (jp-zhang@outlook.com)
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "dilithium_consts_rvv.h"
#include "ext_headers.h"

LC_FIPS_RODATA_SECTION
const int32_t dilithium_qdata_rvv[] __attribute__((aligned(16))) = {
#define _ZETA_EXP_0TO3_L0 (0 * 2)
	1830765815,  25847,
#define _ZETA_EXP_0TO3_L1 (_ZETA_EXP_0TO3_L0 + 1 * 2)
	-1929875198, -2608894,	  -1927777021, -518909,
#define _ZETA_EXP_0TO3_L2 (_ZETA_EXP_0TO3_L1 + 2 * 2)
	1640767044,  237124,	  1477910808,  -777960,	    1612161320,
	-876248,     1640734244,  466468,
#define _ZETA_EXP_0TO3_L3 (_ZETA_EXP_0TO3_L2 + 4 * 2)
	308362795,   1826347,	  -1815525077, 2353451,	    -1374673747,
	-359251,     -1091570561, -2091905,    -1929495947, 3119733,
	515185417,   -2884855,	  -285697463,  3111497,	    625853735,
	2680103,
#define _ZETA_EXP_4TO7_P0_L4 (_ZETA_EXP_0TO3_L3 + 8 * 2)
	1727305304,  2725464,	  2082316400,  1024112,	    -1364982364,
	-1079900,    858240904,	  3585928,
#define _ZETA_EXP_4TO7_P0_L5 (_ZETA_EXP_4TO7_P0_L4 + 4 * 2)
	-1846138265, 2706023,	  -1631226336, 95776,	    -1404529459,
	3077325,     1838055109,  3530437,     1594295555,  -1661693,
	-1076973524, -3592148,	  -1898723372, -2537516,    -594436433,
	3915439,
#define _ZETA_EXP_4TO7_P0_L6 (_ZETA_EXP_4TO7_P0_L5 + 8 * 2)
	-1574918427, -1574918427, -654783359,  -654783359,  -3930395,
	-3930395,    -1528703,	  -1528703,    1350681039,  1350681039,
	-1974159335, -1974159335, -3677745,    -3677745,    -3041255,
	-3041255,    -2143979939, -2143979939, 1651689966,  1651689966,
	-1452451,    -1452451,	  3475950,     3475950,	    1599739335,
	1599739335,  140455867,	  140455867,   2176455,	    2176455,
	-1585221,    -1585221,	  -1285853323, -1285853323, -1039411342,
	-1039411342, -1257611,	  -1257611,    1939314,	    1939314,
	-993005454,  -993005454,  1955560694,  1955560694,  -4083598,
	-4083598,    -1000202,	  -1000202,    -1440787840, -1440787840,
	1529189038,  1529189038,  -3190144,    -3190144,    -3157330,
	-3157330,    568627424,	  568627424,   -2131021878, -2131021878,
	-3632928,    -3632928,	  126922,      126922,
#define _ZETA_EXP_4TO7_P0_L7 (_ZETA_EXP_4TO7_P0_L6 + 16 * 2 * 2)
	-898413,     991903578,	  1363007700,  746144248,   2091667,
	3407706,     2316500,	  3817976,     -1363460238, 912367099,
	30313375,    -1420958686, -3342478,    2244091,	    -2446433,
	-3562462,    -605900043,  -44694137,   -326425360,  2032221021,
	266997,	     2434439,	  -1235728,    3513181,	    2027833504,
	1176904444,  1683520342,  1904936414,  -3520352,    -3759364,
	-1197226,    -3193378,	  14253662,    -421552614,  -517299994,
	1257750362,  900702,	  1859098,     909542,	    819034,
	1014493059,  -818371958,  2027935492,  1926727420,  495491,
	-1613174,    -43260,	  -522500,     863641633,   1747917558,
	-1372618620, 1931587462,  -655327,     -3122442,    2031748,
	3207046,     1819892093,  -325927722,  128353682,   1258381762,
	-3556995,    -525098,	  -768622,     -3595838,
#define _ZETA_EXP_4TO7_P1_L4 (_ZETA_EXP_4TO7_P0_L7 + 32 * 2)
	1806278032,  -549488,	  222489248,   -1119584,    -346752664,
	2619752,     684667771,	  -2108549,
#define _ZETA_EXP_4TO7_P1_L5 (_ZETA_EXP_4TO7_P1_L4 + 4 * 2)
	-202001019,  -3861115,	  -475984260,  -3043716,    -561427818,
	3574422,     1797021249,  -2867647,    -1061813248, 3539968,
	2059733581,  -300467,	  -1661512036, 2348700,	    -1104976547,
	-539299,
#define _ZETA_EXP_4TO7_P1_L6 (_ZETA_EXP_4TO7_P1_L5 + 8 * 2)
	-783134478,  -783134478,  -247357819,  -247357819,  3412210,
	3412210,     -983419,	  -983419,     -588790216,  -588790216,
	1518161567,  1518161567,  2147896,     2147896,	    2715295,
	2715295,     289871779,	  289871779,   -86965173,   -86965173,
	-2967645,    -2967645,	  -3693493,    -3693493,    -1262003603,
	-1262003603, 1708872713,  1708872713,  -411027,	    -411027,
	-2477047,    -2477047,	  2135294594,  2135294594,  1787797779,
	1787797779,  -671102,	  -671102,     -1228525,    -1228525,
	-1018755525, -1018755525, 1638590967,  1638590967,  -22981,
	-22981,	     -1308169,	  -1308169,    -889861155,  -889861155,
	-120646188,  -120646188,  -381987,     -381987,	    1349076,
	1349076,     1665705315,  1665705315,  -1669960606, -1669960606,
	1852771,     1852771,	  -1430430,    -1430430,
#define _ZETA_EXP_4TO7_P1_L7 (_ZETA_EXP_4TO7_P1_L6 + 16 * 2 * 2)
	2124962073,  908452108,	  -1123881663, 885133339,   342297,
	286988,	     -2437823,	  4108315,     -1223601433, 1851023419,
	137583815,   1629985060,  3437287,     -3342277,    1735879,
	203044,	     -1920467227, -1176751719, -635454918,  1967222129,
	2842341,     2691481,	  -2590150,    1265009,	    -1637785316,
	-1354528380, -642772911,  6363718,     4055324,	    1247620,
	2486353,     1595974,	  -1536588520, -72690498,   45766801,
	-1287922800, -3767016,	  1250494,     2635921,	    -3548272,
	694382729,   -314284737,  671509323,   1136965286,  -2994039,
	1869119,     1903435,	  -1050970,    235104446,   985022747,
	-2070602178, 1779436847,  -1333058,    1237275,	    -3318210,
	-1430225,    -1045062172, 963438279,   419615363,   1116720494,
	-451100,     1312455,	  3306115,     -1962642,
#define _ZETA_EXP_4TO7_P2_L4 (_ZETA_EXP_4TO7_P1_L7 + 32 * 2)
	1654287830,  -2118186,	  -878576921,  -3859737,    -1257667337,
	-1399561,    -748618600,  -3277672,
#define _ZETA_EXP_4TO7_P2_L5 (_ZETA_EXP_4TO7_P2_L4 + 4 * 2)
	-1750224323, -1699267,	  -901666090,  -1643818,    418987550,
	3505694,     1831915353,  -3821735,    -1925356481, 3507263,
	992097815,   -2140649,	  879957084,   -1600420,    2024403852,
	3699596,
#define _ZETA_EXP_4TO7_P2_L6 (_ZETA_EXP_4TO7_P2_L5 + 8 * 2)
	1321868265,  1321868265,  -916321552,  -916321552,  -3343383,
	-3343383,    264944,	  264944,      1225434135,  1225434135,
	1155548552,  1155548552,  508951,      508951,	    3097992,
	3097992,     -1784632064, -1784632064, 2143745726,  2143745726,
	44288,	     44288,	  -1100098,    -1100098,    666258756,
	666258756,   1210558298,  1210558298,  904516,	    904516,
	3958618,     3958618,	  675310538,   675310538,   -1261461890,
	-1261461890, -3724342,	  -3724342,    -8578,	    -8578,
	-1555941048, -1555941048, -318346816,  -318346816,  1653064,
	1653064,     -3249728,	  -3249728,    -1999506068, -1999506068,
	628664287,   628664287,	  2389356,     2389356,	    -210977,
	-210977,     -1499481951, -1499481951, -1729304568, -1729304568,
	759969,	     759969,	  -1316856,    -1316856,
#define _ZETA_EXP_4TO7_P2_L7 (_ZETA_EXP_4TO7_P2_L6 + 16 * 2 * 2)
	831969619,   -1078959975, 1216882040,  1042326957,  -1279661,
	1917081,     -2546312,	  -1374803,    -300448763,  604552167,
	-270590488,  1405999311,  1500165,     777191,	    2235880,
	3406031,     756955444,	  -1021949428, -1276805128, 713994583,
	-542412,     -2831860,	  -1671176,    -1846953,    -260312805,
	608791570,   371462360,	  940195359,   -2584293,    -3724270,
	594136,	     -3776993,	  1554794072,  173440395,   -1357098057,
	-1542497137, -2013608,	  2432395,     2454455,	    -164721,
	1339088280,  -2126092136, -384158533,  2061661095,  1957272,
	3369112,     185531,	  -1207385,    -2040058690, -1316619236,
	827959816,   -883155599,  -3183426,    162844,	    1616392,
	3014001,     -853476187,  -1039370342, -596344473,  1726753853,
	810149,	     1652634,	  -3694233,    -1799107,
#define _ZETA_EXP_4TO7_P3_L4 (_ZETA_EXP_4TO7_P2_L7 + 32 * 2)
	329347125,   1757237,	  1837364258,  -19422,	    -1443016191,
	4010497,     -1170414139, 280005,
#define _ZETA_EXP_4TO7_P3_L5 (_ZETA_EXP_4TO7_P3_L4 + 4 * 2)
	1484874664,  811944,	  -1636082790, 531354,	    -285388938,
	954230,	     -1983539117, 3881043,     -1495136972, 3900724,
	-950076368,  -2556880,	  -1714807468, 2071892,	    -952438995,
	-2797779,
#define _ZETA_EXP_4TO7_P3_L6 (_ZETA_EXP_4TO7_P3_L5 + 8 * 2)
	-695180180,  -695180180,  1422575624,  1422575624,  189548,
	189548,	     -3553272,	  -3553272,    -1375177022, -1375177022,
	1424130038,  1424130038,  3159746,     3159746,	    -1851402,
	-1851402,    1777179795,  1777179795,  -1185330464, -1185330464,
	-2409325,    -2409325,	  -177440,     -177440,	    334803717,
	334803717,   235321234,	  235321234,   1315589,	    1315589,
	1341330,     1341330,	  -178766299,  -178766299,  168022240,
	168022240,   1285669,	  1285669,     -1584928,    -1584928,
	-518252220,  -518252220,  1206536194,  1206536194,  -812732,
	-812732,     -1439742,	  -1439742,    1957047970,  1957047970,
	985155484,   985155484,	  -3019102,    -3019102,    -3881060,
	-3881060,    1146323031,  1146323031,  -894060583,  -894060583,
	-3628969,    -3628969,	  3839961,     3839961,
#define _ZETA_EXP_4TO7_P3_L7 (_ZETA_EXP_4TO7_P3_L6 + 16 * 2 * 2)
	-2047270596, 6087993,	  702390549,   -1547952704, -3038916,
	3523897,     3866901,	  269760,      -1723816713, -110126092,
	-279505433,  394851342,	  2213111,     -975884,	    1717735,
	472078,	     -1591599803, 565464272,   -260424530,  283780712,
	-426683,     1723600,	  -1803090,    1910376,	    -440824168,
	-1758099917, -71875110,	  776003547,   -1667432,    -1104333,
	-260646,     -3833893,	  1119856484,  -1600929361, -1208667171,
	1123958025,  -2939036,	  -2235985,    -420899,	    -2286327,
	1544891539,  879867909,	  -1499603926, 201262505,   183443,
	-976891,     1612842,	  -3545687,    155290192,   -1809756372,
	2036925262,  1934038751,  -554416,     3919660,	    -48306,
	-1362209,    -973777462,  400711272,   -540420426,  374860238,
	3937738,     1400424,	  -846154,     1976782,
#define _MASK_1100 (_ZETA_EXP_4TO7_P3_L7 + 32 * 2)
	0x03,	     0,		  0,	       0,
#define _MASK_1010 (_MASK_1100 + 4)
	0x05,	     0,		  0,	       0,
#define _MASK_0101 (_MASK_1010 + 4)
	0,	     1,		  0,	       1,
#define _MASK_2323 (_MASK_0101 + 4)
	2,	     3,		  2,	       3,
#define _MASK_1032 (_MASK_2323 + 4)
	1,	     0,		  3,	       2,
#define _ZETA_EXP_INTT_0TO3_P0_L0 (_MASK_1032 + 4)
	-374860238,  540420426,	  -400711272,  973777462,   -1976782,
	846154,	     -1400424,	  -3937738,    -1934038751, -2036925262,
	1809756372,  -155290192,  1362209,     48306,	    -3919660,
	554416,	     -201262505,  1499603926,  -879867909,  -1544891539,
	3545687,     -1612842,	  976891,      -183443,	    -1123958025,
	1208667171,  1600929361,  -1119856484, 2286327,	    420899,
	2235985,     2939036,	  -776003547,  71875110,    1758099917,
	440824168,   3833893,	  260646,      1104333,	    1667432,
	-283780712,  260424530,	  -565464272,  1591599803,  -1910376,
	1803090,     -1723600,	  426683,      -394851342,  279505433,
	110126092,   1723816713,  -472078,     -1717735,    975884,
	-2213111,    1547952704,  -702390549,  -6087993,    2047270596,
	-269760,     -3866901,	  -3523897,    3038916,
#define _ZETA_EXP_INTT_0TO3_P0_L1 (_ZETA_EXP_INTT_0TO3_P0_L0 + 32 * 2)
	894060583,   894060583,	  -1146323031, -1146323031, -3839961,
	-3839961,    3628969,	  3628969,     -985155484,  -985155484,
	-1957047970, -1957047970, 3881060,     3881060,	    3019102,
	3019102,     -1206536194, -1206536194, 518252220,   518252220,
	1439742,     1439742,	  812732,      812732,	    -168022240,
	-168022240,  178766299,	  178766299,   1584928,	    1584928,
	-1285669,    -1285669,	  -235321234,  -235321234,  -334803717,
	-334803717,  -1341330,	  -1341330,    -1315589,    -1315589,
	1185330464,  1185330464,  -1777179795, -1777179795, 177440,
	177440,	     2409325,	  2409325,     -1424130038, -1424130038,
	1375177022,  1375177022,  1851402,     1851402,	    -3159746,
	-3159746,    -1422575624, -1422575624, 695180180,   695180180,
	3553272,     3553272,	  -189548,     -189548,
#define _ZETA_EXP_INTT_0TO3_P0_L2 (_ZETA_EXP_INTT_0TO3_P0_L1 + 16 * 2 * 2)
	952438995,   2797779,	  1714807468,  -2071892,    950076368,
	2556880,     1495136972,  -3900724,    1983539117,  -3881043,
	285388938,   -954230,	  1636082790,  -531354,	    -1484874664,
	-811944,
#define _ZETA_EXP_INTT_0TO3_P0_L3 (_ZETA_EXP_INTT_0TO3_P0_L2 + 8 * 2)
	1170414139,  -280005,	  1443016191,  -4010497,    -1837364258,
	19422,	     -329347125,  -1757237,
#define _ZETA_EXP_INTT_0TO3_P1_L0 (_ZETA_EXP_INTT_0TO3_P0_L3 + 4 * 2)
	-1726753853, 596344473,	  1039370342,  853476187,   1799107,
	3694233,     -1652634,	  -810149,     883155599,   -827959816,
	1316619236,  2040058690,  -3014001,    -1616392,    -162844,
	3183426,     -2061661095, 384158533,   2126092136,  -1339088280,
	1207385,     -185531,	  -3369112,    -1957272,    1542497137,
	1357098057,  -173440395,  -1554794072, 164721,	    -2454455,
	-2432395,    2013608,	  -940195359,  -371462360,  -608791570,
	260312805,   3776993,	  -594136,     3724270,	    2584293,
	-713994583,  1276805128,  1021949428,  -756955444,  1846953,
	1671176,     2831860,	  542412,      -1405999311, 270590488,
	-604552167,  300448763,	  -3406031,    -2235880,    -777191,
	-1500165,    -1042326957, -1216882040, 1078959975,  -831969619,
	1374803,     2546312,	  -1917081,    1279661,
#define _ZETA_EXP_INTT_0TO3_P1_L1 (_ZETA_EXP_INTT_0TO3_P1_L0 + 32 * 2)
	1729304568,  1729304568,  1499481951,  1499481951,  1316856,
	1316856,     -759969,	  -759969,     -628664287,  -628664287,
	1999506068,  1999506068,  210977,      210977,	    -2389356,
	-2389356,    318346816,	  318346816,   1555941048,  1555941048,
	3249728,     3249728,	  -1653064,    -1653064,    1261461890,
	1261461890,  -675310538,  -675310538,  8578,	    8578,
	3724342,     3724342,	  -1210558298, -1210558298, -666258756,
	-666258756,  -3958618,	  -3958618,    -904516,	    -904516,
	-2143745726, -2143745726, 1784632064,  1784632064,  1100098,
	1100098,     -44288,	  -44288,      -1155548552, -1155548552,
	-1225434135, -1225434135, -3097992,    -3097992,    -508951,
	-508951,     916321552,	  916321552,   -1321868265, -1321868265,
	-264944,     -264944,	  3343383,     3343383,
#define _ZETA_EXP_INTT_0TO3_P1_L2 (_ZETA_EXP_INTT_0TO3_P1_L1 + 16 * 2 * 2)
	-2024403852, -3699596,	  -879957084,  1600420,	    -992097815,
	2140649,     1925356481,  -3507263,    -1831915353, 3821735,
	-418987550,  -3505694,	  901666090,   1643818,	    1750224323,
	1699267,
#define _ZETA_EXP_INTT_0TO3_P1_L3 (_ZETA_EXP_INTT_0TO3_P1_L2 + 8 * 2)
	748618600,   3277672,	  1257667337,  1399561,	    878576921,
	3859737,     -1654287830, 2118186,
#define _ZETA_EXP_INTT_0TO3_P2_L0 (_ZETA_EXP_INTT_0TO3_P1_L3 + 4 * 2)
	-1116720494, -419615363,  -963438279,  1045062172,  1962642,
	-3306115,    -1312455,	  451100,      -1779436847, 2070602178,
	-985022747,  -235104446,  1430225,     3318210,	    -1237275,
	1333058,     -1136965286, -671509323,  314284737,   -694382729,
	1050970,     -1903435,	  -1869119,    2994039,	    1287922800,
	-45766801,   72690498,	  1536588520,  3548272,	    -2635921,
	-1250494,    3767016,	  -6363718,    642772911,   1354528380,
	1637785316,  -1595974,	  -2486353,    -1247620,    -4055324,
	-1967222129, 635454918,	  1176751719,  1920467227,  -1265009,
	2590150,     -2691481,	  -2842341,    -1629985060, -137583815,
	-1851023419, 1223601433,  -203044,     -1735879,    3342277,
	-3437287,    -885133339,  1123881663,  -908452108,  -2124962073,
	-4108315,    2437823,	  -286988,     -342297,
#define _ZETA_EXP_INTT_0TO3_P2_L1 (_ZETA_EXP_INTT_0TO3_P2_L0 + 32 * 2)
	1669960606,  1669960606,  -1665705315, -1665705315, 1430430,
	1430430,     -1852771,	  -1852771,    120646188,   120646188,
	889861155,   889861155,	  -1349076,    -1349076,    381987,
	381987,	     -1638590967, -1638590967, 1018755525,  1018755525,
	1308169,     1308169,	  22981,       22981,	    -1787797779,
	-1787797779, -2135294594, -2135294594, 1228525,	    1228525,
	671102,	     671102,	  -1708872713, -1708872713, 1262003603,
	1262003603,  2477047,	  2477047,     411027,	    411027,
	86965173,    86965173,	  -289871779,  -289871779,  3693493,
	3693493,     2967645,	  2967645,     -1518161567, -1518161567,
	588790216,   588790216,	  -2715295,    -2715295,    -2147896,
	-2147896,    247357819,	  247357819,   783134478,   783134478,
	983419,	     983419,	  -3412210,    -3412210,
#define _ZETA_EXP_INTT_0TO3_P2_L2 (_ZETA_EXP_INTT_0TO3_P2_L1 + 16 * 2 * 2)
	1104976547,  539299,	  1661512036,  -2348700,    -2059733581,
	300467,	     1061813248,  -3539968,    -1797021249, 2867647,
	561427818,   -3574422,	  475984260,   3043716,	    202001019,
	3861115,
#define _ZETA_EXP_INTT_0TO3_P2_L3 (_ZETA_EXP_INTT_0TO3_P2_L2 + 8 * 2)
	-684667771,  2108549,	  346752664,   -2619752,    -222489248,
	1119584,     -1806278032, 549488,
#define _ZETA_EXP_INTT_0TO3_P3_L0 (_ZETA_EXP_INTT_0TO3_P2_L3 + 4 * 2)
	-1258381762, -128353682,  325927722,   -1819892093, 3595838,
	768622,	     525098,	  3556995,     -1931587462, 1372618620,
	-1747917558, -863641633,  -3207046,    -2031748,    3122442,
	655327,	     -1926727420, -2027935492, 818371958,   -1014493059,
	522500,	     43260,	  1613174,     -495491,	    -1257750362,
	517299994,   421552614,	  -14253662,   -819034,	    -909542,
	-1859098,    -900702,	  -1904936414, -1683520342, -1176904444,
	-2027833504, 3193378,	  1197226,     3759364,	    3520352,
	-2032221021, 326425360,	  44694137,    605900043,   -3513181,
	1235728,     -2434439,	  -266997,     1420958686,  -30313375,
	-912367099,  1363460238,  3562462,     2446433,	    -2244091,
	3342478,     -746144248,  -1363007700, -991903578,  898413,
	-3817976,    -2316500,	  -3407706,    -2091667,
#define _ZETA_EXP_INTT_0TO3_P3_L1 (_ZETA_EXP_INTT_0TO3_P3_L0 + 32 * 2)
	2131021878,  2131021878,  -568627424,  -568627424,  -126922,
	-126922,     3632928,	  3632928,     -1529189038, -1529189038,
	1440787840,  1440787840,  3157330,     3157330,	    3190144,
	3190144,     -1955560694, -1955560694, 993005454,   993005454,
	1000202,     1000202,	  4083598,     4083598,	    1039411342,
	1039411342,  1285853323,  1285853323,  -1939314,    -1939314,
	1257611,     1257611,	  -140455867,  -140455867,  -1599739335,
	-1599739335, 1585221,	  1585221,     -2176455,    -2176455,
	-1651689966, -1651689966, 2143979939,  2143979939,  -3475950,
	-3475950,    1452451,	  1452451,     1974159335,  1974159335,
	-1350681039, -1350681039, 3041255,     3041255,	    3677745,
	3677745,     654783359,	  654783359,   1574918427,  1574918427,
	1528703,     1528703,	  3930395,     3930395,
#define _ZETA_EXP_INTT_0TO3_P3_L2 (_ZETA_EXP_INTT_0TO3_P3_L1 + 16 * 2 * 2)
	594436433,   -3915439,	  1898723372,  2537516,	    1076973524,
	3592148,     -1594295555, 1661693,     -1838055109, -3530437,
	1404529459,  -3077325,	  1631226336,  -95776,	    1846138265,
	-2706023,
#define _ZETA_EXP_INTT_0TO3_P3_L3 (_ZETA_EXP_INTT_0TO3_P3_L2 + 8 * 2)
	-858240904,  -3585928,	  1364982364,  1079900,	    -2082316400,
	-1024112,    -1727305304, -2725464,
#define _ZETA_EXP_INTT_4TO7_L4 (_ZETA_EXP_INTT_0TO3_P3_L3 + 4 * 2)
	-625853735,  -2680103,	  285697463,   -3111497,    -515185417,
	2884855,     1929495947,  -3119733,    1091570561,  2091905,
	1374673747,  359251,	  1815525077,  -2353451,    -308362795,
	-1826347,
#define _ZETA_EXP_INTT_4TO7_L5 (_ZETA_EXP_INTT_4TO7_L4 + 8 * 2)
	-1640734244, -466468,	  -1612161320, 876248,	    -1477910808,
	777960,	     -1640767044, -237124,
#define _ZETA_EXP_INTT_4TO7_L6 (_ZETA_EXP_INTT_4TO7_L5 + 4 * 2)
	1927777021,  518909,	  1929875198,  2608894,
#define _ZETA_EXP_INTT_4TO7_L7 (_ZETA_EXP_INTT_4TO7_L6 + 2 * 2)
	151046689,   3975713,
};
