; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=x86_64-unknown-linux-gnu -passes=hwasan \
; RUN:   -hwasan-use-after-scope=1 -hwasan-generate-tags-with-calls -S < %s | \
; RUN:   FileCheck %s --check-prefixes=X86-SCOPE
; RUN: opt -mtriple=x86_64-unknown-linux-gnu -passes=hwasan \
; RUN:   -hwasan-use-after-scope=0 -hwasan-generate-tags-with-calls -S < %s | \
; RUN:   FileCheck %s --check-prefixes=X86-NOSCOPE

; RUN: opt -mtriple=aarch64-unknown-linux-android29 -passes=hwasan \
; RUN:   -hwasan-use-after-scope=1 -hwasan-generate-tags-with-calls -S < %s | \
; RUN:   FileCheck %s --check-prefixes=AARCH64-SCOPE
; RUN: opt -mtriple=aarch64-unknown-linux-android29 -passes=hwasan \
; RUN:   -hwasan-use-after-scope=0 -hwasan-generate-tags-with-calls -S < %s | \
; RUN:   FileCheck %s --check-prefixes=AARCH64-NOSCOPE
; RUN: opt -mtriple=aarch64-unknown-linux-android29 -passes=hwasan \
; RUN:   -hwasan-use-after-scope=1 -hwasan-generate-tags-with-calls \
; RUN:   -hwasan-use-short-granules=1 -S < %s | \
; RUN:   FileCheck %s --check-prefixes=AARCH64-SHORT-SCOPE
; RUN: opt -mtriple=aarch64-unknown-linux-android29 -passes=hwasan \
; RUN:   -hwasan-use-after-scope=0 -hwasan-generate-tags-with-calls \
; RUN:   -hwasan-use-short-granules=1 -S < %s | \
; RUN:   FileCheck %s --check-prefixes=AARCH64-SHORT-NOSCOPE


define dso_local i32 @standard_lifetime() local_unnamed_addr sanitize_hwaddress {
; X86-SCOPE-LABEL: @standard_lifetime(
; X86-SCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-SCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-SCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-SCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-SCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-SCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-SCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-SCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-SCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-SCOPE-NEXT:    br label [[TMP11:%.*]]
; X86-SCOPE:       11:
; X86-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    [[TMP12:%.*]] = trunc i64 [[TMP6]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP12]], i64 16)
; X86-SCOPE-NEXT:    [[TMP13:%.*]] = tail call i1 (...) @cond()
; X86-SCOPE-NEXT:    [[TMP14:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP14]], i64 16)
; X86-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    br i1 [[TMP13]], label [[TMP15:%.*]], label [[TMP11]]
; X86-SCOPE:       15:
; X86-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-SCOPE-NEXT:    ret i32 0
;
; X86-NOSCOPE-LABEL: @standard_lifetime(
; X86-NOSCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-NOSCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-NOSCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-NOSCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-NOSCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-NOSCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-NOSCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-NOSCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-NOSCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-NOSCOPE-NEXT:    br label [[TMP12:%.*]]
; X86-NOSCOPE:       12:
; X86-NOSCOPE-NEXT:    [[TMP13:%.*]] = tail call i1 (...) @cond()
; X86-NOSCOPE-NEXT:    br i1 [[TMP13]], label [[TMP14:%.*]], label [[TMP12]]
; X86-NOSCOPE:       14:
; X86-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-NOSCOPE-NEXT:    [[TMP15:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP15]], i64 16)
; X86-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SCOPE-LABEL: @standard_lifetime(
; AARCH64-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; AARCH64-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SCOPE-NEXT:    br label [[TMP25:%.*]]
; AARCH64-SCOPE:       25:
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    [[TMP26:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP27:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP28:%.*]] = and i64 [[TMP27]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP29:%.*]] = lshr i64 [[TMP28]], 4
; AARCH64-SCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP29]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP30]], i8 [[TMP26]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    [[TMP31:%.*]] = tail call i1 (...) @cond()
; AARCH64-SCOPE-NEXT:    [[TMP32:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP34:%.*]] = and i64 [[TMP33]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP35:%.*]] = lshr i64 [[TMP34]], 4
; AARCH64-SCOPE-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP35]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP36]], i8 [[TMP32]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    br i1 [[TMP31]], label [[TMP37:%.*]], label [[TMP25]]
; AARCH64-SCOPE:       37:
; AARCH64-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SCOPE-NEXT:    ret i32 0
;
; AARCH64-NOSCOPE-LABEL: @standard_lifetime(
; AARCH64-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; AARCH64-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    br label [[TMP30:%.*]]
; AARCH64-NOSCOPE:       30:
; AARCH64-NOSCOPE-NEXT:    [[TMP31:%.*]] = tail call i1 (...) @cond()
; AARCH64-NOSCOPE-NEXT:    br i1 [[TMP31]], label [[TMP32:%.*]], label [[TMP30]]
; AARCH64-NOSCOPE:       32:
; AARCH64-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-NOSCOPE-NEXT:    [[TMP33:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP34:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP35:%.*]] = and i64 [[TMP34]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP36:%.*]] = lshr i64 [[TMP35]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP37:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP36]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP37]], i8 [[TMP33]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-SCOPE-LABEL: @standard_lifetime(
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    br label [[TMP25:%.*]]
; AARCH64-SHORT-SCOPE:       25:
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP26:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP27:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP28:%.*]] = and i64 [[TMP27]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP29:%.*]] = lshr i64 [[TMP28]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP29]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP30]], i32 0
; AARCH64-SHORT-SCOPE-NEXT:    store i8 1, ptr [[TMP31]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP32:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-SCOPE-NEXT:    store i8 [[TMP26]], ptr [[TMP32]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP33:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP34:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP35:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP36:%.*]] = and i64 [[TMP35]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP37:%.*]] = lshr i64 [[TMP36]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP38:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP37]]
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP38]], i8 [[TMP34]], i64 1, i1 false)
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    br i1 [[TMP33]], label [[TMP39:%.*]], label [[TMP25]]
; AARCH64-SHORT-SCOPE:       39:
; AARCH64-SHORT-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-SCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-NOSCOPE-LABEL: @standard_lifetime(
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    br label [[TMP32:%.*]]
; AARCH64-SHORT-NOSCOPE:       32:
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP33:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-NOSCOPE-NEXT:    br i1 [[TMP33]], label [[TMP34:%.*]], label [[TMP32]]
; AARCH64-SHORT-NOSCOPE:       34:
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP35:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP36:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP37:%.*]] = and i64 [[TMP36]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP38:%.*]] = lshr i64 [[TMP37]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP39:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP38]]
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP39]], i8 [[TMP35]], i64 1, i1 false)
; AARCH64-SHORT-NOSCOPE-NEXT:    ret i32 0
;
  %1 = alloca i8, align 1
  br label %2

2:                                                ; preds = %2, %0
; We should tag the memory after the br (in the loop).
  call void @llvm.lifetime.start.p0(i64 1, ptr nonnull %1)
  %3 = tail call i1 (...) @cond() #2
; We should tag the memory before the next br (before the jump back).
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %1)
  br i1 %3, label %4, label %2

4:                                                ; preds = %2
  call void @use(ptr nonnull %1) #2
  ret i32 0
}

define dso_local i32 @standard_lifetime_optnone() local_unnamed_addr optnone noinline sanitize_hwaddress {
; X86-SCOPE-LABEL: @standard_lifetime_optnone(
; X86-SCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-SCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-SCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-SCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-SCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-SCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-SCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-SCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-SCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-SCOPE-NEXT:    br label [[TMP11:%.*]]
; X86-SCOPE:       11:
; X86-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    [[TMP12:%.*]] = trunc i64 [[TMP6]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP12]], i64 16)
; X86-SCOPE-NEXT:    [[TMP13:%.*]] = tail call i1 (...) @cond()
; X86-SCOPE-NEXT:    [[TMP14:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP14]], i64 16)
; X86-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    br i1 [[TMP13]], label [[TMP15:%.*]], label [[TMP11]]
; X86-SCOPE:       15:
; X86-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-SCOPE-NEXT:    ret i32 0
;
; X86-NOSCOPE-LABEL: @standard_lifetime_optnone(
; X86-NOSCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-NOSCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-NOSCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-NOSCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-NOSCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-NOSCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-NOSCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-NOSCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-NOSCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-NOSCOPE-NEXT:    br label [[TMP12:%.*]]
; X86-NOSCOPE:       12:
; X86-NOSCOPE-NEXT:    [[TMP13:%.*]] = tail call i1 (...) @cond()
; X86-NOSCOPE-NEXT:    br i1 [[TMP13]], label [[TMP14:%.*]], label [[TMP12]]
; X86-NOSCOPE:       14:
; X86-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-NOSCOPE-NEXT:    [[TMP15:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP15]], i64 16)
; X86-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SCOPE-LABEL: @standard_lifetime_optnone(
; AARCH64-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SCOPE-NEXT:    br label [[TMP25:%.*]]
; AARCH64-SCOPE:       25:
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    [[TMP26:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP27:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP28:%.*]] = and i64 [[TMP27]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP29:%.*]] = lshr i64 [[TMP28]], 4
; AARCH64-SCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP29]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP30]], i8 [[TMP26]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    [[TMP31:%.*]] = tail call i1 (...) @cond()
; AARCH64-SCOPE-NEXT:    [[TMP32:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP34:%.*]] = and i64 [[TMP33]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP35:%.*]] = lshr i64 [[TMP34]], 4
; AARCH64-SCOPE-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP35]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP36]], i8 [[TMP32]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    br i1 [[TMP31]], label [[TMP37:%.*]], label [[TMP25]]
; AARCH64-SCOPE:       37:
; AARCH64-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SCOPE-NEXT:    ret i32 0
;
; AARCH64-NOSCOPE-LABEL: @standard_lifetime_optnone(
; AARCH64-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    br label [[TMP30:%.*]]
; AARCH64-NOSCOPE:       30:
; AARCH64-NOSCOPE-NEXT:    [[TMP31:%.*]] = tail call i1 (...) @cond()
; AARCH64-NOSCOPE-NEXT:    br i1 [[TMP31]], label [[TMP32:%.*]], label [[TMP30]]
; AARCH64-NOSCOPE:       32:
; AARCH64-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-NOSCOPE-NEXT:    [[TMP33:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP34:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP35:%.*]] = and i64 [[TMP34]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP36:%.*]] = lshr i64 [[TMP35]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP37:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP36]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP37]], i8 [[TMP33]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-SCOPE-LABEL: @standard_lifetime_optnone(
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    br label [[TMP25:%.*]]
; AARCH64-SHORT-SCOPE:       25:
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP26:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP27:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP28:%.*]] = and i64 [[TMP27]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP29:%.*]] = lshr i64 [[TMP28]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP29]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP30]], i32 0
; AARCH64-SHORT-SCOPE-NEXT:    store i8 1, ptr [[TMP31]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP32:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-SCOPE-NEXT:    store i8 [[TMP26]], ptr [[TMP32]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP33:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP34:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP35:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP36:%.*]] = and i64 [[TMP35]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP37:%.*]] = lshr i64 [[TMP36]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP38:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP37]]
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP38]], i8 [[TMP34]], i64 1, i1 false)
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    br i1 [[TMP33]], label [[TMP39:%.*]], label [[TMP25]]
; AARCH64-SHORT-SCOPE:       39:
; AARCH64-SHORT-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-SCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-NOSCOPE-LABEL: @standard_lifetime_optnone(
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    br label [[TMP32:%.*]]
; AARCH64-SHORT-NOSCOPE:       32:
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP33:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-NOSCOPE-NEXT:    br i1 [[TMP33]], label [[TMP34:%.*]], label [[TMP32]]
; AARCH64-SHORT-NOSCOPE:       34:
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP35:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP36:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP37:%.*]] = and i64 [[TMP36]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP38:%.*]] = lshr i64 [[TMP37]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP39:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP38]]
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP39]], i8 [[TMP35]], i64 1, i1 false)
; AARCH64-SHORT-NOSCOPE-NEXT:    ret i32 0
;
  %1 = alloca i8, align 1
  br label %2

2:                                                ; preds = %2, %0
; We should tag the memory after the br (in the loop).
  call void @llvm.lifetime.start.p0(i64 1, ptr nonnull %1)
  %3 = tail call i1 (...) @cond() #2
; We should tag the memory before the next br (before the jump back).
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %1)
  br i1 %3, label %4, label %2

4:                                                ; preds = %2
  call void @use(ptr nonnull %1) #2
  ret i32 0
}

define dso_local i32 @multiple_lifetimes() local_unnamed_addr sanitize_hwaddress {
; X86-SCOPE-LABEL: @multiple_lifetimes(
; X86-SCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-SCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-SCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-SCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-SCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-SCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-SCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-SCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-SCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-SCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-SCOPE-NEXT:    [[TMP12:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP12]], i64 16)
; X86-SCOPE-NEXT:    ret i32 0
;
; X86-NOSCOPE-LABEL: @multiple_lifetimes(
; X86-NOSCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-NOSCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-NOSCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-NOSCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-NOSCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-NOSCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-NOSCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-NOSCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-NOSCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-NOSCOPE-NEXT:    [[TMP12:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP12]], i64 16)
; X86-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SCOPE-LABEL: @multiple_lifetimes(
; AARCH64-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SCOPE-NEXT:    [[TMP30:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP31:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP32:%.*]] = and i64 [[TMP31]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP33:%.*]] = lshr i64 [[TMP32]], 4
; AARCH64-SCOPE-NEXT:    [[TMP34:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP33]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP34]], i8 [[TMP30]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    ret i32 0
;
; AARCH64-NOSCOPE-LABEL: @multiple_lifetimes(
; AARCH64-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-NOSCOPE-NEXT:    [[TMP30:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP31:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP32:%.*]] = and i64 [[TMP31]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP33:%.*]] = lshr i64 [[TMP32]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP34:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP33]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP34]], i8 [[TMP30]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-SCOPE-LABEL: @multiple_lifetimes(
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-SCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-SCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP32:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP34:%.*]] = and i64 [[TMP33]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP35:%.*]] = lshr i64 [[TMP34]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP35]]
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP36]], i8 [[TMP32]], i64 1, i1 false)
; AARCH64-SHORT-SCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-NOSCOPE-LABEL: @multiple_lifetimes(
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP32:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP34:%.*]] = and i64 [[TMP33]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP35:%.*]] = lshr i64 [[TMP34]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP35]]
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP36]], i8 [[TMP32]], i64 1, i1 false)
; AARCH64-SHORT-NOSCOPE-NEXT:    ret i32 0
;
  %1 = alloca i8, align 1
; We erase lifetime markers if we insert instrumentation outside of the
; lifetime.
  call void @llvm.lifetime.start.p0(i64 1, ptr nonnull %1)
  call void @use(ptr nonnull %1) #2
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %1)
  call void @llvm.lifetime.start.p0(i64 1, ptr nonnull %1)
  call void @use(ptr nonnull %1) #2
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %1)
  ret i32 0
}

define dso_local i32 @unreachable_exit() local_unnamed_addr sanitize_hwaddress {
; X86-SCOPE-LABEL: @unreachable_exit(
; X86-SCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-SCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-SCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-SCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-SCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-SCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-SCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-SCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-SCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-SCOPE-NEXT:    [[TMP12:%.*]] = tail call i1 (...) @cond()
; X86-SCOPE-NEXT:    br i1 [[TMP12]], label [[TMP13:%.*]], label [[TMP15:%.*]]
; X86-SCOPE:       13:
; X86-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-SCOPE-NEXT:    [[TMP14:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP14]], i64 16)
; X86-SCOPE-NEXT:    ret i32 0
; X86-SCOPE:       15:
; X86-SCOPE-NEXT:    [[TMP16:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP16]], i64 16)
; X86-SCOPE-NEXT:    ret i32 0
;
; X86-NOSCOPE-LABEL: @unreachable_exit(
; X86-NOSCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-NOSCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-NOSCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-NOSCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-NOSCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-NOSCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-NOSCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-NOSCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-NOSCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-NOSCOPE-NEXT:    [[TMP12:%.*]] = tail call i1 (...) @cond()
; X86-NOSCOPE-NEXT:    br i1 [[TMP12]], label [[TMP13:%.*]], label [[TMP15:%.*]]
; X86-NOSCOPE:       13:
; X86-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-NOSCOPE-NEXT:    [[TMP14:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP14]], i64 16)
; X86-NOSCOPE-NEXT:    ret i32 0
; X86-NOSCOPE:       15:
; X86-NOSCOPE-NEXT:    [[TMP16:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP16]], i64 16)
; X86-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SCOPE-LABEL: @unreachable_exit(
; AARCH64-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    [[TMP30:%.*]] = tail call i1 (...) @cond()
; AARCH64-SCOPE-NEXT:    br i1 [[TMP30]], label [[TMP31:%.*]], label [[TMP37:%.*]]
; AARCH64-SCOPE:       31:
; AARCH64-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SCOPE-NEXT:    [[TMP32:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP34:%.*]] = and i64 [[TMP33]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP35:%.*]] = lshr i64 [[TMP34]], 4
; AARCH64-SCOPE-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP35]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP36]], i8 [[TMP32]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    ret i32 0
; AARCH64-SCOPE:       37:
; AARCH64-SCOPE-NEXT:    [[TMP38:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP39:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP40:%.*]] = and i64 [[TMP39]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP41:%.*]] = lshr i64 [[TMP40]], 4
; AARCH64-SCOPE-NEXT:    [[TMP42:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP41]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP42]], i8 [[TMP38]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    ret i32 0
;
; AARCH64-NOSCOPE-LABEL: @unreachable_exit(
; AARCH64-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    [[TMP30:%.*]] = tail call i1 (...) @cond()
; AARCH64-NOSCOPE-NEXT:    br i1 [[TMP30]], label [[TMP31:%.*]], label [[TMP37:%.*]]
; AARCH64-NOSCOPE:       31:
; AARCH64-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-NOSCOPE-NEXT:    [[TMP32:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP34:%.*]] = and i64 [[TMP33]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP35:%.*]] = lshr i64 [[TMP34]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP35]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP36]], i8 [[TMP32]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    ret i32 0
; AARCH64-NOSCOPE:       37:
; AARCH64-NOSCOPE-NEXT:    [[TMP38:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP39:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP40:%.*]] = and i64 [[TMP39]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP41:%.*]] = lshr i64 [[TMP40]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP42:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP41]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP42]], i8 [[TMP38]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-SCOPE-LABEL: @unreachable_exit(
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-SCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-SCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP32:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-SCOPE-NEXT:    br i1 [[TMP32]], label [[TMP33:%.*]], label [[TMP39:%.*]]
; AARCH64-SHORT-SCOPE:       33:
; AARCH64-SHORT-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP34:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP35:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP36:%.*]] = and i64 [[TMP35]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP37:%.*]] = lshr i64 [[TMP36]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP38:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP37]]
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP38]], i8 [[TMP34]], i64 1, i1 false)
; AARCH64-SHORT-SCOPE-NEXT:    ret i32 0
; AARCH64-SHORT-SCOPE:       39:
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP40:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP41:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP42:%.*]] = and i64 [[TMP41]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP43:%.*]] = lshr i64 [[TMP42]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP44:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP43]]
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP44]], i8 [[TMP40]], i64 1, i1 false)
; AARCH64-SHORT-SCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-NOSCOPE-LABEL: @unreachable_exit(
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP32:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-NOSCOPE-NEXT:    br i1 [[TMP32]], label [[TMP33:%.*]], label [[TMP39:%.*]]
; AARCH64-SHORT-NOSCOPE:       33:
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP34:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP35:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP36:%.*]] = and i64 [[TMP35]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP37:%.*]] = lshr i64 [[TMP36]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP38:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP37]]
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP38]], i8 [[TMP34]], i64 1, i1 false)
; AARCH64-SHORT-NOSCOPE-NEXT:    ret i32 0
; AARCH64-SHORT-NOSCOPE:       39:
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP40:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP41:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP42:%.*]] = and i64 [[TMP41]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP43:%.*]] = lshr i64 [[TMP42]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP44:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP43]]
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP44]], i8 [[TMP40]], i64 1, i1 false)
; AARCH64-SHORT-NOSCOPE-NEXT:    ret i32 0
;
  %1 = alloca i8, align 1
  call void @llvm.lifetime.start.p0(i64 1, ptr nonnull %1)
  %2 = tail call i1 (...) @cond() #2
  br i1 %2, label %3, label %4

3:
  call void @use(ptr nonnull %1) #2
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %1)
  ret i32 0

4:
  ret i32 0
}

define dso_local i32 @diamond_lifetime() local_unnamed_addr sanitize_hwaddress {
; X86-SCOPE-LABEL: @diamond_lifetime(
; X86-SCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-SCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-SCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-SCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-SCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-SCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-SCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-SCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-SCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-SCOPE-NEXT:    [[TMP12:%.*]] = tail call i1 (...) @cond()
; X86-SCOPE-NEXT:    br i1 [[TMP12]], label [[TMP13:%.*]], label [[TMP15:%.*]]
; X86-SCOPE:       13:
; X86-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-SCOPE-NEXT:    [[TMP14:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP14]], i64 16)
; X86-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    br label [[TMP17:%.*]]
; X86-SCOPE:       15:
; X86-SCOPE-NEXT:    [[TMP16:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-SCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP16]], i64 16)
; X86-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP4]])
; X86-SCOPE-NEXT:    br label [[TMP17]]
; X86-SCOPE:       17:
; X86-SCOPE-NEXT:    ret i32 0
;
; X86-NOSCOPE-LABEL: @diamond_lifetime(
; X86-NOSCOPE-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; X86-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; X86-NOSCOPE-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; X86-NOSCOPE-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 57
; X86-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = and i64 [[TMP3]], 63
; X86-NOSCOPE-NEXT:    [[TMP4:%.*]] = alloca { i8, [15 x i8] }, align 16
; X86-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i8 @__hwasan_generate_tag()
; X86-NOSCOPE-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; X86-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP4]] to i64
; X86-NOSCOPE-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], -9079256848778919937
; X86-NOSCOPE-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 57
; X86-NOSCOPE-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; X86-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; X86-NOSCOPE-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP11]], i64 16)
; X86-NOSCOPE-NEXT:    [[TMP12:%.*]] = tail call i1 (...) @cond()
; X86-NOSCOPE-NEXT:    br i1 [[TMP12]], label [[TMP13:%.*]], label [[TMP14:%.*]]
; X86-NOSCOPE:       13:
; X86-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; X86-NOSCOPE-NEXT:    br label [[TMP15:%.*]]
; X86-NOSCOPE:       14:
; X86-NOSCOPE-NEXT:    br label [[TMP15]]
; X86-NOSCOPE:       15:
; X86-NOSCOPE-NEXT:    [[TMP16:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; X86-NOSCOPE-NEXT:    call void @__hwasan_tag_memory(ptr [[TMP4]], i8 [[TMP16]], i64 16)
; X86-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SCOPE-LABEL: @diamond_lifetime(
; AARCH64-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    [[TMP30:%.*]] = tail call i1 (...) @cond()
; AARCH64-SCOPE-NEXT:    br i1 [[TMP30]], label [[TMP31:%.*]], label [[TMP37:%.*]]
; AARCH64-SCOPE:       31:
; AARCH64-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SCOPE-NEXT:    [[TMP32:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP34:%.*]] = and i64 [[TMP33]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP35:%.*]] = lshr i64 [[TMP34]], 4
; AARCH64-SCOPE-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP35]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP36]], i8 [[TMP32]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    br label [[TMP43:%.*]]
; AARCH64-SCOPE:       37:
; AARCH64-SCOPE-NEXT:    [[TMP38:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SCOPE-NEXT:    [[TMP39:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SCOPE-NEXT:    [[TMP40:%.*]] = and i64 [[TMP39]], 72057594037927935
; AARCH64-SCOPE-NEXT:    [[TMP41:%.*]] = lshr i64 [[TMP40]], 4
; AARCH64-SCOPE-NEXT:    [[TMP42:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP41]]
; AARCH64-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP42]], i8 [[TMP38]], i64 1, i1 false)
; AARCH64-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SCOPE-NEXT:    br label [[TMP43]]
; AARCH64-SCOPE:       43:
; AARCH64-SCOPE-NEXT:    ret i32 0
;
; AARCH64-NOSCOPE-LABEL: @diamond_lifetime(
; AARCH64-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    [[TMP30:%.*]] = tail call i1 (...) @cond()
; AARCH64-NOSCOPE-NEXT:    br i1 [[TMP30]], label [[TMP31:%.*]], label [[TMP32:%.*]]
; AARCH64-NOSCOPE:       31:
; AARCH64-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-NOSCOPE-NEXT:    br label [[TMP33:%.*]]
; AARCH64-NOSCOPE:       32:
; AARCH64-NOSCOPE-NEXT:    br label [[TMP33]]
; AARCH64-NOSCOPE:       33:
; AARCH64-NOSCOPE-NEXT:    [[TMP34:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-NOSCOPE-NEXT:    [[TMP35:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-NOSCOPE-NEXT:    [[TMP36:%.*]] = and i64 [[TMP35]], 72057594037927935
; AARCH64-NOSCOPE-NEXT:    [[TMP37:%.*]] = lshr i64 [[TMP36]], 4
; AARCH64-NOSCOPE-NEXT:    [[TMP38:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP37]]
; AARCH64-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP38]], i8 [[TMP34]], i64 1, i1 false)
; AARCH64-NOSCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-SCOPE-LABEL: @diamond_lifetime(
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-SCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-SCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-SCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-SCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP32:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-SCOPE-NEXT:    br i1 [[TMP32]], label [[TMP33:%.*]], label [[TMP39:%.*]]
; AARCH64-SHORT-SCOPE:       33:
; AARCH64-SHORT-SCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP34:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP35:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP36:%.*]] = and i64 [[TMP35]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP37:%.*]] = lshr i64 [[TMP36]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP38:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP37]]
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP38]], i8 [[TMP34]], i64 1, i1 false)
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    br label [[TMP45:%.*]]
; AARCH64-SHORT-SCOPE:       39:
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP40:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP41:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP42:%.*]] = and i64 [[TMP41]], 72057594037927935
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP43:%.*]] = lshr i64 [[TMP42]], 4
; AARCH64-SHORT-SCOPE-NEXT:    [[TMP44:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP43]]
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP44]], i8 [[TMP40]], i64 1, i1 false)
; AARCH64-SHORT-SCOPE-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[TMP18]])
; AARCH64-SHORT-SCOPE-NEXT:    br label [[TMP45]]
; AARCH64-SHORT-SCOPE:       45:
; AARCH64-SHORT-SCOPE-NEXT:    ret i32 0
;
; AARCH64-SHORT-NOSCOPE-LABEL: @diamond_lifetime(
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP1:%.*]] = call ptr @llvm.thread.pointer()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[TMP1]], i32 48
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP4:%.*]] = ashr i64 [[TMP3]], 3
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP5:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1]])
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP6:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[TMP6]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP8:%.*]] = shl i64 [[TMP7]], 44
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP9:%.*]] = or i64 [[TMP5]], [[TMP8]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP3]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP9]], ptr [[TMP10]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP11:%.*]] = ashr i64 [[TMP3]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP12:%.*]] = shl nuw nsw i64 [[TMP11]], 12
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], -1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP14:%.*]] = add i64 [[TMP3]], 8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], [[TMP13]]
; AARCH64-SHORT-NOSCOPE-NEXT:    store i64 [[TMP15]], ptr [[TMP2]], align 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP16:%.*]] = or i64 [[TMP3]], 4294967295
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP16]], 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP7]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP18:%.*]] = alloca { i8, [15 x i8] }, align 16
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP19:%.*]] = call i8 @__hwasan_generate_tag()
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP20:%.*]] = zext i8 [[TMP19]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP21:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP22:%.*]] = and i64 [[TMP21]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP23:%.*]] = shl i64 [[TMP20]], 56
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP24:%.*]] = or i64 [[TMP22]], [[TMP23]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[ALLOCA_0_HWASAN:%.*]] = inttoptr i64 [[TMP24]] to ptr
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP25:%.*]] = trunc i64 [[TMP20]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP28]]
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP30:%.*]] = getelementptr i8, ptr [[TMP29]], i32 0
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 1, ptr [[TMP30]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP18]], i32 15
; AARCH64-SHORT-NOSCOPE-NEXT:    store i8 [[TMP25]], ptr [[TMP31]], align 1
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP32:%.*]] = tail call i1 (...) @cond()
; AARCH64-SHORT-NOSCOPE-NEXT:    br i1 [[TMP32]], label [[TMP33:%.*]], label [[TMP34:%.*]]
; AARCH64-SHORT-NOSCOPE:       33:
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @use(ptr nonnull [[ALLOCA_0_HWASAN]])
; AARCH64-SHORT-NOSCOPE-NEXT:    br label [[TMP35:%.*]]
; AARCH64-SHORT-NOSCOPE:       34:
; AARCH64-SHORT-NOSCOPE-NEXT:    br label [[TMP35]]
; AARCH64-SHORT-NOSCOPE:       35:
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP36:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP37:%.*]] = ptrtoint ptr [[TMP18]] to i64
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP38:%.*]] = and i64 [[TMP37]], 72057594037927935
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP39:%.*]] = lshr i64 [[TMP38]], 4
; AARCH64-SHORT-NOSCOPE-NEXT:    [[TMP40:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP39]]
; AARCH64-SHORT-NOSCOPE-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP40]], i8 [[TMP36]], i64 1, i1 false)
; AARCH64-SHORT-NOSCOPE-NEXT:    ret i32 0
;
  %1 = alloca i8, align 1
  call void @llvm.lifetime.start.p0(i64 1, ptr nonnull %1)
  %2 = tail call i1 (...) @cond() #2
  br i1 %2, label %3, label %4

3:
  call void @use(ptr nonnull %1) #2
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %1)
  br label %5

4:
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %1)
  br label %5

5:
  ret i32 0
}

declare dso_local i1 @cond(...) local_unnamed_addr

declare dso_local void @use(ptr) local_unnamed_addr

; Function Attrs: argmemonly mustprogress nofree nosync nounwind willreturn
declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)

; Function Attrs: argmemonly mustprogress nofree nosync nounwind willreturn
declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)
