# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


### UI strings for the MR1 onboarding / multistage about:welcome
### Various strings use a non-breaking space to avoid a single dangling /
### widowed word, so test on various window sizes if you also want this.


## Welcome page strings

onboarding-welcome-header = { -brand-short-name } ലേക്ക് സ്വാഗതം
onboarding-start-browsing-button-label = തിരയാൻ ആരംഭിക്കുക
onboarding-not-now-button-label = ഇപ്പോഴല്ല
mr1-onboarding-get-started-primary-button-label = തുടങ്ങാം

## Custom Return To AMO onboarding strings

return-to-amo-subtitle = അടിപൊളി, താങ്ങൾക്കു് { -brand-short-name } ലഭിച്ചു
# <img data-l10n-name="icon"/> will be replaced with the icon belonging to the extension
#
# Variables:
#   $addon-name (String) - Name of the add-on
return-to-amo-addon-title = ഇപ്പോൾ താങ്ങളോടു് കൊണ്ടുവരാം <img data-l10n-name="icon"/> <b>{ $addon-name }</b>.
return-to-amo-add-extension-label = വിപുലീകരണം ചേർക്കുക
return-to-amo-add-theme-label = അലങ്കാരം ചേൎക്കുക
return-to-amo-theme-install-complete-label = അലങ്കാരം സ്ഥാപിച്ചു

##  Variables: $addon-name (String) - Name of the add-on to be installed

mr1-return-to-amo-subtitle = { -brand-short-name }-നോടു് ഹലോ പറയാം
mr1-return-to-amo-add-extension-label = { $addon-name } ചേൎക്കുക

## Multistage onboarding strings (about:welcome pages)


# Aria-label to make the "steps" of multistage onboarding visible to screen readers.
# Variables:
#   $current (Int) - Number of the current page
#   $total (Int) - Total number of pages

onboarding-welcome-steps-indicator-label =
    .aria-label = മുന്നേറ്റം: { $total }-ൽ { $current }-ആം പടി
# String for the Firefox Accounts button
mr1-onboarding-sign-in-button-label = പ്രവേശിക്കുക
# The primary import button label will depend on whether we can detect which browser was used to download Firefox.
# Variables:
#   $previous (Str) - Previous browser name, such as Edge, Chrome
mr1-onboarding-import-primary-button-label-attribution = { $previous } നിന്നു് ഇറക്കുമതി ചെയ്യുക
mr1-onboarding-theme-header = താങ്ങളുടെ സ്വന്തമാക്കുക
mr1-onboarding-theme-subtitle = ഒരു അലങ്കാരം കൂടെ { -brand-short-name } വ്യക്തിപരമാക്കുക
mr1-onboarding-theme-secondary-button-label = ഇപ്പോഴല്ല
newtab-wallpaper-onboarding-primary-button-label = ചുവൎക്കടലാസു് ഇടുക
# System theme uses operating system color settings
mr1-onboarding-theme-label-system = വ്യവസ്ഥ അലങ്കാരം
mr1-onboarding-theme-label-light = തെളിച്ചം
mr1-onboarding-theme-label-dark = ഇരുണ്ടത്
onboarding-theme-primary-button-label = കഴിഞ്ഞു

## Please make sure to split the content of the title attribute into lines whose
## width corresponds to about 40 Latin characters, to ensure that the tooltip
## doesn't become too long. Line breaks will be preserved when displaying the
## tooltip.

# Tooltip displayed on hover of light theme
mr1-onboarding-theme-tooltip-light =
    .title = ജാലകങ്ങൾക്കും ബട്ടണുകൾക്കും കുറിപ്പടിക്കട്ടകൾക്കും ഒരു ഇളം അലങ്കാരം ഉപയോഗിക്കുക.
# Input description for light theme
mr1-onboarding-theme-description-light =
    .aria-description = ജാലകങ്ങൾക്കും ബട്ടണുകൾക്കും കുറിപ്പടിക്കട്ടകൾക്കും ഒരു ഇളഞ്ഞ അലങ്കാരം ഉപയോഗിക്കുക.
# Tooltip displayed on hover of dark theme
mr1-onboarding-theme-tooltip-dark =
    .title = ജാലകങ്ങൾക്കും ബട്ടണുകൾക്കും കുറിപ്പടിക്കട്ടകൾക്കും ഒരു ഇരുണ്ട അലങ്കാരം ഉപയോഗിക്കുക.
# Input description for dark theme
mr1-onboarding-theme-description-dark =
    .aria-description = ജാലകങ്ങൾക്കും ബട്ടണുകൾക്കും കുറിപ്പടിക്കട്ടകൾക്കും ഒരു ഇരുണ്ട അലങ്കാരം ഉപയോഗിക്കുക.
# Selector description for default themes
mr2-onboarding-default-theme-label = തനിമട്ട അലങ്കാരങ്ങൾ ആരായുക

## Strings for Thank You page

mr2-onboarding-thank-you-header = ഞങ്ങളെ തിരഞ്ഞെടുത്തതിനു് നന്ദി
mr2-onboarding-start-browsing-button-label = തിരയാൻ തുടങ്ങുക.

## Multistage live language reloading onboarding strings (about:welcome pages)
##
## The following language names are generated by the browser's Intl.DisplayNames API.
##
## Variables:
##   $negotiatedLanguage (String) - The name of the langpack's language, e.g. "Español (ES)"
##   $systemLanguage (String) - The name of the system language, e.g "Español (ES)"
##   $appLanguage (String) - The name of the language shipping in the browser build, e.g. "English (EN)"

onboarding-live-language-header = ഭാഷ തിഞ്ഞെടുക്കുക
mr2022-onboarding-live-language-text = { -brand-short-name } താങ്ങളുടെ ഭാഷയിൽ സംസാരിക്കാരുണ്ടു്.
onboarding-live-language-waiting-button = ഉള്ള ഭാഷകൾ കൊണ്ടുവരുന്നു...
mr2022-onboarding-live-language-switch-to = { $negotiatedLanguage }-ലോട്ടു് മാറുക
mr2022-onboarding-live-language-continue-in = { $appLanguage }-ൽ തുടരുക
onboarding-live-language-secondary-cancel-download = റദ്ദാക്കുക
onboarding-live-language-skip-button-label = ഒഴിവാക്കുക

## Firefox 100 Thank You screens

fx100-upgrade-thanks-header = 100-ഓളം നന്നികൾ
mr2022-onboarding-secondary-skip-button-label = ഈ പടി ഒഴിവാക്കുക

## MR2022 New User Easy Setup screen strings

# Primary button string used on new user onboarding first screen showing multiple actions such as Set Default, Import from previous browser.
mr2022-onboarding-easy-setup-primary-button-label = കരുതിവച്ചിട്ടു് തുടരുക
# Set Default action checkbox label used on new user onboarding first screen
mr2022-onboarding-easy-setup-set-default-checkbox-label = { -brand-short-name } തനിമിട്ടമാക്കി വയ്ക്കുക
# Import action checkbox label used on new user onboarding first screen
mr2022-onboarding-easy-setup-import-checkbox-label = മുമ്പത്തെ അന്വേഷിയന്ത്രം നിന്നു് ഇറക്കുമതി ചെയ്യുക

## MR2022 New User Pin Firefox screen strings

# Title used on about:welcome for new users when Firefox is not pinned.
# In this context, open up is synonymous with "Discover".
# The metaphor is that when they open their Firefox browser, it helps them discover an amazing internet.
# If this translation does not make sense in your language, feel free to use the word "discover."
mr2022-onboarding-welcome-pin-header = ഒരു അടിപ്പൊളി ഗോളാന്തരവലയിൽ ആരായുവിൻ
# Primary button string used on welcome page for when Firefox is not pinned.
mr2022-onboarding-pin-primary-button-label =
    { PLATFORM() ->
        [macos] { -brand-short-name }-നെ കാര്യപ്പട്ടയിൽ കുത്തിവയ്ക്കുക
       *[other] { -brand-short-name }-നെ കാര്യപ്പട്ടയിൽ കുത്തിവയ്ക്കുക
    }
# Primary button string used on welcome page for when Firefox is not pinned on MSIX
mr2022-onboarding-pin-primary-button-label-msix = { -brand-short-name }-നെ കാര്യപ്പട്ടയിലും തുടക്കക്കുറിപ്പടിയിലും കുത്തിവയ്ക്കുക

## MR2022 Existing User Pin Firefox Screen Strings

mr2022-onboarding-existing-pin-checkbox-label = കൂടാതെ { -brand-short-name }-നെയും സ്വകാര്യ തിരച്ചിലിലോട്ടു് ചേൎക്കുക

## MR2022 New User Set Default screen strings

# This string is the title used when the user already has pinned the browser, but has not set default.
mr2022-onboarding-set-default-title = { -brand-short-name }-നെ താങ്ങളുടെ തനിമട്ട അന്വേഷിയന്ത്രമാക്കുക
mr2022-onboarding-set-default-primary-button-label = { -brand-short-name } തനിമട്ടമാക്കി വയ്ക്കുക

## MR2022 Get Started screen strings.
## These strings will be used on the welcome page
## when Firefox is already set to default and pinned.

mr2022-onboarding-get-started-primary-button-label = നിമിഷങ്ങൾക്കുള്ളിൽ സജ്ജമാക്കുക

## MR2022 Get Started screen strings.
## These strings will be used on the welcome page
## when Firefox is already set to default and pinned.

mr2022-onboarding-import-primary-button-label-no-attribution = മുമ്പത്തെ അന്വേഷിയന്ത്രം നിന്നു് ഇറക്കുമതി ചെയ്യുക

## If your language uses grammatical genders, in the description for the
## colorway feel free to switch from "You are a X. You…" (e.g. "You are a
## Playmaker. You create…") to "X: you…" ("Playmaker: You create…"). This might
## help creating a more inclusive translation.

mr2022-onboarding-colorway-primary-button-label-continue = തീൎച്ചപ്പെടുത്തിയിട്ടു് തുടരുക
mr2022-onboarding-colorway-label-default = തനിമട്ട്
mr2022-onboarding-colorway-tooltip-dreamer2 =
    .title = വിനവുക്കാണി (ഊതന്നിറം)

## MR2022 Multistage Mobile Download screen strings


## MR2022 Upgrade Dialog screens
## Pin private window screen shown only for users who don't have Firefox private pinned

mr2022-upgrade-onboarding-pin-private-window-header = ഒരു അമൎത്തലിൽ സ്വകാര്യ തിരച്ചിൽ സ്വാതന്ത്രം നേടുക
mr2022-upgrade-onboarding-pin-private-window-subtitle = താങ്ങളുടെ ഉപരിഫലകം നിന്ന് തന്നെ, കുക്കികളും നാൾവഴിയും കരുതിവയ്ക്കാതെ ആരും കാണാത്ത പോലെ പരതുക.

## MR2022 Privacy Segmentation screen strings

mr2022-onboarding-privacy-segmentation-title = താങ്ങളുടെ സ്വകാര്യതായെ ഞങ്ങൾ എപ്പോഴും മാനിക്കാറുണ്ടു്
mr2022-onboarding-privacy-segmentation-button-secondary-label = വിശദമായ വിവരങ്ങൾ കാണിക്കുക

## MR2022 Multistage Gratitude screen strings

mr2022-onboarding-gratitude-primary-button-label = പുതിയതായി എന്താണ് ഉള്ളത് എന്ന് കാണുക.
mr2022-onboarding-gratitude-secondary-button-label = തിരയാൻ തുടങ്ങുക.

## Onboarding spotlight for infrequent users

onboarding-infrequent-import-primary-button = { -brand-short-name }-ലോട്ടു് ഇറക്കുമതി ചെയ്യുക

## MR2022 Illustration alt tags
## Descriptive tags for illustrations used by screen readers and other assistive tech


## Device migration onboarding

onboarding-device-migration-title = തിരികെ സ്വാഗതം
onboarding-device-migration-primary-button-label = പ്രവേശിക്കുക

## Add-ons Picker screen

amo-picker-title = { -brand-short-name } ഇഷ്ടാനുസൃതമാക്കുക
amo-picker-install-button-label = { -brand-short-name }-ലോട്ടു് ചേൎക്കുക
amo-picker-install-complete-label = സ്ഥാപിച്ചതു്
amo-picker-collection-link = കൂടുതൽ ആഡോണുകൾ ആരായുക

## The following screens have been updated to use security and privacy focused strings:

# Easy setup screen
onboarding-easy-setup-security-and-privacy-title = താങ്ങളെ സുരക്ഷിതമായി വയ്ക്കാൻ ഞങ്ങളുടെ കടമയാണു്
onboarding-easy-setup-security-and-privacy-subtitle = ഞങ്ങളുടെ ലാഭേച്ഛയില്ലാത്ത അന്വേഷിയന്ത്രം താങ്ങളെ വെബിലുടനീളം ഒളിമായി പിന്തുടരുന്നതിൽ നിന്ന് കമ്പനികളെ തടയാൻ സഹായിക്കുന്നു.
# Mobile download screen
onboarding-mobile-download-security-and-privacy-title = താങ്ങൾ ഉപകരണങ്ങൾക്കിടയിൽ ചാടുമ്പോഴു്  രൂപമാറ്റം വരുത്തിയിരിക്കുക
# Gratitude screen
onboarding-gratitude-security-and-privacy-title = { -brand-short-name } താങ്ങളുടെ പിന്തുണയോടെയുണ്ട്.
# Sign up or Sign in screen
onboarding-sign-up-title = ഉപകരണങ്ങൾ കുറുകെ ഒളിവാക്കുകൾ സമന്വയിപ്പിക്കുക
onboarding-sign-up-button = പ്രവേശിക്കുക അല്ലെങ്കിൽ അംഗത്വം എടുക്കുക
onboarding-sign-up-secondary-button = തിരയാൻ തുടങ്ങുക.

## New user time and familiarity survey strings

onboarding-new-user-time-based-survey-title = താങ്ങൾ എത്ര നേരത്തോട്ടു് { -brand-short-name } ഉപയോഗിക്കുന്നു ?
# When translating "next" it means the next screen in onboarding.
onboarding-new-user-survey-next-button-label = അടുത്തതു്
# When translating "brand new" it means completely new.
onboarding-new-user-survey-time-based-option-1 = ഞാൻ പുതിയതാണു്
onboarding-new-user-survey-time-based-option-2 = ഒരു മാസത്തിനെക്കാളും കുറച്ചു്
onboarding-new-user-survey-time-based-option-3 = പതിവായി ഒരു മാസത്തിനെക്കാളും കൂടുതൽ
onboarding-new-user-survey-time-based-option-4 = ഒരു മാസത്തിനെക്കാളും കൂടുതൽ, ഇടയ്ക്കിടെ
# When translating "brand new" it means completely new.
onboarding-new-user-survey-familiarity-based-option-1 = ഞാൻ പുതിയതാണു്
onboarding-new-user-survey-familiarity-based-option-2 = ഇച്ചിരി ഉപയോഗിച്ചിട്ടുണ്ടു്
onboarding-new-user-survey-familiarity-based-option-3 = എനിക്കു് ഇതു് ഉപയോഗിക്കാൻ നല്ലോണം അറിയാം
onboarding-new-user-survey-familiarity-based-option-4 = മുൻപു് ഞാൻ ഇതിനെ ഉപയോഗിച്ചിട്ടുണ്ടു്, പക്ഷേ അതു് ആയിട്ടു് ഇച്ചിരി നേരമായി

## UI strings for the sidebar and vertical tabs

# Setup screen for vertical tabs - too many tabs variation
onboarding-many-tabs-title = താങ്ങളുടെ ടാബുകൾ, താങ്ങളുടെ വഴി
# Text underneath an image used for selecting browser tabs to appear on the side of the browser.
onboarding-new-vertical-tabs-label = അരികിൽ ടാബുകൾ
# Text underneath an image used for selecting browser tabs to appear at the top of the browser.
onboarding-new-horizontal-tabs-label = മുകളിൽ ടാബുകൾ
onboarding-flair-text = പുതിയതു്!
onboarding-genai-sidebar-secondary-button = തിരയാൻ തുടങ്ങുക.

## New user onboarding checklist

onboarding-checklist-set-default = { -brand-short-name } തനിമിട്ടമാക്കി വയ്ക്കുക
onboarding-checklist-pin = { -brand-short-name }-നെ കാര്യപ്പട്ടയിൽ കുത്തിവയ്ക്കുക
onboarding-checklist-import = മുമ്പത്തെ അന്വേഷിയന്ത്രം നിന്നു് ഇറക്കുമതി ചെയ്യുക
onboarding-checklist-extension = വിപുലീകരണം ചേൎക്കുക
onboarding-checklist-sign-up = താങ്ങളുടെ അക്കൗണ്ടിലോട്ടു് പ്രവേശിക്കുക അല്ലെങ്കിൽ അംഗത്വമെടുക്കുക

## Tab Groups feature onboarding strings

tab-groups-onboarding-create-group-title-2 = താങ്ങൾക്കു് എപ്പോൾ വേണമെങ്കിലും താങ്ങളുടെ ടാബുക്കൂട്ടങ്ങളെ ഇവിടെ കാണാം.
tab-groups-onboarding-create-group-no-alltabs-button-title = താങ്ങളുടെ ടാബുക്കൂട്ടങ്ങളെ തിരച്ചിൽപ്പട്ട വഴി കണ്ടുപ്പിടിക്കുക.
tab-groups-onboarding-saved-groups-title-2 = ടാബുക്കൂട്ടത്തിനെ താങ്ങൾ അടച്ചാലെങ്കിലും താങ്ങൾക്കു് അതിനെ എപ്പോൾ വേണമെങ്കിലും ഇവിടെ പിന്നെയും തുറക്കാം.
tab-groups-onboarding-saved-groups-no-alltabs-button-title-2 = താങ്ങളുടെ ടാബുക്കൂട്ടങ്ങളെ തിരച്ചിൽപ്പട്ട വഴി കണ്ടുപ്പിടിക്കുക.
tab-groups-onboarding-session-restore-title = താങ്ങൾക്കു് എപ്പോൾ വേണമെങ്കിലും താങ്ങളുടെ ടാബുക്കൂട്ടങ്ങളെ ഇവിടെ വീണ്ടും തുറക്കാം.
tab-groups-onboarding-dismiss = ശരി

## Multi Profiles feature onboarding messages

multi-profile-spotlight-cta = രൂപരേഖയുണ്ടാക്കുക
multi-profile-callout-title = ജോലിയ്ക്കും പണിയ്ക്കും വിനോദത്തിനുമായി വേറെ വേറെ രൂപരേഖകളെ ഉണ്ടാക്കുക
multi-profile-callout-cta = രൂപരേഖയുണ്ടാക്കുക

## Desktop to Mobile Adoption feature callout strings

dismiss-button-label = കളയുക
sync-to-mobile-button-label = മൊബൈലിലേക്കു് സമന്വയിപ്പിക്കുക
