/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jlink;

import java.io.DataInput;
import java.io.IOException;

class ConstantPool {
    static final byte UTF8 = 1;
    static final byte UNUSED = 2;
    static final byte INTEGER = 3;
    static final byte FLOAT = 4;
    static final byte LONG = 5;
    static final byte DOUBLE = 6;
    static final byte CLASS = 7;
    static final byte STRING = 8;
    static final byte FIELDREF = 9;
    static final byte METHODREF = 10;
    static final byte INTERFACEMETHODREF = 11;
    static final byte NAMEANDTYPE = 12;
    byte[] types;
    Object[] values;

    ConstantPool(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.types = new byte[n];
        this.values = new Object[n];
        int n2 = 1;
        while (n2 < n) {
            byte by;
            this.types[n2] = by = dataInput.readByte();
            switch (by) {
                case 1: {
                    this.values[n2] = dataInput.readUTF();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.values[n2] = new Integer(dataInput.readInt());
                    break;
                }
                case 4: {
                    this.values[n2] = new Float(dataInput.readFloat());
                    break;
                }
                case 5: {
                    this.values[n2] = new Long(dataInput.readLong());
                    ++n2;
                    break;
                }
                case 6: {
                    this.values[n2] = new Double(dataInput.readDouble());
                    ++n2;
                    break;
                }
                case 7: 
                case 8: {
                    this.values[n2] = new Integer(dataInput.readUnsignedShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.values[n2] = new Integer(dataInput.readInt());
                }
            }
            ++n2;
        }
    }
}

