/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPathContext;
import org.apache.xpath.patterns.StepPattern;
import org.w3c.dom.Node;

class TemplateSubPatternAssociation
implements Serializable,
Cloneable {
    StepPattern m_stepPattern;
    private String m_pattern;
    private ElemTemplate m_template;
    private TemplateSubPatternAssociation m_next = null;
    private boolean m_wild;
    private String m_targetString;

    TemplateSubPatternAssociation(ElemTemplate elemTemplate, StepPattern stepPattern, String string) {
        this.m_pattern = string;
        this.m_template = elemTemplate;
        this.m_stepPattern = stepPattern;
        this.m_targetString = this.m_stepPattern.getTargetString();
        this.m_wild = this.m_targetString.equals("*");
    }

    public Object clone() throws CloneNotSupportedException {
        TemplateSubPatternAssociation templateSubPatternAssociation = (TemplateSubPatternAssociation)super.clone();
        templateSubPatternAssociation.m_next = null;
        return templateSubPatternAssociation;
    }

    public int getDocOrderPos() {
        return this.m_template.getUid();
    }

    public int getImportLevel() {
        return this.m_template.getStylesheetComposed().getImportCountComposed();
    }

    public TemplateSubPatternAssociation getNext() {
        return this.m_next;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public StepPattern getStepPattern() {
        return this.m_stepPattern;
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public ElemTemplate getTemplate() {
        return this.m_template;
    }

    public boolean isWild() {
        return this.m_wild;
    }

    boolean matchMode(QName qName) {
        return this.matchModes(qName, this.m_template.getMode());
    }

    private boolean matchModes(QName qName, QName qName2) {
        return qName == null && qName2 == null || qName != null && qName2 != null && qName.equals(qName2);
    }

    public boolean matches(XPathContext xPathContext, Node node, QName qName) throws TransformerException {
        double d = this.m_stepPattern.getMatchScore(xPathContext, node);
        return d != Double.NEGATIVE_INFINITY && this.matchModes(qName, this.m_template.getMode());
    }

    public void setNext(TemplateSubPatternAssociation templateSubPatternAssociation) {
        this.m_next = templateSubPatternAssociation;
    }

    public void setTargetString(String string) {
        this.m_targetString = string;
    }
}

