# Copyright 2020 Jack Grigg
#
# Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
# http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
# <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
# option. This file may not be copied, modified, or distributed
# except according to those terms.

### Localization for strings in the rage CLI tools

## Terms (not to be localized)

-age = age
-age-plugin- = age-plugin-
-rage = rage
-rage-keygen = rage-keygen
-stdin = "-"
-recipient-prefix = age1
-identity-prefix = AGE-SECRET-KEY-1
-armor-pem-type = AGE ENCRYPTED FILE

-rage-mount = rage-mount

-ssh-rsa = ssh-rsa
-ssh-ed25519 = ssh-ed25519
-ssh-authorized-keys = authorized_keys
-dot-keys = .keys
-ssh = ssh(1)
-authorized-keys-file-format = AUTHORIZED_KEYS FILE FORMAT
-sshd = sshd(8)
-ssh-agent = ssh-agent(1)

-example = example
-example-r = age1example1
-example-i = AGE-PLUGIN-EXAMPLE-1

-yubikey = yubikey

## CLI flags (not to be localized)

-flag-armor = -a/--armor
-flag-decrypt = -d/--decrypt
-flag-encrypt = -e/--encrypt
-flag-identity = -i/--identity
-flag-output = -o/--output
-flag-recipient = -r/--recipient
-flag-recipients-file = -R/--recipients-file
-flag-passphrase = -p/--passphrase
-flag-plugin-name = -j
-flag-max-work-factor = --max-work-factor
-flag-unstable = --features unstable

-flag-convert = -y

-flag-mnt-types = -t/--types

## Helper variables, to be localized

# Used throughout to indicate that a flag X cannot be used with another flag Y
-cantuse = ne peut pas être utilisé avec

## Usage

usage-header = Utilisation

recipient = RECIPIENT
recipients-file = PATH
identity = IDENTITY
plugin-name = PLUGIN-NAME
input = INPUT
output = OUTPUT

args-header = Arguments

help-arg-input = Chemin vers un fichier à lire.

flags-header = Options

help-flag-help = Affiche ce message d'aide et quitte.
help-flag-version = Affiche les informations de version et quitte.
help-flag-encrypt = Chiffre l'input (l'option par défaut).
help-flag-decrypt = Déchiffre l'input.
help-flag-passphrase = Chiffre avec une phrase secrète au lieu de destinataires.
help-flag-max-work-factor = Facteur d'effort maximum à autoriser pour déchiffrer avec une phrase secrète.
help-flag-armor = Chiffre au format d'encodage PEM.
help-flag-recipient = Chiffre pour le {destinataire} spécifié. Peut être répété.
help-flag-recipients-file = Chiffre pour les destinataires listés dans le fichier {recipients-file}. Peut être répété.
help-flag-identity = Utilise le fichier d'identité {identity}. Peut être répété.
help-flag-plugin-name = Utilise {-age-plugin-}{plugin-name} dans son mode par défaut en tant qu'identité.
help-flag-output = Ecrit le résultat dans le fichier situé au chemin {output}.

rage-after-help-content =
    {input} est par défaut l'entrée standard (stdin), tandis que {output} est par défaut la sortie standard (stdout).
    Si {output} existe, il sera écrasé.

    {recipient} peut être:
    - Une clef publique {-age}, telle que générée par {$keygen_name} ({$example_age_pubkey}).
    - Une clef publique SSH ({$example_ssh_pubkey}).

    {recipients-file} est le chemin vers un fichier contenant des destinataires {-age}, un par ligne
    (en ignorant les lignes vides et les commentaires préfixés par "#"). {-stdin} peut être utilisé
    pour lire des destinataires depuis l'entrée standard.

    {identity} est un chemin vers un fichier avec des identités {-age}, une par ligne
    (en ignorant les lignes vides et les commentaires préfixés par "#"), ou vers un ficher de clef SSH.
    Les fichiers d'identité {-age} protégé par phrase secrète peuvent être utilisé comme fichier d'identité.
    Plusieurs identités peuvent être fournis, et les inutilisées seront ignorées.
    {-stdin} peut être utilisé pour lire des identités depuis l'entrée standard.

rage-after-help-example =
    Exemple:
    {"  "}{$example_a}
    {"  "}{tty-pubkey}: {$example_a_output}
    {"  "}{$example_b}
    {"  "}{$example_c}

keygen-help-flag-output = {help-flag-output} Par défaut, la sortie standard.
keygen-help-flag-convert = Convertit un fichier d'identité en un fichier de destinataires.

## Formatting

warning-msg = Attention: {$warning}

## Keygen messages

tty-pubkey = Clef publique
identity-file-created = créée
identity-file-pubkey = clef publique

## Encryption messages

autogenerated-passphrase = Utilisé une phrase secrète auto-générée:
type-passphrase = Ecrivez la phrase secrète
prompt-passphrase = Phrase secrète

warn-double-encrypting = Chiffrement d'un fichier déjà chiffré

## General errors

err-failed-to-open-input = Echec d'ouverture de l'entrée: {$err}
err-failed-to-open-output = Echec d'ouverture de la sortie: {$err}
err-failed-to-read-input = Echec de lecture de l'entrée: {$err}
err-failed-to-write-output = Echec d'écriture vers la sortie: {$err}
err-identity-ambiguous = {-flag-identity} nécessite {-flag-encrypt} ou {-flag-decrypt}.
err-mixed-encrypt-decrypt = {-flag-encrypt} {-cantuse} {-flag-decrypt}.
err-passphrase-timed-out = Délai dépassé lors de l'attente d'entrée de la phrase secrète.
err-same-input-and-output = L'entrée et la sortie sont le même fichier {$filename}'.

err-ux-A = Est-ce que {-rage} n'a pas fait ce que vous escomptiez ? Est-ce qu'une erreur serait plus utile ?
err-ux-B = Dites-le nous
# Put (len(A) - len(B) - 32) spaces here.
err-ux-C = {"                                                    "}

## Encryption errors

err-enc-broken-stdout = N'a pas pu écrire sur stdout: {$err}
rec-enc-broken-stdout = Etes-vous en train de piper vers programme qui ne lit pas depuis stdin ?

err-enc-broken-file = N'a pas pu écrire dans le fichier: {$err}

rec-enc-missing-recipients = Avez-vous oublié de spécifier {-flag-recipient} ?

err-enc-mixed-identity-passphrase = {-flag-identity} {-cantuse} {-flag-passphrase}.
err-enc-mixed-recipient-passphrase = {-flag-recipient} {-cantuse} {-flag-passphrase}.
err-enc-mixed-recipients-file-passphrase = {-flag-recipients-file} {-cantuse} {-flag-passphrase}.
err-enc-passphrase-without-file = Un fichier à chiffrer doit être passé en argument lors de l'utilisation de {-flag-passphrase}.

err-enc-plugin-name-flag = {-flag-plugin-name} {-cantuse} {-flag-encrypt}.

## Decryption errors

err-detected-powershell-corruption = Il semblerait que ce fichier ait été corrompu par une redirection PowerShell.
rec-detected-powershell-corruption = Essayez d'utiliser {-flag-output} ou {-flag-armor} pour chiffrer des fichiers dans PowerShell.

rec-dec-excessive-work = Pour déchiffrer, réessayez avec {-flag-max-work-factor} {$wf}

err-dec-armor-flag = {-flag-armor} {-cantuse} {-flag-decrypt}.
rec-dec-armor-flag = Note that armored files are detected automatically.

err-dec-missing-identities = Identités manquantes.
rec-dec-missing-identities = Avez-vous oublié de spécifier {-flag-identity} ?
rec-dec-missing-identities-stdin = Avez-vous oublié de fournir une identité via l'entrée standard ?

err-dec-mixed-identity-passphrase = {-flag-identity} {-cantuse} des fichiers chiffrés avec une phrase secrète.

err-mixed-identity-and-plugin-name = {-flag-identity} {-cantuse} {-flag-plugin-name}.

err-dec-passphrase-flag = {-flag-passphrase} {-cantuse} {-flag-decrypt}.
rec-dec-passphrase-flag = Notez que les fichiers chiffrés avec une phrase secrète sont détectés automatiquement.

err-dec-passphrase-without-file-win =
    Ce fichier requière une phrase secrète, et, sur Windows,
    le fichier à déchiffrer doit être passé en tant qu'argument
    positionnel pour déchiffrer avec une phrase secrète.

err-dec-recipient-flag = {-flag-recipient} {-cantuse} {-flag-decrypt}.
err-dec-recipients-file-flag = {-flag-recipients-file} {-cantuse} {-flag-decrypt}.
rec-dec-recipient-flag = Vouliez-vous peut-être utiliser {-flag-identity} pour spécifier une clef privée ?

## rage-mount strings

mnt-filename = FILENAME
mnt-mountpoint = MOUNTPOINT
mnt-types = TYPES

help-arg-mnt-filename = Le système de fichier chiffré à monter.
help-arg-mnt-mountpoint = Le dossier vers lequel monter le système de fichier.
help-arg-mnt-types = Indique le type de système de fichier (parmis {$types}).

info-decrypting = Déchiffrement de {$filename}
info-mounting-as-fuse = Montage en tant que système de fichier FUSE

err-mnt-missing-filename = Il manque un nom de fichier.
err-mnt-missing-mountpoint = Il manque un point de montage.
err-mnt-missing-types = Il manque le fanion {-flag-mnt-types}.
err-mnt-unknown-type = Type de système de fichier inconnu "{$fs_type}"

## Unstable features

test-unstable = Pour tester cela, il faut compiler {-rage} avec {-flag-unstable}.

## rage manpage

recipients = RECIPIENTS
identities = IDENTITIES

man-rage-about = Un outil de chiffrement simple, sécurisé et moderne.

man-rage-description =
    {-rage} encrypts or decrypts {input} to {output}. The {input} argument is
    optional and defaults to standard input. Only a single {input} file may be
    specified. If {-flag-output} is not specified, {output} defaults to standard
    output.

    If {-flag-passphrase} is specified, the file is encrypted with a passphrase
    requested interactively. Otherwise, it's encrypted to one or more
    {recipients} specified with {-flag-recipient} or
    {-flag-recipients-file}. Every recipient can decrypt the file.

    In {-flag-decrypt} mode, passphrase-encrypted files are detected automatically
    and the passphrase is requested interactively. Otherwise, one or more
    {identities} specified with {-flag-identity} are used to decrypt the file.

    {-age} encrypted files are binary and not malleable, with around 200 bytes of
    overhead per recipient, plus 16 bytes every 64KiB of plaintext.

man-rage-flag-output =
    Write encrypted or decrypted file to {output} instead of standard output.
    If {output} already exists it will be overwritten.

    If encrypting without {-flag-armor}, {-rage} will refuse to output binary to a
    TTY. This can be forced by specifying {-stdin} as {output}.

man-rage-encryption-options = Encryption options

man-rage-flag-encrypt =
    Encrypt {input} to {output}. This is the default.

man-rage-flag-recipient =
    Encrypt to the explicitly specified {recipient}. See the
    {man-rage-recipients-and-identities-heading} section for possible recipient
    formats.

    This option can be repeated and combined with other recipient flags,
    and the file can be decrypted by all provided recipients independently.

man-rage-flag-recipients-file =
    Encrypt to the {recipients} listed in the file at {recipients-file}, one per
    line. Empty lines and lines starting with "#" are ignored as comments.

    If {recipients-file} is {-stdin}, the recipients are read from standard
    input. In this case, the {input} argument must be specified.

    This option can be repeated and combined with other recipient flags,
    and the file can be decrypted by all provided recipients independently.

man-rage-flag-passphrase =
    Encrypt with a passphrase, requested interactively from the terminal.
    {-rage} will offer to auto-generate a secure passphrase.

    Cette option ne peut pas être utilisée avec d'autre fanion (flag).

man-rage-flag-armor =
    Encrypt to an ASCII-only "armored" encoding.

    {-age} armor is a strict version of PEM with type "{-armor-pem-type}",
    canonical "strict" Base64, no headers, and no support for leading and
    trailing extra data.

    Decryption transparently detects and decodes ASCII armoring.

man-rage-flag-identity-encrypt =
    Encrypt to the {recipients} corresponding to the {identities} listed in the
    file at {identity}. This is equivalent to converting the file at {identity}
    to a recipients file with '{-rage-keygen} {-flag-convert}' and then passing that to
    {-flag-recipients-file}.

    For the format of {identity}, see the definition of {-flag-identity} in the
    {man-rage-decryption-options} section.

    {-flag-encrypt} must be explicitly specified when using {-flag-identity}
    in encryption mode to avoid confusion.

man-rage-flag-plugin-encrypt =
    Encrypt using the data-less plugin {plugin-name}.

    This is equivalent to using {-flag-identity} with a file that contains a
    single plugin {identity} that encodes no plugin-specific data.

    {-flag-encrypt} must be explicitly specified when using {-flag-plugin-name}
    in encryption mode to avoid confusion.

man-rage-decryption-options = Decryption options

man-rage-flag-decrypt =
    Decrypt {input} to {output}.

    If {input} is passphrase encrypted, it will be automatically detected
    and the passphrase will be requested interactively. Otherwise, the
    {identities} specified with {-flag-identity} are used.

    ASCII armoring is transparently detected and decoded.

man-rage-flag-identity-decrypt =
    Decrypt using the {identities} at {identity}.

    {identity} may be one of the following:

    a. A file listing {identities} one per line. Empty lines and lines starting
    with "#" are ignored as comments.

    b. A passphrase encrypted age file, containing {identities} one per
    line like above. The passphrase is requested interactively. Note that
    passphrase-protected identity files are not necessary for most use cases,
    where access to the encrypted identity file implies access to the whole
    system.

    c. An SSH private key file, in PKCS#1, PKCS#8, or OpenSSH format.
    If the private key is password-protected, the password is requested
    interactively only if the SSH identity matches the file. See the
    {man-rage-ssh-keys-heading} section for more information, including
    supported key types.

    d. {-stdin}, causing one of the options above to be read from standard input.
    In this case, the {input} argument must be specified.

    This option can be repeated. Identities are tried in the order in which are
    provided, and the first one matching one of the file's recipients is used.
    Unused identities are ignored, but it is an error if the {input} file is
    passphrase-encrypted and {-flag-identity} is specified.

man-rage-flag-plugin-decrypt =
    Decrypt using the data-less plugin {plugin-name}.

    This is equivalent to using {-flag-identity} with a file that contains a
    single plugin {identity} that encodes no plugin-specific data.

man-rage-recipients-and-identities-heading = RECIPIENTS AND IDENTITIES
man-rage-recipients-and-identities =
    {recipients} are public values, like a public key, that a file can be encrypted
    to. {identities} are private values, like a private key, that allow decrypting
    a file encrypted to the corresponding {recipient}.

man-rage-native-x25519-keys-heading = Native X25519 keys
man-rage-native-x25519-keys =
    Native {-age} key pairs are generated with {-rage-keygen}(1), and provide small
    encodings and strong encryption based on X25519. They are the recommended
    recipient type for most applications.

    A {recipient} encoding begins with "{-recipient-prefix}" and looks like the
    following:

    {"    "}{$example_age_recipient}

    An {identity} encoding begins with "{-identity-prefix}" and looks like the
    following:

    {"    "}{$example_age_identity}

    An encrypted file can't be linked to the native recipient it's encrypted to
    without access to the corresponding identity.

man-rage-ssh-keys-heading = SSH keys
man-rage-ssh-keys =
    As a convenience feature, {-rage} also supports encrypting to RSA or Ed25519
    {-ssh} keys. RSA keys must be at least 2048 bits. This feature employs more
    complex cryptography, and should only be used when a native key is not available
    for the recipient. Note that SSH keys might not be protected long-term by the
    recipient, since they are revokable when used only for authentication.

    A {recipient} encoding is an SSH public key in "{-ssh-authorized-keys}" format
    (see the "{-authorized-keys-file-format}" section of {-sshd}), starting with
    "{-ssh-rsa}" or "{-ssh-ed25519}", like the following:

    {"    "}{$example_ssh_rsa}
    {"    "}{$example_ssh_ed25519}

    The comment at the end of the line, if present, is ignored.

    In recipient files passed to {-flag-recipients-file}, unsupported but valid
    SSH public keys are ignored with a warning, to facilitate using
    "{-ssh-authorized-keys}" or GitHub "{-dot-keys}" files. (See {man-examples-heading}.)

    An {identity} is an SSH private key _file_ passed individually to
    {-flag-identity}. Note that keys held on hardware tokens such as YubiKeys
    or accessed via {-ssh-agent} are not supported.

    An encrypted file _can_ be linked to the SSH public key it was encrypted to.
    This is so that {-rage} can identify the correct SSH private key before
    requesting its password, if any.

man-rage-plugins-heading = Plugins
man-rage-plugins =
    {-rage} can be extended through plugins. A plugin is only loaded if a corresponding
    {recipient} or {identity} is specified. (Simply decrypting a file encrypted with
    a plugin will not cause it to load, for security reasons among others.)

    A {recipient} for a plugin named "{-example}" starts with "{-example-r}", while an
    {identity} starts with "{-example-i}". They both encode arbitrary plugin-specific
    data, and are generated by the plugin.

    When either is specified, {-rage} searches for {-age-plugin-}{-example} in the PATH
    and executes it to perform the file header encryption or decryption. The plugin
    may request input from the user through {-rage} to complete the operation.

    Plugins can be freely mixed with other plugins or natively supported keys.

    A plugin is not bound to only encrypt or decrypt files meant for or generated by
    the plugin. For example, a plugin can be used to decrypt files encrypted to a
    native X25519 {recipient} or even with a passphrase. Similarly, a plugin can
    encrypt a file such that it can be decrypted without the use of any plugin.

    Plugins for which the {identity}/{recipient} distinction doesn't make sense
    (such as a symmetric encryption plugin) may generate only an {identity} and
    instruct the user to perform encryption with the {-flag-encrypt} and
    {-flag-identity} flags. Plugins for which the concept of separate identities
    doesn't make sense (such as a password-encryption plugin) may instruct the user
    to use the {-flag-plugin-name} flag.

man-examples-heading = EXAMPLES

man-rage-example-single = Generate a new identity, encrypt data, and decrypt
man-rage-example-enc-multiple = Encrypt {$input} to multiple recipients and output to {$output}
man-rage-example-enc-list = Encrypt to a list of recipients
man-rage-example-password = Encrypt and decrypt a file using a passphrase
man-rage-example-identity-passphrase = Encrypt and decrypt with a passphrase-protected identity file
man-rage-example-ssh = Encrypt and decrypt with an SSH public key
man-rage-example-yubikey = Encrypt and decrypt with {-age-plugin-}{-yubikey}
man-rage-example-yubikey-setup = Run interactive setup, generate identity file and obtain recipient.
man-rage-example-enc-github = Encrypt to the SSH keys of a GitHub user

man-see-also-heading = SEE ALSO

## rage-keygen manpage

man-keygen-about = Generate age-compatible encryption key pairs

man-keygen-description =
    {-rage-keygen} generates a new native {-age} key pair, and outputs the identity to
    standard output or to the {output} file. The output includes the public key and
    the current time as comments.

    If the output is not going to a terminal, {-rage-keygen} prints the public key to
    standard error.

man-keygen-flag-output =
    Write the identity to {output} instead of standard output.

    If {output} already exists, it is not overwritten.

man-keygen-flag-convert =
    Read an identity file from {input} or from standard input and output the
    corresponding recipient(s), one per line, with no comments.

man-keygen-example-stdout = Generate a new identity
man-keygen-example-file = Write a new identity to "{$filename}"
man-keygen-example-convert = Convert an identity to a recipient

## rage-mount manpage

man-mount-about = Mount an {-age} encrypted filesystem

man-mount-description =
    {-rage-mount} decrypts the {-age} encrypted filesystem at {mnt-filename} on the
    fly, and mounts it as a directory on the local filesystem at {mnt-mountpoint}.

    Passphrase-encrypted files are detected automatically and the passphrase is
    requested interactively. Otherwise, one or more {identities} specified with
    {-flag-identity} are used to decrypt the file.

    The previous contents (if any) and owner and mode of {mnt-mountpoint} become
    invisible, and as long as this filesystem remains mounted, the pathname
    {mnt-mountpoint} refers to the root of the filesystem on {mnt-filename}.

man-mount-flag-types =
    Set the filesystem type. The following types are currently supported: {$types}.

    This option is required. {-rage-mount} does not attempt to guess the filesystem
    format.

    In theory, any efficiently-seekable filesystem format can be supported. At
    present, {-rage-mount} only supports seekable archive formats.

man-mount-example-identity = Mounting an archive encrypted to a recipient
man-mount-example-passphrase = Mounting an archive encrypted with a passphrase
