; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=instcombine -S < %s | FileCheck %s
; RUN: opt -passes=instcombine,simplifycfg,instcombine -S < %s | FileCheck %s --check-prefix=EXTRA-PASSES

; Check that code corresponding to the following C function is
; simplified into a single ASR operation:
;
; int test_asr(int a, int b) {
;   return a < 0 ? -(-a - 1 >> b) - 1 : a >> b;
; }
;

define i32 @test_asr(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @test_asr(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = icmp slt i32 [[A]], 0
; CHECK-NEXT:    br i1 [[C]], label [[BB2:%.*]], label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[NOT2:%.*]] = ashr i32 [[A]], [[B]]
; CHECK-NEXT:    br label [[BB4:%.*]]
; CHECK:       bb3:
; CHECK-NEXT:    [[E:%.*]] = lshr i32 [[A]], [[B]]
; CHECK-NEXT:    br label [[BB4]]
; CHECK:       bb4:
; CHECK-NEXT:    [[F:%.*]] = phi i32 [ [[NOT2]], [[BB2]] ], [ [[E]], [[BB3]] ]
; CHECK-NEXT:    ret i32 [[F]]
;
; EXTRA-PASSES-LABEL: define i32 @test_asr(
; EXTRA-PASSES-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; EXTRA-PASSES-NEXT:  entry:
; EXTRA-PASSES-NEXT:    [[C1:%.*]] = ashr i32 [[A]], [[B]]
; EXTRA-PASSES-NEXT:    ret i32 [[C1]]
;
entry:
  %c = icmp slt i32 %a, 0
  br i1 %c, label %bb2, label %bb3

bb2:
  %t1 = sub i32 0, %a
  %not = sub i32 %t1, 1
  %d = ashr i32 %not, %b
  %t2 = sub i32 0, %d
  %not2 = sub i32 %t2, 1
  br label %bb4
bb3:
  %e = ashr i32 %a, %b
  br label %bb4
bb4:
  %f = phi i32 [ %not2, %bb2 ], [ %e, %bb3 ]
  ret i32 %f
}
