; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -global-isel-abort=2 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i8 @ucmp.8.8(i8 %x, i8 %y) nounwind {
; CHECK-SD-LABEL: ucmp.8.8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    and w8, w0, #0xff
; CHECK-SD-NEXT:    cmp w8, w1, uxtb
; CHECK-SD-NEXT:    cset w8, hi
; CHECK-SD-NEXT:    csinv w0, w8, wzr, hs
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucmp.8.8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0xff
; CHECK-GI-NEXT:    and w9, w1, #0xff
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    cset w8, hi
; CHECK-GI-NEXT:    csinv w0, w8, wzr, hs
; CHECK-GI-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @ucmp.8.16(i16 %x, i16 %y) nounwind {
; CHECK-SD-LABEL: ucmp.8.16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    and w8, w0, #0xffff
; CHECK-SD-NEXT:    cmp w8, w1, uxth
; CHECK-SD-NEXT:    cset w8, hi
; CHECK-SD-NEXT:    csinv w0, w8, wzr, hs
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucmp.8.16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0xffff
; CHECK-GI-NEXT:    and w9, w1, #0xffff
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    cset w8, hi
; CHECK-GI-NEXT:    csinv w0, w8, wzr, hs
; CHECK-GI-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @ucmp.8.32(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: ucmp.8.32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    csinv w0, w8, wzr, hs
; CHECK-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @ucmp.8.64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: ucmp.8.64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x1
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    csinv w0, w8, wzr, hs
; CHECK-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @ucmp.8.128(i128 %x, i128 %y) nounwind {
; CHECK-SD-LABEL: ucmp.8.128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp x2, x0
; CHECK-SD-NEXT:    sbcs xzr, x3, x1
; CHECK-SD-NEXT:    cset w8, lo
; CHECK-SD-NEXT:    cmp x0, x2
; CHECK-SD-NEXT:    sbcs xzr, x1, x3
; CHECK-SD-NEXT:    csinv w0, w8, wzr, hs
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucmp.8.128:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    cset w8, hi
; CHECK-GI-NEXT:    cmp x0, x2
; CHECK-GI-NEXT:    cset w9, hi
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    csel w8, w9, w8, eq
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    cset w8, ne
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    cset w9, lo
; CHECK-GI-NEXT:    cmp x0, x2
; CHECK-GI-NEXT:    cset w10, lo
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    csel w9, w10, w9, eq
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csinv w0, w8, wzr, eq
; CHECK-GI-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @ucmp.32.32(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: ucmp.32.32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    csinv w0, w8, wzr, hs
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @ucmp.32.64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: ucmp.32.64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x1
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    csinv w0, w8, wzr, hs
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @ucmp.64.64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: ucmp.64.64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x1
; CHECK-NEXT:    cset x8, hi
; CHECK-NEXT:    csinv x0, x8, xzr, hs
; CHECK-NEXT:    ret
  %1 = call i64 @llvm.ucmp(i64 %x, i64 %y)
  ret i64 %1
}

define <1 x i64> @ucmp.1.64.65(<1 x i65> %x, <1 x i65> %y) {
; CHECK-SD-LABEL: ucmp.1.64.65:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    and x8, x1, #0x1
; CHECK-SD-NEXT:    and x9, x3, #0x1
; CHECK-SD-NEXT:    cmp x2, x0
; CHECK-SD-NEXT:    sbcs xzr, x9, x8
; CHECK-SD-NEXT:    cset x10, lo
; CHECK-SD-NEXT:    cmp x0, x2
; CHECK-SD-NEXT:    sbcs xzr, x8, x9
; CHECK-SD-NEXT:    csinv x8, x10, xzr, hs
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucmp.1.64.65:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and x8, x1, #0x1
; CHECK-GI-NEXT:    and x9, x3, #0x1
; CHECK-GI-NEXT:    cmp x8, x9
; CHECK-GI-NEXT:    cset w10, hi
; CHECK-GI-NEXT:    cmp x0, x2
; CHECK-GI-NEXT:    cset w11, hi
; CHECK-GI-NEXT:    cmp x8, x9
; CHECK-GI-NEXT:    csel w10, w11, w10, eq
; CHECK-GI-NEXT:    tst w10, #0x1
; CHECK-GI-NEXT:    cset x10, ne
; CHECK-GI-NEXT:    cmp x8, x9
; CHECK-GI-NEXT:    cset w11, lo
; CHECK-GI-NEXT:    cmp x0, x2
; CHECK-GI-NEXT:    cset w12, lo
; CHECK-GI-NEXT:    cmp x8, x9
; CHECK-GI-NEXT:    csel w8, w12, w11, eq
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csinv x8, x10, xzr, eq
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
  %1 = call <1 x i64> @llvm.ucmp(<1 x i65> %x, <1 x i65> %y)
  ret <1 x i64> %1
}
