/*
 * Copyright (C) 2024 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This file is derived from https://github.com/Ji-Peng/PQRV which uses the
 * following license.
 *
 * The MIT license, the text of which is below, applies to PQRV in general.
 *
 * Copyright (c) 2024 - 2025 Jipeng Zhang (jp-zhang@outlook.com)
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "dilithium_zetas_riscv64.h"
#include "ext_headers.h"

// RV64IM assembly optimized implementation with Plantard arithmetic
LC_FIPS_RODATA_SECTION
const int64_t zetas_ntt_8l_rv64im[LC_DILITHIUM_N] = {
	-7863079302046539641, 8288750859434465317,  8279739258909364132,
	-7047040794213066873, -6347578587163640001, -6924180145725268195,
	-7046899919168219175, -1324408118892148702, 7797620831989026436,
	5904178785850661821,  4688259859699270849,  8287121991728413809,
	-2212704518869611853, 1227061261729813591,  -2688021322530896626,
	-7418719789490536519, 7929103473456019385,  7006063765542992697,
	6764223135818434274,  2812273112086566323,  -5801130891717146429,
	8478949779359463672,  3858655525281480,	    -4260193426548934306,
	-5854073494508971959, -3204665141301799075, 5856017129893355044,
	-3918586851001296707, -130194955510181959,  6102971083511369758,
	-8943480837399596562, 6032408094250703242,  -7894386579591364792,
	9208323720540693185,  -7093954385319926075, -6870828124834354042,
	-603253356108752072,  2602320869466829805,  191959857985594580,
	1401986245151715432,  -8728322821638222451, -8709478583217267089,
	-5054766099423739082, -7230664811654314069, -8181639600726124135,
	5862554612443318532,  -6847447269734787653, 4625566062396893718,
	5522697969093398433,  4464237721975370486,  4264925947586786663,
	-8399069226585667377, -61219011676627792,   1810554691626100264,
	2221786556917136888,  -5401996670902405877, -4357214510170059115,
	3514880794746733203,  -8709916616559840400, -8275231257474237793,
	-3686116612931685951, 8154954785590364077,  2553085041292559330,
	6188136651639530476,  -6567816909229834223, -2442236191550602657,
	9152669273135549467,  -3709312569534889736, -7507248749314436028,
	5895352083821923239,  -8296104977010030306, -7816377023506951986,
	1399848906580666762,  -551274866905102976,  -5404708515515724065,
	-7757905075204854307, 867587768384851535,   2044336828550855208,
	3363536973128790572,  1062393742510884766,  2528834723025573554,
	-6520454278917522983, -9126642608599937249, -3901772093695178495,
	4827034985909707918,  -3801618741498768150, 5255328139835346225,
	-7950085050448023416, -590917984994275510,  -7000732525564537623,
	-955584044445420687,  2411314119206532931,  -7718147496141743018,
	-1244989812359258915, 373512572033065466,   5420264202108515975,
	-7339552416631281695, 8248343934461509170,  5054110149996166987,
	2729258089564908745,  -8449154707374175531, 7034234372167380820,
	5817655094243266263,  2760688632773975632,  -27331959873029171,
	1489291353023500564,  4560453176433772522,  -8846488369021956442,
	-9171020448899537886, -7678532993296055172, 4375521662482532628,
	-7037694615456452404, 6599597438878444609,  312203312280832118,
	-196566912186629456,  5531586303954257883,  -2982351113496677052,
	1349842668004885439,  -2884110580268589357, -4883228720595909230,
	-2940625686150849480, 7136139857734084410,  4745838131935615944,
	3821924558510018379,  518171432538469675,   -7154149851748832310,
	7172426187645245389,  -1009765907397390811, -4230640483546978145,
	8893168635835786644,  -7642623063895346636, 4488507850795537969,
	-4137935899346889835, -1802234259289783097, -4796278001508819088,
	-7105112129106378911, 7517156227077865544,  3872626367619735212,
	-5677380969508746657, 3935571098595747305,  -5263199532966211355,
	-4963043238192433167, -3573282305526407034, 4634097807300482432,
	-5226468566194749829, -4476760192758785397, 1290417611977490052,
	-2596531785592619712, 1162177297714569904,  -6038721057197940712,
	3773459140737258753,  -1799537822884495126, -7868016532133936310,
	7664936350295676563,  -9207317784673577591, -2861559567230078939,
	-5199308297782628790, -3251098876787145806, 4389239369974577227,
	5483836267268615473,  -3066583384452721770, 1118034982880574012,
	-2614739885139184688, -1595418687590483606, -4038108320691689792,
	5401640080945135141,  8269343120834119163,  -4261027670955141768,
	-2900436677262892116, 5417937562695953211,  6682715916511162215,
	1367289161840242546,  -6677789692286644273, -744920823083718442,
	5828691773538053109,  6624974757504211969,  -5751340368053788143,
	9131496194129455597,  1649948335809421485,  -8854766979079334449,
	3215292402497497298,  -3779386898483740798, -8694748336340379660,
	8587813171438098100,  -2700092552936283755, 6440225940876758933,
	7427306563708518865,  8761985353839095054,  5654836559987963476,
	-3556060331293775945, 3793124416528967105,  3665652311494982061,
	4464061628169310864,  2561280006792059016,  -7416351327799034595,
	-1414535130006039286, -6377488120122866897, 7026922076870754992,
	2985776138024536711,  -6109915782987846123, 5906340337320043688,
	-6116591939410081565, 8792960254324982667,  -26147729027278209,
	-3016744434992697088, 6648406239573020499,  7403736407767438382,
	472987963076146265,   1200466694669659090,  -1695873600429771055,
	-7891419398959260151, 1225736155839214931,  8519235639840753829,
	-7632929099871764413, 5090955577741567268,  -1437971014419999307,
	-1010697003396931065, 6835869101986367468,  -2428650554413102775,
	1118514838502086484,  -1218828876296526235, 1893325383991850115,
	7550981646049343297,  308701246712821374,   -3332909857909870714,
	6197707349998870963,  6421564399779590430,  4080546927952058835,
	767795408490863416,   -721650026612939318,  2225876335562871622,
	-5182033495408179815, -4809746976499804471, 6875939247555234587,
	5191185970978128699,  -4827362960623493965, -6635258635778093928,
	-3779003894455561119, 6440749819949786311,  -864415878703202584,
	5026890449924500826,  7365041995058412064,  4090694333526244586,
	-8405457029400480186, -4231210587244096174, -4923419930656442340,
	3839960966595675222,  -666966296313699269,  7772844433476437538,
	-8748527384710988398, -8306633185439819991, 4182342354889975161,
	-1721041807660842613, 2321088055326733809,  -1610012461767674828,
};

LC_FIPS_RODATA_SECTION
const int64_t zetas_intt_8l_rv64im[LC_DILITHIUM_N] = {
	1610012461767674828,  -2321088055326733809, 1721041807660842613,
	-4182342354889975161, 8306633185439819991,  8748527384710988398,
	-7772844433476437538, 666966296313699269,   -3839960966595675222,
	4923419930656442340,  4231210587244096174,  8405457029400480186,
	-4090694333526244586, -7365041995058412064, -5026890449924500826,
	864415878703202584,   -6440749819949786311, 3779003894455561119,
	6635258635778093928,  4827362960623493965,  -5191185970978128699,
	-6875939247555234587, 4809746976499804471,  5182033495408179815,
	-2225876335562871622, 721650026612939318,   -767795408490863416,
	-4080546927952058835, -6421564399779590430, -6197707349998870963,
	3332909857909870714,  -308701246712821374,  -7550981646049343297,
	-1893325383991850115, 1218828876296526235,  -1118514838502086484,
	2428650554413102775,  -6835869101986367468, 1010697003396931065,
	1437971014419999307,  -5090955577741567268, 7632929099871764413,
	-8519235639840753829, -1225736155839214931, 7891419398959260151,
	1695873600429771055,  -1200466694669659090, -472987963076146265,
	-7403736407767438382, -6648406239573020499, 3016744434992697088,
	26147729027278209,    -8792960254324982667, 6116591939410081565,
	-5906340337320043688, 6109915782987846123,  -2985776138024536711,
	-7026922076870754992, 6377488120122866897,  1414535130006039286,
	7416351327799034595,  -2561280006792059016, -4464061628169310864,
	-3665652311494982061, -3793124416528967105, 3556060331293775945,
	-5654836559987963476, -8761985353839095054, -7427306563708518865,
	-6440225940876758933, 2700092552936283755,  -8587813171438098100,
	8694748336340379660,  3779386898483740798,  -3215292402497497298,
	8854766979079334449,  -1649948335809421485, -9131496194129455597,
	5751340368053788143,  -6624974757504211969, -5828691773538053109,
	744920823083718442,   6677789692286644273,  -1367289161840242546,
	-6682715916511162215, -5417937562695953211, 2900436677262892116,
	4261027670955141768,  -8269343120834119163, -5401640080945135141,
	4038108320691689792,  1595418687590483606,  2614739885139184688,
	-1118034982880574012, 3066583384452721770,  -5483836267268615473,
	-4389239369974577227, 3251098876787145806,  5199308297782628790,
	2861559567230078939,  9207317784673577591,  -7664936350295676563,
	7868016532133936310,  1799537822884495126,  -3773459140737258753,
	6038721057197940712,  -1162177297714569904, 2596531785592619712,
	-1290417611977490052, 4476760192758785397,  5226468566194749829,
	-4634097807300482432, 3573282305526407034,  4963043238192433167,
	5263199532966211355,  -3935571098595747305, 5677380969508746657,
	-3872626367619735212, -7517156227077865544, 7105112129106378911,
	4796278001508819088,  1802234259289783097,  4137935899346889835,
	-4488507850795537969, 7642623063895346636,  -8893168635835786644,
	4230640483546978145,  1009765907397390811,  -7172426187645245389,
	7154149851748832310,  -518171432538469675,  -3821924558510018379,
	-4745838131935615944, -7136139857734084410, 2940625686150849480,
	4883228720595909230,  2884110580268589357,  -1349842668004885439,
	2982351113496677052,  -5531586303954257883, 196566912186629456,
	-312203312280832118,  -6599597438878444609, 7037694615456452404,
	-4375521662482532628, 7678532993296055172,  9171020448899537886,
	8846488369021956442,  -4560453176433772522, -1489291353023500564,
	27331959873029171,    -2760688632773975632, -5817655094243266263,
	-7034234372167380820, 8449154707374175531,  -2729258089564908745,
	-5054110149996166987, -8248343934461509170, 7339552416631281695,
	-5420264202108515975, -373512572033065466,  1244989812359258915,
	7718147496141743018,  -2411314119206532931, 955584044445420687,
	7000732525564537623,  590917984994275510,   7950085050448023416,
	-5255328139835346225, 3801618741498768150,  -4827034985909707918,
	3901772093695178495,  9126642608599937249,  6520454278917522983,
	-2528834723025573554, -1062393742510884766, -3363536973128790572,
	-2044336828550855208, -867587768384851535,  7757905075204854307,
	5404708515515724065,  551274866905102976,   -1399848906580666762,
	7816377023506951986,  8296104977010030306,  -5895352083821923239,
	7507248749314436028,  3709312569534889736,  -9152669273135549467,
	2442236191550602657,  6567816909229834223,  -6188136651639530476,
	-2553085041292559330, -8154954785590364077, 3686116612931685951,
	8275231257474237793,  8709916616559840400,  -3514880794746733203,
	4357214510170059115,  5401996670902405877,  -2221786556917136888,
	-1810554691626100264, 61219011676627792,    8399069226585667377,
	-4264925947586786663, -4464237721975370486, -5522697969093398433,
	-4625566062396893718, 6847447269734787653,  -5862554612443318532,
	8181639600726124135,  7230664811654314069,  5054766099423739082,
	8709478583217267089,  8728322821638222451,  -1401986245151715432,
	-191959857985594580,  -2602320869466829805, 603253356108752072,
	6870828124834354042,  7093954385319926075,  -9208323720540693185,
	7894386579591364792,  -6032408094250703242, 8943480837399596562,
	-6102971083511369758, 130194955510181959,   3918586851001296707,
	-5856017129893355044, 3204665141301799075,  5854073494508971959,
	4260193426548934306,  -3858655525281480,    -8478949779359463672,
	5801130891717146429,  -2812273112086566323, -6764223135818434274,
	-7006063765542992697, -7929103473456019385, 7418719789490536519,
	2688021322530896626,  -1227061261729813591, 2212704518869611853,
	-8287121991728413809, -4688259859699270849, -5904178785850661821,
	-7797620831989026436, 1324408118892148702,  7046899919168219175,
	6924180145725268195,  6347578587163640001,  7047040794213066873,
	-8279739258909364132, -8288750859434465317, -8751230424634003604,
	-92400822384635461,
};
