/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Intervall;
import java.util.Vector;

public final class IntCharSet {
    private static final boolean DEBUG = false;
    private Vector intervalls;
    private int pos;

    public IntCharSet() {
        this.intervalls = new Vector();
    }

    public IntCharSet(char c) {
        this(new Intervall(c, c));
    }

    public IntCharSet(Intervall intervall) {
        this();
        this.intervalls.addElement(intervall);
    }

    public IntCharSet(Vector vector) {
        int n = vector.size();
        this.intervalls = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            this.add((Intervall)vector.elementAt(n2));
            ++n2;
        }
    }

    private int indexOf(char c) {
        int n = 0;
        int n2 = this.intervalls.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Intervall intervall = (Intervall)this.intervalls.elementAt(n3);
            if (n == n2) {
                return intervall.contains(c) ? n : -1;
            }
            if (c < intervall.start) {
                n2 = n3 - 1;
                continue;
            }
            if (c > intervall.end) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    public IntCharSet add(IntCharSet intCharSet) {
        int n = 0;
        while (n < intCharSet.intervalls.size()) {
            this.add((Intervall)intCharSet.intervalls.elementAt(n));
            ++n;
        }
        return this;
    }

    public void add(Intervall intervall) {
        int n = this.intervalls.size();
        int n2 = 0;
        while (n2 < n) {
            Intervall intervall2 = (Intervall)this.intervalls.elementAt(n2);
            if (intervall2.end + '\u0001' >= intervall.start) {
                if (intervall2.contains(intervall)) {
                    return;
                }
                if (intervall2.start > intervall.end + '\u0001') {
                    this.intervalls.insertElementAt(new Intervall(intervall), n2);
                    return;
                }
                if (intervall.start < intervall2.start) {
                    intervall2.start = intervall.start;
                }
                if (intervall.end <= intervall2.end) {
                    return;
                }
                intervall2.end = intervall.end;
                ++n2;
                while (n2 < n) {
                    Intervall intervall3 = (Intervall)this.intervalls.elementAt(n2);
                    if (intervall3.start > intervall2.end + '\u0001') {
                        return;
                    }
                    intervall2.end = intervall3.end;
                    this.intervalls.removeElementAt(n2);
                    --n;
                }
                return;
            }
            ++n2;
        }
        this.intervalls.addElement(new Intervall(intervall));
    }

    public void add(char c) {
        this.add(new Intervall(c, c));
    }

    public boolean contains(char c) {
        return this.indexOf(c) >= 0;
    }

    public boolean contains(Intervall intervall) {
        int n = this.indexOf(intervall.start);
        if (n < 0) {
            return false;
        }
        return ((Intervall)this.intervalls.elementAt(n)).contains(intervall);
    }

    public boolean contains(IntCharSet intCharSet) {
        int n = 0;
        int n2 = 0;
        while (n2 < intCharSet.intervalls.size()) {
            Intervall intervall;
            Intervall intervall2 = (Intervall)this.intervalls.elementAt(n);
            if (intervall2.contains(intervall = (Intervall)this.intervalls.elementAt(n2))) {
                ++n2;
            }
            if (intervall2.start > intervall.end) {
                return false;
            }
            if (intervall2.end >= intervall.start) continue;
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        IntCharSet intCharSet = (IntCharSet)object;
        if (this.intervalls.size() != intCharSet.intervalls.size()) {
            return false;
        }
        int n = 0;
        while (n < this.intervalls.size()) {
            if (!this.intervalls.elementAt(n).equals(intCharSet.intervalls.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private char min(char c, char c2) {
        return c <= c2 ? c : c2;
    }

    private char max(char c, char c2) {
        return c >= c2 ? c : c2;
    }

    public IntCharSet and(IntCharSet intCharSet) {
        IntCharSet intCharSet2 = new IntCharSet();
        int n = 0;
        int n2 = 0;
        int n3 = this.intervalls.size();
        int n4 = intCharSet.intervalls.size();
        while (n < n3 && n2 < n4) {
            Intervall intervall = (Intervall)this.intervalls.elementAt(n);
            Intervall intervall2 = (Intervall)intCharSet.intervalls.elementAt(n2);
            if (intervall.end < intervall2.start) {
                ++n;
                continue;
            }
            if (intervall2.end < intervall.start) {
                ++n2;
                continue;
            }
            intCharSet2.intervalls.addElement(new Intervall(this.max(intervall.start, intervall2.start), this.min(intervall.end, intervall2.end)));
            if (intervall.end >= intervall2.end) {
                ++n2;
            }
            if (intervall2.end < intervall.end) continue;
            ++n;
        }
        return intCharSet2;
    }

    public void sub(IntCharSet intCharSet) {
        int n = 0;
        int n2 = 0;
        int n3 = intCharSet.intervalls.size();
        while (n < this.intervalls.size() && n2 < n3) {
            Intervall intervall = (Intervall)this.intervalls.elementAt(n);
            Intervall intervall2 = (Intervall)intCharSet.intervalls.elementAt(n2);
            if (intervall.end < intervall2.start) {
                ++n;
                continue;
            }
            if (intervall2.end < intervall.start) {
                ++n2;
                continue;
            }
            if (intervall.start == intervall2.start && intervall.end == intervall2.end) {
                this.intervalls.removeElementAt(n);
                ++n2;
                continue;
            }
            if (intervall.start == intervall2.start) {
                intervall.start = (char)(intervall2.end + '\u0001');
                ++n2;
                continue;
            }
            if (intervall.end == intervall2.end) {
                intervall.end = (char)(intervall2.start - '\u0001');
                ++n;
                ++n2;
                continue;
            }
            this.intervalls.insertElementAt(new Intervall(intervall.start, (char)(intervall2.start - '\u0001')), n);
            intervall.start = (char)(intervall2.end + '\u0001');
            ++n;
            ++n2;
        }
    }

    public boolean containsElements() {
        return this.intervalls.size() > 0;
    }

    public int numIntervalls() {
        return this.intervalls.size();
    }

    public Intervall getNext() {
        if (this.pos == this.intervalls.size()) {
            this.pos = 0;
        }
        return (Intervall)this.intervalls.elementAt(this.pos++);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{ ");
        int n = 0;
        while (n < this.intervalls.size()) {
            stringBuffer.append(this.intervalls.elementAt(n));
            ++n;
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }
}

