/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package javax.activation;

/**
 * @version $Rev: 467553 $ $Date: 2006-10-25 06:01:51 +0200 (Wed, 25 Oct 2006) $
 */
public abstract class CommandMap {
    private static CommandMap defaultCommandMap = new MailcapCommandMap();

    /**
     * Return the default CommandMap. If this has not been explictly set
     * using setDefaultCommandMap() then a MailcapCommandMap is returned.
     * @return the default CommandMap
     */
    public static CommandMap getDefaultCommandMap() {
        return defaultCommandMap;
    }

    /**
     * Set the default CommandMap.
     *
     * @param commandMap the new default CommandMap; if null resets to a MailcapCommandMap 
     * @throws SecurityException if the caller does not have "SetFactory" RuntimePermission
     */
    public static void setDefaultCommandMap(CommandMap commandMap) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        defaultCommandMap = commandMap == null ? new MailcapCommandMap() : commandMap;
    }

    public CommandMap() {
    }

    public abstract CommandInfo[] getPreferredCommands(String mimeType);

    public abstract CommandInfo[] getAllCommands(String mimeType);

    public abstract CommandInfo getCommand(String mimeType, String cmdName);

    public abstract DataContentHandler createDataContentHandler(String mimeType);
}