// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `ConnectionErrorCodeType`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let connectionerrorcodetype = unimplemented!();
/// match connectionerrorcodetype {
///     ConnectionErrorCodeType::ClusterNotFound => { /* ... */ },
///     ConnectionErrorCodeType::InsufficientCloudhsmHsms => { /* ... */ },
///     ConnectionErrorCodeType::InsufficientFreeAddressesInSubnet => { /* ... */ },
///     ConnectionErrorCodeType::InternalError => { /* ... */ },
///     ConnectionErrorCodeType::InvalidCredentials => { /* ... */ },
///     ConnectionErrorCodeType::NetworkErrors => { /* ... */ },
///     ConnectionErrorCodeType::SubnetNotFound => { /* ... */ },
///     ConnectionErrorCodeType::UserLockedOut => { /* ... */ },
///     ConnectionErrorCodeType::UserLoggedIn => { /* ... */ },
///     ConnectionErrorCodeType::UserNotFound => { /* ... */ },
///     ConnectionErrorCodeType::XksProxyAccessDenied => { /* ... */ },
///     ConnectionErrorCodeType::XksProxyInvalidConfiguration => { /* ... */ },
///     ConnectionErrorCodeType::XksProxyInvalidResponse => { /* ... */ },
///     ConnectionErrorCodeType::XksProxyInvalidTlsConfiguration => { /* ... */ },
///     ConnectionErrorCodeType::XksProxyNotReachable => { /* ... */ },
///     ConnectionErrorCodeType::XksProxyTimedOut => { /* ... */ },
///     ConnectionErrorCodeType::XksVpcEndpointServiceInvalidConfiguration => { /* ... */ },
///     ConnectionErrorCodeType::XksVpcEndpointServiceNotFound => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `connectionerrorcodetype` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `ConnectionErrorCodeType::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `ConnectionErrorCodeType::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `ConnectionErrorCodeType::NewFeature` is defined.
/// Specifically, when `connectionerrorcodetype` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `ConnectionErrorCodeType::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum ConnectionErrorCodeType {
    #[allow(missing_docs)] // documentation missing in model
    ClusterNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientCloudhsmHsms,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientFreeAddressesInSubnet,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidCredentials,
    #[allow(missing_docs)] // documentation missing in model
    NetworkErrors,
    #[allow(missing_docs)] // documentation missing in model
    SubnetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    UserLockedOut,
    #[allow(missing_docs)] // documentation missing in model
    UserLoggedIn,
    #[allow(missing_docs)] // documentation missing in model
    UserNotFound,
    #[allow(missing_docs)] // documentation missing in model
    XksProxyAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    XksProxyInvalidConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    XksProxyInvalidResponse,
    #[allow(missing_docs)] // documentation missing in model
    XksProxyInvalidTlsConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    XksProxyNotReachable,
    #[allow(missing_docs)] // documentation missing in model
    XksProxyTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    XksVpcEndpointServiceInvalidConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    XksVpcEndpointServiceNotFound,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for ConnectionErrorCodeType {
    fn from(s: &str) -> Self {
        match s {
            "CLUSTER_NOT_FOUND" => ConnectionErrorCodeType::ClusterNotFound,
            "INSUFFICIENT_CLOUDHSM_HSMS" => ConnectionErrorCodeType::InsufficientCloudhsmHsms,
            "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET" => ConnectionErrorCodeType::InsufficientFreeAddressesInSubnet,
            "INTERNAL_ERROR" => ConnectionErrorCodeType::InternalError,
            "INVALID_CREDENTIALS" => ConnectionErrorCodeType::InvalidCredentials,
            "NETWORK_ERRORS" => ConnectionErrorCodeType::NetworkErrors,
            "SUBNET_NOT_FOUND" => ConnectionErrorCodeType::SubnetNotFound,
            "USER_LOCKED_OUT" => ConnectionErrorCodeType::UserLockedOut,
            "USER_LOGGED_IN" => ConnectionErrorCodeType::UserLoggedIn,
            "USER_NOT_FOUND" => ConnectionErrorCodeType::UserNotFound,
            "XKS_PROXY_ACCESS_DENIED" => ConnectionErrorCodeType::XksProxyAccessDenied,
            "XKS_PROXY_INVALID_CONFIGURATION" => ConnectionErrorCodeType::XksProxyInvalidConfiguration,
            "XKS_PROXY_INVALID_RESPONSE" => ConnectionErrorCodeType::XksProxyInvalidResponse,
            "XKS_PROXY_INVALID_TLS_CONFIGURATION" => ConnectionErrorCodeType::XksProxyInvalidTlsConfiguration,
            "XKS_PROXY_NOT_REACHABLE" => ConnectionErrorCodeType::XksProxyNotReachable,
            "XKS_PROXY_TIMED_OUT" => ConnectionErrorCodeType::XksProxyTimedOut,
            "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION" => ConnectionErrorCodeType::XksVpcEndpointServiceInvalidConfiguration,
            "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND" => ConnectionErrorCodeType::XksVpcEndpointServiceNotFound,
            other => ConnectionErrorCodeType::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for ConnectionErrorCodeType {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(ConnectionErrorCodeType::from(s))
    }
}
impl ConnectionErrorCodeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionErrorCodeType::ClusterNotFound => "CLUSTER_NOT_FOUND",
            ConnectionErrorCodeType::InsufficientCloudhsmHsms => "INSUFFICIENT_CLOUDHSM_HSMS",
            ConnectionErrorCodeType::InsufficientFreeAddressesInSubnet => "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET",
            ConnectionErrorCodeType::InternalError => "INTERNAL_ERROR",
            ConnectionErrorCodeType::InvalidCredentials => "INVALID_CREDENTIALS",
            ConnectionErrorCodeType::NetworkErrors => "NETWORK_ERRORS",
            ConnectionErrorCodeType::SubnetNotFound => "SUBNET_NOT_FOUND",
            ConnectionErrorCodeType::UserLockedOut => "USER_LOCKED_OUT",
            ConnectionErrorCodeType::UserLoggedIn => "USER_LOGGED_IN",
            ConnectionErrorCodeType::UserNotFound => "USER_NOT_FOUND",
            ConnectionErrorCodeType::XksProxyAccessDenied => "XKS_PROXY_ACCESS_DENIED",
            ConnectionErrorCodeType::XksProxyInvalidConfiguration => "XKS_PROXY_INVALID_CONFIGURATION",
            ConnectionErrorCodeType::XksProxyInvalidResponse => "XKS_PROXY_INVALID_RESPONSE",
            ConnectionErrorCodeType::XksProxyInvalidTlsConfiguration => "XKS_PROXY_INVALID_TLS_CONFIGURATION",
            ConnectionErrorCodeType::XksProxyNotReachable => "XKS_PROXY_NOT_REACHABLE",
            ConnectionErrorCodeType::XksProxyTimedOut => "XKS_PROXY_TIMED_OUT",
            ConnectionErrorCodeType::XksVpcEndpointServiceInvalidConfiguration => "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION",
            ConnectionErrorCodeType::XksVpcEndpointServiceNotFound => "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND",
            ConnectionErrorCodeType::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "CLUSTER_NOT_FOUND",
            "INSUFFICIENT_CLOUDHSM_HSMS",
            "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET",
            "INTERNAL_ERROR",
            "INVALID_CREDENTIALS",
            "NETWORK_ERRORS",
            "SUBNET_NOT_FOUND",
            "USER_LOCKED_OUT",
            "USER_LOGGED_IN",
            "USER_NOT_FOUND",
            "XKS_PROXY_ACCESS_DENIED",
            "XKS_PROXY_INVALID_CONFIGURATION",
            "XKS_PROXY_INVALID_RESPONSE",
            "XKS_PROXY_INVALID_TLS_CONFIGURATION",
            "XKS_PROXY_NOT_REACHABLE",
            "XKS_PROXY_TIMED_OUT",
            "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION",
            "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND",
        ]
    }
}
impl ::std::convert::AsRef<str> for ConnectionErrorCodeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl ConnectionErrorCodeType {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for ConnectionErrorCodeType {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            ConnectionErrorCodeType::ClusterNotFound => write!(f, "CLUSTER_NOT_FOUND"),
            ConnectionErrorCodeType::InsufficientCloudhsmHsms => write!(f, "INSUFFICIENT_CLOUDHSM_HSMS"),
            ConnectionErrorCodeType::InsufficientFreeAddressesInSubnet => write!(f, "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET"),
            ConnectionErrorCodeType::InternalError => write!(f, "INTERNAL_ERROR"),
            ConnectionErrorCodeType::InvalidCredentials => write!(f, "INVALID_CREDENTIALS"),
            ConnectionErrorCodeType::NetworkErrors => write!(f, "NETWORK_ERRORS"),
            ConnectionErrorCodeType::SubnetNotFound => write!(f, "SUBNET_NOT_FOUND"),
            ConnectionErrorCodeType::UserLockedOut => write!(f, "USER_LOCKED_OUT"),
            ConnectionErrorCodeType::UserLoggedIn => write!(f, "USER_LOGGED_IN"),
            ConnectionErrorCodeType::UserNotFound => write!(f, "USER_NOT_FOUND"),
            ConnectionErrorCodeType::XksProxyAccessDenied => write!(f, "XKS_PROXY_ACCESS_DENIED"),
            ConnectionErrorCodeType::XksProxyInvalidConfiguration => write!(f, "XKS_PROXY_INVALID_CONFIGURATION"),
            ConnectionErrorCodeType::XksProxyInvalidResponse => write!(f, "XKS_PROXY_INVALID_RESPONSE"),
            ConnectionErrorCodeType::XksProxyInvalidTlsConfiguration => write!(f, "XKS_PROXY_INVALID_TLS_CONFIGURATION"),
            ConnectionErrorCodeType::XksProxyNotReachable => write!(f, "XKS_PROXY_NOT_REACHABLE"),
            ConnectionErrorCodeType::XksProxyTimedOut => write!(f, "XKS_PROXY_TIMED_OUT"),
            ConnectionErrorCodeType::XksVpcEndpointServiceInvalidConfiguration => write!(f, "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION"),
            ConnectionErrorCodeType::XksVpcEndpointServiceNotFound => write!(f, "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND"),
            ConnectionErrorCodeType::Unknown(value) => write!(f, "{}", value),
        }
    }
}
