// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ScheduleKeyDeletion`](crate::operation::schedule_key_deletion::builders::ScheduleKeyDeletionFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::schedule_key_deletion::builders::ScheduleKeyDeletionFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::schedule_key_deletion::builders::ScheduleKeyDeletionFluentBuilder::set_key_id):<br>required: **true**<br><p>The unique identifier of the KMS key to delete.</p> <p>Specify the key ID or key ARN of the KMS key.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p><br>
    ///   - [`pending_window_in_days(i32)`](crate::operation::schedule_key_deletion::builders::ScheduleKeyDeletionFluentBuilder::pending_window_in_days) / [`set_pending_window_in_days(Option<i32>)`](crate::operation::schedule_key_deletion::builders::ScheduleKeyDeletionFluentBuilder::set_pending_window_in_days):<br>required: **false**<br><p>The waiting period, specified in number of days. After the waiting period ends, KMS deletes the KMS key.</p> <p>If the KMS key is a multi-Region primary key with replica keys, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.</p> <p>This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a value, it defaults to 30. You can use the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/conditions-kms.html#conditions-kms-schedule-key-deletion-pending-window-in-days"> <code>kms:ScheduleKeyDeletionPendingWindowInDays</code> </a> condition key to further constrain the values that principals can specify in the <code>PendingWindowInDays</code> parameter.</p><br>
    /// - On success, responds with [`ScheduleKeyDeletionOutput`](crate::operation::schedule_key_deletion::ScheduleKeyDeletionOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::operation::schedule_key_deletion::ScheduleKeyDeletionOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is scheduled.</p>
    ///   - [`deletion_date(Option<DateTime>)`](crate::operation::schedule_key_deletion::ScheduleKeyDeletionOutput::deletion_date): <p>The date and time after which KMS deletes the KMS key.</p> <p>If the KMS key is a multi-Region primary key with replica keys, this field does not appear. The deletion date for the primary key isn't known until its last replica key is deleted.</p>
    ///   - [`key_state(Option<KeyState>)`](crate::operation::schedule_key_deletion::ScheduleKeyDeletionOutput::key_state): <p>The current status of the KMS key.</p> <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`pending_window_in_days(Option<i32>)`](crate::operation::schedule_key_deletion::ScheduleKeyDeletionOutput::pending_window_in_days): <p>The waiting period before the KMS key is deleted.</p> <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.</p>
    /// - On failure, responds with [`SdkError<ScheduleKeyDeletionError>`](crate::operation::schedule_key_deletion::ScheduleKeyDeletionError)
    pub fn schedule_key_deletion(&self) -> crate::operation::schedule_key_deletion::builders::ScheduleKeyDeletionFluentBuilder {
        crate::operation::schedule_key_deletion::builders::ScheduleKeyDeletionFluentBuilder::new(self.handle.clone())
    }
}
