# InfluxDB Receiver

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [beta]: metrics   |
| Distributions | [contrib] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Areceiver%2Finfluxdb%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Areceiver%2Finfluxdb) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Areceiver%2Finfluxdb%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Areceiver%2Finfluxdb) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=receiver_influxdb)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=receiver_influxdb&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@jacobmarble](https://www.github.com/jacobmarble) |

[beta]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#beta
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
<!-- end autogenerated section -->

This receiver accepts metrics data as [InfluxDB Line Protocol](https://docs.influxdata.com/influxdb/v2.0/reference/syntax/line-protocol/).

Write endpoints exist at `/write` (InfluxDB 1.x compatibility) and `/api/v2/write` (InfluxDB 2.x compatibility).
Write query parameters `db`/`rp` (InfluxDB 1.x) and `org`/`bucket` (InfluxDB 2.x) are ignored.
Write query parameter `precision` is optional, defaults to `ns`.

Write responses:
- 204: success, no further response needed (no content)
- 400: permanent failure; check response body for details
- 500: retryable error; check response body for details

## Configuration

The following configuration options are supported:

* `endpoint` (default = localhost:8086) HTTP service endpoint for the line protocol receiver. See our [security best practices doc](https://opentelemetry.io/docs/security/config-best-practices/#protect-against-denial-of-service-attacks) to understand how to set the endpoint in different environments.

The full list of settings exposed for this receiver are documented in [config.go](config.go).

Example:
```yaml
receivers:
  influxdb:
    endpoint: 0.0.0.0:8080
```

## Definitions

[InfluxDB](https://www.influxdata.com/products/influxdb/) is an open-source time series database.

[Telegraf](https://www.influxdata.com/time-series-platform/telegraf/) is an open-source metrics agent, similar to the OpenTelemetry Collector.
Telegraf has [hundreds of plugins](https://www.influxdata.com/products/integrations/?_integrations_dropdown=telegraf-plugins).

[Line protocol](https://docs.influxdata.com/influxdb/v2.0/reference/syntax/line-protocol/) is a textual HTTP payload format used to move metrics between Telegraf agents and InfluxDB instances.

## Schema

The InfluxDB->OpenTelemetry conversion [schema](https://github.com/influxdata/influxdb-observability/blob/main/docs/index.md) and [implementation](https://github.com/influxdata/influxdb-observability/tree/main/influx2otel) are hosted at https://github.com/influxdata/influxdb-observability .
This receiver automatically detects schema at parse time.

### Example: Metrics - `prometheus-v1`
```
cpu_temp,foo=bar gauge=87.332
http_requests_total,method=post,code=200 counter=1027
http_requests_total,method=post,code=400 counter=3
http_request_duration_seconds 0.05=24054,0.1=33444,0.2=100392,0.5=129389,1=133988,sum=53423,count=144320
rpc_duration_seconds 0.01=3102,0.05=3272,0.5=4773,0.9=9001,0.99=76656,sum=1.7560473e+07,count=2693
```

### Example: Metrics - `prometheus-v2`
```
prometheus,foo=bar cpu_temp=87.332
prometheus,method=post,code=200 http_requests_total=1027
prometheus,method=post,code=400 http_requests_total=3
prometheus,le=0.05 http_request_duration_seconds_bucket=24054
prometheus,le=0.1  http_request_duration_seconds_bucket=33444
prometheus,le=0.2  http_request_duration_seconds_bucket=100392
prometheus,le=0.5  http_request_duration_seconds_bucket=129389
prometheus,le=1    http_request_duration_seconds_bucket=133988
prometheus         http_request_duration_seconds_count=144320,http_request_duration_seconds_sum=53423
prometheus,quantile=0.01 rpc_duration_seconds=3102
prometheus,quantile=0.05 rpc_duration_seconds=3272
prometheus,quantile=0.5  rpc_duration_seconds=4773
prometheus,quantile=0.9  rpc_duration_seconds=9001
prometheus,quantile=0.99 rpc_duration_seconds=76656
prometheus               rpc_duration_seconds_count=1.7560473e+07,rpc_duration_seconds_sum=2693
```

