# Resource Detection Processor

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [development]: profiles   |
|               | [beta]: traces, metrics, logs   |
| Distributions | [contrib], [k8s] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Aprocessor%2Fresourcedetection%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Aprocessor%2Fresourcedetection) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Aprocessor%2Fresourcedetection%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Aprocessor%2Fresourcedetection) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=processor_resourcedetection)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=processor_resourcedetection&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@Aneurysm9](https://www.github.com/Aneurysm9), [@dashpole](https://www.github.com/dashpole) |

[development]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#development
[beta]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#beta
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
[k8s]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-k8s
<!-- end autogenerated section -->

The resource detection processor can be used to detect resource information from the host,
in a format that conforms to the [OpenTelemetry resource semantic conventions](https://github.com/open-telemetry/semantic-conventions/tree/main/docs/resource), and append or
override the resource value in telemetry data with this information.

> **Note**
>
> If a configured resource detector fails in some way, the error it returns to the processor will be logged, and the collector will continue to run. This behavior is configurable using a feature gate, however the error behavior of each independent resource detector may vary.
>
> This feature can be controlled with [feature gate](https://github.com/open-telemetry/opentelemetry-collector/tree/main/featuregate) `processor.resourcedetection.propagateerrors`. It is currently disabled by default (alpha stage).
>
>  Example of how to enable it:
> ```shell-session
> $ otelcol --config=config.yaml --feature-gates=processor.resourcedetection.propagateerrors
> ```

## Supported detectors

### Environment Variable

Reads resource information from the `OTEL_RESOURCE_ATTRIBUTES` environment
variable. This is expected to be in the format `<key1>=<value1>,<key2>=<value2>,...`, the
details of which are currently pending confirmation in the OpenTelemetry specification.

Example:

```yaml
processors:
  resourcedetection/env:
    detectors: [env]
    timeout: 2s
    override: false
```

### System metadata

Note: use the Docker detector (see below) if running the Collector as a Docker container.

Queries the host machine to retrieve the system related resource attributes. The list of the
populated resource attributes can be found at [System Detector Resource Attributes](./internal/system/documentation.md).

By default `host.name` is being set to FQDN if possible, and a hostname provided by OS used as fallback.
This logic can be changed with `hostname_sources` configuration which is set to `["dns", "os"]` by default.

Use the following config to avoid getting FQDN and apply hostname provided by OS only:

```yaml
processors:
  resourcedetection/system:
    detectors: ["system"]
    system:
      hostname_sources: ["os"]
```

* all valid options for `hostname_sources`:
    * "dns"
    * "os"
    * "cname"
    * "lookup"

#### Hostname Sources

##### dns

The "dns" hostname source uses multiple sources to get the fully qualified domain name. First, it looks up the
host name in the local machine's `hosts` file. If that fails, it looks up the CNAME. Lastly, if that fails,
it does a reverse DNS query. Note: this hostname source may produce unreliable results on Windows. To produce
a FQDN, Windows hosts might have better results using the "lookup" hostname source, which is mentioned below.

##### os

The "os" hostname source provides the hostname provided by the local machine's kernel.

##### cname

The "cname" hostname source provides the canonical name, as provided by net.LookupCNAME in the Go standard library.
Note: this hostname source may produce unreliable results on Windows.

##### lookup

The "lookup" hostname source does a reverse DNS lookup of the current host's IP address.

### Docker metadata

Queries the Docker daemon to retrieve resource attributes from the host machine.
The list of the populated resource attributes can
be found at [Docker Detector Resource Attributes](./internal/docker/documentation.md).

You need to mount the Docker socket (`/var/run/docker.sock` on Linux) to contact the Docker daemon.
Docker detection does not work on macOS.

Example:

```yaml
processors:
  resourcedetection/docker:
    detectors: [env, docker]
    timeout: 2s
    override: false
```

### Heroku metadata

When [Heroku dyno metadata is active](https://devcenter.heroku.com/articles/dyno-metadata), Heroku applications publish information through environment variables.

We map these environment variables to resource attributes as follows:

| Dyno metadata environment variable | Resource attribute                  |
|------------------------------------|-------------------------------------|
| `HEROKU_APP_ID`                    | `heroku.app.id`                     |
| `HEROKU_APP_NAME`                  | `service.name`                      |
| `HEROKU_DYNO_ID`                   | `service.instance.id`               |
| `HEROKU_RELEASE_CREATED_AT`        | `heroku.release.creation_timestamp` |
| `HEROKU_RELEASE_VERSION`           | `service.version`                   |
| `HEROKU_SLUG_COMMIT`               | `heroku.release.commit`             |

For more information, see the [Heroku cloud provider documentation](https://github.com/open-telemetry/semantic-conventions/blob/main/docs/resource/cloud-provider/heroku.md) under the [OpenTelemetry specification semantic conventions](https://github.com/open-telemetry/semantic-conventions).

The list of the populated resource attributes can be found at [Heroku Detector Resource Attributes](./internal/heroku/documentation.md).

```yaml
processors:
  resourcedetection/heroku:
    detectors: [env, heroku]
    timeout: 2s
    override: false
```

### GCP Metadata

Uses the [Google Cloud Client Libraries for Go](https://github.com/googleapis/google-cloud-go)
to read resource information from the [metadata server](https://cloud.google.com/compute/docs/storing-retrieving-metadata) and environment variables to detect which GCP platform the
application is running on, and detect the appropriate attributes for that platform. Regardless
of the GCP platform the application is running on, use the gcp detector:

Example:

```yaml
processors:
  resourcedetection/gcp:
    detectors: [env, gcp]
    timeout: 2s
    override: false
```

The list of the populated resource attributes can be found at [GCP Detector Resource Attributes](./internal/gcp/documentation.md).

#### GCE Metadata

    * cloud.provider ("gcp")
    * cloud.platform ("gcp_compute_engine")
    * cloud.account.id (project id)
    * cloud.region  (e.g. us-central1)
    * cloud.availability_zone (e.g. us-central1-c)
    * host.id (instance id)
    * host.name (instance name)
    * host.type (machine type)
    * (optional) gcp.gce.instance.hostname
    * (optional) gcp.gce.instance.name

#### GKE Metadata

    * cloud.provider ("gcp")
    * cloud.platform ("gcp_kubernetes_engine")
    * cloud.account.id (project id)
    * cloud.region (only for regional GKE clusters; e.g. "us-central1")
    * cloud.availability_zone (only for zonal GKE clusters; e.g. "us-central1-c")
    * k8s.cluster.name
    * host.id (instance id)
    * host.name (instance name; only when workload identity is disabled)

One known issue is when GKE workload identity is enabled, the GCE metadata endpoints won't be available, thus the GKE resource detector won't be
able to determine `host.name`. In that case, users are encouraged to set `host.name` from either:
- `node.name` through the downward API with the `env` detector
- obtaining the Kubernetes node name from the Kubernetes API (with `k8s.io/client-go`)

#### Google Cloud Run Services Metadata

    * cloud.provider ("gcp")
    * cloud.platform ("gcp_cloud_run")
    * cloud.account.id (project id)
    * cloud.region (e.g. "us-central1")
    * faas.id (instance id)
    * faas.name (service name)
    * faas.version (service revision)

#### Cloud Run Jobs Metadata

    * cloud.provider ("gcp")
    * cloud.platform ("gcp_cloud_run")
    * cloud.account.id (project id)
    * cloud.region (e.g. "us-central1")
    * faas.id (instance id)
    * faas.name (service name)
    * gcp.cloud_run.job.execution ("my-service-ajg89")
    * gcp.cloud_run.job.task_index ("0")

#### Google Cloud Functions Metadata

    * cloud.provider ("gcp")
    * cloud.platform ("gcp_cloud_functions")
    * cloud.account.id (project id)
    * cloud.region (e.g. "us-central1")
    * faas.id (instance id)
    * faas.name (function name)
    * faas.version (function version)

#### Google App Engine Metadata

    * cloud.provider ("gcp")
    * cloud.platform ("gcp_app_engine")
    * cloud.account.id (project id)
    * cloud.region (e.g. "us-central1")
    * cloud.availability_zone (e.g. "us-central1-c")
    * faas.id (instance id)
    * faas.name (service name)
    * faas.version (service version)

### AWS EC2

Uses [AWS SDK for Go](https://docs.aws.amazon.com/sdk-for-go/api/aws/ec2metadata/) to read resource information
from the [EC2 instance metadata API](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) to retrieve related resource attributes:

The list of the populated resource attributes can be found at [EC2 Detector Resource Attributes](./internal/aws/ec2/documentation.md).

It also can optionally gather tags for the EC2 instance that the collector is running on.
Note that in order to fetch EC2 tags, the IAM role assigned to the EC2 instance must have a policy that includes the `ec2:DescribeTags` permission.

EC2 custom configuration example:
```yaml
processors:
  resourcedetection/ec2:
    detectors: ["ec2"]
    ec2:
      # A list of regex's to match tag keys to add as resource attributes can be specified
      tags:
        - ^tag1$
        - ^tag2$
        - ^label.*$
```

If you are using a proxy server on your EC2 instance, it's important that you exempt requests for instance metadata as [described in the AWS cli user guide](https://github.com/awsdocs/aws-cli-user-guide/blob/a2393582590b64bd2a1d9978af15b350e1f9eb8e/doc_source/cli-configure-proxy.md#using-a-proxy-on-amazon-ec2-instances). Failing to do so can result in proxied or missing instance data.

If the instance is part of AWS ParallelCluster and the detector is failing to connect to the metadata server, check the iptable and make sure the chain `PARALLELCLUSTER_IMDS` contains a rule that allows OTEL user to access `169.254.169.254/32`

In some cases, you might need to change the behavior of the AWS metadata client from the [standard retryer](https://docs.aws.amazon.com/sdk-for-go/v2/developer-guide/configure-retries-timeouts.html)

By default, the client retries 3 times with a max backoff delay of 20s.

We offer a limited set of options to override those defaults specifically, such that you can set the client to retry 10 times, for up to 5 minutes, for example:

```yaml
processors:
  resourcedetection/ec2:
    detectors: ["ec2"]
    ec2:
      max_attempts: 10
      max_backoff: 5m
```

The EC2 detector will report an error in logs if the EC2 metadata endpoint is unavailable. You can configure the detector to instead fail with this flag:

```yaml
processors:
  resourcedetection/ec2:
    detectors: ["ec2"]
    ec2:
      fail_on_missing_metadata: true
```

### Amazon ECS

Queries the [Task Metadata Endpoint](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-metadata-endpoint.html) (TMDE) to record information about the current ECS Task. Only TMDE V4 and V3 are supported.

The list of the populated resource attributes can be found at [ECS Detector Resource Attributes](./internal/aws/ecs/documentation.md).

Example:

```yaml
processors:
  resourcedetection/ecs:
    detectors: [env, ecs]
    timeout: 2s
    override: false
```

### Amazon Elastic Beanstalk

Reads the AWS X-Ray configuration file available on all Beanstalk instances with [X-Ray Enabled](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-configuration-debugging.html).

The list of the populated resource attributes can be found at [Elastic Beanstalk Detector Resource Attributes](./internal/aws/elasticbeanstalk/documentation.md).

Example:

```yaml
processors:
  resourcedetection/elastic_beanstalk:
    detectors: [env, elastic_beanstalk]
    timeout: 2s
    override: false
```

### Amazon EKS

This detector reads resource information from the [EC2 instance metadata service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) to retrieve related resource attributes.
If IMDS is not available, (example: EKS-AutoMode and POD not on the hostnetwork), it falls back to a combination of [Kubernetes API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.25/#-strong-kubernetes-api-v1-25-strong-) 
and [EC2 API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html) to retrieve related resource attributes.

EC2 API requires the `EC2:DescribeInstances` permission to be granted to the IAM role. If IMDS is not accessible, ex: EKS-AutoMode, you can use [POD Identity](https://docs.aws.amazon.com/eks/latest/userguide/pod-identities.html).

The list of the populated resource attributes can be found at [EKS Detector Resource Attributes](./internal/aws/eks/documentation.md).

Example:

```yaml
processors:
  resourcedetection/eks:
    detectors: [env, eks]
    timeout: 15s
    override: false
```

#### Cluster Name

Cluster name detection is disabled by default, and can be enabled with the
following configuration:

```yaml
processors:
  resourcedetection/eks:
    detectors: [env, eks]
    timeout: 15s
    override: false
    eks:
      resource_attributes:
        k8s.cluster.name:
          enabled: true
```

Note: The kubernetes cluster name is only available when running on EC2 instances, and requires permission to run the `EC2:DescribeInstances` [action](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html).
If you see an error with the message `context deadline exceeded`, please increase the timeout setting in your config.

#### Node Name Env Variable
When using the EC2 API and the Kubernetes API to retrieve resource attributes, the node name is needed. The node name is extracted from the env variable you define on the pod.
The node name env variable that contains the node name value can be set using the `node_from_env_var` option:

```yaml
processors:
  resourcedetection/eks:
    detectors: [eks]
    timeout: 15s
    override: false
    eks:
      node_from_env_var: K8S_NODE_NAME
```
In this example, the env variable `K8S_NODE_NAME` will hold the actual node name and can be set in the pod spec using the downward API.

```yaml
        env:
          - name: K8S_NODE_NAME
            valueFrom:
              fieldRef:
                fieldPath: spec.nodeName
```

### AWS Lambda

Uses the AWS Lambda [runtime environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime)
to retrieve related resource attributes.

The list of the populated resource attributes can be found at [Lambda Detector Resource Attributes](./internal/aws/lambda/documentation.md).

Example:

```yaml
processors:
  resourcedetection/lambda:
    detectors: [env, lambda]
    timeout: 0.2s
    override: false
```

### Azure

Queries the [Azure Instance Metadata Service](https://aka.ms/azureimds) to retrieve related attributes.

The list of the populated resource attributes can be found at [Azure Detector Resource Attributes](./internal/azure/documentation.md).

Example:

```yaml
processors:
  resourcedetection/azure:
    detectors: [env, azure]
    timeout: 2s
    override: false
```

It also can optionally gather tags from the Azure instance that the Collector is running on.

Azure custom configuration example:

```yaml
processors:
  resourcedetection/azure:
    detectors: ["azure"]
    azure:
      # A list of regex's to match tag keys to add as resource attributes can be specified
      tags:
        - ^tag1$
        - ^tag2$
        - ^label.*$
```

Matched tags are added as:

    * azure.tags.<tag name>

### Azure AKS

The list of the populated resource attributes can be found at [AKS Detector Resource Attributes](./internal/azure/aks/documentation.md).

```yaml
processors:
  resourcedetection/aks:
    detectors: [env, aks]
    timeout: 2s
    override: false
```

#### Cluster Name

Cluster name detection is disabled by default, and can be enabled with the
following configuration:

```yaml
processors:
  resourcedetection/aks:
    detectors: [aks]
    timeout: 2s
    override: false
    aks:
      resource_attributes:
        k8s.cluster.name:
          enabled: true
```

Azure AKS cluster name is derived from the Azure Instance Metadata Service's (IMDS) infrastructure resource group field. This field contains the resource group and name of the cluster, separated by underscores. e.g: `MC_<resource group>_<cluster name>_<location>`.

Example:
  - Resource group: my-resource-group
  - Cluster name:   my-cluster
  - Location:       eastus
  - Generated name: MC_my-resource-group_my-cluster_eastus

The cluster name is detected if it does not contain underscores and if a custom infrastructure resource group name was not used.

If accurate parsing cannot be performed, the infrastructure resource group value is returned. This value can be used to uniquely identify the cluster, as Azure will not allow users to create multiple clusters with the same infrastructure resource group name.

### Consul

Queries a [consul agent](https://www.consul.io/docs/agent) and reads its [configuration endpoint](https://www.consul.io/api-docs/agent#read-configuration) to retrieve related resource attributes:

The list of the populated resource attributes can be found at [Consul Detector Resource Attributes](./internal/consul/documentation.md).

In addition to:

  * *exploded consul metadata* - reads all key:value pairs in [consul metadata](https://www.consul.io/docs/agent/options#_node_meta) into label:labelvalue pairs.

```yaml
processors:
  resourcedetection/consul:
    detectors: [env, consul]
    timeout: 2s
    override: false
```

### Kubeadm Metadata

Queries the K8S API server to retrieve kubeadm resource attributes:

The list of the populated resource attributes can be found at [kubeadm Detector Resource Attributes](./internal/kubeadm/documentation.md).

The following permissions are required:
```yaml
apiVersion: rbac.authorization.k8s.io/v1
kind: Role
metadata:
  name: otel-collector
  namespace: kube-system
rules:
  - apiGroups: [""]
    resources: ["configmaps"]
    resourceNames: ["kubeadm-config"]
    verbs: ["get"]
  - apiGroups: [""]
    resources: ["namespaces"]
    resourceNames: ["kube-system"]
    verbs: ["get"]
---
apiVersion: rbac.authorization.k8s.io/v1
kind: RoleBinding
metadata:
  name: otel-collector-rolebinding
  namespace: kube-system
subjects:
- kind: ServiceAccount
  name: default
  namespace: default
roleRef:
  kind: Role
  name: otel-collector
  apiGroup: rbac.authorization.k8s.io
```

| Name | Type | Required | Default         | Docs                                                                                                                                                                                                                                   |
| ---- | ---- |----------|-----------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| auth_type | string | No       | `serviceAccount` | How to authenticate to the K8s API server.  This can be one of `none` (for no auth), `serviceAccount` (to use the standard service account token provided to the agent pod), or `kubeConfig` to use credentials from `~/.kube/config`. |

### K8S Node Metadata

Queries the K8S api server to retrieve node resource attributes.

The list of the populated resource attributes can be found at [k8snode Detector Resource Attributes](./internal/k8snode/documentation.md).

The following permissions are required:
```yaml
kind: ClusterRole
metadata:
  name: otel-collector
rules:
  - apiGroups: [""]
    resources: ["nodes"]
    verbs: ["get", "list"]
```

| Name | Type | Required | Default         | Docs                                                                                                                                                                                                                                   |
| ---- | ---- |----------|-----------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| auth_type | string | No       | `serviceAccount` | How to authenticate to the K8s API server.  This can be one of `none` (for no auth), `serviceAccount` (to use the standard service account token provided to the agent pod), or `kubeConfig` to use credentials from `~/.kube/config`. |
| node_from_env_var | string | Yes      | `K8S_NODE_NAME` | The environment variable name that holds the name of the node to retrieve metadata from. Default value is `K8S_NODE_NAME`. You can set the env dynamically on the workload definition using the downward API; see example              |

#### Example using the default `node_from_env_var` option:

```yaml
processors:
  resourcedetection/k8snode:
    detectors: [k8snode]
```
and add this to your workload:
```yaml
        env:
          - name: K8S_NODE_NAME
            valueFrom:
              fieldRef:
                fieldPath: spec.nodeName
```

#### Example using a custom variable `node_from_env_var` option:
```yaml
processors:
  resourcedetection/k8snode:
    detectors: [k8snode]
    k8snode:
      node_from_env_var: "my_custom_var"
```
and add this to your workload:
```yaml
        env:
          - name: my_custom_var
            valueFrom:
              fieldRef:
                fieldPath: spec.nodeName
```

### OpenShift

Queries the OpenShift and Kubernetes API to retrieve related resource attributes.

The list of the populated resource attributes can be found at [OpenShift Detector Resource Attributes](./internal/openshift/documentation.md).

The following permissions are required:
```yaml
kind: ClusterRole
metadata:
  name: otel-collector
rules:
- apiGroups: ["config.openshift.io"]
  resources: ["infrastructures", "infrastructures/status"]
  verbs: ["get", "watch", "list"]
```

By default, the API address is determined from the environment variables `KUBERNETES_SERVICE_HOST`, `KUBERNETES_SERVICE_PORT` and the service token is read from `/var/run/secrets/kubernetes.io/serviceaccount/token`.
If TLS is not explicit disabled and no `ca_file` is configured `/var/run/secrets/kubernetes.io/serviceaccount/ca.crt` is used.
The determination of the API address, ca_file and the service token is skipped if they are set in the configuration.

Example:

```yaml
processors:
  resourcedetection/openshift:
    detectors: [openshift]
    timeout: 2s
    override: false
    openshift: # optional
      address: "https://api.example.com"
      token: "token"
      tls:
        insecure: false
        ca_file: "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt"
```

See: [TLS Configuration Settings](https://github.com/open-telemetry/opentelemetry-collector/blob/main/config/configtls/README.md) for the full set of available options.

### Dynatrace

Loads resource information from the `dt_host_metadata.properties` file which is located in
the `/var/lib/dynatrace/enrichment` (on *nix systems) or `%ProgramData%\dynatrace\enrichment` (on Windows) directories.
If present in the file, the following attributes will be added:

- `dt.entity.host`
- `host.name`

The Dynatrace detector does not require any additional configuration, other than being added to the list of detectors.

Example:

```yaml
processors:
  resourcedetection/dynatrace:
    override: false
    detectors: [dynatrace]
```

It is strongly recommended to use the `override: false` configuration option, to prevent the detector from overwriting
existing resource attributes.
If the Dynatrace host entity identifier attribute `dt.entity.host` or `host.name` are already present on incoming data as it is sent from
other sources to the collector, then these describe the monitored entity in the best way.
Overriding these with the collector's own identifier would instead make the telemetry appear as if it was coming from the collector
or the collector's host instead, which might be inaccurate.

## Configuration

```yaml
# a list of resource detectors to run, valid options are: "env", "system", "gcp", "ec2", "ecs", "elastic_beanstalk", "eks", "lambda", "azure", "heroku", "openshift", "dynatrace"
detectors: [ <string> ]
# determines if existing resource attributes should be overridden or preserved, defaults to true
override: <bool>
# [DEPRECATED] When included, only attributes in the list will be appended.  Applies to all detectors.
attributes: [ <string> ]
```

Moreover, you have the ability to specify which detector should collect each attribute with `resource_attributes` option. An example of such a configuration is:

```yaml
resourcedetection:
  detectors: [system, ec2]
  system:
    resource_attributes:
      host.name:
        enabled: true
      host.id:
        enabled: false
  ec2:
    resource_attributes:
      host.name:
        enabled: false
      host.id:
        enabled: true
```

### Migration from attributes to resource_attributes

The `attributes` option is deprecated and will be removed soon, from now on you should enable/disable attributes through `resource_attributes`.
For example, this config:

```yaml
resourcedetection:
  detectors: [system]
  attributes: ['host.name', 'host.id']
```

can be replaced with:

```yaml
resourcedetection:
  detectors: [system]
  system:
    resource_attributes:
      host.name:
        enabled: true
      host.id:
        enabled: true
      os.type:
        enabled: false
```

## Ordering

Note that if multiple detectors are inserting the same attribute name, the first detector to insert wins. For example if you had `detectors: [eks, ec2]` then `cloud.platform` will be `aws_eks` instead of `ec2`. The below ordering is recommended.

### AWS

* lambda
* elastic_beanstalk
* eks
* ecs
* ec2

The full list of settings exposed for this extension are documented in [config.go](./config.go)
with detailed sample configurations in [testdata/config.yaml](./testdata/config.yaml).
