# Headers Setter extension
<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [alpha]  |
| Distributions | [contrib], [k8s] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Aextension%2Fheaderssetter%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Aextension%2Fheaderssetter) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Aextension%2Fheaderssetter%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Aextension%2Fheaderssetter) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=extension_headers_setter)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=extension_headers_setter&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@VihasMakwana](https://www.github.com/VihasMakwana) \| Seeking more code owners! |

[alpha]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#alpha
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
[k8s]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-k8s
<!-- end autogenerated section -->

The `headers_setter` extension implements `ClientAuthenticator` and is used to
set requests headers in `gRPC` / `HTTP` exporters with values provided via
extension configurations or requests metadata (context).

Use cases include but are not limited to enabling multi-tenancy for observability
backends such as [Tempo], [Mimir], [Loki] and others by setting the `X-Scope-OrgID`
header to the value extracted from the context.

## Configuration

The following settings are required:

- `headers`: a list of header configuration objects that specify headers and
  their value sources. Each configuration object has the following properties:
    - `key`: The header name.
    - `action` (default: `upsert`): An action to perform on the header. Supported actions are:
        - `insert`: Inserts the new header if it does not exist.
        - `update`: Updates the header value if it exists.
        - `upsert`: Inserts a header if it does not exist and updates the header
          if it exists.
        - `delete`: Deletes the header.
    - `value`: The header value is looked up from the `value` property of the
      extension configuration.
    - `default_value`: (Optional) Value used if no entry for header key specified in `from_context` is present in request metadata.
    - `from_context`: The header value is looked up from the request metadata,
      such as HTTP headers, using the property value as the key (likely a header
      name).
    - `from_attribute`: The header value is taken from the request's authentication data,
      may include attributes like `subject` and `membership`.

The `value`,`from_context,default_value` and `from_attribute,default_value` properties are mutually exclusive.

In order for `from_context` to work, other components in the pipeline also need to be configured appropriately:
* If a [batch processor][batch-processor] is present in the pipeline, it must be configured to [preserve client metadata][batch-processor-preserve-metadata]. 
  Add the value which `from_context` needs to the `metadata_keys` of the batch processor.
* Receivers must be configured with `include_metadata: true` so that metadata keys are available to the pipeline.

#### Configuration Example

```yaml
extensions:
  headers_setter:
    headers:
      - action: insert
        key: X-Scope-OrgID
        from_context: tenant_id
        default_value: Org-ID
      - action: upsert
        key: User-ID
        value: user_id
      - action: update
        key: User-ID
        value: user_id
      - action: delete
        key: Some-Header

receivers:
  otlp:
    protocols:
      http:
        include_metadata: true

processors:
  batch:
    # Preserve the tenant-id metadata.
    metadata_keys:
    - tenant_id

exporters:
  loki:
    labels:
      resource:
        container_id: ""
        container_name: ""
    endpoint: https://localhost:<port>/loki/api/v1/push
    auth:
      authenticator: headers_setter

service:
  extensions: [ headers_setter ]
  pipelines:
    traces:
      receivers: [ otlp ]
      processors: [ batch ]
      exporters: [ loki ]
```

[batch-processor]: https://github.com/open-telemetry/opentelemetry-collector/tree/main/processor/batchprocessor/README.md
[batch-processor-preserve-metadata]: https://github.com/open-telemetry/opentelemetry-collector/tree/main/processor/batchprocessor/README.md#batching-and-client-metadata

[alpha]: https://github.com/open-telemetry/opentelemetry-collector#alpha
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
[Mimir]: https://grafana.com/oss/mimir/
[Tempo]: https://grafana.com/oss/tempo/
[Loki]: https://grafana.com/oss/loki/