// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/process/agent.proto

package process

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// ContainerHostType is a enum that represents the type of host detected for container collection.
// Sometimes containers are running on host-less environment, we'll need additional information to identify them
// This will help with the host resolution when we resolve container payloads
type ContainerHostType int32

const (
	ContainerHostType_notSpecified ContainerHostType = 0
	ContainerHostType_fargateECS   ContainerHostType = 1
	ContainerHostType_fargateEKS   ContainerHostType = 2
)

var ContainerHostType_name = map[int32]string{
	0: "notSpecified",
	1: "fargateECS",
	2: "fargateEKS",
}

var ContainerHostType_value = map[string]int32{
	"notSpecified": 0,
	"fargateECS":   1,
	"fargateEKS":   2,
}

func (x ContainerHostType) String() string {
	return proto.EnumName(ContainerHostType_name, int32(x))
}

func (ContainerHostType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{0}
}

// From https://github.com/DataDog/datadog-agent/blob/853fdeea6979e371eacda2a7022ba6291f211eec/pkg/languagedetection/languagemodels/language.go#L11-L38
type Language int32

const (
	Language_LANGUAGE_UNKNOWN Language = 0
	Language_LANGUAGE_JAVA    Language = 1
	Language_LANGUAGE_NODE    Language = 2
	Language_LANGUAGE_PYTHON  Language = 3
	Language_LANGUAGE_RUBY    Language = 4
	Language_LANGUAGE_DOTNET  Language = 5
	Language_LANGUAGE_GO      Language = 6
	Language_LANGUAGE_CPP     Language = 7
	Language_LANGUAGE_PHP     Language = 8
)

var Language_name = map[int32]string{
	0: "LANGUAGE_UNKNOWN",
	1: "LANGUAGE_JAVA",
	2: "LANGUAGE_NODE",
	3: "LANGUAGE_PYTHON",
	4: "LANGUAGE_RUBY",
	5: "LANGUAGE_DOTNET",
	6: "LANGUAGE_GO",
	7: "LANGUAGE_CPP",
	8: "LANGUAGE_PHP",
}

var Language_value = map[string]int32{
	"LANGUAGE_UNKNOWN": 0,
	"LANGUAGE_JAVA":    1,
	"LANGUAGE_NODE":    2,
	"LANGUAGE_PYTHON":  3,
	"LANGUAGE_RUBY":    4,
	"LANGUAGE_DOTNET":  5,
	"LANGUAGE_GO":      6,
	"LANGUAGE_CPP":     7,
	"LANGUAGE_PHP":     8,
}

func (x Language) String() string {
	return proto.EnumName(Language_name, int32(x))
}

func (Language) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{1}
}

type ServiceNameSource int32

const (
	ServiceNameSource_SERVICE_NAME_SOURCE_UNKNOWN      ServiceNameSource = 0
	ServiceNameSource_SERVICE_NAME_SOURCE_DD_SERVICE   ServiceNameSource = 1
	ServiceNameSource_SERVICE_NAME_SOURCE_COMMAND_LINE ServiceNameSource = 2
	ServiceNameSource_SERVICE_NAME_SOURCE_LARAVEL      ServiceNameSource = 3
	ServiceNameSource_SERVICE_NAME_SOURCE_PYTHON       ServiceNameSource = 4
	ServiceNameSource_SERVICE_NAME_SOURCE_NODEJS       ServiceNameSource = 5
	ServiceNameSource_SERVICE_NAME_SOURCE_GUNICORN     ServiceNameSource = 6
	ServiceNameSource_SERVICE_NAME_SOURCE_RAILS        ServiceNameSource = 7
	ServiceNameSource_SERVICE_NAME_SOURCE_SPRING       ServiceNameSource = 8
	ServiceNameSource_SERVICE_NAME_SOURCE_JBOSS        ServiceNameSource = 9
	ServiceNameSource_SERVICE_NAME_SOURCE_TOMCAT       ServiceNameSource = 10
	ServiceNameSource_SERVICE_NAME_SOURCE_WEBLOGIC     ServiceNameSource = 11
	ServiceNameSource_SERVICE_NAME_SOURCE_WEBSPHERE    ServiceNameSource = 12
)

var ServiceNameSource_name = map[int32]string{
	0:  "SERVICE_NAME_SOURCE_UNKNOWN",
	1:  "SERVICE_NAME_SOURCE_DD_SERVICE",
	2:  "SERVICE_NAME_SOURCE_COMMAND_LINE",
	3:  "SERVICE_NAME_SOURCE_LARAVEL",
	4:  "SERVICE_NAME_SOURCE_PYTHON",
	5:  "SERVICE_NAME_SOURCE_NODEJS",
	6:  "SERVICE_NAME_SOURCE_GUNICORN",
	7:  "SERVICE_NAME_SOURCE_RAILS",
	8:  "SERVICE_NAME_SOURCE_SPRING",
	9:  "SERVICE_NAME_SOURCE_JBOSS",
	10: "SERVICE_NAME_SOURCE_TOMCAT",
	11: "SERVICE_NAME_SOURCE_WEBLOGIC",
	12: "SERVICE_NAME_SOURCE_WEBSPHERE",
}

var ServiceNameSource_value = map[string]int32{
	"SERVICE_NAME_SOURCE_UNKNOWN":      0,
	"SERVICE_NAME_SOURCE_DD_SERVICE":   1,
	"SERVICE_NAME_SOURCE_COMMAND_LINE": 2,
	"SERVICE_NAME_SOURCE_LARAVEL":      3,
	"SERVICE_NAME_SOURCE_PYTHON":       4,
	"SERVICE_NAME_SOURCE_NODEJS":       5,
	"SERVICE_NAME_SOURCE_GUNICORN":     6,
	"SERVICE_NAME_SOURCE_RAILS":        7,
	"SERVICE_NAME_SOURCE_SPRING":       8,
	"SERVICE_NAME_SOURCE_JBOSS":        9,
	"SERVICE_NAME_SOURCE_TOMCAT":       10,
	"SERVICE_NAME_SOURCE_WEBLOGIC":     11,
	"SERVICE_NAME_SOURCE_WEBSPHERE":    12,
}

func (x ServiceNameSource) String() string {
	return proto.EnumName(ServiceNameSource_name, int32(x))
}

func (ServiceNameSource) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{2}
}

// status section in https://docs.docker.com/engine/api/v1.29/#tag/Container
type ContainerState int32

const (
	ContainerState_unknown    ContainerState = 0
	ContainerState_created    ContainerState = 1
	ContainerState_restarting ContainerState = 2
	ContainerState_running    ContainerState = 3
	ContainerState_paused     ContainerState = 4
	ContainerState_exited     ContainerState = 5
	ContainerState_dead       ContainerState = 6
)

var ContainerState_name = map[int32]string{
	0: "unknown",
	1: "created",
	2: "restarting",
	3: "running",
	4: "paused",
	5: "exited",
	6: "dead",
}

var ContainerState_value = map[string]int32{
	"unknown":    0,
	"created":    1,
	"restarting": 2,
	"running":    3,
	"paused":     4,
	"exited":     5,
	"dead":       6,
}

func (x ContainerState) String() string {
	return proto.EnumName(ContainerState_name, int32(x))
}

func (ContainerState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{3}
}

// https://blog.couchbase.com/docker-health-check-keeping-containers-healthy/
// health can be: starting, healthy, unhealthy
type ContainerHealth int32

const (
	ContainerHealth_unknownHealth ContainerHealth = 0
	ContainerHealth_starting      ContainerHealth = 1
	ContainerHealth_healthy       ContainerHealth = 2
	ContainerHealth_unhealthy     ContainerHealth = 3
)

var ContainerHealth_name = map[int32]string{
	0: "unknownHealth",
	1: "starting",
	2: "healthy",
	3: "unhealthy",
}

var ContainerHealth_value = map[string]int32{
	"unknownHealth": 0,
	"starting":      1,
	"healthy":       2,
	"unhealthy":     3,
}

func (x ContainerHealth) String() string {
	return proto.EnumName(ContainerHealth_name, int32(x))
}

func (ContainerHealth) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{4}
}

// Process state codes in http://wiki.preshweb.co.uk/doku.php?id=linux:psflags
type ProcessState int32

const (
	ProcessState_U ProcessState = 0
	ProcessState_D ProcessState = 1
	ProcessState_R ProcessState = 2
	ProcessState_S ProcessState = 3
	ProcessState_T ProcessState = 4
	ProcessState_W ProcessState = 5
	ProcessState_X ProcessState = 6
	ProcessState_Z ProcessState = 7
)

var ProcessState_name = map[int32]string{
	0: "U",
	1: "D",
	2: "R",
	3: "S",
	4: "T",
	5: "W",
	6: "X",
	7: "Z",
}

var ProcessState_value = map[string]int32{
	"U": 0,
	"D": 1,
	"R": 2,
	"S": 3,
	"T": 4,
	"W": 5,
	"X": 6,
	"Z": 7,
}

func (x ProcessState) String() string {
	return proto.EnumName(ProcessState_name, int32(x))
}

func (ProcessState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{5}
}

type ConnectionType int32

const (
	ConnectionType_tcp ConnectionType = 0
	ConnectionType_udp ConnectionType = 1
)

var ConnectionType_name = map[int32]string{
	0: "tcp",
	1: "udp",
}

var ConnectionType_value = map[string]int32{
	"tcp": 0,
	"udp": 1,
}

func (x ConnectionType) String() string {
	return proto.EnumName(ConnectionType_name, int32(x))
}

func (ConnectionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{6}
}

type OrchestratorResource int32

const (
	OrchestratorResource_OrchestratorResource_UNSPECIFIED OrchestratorResource = 0
	OrchestratorResource_POD                              OrchestratorResource = 1
	OrchestratorResource_REPLICASET                       OrchestratorResource = 2
	OrchestratorResource_SERVICE                          OrchestratorResource = 3
	OrchestratorResource_NODE                             OrchestratorResource = 4
	OrchestratorResource_CLUSTER                          OrchestratorResource = 5
	OrchestratorResource_JOB                              OrchestratorResource = 6
	OrchestratorResource_CRONJOB                          OrchestratorResource = 7
	OrchestratorResource_DAEMONSET                        OrchestratorResource = 8
	OrchestratorResource_STATEFULSET                      OrchestratorResource = 9
	OrchestratorResource_PERSISTENTVOLUME                 OrchestratorResource = 10
	OrchestratorResource_PERSISTENTVOLUMECLAIM            OrchestratorResource = 11
	OrchestratorResource_ROLE                             OrchestratorResource = 12
	OrchestratorResource_ROLEBINDING                      OrchestratorResource = 13
	OrchestratorResource_CLUSTERROLE                      OrchestratorResource = 14
	OrchestratorResource_CLUSTERROLEBINDING               OrchestratorResource = 15
	OrchestratorResource_SERVICEACCOUNT                   OrchestratorResource = 16
	OrchestratorResource_INGRESS                          OrchestratorResource = 17
	OrchestratorResource_DEPLOYMENT                       OrchestratorResource = 18
	OrchestratorResource_NAMESPACE                        OrchestratorResource = 19
	OrchestratorResource_CRD                              OrchestratorResource = 20
	OrchestratorResource_CR                               OrchestratorResource = 21
	OrchestratorResource_VERTICALPODAUTOSCALER            OrchestratorResource = 22
	OrchestratorResource_HORIZONTALPODAUTOSCALER          OrchestratorResource = 23
	OrchestratorResource_NETWORKPOLICY                    OrchestratorResource = 24
	OrchestratorResource_LIMITRANGE                       OrchestratorResource = 25
	OrchestratorResource_STORAGECLASS                     OrchestratorResource = 26
	OrchestratorResource_ECSTASK                          OrchestratorResource = 150
)

var OrchestratorResource_name = map[int32]string{
	0:   "OrchestratorResource_UNSPECIFIED",
	1:   "POD",
	2:   "REPLICASET",
	3:   "SERVICE",
	4:   "NODE",
	5:   "CLUSTER",
	6:   "JOB",
	7:   "CRONJOB",
	8:   "DAEMONSET",
	9:   "STATEFULSET",
	10:  "PERSISTENTVOLUME",
	11:  "PERSISTENTVOLUMECLAIM",
	12:  "ROLE",
	13:  "ROLEBINDING",
	14:  "CLUSTERROLE",
	15:  "CLUSTERROLEBINDING",
	16:  "SERVICEACCOUNT",
	17:  "INGRESS",
	18:  "DEPLOYMENT",
	19:  "NAMESPACE",
	20:  "CRD",
	21:  "CR",
	22:  "VERTICALPODAUTOSCALER",
	23:  "HORIZONTALPODAUTOSCALER",
	24:  "NETWORKPOLICY",
	25:  "LIMITRANGE",
	26:  "STORAGECLASS",
	150: "ECSTASK",
}

var OrchestratorResource_value = map[string]int32{
	"OrchestratorResource_UNSPECIFIED": 0,
	"POD":                              1,
	"REPLICASET":                       2,
	"SERVICE":                          3,
	"NODE":                             4,
	"CLUSTER":                          5,
	"JOB":                              6,
	"CRONJOB":                          7,
	"DAEMONSET":                        8,
	"STATEFULSET":                      9,
	"PERSISTENTVOLUME":                 10,
	"PERSISTENTVOLUMECLAIM":            11,
	"ROLE":                             12,
	"ROLEBINDING":                      13,
	"CLUSTERROLE":                      14,
	"CLUSTERROLEBINDING":               15,
	"SERVICEACCOUNT":                   16,
	"INGRESS":                          17,
	"DEPLOYMENT":                       18,
	"NAMESPACE":                        19,
	"CRD":                              20,
	"CR":                               21,
	"VERTICALPODAUTOSCALER":            22,
	"HORIZONTALPODAUTOSCALER":          23,
	"NETWORKPOLICY":                    24,
	"LIMITRANGE":                       25,
	"STORAGECLASS":                     26,
	"ECSTASK":                          150,
}

func (x OrchestratorResource) String() string {
	return proto.EnumName(OrchestratorResource_name, int32(x))
}

func (OrchestratorResource) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{7}
}

type ResourceRequirementsType int32

const (
	ResourceRequirementsType_unknownType        ResourceRequirementsType = 0
	ResourceRequirementsType_container          ResourceRequirementsType = 1
	ResourceRequirementsType_initContainer      ResourceRequirementsType = 2
	ResourceRequirementsType_ephemeralContainer ResourceRequirementsType = 3
	ResourceRequirementsType_nativeSidecar      ResourceRequirementsType = 4
)

var ResourceRequirementsType_name = map[int32]string{
	0: "unknownType",
	1: "container",
	2: "initContainer",
	3: "ephemeralContainer",
	4: "nativeSidecar",
}

var ResourceRequirementsType_value = map[string]int32{
	"unknownType":        0,
	"container":          1,
	"initContainer":      2,
	"ephemeralContainer": 3,
	"nativeSidecar":      4,
}

func (x ResourceRequirementsType) String() string {
	return proto.EnumName(ResourceRequirementsType_name, int32(x))
}

func (ResourceRequirementsType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{8}
}

// A list of the supported operations for the Postgres database.
// Other operations will not be monitored and will not be included in the agent's output.
type PostgresOperation int32

const (
	PostgresOperation_PostgresUnknownOp  PostgresOperation = 0
	PostgresOperation_PostgresSelectOp   PostgresOperation = 1
	PostgresOperation_PostgresInsertOp   PostgresOperation = 2
	PostgresOperation_PostgresUpdateOp   PostgresOperation = 3
	PostgresOperation_PostgresDeleteOp   PostgresOperation = 4
	PostgresOperation_PostgresAlterOp    PostgresOperation = 5
	PostgresOperation_PostgresCreateOp   PostgresOperation = 6
	PostgresOperation_PostgresDropOp     PostgresOperation = 7
	PostgresOperation_PostgresTruncateOp PostgresOperation = 8
	PostgresOperation_PostgresShowOp     PostgresOperation = 9
)

var PostgresOperation_name = map[int32]string{
	0: "PostgresUnknownOp",
	1: "PostgresSelectOp",
	2: "PostgresInsertOp",
	3: "PostgresUpdateOp",
	4: "PostgresDeleteOp",
	5: "PostgresAlterOp",
	6: "PostgresCreateOp",
	7: "PostgresDropOp",
	8: "PostgresTruncateOp",
	9: "PostgresShowOp",
}

var PostgresOperation_value = map[string]int32{
	"PostgresUnknownOp":  0,
	"PostgresSelectOp":   1,
	"PostgresInsertOp":   2,
	"PostgresUpdateOp":   3,
	"PostgresDeleteOp":   4,
	"PostgresAlterOp":    5,
	"PostgresCreateOp":   6,
	"PostgresDropOp":     7,
	"PostgresTruncateOp": 8,
	"PostgresShowOp":     9,
}

func (x PostgresOperation) String() string {
	return proto.EnumName(PostgresOperation_name, int32(x))
}

func (PostgresOperation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{9}
}

// A list of the supported commands for the redis cache.
type RedisCommand int32

const (
	RedisCommand_RedisUnknownCommand RedisCommand = 0
	RedisCommand_RedisGetCommand     RedisCommand = 1
	RedisCommand_RedisSetCommand     RedisCommand = 2
)

var RedisCommand_name = map[int32]string{
	0: "RedisUnknownCommand",
	1: "RedisGetCommand",
	2: "RedisSetCommand",
}

var RedisCommand_value = map[string]int32{
	"RedisUnknownCommand": 0,
	"RedisGetCommand":     1,
	"RedisSetCommand":     2,
}

func (x RedisCommand) String() string {
	return proto.EnumName(RedisCommand_name, int32(x))
}

func (RedisCommand) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{10}
}

type RedisErrorType int32

const (
	RedisErrorType_RedisNoError          RedisErrorType = 0
	RedisErrorType_RedisErrorTypeUnknown RedisErrorType = 1
	RedisErrorType_RedisErrErr           RedisErrorType = 2
	RedisErrorType_RedisErrWrongType     RedisErrorType = 3
	RedisErrorType_RedisErrNoAuth        RedisErrorType = 4
	RedisErrorType_RedisErrNoPerm        RedisErrorType = 5
	RedisErrorType_RedisErrBusy          RedisErrorType = 6
	RedisErrorType_RedisErrNoScript      RedisErrorType = 7
	RedisErrorType_RedisErrLoading       RedisErrorType = 8
	RedisErrorType_RedisErrReadOnly      RedisErrorType = 9
	RedisErrorType_RedisErrExecAbort     RedisErrorType = 10
	RedisErrorType_RedisErrMasterDown    RedisErrorType = 11
	RedisErrorType_RedisErrMisconf       RedisErrorType = 12
	RedisErrorType_RedisErrCrossSlot     RedisErrorType = 13
	RedisErrorType_RedisErrTryAgain      RedisErrorType = 14
	RedisErrorType_RedisErrAsk           RedisErrorType = 15
	RedisErrorType_RedisErrMoved         RedisErrorType = 16
	RedisErrorType_RedisErrClusterDown   RedisErrorType = 17
	RedisErrorType_RedisErrNoReplicas    RedisErrorType = 18
	RedisErrorType_RedisErrOom           RedisErrorType = 19
	RedisErrorType_RedisErrNoQuorum      RedisErrorType = 20
	RedisErrorType_RedisErrBusyKey       RedisErrorType = 21
	RedisErrorType_RedisErrUnblocked     RedisErrorType = 22
	RedisErrorType_RedisErrWrongPass     RedisErrorType = 23
	RedisErrorType_RedisErrInvalidObj    RedisErrorType = 24
)

var RedisErrorType_name = map[int32]string{
	0:  "RedisNoError",
	1:  "RedisErrorTypeUnknown",
	2:  "RedisErrErr",
	3:  "RedisErrWrongType",
	4:  "RedisErrNoAuth",
	5:  "RedisErrNoPerm",
	6:  "RedisErrBusy",
	7:  "RedisErrNoScript",
	8:  "RedisErrLoading",
	9:  "RedisErrReadOnly",
	10: "RedisErrExecAbort",
	11: "RedisErrMasterDown",
	12: "RedisErrMisconf",
	13: "RedisErrCrossSlot",
	14: "RedisErrTryAgain",
	15: "RedisErrAsk",
	16: "RedisErrMoved",
	17: "RedisErrClusterDown",
	18: "RedisErrNoReplicas",
	19: "RedisErrOom",
	20: "RedisErrNoQuorum",
	21: "RedisErrBusyKey",
	22: "RedisErrUnblocked",
	23: "RedisErrWrongPass",
	24: "RedisErrInvalidObj",
}

var RedisErrorType_value = map[string]int32{
	"RedisNoError":          0,
	"RedisErrorTypeUnknown": 1,
	"RedisErrErr":           2,
	"RedisErrWrongType":     3,
	"RedisErrNoAuth":        4,
	"RedisErrNoPerm":        5,
	"RedisErrBusy":          6,
	"RedisErrNoScript":      7,
	"RedisErrLoading":       8,
	"RedisErrReadOnly":      9,
	"RedisErrExecAbort":     10,
	"RedisErrMasterDown":    11,
	"RedisErrMisconf":       12,
	"RedisErrCrossSlot":     13,
	"RedisErrTryAgain":      14,
	"RedisErrAsk":           15,
	"RedisErrMoved":         16,
	"RedisErrClusterDown":   17,
	"RedisErrNoReplicas":    18,
	"RedisErrOom":           19,
	"RedisErrNoQuorum":      20,
	"RedisErrBusyKey":       21,
	"RedisErrUnblocked":     22,
	"RedisErrWrongPass":     23,
	"RedisErrInvalidObj":    24,
}

func (x RedisErrorType) String() string {
	return proto.EnumName(RedisErrorType_name, int32(x))
}

func (RedisErrorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{11}
}

type HTTPResponseStatus int32

const (
	HTTPResponseStatus_Info      HTTPResponseStatus = 0
	HTTPResponseStatus_Success   HTTPResponseStatus = 1
	HTTPResponseStatus_Redirect  HTTPResponseStatus = 2
	HTTPResponseStatus_ClientErr HTTPResponseStatus = 3
	HTTPResponseStatus_ServerErr HTTPResponseStatus = 4
)

var HTTPResponseStatus_name = map[int32]string{
	0: "Info",
	1: "Success",
	2: "Redirect",
	3: "ClientErr",
	4: "ServerErr",
}

var HTTPResponseStatus_value = map[string]int32{
	"Info":      0,
	"Success":   1,
	"Redirect":  2,
	"ClientErr": 3,
	"ServerErr": 4,
}

func (x HTTPResponseStatus) String() string {
	return proto.EnumName(HTTPResponseStatus_name, int32(x))
}

func (HTTPResponseStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{12}
}

type HTTPMethod int32

const (
	HTTPMethod_Unknown HTTPMethod = 0
	HTTPMethod_Get     HTTPMethod = 1
	HTTPMethod_Post    HTTPMethod = 2
	HTTPMethod_Put     HTTPMethod = 3
	HTTPMethod_Delete  HTTPMethod = 4
	HTTPMethod_Head    HTTPMethod = 5
	HTTPMethod_Options HTTPMethod = 6
	HTTPMethod_Patch   HTTPMethod = 7
	HTTPMethod_Trace   HTTPMethod = 8
)

var HTTPMethod_name = map[int32]string{
	0: "Unknown",
	1: "Get",
	2: "Post",
	3: "Put",
	4: "Delete",
	5: "Head",
	6: "Options",
	7: "Patch",
	8: "Trace",
}

var HTTPMethod_value = map[string]int32{
	"Unknown": 0,
	"Get":     1,
	"Post":    2,
	"Put":     3,
	"Delete":  4,
	"Head":    5,
	"Options": 6,
	"Patch":   7,
	"Trace":   8,
}

func (x HTTPMethod) String() string {
	return proto.EnumName(HTTPMethod_name, int32(x))
}

func (HTTPMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{13}
}

type IntOrString_Type int32

const (
	IntOrString_Int    IntOrString_Type = 0
	IntOrString_String IntOrString_Type = 1
)

var IntOrString_Type_name = map[int32]string{
	0: "Int",
	1: "String",
}

var IntOrString_Type_value = map[string]int32{
	"Int":    0,
	"String": 1,
}

func (x IntOrString_Type) String() string {
	return proto.EnumName(IntOrString_Type_name, int32(x))
}

func (IntOrString_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{91, 0}
}

type ResCollector struct {
	Header  *ResCollector_Header `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Message string               `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Status  *CollectorStatus     `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (m *ResCollector) Reset()         { *m = ResCollector{} }
func (m *ResCollector) String() string { return proto.CompactTextString(m) }
func (*ResCollector) ProtoMessage()    {}
func (*ResCollector) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{0}
}
func (m *ResCollector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResCollector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResCollector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResCollector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResCollector.Merge(m, src)
}
func (m *ResCollector) XXX_Size() int {
	return m.Size()
}
func (m *ResCollector) XXX_DiscardUnknown() {
	xxx_messageInfo_ResCollector.DiscardUnknown(m)
}

var xxx_messageInfo_ResCollector proto.InternalMessageInfo

func (m *ResCollector) GetHeader() *ResCollector_Header {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *ResCollector) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ResCollector) GetStatus() *CollectorStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Header must exist at position 1 for compatibility
// with older version of the Agent. We should be able
// to drop this at some point.
type ResCollector_Header struct {
	Type int32 `protobuf:"varint,4,opt,name=type,proto3" json:"type,omitempty"`
}

func (m *ResCollector_Header) Reset()         { *m = ResCollector_Header{} }
func (m *ResCollector_Header) String() string { return proto.CompactTextString(m) }
func (*ResCollector_Header) ProtoMessage()    {}
func (*ResCollector_Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{0, 0}
}
func (m *ResCollector_Header) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResCollector_Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResCollector_Header.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResCollector_Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResCollector_Header.Merge(m, src)
}
func (m *ResCollector_Header) XXX_Size() int {
	return m.Size()
}
func (m *ResCollector_Header) XXX_DiscardUnknown() {
	xxx_messageInfo_ResCollector_Header.DiscardUnknown(m)
}

var xxx_messageInfo_ResCollector_Header proto.InternalMessageInfo

func (m *ResCollector_Header) GetType() int32 {
	if m != nil {
		return m.Type
	}
	return 0
}

type CollectorProc struct {
	HostName          string            `protobuf:"bytes,2,opt,name=hostName,proto3" json:"hostName,omitempty"`
	NetworkId         string            `protobuf:"bytes,11,opt,name=networkId,proto3" json:"networkId,omitempty"`
	Processes         []*Process        `protobuf:"bytes,3,rep,name=processes,proto3" json:"processes,omitempty"`
	Host              *Host             `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
	Info              *SystemInfo       `protobuf:"bytes,5,opt,name=info,proto3" json:"info,omitempty"`
	GroupId           int32             `protobuf:"varint,6,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize         int32             `protobuf:"varint,7,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Containers        []*Container      `protobuf:"bytes,10,rep,name=containers,proto3" json:"containers,omitempty"`
	ContainerHostType ContainerHostType `protobuf:"varint,12,opt,name=containerHostType,proto3,enum=datadog.process_agent.ContainerHostType" json:"containerHostType,omitempty"`
	// Types that are valid to be assigned to Hints:
	//
	//	*CollectorProc_HintMask
	Hints isCollectorProc_Hints `protobuf_oneof:"hints"`
}

func (m *CollectorProc) Reset()         { *m = CollectorProc{} }
func (m *CollectorProc) String() string { return proto.CompactTextString(m) }
func (*CollectorProc) ProtoMessage()    {}
func (*CollectorProc) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{1}
}
func (m *CollectorProc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorProc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorProc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorProc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorProc.Merge(m, src)
}
func (m *CollectorProc) XXX_Size() int {
	return m.Size()
}
func (m *CollectorProc) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorProc.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorProc proto.InternalMessageInfo

type isCollectorProc_Hints interface {
	isCollectorProc_Hints()
	MarshalTo([]byte) (int, error)
	Size() int
}

type CollectorProc_HintMask struct {
	HintMask int32 `protobuf:"varint,14,opt,name=hintMask,proto3,oneof" json:"hintMask,omitempty"`
}

func (*CollectorProc_HintMask) isCollectorProc_Hints() {}

func (m *CollectorProc) GetHints() isCollectorProc_Hints {
	if m != nil {
		return m.Hints
	}
	return nil
}

func (m *CollectorProc) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorProc) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *CollectorProc) GetProcesses() []*Process {
	if m != nil {
		return m.Processes
	}
	return nil
}

func (m *CollectorProc) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *CollectorProc) GetInfo() *SystemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *CollectorProc) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorProc) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorProc) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *CollectorProc) GetContainerHostType() ContainerHostType {
	if m != nil {
		return m.ContainerHostType
	}
	return ContainerHostType_notSpecified
}

func (m *CollectorProc) GetHintMask() int32 {
	if x, ok := m.GetHints().(*CollectorProc_HintMask); ok {
		return x.HintMask
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CollectorProc) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CollectorProc_HintMask)(nil),
	}
}

type CollectorProcDiscovery struct {
	HostName           string              `protobuf:"bytes,1,opt,name=hostName,proto3" json:"hostName,omitempty"`
	GroupId            int32               `protobuf:"varint,2,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize          int32               `protobuf:"varint,3,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	ProcessDiscoveries []*ProcessDiscovery `protobuf:"bytes,4,rep,name=processDiscoveries,proto3" json:"processDiscoveries,omitempty"`
	Host               *Host               `protobuf:"bytes,5,opt,name=host,proto3" json:"host,omitempty"`
}

func (m *CollectorProcDiscovery) Reset()         { *m = CollectorProcDiscovery{} }
func (m *CollectorProcDiscovery) String() string { return proto.CompactTextString(m) }
func (*CollectorProcDiscovery) ProtoMessage()    {}
func (*CollectorProcDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{2}
}
func (m *CollectorProcDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorProcDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorProcDiscovery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorProcDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorProcDiscovery.Merge(m, src)
}
func (m *CollectorProcDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *CollectorProcDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorProcDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorProcDiscovery proto.InternalMessageInfo

func (m *CollectorProcDiscovery) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorProcDiscovery) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorProcDiscovery) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorProcDiscovery) GetProcessDiscoveries() []*ProcessDiscovery {
	if m != nil {
		return m.ProcessDiscoveries
	}
	return nil
}

func (m *CollectorProcDiscovery) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

type CollectorRealTime struct {
	HostName string         `protobuf:"bytes,2,opt,name=hostName,proto3" json:"hostName,omitempty"`
	Stats    []*ProcessStat `protobuf:"bytes,3,rep,name=stats,proto3" json:"stats,omitempty"`
	// Post-resolved fields
	HostId            int64             `protobuf:"varint,4,opt,name=hostId,proto3" json:"hostId,omitempty"`
	OrgId             int32             `protobuf:"varint,5,opt,name=orgId,proto3" json:"orgId,omitempty"`
	GroupId           int32             `protobuf:"varint,6,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize         int32             `protobuf:"varint,7,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	NumCpus           int32             `protobuf:"varint,8,opt,name=numCpus,proto3" json:"numCpus,omitempty"`
	TotalMemory       int64             `protobuf:"varint,9,opt,name=totalMemory,proto3" json:"totalMemory,omitempty"`
	ContainerStats    []*ContainerStat  `protobuf:"bytes,10,rep,name=containerStats,proto3" json:"containerStats,omitempty"`
	ContainerHostType ContainerHostType `protobuf:"varint,11,opt,name=containerHostType,proto3,enum=datadog.process_agent.ContainerHostType" json:"containerHostType,omitempty"`
}

func (m *CollectorRealTime) Reset()         { *m = CollectorRealTime{} }
func (m *CollectorRealTime) String() string { return proto.CompactTextString(m) }
func (*CollectorRealTime) ProtoMessage()    {}
func (*CollectorRealTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{3}
}
func (m *CollectorRealTime) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorRealTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorRealTime.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorRealTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorRealTime.Merge(m, src)
}
func (m *CollectorRealTime) XXX_Size() int {
	return m.Size()
}
func (m *CollectorRealTime) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorRealTime.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorRealTime proto.InternalMessageInfo

func (m *CollectorRealTime) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorRealTime) GetStats() []*ProcessStat {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (m *CollectorRealTime) GetHostId() int64 {
	if m != nil {
		return m.HostId
	}
	return 0
}

func (m *CollectorRealTime) GetOrgId() int32 {
	if m != nil {
		return m.OrgId
	}
	return 0
}

func (m *CollectorRealTime) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorRealTime) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorRealTime) GetNumCpus() int32 {
	if m != nil {
		return m.NumCpus
	}
	return 0
}

func (m *CollectorRealTime) GetTotalMemory() int64 {
	if m != nil {
		return m.TotalMemory
	}
	return 0
}

func (m *CollectorRealTime) GetContainerStats() []*ContainerStat {
	if m != nil {
		return m.ContainerStats
	}
	return nil
}

func (m *CollectorRealTime) GetContainerHostType() ContainerHostType {
	if m != nil {
		return m.ContainerHostType
	}
	return ContainerHostType_notSpecified
}

type CollectorContainer struct {
	HostName   string       `protobuf:"bytes,1,opt,name=hostName,proto3" json:"hostName,omitempty"`
	NetworkId  string       `protobuf:"bytes,11,opt,name=networkId,proto3" json:"networkId,omitempty"`
	Info       *SystemInfo  `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	Containers []*Container `protobuf:"bytes,3,rep,name=containers,proto3" json:"containers,omitempty"`
	GroupId    int32        `protobuf:"varint,4,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize  int32        `protobuf:"varint,5,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	// Post-resolved fields
	Host              *Host             `protobuf:"bytes,8,opt,name=host,proto3" json:"host,omitempty"`
	ContainerHostType ContainerHostType `protobuf:"varint,9,opt,name=containerHostType,proto3,enum=datadog.process_agent.ContainerHostType" json:"containerHostType,omitempty"`
}

func (m *CollectorContainer) Reset()         { *m = CollectorContainer{} }
func (m *CollectorContainer) String() string { return proto.CompactTextString(m) }
func (*CollectorContainer) ProtoMessage()    {}
func (*CollectorContainer) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{4}
}
func (m *CollectorContainer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorContainer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorContainer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorContainer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorContainer.Merge(m, src)
}
func (m *CollectorContainer) XXX_Size() int {
	return m.Size()
}
func (m *CollectorContainer) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorContainer.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorContainer proto.InternalMessageInfo

func (m *CollectorContainer) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorContainer) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *CollectorContainer) GetInfo() *SystemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *CollectorContainer) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *CollectorContainer) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorContainer) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorContainer) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *CollectorContainer) GetContainerHostType() ContainerHostType {
	if m != nil {
		return m.ContainerHostType
	}
	return ContainerHostType_notSpecified
}

type CollectorContainerRealTime struct {
	HostName string           `protobuf:"bytes,1,opt,name=hostName,proto3" json:"hostName,omitempty"`
	Stats    []*ContainerStat `protobuf:"bytes,2,rep,name=stats,proto3" json:"stats,omitempty"`
	// Used for normalization at host-level.
	NumCpus     int32 `protobuf:"varint,3,opt,name=numCpus,proto3" json:"numCpus,omitempty"`
	TotalMemory int64 `protobuf:"varint,4,opt,name=totalMemory,proto3" json:"totalMemory,omitempty"`
	// Post-resolved fields
	HostId            int64             `protobuf:"varint,5,opt,name=hostId,proto3" json:"hostId,omitempty"`
	GroupId           int32             `protobuf:"varint,6,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize         int32             `protobuf:"varint,7,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	ContainerHostType ContainerHostType `protobuf:"varint,8,opt,name=containerHostType,proto3,enum=datadog.process_agent.ContainerHostType" json:"containerHostType,omitempty"`
}

func (m *CollectorContainerRealTime) Reset()         { *m = CollectorContainerRealTime{} }
func (m *CollectorContainerRealTime) String() string { return proto.CompactTextString(m) }
func (*CollectorContainerRealTime) ProtoMessage()    {}
func (*CollectorContainerRealTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{5}
}
func (m *CollectorContainerRealTime) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorContainerRealTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorContainerRealTime.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorContainerRealTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorContainerRealTime.Merge(m, src)
}
func (m *CollectorContainerRealTime) XXX_Size() int {
	return m.Size()
}
func (m *CollectorContainerRealTime) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorContainerRealTime.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorContainerRealTime proto.InternalMessageInfo

func (m *CollectorContainerRealTime) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorContainerRealTime) GetStats() []*ContainerStat {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (m *CollectorContainerRealTime) GetNumCpus() int32 {
	if m != nil {
		return m.NumCpus
	}
	return 0
}

func (m *CollectorContainerRealTime) GetTotalMemory() int64 {
	if m != nil {
		return m.TotalMemory
	}
	return 0
}

func (m *CollectorContainerRealTime) GetHostId() int64 {
	if m != nil {
		return m.HostId
	}
	return 0
}

func (m *CollectorContainerRealTime) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorContainerRealTime) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorContainerRealTime) GetContainerHostType() ContainerHostType {
	if m != nil {
		return m.ContainerHostType
	}
	return ContainerHostType_notSpecified
}

type CollectorReqStatus struct {
	HostName string `protobuf:"bytes,2,opt,name=hostName,proto3" json:"hostName,omitempty"`
}

func (m *CollectorReqStatus) Reset()         { *m = CollectorReqStatus{} }
func (m *CollectorReqStatus) String() string { return proto.CompactTextString(m) }
func (*CollectorReqStatus) ProtoMessage()    {}
func (*CollectorReqStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{6}
}
func (m *CollectorReqStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorReqStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorReqStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorReqStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorReqStatus.Merge(m, src)
}
func (m *CollectorReqStatus) XXX_Size() int {
	return m.Size()
}
func (m *CollectorReqStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorReqStatus.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorReqStatus proto.InternalMessageInfo

func (m *CollectorReqStatus) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

type CollectorECSTask struct {
	AwsAccountID int64         `protobuf:"varint,1,opt,name=awsAccountID,proto3" json:"awsAccountID,omitempty"`
	ClusterName  string        `protobuf:"bytes,2,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,3,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	Region       string        `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	GroupId      int32         `protobuf:"varint,5,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,6,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Tasks        []*ECSTask    `protobuf:"bytes,7,rep,name=tasks,proto3" json:"tasks,omitempty"`
	Tags         []string      `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	Host         *Host         `protobuf:"bytes,9,opt,name=host,proto3" json:"host,omitempty"`
	HostName     string        `protobuf:"bytes,10,opt,name=hostName,proto3" json:"hostName,omitempty"`
	Info         *SystemInfo   `protobuf:"bytes,11,opt,name=info,proto3" json:"info,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,12,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorECSTask) Reset()         { *m = CollectorECSTask{} }
func (m *CollectorECSTask) String() string { return proto.CompactTextString(m) }
func (*CollectorECSTask) ProtoMessage()    {}
func (*CollectorECSTask) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{7}
}
func (m *CollectorECSTask) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorECSTask) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorECSTask.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorECSTask) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorECSTask.Merge(m, src)
}
func (m *CollectorECSTask) XXX_Size() int {
	return m.Size()
}
func (m *CollectorECSTask) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorECSTask.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorECSTask proto.InternalMessageInfo

func (m *CollectorECSTask) GetAwsAccountID() int64 {
	if m != nil {
		return m.AwsAccountID
	}
	return 0
}

func (m *CollectorECSTask) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorECSTask) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorECSTask) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *CollectorECSTask) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorECSTask) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorECSTask) GetTasks() []*ECSTask {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *CollectorECSTask) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorECSTask) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *CollectorECSTask) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorECSTask) GetInfo() *SystemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *CollectorECSTask) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type ECSTask struct {
	Arn                     string             `protobuf:"bytes,1,opt,name=arn,proto3" json:"arn,omitempty"`
	ResourceVersion         string             `protobuf:"bytes,2,opt,name=resourceVersion,proto3" json:"resourceVersion,omitempty"`
	LaunchType              string             `protobuf:"bytes,3,opt,name=launchType,proto3" json:"launchType,omitempty"`
	DesiredStatus           string             `protobuf:"bytes,4,opt,name=desiredStatus,proto3" json:"desiredStatus,omitempty"`
	KnownStatus             string             `protobuf:"bytes,5,opt,name=knownStatus,proto3" json:"knownStatus,omitempty"`
	Family                  string             `protobuf:"bytes,6,opt,name=family,proto3" json:"family,omitempty"`
	Version                 string             `protobuf:"bytes,7,opt,name=version,proto3" json:"version,omitempty"`
	AvailabilityZone        string             `protobuf:"bytes,8,opt,name=availabilityZone,proto3" json:"availabilityZone,omitempty"`
	Limits                  map[string]float64 `protobuf:"bytes,9,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	EphemeralStorageMetrics map[string]int64   `protobuf:"bytes,10,rep,name=ephemeralStorageMetrics,proto3" json:"ephemeralStorageMetrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ServiceName             string             `protobuf:"bytes,11,opt,name=serviceName,proto3" json:"serviceName,omitempty"`
	VpcId                   string             `protobuf:"bytes,12,opt,name=vpcId,proto3" json:"vpcId,omitempty"`
	PullStartedAt           int64              `protobuf:"varint,13,opt,name=pullStartedAt,proto3" json:"pullStartedAt,omitempty"`
	PullStoppedAt           int64              `protobuf:"varint,14,opt,name=pullStoppedAt,proto3" json:"pullStoppedAt,omitempty"`
	ExecutionStoppedAt      int64              `protobuf:"varint,15,opt,name=executionStoppedAt,proto3" json:"executionStoppedAt,omitempty"`
	Containers              []*ECSContainer    `protobuf:"bytes,16,rep,name=containers,proto3" json:"containers,omitempty"`
	Tags                    []string           `protobuf:"bytes,17,rep,name=tags,proto3" json:"tags,omitempty"`
	EcsTags                 []string           `protobuf:"bytes,18,rep,name=ecsTags,proto3" json:"ecsTags,omitempty"`
	ContainerInstanceTags   []string           `protobuf:"bytes,19,rep,name=containerInstanceTags,proto3" json:"containerInstanceTags,omitempty"`
	Host                    *Host              `protobuf:"bytes,20,opt,name=host,proto3" json:"host,omitempty"`
	ContainerInstanceArn    string             `protobuf:"bytes,21,opt,name=containerInstanceArn,proto3" json:"containerInstanceArn,omitempty"`
}

func (m *ECSTask) Reset()         { *m = ECSTask{} }
func (m *ECSTask) String() string { return proto.CompactTextString(m) }
func (*ECSTask) ProtoMessage()    {}
func (*ECSTask) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{8}
}
func (m *ECSTask) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECSTask) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECSTask.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECSTask) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECSTask.Merge(m, src)
}
func (m *ECSTask) XXX_Size() int {
	return m.Size()
}
func (m *ECSTask) XXX_DiscardUnknown() {
	xxx_messageInfo_ECSTask.DiscardUnknown(m)
}

var xxx_messageInfo_ECSTask proto.InternalMessageInfo

func (m *ECSTask) GetArn() string {
	if m != nil {
		return m.Arn
	}
	return ""
}

func (m *ECSTask) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

func (m *ECSTask) GetLaunchType() string {
	if m != nil {
		return m.LaunchType
	}
	return ""
}

func (m *ECSTask) GetDesiredStatus() string {
	if m != nil {
		return m.DesiredStatus
	}
	return ""
}

func (m *ECSTask) GetKnownStatus() string {
	if m != nil {
		return m.KnownStatus
	}
	return ""
}

func (m *ECSTask) GetFamily() string {
	if m != nil {
		return m.Family
	}
	return ""
}

func (m *ECSTask) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ECSTask) GetAvailabilityZone() string {
	if m != nil {
		return m.AvailabilityZone
	}
	return ""
}

func (m *ECSTask) GetLimits() map[string]float64 {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *ECSTask) GetEphemeralStorageMetrics() map[string]int64 {
	if m != nil {
		return m.EphemeralStorageMetrics
	}
	return nil
}

func (m *ECSTask) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ECSTask) GetVpcId() string {
	if m != nil {
		return m.VpcId
	}
	return ""
}

func (m *ECSTask) GetPullStartedAt() int64 {
	if m != nil {
		return m.PullStartedAt
	}
	return 0
}

func (m *ECSTask) GetPullStoppedAt() int64 {
	if m != nil {
		return m.PullStoppedAt
	}
	return 0
}

func (m *ECSTask) GetExecutionStoppedAt() int64 {
	if m != nil {
		return m.ExecutionStoppedAt
	}
	return 0
}

func (m *ECSTask) GetContainers() []*ECSContainer {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *ECSTask) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ECSTask) GetEcsTags() []string {
	if m != nil {
		return m.EcsTags
	}
	return nil
}

func (m *ECSTask) GetContainerInstanceTags() []string {
	if m != nil {
		return m.ContainerInstanceTags
	}
	return nil
}

func (m *ECSTask) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *ECSTask) GetContainerInstanceArn() string {
	if m != nil {
		return m.ContainerInstanceArn
	}
	return ""
}

type ECSContainer struct {
	DockerID      string                 `protobuf:"bytes,1,opt,name=dockerID,proto3" json:"dockerID,omitempty"`
	DockerName    string                 `protobuf:"bytes,2,opt,name=dockerName,proto3" json:"dockerName,omitempty"`
	Name          string                 `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Image         string                 `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	ImageID       string                 `protobuf:"bytes,5,opt,name=imageID,proto3" json:"imageID,omitempty"`
	CreatedAt     int64                  `protobuf:"varint,6,opt,name=createdAt,proto3" json:"createdAt,omitempty"`
	StartedAt     int64                  `protobuf:"varint,7,opt,name=startedAt,proto3" json:"startedAt,omitempty"`
	FinishedAt    int64                  `protobuf:"varint,8,opt,name=finishedAt,proto3" json:"finishedAt,omitempty"`
	DesiredStatus string                 `protobuf:"bytes,9,opt,name=desiredStatus,proto3" json:"desiredStatus,omitempty"`
	KnownStatus   string                 `protobuf:"bytes,10,opt,name=knownStatus,proto3" json:"knownStatus,omitempty"`
	ExitCode      *ECSContainerExitCode  `protobuf:"bytes,11,opt,name=exitCode,proto3" json:"exitCode,omitempty"`
	Type          string                 `protobuf:"bytes,12,opt,name=type,proto3" json:"type,omitempty"`
	LogDriver     string                 `protobuf:"bytes,13,opt,name=logDriver,proto3" json:"logDriver,omitempty"`
	LogOptions    map[string]string      `protobuf:"bytes,14,rep,name=logOptions,proto3" json:"logOptions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ContainerArn  string                 `protobuf:"bytes,15,opt,name=containerArn,proto3" json:"containerArn,omitempty"`
	Ports         []*ECSContainerPort    `protobuf:"bytes,16,rep,name=ports,proto3" json:"ports,omitempty"`
	Networks      []*ECSContainerNetwork `protobuf:"bytes,17,rep,name=networks,proto3" json:"networks,omitempty"`
	Volumes       []*ECSContainerVolume  `protobuf:"bytes,18,rep,name=volumes,proto3" json:"volumes,omitempty"`
	Health        *ECSContainerHealth    `protobuf:"bytes,19,opt,name=health,proto3" json:"health,omitempty"`
	Labels        []string               `protobuf:"bytes,20,rep,name=labels,proto3" json:"labels,omitempty"`
	Limits        map[string]float64     `protobuf:"bytes,21,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	Snapshotter   string                 `protobuf:"bytes,22,opt,name=snapshotter,proto3" json:"snapshotter,omitempty"`
}

func (m *ECSContainer) Reset()         { *m = ECSContainer{} }
func (m *ECSContainer) String() string { return proto.CompactTextString(m) }
func (*ECSContainer) ProtoMessage()    {}
func (*ECSContainer) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{9}
}
func (m *ECSContainer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECSContainer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECSContainer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECSContainer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECSContainer.Merge(m, src)
}
func (m *ECSContainer) XXX_Size() int {
	return m.Size()
}
func (m *ECSContainer) XXX_DiscardUnknown() {
	xxx_messageInfo_ECSContainer.DiscardUnknown(m)
}

var xxx_messageInfo_ECSContainer proto.InternalMessageInfo

func (m *ECSContainer) GetDockerID() string {
	if m != nil {
		return m.DockerID
	}
	return ""
}

func (m *ECSContainer) GetDockerName() string {
	if m != nil {
		return m.DockerName
	}
	return ""
}

func (m *ECSContainer) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ECSContainer) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *ECSContainer) GetImageID() string {
	if m != nil {
		return m.ImageID
	}
	return ""
}

func (m *ECSContainer) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *ECSContainer) GetStartedAt() int64 {
	if m != nil {
		return m.StartedAt
	}
	return 0
}

func (m *ECSContainer) GetFinishedAt() int64 {
	if m != nil {
		return m.FinishedAt
	}
	return 0
}

func (m *ECSContainer) GetDesiredStatus() string {
	if m != nil {
		return m.DesiredStatus
	}
	return ""
}

func (m *ECSContainer) GetKnownStatus() string {
	if m != nil {
		return m.KnownStatus
	}
	return ""
}

func (m *ECSContainer) GetExitCode() *ECSContainerExitCode {
	if m != nil {
		return m.ExitCode
	}
	return nil
}

func (m *ECSContainer) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ECSContainer) GetLogDriver() string {
	if m != nil {
		return m.LogDriver
	}
	return ""
}

func (m *ECSContainer) GetLogOptions() map[string]string {
	if m != nil {
		return m.LogOptions
	}
	return nil
}

func (m *ECSContainer) GetContainerArn() string {
	if m != nil {
		return m.ContainerArn
	}
	return ""
}

func (m *ECSContainer) GetPorts() []*ECSContainerPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *ECSContainer) GetNetworks() []*ECSContainerNetwork {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *ECSContainer) GetVolumes() []*ECSContainerVolume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *ECSContainer) GetHealth() *ECSContainerHealth {
	if m != nil {
		return m.Health
	}
	return nil
}

func (m *ECSContainer) GetLabels() []string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ECSContainer) GetLimits() map[string]float64 {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *ECSContainer) GetSnapshotter() string {
	if m != nil {
		return m.Snapshotter
	}
	return ""
}

type ECSContainerNetwork struct {
	NetworkMode   string   `protobuf:"bytes,1,opt,name=networkMode,proto3" json:"networkMode,omitempty"`
	Ipv4Addresses []string `protobuf:"bytes,2,rep,name=ipv4Addresses,proto3" json:"ipv4Addresses,omitempty"`
	Ipv6Addresses []string `protobuf:"bytes,3,rep,name=ipv6Addresses,proto3" json:"ipv6Addresses,omitempty"`
}

func (m *ECSContainerNetwork) Reset()         { *m = ECSContainerNetwork{} }
func (m *ECSContainerNetwork) String() string { return proto.CompactTextString(m) }
func (*ECSContainerNetwork) ProtoMessage()    {}
func (*ECSContainerNetwork) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{10}
}
func (m *ECSContainerNetwork) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECSContainerNetwork) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECSContainerNetwork.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECSContainerNetwork) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECSContainerNetwork.Merge(m, src)
}
func (m *ECSContainerNetwork) XXX_Size() int {
	return m.Size()
}
func (m *ECSContainerNetwork) XXX_DiscardUnknown() {
	xxx_messageInfo_ECSContainerNetwork.DiscardUnknown(m)
}

var xxx_messageInfo_ECSContainerNetwork proto.InternalMessageInfo

func (m *ECSContainerNetwork) GetNetworkMode() string {
	if m != nil {
		return m.NetworkMode
	}
	return ""
}

func (m *ECSContainerNetwork) GetIpv4Addresses() []string {
	if m != nil {
		return m.Ipv4Addresses
	}
	return nil
}

func (m *ECSContainerNetwork) GetIpv6Addresses() []string {
	if m != nil {
		return m.Ipv6Addresses
	}
	return nil
}

type ECSContainerPort struct {
	ContainerPort int32  `protobuf:"varint,1,opt,name=containerPort,proto3" json:"containerPort,omitempty"`
	Protocol      string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	HostIp        string `protobuf:"bytes,3,opt,name=hostIp,proto3" json:"hostIp,omitempty"`
	HostPort      int32  `protobuf:"varint,4,opt,name=hostPort,proto3" json:"hostPort,omitempty"`
}

func (m *ECSContainerPort) Reset()         { *m = ECSContainerPort{} }
func (m *ECSContainerPort) String() string { return proto.CompactTextString(m) }
func (*ECSContainerPort) ProtoMessage()    {}
func (*ECSContainerPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{11}
}
func (m *ECSContainerPort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECSContainerPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECSContainerPort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECSContainerPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECSContainerPort.Merge(m, src)
}
func (m *ECSContainerPort) XXX_Size() int {
	return m.Size()
}
func (m *ECSContainerPort) XXX_DiscardUnknown() {
	xxx_messageInfo_ECSContainerPort.DiscardUnknown(m)
}

var xxx_messageInfo_ECSContainerPort proto.InternalMessageInfo

func (m *ECSContainerPort) GetContainerPort() int32 {
	if m != nil {
		return m.ContainerPort
	}
	return 0
}

func (m *ECSContainerPort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *ECSContainerPort) GetHostIp() string {
	if m != nil {
		return m.HostIp
	}
	return ""
}

func (m *ECSContainerPort) GetHostPort() int32 {
	if m != nil {
		return m.HostPort
	}
	return 0
}

type ECSContainerVolume struct {
	DockerName  string `protobuf:"bytes,1,opt,name=dockerName,proto3" json:"dockerName,omitempty"`
	Source      string `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	Destination string `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
}

func (m *ECSContainerVolume) Reset()         { *m = ECSContainerVolume{} }
func (m *ECSContainerVolume) String() string { return proto.CompactTextString(m) }
func (*ECSContainerVolume) ProtoMessage()    {}
func (*ECSContainerVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{12}
}
func (m *ECSContainerVolume) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECSContainerVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECSContainerVolume.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECSContainerVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECSContainerVolume.Merge(m, src)
}
func (m *ECSContainerVolume) XXX_Size() int {
	return m.Size()
}
func (m *ECSContainerVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_ECSContainerVolume.DiscardUnknown(m)
}

var xxx_messageInfo_ECSContainerVolume proto.InternalMessageInfo

func (m *ECSContainerVolume) GetDockerName() string {
	if m != nil {
		return m.DockerName
	}
	return ""
}

func (m *ECSContainerVolume) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *ECSContainerVolume) GetDestination() string {
	if m != nil {
		return m.Destination
	}
	return ""
}

type ECSContainerHealth struct {
	Status   string                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Since    int64                 `protobuf:"varint,2,opt,name=since,proto3" json:"since,omitempty"`
	ExitCode *ECSContainerExitCode `protobuf:"bytes,3,opt,name=exitCode,proto3" json:"exitCode,omitempty"`
	Output   string                `protobuf:"bytes,4,opt,name=output,proto3" json:"output,omitempty"`
}

func (m *ECSContainerHealth) Reset()         { *m = ECSContainerHealth{} }
func (m *ECSContainerHealth) String() string { return proto.CompactTextString(m) }
func (*ECSContainerHealth) ProtoMessage()    {}
func (*ECSContainerHealth) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{13}
}
func (m *ECSContainerHealth) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECSContainerHealth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECSContainerHealth.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECSContainerHealth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECSContainerHealth.Merge(m, src)
}
func (m *ECSContainerHealth) XXX_Size() int {
	return m.Size()
}
func (m *ECSContainerHealth) XXX_DiscardUnknown() {
	xxx_messageInfo_ECSContainerHealth.DiscardUnknown(m)
}

var xxx_messageInfo_ECSContainerHealth proto.InternalMessageInfo

func (m *ECSContainerHealth) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ECSContainerHealth) GetSince() int64 {
	if m != nil {
		return m.Since
	}
	return 0
}

func (m *ECSContainerHealth) GetExitCode() *ECSContainerExitCode {
	if m != nil {
		return m.ExitCode
	}
	return nil
}

func (m *ECSContainerHealth) GetOutput() string {
	if m != nil {
		return m.Output
	}
	return ""
}

type ECSContainerExitCode struct {
	ExitCode int32 `protobuf:"varint,3,opt,name=exitCode,proto3" json:"exitCode,omitempty"`
}

func (m *ECSContainerExitCode) Reset()         { *m = ECSContainerExitCode{} }
func (m *ECSContainerExitCode) String() string { return proto.CompactTextString(m) }
func (*ECSContainerExitCode) ProtoMessage()    {}
func (*ECSContainerExitCode) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{14}
}
func (m *ECSContainerExitCode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECSContainerExitCode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECSContainerExitCode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECSContainerExitCode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECSContainerExitCode.Merge(m, src)
}
func (m *ECSContainerExitCode) XXX_Size() int {
	return m.Size()
}
func (m *ECSContainerExitCode) XXX_DiscardUnknown() {
	xxx_messageInfo_ECSContainerExitCode.DiscardUnknown(m)
}

var xxx_messageInfo_ECSContainerExitCode proto.InternalMessageInfo

func (m *ECSContainerExitCode) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

type CollectorPod struct {
	HostName     string        `protobuf:"bytes,1,opt,name=hostName,proto3" json:"hostName,omitempty"`
	ClusterName  string        `protobuf:"bytes,2,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,3,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,4,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,5,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Pods         []*Pod        `protobuf:"bytes,6,rep,name=pods,proto3" json:"pods,omitempty"`
	Host         *Host         `protobuf:"bytes,7,opt,name=host,proto3" json:"host,omitempty"`
	Tags         []string      `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	Info         *SystemInfo   `protobuf:"bytes,9,opt,name=info,proto3" json:"info,omitempty"`
	IsTerminated bool          `protobuf:"varint,10,opt,name=isTerminated,proto3" json:"isTerminated,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,11,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorPod) Reset()         { *m = CollectorPod{} }
func (m *CollectorPod) String() string { return proto.CompactTextString(m) }
func (*CollectorPod) ProtoMessage()    {}
func (*CollectorPod) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{15}
}
func (m *CollectorPod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorPod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorPod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorPod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorPod.Merge(m, src)
}
func (m *CollectorPod) XXX_Size() int {
	return m.Size()
}
func (m *CollectorPod) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorPod.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorPod proto.InternalMessageInfo

func (m *CollectorPod) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorPod) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorPod) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorPod) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorPod) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorPod) GetPods() []*Pod {
	if m != nil {
		return m.Pods
	}
	return nil
}

func (m *CollectorPod) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *CollectorPod) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorPod) GetInfo() *SystemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *CollectorPod) GetIsTerminated() bool {
	if m != nil {
		return m.IsTerminated
	}
	return false
}

func (m *CollectorPod) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorPodDisruptionBudget struct {
	ClusterName          string                 `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId            string                 `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId              int32                  `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	PodDisruptionBudgets []*PodDisruptionBudget `protobuf:"bytes,4,rep,name=podDisruptionBudgets,proto3" json:"podDisruptionBudgets,omitempty"`
	Tags                 []string               `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	GroupSize            int32                  `protobuf:"varint,6,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	AgentVersion         *AgentVersion          `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorPodDisruptionBudget) Reset()         { *m = CollectorPodDisruptionBudget{} }
func (m *CollectorPodDisruptionBudget) String() string { return proto.CompactTextString(m) }
func (*CollectorPodDisruptionBudget) ProtoMessage()    {}
func (*CollectorPodDisruptionBudget) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{16}
}
func (m *CollectorPodDisruptionBudget) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorPodDisruptionBudget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorPodDisruptionBudget.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorPodDisruptionBudget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorPodDisruptionBudget.Merge(m, src)
}
func (m *CollectorPodDisruptionBudget) XXX_Size() int {
	return m.Size()
}
func (m *CollectorPodDisruptionBudget) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorPodDisruptionBudget.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorPodDisruptionBudget proto.InternalMessageInfo

func (m *CollectorPodDisruptionBudget) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorPodDisruptionBudget) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorPodDisruptionBudget) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorPodDisruptionBudget) GetPodDisruptionBudgets() []*PodDisruptionBudget {
	if m != nil {
		return m.PodDisruptionBudgets
	}
	return nil
}

func (m *CollectorPodDisruptionBudget) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorPodDisruptionBudget) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorPodDisruptionBudget) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorReplicaSet struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	ReplicaSets  []*ReplicaSet `protobuf:"bytes,5,rep,name=replicaSets,proto3" json:"replicaSets,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorReplicaSet) Reset()         { *m = CollectorReplicaSet{} }
func (m *CollectorReplicaSet) String() string { return proto.CompactTextString(m) }
func (*CollectorReplicaSet) ProtoMessage()    {}
func (*CollectorReplicaSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{17}
}
func (m *CollectorReplicaSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorReplicaSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorReplicaSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorReplicaSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorReplicaSet.Merge(m, src)
}
func (m *CollectorReplicaSet) XXX_Size() int {
	return m.Size()
}
func (m *CollectorReplicaSet) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorReplicaSet.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorReplicaSet proto.InternalMessageInfo

func (m *CollectorReplicaSet) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorReplicaSet) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorReplicaSet) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorReplicaSet) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorReplicaSet) GetReplicaSets() []*ReplicaSet {
	if m != nil {
		return m.ReplicaSets
	}
	return nil
}

func (m *CollectorReplicaSet) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorReplicaSet) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorDeployment struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Deployments  []*Deployment `protobuf:"bytes,5,rep,name=deployments,proto3" json:"deployments,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorDeployment) Reset()         { *m = CollectorDeployment{} }
func (m *CollectorDeployment) String() string { return proto.CompactTextString(m) }
func (*CollectorDeployment) ProtoMessage()    {}
func (*CollectorDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{18}
}
func (m *CollectorDeployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorDeployment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorDeployment.Merge(m, src)
}
func (m *CollectorDeployment) XXX_Size() int {
	return m.Size()
}
func (m *CollectorDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorDeployment proto.InternalMessageInfo

func (m *CollectorDeployment) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorDeployment) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorDeployment) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorDeployment) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorDeployment) GetDeployments() []*Deployment {
	if m != nil {
		return m.Deployments
	}
	return nil
}

func (m *CollectorDeployment) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorDeployment) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorService struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Services     []*Service    `protobuf:"bytes,5,rep,name=services,proto3" json:"services,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorService) Reset()         { *m = CollectorService{} }
func (m *CollectorService) String() string { return proto.CompactTextString(m) }
func (*CollectorService) ProtoMessage()    {}
func (*CollectorService) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{19}
}
func (m *CollectorService) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorService.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorService.Merge(m, src)
}
func (m *CollectorService) XXX_Size() int {
	return m.Size()
}
func (m *CollectorService) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorService.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorService proto.InternalMessageInfo

func (m *CollectorService) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorService) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorService) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorService) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorService) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *CollectorService) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorService) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorNode struct {
	ClusterName      string           `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId        string           `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId          int32            `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize        int32            `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Nodes            []*Node          `protobuf:"bytes,5,rep,name=nodes,proto3" json:"nodes,omitempty"`
	Tags             []string         `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	HostAliasMapping map[string]*Host `protobuf:"bytes,7,rep,name=hostAliasMapping,proto3" json:"hostAliasMapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	AgentVersion     *AgentVersion    `protobuf:"bytes,8,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorNode) Reset()         { *m = CollectorNode{} }
func (m *CollectorNode) String() string { return proto.CompactTextString(m) }
func (*CollectorNode) ProtoMessage()    {}
func (*CollectorNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{20}
}
func (m *CollectorNode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorNode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorNode.Merge(m, src)
}
func (m *CollectorNode) XXX_Size() int {
	return m.Size()
}
func (m *CollectorNode) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorNode.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorNode proto.InternalMessageInfo

func (m *CollectorNode) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorNode) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorNode) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorNode) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorNode) GetNodes() []*Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *CollectorNode) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorNode) GetHostAliasMapping() map[string]*Host {
	if m != nil {
		return m.HostAliasMapping
	}
	return nil
}

func (m *CollectorNode) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorCluster struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Cluster      *Cluster      `protobuf:"bytes,5,opt,name=cluster,proto3" json:"cluster,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorCluster) Reset()         { *m = CollectorCluster{} }
func (m *CollectorCluster) String() string { return proto.CompactTextString(m) }
func (*CollectorCluster) ProtoMessage()    {}
func (*CollectorCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{21}
}
func (m *CollectorCluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorCluster.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorCluster.Merge(m, src)
}
func (m *CollectorCluster) XXX_Size() int {
	return m.Size()
}
func (m *CollectorCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorCluster.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorCluster proto.InternalMessageInfo

func (m *CollectorCluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorCluster) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorCluster) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorCluster) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorCluster) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *CollectorCluster) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorCluster) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

// CollectorManifest is the dedicated payload/pipeline for the yaml collection
type CollectorManifest struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Manifests    []*Manifest   `protobuf:"bytes,5,rep,name=manifests,proto3" json:"manifests,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	HostName     string        `protobuf:"bytes,7,opt,name=hostName,proto3" json:"hostName,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,8,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorManifest) Reset()         { *m = CollectorManifest{} }
func (m *CollectorManifest) String() string { return proto.CompactTextString(m) }
func (*CollectorManifest) ProtoMessage()    {}
func (*CollectorManifest) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{22}
}
func (m *CollectorManifest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorManifest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorManifest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorManifest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorManifest.Merge(m, src)
}
func (m *CollectorManifest) XXX_Size() int {
	return m.Size()
}
func (m *CollectorManifest) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorManifest.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorManifest proto.InternalMessageInfo

func (m *CollectorManifest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorManifest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorManifest) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorManifest) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorManifest) GetManifests() []*Manifest {
	if m != nil {
		return m.Manifests
	}
	return nil
}

func (m *CollectorManifest) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorManifest) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorManifest) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorManifestCRD struct {
	Manifest *CollectorManifest `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	Tags     []string           `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *CollectorManifestCRD) Reset()         { *m = CollectorManifestCRD{} }
func (m *CollectorManifestCRD) String() string { return proto.CompactTextString(m) }
func (*CollectorManifestCRD) ProtoMessage()    {}
func (*CollectorManifestCRD) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{23}
}
func (m *CollectorManifestCRD) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorManifestCRD) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorManifestCRD.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorManifestCRD) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorManifestCRD.Merge(m, src)
}
func (m *CollectorManifestCRD) XXX_Size() int {
	return m.Size()
}
func (m *CollectorManifestCRD) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorManifestCRD.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorManifestCRD proto.InternalMessageInfo

func (m *CollectorManifestCRD) GetManifest() *CollectorManifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *CollectorManifestCRD) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type CollectorManifestCR struct {
	Manifest *CollectorManifest `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	Tags     []string           `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *CollectorManifestCR) Reset()         { *m = CollectorManifestCR{} }
func (m *CollectorManifestCR) String() string { return proto.CompactTextString(m) }
func (*CollectorManifestCR) ProtoMessage()    {}
func (*CollectorManifestCR) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{24}
}
func (m *CollectorManifestCR) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorManifestCR) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorManifestCR.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorManifestCR) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorManifestCR.Merge(m, src)
}
func (m *CollectorManifestCR) XXX_Size() int {
	return m.Size()
}
func (m *CollectorManifestCR) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorManifestCR.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorManifestCR proto.InternalMessageInfo

func (m *CollectorManifestCR) GetManifest() *CollectorManifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *CollectorManifestCR) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type CollectorNamespace struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Namespaces   []*Namespace  `protobuf:"bytes,5,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorNamespace) Reset()         { *m = CollectorNamespace{} }
func (m *CollectorNamespace) String() string { return proto.CompactTextString(m) }
func (*CollectorNamespace) ProtoMessage()    {}
func (*CollectorNamespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{25}
}
func (m *CollectorNamespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorNamespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorNamespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorNamespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorNamespace.Merge(m, src)
}
func (m *CollectorNamespace) XXX_Size() int {
	return m.Size()
}
func (m *CollectorNamespace) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorNamespace.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorNamespace proto.InternalMessageInfo

func (m *CollectorNamespace) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorNamespace) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorNamespace) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorNamespace) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorNamespace) GetNamespaces() []*Namespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *CollectorNamespace) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorNamespace) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorJob struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Jobs         []*Job        `protobuf:"bytes,5,rep,name=jobs,proto3" json:"jobs,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorJob) Reset()         { *m = CollectorJob{} }
func (m *CollectorJob) String() string { return proto.CompactTextString(m) }
func (*CollectorJob) ProtoMessage()    {}
func (*CollectorJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{26}
}
func (m *CollectorJob) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorJob.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorJob.Merge(m, src)
}
func (m *CollectorJob) XXX_Size() int {
	return m.Size()
}
func (m *CollectorJob) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorJob.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorJob proto.InternalMessageInfo

func (m *CollectorJob) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorJob) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorJob) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorJob) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorJob) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *CollectorJob) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorJob) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorCronJob struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	CronJobs     []*CronJob    `protobuf:"bytes,5,rep,name=cronJobs,proto3" json:"cronJobs,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorCronJob) Reset()         { *m = CollectorCronJob{} }
func (m *CollectorCronJob) String() string { return proto.CompactTextString(m) }
func (*CollectorCronJob) ProtoMessage()    {}
func (*CollectorCronJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{27}
}
func (m *CollectorCronJob) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorCronJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorCronJob.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorCronJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorCronJob.Merge(m, src)
}
func (m *CollectorCronJob) XXX_Size() int {
	return m.Size()
}
func (m *CollectorCronJob) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorCronJob.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorCronJob proto.InternalMessageInfo

func (m *CollectorCronJob) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorCronJob) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorCronJob) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorCronJob) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorCronJob) GetCronJobs() []*CronJob {
	if m != nil {
		return m.CronJobs
	}
	return nil
}

func (m *CollectorCronJob) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorCronJob) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorDaemonSet struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	DaemonSets   []*DaemonSet  `protobuf:"bytes,5,rep,name=daemonSets,proto3" json:"daemonSets,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorDaemonSet) Reset()         { *m = CollectorDaemonSet{} }
func (m *CollectorDaemonSet) String() string { return proto.CompactTextString(m) }
func (*CollectorDaemonSet) ProtoMessage()    {}
func (*CollectorDaemonSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{28}
}
func (m *CollectorDaemonSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorDaemonSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorDaemonSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorDaemonSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorDaemonSet.Merge(m, src)
}
func (m *CollectorDaemonSet) XXX_Size() int {
	return m.Size()
}
func (m *CollectorDaemonSet) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorDaemonSet.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorDaemonSet proto.InternalMessageInfo

func (m *CollectorDaemonSet) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorDaemonSet) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorDaemonSet) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorDaemonSet) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorDaemonSet) GetDaemonSets() []*DaemonSet {
	if m != nil {
		return m.DaemonSets
	}
	return nil
}

func (m *CollectorDaemonSet) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorDaemonSet) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorStatefulSet struct {
	ClusterName  string         `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string         `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32          `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32          `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	StatefulSets []*StatefulSet `protobuf:"bytes,5,rep,name=statefulSets,proto3" json:"statefulSets,omitempty"`
	Tags         []string       `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion  `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorStatefulSet) Reset()         { *m = CollectorStatefulSet{} }
func (m *CollectorStatefulSet) String() string { return proto.CompactTextString(m) }
func (*CollectorStatefulSet) ProtoMessage()    {}
func (*CollectorStatefulSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{29}
}
func (m *CollectorStatefulSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorStatefulSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorStatefulSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorStatefulSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorStatefulSet.Merge(m, src)
}
func (m *CollectorStatefulSet) XXX_Size() int {
	return m.Size()
}
func (m *CollectorStatefulSet) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorStatefulSet.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorStatefulSet proto.InternalMessageInfo

func (m *CollectorStatefulSet) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorStatefulSet) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorStatefulSet) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorStatefulSet) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorStatefulSet) GetStatefulSets() []*StatefulSet {
	if m != nil {
		return m.StatefulSets
	}
	return nil
}

func (m *CollectorStatefulSet) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorStatefulSet) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorPersistentVolume struct {
	ClusterName       string              `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId         string              `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId           int32               `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize         int32               `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	PersistentVolumes []*PersistentVolume `protobuf:"bytes,5,rep,name=persistentVolumes,proto3" json:"persistentVolumes,omitempty"`
	Tags              []string            `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion      *AgentVersion       `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorPersistentVolume) Reset()         { *m = CollectorPersistentVolume{} }
func (m *CollectorPersistentVolume) String() string { return proto.CompactTextString(m) }
func (*CollectorPersistentVolume) ProtoMessage()    {}
func (*CollectorPersistentVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{30}
}
func (m *CollectorPersistentVolume) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorPersistentVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorPersistentVolume.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorPersistentVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorPersistentVolume.Merge(m, src)
}
func (m *CollectorPersistentVolume) XXX_Size() int {
	return m.Size()
}
func (m *CollectorPersistentVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorPersistentVolume.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorPersistentVolume proto.InternalMessageInfo

func (m *CollectorPersistentVolume) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorPersistentVolume) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorPersistentVolume) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorPersistentVolume) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorPersistentVolume) GetPersistentVolumes() []*PersistentVolume {
	if m != nil {
		return m.PersistentVolumes
	}
	return nil
}

func (m *CollectorPersistentVolume) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorPersistentVolume) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorPersistentVolumeClaim struct {
	ClusterName            string                   `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId              string                   `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId                int32                    `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize              int32                    `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	PersistentVolumeClaims []*PersistentVolumeClaim `protobuf:"bytes,5,rep,name=persistentVolumeClaims,proto3" json:"persistentVolumeClaims,omitempty"`
	Tags                   []string                 `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion           *AgentVersion            `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorPersistentVolumeClaim) Reset()         { *m = CollectorPersistentVolumeClaim{} }
func (m *CollectorPersistentVolumeClaim) String() string { return proto.CompactTextString(m) }
func (*CollectorPersistentVolumeClaim) ProtoMessage()    {}
func (*CollectorPersistentVolumeClaim) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{31}
}
func (m *CollectorPersistentVolumeClaim) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorPersistentVolumeClaim) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorPersistentVolumeClaim.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorPersistentVolumeClaim) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorPersistentVolumeClaim.Merge(m, src)
}
func (m *CollectorPersistentVolumeClaim) XXX_Size() int {
	return m.Size()
}
func (m *CollectorPersistentVolumeClaim) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorPersistentVolumeClaim.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorPersistentVolumeClaim proto.InternalMessageInfo

func (m *CollectorPersistentVolumeClaim) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorPersistentVolumeClaim) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorPersistentVolumeClaim) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorPersistentVolumeClaim) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorPersistentVolumeClaim) GetPersistentVolumeClaims() []*PersistentVolumeClaim {
	if m != nil {
		return m.PersistentVolumeClaims
	}
	return nil
}

func (m *CollectorPersistentVolumeClaim) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorPersistentVolumeClaim) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorRole struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Roles        []*Role       `protobuf:"bytes,5,rep,name=roles,proto3" json:"roles,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorRole) Reset()         { *m = CollectorRole{} }
func (m *CollectorRole) String() string { return proto.CompactTextString(m) }
func (*CollectorRole) ProtoMessage()    {}
func (*CollectorRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{32}
}
func (m *CollectorRole) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorRole.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorRole.Merge(m, src)
}
func (m *CollectorRole) XXX_Size() int {
	return m.Size()
}
func (m *CollectorRole) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorRole.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorRole proto.InternalMessageInfo

func (m *CollectorRole) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorRole) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorRole) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorRole) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorRole) GetRoles() []*Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *CollectorRole) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorRole) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorRoleBinding struct {
	ClusterName  string         `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string         `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32          `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32          `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	RoleBindings []*RoleBinding `protobuf:"bytes,5,rep,name=roleBindings,proto3" json:"roleBindings,omitempty"`
	Tags         []string       `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion  `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorRoleBinding) Reset()         { *m = CollectorRoleBinding{} }
func (m *CollectorRoleBinding) String() string { return proto.CompactTextString(m) }
func (*CollectorRoleBinding) ProtoMessage()    {}
func (*CollectorRoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{33}
}
func (m *CollectorRoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorRoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorRoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorRoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorRoleBinding.Merge(m, src)
}
func (m *CollectorRoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *CollectorRoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorRoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorRoleBinding proto.InternalMessageInfo

func (m *CollectorRoleBinding) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorRoleBinding) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorRoleBinding) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorRoleBinding) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorRoleBinding) GetRoleBindings() []*RoleBinding {
	if m != nil {
		return m.RoleBindings
	}
	return nil
}

func (m *CollectorRoleBinding) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorRoleBinding) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorClusterRole struct {
	ClusterName  string         `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string         `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32          `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32          `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	ClusterRoles []*ClusterRole `protobuf:"bytes,5,rep,name=clusterRoles,proto3" json:"clusterRoles,omitempty"`
	Tags         []string       `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion  `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorClusterRole) Reset()         { *m = CollectorClusterRole{} }
func (m *CollectorClusterRole) String() string { return proto.CompactTextString(m) }
func (*CollectorClusterRole) ProtoMessage()    {}
func (*CollectorClusterRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{34}
}
func (m *CollectorClusterRole) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorClusterRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorClusterRole.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorClusterRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorClusterRole.Merge(m, src)
}
func (m *CollectorClusterRole) XXX_Size() int {
	return m.Size()
}
func (m *CollectorClusterRole) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorClusterRole.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorClusterRole proto.InternalMessageInfo

func (m *CollectorClusterRole) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorClusterRole) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorClusterRole) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorClusterRole) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorClusterRole) GetClusterRoles() []*ClusterRole {
	if m != nil {
		return m.ClusterRoles
	}
	return nil
}

func (m *CollectorClusterRole) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorClusterRole) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorClusterRoleBinding struct {
	ClusterName         string                `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId           string                `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId             int32                 `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize           int32                 `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	ClusterRoleBindings []*ClusterRoleBinding `protobuf:"bytes,5,rep,name=clusterRoleBindings,proto3" json:"clusterRoleBindings,omitempty"`
	Tags                []string              `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion        *AgentVersion         `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorClusterRoleBinding) Reset()         { *m = CollectorClusterRoleBinding{} }
func (m *CollectorClusterRoleBinding) String() string { return proto.CompactTextString(m) }
func (*CollectorClusterRoleBinding) ProtoMessage()    {}
func (*CollectorClusterRoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{35}
}
func (m *CollectorClusterRoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorClusterRoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorClusterRoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorClusterRoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorClusterRoleBinding.Merge(m, src)
}
func (m *CollectorClusterRoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *CollectorClusterRoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorClusterRoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorClusterRoleBinding proto.InternalMessageInfo

func (m *CollectorClusterRoleBinding) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorClusterRoleBinding) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorClusterRoleBinding) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorClusterRoleBinding) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorClusterRoleBinding) GetClusterRoleBindings() []*ClusterRoleBinding {
	if m != nil {
		return m.ClusterRoleBindings
	}
	return nil
}

func (m *CollectorClusterRoleBinding) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorClusterRoleBinding) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorServiceAccount struct {
	ClusterName     string            `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId       string            `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId         int32             `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize       int32             `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	ServiceAccounts []*ServiceAccount `protobuf:"bytes,5,rep,name=serviceAccounts,proto3" json:"serviceAccounts,omitempty"`
	Tags            []string          `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion    *AgentVersion     `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorServiceAccount) Reset()         { *m = CollectorServiceAccount{} }
func (m *CollectorServiceAccount) String() string { return proto.CompactTextString(m) }
func (*CollectorServiceAccount) ProtoMessage()    {}
func (*CollectorServiceAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{36}
}
func (m *CollectorServiceAccount) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorServiceAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorServiceAccount.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorServiceAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorServiceAccount.Merge(m, src)
}
func (m *CollectorServiceAccount) XXX_Size() int {
	return m.Size()
}
func (m *CollectorServiceAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorServiceAccount.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorServiceAccount proto.InternalMessageInfo

func (m *CollectorServiceAccount) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorServiceAccount) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorServiceAccount) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorServiceAccount) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorServiceAccount) GetServiceAccounts() []*ServiceAccount {
	if m != nil {
		return m.ServiceAccounts
	}
	return nil
}

func (m *CollectorServiceAccount) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorServiceAccount) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorIngress struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	Ingresses    []*Ingress    `protobuf:"bytes,5,rep,name=ingresses,proto3" json:"ingresses,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorIngress) Reset()         { *m = CollectorIngress{} }
func (m *CollectorIngress) String() string { return proto.CompactTextString(m) }
func (*CollectorIngress) ProtoMessage()    {}
func (*CollectorIngress) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{37}
}
func (m *CollectorIngress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorIngress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorIngress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorIngress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorIngress.Merge(m, src)
}
func (m *CollectorIngress) XXX_Size() int {
	return m.Size()
}
func (m *CollectorIngress) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorIngress.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorIngress proto.InternalMessageInfo

func (m *CollectorIngress) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorIngress) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorIngress) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorIngress) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorIngress) GetIngresses() []*Ingress {
	if m != nil {
		return m.Ingresses
	}
	return nil
}

func (m *CollectorIngress) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorIngress) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorVerticalPodAutoscaler struct {
	ClusterName            string                   `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId              string                   `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId                int32                    `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize              int32                    `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	VerticalPodAutoscalers []*VerticalPodAutoscaler `protobuf:"bytes,5,rep,name=verticalPodAutoscalers,proto3" json:"verticalPodAutoscalers,omitempty"`
	Tags                   []string                 `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion           *AgentVersion            `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorVerticalPodAutoscaler) Reset()         { *m = CollectorVerticalPodAutoscaler{} }
func (m *CollectorVerticalPodAutoscaler) String() string { return proto.CompactTextString(m) }
func (*CollectorVerticalPodAutoscaler) ProtoMessage()    {}
func (*CollectorVerticalPodAutoscaler) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{38}
}
func (m *CollectorVerticalPodAutoscaler) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorVerticalPodAutoscaler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorVerticalPodAutoscaler.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorVerticalPodAutoscaler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorVerticalPodAutoscaler.Merge(m, src)
}
func (m *CollectorVerticalPodAutoscaler) XXX_Size() int {
	return m.Size()
}
func (m *CollectorVerticalPodAutoscaler) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorVerticalPodAutoscaler.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorVerticalPodAutoscaler proto.InternalMessageInfo

func (m *CollectorVerticalPodAutoscaler) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorVerticalPodAutoscaler) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorVerticalPodAutoscaler) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorVerticalPodAutoscaler) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorVerticalPodAutoscaler) GetVerticalPodAutoscalers() []*VerticalPodAutoscaler {
	if m != nil {
		return m.VerticalPodAutoscalers
	}
	return nil
}

func (m *CollectorVerticalPodAutoscaler) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorVerticalPodAutoscaler) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorHorizontalPodAutoscaler struct {
	ClusterName              string                     `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId                string                     `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId                  int32                      `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize                int32                      `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	HorizontalPodAutoscalers []*HorizontalPodAutoscaler `protobuf:"bytes,5,rep,name=horizontalPodAutoscalers,proto3" json:"horizontalPodAutoscalers,omitempty"`
	Tags                     []string                   `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion             *AgentVersion              `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorHorizontalPodAutoscaler) Reset()         { *m = CollectorHorizontalPodAutoscaler{} }
func (m *CollectorHorizontalPodAutoscaler) String() string { return proto.CompactTextString(m) }
func (*CollectorHorizontalPodAutoscaler) ProtoMessage()    {}
func (*CollectorHorizontalPodAutoscaler) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{39}
}
func (m *CollectorHorizontalPodAutoscaler) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorHorizontalPodAutoscaler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorHorizontalPodAutoscaler.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorHorizontalPodAutoscaler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorHorizontalPodAutoscaler.Merge(m, src)
}
func (m *CollectorHorizontalPodAutoscaler) XXX_Size() int {
	return m.Size()
}
func (m *CollectorHorizontalPodAutoscaler) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorHorizontalPodAutoscaler.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorHorizontalPodAutoscaler proto.InternalMessageInfo

func (m *CollectorHorizontalPodAutoscaler) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorHorizontalPodAutoscaler) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorHorizontalPodAutoscaler) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorHorizontalPodAutoscaler) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorHorizontalPodAutoscaler) GetHorizontalPodAutoscalers() []*HorizontalPodAutoscaler {
	if m != nil {
		return m.HorizontalPodAutoscalers
	}
	return nil
}

func (m *CollectorHorizontalPodAutoscaler) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorHorizontalPodAutoscaler) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorNetworkPolicy struct {
	ClusterName     string           `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId       string           `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId         int32            `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize       int32            `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	NetworkPolicies []*NetworkPolicy `protobuf:"bytes,5,rep,name=networkPolicies,proto3" json:"networkPolicies,omitempty"`
	Tags            []string         `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion    *AgentVersion    `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorNetworkPolicy) Reset()         { *m = CollectorNetworkPolicy{} }
func (m *CollectorNetworkPolicy) String() string { return proto.CompactTextString(m) }
func (*CollectorNetworkPolicy) ProtoMessage()    {}
func (*CollectorNetworkPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{40}
}
func (m *CollectorNetworkPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorNetworkPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorNetworkPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorNetworkPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorNetworkPolicy.Merge(m, src)
}
func (m *CollectorNetworkPolicy) XXX_Size() int {
	return m.Size()
}
func (m *CollectorNetworkPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorNetworkPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorNetworkPolicy proto.InternalMessageInfo

func (m *CollectorNetworkPolicy) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorNetworkPolicy) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorNetworkPolicy) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorNetworkPolicy) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorNetworkPolicy) GetNetworkPolicies() []*NetworkPolicy {
	if m != nil {
		return m.NetworkPolicies
	}
	return nil
}

func (m *CollectorNetworkPolicy) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorNetworkPolicy) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorLimitRange struct {
	ClusterName  string        `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId    string        `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId      int32         `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize    int32         `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	LimitRanges  []*LimitRange `protobuf:"bytes,5,rep,name=limitRanges,proto3" json:"limitRanges,omitempty"`
	Tags         []string      `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion *AgentVersion `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorLimitRange) Reset()         { *m = CollectorLimitRange{} }
func (m *CollectorLimitRange) String() string { return proto.CompactTextString(m) }
func (*CollectorLimitRange) ProtoMessage()    {}
func (*CollectorLimitRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{41}
}
func (m *CollectorLimitRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorLimitRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorLimitRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorLimitRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorLimitRange.Merge(m, src)
}
func (m *CollectorLimitRange) XXX_Size() int {
	return m.Size()
}
func (m *CollectorLimitRange) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorLimitRange.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorLimitRange proto.InternalMessageInfo

func (m *CollectorLimitRange) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorLimitRange) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorLimitRange) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorLimitRange) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorLimitRange) GetLimitRanges() []*LimitRange {
	if m != nil {
		return m.LimitRanges
	}
	return nil
}

func (m *CollectorLimitRange) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorLimitRange) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type CollectorStorageClass struct {
	ClusterName    string          `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	ClusterId      string          `protobuf:"bytes,2,opt,name=clusterId,proto3" json:"clusterId,omitempty"`
	GroupId        int32           `protobuf:"varint,3,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize      int32           `protobuf:"varint,4,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	StorageClasses []*StorageClass `protobuf:"bytes,5,rep,name=storageClasses,proto3" json:"storageClasses,omitempty"`
	Tags           []string        `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
	AgentVersion   *AgentVersion   `protobuf:"bytes,7,opt,name=agentVersion,proto3" json:"agentVersion,omitempty"`
}

func (m *CollectorStorageClass) Reset()         { *m = CollectorStorageClass{} }
func (m *CollectorStorageClass) String() string { return proto.CompactTextString(m) }
func (*CollectorStorageClass) ProtoMessage()    {}
func (*CollectorStorageClass) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{42}
}
func (m *CollectorStorageClass) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorStorageClass) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorStorageClass.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorStorageClass) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorStorageClass.Merge(m, src)
}
func (m *CollectorStorageClass) XXX_Size() int {
	return m.Size()
}
func (m *CollectorStorageClass) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorStorageClass.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorStorageClass proto.InternalMessageInfo

func (m *CollectorStorageClass) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *CollectorStorageClass) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CollectorStorageClass) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorStorageClass) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorStorageClass) GetStorageClasses() []*StorageClass {
	if m != nil {
		return m.StorageClasses
	}
	return nil
}

func (m *CollectorStorageClass) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CollectorStorageClass) GetAgentVersion() *AgentVersion {
	if m != nil {
		return m.AgentVersion
	}
	return nil
}

type AgentVersion struct {
	Major  int64  `protobuf:"varint,1,opt,name=Major,proto3" json:"Major,omitempty"`
	Minor  int64  `protobuf:"varint,2,opt,name=Minor,proto3" json:"Minor,omitempty"`
	Patch  int64  `protobuf:"varint,3,opt,name=Patch,proto3" json:"Patch,omitempty"`
	Pre    string `protobuf:"bytes,4,opt,name=Pre,proto3" json:"Pre,omitempty"`
	Meta   string `protobuf:"bytes,5,opt,name=Meta,proto3" json:"Meta,omitempty"`
	Commit string `protobuf:"bytes,6,opt,name=Commit,proto3" json:"Commit,omitempty"`
}

func (m *AgentVersion) Reset()         { *m = AgentVersion{} }
func (m *AgentVersion) String() string { return proto.CompactTextString(m) }
func (*AgentVersion) ProtoMessage()    {}
func (*AgentVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{43}
}
func (m *AgentVersion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AgentVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AgentVersion.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AgentVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgentVersion.Merge(m, src)
}
func (m *AgentVersion) XXX_Size() int {
	return m.Size()
}
func (m *AgentVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_AgentVersion.DiscardUnknown(m)
}

var xxx_messageInfo_AgentVersion proto.InternalMessageInfo

func (m *AgentVersion) GetMajor() int64 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *AgentVersion) GetMinor() int64 {
	if m != nil {
		return m.Minor
	}
	return 0
}

func (m *AgentVersion) GetPatch() int64 {
	if m != nil {
		return m.Patch
	}
	return 0
}

func (m *AgentVersion) GetPre() string {
	if m != nil {
		return m.Pre
	}
	return ""
}

func (m *AgentVersion) GetMeta() string {
	if m != nil {
		return m.Meta
	}
	return ""
}

func (m *AgentVersion) GetCommit() string {
	if m != nil {
		return m.Commit
	}
	return ""
}

type CollectorStatus struct {
	ActiveClients int32 `protobuf:"varint,1,opt,name=activeClients,proto3" json:"activeClients,omitempty"`
	Interval      int32 `protobuf:"varint,2,opt,name=interval,proto3" json:"interval,omitempty"`
}

func (m *CollectorStatus) Reset()         { *m = CollectorStatus{} }
func (m *CollectorStatus) String() string { return proto.CompactTextString(m) }
func (*CollectorStatus) ProtoMessage()    {}
func (*CollectorStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{44}
}
func (m *CollectorStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorStatus.Merge(m, src)
}
func (m *CollectorStatus) XXX_Size() int {
	return m.Size()
}
func (m *CollectorStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorStatus.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorStatus proto.InternalMessageInfo

func (m *CollectorStatus) GetActiveClients() int32 {
	if m != nil {
		return m.ActiveClients
	}
	return 0
}

func (m *CollectorStatus) GetInterval() int32 {
	if m != nil {
		return m.Interval
	}
	return 0
}

// Selected fields from TracerMetadata as defined in
// https://github.com/DataDog/libdatadog/blob/99056cf717cfe9/ddcommon/src/tracer_metadata.rs#L7-L29
type TracerMetadata struct {
	RuntimeId   string `protobuf:"bytes,1,opt,name=runtimeId,proto3" json:"runtimeId,omitempty"`
	ServiceName string `protobuf:"bytes,2,opt,name=serviceName,proto3" json:"serviceName,omitempty"`
}

func (m *TracerMetadata) Reset()         { *m = TracerMetadata{} }
func (m *TracerMetadata) String() string { return proto.CompactTextString(m) }
func (*TracerMetadata) ProtoMessage()    {}
func (*TracerMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{45}
}
func (m *TracerMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TracerMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TracerMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TracerMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TracerMetadata.Merge(m, src)
}
func (m *TracerMetadata) XXX_Size() int {
	return m.Size()
}
func (m *TracerMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_TracerMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_TracerMetadata proto.InternalMessageInfo

func (m *TracerMetadata) GetRuntimeId() string {
	if m != nil {
		return m.RuntimeId
	}
	return ""
}

func (m *TracerMetadata) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

type PortInfo struct {
	Tcp []int32 `protobuf:"varint,1,rep,packed,name=tcp,proto3" json:"tcp,omitempty"`
	Udp []int32 `protobuf:"varint,2,rep,packed,name=udp,proto3" json:"udp,omitempty"`
}

func (m *PortInfo) Reset()         { *m = PortInfo{} }
func (m *PortInfo) String() string { return proto.CompactTextString(m) }
func (*PortInfo) ProtoMessage()    {}
func (*PortInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{46}
}
func (m *PortInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortInfo.Merge(m, src)
}
func (m *PortInfo) XXX_Size() int {
	return m.Size()
}
func (m *PortInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PortInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PortInfo proto.InternalMessageInfo

func (m *PortInfo) GetTcp() []int32 {
	if m != nil {
		return m.Tcp
	}
	return nil
}

func (m *PortInfo) GetUdp() []int32 {
	if m != nil {
		return m.Udp
	}
	return nil
}

type Process struct {
	Key                    uint32            `protobuf:"varint,1,opt,name=key,proto3" json:"key,omitempty"`
	Pid                    int32             `protobuf:"varint,2,opt,name=pid,proto3" json:"pid,omitempty"`
	NsPid                  int32             `protobuf:"varint,20,opt,name=nsPid,proto3" json:"nsPid,omitempty"`
	Host                   *Host             `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	Command                *Command          `protobuf:"bytes,4,opt,name=command,proto3" json:"command,omitempty"`
	User                   *ProcessUser      `protobuf:"bytes,5,opt,name=user,proto3" json:"user,omitempty"`
	Memory                 *MemoryStat       `protobuf:"bytes,7,opt,name=memory,proto3" json:"memory,omitempty"`
	Cpu                    *CPUStat          `protobuf:"bytes,8,opt,name=cpu,proto3" json:"cpu,omitempty"`
	CreateTime             int64             `protobuf:"varint,9,opt,name=createTime,proto3" json:"createTime,omitempty"`
	Container              *Container        `protobuf:"bytes,10,opt,name=container,proto3" json:"container,omitempty"`
	OpenFdCount            int32             `protobuf:"varint,11,opt,name=openFdCount,proto3" json:"openFdCount,omitempty"`
	State                  ProcessState      `protobuf:"varint,12,opt,name=state,proto3,enum=datadog.process_agent.ProcessState" json:"state,omitempty"`
	IoStat                 *IOStat           `protobuf:"bytes,13,opt,name=ioStat,proto3" json:"ioStat,omitempty"`
	ContainerId            string            `protobuf:"bytes,14,opt,name=containerId,proto3" json:"containerId,omitempty"`
	ContainerKey           uint32            `protobuf:"varint,15,opt,name=containerKey,proto3" json:"containerKey,omitempty"`
	VoluntaryCtxSwitches   uint64            `protobuf:"varint,16,opt,name=voluntaryCtxSwitches,proto3" json:"voluntaryCtxSwitches,omitempty"`
	InvoluntaryCtxSwitches uint64            `protobuf:"varint,17,opt,name=involuntaryCtxSwitches,proto3" json:"involuntaryCtxSwitches,omitempty"`
	ByteKey                []byte            `protobuf:"bytes,18,opt,name=byteKey,proto3" json:"byteKey,omitempty"`
	ContainerByteKey       []byte            `protobuf:"bytes,19,opt,name=containerByteKey,proto3" json:"containerByteKey,omitempty"`
	Networks               *ProcessNetworks  `protobuf:"bytes,21,opt,name=networks,proto3" json:"networks,omitempty"`
	ProcessContext         []string          `protobuf:"bytes,22,rep,name=processContext,proto3" json:"processContext,omitempty"`
	Tags                   []string          `protobuf:"bytes,23,rep,name=tags,proto3" json:"tags,omitempty"`
	Language               Language          `protobuf:"varint,24,opt,name=language,proto3,enum=datadog.process_agent.Language" json:"language,omitempty"`
	PortInfo               *PortInfo         `protobuf:"bytes,25,opt,name=portInfo,proto3" json:"portInfo,omitempty"`
	ServiceDiscovery       *ServiceDiscovery `protobuf:"bytes,26,opt,name=serviceDiscovery,proto3" json:"serviceDiscovery,omitempty"`
}

func (m *Process) Reset()         { *m = Process{} }
func (m *Process) String() string { return proto.CompactTextString(m) }
func (*Process) ProtoMessage()    {}
func (*Process) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{47}
}
func (m *Process) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Process) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Process.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Process) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Process.Merge(m, src)
}
func (m *Process) XXX_Size() int {
	return m.Size()
}
func (m *Process) XXX_DiscardUnknown() {
	xxx_messageInfo_Process.DiscardUnknown(m)
}

var xxx_messageInfo_Process proto.InternalMessageInfo

func (m *Process) GetKey() uint32 {
	if m != nil {
		return m.Key
	}
	return 0
}

func (m *Process) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *Process) GetNsPid() int32 {
	if m != nil {
		return m.NsPid
	}
	return 0
}

func (m *Process) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *Process) GetCommand() *Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *Process) GetUser() *ProcessUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *Process) GetMemory() *MemoryStat {
	if m != nil {
		return m.Memory
	}
	return nil
}

func (m *Process) GetCpu() *CPUStat {
	if m != nil {
		return m.Cpu
	}
	return nil
}

func (m *Process) GetCreateTime() int64 {
	if m != nil {
		return m.CreateTime
	}
	return 0
}

func (m *Process) GetContainer() *Container {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *Process) GetOpenFdCount() int32 {
	if m != nil {
		return m.OpenFdCount
	}
	return 0
}

func (m *Process) GetState() ProcessState {
	if m != nil {
		return m.State
	}
	return ProcessState_U
}

func (m *Process) GetIoStat() *IOStat {
	if m != nil {
		return m.IoStat
	}
	return nil
}

func (m *Process) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *Process) GetContainerKey() uint32 {
	if m != nil {
		return m.ContainerKey
	}
	return 0
}

func (m *Process) GetVoluntaryCtxSwitches() uint64 {
	if m != nil {
		return m.VoluntaryCtxSwitches
	}
	return 0
}

func (m *Process) GetInvoluntaryCtxSwitches() uint64 {
	if m != nil {
		return m.InvoluntaryCtxSwitches
	}
	return 0
}

func (m *Process) GetByteKey() []byte {
	if m != nil {
		return m.ByteKey
	}
	return nil
}

func (m *Process) GetContainerByteKey() []byte {
	if m != nil {
		return m.ContainerByteKey
	}
	return nil
}

func (m *Process) GetNetworks() *ProcessNetworks {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *Process) GetProcessContext() []string {
	if m != nil {
		return m.ProcessContext
	}
	return nil
}

func (m *Process) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Process) GetLanguage() Language {
	if m != nil {
		return m.Language
	}
	return Language_LANGUAGE_UNKNOWN
}

func (m *Process) GetPortInfo() *PortInfo {
	if m != nil {
		return m.PortInfo
	}
	return nil
}

func (m *Process) GetServiceDiscovery() *ServiceDiscovery {
	if m != nil {
		return m.ServiceDiscovery
	}
	return nil
}

type ServiceDiscovery struct {
	GeneratedServiceName     *ServiceName      `protobuf:"bytes,1,opt,name=generatedServiceName,proto3" json:"generatedServiceName,omitempty"`
	DdServiceName            *ServiceName      `protobuf:"bytes,2,opt,name=ddServiceName,proto3" json:"ddServiceName,omitempty"`
	AdditionalGeneratedNames []*ServiceName    `protobuf:"bytes,3,rep,name=additionalGeneratedNames,proto3" json:"additionalGeneratedNames,omitempty"`
	TracerMetadata           []*TracerMetadata `protobuf:"bytes,4,rep,name=tracerMetadata,proto3" json:"tracerMetadata,omitempty"`
	ApmInstrumentation       bool              `protobuf:"varint,5,opt,name=apmInstrumentation,proto3" json:"apmInstrumentation,omitempty"`
}

func (m *ServiceDiscovery) Reset()         { *m = ServiceDiscovery{} }
func (m *ServiceDiscovery) String() string { return proto.CompactTextString(m) }
func (*ServiceDiscovery) ProtoMessage()    {}
func (*ServiceDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{48}
}
func (m *ServiceDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceDiscovery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceDiscovery.Merge(m, src)
}
func (m *ServiceDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *ServiceDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceDiscovery proto.InternalMessageInfo

func (m *ServiceDiscovery) GetGeneratedServiceName() *ServiceName {
	if m != nil {
		return m.GeneratedServiceName
	}
	return nil
}

func (m *ServiceDiscovery) GetDdServiceName() *ServiceName {
	if m != nil {
		return m.DdServiceName
	}
	return nil
}

func (m *ServiceDiscovery) GetAdditionalGeneratedNames() []*ServiceName {
	if m != nil {
		return m.AdditionalGeneratedNames
	}
	return nil
}

func (m *ServiceDiscovery) GetTracerMetadata() []*TracerMetadata {
	if m != nil {
		return m.TracerMetadata
	}
	return nil
}

func (m *ServiceDiscovery) GetApmInstrumentation() bool {
	if m != nil {
		return m.ApmInstrumentation
	}
	return false
}

type ServiceName struct {
	Name   string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Source ServiceNameSource `protobuf:"varint,2,opt,name=source,proto3,enum=datadog.process_agent.ServiceNameSource" json:"source,omitempty"`
}

func (m *ServiceName) Reset()         { *m = ServiceName{} }
func (m *ServiceName) String() string { return proto.CompactTextString(m) }
func (*ServiceName) ProtoMessage()    {}
func (*ServiceName) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{49}
}
func (m *ServiceName) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceName.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceName.Merge(m, src)
}
func (m *ServiceName) XXX_Size() int {
	return m.Size()
}
func (m *ServiceName) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceName.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceName proto.InternalMessageInfo

func (m *ServiceName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceName) GetSource() ServiceNameSource {
	if m != nil {
		return m.Source
	}
	return ServiceNameSource_SERVICE_NAME_SOURCE_UNKNOWN
}

type ProcessDiscovery struct {
	Pid        int32        `protobuf:"varint,1,opt,name=pid,proto3" json:"pid,omitempty"`
	NsPid      int32        `protobuf:"varint,2,opt,name=nsPid,proto3" json:"nsPid,omitempty"`
	Host       *Host        `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	Command    *Command     `protobuf:"bytes,4,opt,name=command,proto3" json:"command,omitempty"`
	User       *ProcessUser `protobuf:"bytes,5,opt,name=user,proto3" json:"user,omitempty"`
	CreateTime int64        `protobuf:"varint,6,opt,name=createTime,proto3" json:"createTime,omitempty"`
	ByteKey    []byte       `protobuf:"bytes,7,opt,name=byteKey,proto3" json:"byteKey,omitempty"`
}

func (m *ProcessDiscovery) Reset()         { *m = ProcessDiscovery{} }
func (m *ProcessDiscovery) String() string { return proto.CompactTextString(m) }
func (*ProcessDiscovery) ProtoMessage()    {}
func (*ProcessDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{50}
}
func (m *ProcessDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessDiscovery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessDiscovery.Merge(m, src)
}
func (m *ProcessDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *ProcessDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessDiscovery proto.InternalMessageInfo

func (m *ProcessDiscovery) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *ProcessDiscovery) GetNsPid() int32 {
	if m != nil {
		return m.NsPid
	}
	return 0
}

func (m *ProcessDiscovery) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *ProcessDiscovery) GetCommand() *Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ProcessDiscovery) GetUser() *ProcessUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *ProcessDiscovery) GetCreateTime() int64 {
	if m != nil {
		return m.CreateTime
	}
	return 0
}

func (m *ProcessDiscovery) GetByteKey() []byte {
	if m != nil {
		return m.ByteKey
	}
	return nil
}

type Command struct {
	Args   []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	Cwd    string   `protobuf:"bytes,3,opt,name=cwd,proto3" json:"cwd,omitempty"`
	Root   string   `protobuf:"bytes,4,opt,name=root,proto3" json:"root,omitempty"`
	OnDisk bool     `protobuf:"varint,5,opt,name=onDisk,proto3" json:"onDisk,omitempty"`
	Ppid   int32    `protobuf:"varint,6,opt,name=ppid,proto3" json:"ppid,omitempty"`
	Pgroup int32    `protobuf:"varint,7,opt,name=pgroup,proto3" json:"pgroup,omitempty"`
	Exe    string   `protobuf:"bytes,8,opt,name=exe,proto3" json:"exe,omitempty"`
	Comm   string   `protobuf:"bytes,9,opt,name=comm,proto3" json:"comm,omitempty"`
}

func (m *Command) Reset()         { *m = Command{} }
func (m *Command) String() string { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()    {}
func (*Command) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{51}
}
func (m *Command) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Command) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Command.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Command) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Command.Merge(m, src)
}
func (m *Command) XXX_Size() int {
	return m.Size()
}
func (m *Command) XXX_DiscardUnknown() {
	xxx_messageInfo_Command.DiscardUnknown(m)
}

var xxx_messageInfo_Command proto.InternalMessageInfo

func (m *Command) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Command) GetCwd() string {
	if m != nil {
		return m.Cwd
	}
	return ""
}

func (m *Command) GetRoot() string {
	if m != nil {
		return m.Root
	}
	return ""
}

func (m *Command) GetOnDisk() bool {
	if m != nil {
		return m.OnDisk
	}
	return false
}

func (m *Command) GetPpid() int32 {
	if m != nil {
		return m.Ppid
	}
	return 0
}

func (m *Command) GetPgroup() int32 {
	if m != nil {
		return m.Pgroup
	}
	return 0
}

func (m *Command) GetExe() string {
	if m != nil {
		return m.Exe
	}
	return ""
}

func (m *Command) GetComm() string {
	if m != nil {
		return m.Comm
	}
	return ""
}

type ProcessUser struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Uid  int32  `protobuf:"varint,2,opt,name=uid,proto3" json:"uid,omitempty"`
	Gid  int32  `protobuf:"varint,3,opt,name=gid,proto3" json:"gid,omitempty"`
	Euid int32  `protobuf:"varint,4,opt,name=euid,proto3" json:"euid,omitempty"`
	Egid int32  `protobuf:"varint,5,opt,name=egid,proto3" json:"egid,omitempty"`
	Suid int32  `protobuf:"varint,6,opt,name=suid,proto3" json:"suid,omitempty"`
	Sgid int32  `protobuf:"varint,7,opt,name=sgid,proto3" json:"sgid,omitempty"`
}

func (m *ProcessUser) Reset()         { *m = ProcessUser{} }
func (m *ProcessUser) String() string { return proto.CompactTextString(m) }
func (*ProcessUser) ProtoMessage()    {}
func (*ProcessUser) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{52}
}
func (m *ProcessUser) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessUser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessUser.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessUser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessUser.Merge(m, src)
}
func (m *ProcessUser) XXX_Size() int {
	return m.Size()
}
func (m *ProcessUser) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessUser.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessUser proto.InternalMessageInfo

func (m *ProcessUser) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProcessUser) GetUid() int32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *ProcessUser) GetGid() int32 {
	if m != nil {
		return m.Gid
	}
	return 0
}

func (m *ProcessUser) GetEuid() int32 {
	if m != nil {
		return m.Euid
	}
	return 0
}

func (m *ProcessUser) GetEgid() int32 {
	if m != nil {
		return m.Egid
	}
	return 0
}

func (m *ProcessUser) GetSuid() int32 {
	if m != nil {
		return m.Suid
	}
	return 0
}

func (m *ProcessUser) GetSgid() int32 {
	if m != nil {
		return m.Sgid
	}
	return 0
}

// ProcessNetworks is a structure that holds network related metrics for processes
type ProcessNetworks struct {
	ConnectionRate float32 `protobuf:"fixed32,1,opt,name=connectionRate,proto3" json:"connectionRate,omitempty"`
	BytesRate      float32 `protobuf:"fixed32,2,opt,name=bytesRate,proto3" json:"bytesRate,omitempty"`
}

func (m *ProcessNetworks) Reset()         { *m = ProcessNetworks{} }
func (m *ProcessNetworks) String() string { return proto.CompactTextString(m) }
func (*ProcessNetworks) ProtoMessage()    {}
func (*ProcessNetworks) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{53}
}
func (m *ProcessNetworks) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessNetworks) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessNetworks.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessNetworks) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessNetworks.Merge(m, src)
}
func (m *ProcessNetworks) XXX_Size() int {
	return m.Size()
}
func (m *ProcessNetworks) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessNetworks.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessNetworks proto.InternalMessageInfo

func (m *ProcessNetworks) GetConnectionRate() float32 {
	if m != nil {
		return m.ConnectionRate
	}
	return 0
}

func (m *ProcessNetworks) GetBytesRate() float32 {
	if m != nil {
		return m.BytesRate
	}
	return 0
}

// ContainerAddr records the IPs, Ports and Protocols for each container
type ContainerAddr struct {
	Ip       string         `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	Port     int32          `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	Protocol ConnectionType `protobuf:"varint,3,opt,name=protocol,proto3,enum=datadog.process_agent.ConnectionType" json:"protocol,omitempty"`
}

func (m *ContainerAddr) Reset()         { *m = ContainerAddr{} }
func (m *ContainerAddr) String() string { return proto.CompactTextString(m) }
func (*ContainerAddr) ProtoMessage()    {}
func (*ContainerAddr) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{54}
}
func (m *ContainerAddr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerAddr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerAddr.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerAddr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerAddr.Merge(m, src)
}
func (m *ContainerAddr) XXX_Size() int {
	return m.Size()
}
func (m *ContainerAddr) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerAddr.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerAddr proto.InternalMessageInfo

func (m *ContainerAddr) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *ContainerAddr) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *ContainerAddr) GetProtocol() ConnectionType {
	if m != nil {
		return m.Protocol
	}
	return ConnectionType_tcp
}

type Container struct {
	Type          string           `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Id            string           `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Name          string           `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Image         string           `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	CpuLimit      float32          `protobuf:"fixed32,5,opt,name=cpuLimit,proto3" json:"cpuLimit,omitempty"`
	MemoryLimit   uint64           `protobuf:"varint,6,opt,name=memoryLimit,proto3" json:"memoryLimit,omitempty"`
	State         ContainerState   `protobuf:"varint,8,opt,name=state,proto3,enum=datadog.process_agent.ContainerState" json:"state,omitempty"`
	Health        ContainerHealth  `protobuf:"varint,9,opt,name=health,proto3,enum=datadog.process_agent.ContainerHealth" json:"health,omitempty"`
	Created       int64            `protobuf:"varint,10,opt,name=created,proto3" json:"created,omitempty"`
	Rbps          float32          `protobuf:"fixed32,11,opt,name=rbps,proto3" json:"rbps,omitempty"`
	Wbps          float32          `protobuf:"fixed32,12,opt,name=wbps,proto3" json:"wbps,omitempty"`
	Key           uint32           `protobuf:"varint,13,opt,name=key,proto3" json:"key,omitempty"`
	NetRcvdPs     float32          `protobuf:"fixed32,14,opt,name=netRcvdPs,proto3" json:"netRcvdPs,omitempty"`
	NetSentPs     float32          `protobuf:"fixed32,15,opt,name=netSentPs,proto3" json:"netSentPs,omitempty"`
	NetRcvdBps    float32          `protobuf:"fixed32,16,opt,name=netRcvdBps,proto3" json:"netRcvdBps,omitempty"`
	NetSentBps    float32          `protobuf:"fixed32,17,opt,name=netSentBps,proto3" json:"netSentBps,omitempty"`
	UserPct       float32          `protobuf:"fixed32,18,opt,name=userPct,proto3" json:"userPct,omitempty"`
	SystemPct     float32          `protobuf:"fixed32,19,opt,name=systemPct,proto3" json:"systemPct,omitempty"`
	TotalPct      float32          `protobuf:"fixed32,20,opt,name=totalPct,proto3" json:"totalPct,omitempty"`
	MemRss        uint64           `protobuf:"varint,21,opt,name=memRss,proto3" json:"memRss,omitempty"`
	MemCache      uint64           `protobuf:"varint,22,opt,name=memCache,proto3" json:"memCache,omitempty"`
	Host          *Host            `protobuf:"bytes,23,opt,name=host,proto3" json:"host,omitempty"`
	Started       int64            `protobuf:"varint,24,opt,name=started,proto3" json:"started,omitempty"`
	ByteKey       []byte           `protobuf:"bytes,25,opt,name=byteKey,proto3" json:"byteKey,omitempty"`
	Tags          []string         `protobuf:"bytes,26,rep,name=tags,proto3" json:"tags,omitempty"`
	Addresses     []*ContainerAddr `protobuf:"bytes,27,rep,name=addresses,proto3" json:"addresses,omitempty"`
	ThreadCount   uint64           `protobuf:"varint,28,opt,name=threadCount,proto3" json:"threadCount,omitempty"`
	ThreadLimit   uint64           `protobuf:"varint,29,opt,name=threadLimit,proto3" json:"threadLimit,omitempty"`
	MemUsage      uint64           `protobuf:"varint,30,opt,name=memUsage,proto3" json:"memUsage,omitempty"`
	CpuUsageNs    float32          `protobuf:"fixed32,31,opt,name=cpuUsageNs,proto3" json:"cpuUsageNs,omitempty"`
	MemAccounted  uint64           `protobuf:"varint,32,opt,name=memAccounted,proto3" json:"memAccounted,omitempty"`
	CpuRequest    float32          `protobuf:"fixed32,33,opt,name=cpuRequest,proto3" json:"cpuRequest,omitempty"`
	MemoryRequest uint64           `protobuf:"varint,34,opt,name=memoryRequest,proto3" json:"memoryRequest,omitempty"`
	RepoDigest    string           `protobuf:"bytes,35,opt,name=repoDigest,proto3" json:"repoDigest,omitempty"`
}

func (m *Container) Reset()         { *m = Container{} }
func (m *Container) String() string { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()    {}
func (*Container) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{55}
}
func (m *Container) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Container) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Container.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Container) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Container.Merge(m, src)
}
func (m *Container) XXX_Size() int {
	return m.Size()
}
func (m *Container) XXX_DiscardUnknown() {
	xxx_messageInfo_Container.DiscardUnknown(m)
}

var xxx_messageInfo_Container proto.InternalMessageInfo

func (m *Container) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Container) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Container) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Container) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *Container) GetCpuLimit() float32 {
	if m != nil {
		return m.CpuLimit
	}
	return 0
}

func (m *Container) GetMemoryLimit() uint64 {
	if m != nil {
		return m.MemoryLimit
	}
	return 0
}

func (m *Container) GetState() ContainerState {
	if m != nil {
		return m.State
	}
	return ContainerState_unknown
}

func (m *Container) GetHealth() ContainerHealth {
	if m != nil {
		return m.Health
	}
	return ContainerHealth_unknownHealth
}

func (m *Container) GetCreated() int64 {
	if m != nil {
		return m.Created
	}
	return 0
}

func (m *Container) GetRbps() float32 {
	if m != nil {
		return m.Rbps
	}
	return 0
}

func (m *Container) GetWbps() float32 {
	if m != nil {
		return m.Wbps
	}
	return 0
}

func (m *Container) GetKey() uint32 {
	if m != nil {
		return m.Key
	}
	return 0
}

func (m *Container) GetNetRcvdPs() float32 {
	if m != nil {
		return m.NetRcvdPs
	}
	return 0
}

func (m *Container) GetNetSentPs() float32 {
	if m != nil {
		return m.NetSentPs
	}
	return 0
}

func (m *Container) GetNetRcvdBps() float32 {
	if m != nil {
		return m.NetRcvdBps
	}
	return 0
}

func (m *Container) GetNetSentBps() float32 {
	if m != nil {
		return m.NetSentBps
	}
	return 0
}

func (m *Container) GetUserPct() float32 {
	if m != nil {
		return m.UserPct
	}
	return 0
}

func (m *Container) GetSystemPct() float32 {
	if m != nil {
		return m.SystemPct
	}
	return 0
}

func (m *Container) GetTotalPct() float32 {
	if m != nil {
		return m.TotalPct
	}
	return 0
}

func (m *Container) GetMemRss() uint64 {
	if m != nil {
		return m.MemRss
	}
	return 0
}

func (m *Container) GetMemCache() uint64 {
	if m != nil {
		return m.MemCache
	}
	return 0
}

func (m *Container) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *Container) GetStarted() int64 {
	if m != nil {
		return m.Started
	}
	return 0
}

func (m *Container) GetByteKey() []byte {
	if m != nil {
		return m.ByteKey
	}
	return nil
}

func (m *Container) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Container) GetAddresses() []*ContainerAddr {
	if m != nil {
		return m.Addresses
	}
	return nil
}

func (m *Container) GetThreadCount() uint64 {
	if m != nil {
		return m.ThreadCount
	}
	return 0
}

func (m *Container) GetThreadLimit() uint64 {
	if m != nil {
		return m.ThreadLimit
	}
	return 0
}

func (m *Container) GetMemUsage() uint64 {
	if m != nil {
		return m.MemUsage
	}
	return 0
}

func (m *Container) GetCpuUsageNs() float32 {
	if m != nil {
		return m.CpuUsageNs
	}
	return 0
}

func (m *Container) GetMemAccounted() uint64 {
	if m != nil {
		return m.MemAccounted
	}
	return 0
}

func (m *Container) GetCpuRequest() float32 {
	if m != nil {
		return m.CpuRequest
	}
	return 0
}

func (m *Container) GetMemoryRequest() uint64 {
	if m != nil {
		return m.MemoryRequest
	}
	return 0
}

func (m *Container) GetRepoDigest() string {
	if m != nil {
		return m.RepoDigest
	}
	return ""
}

// ProcessStat is used for real-time process messages. It should only contain
// data that can change for a running process (and relevant information to
// generate a key). We will send a lot of these in the real-time messages so
// it's critical to keep this small.
type ProcessStat struct {
	Pid int32 `protobuf:"varint,1,opt,name=pid,proto3" json:"pid,omitempty"`
	// In milliseconds
	CreateTime  int64       `protobuf:"varint,2,opt,name=createTime,proto3" json:"createTime,omitempty"`
	Memory      *MemoryStat `protobuf:"bytes,3,opt,name=memory,proto3" json:"memory,omitempty"`
	Cpu         *CPUStat    `protobuf:"bytes,4,opt,name=cpu,proto3" json:"cpu,omitempty"`
	Nice        int32       `protobuf:"varint,5,opt,name=nice,proto3" json:"nice,omitempty"`
	Threads     int32       `protobuf:"varint,7,opt,name=threads,proto3" json:"threads,omitempty"`
	OpenFdCount int32       `protobuf:"varint,8,opt,name=openFdCount,proto3" json:"openFdCount,omitempty"`
	Key         uint32      `protobuf:"varint,9,opt,name=key,proto3" json:"key,omitempty"`
	// we need container id because we need to do the scoring by container
	ContainerId    string           `protobuf:"bytes,10,opt,name=containerId,proto3" json:"containerId,omitempty"`
	ContainerState ContainerState   `protobuf:"varint,11,opt,name=containerState,proto3,enum=datadog.process_agent.ContainerState" json:"containerState,omitempty"`
	ProcessState   ProcessState     `protobuf:"varint,12,opt,name=processState,proto3,enum=datadog.process_agent.ProcessState" json:"processState,omitempty"`
	IoStat         *IOStat          `protobuf:"bytes,19,opt,name=ioStat,proto3" json:"ioStat,omitempty"`
	Networks       *ProcessNetworks `protobuf:"bytes,28,opt,name=networks,proto3" json:"networks,omitempty"`
	// DEPRECATED: All container-level stats (except ID) have moved into ContainerStat.
	// These will be removed in the future.
	// These stats are from the container level but are stored per-process
	// because we don't send a container primitive yet.
	ContainerHealth        ContainerHealth `protobuf:"varint,15,opt,name=containerHealth,proto3,enum=datadog.process_agent.ContainerHealth" json:"containerHealth,omitempty"`
	ContainerRbps          float32         `protobuf:"fixed32,16,opt,name=containerRbps,proto3" json:"containerRbps,omitempty"`
	ContainerWbps          float32         `protobuf:"fixed32,17,opt,name=containerWbps,proto3" json:"containerWbps,omitempty"`
	ContainerKey           uint32          `protobuf:"varint,18,opt,name=containerKey,proto3" json:"containerKey,omitempty"`
	ContainerNetRcvdPs     float32         `protobuf:"fixed32,20,opt,name=containerNetRcvdPs,proto3" json:"containerNetRcvdPs,omitempty"`
	ContainerNetSentPs     float32         `protobuf:"fixed32,21,opt,name=containerNetSentPs,proto3" json:"containerNetSentPs,omitempty"`
	ContainerNetRcvdBps    float32         `protobuf:"fixed32,22,opt,name=containerNetRcvdBps,proto3" json:"containerNetRcvdBps,omitempty"`
	ContainerNetSentBps    float32         `protobuf:"fixed32,23,opt,name=containerNetSentBps,proto3" json:"containerNetSentBps,omitempty"`
	VoluntaryCtxSwitches   uint64          `protobuf:"varint,24,opt,name=voluntaryCtxSwitches,proto3" json:"voluntaryCtxSwitches,omitempty"`
	InvoluntaryCtxSwitches uint64          `protobuf:"varint,25,opt,name=involuntaryCtxSwitches,proto3" json:"involuntaryCtxSwitches,omitempty"`
	ByteKey                []byte          `protobuf:"bytes,26,opt,name=byteKey,proto3" json:"byteKey,omitempty"`
	ContainerByteKey       []byte          `protobuf:"bytes,27,opt,name=containerByteKey,proto3" json:"containerByteKey,omitempty"`
}

func (m *ProcessStat) Reset()         { *m = ProcessStat{} }
func (m *ProcessStat) String() string { return proto.CompactTextString(m) }
func (*ProcessStat) ProtoMessage()    {}
func (*ProcessStat) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{56}
}
func (m *ProcessStat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessStat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessStat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessStat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessStat.Merge(m, src)
}
func (m *ProcessStat) XXX_Size() int {
	return m.Size()
}
func (m *ProcessStat) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessStat.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessStat proto.InternalMessageInfo

func (m *ProcessStat) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *ProcessStat) GetCreateTime() int64 {
	if m != nil {
		return m.CreateTime
	}
	return 0
}

func (m *ProcessStat) GetMemory() *MemoryStat {
	if m != nil {
		return m.Memory
	}
	return nil
}

func (m *ProcessStat) GetCpu() *CPUStat {
	if m != nil {
		return m.Cpu
	}
	return nil
}

func (m *ProcessStat) GetNice() int32 {
	if m != nil {
		return m.Nice
	}
	return 0
}

func (m *ProcessStat) GetThreads() int32 {
	if m != nil {
		return m.Threads
	}
	return 0
}

func (m *ProcessStat) GetOpenFdCount() int32 {
	if m != nil {
		return m.OpenFdCount
	}
	return 0
}

func (m *ProcessStat) GetKey() uint32 {
	if m != nil {
		return m.Key
	}
	return 0
}

func (m *ProcessStat) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ProcessStat) GetContainerState() ContainerState {
	if m != nil {
		return m.ContainerState
	}
	return ContainerState_unknown
}

func (m *ProcessStat) GetProcessState() ProcessState {
	if m != nil {
		return m.ProcessState
	}
	return ProcessState_U
}

func (m *ProcessStat) GetIoStat() *IOStat {
	if m != nil {
		return m.IoStat
	}
	return nil
}

func (m *ProcessStat) GetNetworks() *ProcessNetworks {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *ProcessStat) GetContainerHealth() ContainerHealth {
	if m != nil {
		return m.ContainerHealth
	}
	return ContainerHealth_unknownHealth
}

func (m *ProcessStat) GetContainerRbps() float32 {
	if m != nil {
		return m.ContainerRbps
	}
	return 0
}

func (m *ProcessStat) GetContainerWbps() float32 {
	if m != nil {
		return m.ContainerWbps
	}
	return 0
}

func (m *ProcessStat) GetContainerKey() uint32 {
	if m != nil {
		return m.ContainerKey
	}
	return 0
}

func (m *ProcessStat) GetContainerNetRcvdPs() float32 {
	if m != nil {
		return m.ContainerNetRcvdPs
	}
	return 0
}

func (m *ProcessStat) GetContainerNetSentPs() float32 {
	if m != nil {
		return m.ContainerNetSentPs
	}
	return 0
}

func (m *ProcessStat) GetContainerNetRcvdBps() float32 {
	if m != nil {
		return m.ContainerNetRcvdBps
	}
	return 0
}

func (m *ProcessStat) GetContainerNetSentBps() float32 {
	if m != nil {
		return m.ContainerNetSentBps
	}
	return 0
}

func (m *ProcessStat) GetVoluntaryCtxSwitches() uint64 {
	if m != nil {
		return m.VoluntaryCtxSwitches
	}
	return 0
}

func (m *ProcessStat) GetInvoluntaryCtxSwitches() uint64 {
	if m != nil {
		return m.InvoluntaryCtxSwitches
	}
	return 0
}

func (m *ProcessStat) GetByteKey() []byte {
	if m != nil {
		return m.ByteKey
	}
	return nil
}

func (m *ProcessStat) GetContainerByteKey() []byte {
	if m != nil {
		return m.ContainerByteKey
	}
	return nil
}

// ProcStatsWithPerm is holding attributes for processes that requires extra permission to collect.
// It is used to pass data between system-probe and process-agent
type ProcStatsWithPerm struct {
	OpenFDCount int32 `protobuf:"varint,1,opt,name=openFDCount,proto3" json:"openFDCount,omitempty"`
	ReadCount   int64 `protobuf:"varint,2,opt,name=readCount,proto3" json:"readCount,omitempty"`
	WriteCount  int64 `protobuf:"varint,3,opt,name=writeCount,proto3" json:"writeCount,omitempty"`
	ReadBytes   int64 `protobuf:"varint,4,opt,name=readBytes,proto3" json:"readBytes,omitempty"`
	WriteBytes  int64 `protobuf:"varint,5,opt,name=writeBytes,proto3" json:"writeBytes,omitempty"`
}

func (m *ProcStatsWithPerm) Reset()         { *m = ProcStatsWithPerm{} }
func (m *ProcStatsWithPerm) String() string { return proto.CompactTextString(m) }
func (*ProcStatsWithPerm) ProtoMessage()    {}
func (*ProcStatsWithPerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{57}
}
func (m *ProcStatsWithPerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcStatsWithPerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcStatsWithPerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcStatsWithPerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcStatsWithPerm.Merge(m, src)
}
func (m *ProcStatsWithPerm) XXX_Size() int {
	return m.Size()
}
func (m *ProcStatsWithPerm) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcStatsWithPerm.DiscardUnknown(m)
}

var xxx_messageInfo_ProcStatsWithPerm proto.InternalMessageInfo

func (m *ProcStatsWithPerm) GetOpenFDCount() int32 {
	if m != nil {
		return m.OpenFDCount
	}
	return 0
}

func (m *ProcStatsWithPerm) GetReadCount() int64 {
	if m != nil {
		return m.ReadCount
	}
	return 0
}

func (m *ProcStatsWithPerm) GetWriteCount() int64 {
	if m != nil {
		return m.WriteCount
	}
	return 0
}

func (m *ProcStatsWithPerm) GetReadBytes() int64 {
	if m != nil {
		return m.ReadBytes
	}
	return 0
}

func (m *ProcStatsWithPerm) GetWriteBytes() int64 {
	if m != nil {
		return m.WriteBytes
	}
	return 0
}

// ProcStatsWithPermByPID stores ProcStatsWithPerm in a map with key as PIDs
type ProcStatsWithPermByPID struct {
	StatsByPID map[int32]*ProcStatsWithPerm `protobuf:"bytes,1,rep,name=statsByPID,proto3" json:"statsByPID,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *ProcStatsWithPermByPID) Reset()         { *m = ProcStatsWithPermByPID{} }
func (m *ProcStatsWithPermByPID) String() string { return proto.CompactTextString(m) }
func (*ProcStatsWithPermByPID) ProtoMessage()    {}
func (*ProcStatsWithPermByPID) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{58}
}
func (m *ProcStatsWithPermByPID) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcStatsWithPermByPID) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcStatsWithPermByPID.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcStatsWithPermByPID) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcStatsWithPermByPID.Merge(m, src)
}
func (m *ProcStatsWithPermByPID) XXX_Size() int {
	return m.Size()
}
func (m *ProcStatsWithPermByPID) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcStatsWithPermByPID.DiscardUnknown(m)
}

var xxx_messageInfo_ProcStatsWithPermByPID proto.InternalMessageInfo

func (m *ProcStatsWithPermByPID) GetStatsByPID() map[int32]*ProcStatsWithPerm {
	if m != nil {
		return m.StatsByPID
	}
	return nil
}

// ContainerStat is used for real-time container messages. It should only contain
// data that can change for a running container (and relevant information to
// generate a key). We will send a lot of these in the real-time messages so
// it's critical to keep this small (basically no strings except ID)
type ContainerStat struct {
	Id         string          `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	UserPct    float32         `protobuf:"fixed32,2,opt,name=userPct,proto3" json:"userPct,omitempty"`
	SystemPct  float32         `protobuf:"fixed32,3,opt,name=systemPct,proto3" json:"systemPct,omitempty"`
	TotalPct   float32         `protobuf:"fixed32,4,opt,name=totalPct,proto3" json:"totalPct,omitempty"`
	CpuLimit   float32         `protobuf:"fixed32,5,opt,name=cpuLimit,proto3" json:"cpuLimit,omitempty"`
	MemRss     uint64          `protobuf:"varint,6,opt,name=memRss,proto3" json:"memRss,omitempty"`
	MemCache   uint64          `protobuf:"varint,7,opt,name=memCache,proto3" json:"memCache,omitempty"`
	MemLimit   uint64          `protobuf:"varint,8,opt,name=memLimit,proto3" json:"memLimit,omitempty"`
	Rbps       float32         `protobuf:"fixed32,9,opt,name=rbps,proto3" json:"rbps,omitempty"`
	Wbps       float32         `protobuf:"fixed32,10,opt,name=wbps,proto3" json:"wbps,omitempty"`
	NetRcvdPs  float32         `protobuf:"fixed32,11,opt,name=netRcvdPs,proto3" json:"netRcvdPs,omitempty"`
	NetSentPs  float32         `protobuf:"fixed32,12,opt,name=netSentPs,proto3" json:"netSentPs,omitempty"`
	NetRcvdBps float32         `protobuf:"fixed32,13,opt,name=netRcvdBps,proto3" json:"netRcvdBps,omitempty"`
	NetSentBps float32         `protobuf:"fixed32,14,opt,name=netSentBps,proto3" json:"netSentBps,omitempty"`
	State      ContainerState  `protobuf:"varint,15,opt,name=state,proto3,enum=datadog.process_agent.ContainerState" json:"state,omitempty"`
	Health     ContainerHealth `protobuf:"varint,16,opt,name=health,proto3,enum=datadog.process_agent.ContainerHealth" json:"health,omitempty"`
	// Post-resolved fields
	Key           uint32  `protobuf:"varint,17,opt,name=key,proto3" json:"key,omitempty"`
	Started       int64   `protobuf:"varint,18,opt,name=started,proto3" json:"started,omitempty"`
	ByteKey       []byte  `protobuf:"bytes,19,opt,name=byteKey,proto3" json:"byteKey,omitempty"`
	ThreadCount   uint64  `protobuf:"varint,20,opt,name=threadCount,proto3" json:"threadCount,omitempty"`
	ThreadLimit   uint64  `protobuf:"varint,21,opt,name=threadLimit,proto3" json:"threadLimit,omitempty"`
	MemUsage      uint64  `protobuf:"varint,22,opt,name=memUsage,proto3" json:"memUsage,omitempty"`
	CpuUsageNs    float32 `protobuf:"fixed32,23,opt,name=cpuUsageNs,proto3" json:"cpuUsageNs,omitempty"`
	MemAccounted  uint64  `protobuf:"varint,24,opt,name=memAccounted,proto3" json:"memAccounted,omitempty"`
	CpuRequest    float32 `protobuf:"fixed32,25,opt,name=cpuRequest,proto3" json:"cpuRequest,omitempty"`
	MemoryRequest uint64  `protobuf:"varint,26,opt,name=memoryRequest,proto3" json:"memoryRequest,omitempty"`
}

func (m *ContainerStat) Reset()         { *m = ContainerStat{} }
func (m *ContainerStat) String() string { return proto.CompactTextString(m) }
func (*ContainerStat) ProtoMessage()    {}
func (*ContainerStat) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{59}
}
func (m *ContainerStat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStat.Merge(m, src)
}
func (m *ContainerStat) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStat) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStat.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStat proto.InternalMessageInfo

func (m *ContainerStat) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ContainerStat) GetUserPct() float32 {
	if m != nil {
		return m.UserPct
	}
	return 0
}

func (m *ContainerStat) GetSystemPct() float32 {
	if m != nil {
		return m.SystemPct
	}
	return 0
}

func (m *ContainerStat) GetTotalPct() float32 {
	if m != nil {
		return m.TotalPct
	}
	return 0
}

func (m *ContainerStat) GetCpuLimit() float32 {
	if m != nil {
		return m.CpuLimit
	}
	return 0
}

func (m *ContainerStat) GetMemRss() uint64 {
	if m != nil {
		return m.MemRss
	}
	return 0
}

func (m *ContainerStat) GetMemCache() uint64 {
	if m != nil {
		return m.MemCache
	}
	return 0
}

func (m *ContainerStat) GetMemLimit() uint64 {
	if m != nil {
		return m.MemLimit
	}
	return 0
}

func (m *ContainerStat) GetRbps() float32 {
	if m != nil {
		return m.Rbps
	}
	return 0
}

func (m *ContainerStat) GetWbps() float32 {
	if m != nil {
		return m.Wbps
	}
	return 0
}

func (m *ContainerStat) GetNetRcvdPs() float32 {
	if m != nil {
		return m.NetRcvdPs
	}
	return 0
}

func (m *ContainerStat) GetNetSentPs() float32 {
	if m != nil {
		return m.NetSentPs
	}
	return 0
}

func (m *ContainerStat) GetNetRcvdBps() float32 {
	if m != nil {
		return m.NetRcvdBps
	}
	return 0
}

func (m *ContainerStat) GetNetSentBps() float32 {
	if m != nil {
		return m.NetSentBps
	}
	return 0
}

func (m *ContainerStat) GetState() ContainerState {
	if m != nil {
		return m.State
	}
	return ContainerState_unknown
}

func (m *ContainerStat) GetHealth() ContainerHealth {
	if m != nil {
		return m.Health
	}
	return ContainerHealth_unknownHealth
}

func (m *ContainerStat) GetKey() uint32 {
	if m != nil {
		return m.Key
	}
	return 0
}

func (m *ContainerStat) GetStarted() int64 {
	if m != nil {
		return m.Started
	}
	return 0
}

func (m *ContainerStat) GetByteKey() []byte {
	if m != nil {
		return m.ByteKey
	}
	return nil
}

func (m *ContainerStat) GetThreadCount() uint64 {
	if m != nil {
		return m.ThreadCount
	}
	return 0
}

func (m *ContainerStat) GetThreadLimit() uint64 {
	if m != nil {
		return m.ThreadLimit
	}
	return 0
}

func (m *ContainerStat) GetMemUsage() uint64 {
	if m != nil {
		return m.MemUsage
	}
	return 0
}

func (m *ContainerStat) GetCpuUsageNs() float32 {
	if m != nil {
		return m.CpuUsageNs
	}
	return 0
}

func (m *ContainerStat) GetMemAccounted() uint64 {
	if m != nil {
		return m.MemAccounted
	}
	return 0
}

func (m *ContainerStat) GetCpuRequest() float32 {
	if m != nil {
		return m.CpuRequest
	}
	return 0
}

func (m *ContainerStat) GetMemoryRequest() uint64 {
	if m != nil {
		return m.MemoryRequest
	}
	return 0
}

type SystemInfo struct {
	Uuid        string     `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	Os          *OSInfo    `protobuf:"bytes,2,opt,name=os,proto3" json:"os,omitempty"`
	Cpus        []*CPUInfo `protobuf:"bytes,3,rep,name=cpus,proto3" json:"cpus,omitempty"`
	TotalMemory int64      `protobuf:"varint,5,opt,name=totalMemory,proto3" json:"totalMemory,omitempty"`
}

func (m *SystemInfo) Reset()         { *m = SystemInfo{} }
func (m *SystemInfo) String() string { return proto.CompactTextString(m) }
func (*SystemInfo) ProtoMessage()    {}
func (*SystemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{60}
}
func (m *SystemInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SystemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SystemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemInfo.Merge(m, src)
}
func (m *SystemInfo) XXX_Size() int {
	return m.Size()
}
func (m *SystemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SystemInfo proto.InternalMessageInfo

func (m *SystemInfo) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *SystemInfo) GetOs() *OSInfo {
	if m != nil {
		return m.Os
	}
	return nil
}

func (m *SystemInfo) GetCpus() []*CPUInfo {
	if m != nil {
		return m.Cpus
	}
	return nil
}

func (m *SystemInfo) GetTotalMemory() int64 {
	if m != nil {
		return m.TotalMemory
	}
	return 0
}

type OSInfo struct {
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Platform      string `protobuf:"bytes,2,opt,name=platform,proto3" json:"platform,omitempty"`
	Family        string `protobuf:"bytes,3,opt,name=family,proto3" json:"family,omitempty"`
	Version       string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	KernelVersion string `protobuf:"bytes,5,opt,name=kernelVersion,proto3" json:"kernelVersion,omitempty"`
}

func (m *OSInfo) Reset()         { *m = OSInfo{} }
func (m *OSInfo) String() string { return proto.CompactTextString(m) }
func (*OSInfo) ProtoMessage()    {}
func (*OSInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{61}
}
func (m *OSInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OSInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OSInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OSInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OSInfo.Merge(m, src)
}
func (m *OSInfo) XXX_Size() int {
	return m.Size()
}
func (m *OSInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_OSInfo.DiscardUnknown(m)
}

var xxx_messageInfo_OSInfo proto.InternalMessageInfo

func (m *OSInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OSInfo) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *OSInfo) GetFamily() string {
	if m != nil {
		return m.Family
	}
	return ""
}

func (m *OSInfo) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *OSInfo) GetKernelVersion() string {
	if m != nil {
		return m.KernelVersion
	}
	return ""
}

type IOStat struct {
	ReadRate       float32 `protobuf:"fixed32,1,opt,name=readRate,proto3" json:"readRate,omitempty"`
	WriteRate      float32 `protobuf:"fixed32,2,opt,name=writeRate,proto3" json:"writeRate,omitempty"`
	ReadBytesRate  float32 `protobuf:"fixed32,3,opt,name=readBytesRate,proto3" json:"readBytesRate,omitempty"`
	WriteBytesRate float32 `protobuf:"fixed32,4,opt,name=writeBytesRate,proto3" json:"writeBytesRate,omitempty"`
}

func (m *IOStat) Reset()         { *m = IOStat{} }
func (m *IOStat) String() string { return proto.CompactTextString(m) }
func (*IOStat) ProtoMessage()    {}
func (*IOStat) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{62}
}
func (m *IOStat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IOStat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IOStat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IOStat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IOStat.Merge(m, src)
}
func (m *IOStat) XXX_Size() int {
	return m.Size()
}
func (m *IOStat) XXX_DiscardUnknown() {
	xxx_messageInfo_IOStat.DiscardUnknown(m)
}

var xxx_messageInfo_IOStat proto.InternalMessageInfo

func (m *IOStat) GetReadRate() float32 {
	if m != nil {
		return m.ReadRate
	}
	return 0
}

func (m *IOStat) GetWriteRate() float32 {
	if m != nil {
		return m.WriteRate
	}
	return 0
}

func (m *IOStat) GetReadBytesRate() float32 {
	if m != nil {
		return m.ReadBytesRate
	}
	return 0
}

func (m *IOStat) GetWriteBytesRate() float32 {
	if m != nil {
		return m.WriteBytesRate
	}
	return 0
}

type MemoryStat struct {
	Rss    uint64 `protobuf:"varint,1,opt,name=rss,proto3" json:"rss,omitempty"`
	Vms    uint64 `protobuf:"varint,2,opt,name=vms,proto3" json:"vms,omitempty"`
	Swap   uint64 `protobuf:"varint,3,opt,name=swap,proto3" json:"swap,omitempty"`
	Shared uint64 `protobuf:"varint,4,opt,name=shared,proto3" json:"shared,omitempty"`
	Text   uint64 `protobuf:"varint,5,opt,name=text,proto3" json:"text,omitempty"`
	Lib    uint64 `protobuf:"varint,6,opt,name=lib,proto3" json:"lib,omitempty"`
	Data   uint64 `protobuf:"varint,7,opt,name=data,proto3" json:"data,omitempty"`
	Dirty  uint64 `protobuf:"varint,8,opt,name=dirty,proto3" json:"dirty,omitempty"`
}

func (m *MemoryStat) Reset()         { *m = MemoryStat{} }
func (m *MemoryStat) String() string { return proto.CompactTextString(m) }
func (*MemoryStat) ProtoMessage()    {}
func (*MemoryStat) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{63}
}
func (m *MemoryStat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemoryStat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemoryStat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemoryStat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemoryStat.Merge(m, src)
}
func (m *MemoryStat) XXX_Size() int {
	return m.Size()
}
func (m *MemoryStat) XXX_DiscardUnknown() {
	xxx_messageInfo_MemoryStat.DiscardUnknown(m)
}

var xxx_messageInfo_MemoryStat proto.InternalMessageInfo

func (m *MemoryStat) GetRss() uint64 {
	if m != nil {
		return m.Rss
	}
	return 0
}

func (m *MemoryStat) GetVms() uint64 {
	if m != nil {
		return m.Vms
	}
	return 0
}

func (m *MemoryStat) GetSwap() uint64 {
	if m != nil {
		return m.Swap
	}
	return 0
}

func (m *MemoryStat) GetShared() uint64 {
	if m != nil {
		return m.Shared
	}
	return 0
}

func (m *MemoryStat) GetText() uint64 {
	if m != nil {
		return m.Text
	}
	return 0
}

func (m *MemoryStat) GetLib() uint64 {
	if m != nil {
		return m.Lib
	}
	return 0
}

func (m *MemoryStat) GetData() uint64 {
	if m != nil {
		return m.Data
	}
	return 0
}

func (m *MemoryStat) GetDirty() uint64 {
	if m != nil {
		return m.Dirty
	}
	return 0
}

type CPUStat struct {
	LastCpu    string           `protobuf:"bytes,1,opt,name=lastCpu,proto3" json:"lastCpu,omitempty"`
	TotalPct   float32          `protobuf:"fixed32,2,opt,name=totalPct,proto3" json:"totalPct,omitempty"`
	UserPct    float32          `protobuf:"fixed32,3,opt,name=userPct,proto3" json:"userPct,omitempty"`
	SystemPct  float32          `protobuf:"fixed32,4,opt,name=systemPct,proto3" json:"systemPct,omitempty"`
	NumThreads int32            `protobuf:"varint,5,opt,name=numThreads,proto3" json:"numThreads,omitempty"`
	Cpus       []*SingleCPUStat `protobuf:"bytes,6,rep,name=cpus,proto3" json:"cpus,omitempty"`
	Nice       int32            `protobuf:"varint,7,opt,name=nice,proto3" json:"nice,omitempty"`
	UserTime   int64            `protobuf:"varint,8,opt,name=userTime,proto3" json:"userTime,omitempty"`
	SystemTime int64            `protobuf:"varint,9,opt,name=systemTime,proto3" json:"systemTime,omitempty"`
}

func (m *CPUStat) Reset()         { *m = CPUStat{} }
func (m *CPUStat) String() string { return proto.CompactTextString(m) }
func (*CPUStat) ProtoMessage()    {}
func (*CPUStat) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{64}
}
func (m *CPUStat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CPUStat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CPUStat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CPUStat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CPUStat.Merge(m, src)
}
func (m *CPUStat) XXX_Size() int {
	return m.Size()
}
func (m *CPUStat) XXX_DiscardUnknown() {
	xxx_messageInfo_CPUStat.DiscardUnknown(m)
}

var xxx_messageInfo_CPUStat proto.InternalMessageInfo

func (m *CPUStat) GetLastCpu() string {
	if m != nil {
		return m.LastCpu
	}
	return ""
}

func (m *CPUStat) GetTotalPct() float32 {
	if m != nil {
		return m.TotalPct
	}
	return 0
}

func (m *CPUStat) GetUserPct() float32 {
	if m != nil {
		return m.UserPct
	}
	return 0
}

func (m *CPUStat) GetSystemPct() float32 {
	if m != nil {
		return m.SystemPct
	}
	return 0
}

func (m *CPUStat) GetNumThreads() int32 {
	if m != nil {
		return m.NumThreads
	}
	return 0
}

func (m *CPUStat) GetCpus() []*SingleCPUStat {
	if m != nil {
		return m.Cpus
	}
	return nil
}

func (m *CPUStat) GetNice() int32 {
	if m != nil {
		return m.Nice
	}
	return 0
}

func (m *CPUStat) GetUserTime() int64 {
	if m != nil {
		return m.UserTime
	}
	return 0
}

func (m *CPUStat) GetSystemTime() int64 {
	if m != nil {
		return m.SystemTime
	}
	return 0
}

type SingleCPUStat struct {
	Name     string  `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	TotalPct float32 `protobuf:"fixed32,2,opt,name=totalPct,proto3" json:"totalPct,omitempty"`
}

func (m *SingleCPUStat) Reset()         { *m = SingleCPUStat{} }
func (m *SingleCPUStat) String() string { return proto.CompactTextString(m) }
func (*SingleCPUStat) ProtoMessage()    {}
func (*SingleCPUStat) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{65}
}
func (m *SingleCPUStat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SingleCPUStat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SingleCPUStat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SingleCPUStat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SingleCPUStat.Merge(m, src)
}
func (m *SingleCPUStat) XXX_Size() int {
	return m.Size()
}
func (m *SingleCPUStat) XXX_DiscardUnknown() {
	xxx_messageInfo_SingleCPUStat.DiscardUnknown(m)
}

var xxx_messageInfo_SingleCPUStat proto.InternalMessageInfo

func (m *SingleCPUStat) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SingleCPUStat) GetTotalPct() float32 {
	if m != nil {
		return m.TotalPct
	}
	return 0
}

type CPUInfo struct {
	Number     int32  `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	Vendor     string `protobuf:"bytes,2,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Family     string `protobuf:"bytes,3,opt,name=family,proto3" json:"family,omitempty"`
	Model      string `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	PhysicalId string `protobuf:"bytes,5,opt,name=physicalId,proto3" json:"physicalId,omitempty"`
	CoreId     string `protobuf:"bytes,6,opt,name=coreId,proto3" json:"coreId,omitempty"`
	Cores      int32  `protobuf:"varint,7,opt,name=cores,proto3" json:"cores,omitempty"`
	Mhz        int64  `protobuf:"varint,8,opt,name=mhz,proto3" json:"mhz,omitempty"`
	CacheSize  int32  `protobuf:"varint,9,opt,name=cacheSize,proto3" json:"cacheSize,omitempty"`
}

func (m *CPUInfo) Reset()         { *m = CPUInfo{} }
func (m *CPUInfo) String() string { return proto.CompactTextString(m) }
func (*CPUInfo) ProtoMessage()    {}
func (*CPUInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{66}
}
func (m *CPUInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CPUInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CPUInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CPUInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CPUInfo.Merge(m, src)
}
func (m *CPUInfo) XXX_Size() int {
	return m.Size()
}
func (m *CPUInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CPUInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CPUInfo proto.InternalMessageInfo

func (m *CPUInfo) GetNumber() int32 {
	if m != nil {
		return m.Number
	}
	return 0
}

func (m *CPUInfo) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *CPUInfo) GetFamily() string {
	if m != nil {
		return m.Family
	}
	return ""
}

func (m *CPUInfo) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *CPUInfo) GetPhysicalId() string {
	if m != nil {
		return m.PhysicalId
	}
	return ""
}

func (m *CPUInfo) GetCoreId() string {
	if m != nil {
		return m.CoreId
	}
	return ""
}

func (m *CPUInfo) GetCores() int32 {
	if m != nil {
		return m.Cores
	}
	return 0
}

func (m *CPUInfo) GetMhz() int64 {
	if m != nil {
		return m.Mhz
	}
	return 0
}

func (m *CPUInfo) GetCacheSize() int32 {
	if m != nil {
		return m.CacheSize
	}
	return 0
}

type Host struct {
	Id           int64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	OrgId        int32    `protobuf:"varint,2,opt,name=orgId,proto3" json:"orgId,omitempty"`
	Name         string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	AllTags      []string `protobuf:"bytes,6,rep,name=allTags,proto3" json:"allTags,omitempty"`
	NumCpus      int32    `protobuf:"varint,7,opt,name=numCpus,proto3" json:"numCpus,omitempty"`
	TotalMemory  int64    `protobuf:"varint,8,opt,name=totalMemory,proto3" json:"totalMemory,omitempty"`
	TagIndex     int32    `protobuf:"varint,9,opt,name=tagIndex,proto3" json:"tagIndex,omitempty"`
	TagsModified int64    `protobuf:"varint,10,opt,name=tagsModified,proto3" json:"tagsModified,omitempty"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{67}
}
func (m *Host) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Host.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(m, src)
}
func (m *Host) XXX_Size() int {
	return m.Size()
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Host) GetOrgId() int32 {
	if m != nil {
		return m.OrgId
	}
	return 0
}

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetAllTags() []string {
	if m != nil {
		return m.AllTags
	}
	return nil
}

func (m *Host) GetNumCpus() int32 {
	if m != nil {
		return m.NumCpus
	}
	return 0
}

func (m *Host) GetTotalMemory() int64 {
	if m != nil {
		return m.TotalMemory
	}
	return 0
}

func (m *Host) GetTagIndex() int32 {
	if m != nil {
		return m.TagIndex
	}
	return 0
}

func (m *Host) GetTagsModified() int64 {
	if m != nil {
		return m.TagsModified
	}
	return 0
}

type Cluster struct {
	NodeCount         int32            `protobuf:"varint,1,opt,name=nodeCount,proto3" json:"nodeCount,omitempty"`
	KubeletVersions   map[string]int32 `protobuf:"bytes,2,rep,name=kubeletVersions,proto3" json:"kubeletVersions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ApiServerVersions map[string]int32 `protobuf:"bytes,3,rep,name=apiServerVersions,proto3" json:"apiServerVersions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// sum of all nodes capacities and allocatables.
	// Using smallest possible quantity levels.
	// For memory it is bytes, for CPU it is millicore.
	PodCapacity                  uint32             `protobuf:"varint,4,opt,name=podCapacity,proto3" json:"podCapacity,omitempty"`
	PodAllocatable               uint32             `protobuf:"varint,5,opt,name=podAllocatable,proto3" json:"podAllocatable,omitempty"`
	MemoryAllocatable            uint64             `protobuf:"varint,6,opt,name=memoryAllocatable,proto3" json:"memoryAllocatable,omitempty"`
	MemoryCapacity               uint64             `protobuf:"varint,7,opt,name=memoryCapacity,proto3" json:"memoryCapacity,omitempty"`
	CpuAllocatable               uint64             `protobuf:"varint,8,opt,name=cpuAllocatable,proto3" json:"cpuAllocatable,omitempty"`
	CpuCapacity                  uint64             `protobuf:"varint,9,opt,name=cpuCapacity,proto3" json:"cpuCapacity,omitempty"`
	ResourceVersion              string             `protobuf:"bytes,10,opt,name=resourceVersion,proto3" json:"resourceVersion,omitempty"`
	CreationTimestamp            int64              `protobuf:"varint,11,opt,name=creationTimestamp,proto3" json:"creationTimestamp,omitempty"`
	Tags                         []string           `protobuf:"bytes,12,rep,name=tags,proto3" json:"tags,omitempty"`
	Metrics                      *ResourceMetrics   `protobuf:"bytes,13,opt,name=metrics,proto3" json:"metrics,omitempty"`
	ExtendedResourcesAllocatable map[string]int64   `protobuf:"bytes,14,rep,name=extendedResourcesAllocatable,proto3" json:"extendedResourcesAllocatable,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ExtendedResourcesCapacity    map[string]int64   `protobuf:"bytes,15,rep,name=extendedResourcesCapacity,proto3" json:"extendedResourcesCapacity,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	NodesInfo                    []*ClusterNodeInfo `protobuf:"bytes,16,rep,name=nodesInfo,proto3" json:"nodesInfo,omitempty"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{68}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return m.Size()
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *Cluster) GetKubeletVersions() map[string]int32 {
	if m != nil {
		return m.KubeletVersions
	}
	return nil
}

func (m *Cluster) GetApiServerVersions() map[string]int32 {
	if m != nil {
		return m.ApiServerVersions
	}
	return nil
}

func (m *Cluster) GetPodCapacity() uint32 {
	if m != nil {
		return m.PodCapacity
	}
	return 0
}

func (m *Cluster) GetPodAllocatable() uint32 {
	if m != nil {
		return m.PodAllocatable
	}
	return 0
}

func (m *Cluster) GetMemoryAllocatable() uint64 {
	if m != nil {
		return m.MemoryAllocatable
	}
	return 0
}

func (m *Cluster) GetMemoryCapacity() uint64 {
	if m != nil {
		return m.MemoryCapacity
	}
	return 0
}

func (m *Cluster) GetCpuAllocatable() uint64 {
	if m != nil {
		return m.CpuAllocatable
	}
	return 0
}

func (m *Cluster) GetCpuCapacity() uint64 {
	if m != nil {
		return m.CpuCapacity
	}
	return 0
}

func (m *Cluster) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

func (m *Cluster) GetCreationTimestamp() int64 {
	if m != nil {
		return m.CreationTimestamp
	}
	return 0
}

func (m *Cluster) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Cluster) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *Cluster) GetExtendedResourcesAllocatable() map[string]int64 {
	if m != nil {
		return m.ExtendedResourcesAllocatable
	}
	return nil
}

func (m *Cluster) GetExtendedResourcesCapacity() map[string]int64 {
	if m != nil {
		return m.ExtendedResourcesCapacity
	}
	return nil
}

func (m *Cluster) GetNodesInfo() []*ClusterNodeInfo {
	if m != nil {
		return m.NodesInfo
	}
	return nil
}

type ClusterNodeInfo struct {
	Name                    string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Region                  string            `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	InstanceType            string            `protobuf:"bytes,3,opt,name=instanceType,proto3" json:"instanceType,omitempty"`
	OperatingSystem         string            `protobuf:"bytes,4,opt,name=operatingSystem,proto3" json:"operatingSystem,omitempty"`
	OperatingSystemImage    string            `protobuf:"bytes,5,opt,name=operatingSystemImage,proto3" json:"operatingSystemImage,omitempty"`
	Architecture            string            `protobuf:"bytes,6,opt,name=architecture,proto3" json:"architecture,omitempty"`
	KernelVersion           string            `protobuf:"bytes,7,opt,name=kernelVersion,proto3" json:"kernelVersion,omitempty"`
	ContainerRuntimeVersion string            `protobuf:"bytes,8,opt,name=containerRuntimeVersion,proto3" json:"containerRuntimeVersion,omitempty"`
	KubeletVersion          string            `protobuf:"bytes,9,opt,name=kubeletVersion,proto3" json:"kubeletVersion,omitempty"`
	ResourceAllocatable     map[string]string `protobuf:"bytes,10,rep,name=resourceAllocatable,proto3" json:"resourceAllocatable,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ResourceCapacity        map[string]string `protobuf:"bytes,11,rep,name=resourceCapacity,proto3" json:"resourceCapacity,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *ClusterNodeInfo) Reset()         { *m = ClusterNodeInfo{} }
func (m *ClusterNodeInfo) String() string { return proto.CompactTextString(m) }
func (*ClusterNodeInfo) ProtoMessage()    {}
func (*ClusterNodeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{69}
}
func (m *ClusterNodeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterNodeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterNodeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterNodeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterNodeInfo.Merge(m, src)
}
func (m *ClusterNodeInfo) XXX_Size() int {
	return m.Size()
}
func (m *ClusterNodeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterNodeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterNodeInfo proto.InternalMessageInfo

func (m *ClusterNodeInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ClusterNodeInfo) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ClusterNodeInfo) GetInstanceType() string {
	if m != nil {
		return m.InstanceType
	}
	return ""
}

func (m *ClusterNodeInfo) GetOperatingSystem() string {
	if m != nil {
		return m.OperatingSystem
	}
	return ""
}

func (m *ClusterNodeInfo) GetOperatingSystemImage() string {
	if m != nil {
		return m.OperatingSystemImage
	}
	return ""
}

func (m *ClusterNodeInfo) GetArchitecture() string {
	if m != nil {
		return m.Architecture
	}
	return ""
}

func (m *ClusterNodeInfo) GetKernelVersion() string {
	if m != nil {
		return m.KernelVersion
	}
	return ""
}

func (m *ClusterNodeInfo) GetContainerRuntimeVersion() string {
	if m != nil {
		return m.ContainerRuntimeVersion
	}
	return ""
}

func (m *ClusterNodeInfo) GetKubeletVersion() string {
	if m != nil {
		return m.KubeletVersion
	}
	return ""
}

func (m *ClusterNodeInfo) GetResourceAllocatable() map[string]string {
	if m != nil {
		return m.ResourceAllocatable
	}
	return nil
}

func (m *ClusterNodeInfo) GetResourceCapacity() map[string]string {
	if m != nil {
		return m.ResourceCapacity
	}
	return nil
}

// reference https://github.com/kubernetes/apimachinery/blob/2373d029717c4d169463414a6127cd1d0d12680e/pkg/apis/meta/v1/generated.proto#L521
type Metadata struct {
	Name                       string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace                  string            `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Uid                        string            `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	CreationTimestamp          int64             `protobuf:"varint,4,opt,name=creationTimestamp,proto3" json:"creationTimestamp,omitempty"`
	DeletionTimestamp          int64             `protobuf:"varint,5,opt,name=deletionTimestamp,proto3" json:"deletionTimestamp,omitempty"`
	Labels                     []string          `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty"`
	Annotations                []string          `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty"`
	OwnerReferences            []*OwnerReference `protobuf:"bytes,8,rep,name=ownerReferences,proto3" json:"ownerReferences,omitempty"`
	ResourceVersion            string            `protobuf:"bytes,9,opt,name=resourceVersion,proto3" json:"resourceVersion,omitempty"`
	Finalizers                 []string          `protobuf:"bytes,10,rep,name=finalizers,proto3" json:"finalizers,omitempty"`
	DeletionGracePeriodSeconds int64             `protobuf:"varint,11,opt,name=deletionGracePeriodSeconds,proto3" json:"deletionGracePeriodSeconds,omitempty"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{70}
}
func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(m, src)
}
func (m *Metadata) XXX_Size() int {
	return m.Size()
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

func (m *Metadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Metadata) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Metadata) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *Metadata) GetCreationTimestamp() int64 {
	if m != nil {
		return m.CreationTimestamp
	}
	return 0
}

func (m *Metadata) GetDeletionTimestamp() int64 {
	if m != nil {
		return m.DeletionTimestamp
	}
	return 0
}

func (m *Metadata) GetLabels() []string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Metadata) GetAnnotations() []string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Metadata) GetOwnerReferences() []*OwnerReference {
	if m != nil {
		return m.OwnerReferences
	}
	return nil
}

func (m *Metadata) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

func (m *Metadata) GetFinalizers() []string {
	if m != nil {
		return m.Finalizers
	}
	return nil
}

func (m *Metadata) GetDeletionGracePeriodSeconds() int64 {
	if m != nil {
		return m.DeletionGracePeriodSeconds
	}
	return 0
}

type OwnerReference struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Uid  string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (m *OwnerReference) Reset()         { *m = OwnerReference{} }
func (m *OwnerReference) String() string { return proto.CompactTextString(m) }
func (*OwnerReference) ProtoMessage()    {}
func (*OwnerReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{71}
}
func (m *OwnerReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OwnerReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OwnerReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OwnerReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OwnerReference.Merge(m, src)
}
func (m *OwnerReference) XXX_Size() int {
	return m.Size()
}
func (m *OwnerReference) XXX_DiscardUnknown() {
	xxx_messageInfo_OwnerReference.DiscardUnknown(m)
}

var xxx_messageInfo_OwnerReference proto.InternalMessageInfo

func (m *OwnerReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OwnerReference) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *OwnerReference) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/pkg/apis/core/types.go#L4317
type ObjectReference struct {
	Kind            string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Namespace       string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Name            string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Uid             string `protobuf:"bytes,4,opt,name=uid,proto3" json:"uid,omitempty"`
	ApiVersion      string `protobuf:"bytes,5,opt,name=apiVersion,proto3" json:"apiVersion,omitempty"`
	ResourceVersion string `protobuf:"bytes,6,opt,name=resourceVersion,proto3" json:"resourceVersion,omitempty"`
	FieldPath       string `protobuf:"bytes,7,opt,name=fieldPath,proto3" json:"fieldPath,omitempty"`
}

func (m *ObjectReference) Reset()         { *m = ObjectReference{} }
func (m *ObjectReference) String() string { return proto.CompactTextString(m) }
func (*ObjectReference) ProtoMessage()    {}
func (*ObjectReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{72}
}
func (m *ObjectReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ObjectReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ObjectReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ObjectReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectReference.Merge(m, src)
}
func (m *ObjectReference) XXX_Size() int {
	return m.Size()
}
func (m *ObjectReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectReference.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectReference proto.InternalMessageInfo

func (m *ObjectReference) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *ObjectReference) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ObjectReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ObjectReference) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *ObjectReference) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *ObjectReference) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

func (m *ObjectReference) GetFieldPath() string {
	if m != nil {
		return m.FieldPath
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L4571
type ServicePort struct {
	Name       string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Protocol   string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Port       int32  `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	TargetPort string `protobuf:"bytes,4,opt,name=targetPort,proto3" json:"targetPort,omitempty"`
	NodePort   int32  `protobuf:"varint,5,opt,name=nodePort,proto3" json:"nodePort,omitempty"`
}

func (m *ServicePort) Reset()         { *m = ServicePort{} }
func (m *ServicePort) String() string { return proto.CompactTextString(m) }
func (*ServicePort) ProtoMessage()    {}
func (*ServicePort) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{73}
}
func (m *ServicePort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServicePort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServicePort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServicePort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicePort.Merge(m, src)
}
func (m *ServicePort) XXX_Size() int {
	return m.Size()
}
func (m *ServicePort) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicePort.DiscardUnknown(m)
}

var xxx_messageInfo_ServicePort proto.InternalMessageInfo

func (m *ServicePort) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServicePort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *ServicePort) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *ServicePort) GetTargetPort() string {
	if m != nil {
		return m.TargetPort
	}
	return ""
}

func (m *ServicePort) GetNodePort() int32 {
	if m != nil {
		return m.NodePort
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L4756
type ServiceSessionAffinityConfig struct {
	ClientIPTimeoutSeconds int32 `protobuf:"varint,1,opt,name=clientIPTimeoutSeconds,proto3" json:"clientIPTimeoutSeconds,omitempty"`
}

func (m *ServiceSessionAffinityConfig) Reset()         { *m = ServiceSessionAffinityConfig{} }
func (m *ServiceSessionAffinityConfig) String() string { return proto.CompactTextString(m) }
func (*ServiceSessionAffinityConfig) ProtoMessage()    {}
func (*ServiceSessionAffinityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{74}
}
func (m *ServiceSessionAffinityConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceSessionAffinityConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceSessionAffinityConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceSessionAffinityConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceSessionAffinityConfig.Merge(m, src)
}
func (m *ServiceSessionAffinityConfig) XXX_Size() int {
	return m.Size()
}
func (m *ServiceSessionAffinityConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceSessionAffinityConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceSessionAffinityConfig proto.InternalMessageInfo

func (m *ServiceSessionAffinityConfig) GetClientIPTimeoutSeconds() int32 {
	if m != nil {
		return m.ClientIPTimeoutSeconds
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2107
type Node struct {
	Metadata *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// spec reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2312
	PodCIDR       string      `protobuf:"bytes,2,opt,name=podCIDR,proto3" json:"podCIDR,omitempty"`
	PodCIDRs      []string    `protobuf:"bytes,3,rep,name=podCIDRs,proto3" json:"podCIDRs,omitempty"`
	Unschedulable bool        `protobuf:"varint,4,opt,name=unschedulable,proto3" json:"unschedulable,omitempty"`
	Taints        []*Taint    `protobuf:"bytes,5,rep,name=taints,proto3" json:"taints,omitempty"`
	Status        *NodeStatus `protobuf:"bytes,6,opt,name=status,proto3" json:"status,omitempty"`
	Yaml          []byte      `protobuf:"bytes,7,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	// we parse it from the labels. Similar to upstream https://github.com/kubernetes/kubernetes/blob/1e12d92a5179dbfeb455c79dbf9120c8536e5f9c/pkg/printers/internalversion/printers.go#L1487
	Roles      []string         `protobuf:"bytes,8,rep,name=roles,proto3" json:"roles,omitempty"`
	Tags       []string         `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty"`
	ProviderID string           `protobuf:"bytes,10,opt,name=providerID,proto3" json:"providerID,omitempty"`
	Host       *Host            `protobuf:"bytes,11,opt,name=host,proto3" json:"host,omitempty"`
	Metrics    *ResourceMetrics `protobuf:"bytes,12,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (m *Node) Reset()         { *m = Node{} }
func (m *Node) String() string { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()    {}
func (*Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{75}
}
func (m *Node) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Node.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node.Merge(m, src)
}
func (m *Node) XXX_Size() int {
	return m.Size()
}
func (m *Node) XXX_DiscardUnknown() {
	xxx_messageInfo_Node.DiscardUnknown(m)
}

var xxx_messageInfo_Node proto.InternalMessageInfo

func (m *Node) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Node) GetPodCIDR() string {
	if m != nil {
		return m.PodCIDR
	}
	return ""
}

func (m *Node) GetPodCIDRs() []string {
	if m != nil {
		return m.PodCIDRs
	}
	return nil
}

func (m *Node) GetUnschedulable() bool {
	if m != nil {
		return m.Unschedulable
	}
	return false
}

func (m *Node) GetTaints() []*Taint {
	if m != nil {
		return m.Taints
	}
	return nil
}

func (m *Node) GetStatus() *NodeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *Node) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Node) GetRoles() []string {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *Node) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Node) GetProviderID() string {
	if m != nil {
		return m.ProviderID
	}
	return ""
}

func (m *Node) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *Node) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2348
type NodeStatus struct {
	// Key/Value of a resource type and a corresponding quantity as an int64.
	Capacity map[string]int64 `protobuf:"bytes,1,rep,name=capacity,proto3" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Key/Value of a resource type and a corresponding quantity as an int64.
	Allocatable map[string]int64 `protobuf:"bytes,2,rep,name=allocatable,proto3" json:"allocatable,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2127
	// these are valid types https://github.com/kubernetes/api/blob/master/core/v1/types.go#L4739-L4753
	NodeAddresses map[string]string `protobuf:"bytes,3,rep,name=nodeAddresses,proto3" json:"nodeAddresses,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// node status displayed by "kubectl get node"
	// mostly based on NodeCondition
	// and https://github.com/kubernetes/kubernetes/blob/1e12d92a5179dbfeb455c79dbf9120c8536e5f9c/pkg/printers/internalversion/printers.go#L1410
	Status         string            `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	KubeletVersion string            `protobuf:"bytes,5,opt,name=kubeletVersion,proto3" json:"kubeletVersion,omitempty"`
	Conditions     []*NodeCondition  `protobuf:"bytes,6,rep,name=conditions,proto3" json:"conditions,omitempty"`
	Images         []*ContainerImage `protobuf:"bytes,7,rep,name=images,proto3" json:"images,omitempty"`
	// node system info reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2411
	KubeProxyVersion        string `protobuf:"bytes,8,opt,name=kubeProxyVersion,proto3" json:"kubeProxyVersion,omitempty"`
	OperatingSystem         string `protobuf:"bytes,9,opt,name=operatingSystem,proto3" json:"operatingSystem,omitempty"`
	Architecture            string `protobuf:"bytes,10,opt,name=architecture,proto3" json:"architecture,omitempty"`
	KernelVersion           string `protobuf:"bytes,11,opt,name=kernelVersion,proto3" json:"kernelVersion,omitempty"`
	OsImage                 string `protobuf:"bytes,12,opt,name=osImage,proto3" json:"osImage,omitempty"`
	ContainerRuntimeVersion string `protobuf:"bytes,13,opt,name=containerRuntimeVersion,proto3" json:"containerRuntimeVersion,omitempty"`
}

func (m *NodeStatus) Reset()         { *m = NodeStatus{} }
func (m *NodeStatus) String() string { return proto.CompactTextString(m) }
func (*NodeStatus) ProtoMessage()    {}
func (*NodeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{76}
}
func (m *NodeStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeStatus.Merge(m, src)
}
func (m *NodeStatus) XXX_Size() int {
	return m.Size()
}
func (m *NodeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_NodeStatus proto.InternalMessageInfo

func (m *NodeStatus) GetCapacity() map[string]int64 {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *NodeStatus) GetAllocatable() map[string]int64 {
	if m != nil {
		return m.Allocatable
	}
	return nil
}

func (m *NodeStatus) GetNodeAddresses() map[string]string {
	if m != nil {
		return m.NodeAddresses
	}
	return nil
}

func (m *NodeStatus) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *NodeStatus) GetKubeletVersion() string {
	if m != nil {
		return m.KubeletVersion
	}
	return ""
}

func (m *NodeStatus) GetConditions() []*NodeCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *NodeStatus) GetImages() []*ContainerImage {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *NodeStatus) GetKubeProxyVersion() string {
	if m != nil {
		return m.KubeProxyVersion
	}
	return ""
}

func (m *NodeStatus) GetOperatingSystem() string {
	if m != nil {
		return m.OperatingSystem
	}
	return ""
}

func (m *NodeStatus) GetArchitecture() string {
	if m != nil {
		return m.Architecture
	}
	return ""
}

func (m *NodeStatus) GetKernelVersion() string {
	if m != nil {
		return m.KernelVersion
	}
	return ""
}

func (m *NodeStatus) GetOsImage() string {
	if m != nil {
		return m.OsImage
	}
	return ""
}

func (m *NodeStatus) GetContainerRuntimeVersion() string {
	if m != nil {
		return m.ContainerRuntimeVersion
	}
	return ""
}

// reference: https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2158
type NodeCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *NodeCondition) Reset()         { *m = NodeCondition{} }
func (m *NodeCondition) String() string { return proto.CompactTextString(m) }
func (*NodeCondition) ProtoMessage()    {}
func (*NodeCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{77}
}
func (m *NodeCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeCondition.Merge(m, src)
}
func (m *NodeCondition) XXX_Size() int {
	return m.Size()
}
func (m *NodeCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeCondition.DiscardUnknown(m)
}

var xxx_messageInfo_NodeCondition proto.InternalMessageInfo

func (m *NodeCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *NodeCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *NodeCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *NodeCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *NodeCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L777
type ContainerImage struct {
	Names     []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	SizeBytes int64    `protobuf:"varint,2,opt,name=sizeBytes,proto3" json:"sizeBytes,omitempty"`
}

func (m *ContainerImage) Reset()         { *m = ContainerImage{} }
func (m *ContainerImage) String() string { return proto.CompactTextString(m) }
func (*ContainerImage) ProtoMessage()    {}
func (*ContainerImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{78}
}
func (m *ContainerImage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerImage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerImage.Merge(m, src)
}
func (m *ContainerImage) XXX_Size() int {
	return m.Size()
}
func (m *ContainerImage) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerImage.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerImage proto.InternalMessageInfo

func (m *ContainerImage) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *ContainerImage) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L4849
type Taint struct {
	Key       string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value     string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Effect    string `protobuf:"bytes,3,opt,name=effect,proto3" json:"effect,omitempty"`
	TimeAdded int64  `protobuf:"varint,4,opt,name=timeAdded,proto3" json:"timeAdded,omitempty"`
}

func (m *Taint) Reset()         { *m = Taint{} }
func (m *Taint) String() string { return proto.CompactTextString(m) }
func (*Taint) ProtoMessage()    {}
func (*Taint) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{79}
}
func (m *Taint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Taint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Taint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Taint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Taint.Merge(m, src)
}
func (m *Taint) XXX_Size() int {
	return m.Size()
}
func (m *Taint) XXX_DiscardUnknown() {
	xxx_messageInfo_Taint.DiscardUnknown(m)
}

var xxx_messageInfo_Taint proto.InternalMessageInfo

func (m *Taint) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Taint) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Taint) GetEffect() string {
	if m != nil {
		return m.Effect
	}
	return ""
}

func (m *Taint) GetTimeAdded() int64 {
	if m != nil {
		return m.TimeAdded
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L4620
type ServiceSpec struct {
	Ports                    []*ServicePort                `protobuf:"bytes,1,rep,name=ports,proto3" json:"ports,omitempty"`
	Selectors                []*LabelSelectorRequirement   `protobuf:"bytes,2,rep,name=selectors,proto3" json:"selectors,omitempty"`
	ClusterIP                string                        `protobuf:"bytes,3,opt,name=clusterIP,proto3" json:"clusterIP,omitempty"`
	Type                     string                        `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	ExternalIPs              []string                      `protobuf:"bytes,5,rep,name=externalIPs,proto3" json:"externalIPs,omitempty"`
	SessionAffinity          string                        `protobuf:"bytes,6,opt,name=sessionAffinity,proto3" json:"sessionAffinity,omitempty"`
	LoadBalancerIP           string                        `protobuf:"bytes,7,opt,name=loadBalancerIP,proto3" json:"loadBalancerIP,omitempty"`
	LoadBalancerSourceRanges []string                      `protobuf:"bytes,8,rep,name=loadBalancerSourceRanges,proto3" json:"loadBalancerSourceRanges,omitempty"`
	ExternalName             string                        `protobuf:"bytes,9,opt,name=externalName,proto3" json:"externalName,omitempty"`
	ExternalTrafficPolicy    string                        `protobuf:"bytes,10,opt,name=externalTrafficPolicy,proto3" json:"externalTrafficPolicy,omitempty"`
	HealthCheckNodePort      int32                         `protobuf:"varint,11,opt,name=healthCheckNodePort,proto3" json:"healthCheckNodePort,omitempty"`
	PublishNotReadyAddresses bool                          `protobuf:"varint,12,opt,name=publishNotReadyAddresses,proto3" json:"publishNotReadyAddresses,omitempty"`
	SessionAffinityConfig    *ServiceSessionAffinityConfig `protobuf:"bytes,13,opt,name=sessionAffinityConfig,proto3" json:"sessionAffinityConfig,omitempty"`
	IpFamily                 string                        `protobuf:"bytes,14,opt,name=ipFamily,proto3" json:"ipFamily,omitempty"`
}

func (m *ServiceSpec) Reset()         { *m = ServiceSpec{} }
func (m *ServiceSpec) String() string { return proto.CompactTextString(m) }
func (*ServiceSpec) ProtoMessage()    {}
func (*ServiceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{80}
}
func (m *ServiceSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceSpec.Merge(m, src)
}
func (m *ServiceSpec) XXX_Size() int {
	return m.Size()
}
func (m *ServiceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceSpec proto.InternalMessageInfo

func (m *ServiceSpec) GetPorts() []*ServicePort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *ServiceSpec) GetSelectors() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selectors
	}
	return nil
}

func (m *ServiceSpec) GetClusterIP() string {
	if m != nil {
		return m.ClusterIP
	}
	return ""
}

func (m *ServiceSpec) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ServiceSpec) GetExternalIPs() []string {
	if m != nil {
		return m.ExternalIPs
	}
	return nil
}

func (m *ServiceSpec) GetSessionAffinity() string {
	if m != nil {
		return m.SessionAffinity
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerIP() string {
	if m != nil {
		return m.LoadBalancerIP
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerSourceRanges() []string {
	if m != nil {
		return m.LoadBalancerSourceRanges
	}
	return nil
}

func (m *ServiceSpec) GetExternalName() string {
	if m != nil {
		return m.ExternalName
	}
	return ""
}

func (m *ServiceSpec) GetExternalTrafficPolicy() string {
	if m != nil {
		return m.ExternalTrafficPolicy
	}
	return ""
}

func (m *ServiceSpec) GetHealthCheckNodePort() int32 {
	if m != nil {
		return m.HealthCheckNodePort
	}
	return 0
}

func (m *ServiceSpec) GetPublishNotReadyAddresses() bool {
	if m != nil {
		return m.PublishNotReadyAddresses
	}
	return false
}

func (m *ServiceSpec) GetSessionAffinityConfig() *ServiceSessionAffinityConfig {
	if m != nil {
		return m.SessionAffinityConfig
	}
	return nil
}

func (m *ServiceSpec) GetIpFamily() string {
	if m != nil {
		return m.IpFamily
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L4748
type ServiceStatus struct {
	LoadBalancerIngress []string `protobuf:"bytes,17,rep,name=loadBalancerIngress,proto3" json:"loadBalancerIngress,omitempty"`
}

func (m *ServiceStatus) Reset()         { *m = ServiceStatus{} }
func (m *ServiceStatus) String() string { return proto.CompactTextString(m) }
func (*ServiceStatus) ProtoMessage()    {}
func (*ServiceStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{81}
}
func (m *ServiceStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceStatus.Merge(m, src)
}
func (m *ServiceStatus) XXX_Size() int {
	return m.Size()
}
func (m *ServiceStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceStatus proto.InternalMessageInfo

func (m *ServiceStatus) GetLoadBalancerIngress() []string {
	if m != nil {
		return m.LoadBalancerIngress
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/release-1.19/staging/src/k8s.io/api/core/v1/generated.proto
type Service struct {
	Metadata *Metadata        `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec     *ServiceSpec     `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status   *ServiceStatus   `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml     []byte           `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string         `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Metrics  *ResourceMetrics `protobuf:"bytes,6,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{82}
}
func (m *Service) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Service.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return m.Size()
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Service) GetSpec() *ServiceSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Service) GetStatus() *ServiceStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *Service) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Service) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Service) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L236
type DeploymentCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastUpdateTime     int64  `protobuf:"varint,6,opt,name=lastUpdateTime,proto3" json:"lastUpdateTime,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,7,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *DeploymentCondition) Reset()         { *m = DeploymentCondition{} }
func (m *DeploymentCondition) String() string { return proto.CompactTextString(m) }
func (*DeploymentCondition) ProtoMessage()    {}
func (*DeploymentCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{83}
}
func (m *DeploymentCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentCondition.Merge(m, src)
}
func (m *DeploymentCondition) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentCondition.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentCondition proto.InternalMessageInfo

func (m *DeploymentCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DeploymentCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DeploymentCondition) GetLastUpdateTime() int64 {
	if m != nil {
		return m.LastUpdateTime
	}
	return 0
}

func (m *DeploymentCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *DeploymentCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *DeploymentCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L221
type Deployment struct {
	Metadata *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// spec
	ReplicasDesired    int32                       `protobuf:"varint,2,opt,name=replicasDesired,proto3" json:"replicasDesired,omitempty"`
	DeploymentStrategy string                      `protobuf:"bytes,3,opt,name=deploymentStrategy,proto3" json:"deploymentStrategy,omitempty"`
	MaxUnavailable     string                      `protobuf:"bytes,4,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	MaxSurge           string                      `protobuf:"bytes,5,opt,name=maxSurge,proto3" json:"maxSurge,omitempty"`
	Paused             bool                        `protobuf:"varint,6,opt,name=paused,proto3" json:"paused,omitempty"`
	Selectors          []*LabelSelectorRequirement `protobuf:"bytes,7,rep,name=selectors,proto3" json:"selectors,omitempty"`
	// status
	Replicas             int32                   `protobuf:"varint,8,opt,name=replicas,proto3" json:"replicas,omitempty"`
	UpdatedReplicas      int32                   `protobuf:"varint,9,opt,name=updatedReplicas,proto3" json:"updatedReplicas,omitempty"`
	ReadyReplicas        int32                   `protobuf:"varint,10,opt,name=readyReplicas,proto3" json:"readyReplicas,omitempty"`
	AvailableReplicas    int32                   `protobuf:"varint,11,opt,name=availableReplicas,proto3" json:"availableReplicas,omitempty"`
	UnavailableReplicas  int32                   `protobuf:"varint,12,opt,name=unavailableReplicas,proto3" json:"unavailableReplicas,omitempty"`
	ConditionMessage     string                  `protobuf:"bytes,13,opt,name=conditionMessage,proto3" json:"conditionMessage,omitempty"`
	ResourceRequirements []*ResourceRequirements `protobuf:"bytes,16,rep,name=resourceRequirements,proto3" json:"resourceRequirements,omitempty"`
	Yaml                 []byte                  `protobuf:"bytes,14,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags                 []string                `protobuf:"bytes,15,rep,name=tags,proto3" json:"tags,omitempty"`
	Metrics              *ResourceMetrics        `protobuf:"bytes,17,opt,name=metrics,proto3" json:"metrics,omitempty"`
	Conditions           []*DeploymentCondition  `protobuf:"bytes,18,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *Deployment) Reset()         { *m = Deployment{} }
func (m *Deployment) String() string { return proto.CompactTextString(m) }
func (*Deployment) ProtoMessage()    {}
func (*Deployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{84}
}
func (m *Deployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment.Merge(m, src)
}
func (m *Deployment) XXX_Size() int {
	return m.Size()
}
func (m *Deployment) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment proto.InternalMessageInfo

func (m *Deployment) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Deployment) GetReplicasDesired() int32 {
	if m != nil {
		return m.ReplicasDesired
	}
	return 0
}

func (m *Deployment) GetDeploymentStrategy() string {
	if m != nil {
		return m.DeploymentStrategy
	}
	return ""
}

func (m *Deployment) GetMaxUnavailable() string {
	if m != nil {
		return m.MaxUnavailable
	}
	return ""
}

func (m *Deployment) GetMaxSurge() string {
	if m != nil {
		return m.MaxSurge
	}
	return ""
}

func (m *Deployment) GetPaused() bool {
	if m != nil {
		return m.Paused
	}
	return false
}

func (m *Deployment) GetSelectors() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selectors
	}
	return nil
}

func (m *Deployment) GetReplicas() int32 {
	if m != nil {
		return m.Replicas
	}
	return 0
}

func (m *Deployment) GetUpdatedReplicas() int32 {
	if m != nil {
		return m.UpdatedReplicas
	}
	return 0
}

func (m *Deployment) GetReadyReplicas() int32 {
	if m != nil {
		return m.ReadyReplicas
	}
	return 0
}

func (m *Deployment) GetAvailableReplicas() int32 {
	if m != nil {
		return m.AvailableReplicas
	}
	return 0
}

func (m *Deployment) GetUnavailableReplicas() int32 {
	if m != nil {
		return m.UnavailableReplicas
	}
	return 0
}

func (m *Deployment) GetConditionMessage() string {
	if m != nil {
		return m.ConditionMessage
	}
	return ""
}

func (m *Deployment) GetResourceRequirements() []*ResourceRequirements {
	if m != nil {
		return m.ResourceRequirements
	}
	return nil
}

// Deprecated: Do not use.
func (m *Deployment) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Deployment) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Deployment) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *Deployment) GetConditions() []*DeploymentCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L388
type ReplicaSetCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ReplicaSetCondition) Reset()         { *m = ReplicaSetCondition{} }
func (m *ReplicaSetCondition) String() string { return proto.CompactTextString(m) }
func (*ReplicaSetCondition) ProtoMessage()    {}
func (*ReplicaSetCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{85}
}
func (m *ReplicaSetCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicaSetCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicaSetCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicaSetCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaSetCondition.Merge(m, src)
}
func (m *ReplicaSetCondition) XXX_Size() int {
	return m.Size()
}
func (m *ReplicaSetCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaSetCondition.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaSetCondition proto.InternalMessageInfo

func (m *ReplicaSetCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ReplicaSetCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ReplicaSetCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *ReplicaSetCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *ReplicaSetCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L366
type ReplicaSet struct {
	Metadata *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// spec
	ReplicasDesired int32                       `protobuf:"varint,2,opt,name=replicasDesired,proto3" json:"replicasDesired,omitempty"`
	Selectors       []*LabelSelectorRequirement `protobuf:"bytes,3,rep,name=selectors,proto3" json:"selectors,omitempty"`
	// status
	Replicas             int32                   `protobuf:"varint,4,opt,name=replicas,proto3" json:"replicas,omitempty"`
	FullyLabeledReplicas int32                   `protobuf:"varint,5,opt,name=fullyLabeledReplicas,proto3" json:"fullyLabeledReplicas,omitempty"`
	ReadyReplicas        int32                   `protobuf:"varint,6,opt,name=readyReplicas,proto3" json:"readyReplicas,omitempty"`
	AvailableReplicas    int32                   `protobuf:"varint,7,opt,name=availableReplicas,proto3" json:"availableReplicas,omitempty"`
	ResourceRequirements []*ResourceRequirements `protobuf:"bytes,10,rep,name=resourceRequirements,proto3" json:"resourceRequirements,omitempty"`
	Yaml                 []byte                  `protobuf:"bytes,8,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags                 []string                `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty"`
	Metrics              *ResourceMetrics        `protobuf:"bytes,11,opt,name=metrics,proto3" json:"metrics,omitempty"`
	Conditions           []*ReplicaSetCondition  `protobuf:"bytes,12,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *ReplicaSet) Reset()         { *m = ReplicaSet{} }
func (m *ReplicaSet) String() string { return proto.CompactTextString(m) }
func (*ReplicaSet) ProtoMessage()    {}
func (*ReplicaSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{86}
}
func (m *ReplicaSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicaSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicaSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicaSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaSet.Merge(m, src)
}
func (m *ReplicaSet) XXX_Size() int {
	return m.Size()
}
func (m *ReplicaSet) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaSet.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaSet proto.InternalMessageInfo

func (m *ReplicaSet) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ReplicaSet) GetReplicasDesired() int32 {
	if m != nil {
		return m.ReplicasDesired
	}
	return 0
}

func (m *ReplicaSet) GetSelectors() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selectors
	}
	return nil
}

func (m *ReplicaSet) GetReplicas() int32 {
	if m != nil {
		return m.Replicas
	}
	return 0
}

func (m *ReplicaSet) GetFullyLabeledReplicas() int32 {
	if m != nil {
		return m.FullyLabeledReplicas
	}
	return 0
}

func (m *ReplicaSet) GetReadyReplicas() int32 {
	if m != nil {
		return m.ReadyReplicas
	}
	return 0
}

func (m *ReplicaSet) GetAvailableReplicas() int32 {
	if m != nil {
		return m.AvailableReplicas
	}
	return 0
}

func (m *ReplicaSet) GetResourceRequirements() []*ResourceRequirements {
	if m != nil {
		return m.ResourceRequirements
	}
	return nil
}

// Deprecated: Do not use.
func (m *ReplicaSet) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *ReplicaSet) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ReplicaSet) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ReplicaSet) GetConditions() []*ReplicaSetCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

type LabelSelectorRequirement struct {
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Valid operators are In, NotIn, Exists and DoesNotExist.
	Operator string   `protobuf:"bytes,2,opt,name=operator,proto3" json:"operator,omitempty"`
	Values   []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (m *LabelSelectorRequirement) Reset()         { *m = LabelSelectorRequirement{} }
func (m *LabelSelectorRequirement) String() string { return proto.CompactTextString(m) }
func (*LabelSelectorRequirement) ProtoMessage()    {}
func (*LabelSelectorRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{87}
}
func (m *LabelSelectorRequirement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelSelectorRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelSelectorRequirement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelSelectorRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSelectorRequirement.Merge(m, src)
}
func (m *LabelSelectorRequirement) XXX_Size() int {
	return m.Size()
}
func (m *LabelSelectorRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSelectorRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSelectorRequirement proto.InternalMessageInfo

func (m *LabelSelectorRequirement) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *LabelSelectorRequirement) GetOperator() string {
	if m != nil {
		return m.Operator
	}
	return ""
}

func (m *LabelSelectorRequirement) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/9ffc095f88c74c0f5b69b1c4a645836f0b7c83fc/staging/src/k8s.io/api/policy/v1/generated.proto#L46
type PodDisruptionBudget struct {
	Metadata *Metadata                  `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec     *PodDisruptionBudgetSpec   `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status   *PodDisruptionBudgetStatus `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Tags     []string                   `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *PodDisruptionBudget) Reset()         { *m = PodDisruptionBudget{} }
func (m *PodDisruptionBudget) String() string { return proto.CompactTextString(m) }
func (*PodDisruptionBudget) ProtoMessage()    {}
func (*PodDisruptionBudget) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{88}
}
func (m *PodDisruptionBudget) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodDisruptionBudget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodDisruptionBudget.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodDisruptionBudget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDisruptionBudget.Merge(m, src)
}
func (m *PodDisruptionBudget) XXX_Size() int {
	return m.Size()
}
func (m *PodDisruptionBudget) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDisruptionBudget.DiscardUnknown(m)
}

var xxx_messageInfo_PodDisruptionBudget proto.InternalMessageInfo

func (m *PodDisruptionBudget) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodDisruptionBudget) GetSpec() *PodDisruptionBudgetSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PodDisruptionBudget) GetStatus() *PodDisruptionBudgetStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *PodDisruptionBudget) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type PodDisruptionBudgetSpec struct {
	MinAvailable               *IntOrString                `protobuf:"bytes,1,opt,name=minAvailable,proto3" json:"minAvailable,omitempty"`
	Selector                   []*LabelSelectorRequirement `protobuf:"bytes,2,rep,name=selector,proto3" json:"selector,omitempty"`
	MaxUnavailable             *IntOrString                `protobuf:"bytes,3,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	UnhealthyPodEvictionPolicy string                      `protobuf:"bytes,4,opt,name=unhealthyPodEvictionPolicy,proto3" json:"unhealthyPodEvictionPolicy,omitempty"`
}

func (m *PodDisruptionBudgetSpec) Reset()         { *m = PodDisruptionBudgetSpec{} }
func (m *PodDisruptionBudgetSpec) String() string { return proto.CompactTextString(m) }
func (*PodDisruptionBudgetSpec) ProtoMessage()    {}
func (*PodDisruptionBudgetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{89}
}
func (m *PodDisruptionBudgetSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodDisruptionBudgetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodDisruptionBudgetSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodDisruptionBudgetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDisruptionBudgetSpec.Merge(m, src)
}
func (m *PodDisruptionBudgetSpec) XXX_Size() int {
	return m.Size()
}
func (m *PodDisruptionBudgetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDisruptionBudgetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PodDisruptionBudgetSpec proto.InternalMessageInfo

func (m *PodDisruptionBudgetSpec) GetMinAvailable() *IntOrString {
	if m != nil {
		return m.MinAvailable
	}
	return nil
}

func (m *PodDisruptionBudgetSpec) GetSelector() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PodDisruptionBudgetSpec) GetMaxUnavailable() *IntOrString {
	if m != nil {
		return m.MaxUnavailable
	}
	return nil
}

func (m *PodDisruptionBudgetSpec) GetUnhealthyPodEvictionPolicy() string {
	if m != nil {
		return m.UnhealthyPodEvictionPolicy
	}
	return ""
}

type PodDisruptionBudgetStatus struct {
	DisruptedPods      map[string]int64 `protobuf:"bytes,1,rep,name=disruptedPods,proto3" json:"disruptedPods,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	DisruptionsAllowed int32            `protobuf:"varint,2,opt,name=disruptionsAllowed,proto3" json:"disruptionsAllowed,omitempty"`
	CurrentHealthy     int32            `protobuf:"varint,3,opt,name=currentHealthy,proto3" json:"currentHealthy,omitempty"`
	DesiredHealthy     int32            `protobuf:"varint,4,opt,name=desiredHealthy,proto3" json:"desiredHealthy,omitempty"`
	ExpectedPods       int32            `protobuf:"varint,5,opt,name=expectedPods,proto3" json:"expectedPods,omitempty"`
	Conditions         []*Condition     `protobuf:"bytes,6,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *PodDisruptionBudgetStatus) Reset()         { *m = PodDisruptionBudgetStatus{} }
func (m *PodDisruptionBudgetStatus) String() string { return proto.CompactTextString(m) }
func (*PodDisruptionBudgetStatus) ProtoMessage()    {}
func (*PodDisruptionBudgetStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{90}
}
func (m *PodDisruptionBudgetStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodDisruptionBudgetStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodDisruptionBudgetStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodDisruptionBudgetStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDisruptionBudgetStatus.Merge(m, src)
}
func (m *PodDisruptionBudgetStatus) XXX_Size() int {
	return m.Size()
}
func (m *PodDisruptionBudgetStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDisruptionBudgetStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PodDisruptionBudgetStatus proto.InternalMessageInfo

func (m *PodDisruptionBudgetStatus) GetDisruptedPods() map[string]int64 {
	if m != nil {
		return m.DisruptedPods
	}
	return nil
}

func (m *PodDisruptionBudgetStatus) GetDisruptionsAllowed() int32 {
	if m != nil {
		return m.DisruptionsAllowed
	}
	return 0
}

func (m *PodDisruptionBudgetStatus) GetCurrentHealthy() int32 {
	if m != nil {
		return m.CurrentHealthy
	}
	return 0
}

func (m *PodDisruptionBudgetStatus) GetDesiredHealthy() int32 {
	if m != nil {
		return m.DesiredHealthy
	}
	return 0
}

func (m *PodDisruptionBudgetStatus) GetExpectedPods() int32 {
	if m != nil {
		return m.ExpectedPods
	}
	return 0
}

func (m *PodDisruptionBudgetStatus) GetConditions() []*Condition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// https://github.com/kubernetes/apimachinery/blob/a8f449e276fe566efddb149992049c78f0088492/pkg/util/intstr/intstr.go#L41
type IntOrString struct {
	Type   IntOrString_Type `protobuf:"varint,1,opt,name=type,proto3,enum=datadog.process_agent.IntOrString_Type" json:"type,omitempty"`
	IntVal int32            `protobuf:"varint,2,opt,name=intVal,proto3" json:"intVal,omitempty"`
	StrVal string           `protobuf:"bytes,3,opt,name=strVal,proto3" json:"strVal,omitempty"`
}

func (m *IntOrString) Reset()         { *m = IntOrString{} }
func (m *IntOrString) String() string { return proto.CompactTextString(m) }
func (*IntOrString) ProtoMessage()    {}
func (*IntOrString) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{91}
}
func (m *IntOrString) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntOrString) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntOrString.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntOrString) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntOrString.Merge(m, src)
}
func (m *IntOrString) XXX_Size() int {
	return m.Size()
}
func (m *IntOrString) XXX_DiscardUnknown() {
	xxx_messageInfo_IntOrString.DiscardUnknown(m)
}

var xxx_messageInfo_IntOrString proto.InternalMessageInfo

func (m *IntOrString) GetType() IntOrString_Type {
	if m != nil {
		return m.Type
	}
	return IntOrString_Int
}

func (m *IntOrString) GetIntVal() int32 {
	if m != nil {
		return m.IntVal
	}
	return 0
}

func (m *IntOrString) GetStrVal() string {
	if m != nil {
		return m.StrVal
	}
	return ""
}

// reference https://github.com/kubernetes/apimachinery/blob/ea28d546a962e50982945e357ad9869cee15f291/pkg/apis/meta/v1/generated.proto#L171
type Condition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *Condition) Reset()         { *m = Condition{} }
func (m *Condition) String() string { return proto.CompactTextString(m) }
func (*Condition) ProtoMessage()    {}
func (*Condition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{92}
}
func (m *Condition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Condition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Condition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Condition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Condition.Merge(m, src)
}
func (m *Condition) XXX_Size() int {
	return m.Size()
}
func (m *Condition) XXX_DiscardUnknown() {
	xxx_messageInfo_Condition.DiscardUnknown(m)
}

var xxx_messageInfo_Condition proto.InternalMessageInfo

func (m *Condition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Condition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Condition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *Condition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Condition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto
type Pod struct {
	Metadata *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// status
	IP                    string                  `protobuf:"bytes,2,opt,name=IP,proto3" json:"IP,omitempty"`
	NominatedNodeName     string                  `protobuf:"bytes,3,opt,name=nominatedNodeName,proto3" json:"nominatedNodeName,omitempty"`
	NodeName              string                  `protobuf:"bytes,4,opt,name=nodeName,proto3" json:"nodeName,omitempty"`
	Phase                 string                  `protobuf:"bytes,5,opt,name=phase,proto3" json:"phase,omitempty"`
	RestartCount          int32                   `protobuf:"varint,6,opt,name=restartCount,proto3" json:"restartCount,omitempty"`
	ContainerStatuses     []*ContainerStatus      `protobuf:"bytes,7,rep,name=containerStatuses,proto3" json:"containerStatuses,omitempty"`
	InitContainerStatuses []*ContainerStatus      `protobuf:"bytes,14,rep,name=initContainerStatuses,proto3" json:"initContainerStatuses,omitempty"`
	ConditionMessage      string                  `protobuf:"bytes,8,opt,name=conditionMessage,proto3" json:"conditionMessage,omitempty"`
	Status                string                  `protobuf:"bytes,9,opt,name=status,proto3" json:"status,omitempty"`
	Yaml                  []byte                  `protobuf:"bytes,10,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags                  []string                `protobuf:"bytes,11,rep,name=tags,proto3" json:"tags,omitempty"`
	Host                  *Host                   `protobuf:"bytes,12,opt,name=host,proto3" json:"host,omitempty"`
	ResourceRequirements  []*ResourceRequirements `protobuf:"bytes,13,rep,name=resourceRequirements,proto3" json:"resourceRequirements,omitempty"`
	QOSClass              string                  `protobuf:"bytes,15,opt,name=QOSClass,proto3" json:"QOSClass,omitempty"`
	PriorityClass         string                  `protobuf:"bytes,16,opt,name=priorityClass,proto3" json:"priorityClass,omitempty"`
	Metrics               *ResourceMetrics        `protobuf:"bytes,17,opt,name=metrics,proto3" json:"metrics,omitempty"`
	StartTime             int64                   `protobuf:"varint,18,opt,name=startTime,proto3" json:"startTime,omitempty"`
	ScheduledTime         int64                   `protobuf:"varint,19,opt,name=scheduledTime,proto3" json:"scheduledTime,omitempty"`
	Conditions            []*PodCondition         `protobuf:"bytes,20,rep,name=conditions,proto3" json:"conditions,omitempty"`
	NodeAffinity          *NodeAffinity           `protobuf:"bytes,21,opt,name=nodeAffinity,proto3" json:"nodeAffinity,omitempty"`
}

func (m *Pod) Reset()         { *m = Pod{} }
func (m *Pod) String() string { return proto.CompactTextString(m) }
func (*Pod) ProtoMessage()    {}
func (*Pod) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{93}
}
func (m *Pod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Pod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Pod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Pod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Pod.Merge(m, src)
}
func (m *Pod) XXX_Size() int {
	return m.Size()
}
func (m *Pod) XXX_DiscardUnknown() {
	xxx_messageInfo_Pod.DiscardUnknown(m)
}

var xxx_messageInfo_Pod proto.InternalMessageInfo

func (m *Pod) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Pod) GetIP() string {
	if m != nil {
		return m.IP
	}
	return ""
}

func (m *Pod) GetNominatedNodeName() string {
	if m != nil {
		return m.NominatedNodeName
	}
	return ""
}

func (m *Pod) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *Pod) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

func (m *Pod) GetRestartCount() int32 {
	if m != nil {
		return m.RestartCount
	}
	return 0
}

func (m *Pod) GetContainerStatuses() []*ContainerStatus {
	if m != nil {
		return m.ContainerStatuses
	}
	return nil
}

func (m *Pod) GetInitContainerStatuses() []*ContainerStatus {
	if m != nil {
		return m.InitContainerStatuses
	}
	return nil
}

func (m *Pod) GetConditionMessage() string {
	if m != nil {
		return m.ConditionMessage
	}
	return ""
}

func (m *Pod) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

// Deprecated: Do not use.
func (m *Pod) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Pod) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Pod) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *Pod) GetResourceRequirements() []*ResourceRequirements {
	if m != nil {
		return m.ResourceRequirements
	}
	return nil
}

func (m *Pod) GetQOSClass() string {
	if m != nil {
		return m.QOSClass
	}
	return ""
}

func (m *Pod) GetPriorityClass() string {
	if m != nil {
		return m.PriorityClass
	}
	return ""
}

func (m *Pod) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *Pod) GetStartTime() int64 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *Pod) GetScheduledTime() int64 {
	if m != nil {
		return m.ScheduledTime
	}
	return 0
}

func (m *Pod) GetConditions() []*PodCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *Pod) GetNodeAffinity() *NodeAffinity {
	if m != nil {
		return m.NodeAffinity
	}
	return nil
}

type PodCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastProbeTime      int64  `protobuf:"varint,3,opt,name=lastProbeTime,proto3" json:"lastProbeTime,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,4,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,5,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *PodCondition) Reset()         { *m = PodCondition{} }
func (m *PodCondition) String() string { return proto.CompactTextString(m) }
func (*PodCondition) ProtoMessage()    {}
func (*PodCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{94}
}
func (m *PodCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodCondition.Merge(m, src)
}
func (m *PodCondition) XXX_Size() int {
	return m.Size()
}
func (m *PodCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_PodCondition.DiscardUnknown(m)
}

var xxx_messageInfo_PodCondition proto.InternalMessageInfo

func (m *PodCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *PodCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *PodCondition) GetLastProbeTime() int64 {
	if m != nil {
		return m.LastProbeTime
	}
	return 0
}

func (m *PodCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *PodCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *PodCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type ContainerStatus struct {
	Name         string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ContainerID  string `protobuf:"bytes,2,opt,name=containerID,proto3" json:"containerID,omitempty"`
	Ready        bool   `protobuf:"varint,3,opt,name=ready,proto3" json:"ready,omitempty"`
	RestartCount int32  `protobuf:"varint,4,opt,name=restartCount,proto3" json:"restartCount,omitempty"`
	State        string `protobuf:"bytes,5,opt,name=state,proto3" json:"state,omitempty"`
	Message      string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	Image        string `protobuf:"bytes,7,opt,name=image,proto3" json:"image,omitempty"`
	ImageID      string `protobuf:"bytes,8,opt,name=imageID,proto3" json:"imageID,omitempty"`
}

func (m *ContainerStatus) Reset()         { *m = ContainerStatus{} }
func (m *ContainerStatus) String() string { return proto.CompactTextString(m) }
func (*ContainerStatus) ProtoMessage()    {}
func (*ContainerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{95}
}
func (m *ContainerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatus.Merge(m, src)
}
func (m *ContainerStatus) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatus proto.InternalMessageInfo

func (m *ContainerStatus) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ContainerStatus) GetContainerID() string {
	if m != nil {
		return m.ContainerID
	}
	return ""
}

func (m *ContainerStatus) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *ContainerStatus) GetRestartCount() int32 {
	if m != nil {
		return m.RestartCount
	}
	return 0
}

func (m *ContainerStatus) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *ContainerStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ContainerStatus) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *ContainerStatus) GetImageID() string {
	if m != nil {
		return m.ImageID
	}
	return ""
}

type NodeAffinity struct {
	RequiredDuringSchedulingIgnoredDuringExecution  *NodeSelector              `protobuf:"bytes,1,opt,name=requiredDuringSchedulingIgnoredDuringExecution,proto3" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	PreferredDuringSchedulingIgnoredDuringExecution []*PreferredSchedulingTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution,proto3" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
}

func (m *NodeAffinity) Reset()         { *m = NodeAffinity{} }
func (m *NodeAffinity) String() string { return proto.CompactTextString(m) }
func (*NodeAffinity) ProtoMessage()    {}
func (*NodeAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{96}
}
func (m *NodeAffinity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeAffinity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeAffinity.Merge(m, src)
}
func (m *NodeAffinity) XXX_Size() int {
	return m.Size()
}
func (m *NodeAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_NodeAffinity proto.InternalMessageInfo

func (m *NodeAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() *NodeSelector {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *NodeAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*PreferredSchedulingTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

type NodeSelector struct {
	NodeSelectorTerms []*NodeSelectorTerm `protobuf:"bytes,1,rep,name=nodeSelectorTerms,proto3" json:"nodeSelectorTerms,omitempty"`
}

func (m *NodeSelector) Reset()         { *m = NodeSelector{} }
func (m *NodeSelector) String() string { return proto.CompactTextString(m) }
func (*NodeSelector) ProtoMessage()    {}
func (*NodeSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{97}
}
func (m *NodeSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelector.Merge(m, src)
}
func (m *NodeSelector) XXX_Size() int {
	return m.Size()
}
func (m *NodeSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelector.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelector proto.InternalMessageInfo

func (m *NodeSelector) GetNodeSelectorTerms() []*NodeSelectorTerm {
	if m != nil {
		return m.NodeSelectorTerms
	}
	return nil
}

type PreferredSchedulingTerm struct {
	Weight     int32             `protobuf:"varint,1,opt,name=weight,proto3" json:"weight,omitempty"`
	Preference *NodeSelectorTerm `protobuf:"bytes,2,opt,name=preference,proto3" json:"preference,omitempty"`
}

func (m *PreferredSchedulingTerm) Reset()         { *m = PreferredSchedulingTerm{} }
func (m *PreferredSchedulingTerm) String() string { return proto.CompactTextString(m) }
func (*PreferredSchedulingTerm) ProtoMessage()    {}
func (*PreferredSchedulingTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{98}
}
func (m *PreferredSchedulingTerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PreferredSchedulingTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PreferredSchedulingTerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PreferredSchedulingTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreferredSchedulingTerm.Merge(m, src)
}
func (m *PreferredSchedulingTerm) XXX_Size() int {
	return m.Size()
}
func (m *PreferredSchedulingTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_PreferredSchedulingTerm.DiscardUnknown(m)
}

var xxx_messageInfo_PreferredSchedulingTerm proto.InternalMessageInfo

func (m *PreferredSchedulingTerm) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *PreferredSchedulingTerm) GetPreference() *NodeSelectorTerm {
	if m != nil {
		return m.Preference
	}
	return nil
}

type Manifest struct {
	Type            int32    `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	ResourceVersion string   `protobuf:"bytes,2,opt,name=resourceVersion,proto3" json:"resourceVersion,omitempty"`
	Uid             string   `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	Content         []byte   `protobuf:"bytes,4,opt,name=content,proto3" json:"content,omitempty"`
	ContentType     string   `protobuf:"bytes,5,opt,name=contentType,proto3" json:"contentType,omitempty"`
	Version         string   `protobuf:"bytes,6,opt,name=version,proto3" json:"version,omitempty"`
	Tags            []string `protobuf:"bytes,7,rep,name=tags,proto3" json:"tags,omitempty"`
	IsTerminated    bool     `protobuf:"varint,8,opt,name=isTerminated,proto3" json:"isTerminated,omitempty"`
	ApiVersion      string   `protobuf:"bytes,9,opt,name=apiVersion,proto3" json:"apiVersion,omitempty"`
	NodeName        string   `protobuf:"bytes,10,opt,name=nodeName,proto3" json:"nodeName,omitempty"`
	Kind            string   `protobuf:"bytes,11,opt,name=kind,proto3" json:"kind,omitempty"`
	Host            *Host    `protobuf:"bytes,12,opt,name=host,proto3" json:"host,omitempty"`
}

func (m *Manifest) Reset()         { *m = Manifest{} }
func (m *Manifest) String() string { return proto.CompactTextString(m) }
func (*Manifest) ProtoMessage()    {}
func (*Manifest) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{99}
}
func (m *Manifest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Manifest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Manifest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Manifest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Manifest.Merge(m, src)
}
func (m *Manifest) XXX_Size() int {
	return m.Size()
}
func (m *Manifest) XXX_DiscardUnknown() {
	xxx_messageInfo_Manifest.DiscardUnknown(m)
}

var xxx_messageInfo_Manifest proto.InternalMessageInfo

func (m *Manifest) GetType() int32 {
	if m != nil {
		return m.Type
	}
	return 0
}

func (m *Manifest) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

func (m *Manifest) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *Manifest) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Manifest) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Manifest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Manifest) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Manifest) GetIsTerminated() bool {
	if m != nil {
		return m.IsTerminated
	}
	return false
}

func (m *Manifest) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *Manifest) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *Manifest) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Manifest) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2054
type NamespaceCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *NamespaceCondition) Reset()         { *m = NamespaceCondition{} }
func (m *NamespaceCondition) String() string { return proto.CompactTextString(m) }
func (*NamespaceCondition) ProtoMessage()    {}
func (*NamespaceCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{100}
}
func (m *NamespaceCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceCondition.Merge(m, src)
}
func (m *NamespaceCondition) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceCondition.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceCondition proto.InternalMessageInfo

func (m *NamespaceCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *NamespaceCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *NamespaceCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *NamespaceCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *NamespaceCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L2036
type Namespace struct {
	Metadata         *Metadata             `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Status           string                `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	ConditionMessage string                `protobuf:"bytes,3,opt,name=conditionMessage,proto3" json:"conditionMessage,omitempty"`
	Yaml             []byte                `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags             []string              `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Conditions       []*NamespaceCondition `protobuf:"bytes,6,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *Namespace) Reset()         { *m = Namespace{} }
func (m *Namespace) String() string { return proto.CompactTextString(m) }
func (*Namespace) ProtoMessage()    {}
func (*Namespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{101}
}
func (m *Namespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Namespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Namespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Namespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Namespace.Merge(m, src)
}
func (m *Namespace) XXX_Size() int {
	return m.Size()
}
func (m *Namespace) XXX_DiscardUnknown() {
	xxx_messageInfo_Namespace.DiscardUnknown(m)
}

var xxx_messageInfo_Namespace proto.InternalMessageInfo

func (m *Namespace) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Namespace) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Namespace) GetConditionMessage() string {
	if m != nil {
		return m.ConditionMessage
	}
	return ""
}

// Deprecated: Do not use.
func (m *Namespace) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Namespace) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Namespace) GetConditions() []*NamespaceCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// https://github.com/kubernetes/kubernetes/blob/4112d8db20c5550cc27d30d3cee2723db0f8e1c4/staging/src/k8s.io/api/core/v1/types.go#L2097
// Using smallest possible quantity levels.
// For memory it is bytes, for CPU it is millicore.
type ResourceRequirements struct {
	// Limits describes the maximum amount of compute resources allowed.
	// Key/Value of a resource type and a corresponding quantity as an int64.
	Limits map[string]int64 `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Requests describes the minimum amount of compute resources required.
	// Key/Value of a resource type and a corresponding quantity as an int64.
	Requests map[string]int64 `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Name describes the name of the holder of the resource requirements (e.g. a container name).
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// ResourceRequirementsType describes the type which uses the ResourceRequirements.
	Type ResourceRequirementsType `protobuf:"varint,4,opt,name=type,proto3,enum=datadog.process_agent.ResourceRequirementsType" json:"type,omitempty"`
}

func (m *ResourceRequirements) Reset()         { *m = ResourceRequirements{} }
func (m *ResourceRequirements) String() string { return proto.CompactTextString(m) }
func (*ResourceRequirements) ProtoMessage()    {}
func (*ResourceRequirements) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{102}
}
func (m *ResourceRequirements) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceRequirements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceRequirements.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceRequirements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceRequirements.Merge(m, src)
}
func (m *ResourceRequirements) XXX_Size() int {
	return m.Size()
}
func (m *ResourceRequirements) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceRequirements.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceRequirements proto.InternalMessageInfo

func (m *ResourceRequirements) GetLimits() map[string]int64 {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *ResourceRequirements) GetRequests() map[string]int64 {
	if m != nil {
		return m.Requests
	}
	return nil
}

func (m *ResourceRequirements) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ResourceRequirements) GetType() ResourceRequirementsType {
	if m != nil {
		return m.Type
	}
	return ResourceRequirementsType_unknownType
}

// ResourceMetrics is used in backend enrichment.
type ResourceMetrics struct {
	MetricValues map[string]float64 `protobuf:"bytes,1,rep,name=metricValues,proto3" json:"metricValues,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
}

func (m *ResourceMetrics) Reset()         { *m = ResourceMetrics{} }
func (m *ResourceMetrics) String() string { return proto.CompactTextString(m) }
func (*ResourceMetrics) ProtoMessage()    {}
func (*ResourceMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{103}
}
func (m *ResourceMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetrics.Merge(m, src)
}
func (m *ResourceMetrics) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetrics proto.InternalMessageInfo

func (m *ResourceMetrics) GetMetricValues() map[string]float64 {
	if m != nil {
		return m.MetricValues
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/batch/v1/types.go#L61
type JobSpec struct {
	Parallelism           int32                       `protobuf:"varint,1,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	Completions           int32                       `protobuf:"varint,2,opt,name=completions,proto3" json:"completions,omitempty"`
	ActiveDeadlineSeconds int64                       `protobuf:"varint,3,opt,name=activeDeadlineSeconds,proto3" json:"activeDeadlineSeconds,omitempty"`
	BackoffLimit          int32                       `protobuf:"varint,4,opt,name=backoffLimit,proto3" json:"backoffLimit,omitempty"`
	Selectors             []*LabelSelectorRequirement `protobuf:"bytes,5,rep,name=selectors,proto3" json:"selectors,omitempty"`
	ManualSelector        bool                        `protobuf:"varint,6,opt,name=manualSelector,proto3" json:"manualSelector,omitempty"`
	ResourceRequirements  []*ResourceRequirements     `protobuf:"bytes,7,rep,name=resourceRequirements,proto3" json:"resourceRequirements,omitempty"`
}

func (m *JobSpec) Reset()         { *m = JobSpec{} }
func (m *JobSpec) String() string { return proto.CompactTextString(m) }
func (*JobSpec) ProtoMessage()    {}
func (*JobSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{104}
}
func (m *JobSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JobSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JobSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JobSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobSpec.Merge(m, src)
}
func (m *JobSpec) XXX_Size() int {
	return m.Size()
}
func (m *JobSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_JobSpec.DiscardUnknown(m)
}

var xxx_messageInfo_JobSpec proto.InternalMessageInfo

func (m *JobSpec) GetParallelism() int32 {
	if m != nil {
		return m.Parallelism
	}
	return 0
}

func (m *JobSpec) GetCompletions() int32 {
	if m != nil {
		return m.Completions
	}
	return 0
}

func (m *JobSpec) GetActiveDeadlineSeconds() int64 {
	if m != nil {
		return m.ActiveDeadlineSeconds
	}
	return 0
}

func (m *JobSpec) GetBackoffLimit() int32 {
	if m != nil {
		return m.BackoffLimit
	}
	return 0
}

func (m *JobSpec) GetSelectors() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selectors
	}
	return nil
}

func (m *JobSpec) GetManualSelector() bool {
	if m != nil {
		return m.ManualSelector
	}
	return false
}

func (m *JobSpec) GetResourceRequirements() []*ResourceRequirements {
	if m != nil {
		return m.ResourceRequirements
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/batch/v1/types.go#L132
type JobStatus struct {
	ConditionMessage string `protobuf:"bytes,1,opt,name=conditionMessage,proto3" json:"conditionMessage,omitempty"`
	StartTime        int64  `protobuf:"varint,2,opt,name=startTime,proto3" json:"startTime,omitempty"`
	CompletionTime   int64  `protobuf:"varint,3,opt,name=completionTime,proto3" json:"completionTime,omitempty"`
	Active           int32  `protobuf:"varint,4,opt,name=active,proto3" json:"active,omitempty"`
	Succeeded        int32  `protobuf:"varint,5,opt,name=succeeded,proto3" json:"succeeded,omitempty"`
	Failed           int32  `protobuf:"varint,6,opt,name=failed,proto3" json:"failed,omitempty"`
}

func (m *JobStatus) Reset()         { *m = JobStatus{} }
func (m *JobStatus) String() string { return proto.CompactTextString(m) }
func (*JobStatus) ProtoMessage()    {}
func (*JobStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{105}
}
func (m *JobStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JobStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JobStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JobStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobStatus.Merge(m, src)
}
func (m *JobStatus) XXX_Size() int {
	return m.Size()
}
func (m *JobStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_JobStatus.DiscardUnknown(m)
}

var xxx_messageInfo_JobStatus proto.InternalMessageInfo

func (m *JobStatus) GetConditionMessage() string {
	if m != nil {
		return m.ConditionMessage
	}
	return ""
}

func (m *JobStatus) GetStartTime() int64 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *JobStatus) GetCompletionTime() int64 {
	if m != nil {
		return m.CompletionTime
	}
	return 0
}

func (m *JobStatus) GetActive() int32 {
	if m != nil {
		return m.Active
	}
	return 0
}

func (m *JobStatus) GetSucceeded() int32 {
	if m != nil {
		return m.Succeeded
	}
	return 0
}

func (m *JobStatus) GetFailed() int32 {
	if m != nil {
		return m.Failed
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/batch/v1/generated.proto#L51
type JobCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastProbeTime      int64  `protobuf:"varint,3,opt,name=lastProbeTime,proto3" json:"lastProbeTime,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,4,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,5,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *JobCondition) Reset()         { *m = JobCondition{} }
func (m *JobCondition) String() string { return proto.CompactTextString(m) }
func (*JobCondition) ProtoMessage()    {}
func (*JobCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{106}
}
func (m *JobCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JobCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JobCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JobCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobCondition.Merge(m, src)
}
func (m *JobCondition) XXX_Size() int {
	return m.Size()
}
func (m *JobCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_JobCondition.DiscardUnknown(m)
}

var xxx_messageInfo_JobCondition proto.InternalMessageInfo

func (m *JobCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *JobCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *JobCondition) GetLastProbeTime() int64 {
	if m != nil {
		return m.LastProbeTime
	}
	return 0
}

func (m *JobCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *JobCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *JobCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/batch/v1/types.go#L28
type Job struct {
	Metadata   *Metadata       `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec       *JobSpec        `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status     *JobStatus      `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml       []byte          `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags       []string        `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Conditions []*JobCondition `protobuf:"bytes,6,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *Job) Reset()         { *m = Job{} }
func (m *Job) String() string { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()    {}
func (*Job) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{107}
}
func (m *Job) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Job) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Job.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Job) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Job.Merge(m, src)
}
func (m *Job) XXX_Size() int {
	return m.Size()
}
func (m *Job) XXX_DiscardUnknown() {
	xxx_messageInfo_Job.DiscardUnknown(m)
}

var xxx_messageInfo_Job proto.InternalMessageInfo

func (m *Job) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Job) GetSpec() *JobSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Job) GetStatus() *JobStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *Job) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Job) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Job) GetConditions() []*JobCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/batch/v1beta1/types.go#L92
type CronJobSpec struct {
	Schedule                   string                  `protobuf:"bytes,1,opt,name=schedule,proto3" json:"schedule,omitempty"`
	StartingDeadlineSeconds    int64                   `protobuf:"varint,2,opt,name=startingDeadlineSeconds,proto3" json:"startingDeadlineSeconds,omitempty"`
	ConcurrencyPolicy          string                  `protobuf:"bytes,3,opt,name=concurrencyPolicy,proto3" json:"concurrencyPolicy,omitempty"`
	Suspend                    bool                    `protobuf:"varint,4,opt,name=suspend,proto3" json:"suspend,omitempty"`
	SuccessfulJobsHistoryLimit int32                   `protobuf:"varint,5,opt,name=successfulJobsHistoryLimit,proto3" json:"successfulJobsHistoryLimit,omitempty"`
	FailedJobsHistoryLimit     int32                   `protobuf:"varint,6,opt,name=failedJobsHistoryLimit,proto3" json:"failedJobsHistoryLimit,omitempty"`
	ResourceRequirements       []*ResourceRequirements `protobuf:"bytes,7,rep,name=resourceRequirements,proto3" json:"resourceRequirements,omitempty"`
	TimeZone                   string                  `protobuf:"bytes,8,opt,name=timeZone,proto3" json:"timeZone,omitempty"`
}

func (m *CronJobSpec) Reset()         { *m = CronJobSpec{} }
func (m *CronJobSpec) String() string { return proto.CompactTextString(m) }
func (*CronJobSpec) ProtoMessage()    {}
func (*CronJobSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{108}
}
func (m *CronJobSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CronJobSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CronJobSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CronJobSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CronJobSpec.Merge(m, src)
}
func (m *CronJobSpec) XXX_Size() int {
	return m.Size()
}
func (m *CronJobSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CronJobSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CronJobSpec proto.InternalMessageInfo

func (m *CronJobSpec) GetSchedule() string {
	if m != nil {
		return m.Schedule
	}
	return ""
}

func (m *CronJobSpec) GetStartingDeadlineSeconds() int64 {
	if m != nil {
		return m.StartingDeadlineSeconds
	}
	return 0
}

func (m *CronJobSpec) GetConcurrencyPolicy() string {
	if m != nil {
		return m.ConcurrencyPolicy
	}
	return ""
}

func (m *CronJobSpec) GetSuspend() bool {
	if m != nil {
		return m.Suspend
	}
	return false
}

func (m *CronJobSpec) GetSuccessfulJobsHistoryLimit() int32 {
	if m != nil {
		return m.SuccessfulJobsHistoryLimit
	}
	return 0
}

func (m *CronJobSpec) GetFailedJobsHistoryLimit() int32 {
	if m != nil {
		return m.FailedJobsHistoryLimit
	}
	return 0
}

func (m *CronJobSpec) GetResourceRequirements() []*ResourceRequirements {
	if m != nil {
		return m.ResourceRequirements
	}
	return nil
}

func (m *CronJobSpec) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/batch/v1beta1/types.go#L150
type CronJobStatus struct {
	Active             []*ObjectReference `protobuf:"bytes,1,rep,name=active,proto3" json:"active,omitempty"`
	LastScheduleTime   int64              `protobuf:"varint,2,opt,name=lastScheduleTime,proto3" json:"lastScheduleTime,omitempty"`
	LastSuccessfulTime int64              `protobuf:"varint,3,opt,name=lastSuccessfulTime,proto3" json:"lastSuccessfulTime,omitempty"`
}

func (m *CronJobStatus) Reset()         { *m = CronJobStatus{} }
func (m *CronJobStatus) String() string { return proto.CompactTextString(m) }
func (*CronJobStatus) ProtoMessage()    {}
func (*CronJobStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{109}
}
func (m *CronJobStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CronJobStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CronJobStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CronJobStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CronJobStatus.Merge(m, src)
}
func (m *CronJobStatus) XXX_Size() int {
	return m.Size()
}
func (m *CronJobStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_CronJobStatus.DiscardUnknown(m)
}

var xxx_messageInfo_CronJobStatus proto.InternalMessageInfo

func (m *CronJobStatus) GetActive() []*ObjectReference {
	if m != nil {
		return m.Active
	}
	return nil
}

func (m *CronJobStatus) GetLastScheduleTime() int64 {
	if m != nil {
		return m.LastScheduleTime
	}
	return 0
}

func (m *CronJobStatus) GetLastSuccessfulTime() int64 {
	if m != nil {
		return m.LastSuccessfulTime
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/batch/v1beta1/types.go#L58
type CronJob struct {
	Metadata *Metadata      `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec     *CronJobSpec   `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status   *CronJobStatus `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml     []byte         `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string       `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *CronJob) Reset()         { *m = CronJob{} }
func (m *CronJob) String() string { return proto.CompactTextString(m) }
func (*CronJob) ProtoMessage()    {}
func (*CronJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{110}
}
func (m *CronJob) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CronJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CronJob.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CronJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CronJob.Merge(m, src)
}
func (m *CronJob) XXX_Size() int {
	return m.Size()
}
func (m *CronJob) XXX_DiscardUnknown() {
	xxx_messageInfo_CronJob.DiscardUnknown(m)
}

var xxx_messageInfo_CronJob proto.InternalMessageInfo

func (m *CronJob) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *CronJob) GetSpec() *CronJobSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *CronJob) GetStatus() *CronJobStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *CronJob) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *CronJob) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L119
type DaemonSetSpec struct {
	Selectors            []*LabelSelectorRequirement `protobuf:"bytes,1,rep,name=selectors,proto3" json:"selectors,omitempty"`
	DeploymentStrategy   string                      `protobuf:"bytes,2,opt,name=deploymentStrategy,proto3" json:"deploymentStrategy,omitempty"`
	MaxUnavailable       string                      `protobuf:"bytes,3,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	MinReadySeconds      int32                       `protobuf:"varint,4,opt,name=minReadySeconds,proto3" json:"minReadySeconds,omitempty"`
	RevisionHistoryLimit int32                       `protobuf:"varint,5,opt,name=revisionHistoryLimit,proto3" json:"revisionHistoryLimit,omitempty"`
	ResourceRequirements []*ResourceRequirements     `protobuf:"bytes,6,rep,name=resourceRequirements,proto3" json:"resourceRequirements,omitempty"`
}

func (m *DaemonSetSpec) Reset()         { *m = DaemonSetSpec{} }
func (m *DaemonSetSpec) String() string { return proto.CompactTextString(m) }
func (*DaemonSetSpec) ProtoMessage()    {}
func (*DaemonSetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{111}
}
func (m *DaemonSetSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DaemonSetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DaemonSetSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DaemonSetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DaemonSetSpec.Merge(m, src)
}
func (m *DaemonSetSpec) XXX_Size() int {
	return m.Size()
}
func (m *DaemonSetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_DaemonSetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_DaemonSetSpec proto.InternalMessageInfo

func (m *DaemonSetSpec) GetSelectors() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selectors
	}
	return nil
}

func (m *DaemonSetSpec) GetDeploymentStrategy() string {
	if m != nil {
		return m.DeploymentStrategy
	}
	return ""
}

func (m *DaemonSetSpec) GetMaxUnavailable() string {
	if m != nil {
		return m.MaxUnavailable
	}
	return ""
}

func (m *DaemonSetSpec) GetMinReadySeconds() int32 {
	if m != nil {
		return m.MinReadySeconds
	}
	return 0
}

func (m *DaemonSetSpec) GetRevisionHistoryLimit() int32 {
	if m != nil {
		return m.RevisionHistoryLimit
	}
	return 0
}

func (m *DaemonSetSpec) GetResourceRequirements() []*ResourceRequirements {
	if m != nil {
		return m.ResourceRequirements
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L152
type DaemonSetStatus struct {
	CurrentNumberScheduled int32 `protobuf:"varint,1,opt,name=currentNumberScheduled,proto3" json:"currentNumberScheduled,omitempty"`
	NumberMisscheduled     int32 `protobuf:"varint,2,opt,name=numberMisscheduled,proto3" json:"numberMisscheduled,omitempty"`
	DesiredNumberScheduled int32 `protobuf:"varint,3,opt,name=desiredNumberScheduled,proto3" json:"desiredNumberScheduled,omitempty"`
	NumberReady            int32 `protobuf:"varint,4,opt,name=numberReady,proto3" json:"numberReady,omitempty"`
	UpdatedNumberScheduled int32 `protobuf:"varint,6,opt,name=updatedNumberScheduled,proto3" json:"updatedNumberScheduled,omitempty"`
	NumberAvailable        int32 `protobuf:"varint,7,opt,name=numberAvailable,proto3" json:"numberAvailable,omitempty"`
	NumberUnavailable      int32 `protobuf:"varint,8,opt,name=numberUnavailable,proto3" json:"numberUnavailable,omitempty"`
}

func (m *DaemonSetStatus) Reset()         { *m = DaemonSetStatus{} }
func (m *DaemonSetStatus) String() string { return proto.CompactTextString(m) }
func (*DaemonSetStatus) ProtoMessage()    {}
func (*DaemonSetStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{112}
}
func (m *DaemonSetStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DaemonSetStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DaemonSetStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DaemonSetStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DaemonSetStatus.Merge(m, src)
}
func (m *DaemonSetStatus) XXX_Size() int {
	return m.Size()
}
func (m *DaemonSetStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_DaemonSetStatus.DiscardUnknown(m)
}

var xxx_messageInfo_DaemonSetStatus proto.InternalMessageInfo

func (m *DaemonSetStatus) GetCurrentNumberScheduled() int32 {
	if m != nil {
		return m.CurrentNumberScheduled
	}
	return 0
}

func (m *DaemonSetStatus) GetNumberMisscheduled() int32 {
	if m != nil {
		return m.NumberMisscheduled
	}
	return 0
}

func (m *DaemonSetStatus) GetDesiredNumberScheduled() int32 {
	if m != nil {
		return m.DesiredNumberScheduled
	}
	return 0
}

func (m *DaemonSetStatus) GetNumberReady() int32 {
	if m != nil {
		return m.NumberReady
	}
	return 0
}

func (m *DaemonSetStatus) GetUpdatedNumberScheduled() int32 {
	if m != nil {
		return m.UpdatedNumberScheduled
	}
	return 0
}

func (m *DaemonSetStatus) GetNumberAvailable() int32 {
	if m != nil {
		return m.NumberAvailable
	}
	return 0
}

func (m *DaemonSetStatus) GetNumberUnavailable() int32 {
	if m != nil {
		return m.NumberUnavailable
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L87
type DaemonSetCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *DaemonSetCondition) Reset()         { *m = DaemonSetCondition{} }
func (m *DaemonSetCondition) String() string { return proto.CompactTextString(m) }
func (*DaemonSetCondition) ProtoMessage()    {}
func (*DaemonSetCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{113}
}
func (m *DaemonSetCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DaemonSetCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DaemonSetCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DaemonSetCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DaemonSetCondition.Merge(m, src)
}
func (m *DaemonSetCondition) XXX_Size() int {
	return m.Size()
}
func (m *DaemonSetCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_DaemonSetCondition.DiscardUnknown(m)
}

var xxx_messageInfo_DaemonSetCondition proto.InternalMessageInfo

func (m *DaemonSetCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DaemonSetCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DaemonSetCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *DaemonSetCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *DaemonSetCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L66
type DaemonSet struct {
	Metadata   *Metadata             `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec       *DaemonSetSpec        `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status     *DaemonSetStatus      `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml       []byte                `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags       []string              `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Metrics    *ResourceMetrics      `protobuf:"bytes,6,opt,name=metrics,proto3" json:"metrics,omitempty"`
	Conditions []*DaemonSetCondition `protobuf:"bytes,7,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *DaemonSet) Reset()         { *m = DaemonSet{} }
func (m *DaemonSet) String() string { return proto.CompactTextString(m) }
func (*DaemonSet) ProtoMessage()    {}
func (*DaemonSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{114}
}
func (m *DaemonSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DaemonSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DaemonSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DaemonSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DaemonSet.Merge(m, src)
}
func (m *DaemonSet) XXX_Size() int {
	return m.Size()
}
func (m *DaemonSet) XXX_DiscardUnknown() {
	xxx_messageInfo_DaemonSet.DiscardUnknown(m)
}

var xxx_messageInfo_DaemonSet proto.InternalMessageInfo

func (m *DaemonSet) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *DaemonSet) GetSpec() *DaemonSetSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *DaemonSet) GetStatus() *DaemonSetStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *DaemonSet) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *DaemonSet) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *DaemonSet) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *DaemonSet) GetConditions() []*DaemonSetCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L586
type StatefulSetSpec struct {
	DesiredReplicas      int32                       `protobuf:"varint,1,opt,name=desiredReplicas,proto3" json:"desiredReplicas,omitempty"`
	Selectors            []*LabelSelectorRequirement `protobuf:"bytes,2,rep,name=selectors,proto3" json:"selectors,omitempty"`
	ServiceName          string                      `protobuf:"bytes,3,opt,name=serviceName,proto3" json:"serviceName,omitempty"`
	PodManagementPolicy  string                      `protobuf:"bytes,4,opt,name=podManagementPolicy,proto3" json:"podManagementPolicy,omitempty"`
	UpdateStrategy       string                      `protobuf:"bytes,5,opt,name=updateStrategy,proto3" json:"updateStrategy,omitempty"`
	Partition            int32                       `protobuf:"varint,6,opt,name=partition,proto3" json:"partition,omitempty"`
	ResourceRequirements []*ResourceRequirements     `protobuf:"bytes,7,rep,name=resourceRequirements,proto3" json:"resourceRequirements,omitempty"`
}

func (m *StatefulSetSpec) Reset()         { *m = StatefulSetSpec{} }
func (m *StatefulSetSpec) String() string { return proto.CompactTextString(m) }
func (*StatefulSetSpec) ProtoMessage()    {}
func (*StatefulSetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{115}
}
func (m *StatefulSetSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatefulSetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatefulSetSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatefulSetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatefulSetSpec.Merge(m, src)
}
func (m *StatefulSetSpec) XXX_Size() int {
	return m.Size()
}
func (m *StatefulSetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_StatefulSetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_StatefulSetSpec proto.InternalMessageInfo

func (m *StatefulSetSpec) GetDesiredReplicas() int32 {
	if m != nil {
		return m.DesiredReplicas
	}
	return 0
}

func (m *StatefulSetSpec) GetSelectors() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selectors
	}
	return nil
}

func (m *StatefulSetSpec) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *StatefulSetSpec) GetPodManagementPolicy() string {
	if m != nil {
		return m.PodManagementPolicy
	}
	return ""
}

func (m *StatefulSetSpec) GetUpdateStrategy() string {
	if m != nil {
		return m.UpdateStrategy
	}
	return ""
}

func (m *StatefulSetSpec) GetPartition() int32 {
	if m != nil {
		return m.Partition
	}
	return 0
}

func (m *StatefulSetSpec) GetResourceRequirements() []*ResourceRequirements {
	if m != nil {
		return m.ResourceRequirements
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L647
type StatefulSetStatus struct {
	Replicas        int32 `protobuf:"varint,1,opt,name=replicas,proto3" json:"replicas,omitempty"`
	ReadyReplicas   int32 `protobuf:"varint,2,opt,name=readyReplicas,proto3" json:"readyReplicas,omitempty"`
	CurrentReplicas int32 `protobuf:"varint,3,opt,name=currentReplicas,proto3" json:"currentReplicas,omitempty"`
	UpdatedReplicas int32 `protobuf:"varint,4,opt,name=updatedReplicas,proto3" json:"updatedReplicas,omitempty"`
}

func (m *StatefulSetStatus) Reset()         { *m = StatefulSetStatus{} }
func (m *StatefulSetStatus) String() string { return proto.CompactTextString(m) }
func (*StatefulSetStatus) ProtoMessage()    {}
func (*StatefulSetStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{116}
}
func (m *StatefulSetStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatefulSetStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatefulSetStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatefulSetStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatefulSetStatus.Merge(m, src)
}
func (m *StatefulSetStatus) XXX_Size() int {
	return m.Size()
}
func (m *StatefulSetStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_StatefulSetStatus.DiscardUnknown(m)
}

var xxx_messageInfo_StatefulSetStatus proto.InternalMessageInfo

func (m *StatefulSetStatus) GetReplicas() int32 {
	if m != nil {
		return m.Replicas
	}
	return 0
}

func (m *StatefulSetStatus) GetReadyReplicas() int32 {
	if m != nil {
		return m.ReadyReplicas
	}
	return 0
}

func (m *StatefulSetStatus) GetCurrentReplicas() int32 {
	if m != nil {
		return m.CurrentReplicas
	}
	return 0
}

func (m *StatefulSetStatus) GetUpdatedReplicas() int32 {
	if m != nil {
		return m.UpdatedReplicas
	}
	return 0
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L557
type StatefulSetCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *StatefulSetCondition) Reset()         { *m = StatefulSetCondition{} }
func (m *StatefulSetCondition) String() string { return proto.CompactTextString(m) }
func (*StatefulSetCondition) ProtoMessage()    {}
func (*StatefulSetCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{117}
}
func (m *StatefulSetCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatefulSetCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatefulSetCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatefulSetCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatefulSetCondition.Merge(m, src)
}
func (m *StatefulSetCondition) XXX_Size() int {
	return m.Size()
}
func (m *StatefulSetCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_StatefulSetCondition.DiscardUnknown(m)
}

var xxx_messageInfo_StatefulSetCondition proto.InternalMessageInfo

func (m *StatefulSetCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *StatefulSetCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *StatefulSetCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *StatefulSetCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *StatefulSetCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/apps/v1/generated.proto#L542
type StatefulSet struct {
	Metadata   *Metadata               `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec       *StatefulSetSpec        `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status     *StatefulSetStatus      `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml       []byte                  `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags       []string                `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Metrics    *ResourceMetrics        `protobuf:"bytes,6,opt,name=metrics,proto3" json:"metrics,omitempty"`
	Conditions []*StatefulSetCondition `protobuf:"bytes,7,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *StatefulSet) Reset()         { *m = StatefulSet{} }
func (m *StatefulSet) String() string { return proto.CompactTextString(m) }
func (*StatefulSet) ProtoMessage()    {}
func (*StatefulSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{118}
}
func (m *StatefulSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatefulSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatefulSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatefulSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatefulSet.Merge(m, src)
}
func (m *StatefulSet) XXX_Size() int {
	return m.Size()
}
func (m *StatefulSet) XXX_DiscardUnknown() {
	xxx_messageInfo_StatefulSet.DiscardUnknown(m)
}

var xxx_messageInfo_StatefulSet proto.InternalMessageInfo

func (m *StatefulSet) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *StatefulSet) GetSpec() *StatefulSetSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *StatefulSet) GetStatus() *StatefulSetStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *StatefulSet) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *StatefulSet) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *StatefulSet) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *StatefulSet) GetConditions() []*StatefulSetCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L2576
type PersistentVolume struct {
	Metadata *Metadata               `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec     *PersistentVolumeSpec   `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status   *PersistentVolumeStatus `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml     []byte                  `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string                `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *PersistentVolume) Reset()         { *m = PersistentVolume{} }
func (m *PersistentVolume) String() string { return proto.CompactTextString(m) }
func (*PersistentVolume) ProtoMessage()    {}
func (*PersistentVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{119}
}
func (m *PersistentVolume) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolume.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolume.Merge(m, src)
}
func (m *PersistentVolume) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolume.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolume proto.InternalMessageInfo

func (m *PersistentVolume) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolume) GetSpec() *PersistentVolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PersistentVolume) GetStatus() *PersistentVolumeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *PersistentVolume) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *PersistentVolume) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L2889
type PersistentVolumeSpec struct {
	// Key/Value of a resource type and a corresponding quantity as an int64.
	Capacity map[string]int64 `protobuf:"bytes,1,rep,name=capacity,proto3" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// in kubernetes these are actually fields in a struct where only one can be set.
	// For now we only set it to a string with the name.
	PersistentVolumeType          string                  `protobuf:"bytes,2,opt,name=persistentVolumeType,proto3" json:"persistentVolumeType,omitempty"`
	AccessModes                   []string                `protobuf:"bytes,3,rep,name=accessModes,proto3" json:"accessModes,omitempty"`
	ClaimRef                      *ObjectReference        `protobuf:"bytes,4,opt,name=claimRef,proto3" json:"claimRef,omitempty"`
	PersistentVolumeReclaimPolicy string                  `protobuf:"bytes,5,opt,name=persistentVolumeReclaimPolicy,proto3" json:"persistentVolumeReclaimPolicy,omitempty"`
	StorageClassName              string                  `protobuf:"bytes,6,opt,name=storageClassName,proto3" json:"storageClassName,omitempty"`
	MountOptions                  []string                `protobuf:"bytes,7,rep,name=mountOptions,proto3" json:"mountOptions,omitempty"`
	VolumeMode                    string                  `protobuf:"bytes,8,opt,name=volumeMode,proto3" json:"volumeMode,omitempty"`
	NodeAffinity                  []*NodeSelectorTerm     `protobuf:"bytes,9,rep,name=nodeAffinity,proto3" json:"nodeAffinity,omitempty"`
	PersistentVolumeSource        *PersistentVolumeSource `protobuf:"bytes,10,opt,name=persistentVolumeSource,proto3" json:"persistentVolumeSource,omitempty"`
}

func (m *PersistentVolumeSpec) Reset()         { *m = PersistentVolumeSpec{} }
func (m *PersistentVolumeSpec) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeSpec) ProtoMessage()    {}
func (*PersistentVolumeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{120}
}
func (m *PersistentVolumeSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeSpec.Merge(m, src)
}
func (m *PersistentVolumeSpec) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeSpec proto.InternalMessageInfo

func (m *PersistentVolumeSpec) GetCapacity() map[string]int64 {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *PersistentVolumeSpec) GetPersistentVolumeType() string {
	if m != nil {
		return m.PersistentVolumeType
	}
	return ""
}

func (m *PersistentVolumeSpec) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeSpec) GetClaimRef() *ObjectReference {
	if m != nil {
		return m.ClaimRef
	}
	return nil
}

func (m *PersistentVolumeSpec) GetPersistentVolumeReclaimPolicy() string {
	if m != nil {
		return m.PersistentVolumeReclaimPolicy
	}
	return ""
}

func (m *PersistentVolumeSpec) GetStorageClassName() string {
	if m != nil {
		return m.StorageClassName
	}
	return ""
}

func (m *PersistentVolumeSpec) GetMountOptions() []string {
	if m != nil {
		return m.MountOptions
	}
	return nil
}

func (m *PersistentVolumeSpec) GetVolumeMode() string {
	if m != nil {
		return m.VolumeMode
	}
	return ""
}

func (m *PersistentVolumeSpec) GetNodeAffinity() []*NodeSelectorTerm {
	if m != nil {
		return m.NodeAffinity
	}
	return nil
}

func (m *PersistentVolumeSpec) GetPersistentVolumeSource() *PersistentVolumeSource {
	if m != nil {
		return m.PersistentVolumeSource
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/release-1.27/core/v1/generated.proto#L1722
type PersistentVolumeSource struct {
	GcePersistentDisk    *GCEPersistentDiskVolumeSource    `protobuf:"bytes,1,opt,name=gcePersistentDisk,proto3" json:"gcePersistentDisk,omitempty"`
	AwsElasticBlockStore *AWSElasticBlockStoreVolumeSource `protobuf:"bytes,2,opt,name=awsElasticBlockStore,proto3" json:"awsElasticBlockStore,omitempty"`
	AzureFile            *AzureFilePersistentVolumeSource  `protobuf:"bytes,3,opt,name=azureFile,proto3" json:"azureFile,omitempty"`
	AzureDisk            *AzureDiskVolumeSource            `protobuf:"bytes,4,opt,name=azureDisk,proto3" json:"azureDisk,omitempty"`
	Csi                  *CSIVolumeSource                  `protobuf:"bytes,5,opt,name=csi,proto3" json:"csi,omitempty"`
}

func (m *PersistentVolumeSource) Reset()         { *m = PersistentVolumeSource{} }
func (m *PersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeSource) ProtoMessage()    {}
func (*PersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{121}
}
func (m *PersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeSource.Merge(m, src)
}
func (m *PersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeSource proto.InternalMessageInfo

func (m *PersistentVolumeSource) GetGcePersistentDisk() *GCEPersistentDiskVolumeSource {
	if m != nil {
		return m.GcePersistentDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetAwsElasticBlockStore() *AWSElasticBlockStoreVolumeSource {
	if m != nil {
		return m.AwsElasticBlockStore
	}
	return nil
}

func (m *PersistentVolumeSource) GetAzureFile() *AzureFilePersistentVolumeSource {
	if m != nil {
		return m.AzureFile
	}
	return nil
}

func (m *PersistentVolumeSource) GetAzureDisk() *AzureDiskVolumeSource {
	if m != nil {
		return m.AzureDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetCsi() *CSIVolumeSource {
	if m != nil {
		return m.Csi
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L1616
type GCEPersistentDiskVolumeSource struct {
	PdName    string `protobuf:"bytes,1,opt,name=pdName,proto3" json:"pdName,omitempty"`
	FsType    string `protobuf:"bytes,2,opt,name=fsType,proto3" json:"fsType,omitempty"`
	Partition int32  `protobuf:"varint,3,opt,name=partition,proto3" json:"partition,omitempty"`
	ReadOnly  bool   `protobuf:"varint,4,opt,name=readOnly,proto3" json:"readOnly,omitempty"`
}

func (m *GCEPersistentDiskVolumeSource) Reset()         { *m = GCEPersistentDiskVolumeSource{} }
func (m *GCEPersistentDiskVolumeSource) String() string { return proto.CompactTextString(m) }
func (*GCEPersistentDiskVolumeSource) ProtoMessage()    {}
func (*GCEPersistentDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{122}
}
func (m *GCEPersistentDiskVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCEPersistentDiskVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCEPersistentDiskVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GCEPersistentDiskVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCEPersistentDiskVolumeSource.Merge(m, src)
}
func (m *GCEPersistentDiskVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *GCEPersistentDiskVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GCEPersistentDiskVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_GCEPersistentDiskVolumeSource proto.InternalMessageInfo

func (m *GCEPersistentDiskVolumeSource) GetPdName() string {
	if m != nil {
		return m.PdName
	}
	return ""
}

func (m *GCEPersistentDiskVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *GCEPersistentDiskVolumeSource) GetPartition() int32 {
	if m != nil {
		return m.Partition
	}
	return 0
}

func (m *GCEPersistentDiskVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// reference https://github.com/kubernetes/api/blob/release-1.27/core/v1/generated.proto#L39
type AWSElasticBlockStoreVolumeSource struct {
	VolumeID  string `protobuf:"bytes,1,opt,name=volumeID,proto3" json:"volumeID,omitempty"`
	FsType    string `protobuf:"bytes,2,opt,name=fsType,proto3" json:"fsType,omitempty"`
	Partition int32  `protobuf:"varint,3,opt,name=partition,proto3" json:"partition,omitempty"`
	ReadOnly  bool   `protobuf:"varint,4,opt,name=readOnly,proto3" json:"readOnly,omitempty"`
}

func (m *AWSElasticBlockStoreVolumeSource) Reset()         { *m = AWSElasticBlockStoreVolumeSource{} }
func (m *AWSElasticBlockStoreVolumeSource) String() string { return proto.CompactTextString(m) }
func (*AWSElasticBlockStoreVolumeSource) ProtoMessage()    {}
func (*AWSElasticBlockStoreVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{123}
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AWSElasticBlockStoreVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AWSElasticBlockStoreVolumeSource.Merge(m, src)
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_AWSElasticBlockStoreVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_AWSElasticBlockStoreVolumeSource proto.InternalMessageInfo

func (m *AWSElasticBlockStoreVolumeSource) GetVolumeID() string {
	if m != nil {
		return m.VolumeID
	}
	return ""
}

func (m *AWSElasticBlockStoreVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *AWSElasticBlockStoreVolumeSource) GetPartition() int32 {
	if m != nil {
		return m.Partition
	}
	return 0
}

func (m *AWSElasticBlockStoreVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// reference https://github.com/kubernetes/api/blob/release-1.27/core/v1/generated.proto#L127
type AzureFilePersistentVolumeSource struct {
	SecretName      string `protobuf:"bytes,1,opt,name=secretName,proto3" json:"secretName,omitempty"`
	ShareName       string `protobuf:"bytes,2,opt,name=shareName,proto3" json:"shareName,omitempty"`
	ReadOnly        bool   `protobuf:"varint,3,opt,name=readOnly,proto3" json:"readOnly,omitempty"`
	SecretNamespace string `protobuf:"bytes,4,opt,name=secretNamespace,proto3" json:"secretNamespace,omitempty"`
}

func (m *AzureFilePersistentVolumeSource) Reset()         { *m = AzureFilePersistentVolumeSource{} }
func (m *AzureFilePersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*AzureFilePersistentVolumeSource) ProtoMessage()    {}
func (*AzureFilePersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{124}
}
func (m *AzureFilePersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AzureFilePersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AzureFilePersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AzureFilePersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AzureFilePersistentVolumeSource.Merge(m, src)
}
func (m *AzureFilePersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *AzureFilePersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_AzureFilePersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_AzureFilePersistentVolumeSource proto.InternalMessageInfo

func (m *AzureFilePersistentVolumeSource) GetSecretName() string {
	if m != nil {
		return m.SecretName
	}
	return ""
}

func (m *AzureFilePersistentVolumeSource) GetShareName() string {
	if m != nil {
		return m.ShareName
	}
	return ""
}

func (m *AzureFilePersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *AzureFilePersistentVolumeSource) GetSecretNamespace() string {
	if m != nil {
		return m.SecretNamespace
	}
	return ""
}

// reference https://github.com/kubernetes/api/blob/release-1.27/core/v1/generated.proto#L100
type AzureDiskVolumeSource struct {
	DiskName    string `protobuf:"bytes,1,opt,name=diskName,proto3" json:"diskName,omitempty"`
	DiskURI     string `protobuf:"bytes,2,opt,name=diskURI,proto3" json:"diskURI,omitempty"`
	CachingMode string `protobuf:"bytes,3,opt,name=cachingMode,proto3" json:"cachingMode,omitempty"`
	FsType      string `protobuf:"bytes,4,opt,name=fsType,proto3" json:"fsType,omitempty"`
	ReadOnly    bool   `protobuf:"varint,5,opt,name=readOnly,proto3" json:"readOnly,omitempty"`
	Kind        string `protobuf:"bytes,6,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (m *AzureDiskVolumeSource) Reset()         { *m = AzureDiskVolumeSource{} }
func (m *AzureDiskVolumeSource) String() string { return proto.CompactTextString(m) }
func (*AzureDiskVolumeSource) ProtoMessage()    {}
func (*AzureDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{125}
}
func (m *AzureDiskVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AzureDiskVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AzureDiskVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AzureDiskVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AzureDiskVolumeSource.Merge(m, src)
}
func (m *AzureDiskVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *AzureDiskVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_AzureDiskVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_AzureDiskVolumeSource proto.InternalMessageInfo

func (m *AzureDiskVolumeSource) GetDiskName() string {
	if m != nil {
		return m.DiskName
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetDiskURI() string {
	if m != nil {
		return m.DiskURI
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetCachingMode() string {
	if m != nil {
		return m.CachingMode
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *AzureDiskVolumeSource) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

// reference https://github.com/kubernetes/api/blob/release-1.27/core/v1/generated.proto#L172
type CSIVolumeSource struct {
	Driver                     string            `protobuf:"bytes,1,opt,name=driver,proto3" json:"driver,omitempty"`
	VolumeHandle               string            `protobuf:"bytes,2,opt,name=volumeHandle,proto3" json:"volumeHandle,omitempty"`
	ReadOnly                   bool              `protobuf:"varint,3,opt,name=readOnly,proto3" json:"readOnly,omitempty"`
	FsType                     string            `protobuf:"bytes,4,opt,name=fsType,proto3" json:"fsType,omitempty"`
	VolumeAttributes           map[string]string `protobuf:"bytes,5,rep,name=volumeAttributes,proto3" json:"volumeAttributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ControllerPublishSecretRef *SecretReference  `protobuf:"bytes,6,opt,name=controllerPublishSecretRef,proto3" json:"controllerPublishSecretRef,omitempty"`
	NodeStageSecretRef         *SecretReference  `protobuf:"bytes,7,opt,name=nodeStageSecretRef,proto3" json:"nodeStageSecretRef,omitempty"`
	NodePublishSecretRef       *SecretReference  `protobuf:"bytes,8,opt,name=nodePublishSecretRef,proto3" json:"nodePublishSecretRef,omitempty"`
	ControllerExpandSecretRef  *SecretReference  `protobuf:"bytes,9,opt,name=controllerExpandSecretRef,proto3" json:"controllerExpandSecretRef,omitempty"`
	NodeExpandSecretRef        *SecretReference  `protobuf:"bytes,10,opt,name=nodeExpandSecretRef,proto3" json:"nodeExpandSecretRef,omitempty"`
}

func (m *CSIVolumeSource) Reset()         { *m = CSIVolumeSource{} }
func (m *CSIVolumeSource) String() string { return proto.CompactTextString(m) }
func (*CSIVolumeSource) ProtoMessage()    {}
func (*CSIVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{126}
}
func (m *CSIVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CSIVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CSIVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CSIVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CSIVolumeSource.Merge(m, src)
}
func (m *CSIVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *CSIVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CSIVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_CSIVolumeSource proto.InternalMessageInfo

func (m *CSIVolumeSource) GetDriver() string {
	if m != nil {
		return m.Driver
	}
	return ""
}

func (m *CSIVolumeSource) GetVolumeHandle() string {
	if m != nil {
		return m.VolumeHandle
	}
	return ""
}

func (m *CSIVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *CSIVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *CSIVolumeSource) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

func (m *CSIVolumeSource) GetControllerPublishSecretRef() *SecretReference {
	if m != nil {
		return m.ControllerPublishSecretRef
	}
	return nil
}

func (m *CSIVolumeSource) GetNodeStageSecretRef() *SecretReference {
	if m != nil {
		return m.NodeStageSecretRef
	}
	return nil
}

func (m *CSIVolumeSource) GetNodePublishSecretRef() *SecretReference {
	if m != nil {
		return m.NodePublishSecretRef
	}
	return nil
}

func (m *CSIVolumeSource) GetControllerExpandSecretRef() *SecretReference {
	if m != nil {
		return m.ControllerExpandSecretRef
	}
	return nil
}

func (m *CSIVolumeSource) GetNodeExpandSecretRef() *SecretReference {
	if m != nil {
		return m.NodeExpandSecretRef
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L4553
type SecretReference struct {
	Name      string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (m *SecretReference) Reset()         { *m = SecretReference{} }
func (m *SecretReference) String() string { return proto.CompactTextString(m) }
func (*SecretReference) ProtoMessage()    {}
func (*SecretReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{127}
}
func (m *SecretReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretReference.Merge(m, src)
}
func (m *SecretReference) XXX_Size() int {
	return m.Size()
}
func (m *SecretReference) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretReference.DiscardUnknown(m)
}

var xxx_messageInfo_SecretReference proto.InternalMessageInfo

func (m *SecretReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecretReference) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L2940
type PersistentVolumeStatus struct {
	Phase   string `protobuf:"bytes,1,opt,name=phase,proto3" json:"phase,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Reason  string `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (m *PersistentVolumeStatus) Reset()         { *m = PersistentVolumeStatus{} }
func (m *PersistentVolumeStatus) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeStatus) ProtoMessage()    {}
func (*PersistentVolumeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{128}
}
func (m *PersistentVolumeStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeStatus.Merge(m, src)
}
func (m *PersistentVolumeStatus) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeStatus proto.InternalMessageInfo

func (m *PersistentVolumeStatus) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

func (m *PersistentVolumeStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *PersistentVolumeStatus) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type NodeSelectorTerm struct {
	MatchExpressions []*LabelSelectorRequirement `protobuf:"bytes,1,rep,name=matchExpressions,proto3" json:"matchExpressions,omitempty"`
	MatchFields      []*LabelSelectorRequirement `protobuf:"bytes,2,rep,name=matchFields,proto3" json:"matchFields,omitempty"`
}

func (m *NodeSelectorTerm) Reset()         { *m = NodeSelectorTerm{} }
func (m *NodeSelectorTerm) String() string { return proto.CompactTextString(m) }
func (*NodeSelectorTerm) ProtoMessage()    {}
func (*NodeSelectorTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{129}
}
func (m *NodeSelectorTerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSelectorTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSelectorTerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSelectorTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelectorTerm.Merge(m, src)
}
func (m *NodeSelectorTerm) XXX_Size() int {
	return m.Size()
}
func (m *NodeSelectorTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelectorTerm.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelectorTerm proto.InternalMessageInfo

func (m *NodeSelectorTerm) GetMatchExpressions() []*LabelSelectorRequirement {
	if m != nil {
		return m.MatchExpressions
	}
	return nil
}

func (m *NodeSelectorTerm) GetMatchFields() []*LabelSelectorRequirement {
	if m != nil {
		return m.MatchFields
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L2597
type PersistentVolumeClaim struct {
	Metadata *Metadata                    `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec     *PersistentVolumeClaimSpec   `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status   *PersistentVolumeClaimStatus `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml     []byte                       `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string                     `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *PersistentVolumeClaim) Reset()         { *m = PersistentVolumeClaim{} }
func (m *PersistentVolumeClaim) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaim) ProtoMessage()    {}
func (*PersistentVolumeClaim) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{130}
}
func (m *PersistentVolumeClaim) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaim) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaim.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaim) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaim.Merge(m, src)
}
func (m *PersistentVolumeClaim) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaim) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaim.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaim proto.InternalMessageInfo

func (m *PersistentVolumeClaim) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolumeClaim) GetSpec() *PersistentVolumeClaimSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PersistentVolumeClaim) GetStatus() *PersistentVolumeClaimStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *PersistentVolumeClaim) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *PersistentVolumeClaim) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L2715
type PersistentVolumeClaimStatus struct {
	Phase       string                            `protobuf:"bytes,1,opt,name=phase,proto3" json:"phase,omitempty"`
	AccessModes []string                          `protobuf:"bytes,2,rep,name=accessModes,proto3" json:"accessModes,omitempty"`
	Capacity    map[string]int64                  `protobuf:"bytes,3,rep,name=capacity,proto3" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	Conditions  []*PersistentVolumeClaimCondition `protobuf:"bytes,4,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *PersistentVolumeClaimStatus) Reset()         { *m = PersistentVolumeClaimStatus{} }
func (m *PersistentVolumeClaimStatus) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimStatus) ProtoMessage()    {}
func (*PersistentVolumeClaimStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{131}
}
func (m *PersistentVolumeClaimStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimStatus.Merge(m, src)
}
func (m *PersistentVolumeClaimStatus) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimStatus proto.InternalMessageInfo

func (m *PersistentVolumeClaimStatus) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

func (m *PersistentVolumeClaimStatus) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeClaimStatus) GetCapacity() map[string]int64 {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *PersistentVolumeClaimStatus) GetConditions() []*PersistentVolumeClaimCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L2654
type PersistentVolumeClaimSpec struct {
	AccessModes      []string                    `protobuf:"bytes,1,rep,name=accessModes,proto3" json:"accessModes,omitempty"`
	Resources        *ResourceRequirements       `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	VolumeName       string                      `protobuf:"bytes,3,opt,name=volumeName,proto3" json:"volumeName,omitempty"`
	Selector         []*LabelSelectorRequirement `protobuf:"bytes,4,rep,name=selector,proto3" json:"selector,omitempty"`
	StorageClassName string                      `protobuf:"bytes,5,opt,name=storageClassName,proto3" json:"storageClassName,omitempty"`
	VolumeMode       string                      `protobuf:"bytes,6,opt,name=volumeMode,proto3" json:"volumeMode,omitempty"`
	DataSource       *TypedLocalObjectReference  `protobuf:"bytes,7,opt,name=dataSource,proto3" json:"dataSource,omitempty"`
}

func (m *PersistentVolumeClaimSpec) Reset()         { *m = PersistentVolumeClaimSpec{} }
func (m *PersistentVolumeClaimSpec) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimSpec) ProtoMessage()    {}
func (*PersistentVolumeClaimSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{132}
}
func (m *PersistentVolumeClaimSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimSpec.Merge(m, src)
}
func (m *PersistentVolumeClaimSpec) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimSpec proto.InternalMessageInfo

func (m *PersistentVolumeClaimSpec) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetResources() *ResourceRequirements {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetVolumeName() string {
	if m != nil {
		return m.VolumeName
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetSelector() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetStorageClassName() string {
	if m != nil {
		return m.StorageClassName
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetVolumeMode() string {
	if m != nil {
		return m.VolumeMode
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetDataSource() *TypedLocalObjectReference {
	if m != nil {
		return m.DataSource
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L5327
type TypedLocalObjectReference struct {
	ApiGroup string `protobuf:"bytes,1,opt,name=apiGroup,proto3" json:"apiGroup,omitempty"`
	Kind     string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	Name     string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *TypedLocalObjectReference) Reset()         { *m = TypedLocalObjectReference{} }
func (m *TypedLocalObjectReference) String() string { return proto.CompactTextString(m) }
func (*TypedLocalObjectReference) ProtoMessage()    {}
func (*TypedLocalObjectReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{133}
}
func (m *TypedLocalObjectReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TypedLocalObjectReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TypedLocalObjectReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TypedLocalObjectReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TypedLocalObjectReference.Merge(m, src)
}
func (m *TypedLocalObjectReference) XXX_Size() int {
	return m.Size()
}
func (m *TypedLocalObjectReference) XXX_DiscardUnknown() {
	xxx_messageInfo_TypedLocalObjectReference.DiscardUnknown(m)
}

var xxx_messageInfo_TypedLocalObjectReference proto.InternalMessageInfo

func (m *TypedLocalObjectReference) GetApiGroup() string {
	if m != nil {
		return m.ApiGroup
	}
	return ""
}

func (m *TypedLocalObjectReference) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *TypedLocalObjectReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// reference https://github.com/kubernetes/api/blob/4bdcbc60ffeee2c04231f11ff114314c1a93ce65/core/v1/generated.proto#L2616
type PersistentVolumeClaimCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastProbeTime      int64  `protobuf:"varint,3,opt,name=lastProbeTime,proto3" json:"lastProbeTime,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,4,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,5,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *PersistentVolumeClaimCondition) Reset()         { *m = PersistentVolumeClaimCondition{} }
func (m *PersistentVolumeClaimCondition) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimCondition) ProtoMessage()    {}
func (*PersistentVolumeClaimCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{134}
}
func (m *PersistentVolumeClaimCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimCondition.Merge(m, src)
}
func (m *PersistentVolumeClaimCondition) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimCondition.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimCondition proto.InternalMessageInfo

func (m *PersistentVolumeClaimCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetLastProbeTime() int64 {
	if m != nil {
		return m.LastProbeTime
	}
	return 0
}

func (m *PersistentVolumeClaimCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *PersistentVolumeClaimCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/rbac/v1/generated.proto#L94
type PolicyRule struct {
	Verbs           []string `protobuf:"bytes,1,rep,name=verbs,proto3" json:"verbs,omitempty"`
	ApiGroups       []string `protobuf:"bytes,2,rep,name=apiGroups,proto3" json:"apiGroups,omitempty"`
	Resources       []string `protobuf:"bytes,3,rep,name=resources,proto3" json:"resources,omitempty"`
	ResourceNames   []string `protobuf:"bytes,4,rep,name=resourceNames,proto3" json:"resourceNames,omitempty"`
	NonResourceURLs []string `protobuf:"bytes,5,rep,name=nonResourceURLs,proto3" json:"nonResourceURLs,omitempty"`
}

func (m *PolicyRule) Reset()         { *m = PolicyRule{} }
func (m *PolicyRule) String() string { return proto.CompactTextString(m) }
func (*PolicyRule) ProtoMessage()    {}
func (*PolicyRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{135}
}
func (m *PolicyRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PolicyRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PolicyRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PolicyRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyRule.Merge(m, src)
}
func (m *PolicyRule) XXX_Size() int {
	return m.Size()
}
func (m *PolicyRule) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyRule.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyRule proto.InternalMessageInfo

func (m *PolicyRule) GetVerbs() []string {
	if m != nil {
		return m.Verbs
	}
	return nil
}

func (m *PolicyRule) GetApiGroups() []string {
	if m != nil {
		return m.ApiGroups
	}
	return nil
}

func (m *PolicyRule) GetResources() []string {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *PolicyRule) GetResourceNames() []string {
	if m != nil {
		return m.ResourceNames
	}
	return nil
}

func (m *PolicyRule) GetNonResourceURLs() []string {
	if m != nil {
		return m.NonResourceURLs
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/rbac/v1/generated.proto#L180
type Subject struct {
	Kind      string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	ApiGroup  string `protobuf:"bytes,2,opt,name=apiGroup,proto3" json:"apiGroup,omitempty"`
	Name      string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Namespace string `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (m *Subject) Reset()         { *m = Subject{} }
func (m *Subject) String() string { return proto.CompactTextString(m) }
func (*Subject) ProtoMessage()    {}
func (*Subject) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{136}
}
func (m *Subject) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Subject.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Subject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subject.Merge(m, src)
}
func (m *Subject) XXX_Size() int {
	return m.Size()
}
func (m *Subject) XXX_DiscardUnknown() {
	xxx_messageInfo_Subject.DiscardUnknown(m)
}

var xxx_messageInfo_Subject proto.InternalMessageInfo

func (m *Subject) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Subject) GetApiGroup() string {
	if m != nil {
		return m.ApiGroup
	}
	return ""
}

func (m *Subject) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subject) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/rbac/v1/generated.proto#L119
type Role struct {
	Metadata *Metadata     `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Rules    []*PolicyRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	Yaml     []byte        `protobuf:"bytes,3,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string      `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *Role) Reset()         { *m = Role{} }
func (m *Role) String() string { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()    {}
func (*Role) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{137}
}
func (m *Role) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Role) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Role.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Role) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Role.Merge(m, src)
}
func (m *Role) XXX_Size() int {
	return m.Size()
}
func (m *Role) XXX_DiscardUnknown() {
	xxx_messageInfo_Role.DiscardUnknown(m)
}

var xxx_messageInfo_Role proto.InternalMessageInfo

func (m *Role) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Role) GetRules() []*PolicyRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// Deprecated: Do not use.
func (m *Role) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Role) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/rbac/v1/generated.proto#L132
type RoleBinding struct {
	Metadata *Metadata                  `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Subjects []*Subject                 `protobuf:"bytes,2,rep,name=subjects,proto3" json:"subjects,omitempty"`
	RoleRef  *TypedLocalObjectReference `protobuf:"bytes,3,opt,name=roleRef,proto3" json:"roleRef,omitempty"`
	Yaml     []byte                     `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string                   `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *RoleBinding) Reset()         { *m = RoleBinding{} }
func (m *RoleBinding) String() string { return proto.CompactTextString(m) }
func (*RoleBinding) ProtoMessage()    {}
func (*RoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{138}
}
func (m *RoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleBinding.Merge(m, src)
}
func (m *RoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *RoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_RoleBinding proto.InternalMessageInfo

func (m *RoleBinding) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *RoleBinding) GetSubjects() []*Subject {
	if m != nil {
		return m.Subjects
	}
	return nil
}

func (m *RoleBinding) GetRoleRef() *TypedLocalObjectReference {
	if m != nil {
		return m.RoleRef
	}
	return nil
}

// Deprecated: Do not use.
func (m *RoleBinding) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *RoleBinding) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/rbac/v1/generated.proto#L40
type ClusterRole struct {
	Metadata         *Metadata                   `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Rules            []*PolicyRule               `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	AggregationRules []*LabelSelectorRequirement `protobuf:"bytes,3,rep,name=aggregationRules,proto3" json:"aggregationRules,omitempty"`
	Yaml             []byte                      `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags             []string                    `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Metrics          *ResourceMetrics            `protobuf:"bytes,6,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (m *ClusterRole) Reset()         { *m = ClusterRole{} }
func (m *ClusterRole) String() string { return proto.CompactTextString(m) }
func (*ClusterRole) ProtoMessage()    {}
func (*ClusterRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{139}
}
func (m *ClusterRole) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterRole.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterRole.Merge(m, src)
}
func (m *ClusterRole) XXX_Size() int {
	return m.Size()
}
func (m *ClusterRole) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterRole.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterRole proto.InternalMessageInfo

func (m *ClusterRole) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ClusterRole) GetRules() []*PolicyRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *ClusterRole) GetAggregationRules() []*LabelSelectorRequirement {
	if m != nil {
		return m.AggregationRules
	}
	return nil
}

// Deprecated: Do not use.
func (m *ClusterRole) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *ClusterRole) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ClusterRole) GetMetrics() *ResourceMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/rbac/v1/generated.proto#L58
type ClusterRoleBinding struct {
	Metadata *Metadata                  `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Subjects []*Subject                 `protobuf:"bytes,2,rep,name=subjects,proto3" json:"subjects,omitempty"`
	RoleRef  *TypedLocalObjectReference `protobuf:"bytes,3,opt,name=roleRef,proto3" json:"roleRef,omitempty"`
	Yaml     []byte                     `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string                   `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *ClusterRoleBinding) Reset()         { *m = ClusterRoleBinding{} }
func (m *ClusterRoleBinding) String() string { return proto.CompactTextString(m) }
func (*ClusterRoleBinding) ProtoMessage()    {}
func (*ClusterRoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{140}
}
func (m *ClusterRoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterRoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterRoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterRoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterRoleBinding.Merge(m, src)
}
func (m *ClusterRoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *ClusterRoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterRoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterRoleBinding proto.InternalMessageInfo

func (m *ClusterRoleBinding) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ClusterRoleBinding) GetSubjects() []*Subject {
	if m != nil {
		return m.Subjects
	}
	return nil
}

func (m *ClusterRoleBinding) GetRoleRef() *TypedLocalObjectReference {
	if m != nil {
		return m.RoleRef
	}
	return nil
}

// Deprecated: Do not use.
func (m *ClusterRoleBinding) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *ClusterRoleBinding) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// reference https://github.com/kubernetes/kubernetes/blob/cb19b56831d54d1d31249949318ef0b07bf00df9/staging/src/k8s.io/api/core/v1/generated.proto#L4495
type ServiceAccount struct {
	Metadata                     *Metadata                    `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Secrets                      []*ObjectReference           `protobuf:"bytes,2,rep,name=secrets,proto3" json:"secrets,omitempty"`
	ImagePullSecrets             []*TypedLocalObjectReference `protobuf:"bytes,3,rep,name=imagePullSecrets,proto3" json:"imagePullSecrets,omitempty"`
	AutomountServiceAccountToken bool                         `protobuf:"varint,4,opt,name=automountServiceAccountToken,proto3" json:"automountServiceAccountToken,omitempty"`
	Yaml                         []byte                       `protobuf:"bytes,5,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags                         []string                     `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *ServiceAccount) Reset()         { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()    {}
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{141}
}
func (m *ServiceAccount) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceAccount.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccount.Merge(m, src)
}
func (m *ServiceAccount) XXX_Size() int {
	return m.Size()
}
func (m *ServiceAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccount proto.InternalMessageInfo

func (m *ServiceAccount) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ServiceAccount) GetSecrets() []*ObjectReference {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *ServiceAccount) GetImagePullSecrets() []*TypedLocalObjectReference {
	if m != nil {
		return m.ImagePullSecrets
	}
	return nil
}

func (m *ServiceAccount) GetAutomountServiceAccountToken() bool {
	if m != nil {
		return m.AutomountServiceAccountToken
	}
	return false
}

// Deprecated: Do not use.
func (m *ServiceAccount) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *ServiceAccount) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L259
// Note: ServiceBackendPort (contains port name and number) is flattened.
type IngressServiceBackend struct {
	ServiceName string `protobuf:"bytes,1,opt,name=serviceName,proto3" json:"serviceName,omitempty"`
	PortName    string `protobuf:"bytes,2,opt,name=portName,proto3" json:"portName,omitempty"`
	PortNumber  int32  `protobuf:"varint,3,opt,name=portNumber,proto3" json:"portNumber,omitempty"`
}

func (m *IngressServiceBackend) Reset()         { *m = IngressServiceBackend{} }
func (m *IngressServiceBackend) String() string { return proto.CompactTextString(m) }
func (*IngressServiceBackend) ProtoMessage()    {}
func (*IngressServiceBackend) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{142}
}
func (m *IngressServiceBackend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IngressServiceBackend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IngressServiceBackend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IngressServiceBackend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressServiceBackend.Merge(m, src)
}
func (m *IngressServiceBackend) XXX_Size() int {
	return m.Size()
}
func (m *IngressServiceBackend) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressServiceBackend.DiscardUnknown(m)
}

var xxx_messageInfo_IngressServiceBackend proto.InternalMessageInfo

func (m *IngressServiceBackend) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *IngressServiceBackend) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *IngressServiceBackend) GetPortNumber() int32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L112
type IngressBackend struct {
	Service  *IngressServiceBackend     `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	Resource *TypedLocalObjectReference `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (m *IngressBackend) Reset()         { *m = IngressBackend{} }
func (m *IngressBackend) String() string { return proto.CompactTextString(m) }
func (*IngressBackend) ProtoMessage()    {}
func (*IngressBackend) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{143}
}
func (m *IngressBackend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IngressBackend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IngressBackend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IngressBackend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressBackend.Merge(m, src)
}
func (m *IngressBackend) XXX_Size() int {
	return m.Size()
}
func (m *IngressBackend) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressBackend.DiscardUnknown(m)
}

var xxx_messageInfo_IngressBackend proto.InternalMessageInfo

func (m *IngressBackend) GetService() *IngressServiceBackend {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *IngressBackend) GetResource() *TypedLocalObjectReference {
	if m != nil {
		return m.Resource
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L315
type IngressTLS struct {
	Hosts      []string `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	SecretName string   `protobuf:"bytes,2,opt,name=secretName,proto3" json:"secretName,omitempty"`
}

func (m *IngressTLS) Reset()         { *m = IngressTLS{} }
func (m *IngressTLS) String() string { return proto.CompactTextString(m) }
func (*IngressTLS) ProtoMessage()    {}
func (*IngressTLS) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{144}
}
func (m *IngressTLS) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IngressTLS) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IngressTLS.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IngressTLS) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressTLS.Merge(m, src)
}
func (m *IngressTLS) XXX_Size() int {
	return m.Size()
}
func (m *IngressTLS) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressTLS.DiscardUnknown(m)
}

var xxx_messageInfo_IngressTLS proto.InternalMessageInfo

func (m *IngressTLS) GetHosts() []string {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *IngressTLS) GetSecretName() string {
	if m != nil {
		return m.SecretName
	}
	return ""
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L35
type HTTPIngressPath struct {
	Path     string          `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	PathType string          `protobuf:"bytes,3,opt,name=pathType,proto3" json:"pathType,omitempty"`
	Backend  *IngressBackend `protobuf:"bytes,2,opt,name=backend,proto3" json:"backend,omitempty"`
}

func (m *HTTPIngressPath) Reset()         { *m = HTTPIngressPath{} }
func (m *HTTPIngressPath) String() string { return proto.CompactTextString(m) }
func (*HTTPIngressPath) ProtoMessage()    {}
func (*HTTPIngressPath) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{145}
}
func (m *HTTPIngressPath) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPIngressPath) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPIngressPath.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPIngressPath) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPIngressPath.Merge(m, src)
}
func (m *HTTPIngressPath) XXX_Size() int {
	return m.Size()
}
func (m *HTTPIngressPath) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPIngressPath.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPIngressPath proto.InternalMessageInfo

func (m *HTTPIngressPath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPIngressPath) GetPathType() string {
	if m != nil {
		return m.PathType
	}
	return ""
}

func (m *HTTPIngressPath) GetBackend() *IngressBackend {
	if m != nil {
		return m.Backend
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L214
// Note: IngressRuleValue and HTTPIngressRuleValue are flattened
type IngressRule struct {
	Host      string             `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	HttpPaths []*HTTPIngressPath `protobuf:"bytes,2,rep,name=httpPaths,proto3" json:"httpPaths,omitempty"`
}

func (m *IngressRule) Reset()         { *m = IngressRule{} }
func (m *IngressRule) String() string { return proto.CompactTextString(m) }
func (*IngressRule) ProtoMessage()    {}
func (*IngressRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{146}
}
func (m *IngressRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IngressRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IngressRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IngressRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressRule.Merge(m, src)
}
func (m *IngressRule) XXX_Size() int {
	return m.Size()
}
func (m *IngressRule) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressRule.DiscardUnknown(m)
}

var xxx_messageInfo_IngressRule proto.InternalMessageInfo

func (m *IngressRule) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *IngressRule) GetHttpPaths() []*HTTPIngressPath {
	if m != nil {
		return m.HttpPaths
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L270
type IngressSpec struct {
	DefaultBackend   *IngressBackend `protobuf:"bytes,1,opt,name=defaultBackend,proto3" json:"defaultBackend,omitempty"`
	Tls              []*IngressTLS   `protobuf:"bytes,2,rep,name=tls,proto3" json:"tls,omitempty"`
	Rules            []*IngressRule  `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
	IngressClassName string          `protobuf:"bytes,4,opt,name=ingressClassName,proto3" json:"ingressClassName,omitempty"`
}

func (m *IngressSpec) Reset()         { *m = IngressSpec{} }
func (m *IngressSpec) String() string { return proto.CompactTextString(m) }
func (*IngressSpec) ProtoMessage()    {}
func (*IngressSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{147}
}
func (m *IngressSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IngressSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IngressSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IngressSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressSpec.Merge(m, src)
}
func (m *IngressSpec) XXX_Size() int {
	return m.Size()
}
func (m *IngressSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressSpec.DiscardUnknown(m)
}

var xxx_messageInfo_IngressSpec proto.InternalMessageInfo

func (m *IngressSpec) GetDefaultBackend() *IngressBackend {
	if m != nil {
		return m.DefaultBackend
	}
	return nil
}

func (m *IngressSpec) GetTls() []*IngressTLS {
	if m != nil {
		return m.Tls
	}
	return nil
}

func (m *IngressSpec) GetRules() []*IngressRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *IngressSpec) GetIngressClassName() string {
	if m != nil {
		return m.IngressClassName
	}
	return ""
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/core/v1/generated.proto#L3781
type PortStatus struct {
	Port     int32  `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Error    string `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (m *PortStatus) Reset()         { *m = PortStatus{} }
func (m *PortStatus) String() string { return proto.CompactTextString(m) }
func (*PortStatus) ProtoMessage()    {}
func (*PortStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{148}
}
func (m *PortStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortStatus.Merge(m, src)
}
func (m *PortStatus) XXX_Size() int {
	return m.Size()
}
func (m *PortStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PortStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PortStatus proto.InternalMessageInfo

func (m *PortStatus) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *PortStatus) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *PortStatus) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/core/v1/generated.proto#L2024
type LoadBalancerIngress struct {
	Ip       string        `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	Hostname string        `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	Ports    []*PortStatus `protobuf:"bytes,4,rep,name=ports,proto3" json:"ports,omitempty"`
}

func (m *LoadBalancerIngress) Reset()         { *m = LoadBalancerIngress{} }
func (m *LoadBalancerIngress) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerIngress) ProtoMessage()    {}
func (*LoadBalancerIngress) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{149}
}
func (m *LoadBalancerIngress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadBalancerIngress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadBalancerIngress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadBalancerIngress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerIngress.Merge(m, src)
}
func (m *LoadBalancerIngress) XXX_Size() int {
	return m.Size()
}
func (m *LoadBalancerIngress) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerIngress.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerIngress proto.InternalMessageInfo

func (m *LoadBalancerIngress) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *LoadBalancerIngress) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *LoadBalancerIngress) GetPorts() []*PortStatus {
	if m != nil {
		return m.Ports
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L308
// LoadBalancerStatus is flattened
type IngressStatus struct {
	Ingress []*LoadBalancerIngress `protobuf:"bytes,1,rep,name=ingress,proto3" json:"ingress,omitempty"`
}

func (m *IngressStatus) Reset()         { *m = IngressStatus{} }
func (m *IngressStatus) String() string { return proto.CompactTextString(m) }
func (*IngressStatus) ProtoMessage()    {}
func (*IngressStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{150}
}
func (m *IngressStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IngressStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IngressStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IngressStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressStatus.Merge(m, src)
}
func (m *IngressStatus) XXX_Size() int {
	return m.Size()
}
func (m *IngressStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressStatus.DiscardUnknown(m)
}

var xxx_messageInfo_IngressStatus proto.InternalMessageInfo

func (m *IngressStatus) GetIngress() []*LoadBalancerIngress {
	if m != nil {
		return m.Ingress
	}
	return nil
}

// reference https://github.com/kubernetes/api/blob/v0.21.5/networking/v1/generated.proto#L94
type Ingress struct {
	Metadata *Metadata      `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec     *IngressSpec   `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status   *IngressStatus `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml     []byte         `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string       `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *Ingress) Reset()         { *m = Ingress{} }
func (m *Ingress) String() string { return proto.CompactTextString(m) }
func (*Ingress) ProtoMessage()    {}
func (*Ingress) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{151}
}
func (m *Ingress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Ingress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Ingress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Ingress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ingress.Merge(m, src)
}
func (m *Ingress) XXX_Size() int {
	return m.Size()
}
func (m *Ingress) XXX_DiscardUnknown() {
	xxx_messageInfo_Ingress.DiscardUnknown(m)
}

var xxx_messageInfo_Ingress proto.InternalMessageInfo

func (m *Ingress) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Ingress) GetSpec() *IngressSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Ingress) GetStatus() *IngressStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *Ingress) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *Ingress) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type KafkaStats struct {
	Count uint32 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// a protobuf encoded sketch of all the requests in a KafkaStats, in nanoseconds.
	// this will be nil if count == 1
	// To decode:
	//
	//	use a protobuf library to decode this into a github.com/DataDog/sketches-go/ddsketch/pb/sketchpb.DDSketch
	//
	// then call github.com/DataDog/sketches-go/ddsketch.FromProto
	// To encode:
	//
	//	create a github.com/DataDog/sketches-go/ddsketch.DDSketch
	//	call ToProto() and then run through a protobuf encoder
	Latencies []byte `protobuf:"bytes,2,opt,name=latencies,proto3" json:"latencies,omitempty"`
	// if the KafkaStats has a single sample, this field will be the latency (in nanoseconds) of the only sample.
	// this is purely to avoid the overhead of having single entry sketches.
	FirstLatencySample float64 `protobuf:"fixed64,3,opt,name=firstLatencySample,proto3" json:"firstLatencySample,omitempty"`
}

func (m *KafkaStats) Reset()         { *m = KafkaStats{} }
func (m *KafkaStats) String() string { return proto.CompactTextString(m) }
func (*KafkaStats) ProtoMessage()    {}
func (*KafkaStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{152}
}
func (m *KafkaStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KafkaStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KafkaStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KafkaStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KafkaStats.Merge(m, src)
}
func (m *KafkaStats) XXX_Size() int {
	return m.Size()
}
func (m *KafkaStats) XXX_DiscardUnknown() {
	xxx_messageInfo_KafkaStats.DiscardUnknown(m)
}

var xxx_messageInfo_KafkaStats proto.InternalMessageInfo

func (m *KafkaStats) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *KafkaStats) GetLatencies() []byte {
	if m != nil {
		return m.Latencies
	}
	return nil
}

func (m *KafkaStats) GetFirstLatencySample() float64 {
	if m != nil {
		return m.FirstLatencySample
	}
	return 0
}

type KafkaRequestHeader struct {
	RequestType    uint32 `protobuf:"varint,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	RequestVersion uint32 `protobuf:"varint,2,opt,name=request_version,json=requestVersion,proto3" json:"request_version,omitempty"`
}

func (m *KafkaRequestHeader) Reset()         { *m = KafkaRequestHeader{} }
func (m *KafkaRequestHeader) String() string { return proto.CompactTextString(m) }
func (*KafkaRequestHeader) ProtoMessage()    {}
func (*KafkaRequestHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{153}
}
func (m *KafkaRequestHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KafkaRequestHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KafkaRequestHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KafkaRequestHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KafkaRequestHeader.Merge(m, src)
}
func (m *KafkaRequestHeader) XXX_Size() int {
	return m.Size()
}
func (m *KafkaRequestHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_KafkaRequestHeader.DiscardUnknown(m)
}

var xxx_messageInfo_KafkaRequestHeader proto.InternalMessageInfo

func (m *KafkaRequestHeader) GetRequestType() uint32 {
	if m != nil {
		return m.RequestType
	}
	return 0
}

func (m *KafkaRequestHeader) GetRequestVersion() uint32 {
	if m != nil {
		return m.RequestVersion
	}
	return 0
}

type KafkaAggregation struct {
	Header *KafkaRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Topic  string              `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// The range of Kafka error codes spans from -1 to 119.
	StatsByErrorCode map[int32]*KafkaStats `protobuf:"bytes,4,rep,name=statsByErrorCode,proto3" json:"statsByErrorCode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// This approach for tracking Kafka hits is outdated, predating the inclusion of error codes.
	// It remains here to accommodate older agent versions.
	Count uint32 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"` // Deprecated: Do not use.
}

func (m *KafkaAggregation) Reset()         { *m = KafkaAggregation{} }
func (m *KafkaAggregation) String() string { return proto.CompactTextString(m) }
func (*KafkaAggregation) ProtoMessage()    {}
func (*KafkaAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{154}
}
func (m *KafkaAggregation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KafkaAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KafkaAggregation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KafkaAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KafkaAggregation.Merge(m, src)
}
func (m *KafkaAggregation) XXX_Size() int {
	return m.Size()
}
func (m *KafkaAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_KafkaAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_KafkaAggregation proto.InternalMessageInfo

func (m *KafkaAggregation) GetHeader() *KafkaRequestHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *KafkaAggregation) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *KafkaAggregation) GetStatsByErrorCode() map[int32]*KafkaStats {
	if m != nil {
		return m.StatsByErrorCode
	}
	return nil
}

// Deprecated: Do not use.
func (m *KafkaAggregation) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type DataStreamsAggregations struct {
	KafkaAggregations []*KafkaAggregation `protobuf:"bytes,3,rep,name=kafkaAggregations,proto3" json:"kafkaAggregations,omitempty"`
}

func (m *DataStreamsAggregations) Reset()         { *m = DataStreamsAggregations{} }
func (m *DataStreamsAggregations) String() string { return proto.CompactTextString(m) }
func (*DataStreamsAggregations) ProtoMessage()    {}
func (*DataStreamsAggregations) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{155}
}
func (m *DataStreamsAggregations) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataStreamsAggregations) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataStreamsAggregations.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataStreamsAggregations) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataStreamsAggregations.Merge(m, src)
}
func (m *DataStreamsAggregations) XXX_Size() int {
	return m.Size()
}
func (m *DataStreamsAggregations) XXX_DiscardUnknown() {
	xxx_messageInfo_DataStreamsAggregations.DiscardUnknown(m)
}

var xxx_messageInfo_DataStreamsAggregations proto.InternalMessageInfo

func (m *DataStreamsAggregations) GetKafkaAggregations() []*KafkaAggregation {
	if m != nil {
		return m.KafkaAggregations
	}
	return nil
}

// Represents the statistics for a single Postgres operation.
type PostgresStats struct {
	// The name of the table that this PostgresStats represents.
	TableName string `protobuf:"bytes,1,opt,name=tableName,proto3" json:"tableName,omitempty"`
	// The operation that this PostgresStats represents.
	Operation PostgresOperation `protobuf:"varint,2,opt,name=operation,proto3,enum=datadog.process_agent.PostgresOperation" json:"operation,omitempty"`
	// A protobuf encoded sketch of all the latencies for this operation. In nanoseconds.
	Latencies []byte `protobuf:"bytes,3,opt,name=latencies,proto3" json:"latencies,omitempty"`
	// If the PostgresStats has a single sample, this field will be the latency (in nanoseconds) of the only sample.
	FirstLatencySample float64 `protobuf:"fixed64,4,opt,name=firstLatencySample,proto3" json:"firstLatencySample,omitempty"`
	// The number of samples in the latencies sketch.
	Count uint32 `protobuf:"varint,5,opt,name=count,proto3" json:"count,omitempty"`
}

func (m *PostgresStats) Reset()         { *m = PostgresStats{} }
func (m *PostgresStats) String() string { return proto.CompactTextString(m) }
func (*PostgresStats) ProtoMessage()    {}
func (*PostgresStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{156}
}
func (m *PostgresStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PostgresStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PostgresStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PostgresStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PostgresStats.Merge(m, src)
}
func (m *PostgresStats) XXX_Size() int {
	return m.Size()
}
func (m *PostgresStats) XXX_DiscardUnknown() {
	xxx_messageInfo_PostgresStats.DiscardUnknown(m)
}

var xxx_messageInfo_PostgresStats proto.InternalMessageInfo

func (m *PostgresStats) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *PostgresStats) GetOperation() PostgresOperation {
	if m != nil {
		return m.Operation
	}
	return PostgresOperation_PostgresUnknownOp
}

func (m *PostgresStats) GetLatencies() []byte {
	if m != nil {
		return m.Latencies
	}
	return nil
}

func (m *PostgresStats) GetFirstLatencySample() float64 {
	if m != nil {
		return m.FirstLatencySample
	}
	return 0
}

func (m *PostgresStats) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type RedisStats struct {
	// The command for the redis cache.
	Command RedisCommand `protobuf:"varint,1,opt,name=command,proto3,enum=datadog.process_agent.RedisCommand" json:"command,omitempty"`
	// The name of the key which the command was applied to.
	KeyName string `protobuf:"bytes,2,opt,name=keyName,proto3" json:"keyName,omitempty"`
	// Indicates whether the key name was truncated due to length limits.
	Truncated bool `protobuf:"varint,3,opt,name=truncated,proto3" json:"truncated,omitempty"`
	// Mapping of error types to the associated Redis stats. Keys should be RedisErrorType values.
	ErrorToStats map[int32]*RedisStatsEntry `protobuf:"bytes,4,rep,name=errorToStats,proto3" json:"errorToStats,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *RedisStats) Reset()         { *m = RedisStats{} }
func (m *RedisStats) String() string { return proto.CompactTextString(m) }
func (*RedisStats) ProtoMessage()    {}
func (*RedisStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{157}
}
func (m *RedisStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisStats.Merge(m, src)
}
func (m *RedisStats) XXX_Size() int {
	return m.Size()
}
func (m *RedisStats) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisStats.DiscardUnknown(m)
}

var xxx_messageInfo_RedisStats proto.InternalMessageInfo

func (m *RedisStats) GetCommand() RedisCommand {
	if m != nil {
		return m.Command
	}
	return RedisCommand_RedisUnknownCommand
}

func (m *RedisStats) GetKeyName() string {
	if m != nil {
		return m.KeyName
	}
	return ""
}

func (m *RedisStats) GetTruncated() bool {
	if m != nil {
		return m.Truncated
	}
	return false
}

func (m *RedisStats) GetErrorToStats() map[int32]*RedisStatsEntry {
	if m != nil {
		return m.ErrorToStats
	}
	return nil
}

// Represents the statistics for a single Redis transaction.
type RedisStatsEntry struct {
	// A protobuf encoded sketch of all the latencies for this operation. In nanoseconds.
	Latencies []byte `protobuf:"bytes,1,opt,name=latencies,proto3" json:"latencies,omitempty"`
	// If the PostgresStats has a single sample, this field will be the latency (in nanoseconds) of the only sample.
	FirstLatencySample float64 `protobuf:"fixed64,2,opt,name=firstLatencySample,proto3" json:"firstLatencySample,omitempty"`
	// The number of samples in the latencies sketch.
	Count uint32 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (m *RedisStatsEntry) Reset()         { *m = RedisStatsEntry{} }
func (m *RedisStatsEntry) String() string { return proto.CompactTextString(m) }
func (*RedisStatsEntry) ProtoMessage()    {}
func (*RedisStatsEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{158}
}
func (m *RedisStatsEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisStatsEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisStatsEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisStatsEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisStatsEntry.Merge(m, src)
}
func (m *RedisStatsEntry) XXX_Size() int {
	return m.Size()
}
func (m *RedisStatsEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisStatsEntry.DiscardUnknown(m)
}

var xxx_messageInfo_RedisStatsEntry proto.InternalMessageInfo

func (m *RedisStatsEntry) GetLatencies() []byte {
	if m != nil {
		return m.Latencies
	}
	return nil
}

func (m *RedisStatsEntry) GetFirstLatencySample() float64 {
	if m != nil {
		return m.FirstLatencySample
	}
	return 0
}

func (m *RedisStatsEntry) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Represents the statistics for a single Database operation.
type DatabaseStats struct {
	// The idea is to have a single message that can represent the stats for any database.
	// Each database will have its own message that will be populated by the agent.
	//
	// Types that are valid to be assigned to DbStats:
	//
	//	*DatabaseStats_Postgres
	//	*DatabaseStats_Redis
	DbStats isDatabaseStats_DbStats `protobuf_oneof:"dbStats"`
}

func (m *DatabaseStats) Reset()         { *m = DatabaseStats{} }
func (m *DatabaseStats) String() string { return proto.CompactTextString(m) }
func (*DatabaseStats) ProtoMessage()    {}
func (*DatabaseStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{159}
}
func (m *DatabaseStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DatabaseStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DatabaseStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DatabaseStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatabaseStats.Merge(m, src)
}
func (m *DatabaseStats) XXX_Size() int {
	return m.Size()
}
func (m *DatabaseStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DatabaseStats.DiscardUnknown(m)
}

var xxx_messageInfo_DatabaseStats proto.InternalMessageInfo

type isDatabaseStats_DbStats interface {
	isDatabaseStats_DbStats()
	MarshalTo([]byte) (int, error)
	Size() int
}

type DatabaseStats_Postgres struct {
	Postgres *PostgresStats `protobuf:"bytes,1,opt,name=postgres,proto3,oneof" json:"postgres,omitempty"`
}
type DatabaseStats_Redis struct {
	Redis *RedisStats `protobuf:"bytes,2,opt,name=redis,proto3,oneof" json:"redis,omitempty"`
}

func (*DatabaseStats_Postgres) isDatabaseStats_DbStats() {}
func (*DatabaseStats_Redis) isDatabaseStats_DbStats()    {}

func (m *DatabaseStats) GetDbStats() isDatabaseStats_DbStats {
	if m != nil {
		return m.DbStats
	}
	return nil
}

func (m *DatabaseStats) GetPostgres() *PostgresStats {
	if x, ok := m.GetDbStats().(*DatabaseStats_Postgres); ok {
		return x.Postgres
	}
	return nil
}

func (m *DatabaseStats) GetRedis() *RedisStats {
	if x, ok := m.GetDbStats().(*DatabaseStats_Redis); ok {
		return x.Redis
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DatabaseStats) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DatabaseStats_Postgres)(nil),
		(*DatabaseStats_Redis)(nil),
	}
}

// Represents a list of database aggregations. Each entry in the list can be from a different database (postgres,
// mysql, etc). The agent will only populate the fields for the database it is configured to monitor.
type DatabaseAggregations struct {
	Aggregations []*DatabaseStats `protobuf:"bytes,1,rep,name=aggregations,proto3" json:"aggregations,omitempty"`
}

func (m *DatabaseAggregations) Reset()         { *m = DatabaseAggregations{} }
func (m *DatabaseAggregations) String() string { return proto.CompactTextString(m) }
func (*DatabaseAggregations) ProtoMessage()    {}
func (*DatabaseAggregations) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{160}
}
func (m *DatabaseAggregations) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DatabaseAggregations) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DatabaseAggregations.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DatabaseAggregations) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatabaseAggregations.Merge(m, src)
}
func (m *DatabaseAggregations) XXX_Size() int {
	return m.Size()
}
func (m *DatabaseAggregations) XXX_DiscardUnknown() {
	xxx_messageInfo_DatabaseAggregations.DiscardUnknown(m)
}

var xxx_messageInfo_DatabaseAggregations proto.InternalMessageInfo

func (m *DatabaseAggregations) GetAggregations() []*DatabaseStats {
	if m != nil {
		return m.Aggregations
	}
	return nil
}

type HTTPAggregations struct {
	EndpointAggregations []*HTTPStats `protobuf:"bytes,2,rep,name=endpointAggregations,proto3" json:"endpointAggregations,omitempty"`
}

func (m *HTTPAggregations) Reset()         { *m = HTTPAggregations{} }
func (m *HTTPAggregations) String() string { return proto.CompactTextString(m) }
func (*HTTPAggregations) ProtoMessage()    {}
func (*HTTPAggregations) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{161}
}
func (m *HTTPAggregations) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPAggregations) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPAggregations.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPAggregations) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPAggregations.Merge(m, src)
}
func (m *HTTPAggregations) XXX_Size() int {
	return m.Size()
}
func (m *HTTPAggregations) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPAggregations.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPAggregations proto.InternalMessageInfo

func (m *HTTPAggregations) GetEndpointAggregations() []*HTTPStats {
	if m != nil {
		return m.EndpointAggregations
	}
	return nil
}

// The current state of HTTP2Aggregations is identical to that of HTTPAggregations.
// However, there is a possibility that additional fields might be added to it in the future.
type HTTP2Aggregations struct {
	EndpointAggregations []*HTTPStats `protobuf:"bytes,1,rep,name=endpointAggregations,proto3" json:"endpointAggregations,omitempty"`
}

func (m *HTTP2Aggregations) Reset()         { *m = HTTP2Aggregations{} }
func (m *HTTP2Aggregations) String() string { return proto.CompactTextString(m) }
func (*HTTP2Aggregations) ProtoMessage()    {}
func (*HTTP2Aggregations) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{162}
}
func (m *HTTP2Aggregations) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTP2Aggregations) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTP2Aggregations.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTP2Aggregations) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTP2Aggregations.Merge(m, src)
}
func (m *HTTP2Aggregations) XXX_Size() int {
	return m.Size()
}
func (m *HTTP2Aggregations) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTP2Aggregations.DiscardUnknown(m)
}

var xxx_messageInfo_HTTP2Aggregations proto.InternalMessageInfo

func (m *HTTP2Aggregations) GetEndpointAggregations() []*HTTPStats {
	if m != nil {
		return m.EndpointAggregations
	}
	return nil
}

type HTTPStats struct {
	Path   string     `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	Method HTTPMethod `protobuf:"varint,5,opt,name=method,proto3,enum=datadog.process_agent.HTTPMethod" json:"method,omitempty"`
	// The agent can only read a limited part of the http header because
	// of cpu/memory contraints. It is thus possible that the path is not
	// read entirely.
	// In case we're sure we've read the http path entirely, fullPath will
	// be set to true. In any other cases, it would be set to false.
	FullPath              bool              `protobuf:"varint,6,opt,name=fullPath,proto3" json:"fullPath,omitempty"`
	StatsByResponseStatus []*HTTPStats_Data `protobuf:"bytes,1,rep,name=statsByResponseStatus,proto3" json:"statsByResponseStatus,omitempty"`
	// This is a temporary field, that might be removed (and the index to be reserved) in the near future.
	// This is the new format of saving aggregations. We support any status code rather than just the status code families
	// as used in statsByResponseStatus.
	StatsByStatusCode map[int32]*HTTPStats_Data `protobuf:"bytes,2,rep,name=statsByStatusCode,proto3" json:"statsByStatusCode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *HTTPStats) Reset()         { *m = HTTPStats{} }
func (m *HTTPStats) String() string { return proto.CompactTextString(m) }
func (*HTTPStats) ProtoMessage()    {}
func (*HTTPStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{163}
}
func (m *HTTPStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPStats.Merge(m, src)
}
func (m *HTTPStats) XXX_Size() int {
	return m.Size()
}
func (m *HTTPStats) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPStats.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPStats proto.InternalMessageInfo

func (m *HTTPStats) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPStats) GetMethod() HTTPMethod {
	if m != nil {
		return m.Method
	}
	return HTTPMethod_Unknown
}

func (m *HTTPStats) GetFullPath() bool {
	if m != nil {
		return m.FullPath
	}
	return false
}

func (m *HTTPStats) GetStatsByResponseStatus() []*HTTPStats_Data {
	if m != nil {
		return m.StatsByResponseStatus
	}
	return nil
}

func (m *HTTPStats) GetStatsByStatusCode() map[int32]*HTTPStats_Data {
	if m != nil {
		return m.StatsByStatusCode
	}
	return nil
}

type HTTPStats_Data struct {
	Count uint32 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// a protobuf encoded sketch of all the requests in this HTTPStats. In nanoseconds.
	// this will be nil if count == 1
	// To decode:
	//
	//	use a protobuf library to decode this into a github.com/DataDog/sketches-go/ddsketch/pb/sketchpb.DDSketch
	//
	// then call github.com/DataDog/sketches-go/ddsketch.FromProto
	// To encode:
	//
	//	create a github.com/DataDog/sketches-go/ddsketch.DDSketch
	//	call ToProto() and then run through a protobuf encoder
	Latencies []byte `protobuf:"bytes,2,opt,name=latencies,proto3" json:"latencies,omitempty"`
	// if the HTTPStats has a single sample, this field will be the latency (in nanoseconds) of the only sample.
	// this is purely to avoid the overhead of having single entry sketches.
	FirstLatencySample float64 `protobuf:"fixed64,4,opt,name=firstLatencySample,proto3" json:"firstLatencySample,omitempty"`
}

func (m *HTTPStats_Data) Reset()         { *m = HTTPStats_Data{} }
func (m *HTTPStats_Data) String() string { return proto.CompactTextString(m) }
func (*HTTPStats_Data) ProtoMessage()    {}
func (*HTTPStats_Data) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{163, 1}
}
func (m *HTTPStats_Data) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPStats_Data) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPStats_Data.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPStats_Data) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPStats_Data.Merge(m, src)
}
func (m *HTTPStats_Data) XXX_Size() int {
	return m.Size()
}
func (m *HTTPStats_Data) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPStats_Data.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPStats_Data proto.InternalMessageInfo

func (m *HTTPStats_Data) GetCount() uint32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *HTTPStats_Data) GetLatencies() []byte {
	if m != nil {
		return m.Latencies
	}
	return nil
}

func (m *HTTPStats_Data) GetFirstLatencySample() float64 {
	if m != nil {
		return m.FirstLatencySample
	}
	return 0
}

// replaces DNSEntry.  Is a list of DNS names that a given IP resolved to.
// List of offsets into the EncodedDomainDatabase.
type DNSDatabaseEntry struct {
	NameOffsets []int32 `protobuf:"varint,1,rep,name=nameOffsets,proto3" json:"nameOffsets,omitempty"`
}

func (m *DNSDatabaseEntry) Reset()         { *m = DNSDatabaseEntry{} }
func (m *DNSDatabaseEntry) String() string { return proto.CompactTextString(m) }
func (*DNSDatabaseEntry) ProtoMessage()    {}
func (*DNSDatabaseEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{164}
}
func (m *DNSDatabaseEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSDatabaseEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSDatabaseEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSDatabaseEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSDatabaseEntry.Merge(m, src)
}
func (m *DNSDatabaseEntry) XXX_Size() int {
	return m.Size()
}
func (m *DNSDatabaseEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSDatabaseEntry.DiscardUnknown(m)
}

var xxx_messageInfo_DNSDatabaseEntry proto.InternalMessageInfo

func (m *DNSDatabaseEntry) GetNameOffsets() []int32 {
	if m != nil {
		return m.NameOffsets
	}
	return nil
}

// ResourceList is a set of (resource name, quantity) pairs
// https://pkg.go.dev/k8s.io/api/core/v1#ResourceList
type ResourceList struct {
	MetricValues map[string]float64 `protobuf:"bytes,1,rep,name=metricValues,proto3" json:"metricValues,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
}

func (m *ResourceList) Reset()         { *m = ResourceList{} }
func (m *ResourceList) String() string { return proto.CompactTextString(m) }
func (*ResourceList) ProtoMessage()    {}
func (*ResourceList) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{165}
}
func (m *ResourceList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceList.Merge(m, src)
}
func (m *ResourceList) XXX_Size() int {
	return m.Size()
}
func (m *ResourceList) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceList.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceList proto.InternalMessageInfo

func (m *ResourceList) GetMetricValues() map[string]float64 {
	if m != nil {
		return m.MetricValues
	}
	return nil
}

// https://github.com/kubernetes/autoscaler/blob/master/vertical-pod-autoscaler/pkg/apis/autoscaling.k8s.io/v1/types.go
type VerticalPodAutoscaler struct {
	Metadata   *Metadata                         `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec       *VerticalPodAutoscalerSpec        `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status     *VerticalPodAutoscalerStatus      `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml       []byte                            `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags       []string                          `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Conditions []*VerticalPodAutoscalerCondition `protobuf:"bytes,6,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *VerticalPodAutoscaler) Reset()         { *m = VerticalPodAutoscaler{} }
func (m *VerticalPodAutoscaler) String() string { return proto.CompactTextString(m) }
func (*VerticalPodAutoscaler) ProtoMessage()    {}
func (*VerticalPodAutoscaler) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{166}
}
func (m *VerticalPodAutoscaler) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerticalPodAutoscaler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerticalPodAutoscaler.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerticalPodAutoscaler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerticalPodAutoscaler.Merge(m, src)
}
func (m *VerticalPodAutoscaler) XXX_Size() int {
	return m.Size()
}
func (m *VerticalPodAutoscaler) XXX_DiscardUnknown() {
	xxx_messageInfo_VerticalPodAutoscaler.DiscardUnknown(m)
}

var xxx_messageInfo_VerticalPodAutoscaler proto.InternalMessageInfo

func (m *VerticalPodAutoscaler) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *VerticalPodAutoscaler) GetSpec() *VerticalPodAutoscalerSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *VerticalPodAutoscaler) GetStatus() *VerticalPodAutoscalerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *VerticalPodAutoscaler) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *VerticalPodAutoscaler) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *VerticalPodAutoscaler) GetConditions() []*VerticalPodAutoscalerCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// reference https://github.com/kubernetes/autoscaler/blob/master/vertical-pod-autoscaler/pkg/apis/autoscaling.k8s.io/v1/types.go#L295
type VerticalPodAutoscalerCondition struct {
	Type               string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status             string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *VerticalPodAutoscalerCondition) Reset()         { *m = VerticalPodAutoscalerCondition{} }
func (m *VerticalPodAutoscalerCondition) String() string { return proto.CompactTextString(m) }
func (*VerticalPodAutoscalerCondition) ProtoMessage()    {}
func (*VerticalPodAutoscalerCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{167}
}
func (m *VerticalPodAutoscalerCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerticalPodAutoscalerCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerticalPodAutoscalerCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerticalPodAutoscalerCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerticalPodAutoscalerCondition.Merge(m, src)
}
func (m *VerticalPodAutoscalerCondition) XXX_Size() int {
	return m.Size()
}
func (m *VerticalPodAutoscalerCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_VerticalPodAutoscalerCondition.DiscardUnknown(m)
}

var xxx_messageInfo_VerticalPodAutoscalerCondition proto.InternalMessageInfo

func (m *VerticalPodAutoscalerCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *VerticalPodAutoscalerCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *VerticalPodAutoscalerCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *VerticalPodAutoscalerCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *VerticalPodAutoscalerCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type VerticalPodAutoscalerSpec struct {
	Target           *VerticalPodAutoscalerTarget `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	UpdateMode       string                       `protobuf:"bytes,2,opt,name=updateMode,proto3" json:"updateMode,omitempty"`
	ResourcePolicies []*ContainerResourcePolicy   `protobuf:"bytes,3,rep,name=resourcePolicies,proto3" json:"resourcePolicies,omitempty"`
}

func (m *VerticalPodAutoscalerSpec) Reset()         { *m = VerticalPodAutoscalerSpec{} }
func (m *VerticalPodAutoscalerSpec) String() string { return proto.CompactTextString(m) }
func (*VerticalPodAutoscalerSpec) ProtoMessage()    {}
func (*VerticalPodAutoscalerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{168}
}
func (m *VerticalPodAutoscalerSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerticalPodAutoscalerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerticalPodAutoscalerSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerticalPodAutoscalerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerticalPodAutoscalerSpec.Merge(m, src)
}
func (m *VerticalPodAutoscalerSpec) XXX_Size() int {
	return m.Size()
}
func (m *VerticalPodAutoscalerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_VerticalPodAutoscalerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_VerticalPodAutoscalerSpec proto.InternalMessageInfo

func (m *VerticalPodAutoscalerSpec) GetTarget() *VerticalPodAutoscalerTarget {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *VerticalPodAutoscalerSpec) GetUpdateMode() string {
	if m != nil {
		return m.UpdateMode
	}
	return ""
}

func (m *VerticalPodAutoscalerSpec) GetResourcePolicies() []*ContainerResourcePolicy {
	if m != nil {
		return m.ResourcePolicies
	}
	return nil
}

type VerticalPodAutoscalerTarget struct {
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *VerticalPodAutoscalerTarget) Reset()         { *m = VerticalPodAutoscalerTarget{} }
func (m *VerticalPodAutoscalerTarget) String() string { return proto.CompactTextString(m) }
func (*VerticalPodAutoscalerTarget) ProtoMessage()    {}
func (*VerticalPodAutoscalerTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{169}
}
func (m *VerticalPodAutoscalerTarget) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerticalPodAutoscalerTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerticalPodAutoscalerTarget.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerticalPodAutoscalerTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerticalPodAutoscalerTarget.Merge(m, src)
}
func (m *VerticalPodAutoscalerTarget) XXX_Size() int {
	return m.Size()
}
func (m *VerticalPodAutoscalerTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_VerticalPodAutoscalerTarget.DiscardUnknown(m)
}

var xxx_messageInfo_VerticalPodAutoscalerTarget proto.InternalMessageInfo

func (m *VerticalPodAutoscalerTarget) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *VerticalPodAutoscalerTarget) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type ContainerResourcePolicy struct {
	ContainerName      string        `protobuf:"bytes,1,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Mode               string        `protobuf:"bytes,2,opt,name=mode,proto3" json:"mode,omitempty"`
	MinAllowed         *ResourceList `protobuf:"bytes,3,opt,name=minAllowed,proto3" json:"minAllowed,omitempty"`
	MaxAllowed         *ResourceList `protobuf:"bytes,4,opt,name=maxAllowed,proto3" json:"maxAllowed,omitempty"`
	ControlledResource []string      `protobuf:"bytes,5,rep,name=controlledResource,proto3" json:"controlledResource,omitempty"`
	ControlledValues   string        `protobuf:"bytes,6,opt,name=controlledValues,proto3" json:"controlledValues,omitempty"`
}

func (m *ContainerResourcePolicy) Reset()         { *m = ContainerResourcePolicy{} }
func (m *ContainerResourcePolicy) String() string { return proto.CompactTextString(m) }
func (*ContainerResourcePolicy) ProtoMessage()    {}
func (*ContainerResourcePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{170}
}
func (m *ContainerResourcePolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerResourcePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerResourcePolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerResourcePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerResourcePolicy.Merge(m, src)
}
func (m *ContainerResourcePolicy) XXX_Size() int {
	return m.Size()
}
func (m *ContainerResourcePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerResourcePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerResourcePolicy proto.InternalMessageInfo

func (m *ContainerResourcePolicy) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *ContainerResourcePolicy) GetMode() string {
	if m != nil {
		return m.Mode
	}
	return ""
}

func (m *ContainerResourcePolicy) GetMinAllowed() *ResourceList {
	if m != nil {
		return m.MinAllowed
	}
	return nil
}

func (m *ContainerResourcePolicy) GetMaxAllowed() *ResourceList {
	if m != nil {
		return m.MaxAllowed
	}
	return nil
}

func (m *ContainerResourcePolicy) GetControlledResource() []string {
	if m != nil {
		return m.ControlledResource
	}
	return nil
}

func (m *ContainerResourcePolicy) GetControlledValues() string {
	if m != nil {
		return m.ControlledValues
	}
	return ""
}

type VerticalPodAutoscalerStatus struct {
	LastRecommendedDate int64                      `protobuf:"varint,1,opt,name=LastRecommendedDate,proto3" json:"LastRecommendedDate,omitempty"`
	Recommendations     []*ContainerRecommendation `protobuf:"bytes,2,rep,name=recommendations,proto3" json:"recommendations,omitempty"`
	Conditions          []*VPACondition            `protobuf:"bytes,3,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *VerticalPodAutoscalerStatus) Reset()         { *m = VerticalPodAutoscalerStatus{} }
func (m *VerticalPodAutoscalerStatus) String() string { return proto.CompactTextString(m) }
func (*VerticalPodAutoscalerStatus) ProtoMessage()    {}
func (*VerticalPodAutoscalerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{171}
}
func (m *VerticalPodAutoscalerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerticalPodAutoscalerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerticalPodAutoscalerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerticalPodAutoscalerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerticalPodAutoscalerStatus.Merge(m, src)
}
func (m *VerticalPodAutoscalerStatus) XXX_Size() int {
	return m.Size()
}
func (m *VerticalPodAutoscalerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_VerticalPodAutoscalerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_VerticalPodAutoscalerStatus proto.InternalMessageInfo

func (m *VerticalPodAutoscalerStatus) GetLastRecommendedDate() int64 {
	if m != nil {
		return m.LastRecommendedDate
	}
	return 0
}

func (m *VerticalPodAutoscalerStatus) GetRecommendations() []*ContainerRecommendation {
	if m != nil {
		return m.Recommendations
	}
	return nil
}

func (m *VerticalPodAutoscalerStatus) GetConditions() []*VPACondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

type ContainerRecommendation struct {
	ContainerName  string        `protobuf:"bytes,1,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Target         *ResourceList `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	LowerBound     *ResourceList `protobuf:"bytes,3,opt,name=lowerBound,proto3" json:"lowerBound,omitempty"`
	UpperBound     *ResourceList `protobuf:"bytes,4,opt,name=upperBound,proto3" json:"upperBound,omitempty"`
	UncappedTarget *ResourceList `protobuf:"bytes,5,opt,name=uncappedTarget,proto3" json:"uncappedTarget,omitempty"`
}

func (m *ContainerRecommendation) Reset()         { *m = ContainerRecommendation{} }
func (m *ContainerRecommendation) String() string { return proto.CompactTextString(m) }
func (*ContainerRecommendation) ProtoMessage()    {}
func (*ContainerRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{172}
}
func (m *ContainerRecommendation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerRecommendation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerRecommendation.Merge(m, src)
}
func (m *ContainerRecommendation) XXX_Size() int {
	return m.Size()
}
func (m *ContainerRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerRecommendation proto.InternalMessageInfo

func (m *ContainerRecommendation) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *ContainerRecommendation) GetTarget() *ResourceList {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ContainerRecommendation) GetLowerBound() *ResourceList {
	if m != nil {
		return m.LowerBound
	}
	return nil
}

func (m *ContainerRecommendation) GetUpperBound() *ResourceList {
	if m != nil {
		return m.UpperBound
	}
	return nil
}

func (m *ContainerRecommendation) GetUncappedTarget() *ResourceList {
	if m != nil {
		return m.UncappedTarget
	}
	return nil
}

type VPACondition struct {
	ConditionType      string `protobuf:"bytes,1,opt,name=ConditionType,proto3" json:"ConditionType,omitempty"`
	ConditionStatus    string `protobuf:"bytes,2,opt,name=ConditionStatus,proto3" json:"ConditionStatus,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=LastTransitionTime,proto3" json:"LastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=Reason,proto3" json:"Reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=Message,proto3" json:"Message,omitempty"`
}

func (m *VPACondition) Reset()         { *m = VPACondition{} }
func (m *VPACondition) String() string { return proto.CompactTextString(m) }
func (*VPACondition) ProtoMessage()    {}
func (*VPACondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{173}
}
func (m *VPACondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VPACondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VPACondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VPACondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VPACondition.Merge(m, src)
}
func (m *VPACondition) XXX_Size() int {
	return m.Size()
}
func (m *VPACondition) XXX_DiscardUnknown() {
	xxx_messageInfo_VPACondition.DiscardUnknown(m)
}

var xxx_messageInfo_VPACondition proto.InternalMessageInfo

func (m *VPACondition) GetConditionType() string {
	if m != nil {
		return m.ConditionType
	}
	return ""
}

func (m *VPACondition) GetConditionStatus() string {
	if m != nil {
		return m.ConditionStatus
	}
	return ""
}

func (m *VPACondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *VPACondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *VPACondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// https://github.com/kubernetes/api/blob/v0.23.15/autoscaling/v2/types.go
type HorizontalPodAutoscaler struct {
	Metadata   *Metadata                           `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec       *HorizontalPodAutoscalerSpec        `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Status     *HorizontalPodAutoscalerStatus      `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Yaml       []byte                              `protobuf:"bytes,4,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags       []string                            `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Conditions []*HorizontalPodAutoscalerCondition `protobuf:"bytes,6,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (m *HorizontalPodAutoscaler) Reset()         { *m = HorizontalPodAutoscaler{} }
func (m *HorizontalPodAutoscaler) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscaler) ProtoMessage()    {}
func (*HorizontalPodAutoscaler) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{174}
}
func (m *HorizontalPodAutoscaler) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscaler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscaler.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscaler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscaler.Merge(m, src)
}
func (m *HorizontalPodAutoscaler) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscaler) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscaler.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscaler proto.InternalMessageInfo

func (m *HorizontalPodAutoscaler) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *HorizontalPodAutoscaler) GetSpec() *HorizontalPodAutoscalerSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *HorizontalPodAutoscaler) GetStatus() *HorizontalPodAutoscalerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Deprecated: Do not use.
func (m *HorizontalPodAutoscaler) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *HorizontalPodAutoscaler) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *HorizontalPodAutoscaler) GetConditions() []*HorizontalPodAutoscalerCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

type HorizontalPodAutoscalerSpec struct {
	Target      *HorizontalPodAutoscalerTarget       `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	MinReplicas int32                                `protobuf:"varint,2,opt,name=minReplicas,proto3" json:"minReplicas,omitempty"`
	MaxReplicas int32                                `protobuf:"varint,3,opt,name=maxReplicas,proto3" json:"maxReplicas,omitempty"`
	Metrics     []*HorizontalPodAutoscalerMetricSpec `protobuf:"bytes,4,rep,name=metrics,proto3" json:"metrics,omitempty"`
	Behavior    *HorizontalPodAutoscalerBehavior     `protobuf:"bytes,5,opt,name=behavior,proto3" json:"behavior,omitempty"`
}

func (m *HorizontalPodAutoscalerSpec) Reset()         { *m = HorizontalPodAutoscalerSpec{} }
func (m *HorizontalPodAutoscalerSpec) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerSpec) ProtoMessage()    {}
func (*HorizontalPodAutoscalerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{175}
}
func (m *HorizontalPodAutoscalerSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscalerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscalerSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscalerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerSpec.Merge(m, src)
}
func (m *HorizontalPodAutoscalerSpec) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscalerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerSpec proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerSpec) GetTarget() *HorizontalPodAutoscalerTarget {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *HorizontalPodAutoscalerSpec) GetMinReplicas() int32 {
	if m != nil {
		return m.MinReplicas
	}
	return 0
}

func (m *HorizontalPodAutoscalerSpec) GetMaxReplicas() int32 {
	if m != nil {
		return m.MaxReplicas
	}
	return 0
}

func (m *HorizontalPodAutoscalerSpec) GetMetrics() []*HorizontalPodAutoscalerMetricSpec {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *HorizontalPodAutoscalerSpec) GetBehavior() *HorizontalPodAutoscalerBehavior {
	if m != nil {
		return m.Behavior
	}
	return nil
}

type HorizontalPodAutoscalerTarget struct {
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *HorizontalPodAutoscalerTarget) Reset()         { *m = HorizontalPodAutoscalerTarget{} }
func (m *HorizontalPodAutoscalerTarget) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerTarget) ProtoMessage()    {}
func (*HorizontalPodAutoscalerTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{176}
}
func (m *HorizontalPodAutoscalerTarget) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscalerTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscalerTarget.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscalerTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerTarget.Merge(m, src)
}
func (m *HorizontalPodAutoscalerTarget) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscalerTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerTarget.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerTarget proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerTarget) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *HorizontalPodAutoscalerTarget) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type HorizontalPodAutoscalerMetricSpec struct {
	Type              string                         `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Object            *ObjectMetricSource            `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	Pods              *PodsMetricSource              `protobuf:"bytes,3,opt,name=pods,proto3" json:"pods,omitempty"`
	Resource          *ResourceMetricSource          `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
	ContainerResource *ContainerResourceMetricSource `protobuf:"bytes,5,opt,name=containerResource,proto3" json:"containerResource,omitempty"`
	External          *ExternalMetricSource          `protobuf:"bytes,6,opt,name=external,proto3" json:"external,omitempty"`
}

func (m *HorizontalPodAutoscalerMetricSpec) Reset()         { *m = HorizontalPodAutoscalerMetricSpec{} }
func (m *HorizontalPodAutoscalerMetricSpec) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerMetricSpec) ProtoMessage()    {}
func (*HorizontalPodAutoscalerMetricSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{177}
}
func (m *HorizontalPodAutoscalerMetricSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscalerMetricSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscalerMetricSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscalerMetricSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerMetricSpec.Merge(m, src)
}
func (m *HorizontalPodAutoscalerMetricSpec) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscalerMetricSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerMetricSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerMetricSpec proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerMetricSpec) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *HorizontalPodAutoscalerMetricSpec) GetObject() *ObjectMetricSource {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricSpec) GetPods() *PodsMetricSource {
	if m != nil {
		return m.Pods
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricSpec) GetResource() *ResourceMetricSource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricSpec) GetContainerResource() *ContainerResourceMetricSource {
	if m != nil {
		return m.ContainerResource
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricSpec) GetExternal() *ExternalMetricSource {
	if m != nil {
		return m.External
	}
	return nil
}

type ObjectMetricSource struct {
	DescribedObject *ObjectReference  `protobuf:"bytes,1,opt,name=describedObject,proto3" json:"describedObject,omitempty"`
	Target          *MetricTarget     `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	Metric          *MetricIdentifier `protobuf:"bytes,3,opt,name=metric,proto3" json:"metric,omitempty"`
}

func (m *ObjectMetricSource) Reset()         { *m = ObjectMetricSource{} }
func (m *ObjectMetricSource) String() string { return proto.CompactTextString(m) }
func (*ObjectMetricSource) ProtoMessage()    {}
func (*ObjectMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{178}
}
func (m *ObjectMetricSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ObjectMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ObjectMetricSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ObjectMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectMetricSource.Merge(m, src)
}
func (m *ObjectMetricSource) XXX_Size() int {
	return m.Size()
}
func (m *ObjectMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectMetricSource proto.InternalMessageInfo

func (m *ObjectMetricSource) GetDescribedObject() *ObjectReference {
	if m != nil {
		return m.DescribedObject
	}
	return nil
}

func (m *ObjectMetricSource) GetTarget() *MetricTarget {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ObjectMetricSource) GetMetric() *MetricIdentifier {
	if m != nil {
		return m.Metric
	}
	return nil
}

type MetricTarget struct {
	Type  string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Value int64  `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *MetricTarget) Reset()         { *m = MetricTarget{} }
func (m *MetricTarget) String() string { return proto.CompactTextString(m) }
func (*MetricTarget) ProtoMessage()    {}
func (*MetricTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{179}
}
func (m *MetricTarget) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricTarget.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricTarget.Merge(m, src)
}
func (m *MetricTarget) XXX_Size() int {
	return m.Size()
}
func (m *MetricTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricTarget.DiscardUnknown(m)
}

var xxx_messageInfo_MetricTarget proto.InternalMessageInfo

func (m *MetricTarget) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *MetricTarget) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type MetricIdentifier struct {
	Name          string                      `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	LabelSelector []*LabelSelectorRequirement `protobuf:"bytes,2,rep,name=labelSelector,proto3" json:"labelSelector,omitempty"`
}

func (m *MetricIdentifier) Reset()         { *m = MetricIdentifier{} }
func (m *MetricIdentifier) String() string { return proto.CompactTextString(m) }
func (*MetricIdentifier) ProtoMessage()    {}
func (*MetricIdentifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{180}
}
func (m *MetricIdentifier) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricIdentifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricIdentifier.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricIdentifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricIdentifier.Merge(m, src)
}
func (m *MetricIdentifier) XXX_Size() int {
	return m.Size()
}
func (m *MetricIdentifier) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricIdentifier.DiscardUnknown(m)
}

var xxx_messageInfo_MetricIdentifier proto.InternalMessageInfo

func (m *MetricIdentifier) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MetricIdentifier) GetLabelSelector() []*LabelSelectorRequirement {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type PodsMetricSource struct {
	Metric *MetricIdentifier `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
	Target *MetricTarget     `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (m *PodsMetricSource) Reset()         { *m = PodsMetricSource{} }
func (m *PodsMetricSource) String() string { return proto.CompactTextString(m) }
func (*PodsMetricSource) ProtoMessage()    {}
func (*PodsMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{181}
}
func (m *PodsMetricSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodsMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodsMetricSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodsMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodsMetricSource.Merge(m, src)
}
func (m *PodsMetricSource) XXX_Size() int {
	return m.Size()
}
func (m *PodsMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_PodsMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_PodsMetricSource proto.InternalMessageInfo

func (m *PodsMetricSource) GetMetric() *MetricIdentifier {
	if m != nil {
		return m.Metric
	}
	return nil
}

func (m *PodsMetricSource) GetTarget() *MetricTarget {
	if m != nil {
		return m.Target
	}
	return nil
}

type ResourceMetricSource struct {
	ResourceName string        `protobuf:"bytes,1,opt,name=resourceName,proto3" json:"resourceName,omitempty"`
	Target       *MetricTarget `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (m *ResourceMetricSource) Reset()         { *m = ResourceMetricSource{} }
func (m *ResourceMetricSource) String() string { return proto.CompactTextString(m) }
func (*ResourceMetricSource) ProtoMessage()    {}
func (*ResourceMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{182}
}
func (m *ResourceMetricSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetricSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetricSource.Merge(m, src)
}
func (m *ResourceMetricSource) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetricSource proto.InternalMessageInfo

func (m *ResourceMetricSource) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ResourceMetricSource) GetTarget() *MetricTarget {
	if m != nil {
		return m.Target
	}
	return nil
}

type ContainerResourceMetricSource struct {
	ResourceName string        `protobuf:"bytes,1,opt,name=resourceName,proto3" json:"resourceName,omitempty"`
	Target       *MetricTarget `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	Container    string        `protobuf:"bytes,3,opt,name=container,proto3" json:"container,omitempty"`
}

func (m *ContainerResourceMetricSource) Reset()         { *m = ContainerResourceMetricSource{} }
func (m *ContainerResourceMetricSource) String() string { return proto.CompactTextString(m) }
func (*ContainerResourceMetricSource) ProtoMessage()    {}
func (*ContainerResourceMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{183}
}
func (m *ContainerResourceMetricSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerResourceMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerResourceMetricSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerResourceMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerResourceMetricSource.Merge(m, src)
}
func (m *ContainerResourceMetricSource) XXX_Size() int {
	return m.Size()
}
func (m *ContainerResourceMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerResourceMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerResourceMetricSource proto.InternalMessageInfo

func (m *ContainerResourceMetricSource) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ContainerResourceMetricSource) GetTarget() *MetricTarget {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ContainerResourceMetricSource) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

type ExternalMetricSource struct {
	Metric *MetricIdentifier `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
	Target *MetricTarget     `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (m *ExternalMetricSource) Reset()         { *m = ExternalMetricSource{} }
func (m *ExternalMetricSource) String() string { return proto.CompactTextString(m) }
func (*ExternalMetricSource) ProtoMessage()    {}
func (*ExternalMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{184}
}
func (m *ExternalMetricSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalMetricSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExternalMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalMetricSource.Merge(m, src)
}
func (m *ExternalMetricSource) XXX_Size() int {
	return m.Size()
}
func (m *ExternalMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalMetricSource proto.InternalMessageInfo

func (m *ExternalMetricSource) GetMetric() *MetricIdentifier {
	if m != nil {
		return m.Metric
	}
	return nil
}

func (m *ExternalMetricSource) GetTarget() *MetricTarget {
	if m != nil {
		return m.Target
	}
	return nil
}

type HorizontalPodAutoscalerBehavior struct {
	ScaleUp   *HPAScalingRules `protobuf:"bytes,1,opt,name=scaleUp,proto3" json:"scaleUp,omitempty"`
	ScaleDown *HPAScalingRules `protobuf:"bytes,2,opt,name=scaleDown,proto3" json:"scaleDown,omitempty"`
}

func (m *HorizontalPodAutoscalerBehavior) Reset()         { *m = HorizontalPodAutoscalerBehavior{} }
func (m *HorizontalPodAutoscalerBehavior) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerBehavior) ProtoMessage()    {}
func (*HorizontalPodAutoscalerBehavior) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{185}
}
func (m *HorizontalPodAutoscalerBehavior) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscalerBehavior) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscalerBehavior.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscalerBehavior) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerBehavior.Merge(m, src)
}
func (m *HorizontalPodAutoscalerBehavior) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscalerBehavior) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerBehavior.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerBehavior proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerBehavior) GetScaleUp() *HPAScalingRules {
	if m != nil {
		return m.ScaleUp
	}
	return nil
}

func (m *HorizontalPodAutoscalerBehavior) GetScaleDown() *HPAScalingRules {
	if m != nil {
		return m.ScaleDown
	}
	return nil
}

type HPAScalingRules struct {
	StabilizationWindowSeconds int32               `protobuf:"varint,1,opt,name=stabilizationWindowSeconds,proto3" json:"stabilizationWindowSeconds,omitempty"`
	SelectPolicy               string              `protobuf:"bytes,2,opt,name=selectPolicy,proto3" json:"selectPolicy,omitempty"`
	Policies                   []*HPAScalingPolicy `protobuf:"bytes,3,rep,name=policies,proto3" json:"policies,omitempty"`
}

func (m *HPAScalingRules) Reset()         { *m = HPAScalingRules{} }
func (m *HPAScalingRules) String() string { return proto.CompactTextString(m) }
func (*HPAScalingRules) ProtoMessage()    {}
func (*HPAScalingRules) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{186}
}
func (m *HPAScalingRules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HPAScalingRules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HPAScalingRules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HPAScalingRules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HPAScalingRules.Merge(m, src)
}
func (m *HPAScalingRules) XXX_Size() int {
	return m.Size()
}
func (m *HPAScalingRules) XXX_DiscardUnknown() {
	xxx_messageInfo_HPAScalingRules.DiscardUnknown(m)
}

var xxx_messageInfo_HPAScalingRules proto.InternalMessageInfo

func (m *HPAScalingRules) GetStabilizationWindowSeconds() int32 {
	if m != nil {
		return m.StabilizationWindowSeconds
	}
	return 0
}

func (m *HPAScalingRules) GetSelectPolicy() string {
	if m != nil {
		return m.SelectPolicy
	}
	return ""
}

func (m *HPAScalingRules) GetPolicies() []*HPAScalingPolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

type HPAScalingPolicy struct {
	Type          string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Value         int32  `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
	PeriodSeconds int32  `protobuf:"varint,3,opt,name=periodSeconds,proto3" json:"periodSeconds,omitempty"`
}

func (m *HPAScalingPolicy) Reset()         { *m = HPAScalingPolicy{} }
func (m *HPAScalingPolicy) String() string { return proto.CompactTextString(m) }
func (*HPAScalingPolicy) ProtoMessage()    {}
func (*HPAScalingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{187}
}
func (m *HPAScalingPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HPAScalingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HPAScalingPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HPAScalingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HPAScalingPolicy.Merge(m, src)
}
func (m *HPAScalingPolicy) XXX_Size() int {
	return m.Size()
}
func (m *HPAScalingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_HPAScalingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_HPAScalingPolicy proto.InternalMessageInfo

func (m *HPAScalingPolicy) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *HPAScalingPolicy) GetValue() int32 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *HPAScalingPolicy) GetPeriodSeconds() int32 {
	if m != nil {
		return m.PeriodSeconds
	}
	return 0
}

type HorizontalPodAutoscalerStatus struct {
	ObservedGeneration int64                                  `protobuf:"varint,1,opt,name=observedGeneration,proto3" json:"observedGeneration,omitempty"`
	LastScaleTime      int64                                  `protobuf:"varint,2,opt,name=lastScaleTime,proto3" json:"lastScaleTime,omitempty"`
	CurrentReplicas    int32                                  `protobuf:"varint,3,opt,name=currentReplicas,proto3" json:"currentReplicas,omitempty"`
	DesiredReplicas    int32                                  `protobuf:"varint,4,opt,name=desiredReplicas,proto3" json:"desiredReplicas,omitempty"`
	CurrentMetrics     []*HorizontalPodAutoscalerMetricStatus `protobuf:"bytes,5,rep,name=currentMetrics,proto3" json:"currentMetrics,omitempty"`
}

func (m *HorizontalPodAutoscalerStatus) Reset()         { *m = HorizontalPodAutoscalerStatus{} }
func (m *HorizontalPodAutoscalerStatus) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerStatus) ProtoMessage()    {}
func (*HorizontalPodAutoscalerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{188}
}
func (m *HorizontalPodAutoscalerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscalerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscalerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscalerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerStatus.Merge(m, src)
}
func (m *HorizontalPodAutoscalerStatus) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscalerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerStatus proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerStatus) GetObservedGeneration() int64 {
	if m != nil {
		return m.ObservedGeneration
	}
	return 0
}

func (m *HorizontalPodAutoscalerStatus) GetLastScaleTime() int64 {
	if m != nil {
		return m.LastScaleTime
	}
	return 0
}

func (m *HorizontalPodAutoscalerStatus) GetCurrentReplicas() int32 {
	if m != nil {
		return m.CurrentReplicas
	}
	return 0
}

func (m *HorizontalPodAutoscalerStatus) GetDesiredReplicas() int32 {
	if m != nil {
		return m.DesiredReplicas
	}
	return 0
}

func (m *HorizontalPodAutoscalerStatus) GetCurrentMetrics() []*HorizontalPodAutoscalerMetricStatus {
	if m != nil {
		return m.CurrentMetrics
	}
	return nil
}

type HorizontalPodAutoscalerCondition struct {
	ConditionType      string `protobuf:"bytes,1,opt,name=conditionType,proto3" json:"conditionType,omitempty"`
	ConditionStatus    string `protobuf:"bytes,2,opt,name=conditionStatus,proto3" json:"conditionStatus,omitempty"`
	LastTransitionTime int64  `protobuf:"varint,3,opt,name=lastTransitionTime,proto3" json:"lastTransitionTime,omitempty"`
	Reason             string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	Message            string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *HorizontalPodAutoscalerCondition) Reset()         { *m = HorizontalPodAutoscalerCondition{} }
func (m *HorizontalPodAutoscalerCondition) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerCondition) ProtoMessage()    {}
func (*HorizontalPodAutoscalerCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{189}
}
func (m *HorizontalPodAutoscalerCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscalerCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscalerCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscalerCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerCondition.Merge(m, src)
}
func (m *HorizontalPodAutoscalerCondition) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscalerCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerCondition.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerCondition proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerCondition) GetConditionType() string {
	if m != nil {
		return m.ConditionType
	}
	return ""
}

func (m *HorizontalPodAutoscalerCondition) GetConditionStatus() string {
	if m != nil {
		return m.ConditionStatus
	}
	return ""
}

func (m *HorizontalPodAutoscalerCondition) GetLastTransitionTime() int64 {
	if m != nil {
		return m.LastTransitionTime
	}
	return 0
}

func (m *HorizontalPodAutoscalerCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *HorizontalPodAutoscalerCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type HorizontalPodAutoscalerMetricStatus struct {
	Type              string                         `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Object            *ObjectMetricStatus            `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	Pods              *PodsMetricStatus              `protobuf:"bytes,3,opt,name=pods,proto3" json:"pods,omitempty"`
	Resource          *ResourceMetricStatus          `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
	ContainerResource *ContainerResourceMetricStatus `protobuf:"bytes,5,opt,name=containerResource,proto3" json:"containerResource,omitempty"`
	External          *ExternalMetricStatus          `protobuf:"bytes,6,opt,name=external,proto3" json:"external,omitempty"`
}

func (m *HorizontalPodAutoscalerMetricStatus) Reset()         { *m = HorizontalPodAutoscalerMetricStatus{} }
func (m *HorizontalPodAutoscalerMetricStatus) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerMetricStatus) ProtoMessage()    {}
func (*HorizontalPodAutoscalerMetricStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{190}
}
func (m *HorizontalPodAutoscalerMetricStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HorizontalPodAutoscalerMetricStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HorizontalPodAutoscalerMetricStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HorizontalPodAutoscalerMetricStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerMetricStatus.Merge(m, src)
}
func (m *HorizontalPodAutoscalerMetricStatus) XXX_Size() int {
	return m.Size()
}
func (m *HorizontalPodAutoscalerMetricStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerMetricStatus.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerMetricStatus proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerMetricStatus) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *HorizontalPodAutoscalerMetricStatus) GetObject() *ObjectMetricStatus {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricStatus) GetPods() *PodsMetricStatus {
	if m != nil {
		return m.Pods
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricStatus) GetResource() *ResourceMetricStatus {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricStatus) GetContainerResource() *ContainerResourceMetricStatus {
	if m != nil {
		return m.ContainerResource
	}
	return nil
}

func (m *HorizontalPodAutoscalerMetricStatus) GetExternal() *ExternalMetricStatus {
	if m != nil {
		return m.External
	}
	return nil
}

type ObjectMetricStatus struct {
	DescribedObject *ObjectReference  `protobuf:"bytes,1,opt,name=describedObject,proto3" json:"describedObject,omitempty"`
	Current         int64             `protobuf:"varint,2,opt,name=current,proto3" json:"current,omitempty"`
	Metric          *MetricIdentifier `protobuf:"bytes,3,opt,name=metric,proto3" json:"metric,omitempty"`
}

func (m *ObjectMetricStatus) Reset()         { *m = ObjectMetricStatus{} }
func (m *ObjectMetricStatus) String() string { return proto.CompactTextString(m) }
func (*ObjectMetricStatus) ProtoMessage()    {}
func (*ObjectMetricStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{191}
}
func (m *ObjectMetricStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ObjectMetricStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ObjectMetricStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ObjectMetricStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectMetricStatus.Merge(m, src)
}
func (m *ObjectMetricStatus) XXX_Size() int {
	return m.Size()
}
func (m *ObjectMetricStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectMetricStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectMetricStatus proto.InternalMessageInfo

func (m *ObjectMetricStatus) GetDescribedObject() *ObjectReference {
	if m != nil {
		return m.DescribedObject
	}
	return nil
}

func (m *ObjectMetricStatus) GetCurrent() int64 {
	if m != nil {
		return m.Current
	}
	return 0
}

func (m *ObjectMetricStatus) GetMetric() *MetricIdentifier {
	if m != nil {
		return m.Metric
	}
	return nil
}

type PodsMetricStatus struct {
	Metric  *MetricIdentifier `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
	Current int64             `protobuf:"varint,2,opt,name=current,proto3" json:"current,omitempty"`
}

func (m *PodsMetricStatus) Reset()         { *m = PodsMetricStatus{} }
func (m *PodsMetricStatus) String() string { return proto.CompactTextString(m) }
func (*PodsMetricStatus) ProtoMessage()    {}
func (*PodsMetricStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{192}
}
func (m *PodsMetricStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodsMetricStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodsMetricStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodsMetricStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodsMetricStatus.Merge(m, src)
}
func (m *PodsMetricStatus) XXX_Size() int {
	return m.Size()
}
func (m *PodsMetricStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PodsMetricStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PodsMetricStatus proto.InternalMessageInfo

func (m *PodsMetricStatus) GetMetric() *MetricIdentifier {
	if m != nil {
		return m.Metric
	}
	return nil
}

func (m *PodsMetricStatus) GetCurrent() int64 {
	if m != nil {
		return m.Current
	}
	return 0
}

type ResourceMetricStatus struct {
	ResourceName string `protobuf:"bytes,1,opt,name=resourceName,proto3" json:"resourceName,omitempty"`
	Current      int64  `protobuf:"varint,2,opt,name=current,proto3" json:"current,omitempty"`
}

func (m *ResourceMetricStatus) Reset()         { *m = ResourceMetricStatus{} }
func (m *ResourceMetricStatus) String() string { return proto.CompactTextString(m) }
func (*ResourceMetricStatus) ProtoMessage()    {}
func (*ResourceMetricStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{193}
}
func (m *ResourceMetricStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetricStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetricStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetricStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetricStatus.Merge(m, src)
}
func (m *ResourceMetricStatus) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetricStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetricStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetricStatus proto.InternalMessageInfo

func (m *ResourceMetricStatus) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ResourceMetricStatus) GetCurrent() int64 {
	if m != nil {
		return m.Current
	}
	return 0
}

type ContainerResourceMetricStatus struct {
	ResourceName string `protobuf:"bytes,1,opt,name=resourceName,proto3" json:"resourceName,omitempty"`
	Current      int64  `protobuf:"varint,2,opt,name=current,proto3" json:"current,omitempty"`
	Container    string `protobuf:"bytes,3,opt,name=container,proto3" json:"container,omitempty"`
}

func (m *ContainerResourceMetricStatus) Reset()         { *m = ContainerResourceMetricStatus{} }
func (m *ContainerResourceMetricStatus) String() string { return proto.CompactTextString(m) }
func (*ContainerResourceMetricStatus) ProtoMessage()    {}
func (*ContainerResourceMetricStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{194}
}
func (m *ContainerResourceMetricStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerResourceMetricStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerResourceMetricStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerResourceMetricStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerResourceMetricStatus.Merge(m, src)
}
func (m *ContainerResourceMetricStatus) XXX_Size() int {
	return m.Size()
}
func (m *ContainerResourceMetricStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerResourceMetricStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerResourceMetricStatus proto.InternalMessageInfo

func (m *ContainerResourceMetricStatus) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ContainerResourceMetricStatus) GetCurrent() int64 {
	if m != nil {
		return m.Current
	}
	return 0
}

func (m *ContainerResourceMetricStatus) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

type ExternalMetricStatus struct {
	Metric  *MetricIdentifier `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
	Current int64             `protobuf:"varint,2,opt,name=current,proto3" json:"current,omitempty"`
}

func (m *ExternalMetricStatus) Reset()         { *m = ExternalMetricStatus{} }
func (m *ExternalMetricStatus) String() string { return proto.CompactTextString(m) }
func (*ExternalMetricStatus) ProtoMessage()    {}
func (*ExternalMetricStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{195}
}
func (m *ExternalMetricStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalMetricStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalMetricStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExternalMetricStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalMetricStatus.Merge(m, src)
}
func (m *ExternalMetricStatus) XXX_Size() int {
	return m.Size()
}
func (m *ExternalMetricStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalMetricStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalMetricStatus proto.InternalMessageInfo

func (m *ExternalMetricStatus) GetMetric() *MetricIdentifier {
	if m != nil {
		return m.Metric
	}
	return nil
}

func (m *ExternalMetricStatus) GetCurrent() int64 {
	if m != nil {
		return m.Current
	}
	return 0
}

// https://github.com/kubernetes/api/blob/v0.23.15/networking/v1/generated.proto
type NetworkPolicy struct {
	Metadata *Metadata          `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec     *NetworkPolicySpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	Yaml     []byte             `protobuf:"bytes,3,opt,name=yaml,proto3" json:"yaml,omitempty"` // Deprecated: Do not use.
	Tags     []string           `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *NetworkPolicy) Reset()         { *m = NetworkPolicy{} }
func (m *NetworkPolicy) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicy) ProtoMessage()    {}
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{196}
}
func (m *NetworkPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicy.Merge(m, src)
}
func (m *NetworkPolicy) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicy proto.InternalMessageInfo

func (m *NetworkPolicy) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NetworkPolicy) GetSpec() *NetworkPolicySpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// Deprecated: Do not use.
func (m *NetworkPolicy) GetYaml() []byte {
	if m != nil {
		return m.Yaml
	}
	return nil
}

func (m *NetworkPolicy) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type NetworkPolicySpec struct {
	Selectors   []*LabelSelectorRequirement `protobuf:"bytes,1,rep,name=selectors,proto3" json:"selectors,omitempty"`
	Ingress     []*NetworkPolicyIngressRule `protobuf:"bytes,2,rep,name=ingress,proto3" json:"ingress,omitempty"`
	Egress      []*NetworkPolicyEgressRule  `protobuf:"bytes,3,rep,name=egress,proto3" json:"egress,omitempty"`
	PolicyTypes []string                    `protobuf:"bytes,4,rep,name=policyTypes,proto3" json:"policyTypes,omitempty"`
}

func (m *NetworkPolicySpec) Reset()         { *m = NetworkPolicySpec{} }
func (m *NetworkPolicySpec) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicySpec) ProtoMessage()    {}
func (*NetworkPolicySpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{197}
}
func (m *NetworkPolicySpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicySpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicySpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicySpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicySpec.Merge(m, src)
}
func (m *NetworkPolicySpec) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicySpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicySpec.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicySpec proto.InternalMessageInfo

func (m *NetworkPolicySpec) GetSelectors() []*LabelSelectorRequirement {
	if m != nil {
		return m.Selectors
	}
	return nil
}

func (m *NetworkPolicySpec) GetIngress() []*NetworkPolicyIngressRule {
	if m != nil {
		return m.Ingress
	}
	return nil
}

func (m *NetworkPolicySpec) GetEgress() []*NetworkPolicyEgressRule {
	if m != nil {
		return m.Egress
	}
	return nil
}

func (m *NetworkPolicySpec) GetPolicyTypes() []string {
	if m != nil {
		return m.PolicyTypes
	}
	return nil
}

type NetworkPolicyIPBlock struct {
	Cidr   string   `protobuf:"bytes,1,opt,name=cidr,proto3" json:"cidr,omitempty"`
	Except []string `protobuf:"bytes,2,rep,name=except,proto3" json:"except,omitempty"`
}

func (m *NetworkPolicyIPBlock) Reset()         { *m = NetworkPolicyIPBlock{} }
func (m *NetworkPolicyIPBlock) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyIPBlock) ProtoMessage()    {}
func (*NetworkPolicyIPBlock) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{198}
}
func (m *NetworkPolicyIPBlock) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicyIPBlock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicyIPBlock.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicyIPBlock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyIPBlock.Merge(m, src)
}
func (m *NetworkPolicyIPBlock) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicyIPBlock) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyIPBlock.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyIPBlock proto.InternalMessageInfo

func (m *NetworkPolicyIPBlock) GetCidr() string {
	if m != nil {
		return m.Cidr
	}
	return ""
}

func (m *NetworkPolicyIPBlock) GetExcept() []string {
	if m != nil {
		return m.Except
	}
	return nil
}

type NetworkPolicyIngressRule struct {
	Ports []*NetworkPolicyPort `protobuf:"bytes,1,rep,name=ports,proto3" json:"ports,omitempty"`
	From  []*NetworkPolicyPeer `protobuf:"bytes,2,rep,name=from,proto3" json:"from,omitempty"`
}

func (m *NetworkPolicyIngressRule) Reset()         { *m = NetworkPolicyIngressRule{} }
func (m *NetworkPolicyIngressRule) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyIngressRule) ProtoMessage()    {}
func (*NetworkPolicyIngressRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{199}
}
func (m *NetworkPolicyIngressRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicyIngressRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicyIngressRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicyIngressRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyIngressRule.Merge(m, src)
}
func (m *NetworkPolicyIngressRule) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicyIngressRule) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyIngressRule.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyIngressRule proto.InternalMessageInfo

func (m *NetworkPolicyIngressRule) GetPorts() []*NetworkPolicyPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *NetworkPolicyIngressRule) GetFrom() []*NetworkPolicyPeer {
	if m != nil {
		return m.From
	}
	return nil
}

type NetworkPolicyEgressRule struct {
	Ports []*NetworkPolicyPort `protobuf:"bytes,1,rep,name=ports,proto3" json:"ports,omitempty"`
	To    []*NetworkPolicyPeer `protobuf:"bytes,2,rep,name=to,proto3" json:"to,omitempty"`
}

func (m *NetworkPolicyEgressRule) Reset()         { *m = NetworkPolicyEgressRule{} }
func (m *NetworkPolicyEgressRule) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyEgressRule) ProtoMessage()    {}
func (*NetworkPolicyEgressRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{200}
}
func (m *NetworkPolicyEgressRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicyEgressRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicyEgressRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicyEgressRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyEgressRule.Merge(m, src)
}
func (m *NetworkPolicyEgressRule) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicyEgressRule) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyEgressRule.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyEgressRule proto.InternalMessageInfo

func (m *NetworkPolicyEgressRule) GetPorts() []*NetworkPolicyPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *NetworkPolicyEgressRule) GetTo() []*NetworkPolicyPeer {
	if m != nil {
		return m.To
	}
	return nil
}

type NetworkPolicyPeer struct {
	PodSelector          []*LabelSelectorRequirement `protobuf:"bytes,1,rep,name=podSelector,proto3" json:"podSelector,omitempty"`
	NamespaceSelector    []*LabelSelectorRequirement `protobuf:"bytes,2,rep,name=namespaceSelector,proto3" json:"namespaceSelector,omitempty"`
	IpBlock              *NetworkPolicyIPBlock       `protobuf:"bytes,3,opt,name=ipBlock,proto3" json:"ipBlock,omitempty"`
	HasPodSelector       bool                        `protobuf:"varint,4,opt,name=hasPodSelector,proto3" json:"hasPodSelector,omitempty"`
	HasNamespaceSelector bool                        `protobuf:"varint,5,opt,name=hasNamespaceSelector,proto3" json:"hasNamespaceSelector,omitempty"`
}

func (m *NetworkPolicyPeer) Reset()         { *m = NetworkPolicyPeer{} }
func (m *NetworkPolicyPeer) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyPeer) ProtoMessage()    {}
func (*NetworkPolicyPeer) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{201}
}
func (m *NetworkPolicyPeer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicyPeer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicyPeer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicyPeer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyPeer.Merge(m, src)
}
func (m *NetworkPolicyPeer) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicyPeer) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyPeer.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyPeer proto.InternalMessageInfo

func (m *NetworkPolicyPeer) GetPodSelector() []*LabelSelectorRequirement {
	if m != nil {
		return m.PodSelector
	}
	return nil
}

func (m *NetworkPolicyPeer) GetNamespaceSelector() []*LabelSelectorRequirement {
	if m != nil {
		return m.NamespaceSelector
	}
	return nil
}

func (m *NetworkPolicyPeer) GetIpBlock() *NetworkPolicyIPBlock {
	if m != nil {
		return m.IpBlock
	}
	return nil
}

func (m *NetworkPolicyPeer) GetHasPodSelector() bool {
	if m != nil {
		return m.HasPodSelector
	}
	return false
}

func (m *NetworkPolicyPeer) GetHasNamespaceSelector() bool {
	if m != nil {
		return m.HasNamespaceSelector
	}
	return false
}

type NetworkPolicyPort struct {
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Port     int32  `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	EndPort  int32  `protobuf:"varint,3,opt,name=endPort,proto3" json:"endPort,omitempty"`
}

func (m *NetworkPolicyPort) Reset()         { *m = NetworkPolicyPort{} }
func (m *NetworkPolicyPort) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyPort) ProtoMessage()    {}
func (*NetworkPolicyPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{202}
}
func (m *NetworkPolicyPort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicyPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicyPort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicyPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyPort.Merge(m, src)
}
func (m *NetworkPolicyPort) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicyPort) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyPort.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyPort proto.InternalMessageInfo

func (m *NetworkPolicyPort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *NetworkPolicyPort) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *NetworkPolicyPort) GetEndPort() int32 {
	if m != nil {
		return m.EndPort
	}
	return 0
}

// https://github.com/kubernetes/api/blob/v0.23.15/core/v1/types.go#L5800
type LimitRange struct {
	Metadata   *Metadata       `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Spec       *LimitRangeSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	LimitTypes []string        `protobuf:"bytes,3,rep,name=limitTypes,proto3" json:"limitTypes,omitempty"`
	Tags       []string        `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *LimitRange) Reset()         { *m = LimitRange{} }
func (m *LimitRange) String() string { return proto.CompactTextString(m) }
func (*LimitRange) ProtoMessage()    {}
func (*LimitRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{203}
}
func (m *LimitRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitRange.Merge(m, src)
}
func (m *LimitRange) XXX_Size() int {
	return m.Size()
}
func (m *LimitRange) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitRange.DiscardUnknown(m)
}

var xxx_messageInfo_LimitRange proto.InternalMessageInfo

func (m *LimitRange) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *LimitRange) GetSpec() *LimitRangeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *LimitRange) GetLimitTypes() []string {
	if m != nil {
		return m.LimitTypes
	}
	return nil
}

func (m *LimitRange) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type LimitRangeSpec struct {
	Limits []*LimitRangeItem `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty"`
}

func (m *LimitRangeSpec) Reset()         { *m = LimitRangeSpec{} }
func (m *LimitRangeSpec) String() string { return proto.CompactTextString(m) }
func (*LimitRangeSpec) ProtoMessage()    {}
func (*LimitRangeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{204}
}
func (m *LimitRangeSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitRangeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitRangeSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitRangeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitRangeSpec.Merge(m, src)
}
func (m *LimitRangeSpec) XXX_Size() int {
	return m.Size()
}
func (m *LimitRangeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitRangeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_LimitRangeSpec proto.InternalMessageInfo

func (m *LimitRangeSpec) GetLimits() []*LimitRangeItem {
	if m != nil {
		return m.Limits
	}
	return nil
}

type LimitRangeItem struct {
	Type                 string           `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Default              map[string]int64 `protobuf:"bytes,2,rep,name=default,proto3" json:"default,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	DefaultRequest       map[string]int64 `protobuf:"bytes,3,rep,name=defaultRequest,proto3" json:"defaultRequest,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	Max                  map[string]int64 `protobuf:"bytes,4,rep,name=max,proto3" json:"max,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	Min                  map[string]int64 `protobuf:"bytes,5,rep,name=min,proto3" json:"min,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	MaxLimitRequestRatio map[string]int64 `protobuf:"bytes,6,rep,name=maxLimitRequestRatio,proto3" json:"maxLimitRequestRatio,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *LimitRangeItem) Reset()         { *m = LimitRangeItem{} }
func (m *LimitRangeItem) String() string { return proto.CompactTextString(m) }
func (*LimitRangeItem) ProtoMessage()    {}
func (*LimitRangeItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{205}
}
func (m *LimitRangeItem) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitRangeItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitRangeItem.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitRangeItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitRangeItem.Merge(m, src)
}
func (m *LimitRangeItem) XXX_Size() int {
	return m.Size()
}
func (m *LimitRangeItem) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitRangeItem.DiscardUnknown(m)
}

var xxx_messageInfo_LimitRangeItem proto.InternalMessageInfo

func (m *LimitRangeItem) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *LimitRangeItem) GetDefault() map[string]int64 {
	if m != nil {
		return m.Default
	}
	return nil
}

func (m *LimitRangeItem) GetDefaultRequest() map[string]int64 {
	if m != nil {
		return m.DefaultRequest
	}
	return nil
}

func (m *LimitRangeItem) GetMax() map[string]int64 {
	if m != nil {
		return m.Max
	}
	return nil
}

func (m *LimitRangeItem) GetMin() map[string]int64 {
	if m != nil {
		return m.Min
	}
	return nil
}

func (m *LimitRangeItem) GetMaxLimitRequestRatio() map[string]int64 {
	if m != nil {
		return m.MaxLimitRequestRatio
	}
	return nil
}

// https://github.com/kubernetes/api/blob/v0.23.15/storage/v1/types.go#L33
type StorageClass struct {
	Metadata             *Metadata               `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Provisioner          string                  `protobuf:"bytes,2,opt,name=provisioner,proto3" json:"provisioner,omitempty"`
	Parameters           map[string]string       `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ReclaimPolicy        string                  `protobuf:"bytes,4,opt,name=reclaimPolicy,proto3" json:"reclaimPolicy,omitempty"`
	MountOptions         []string                `protobuf:"bytes,5,rep,name=mountOptions,proto3" json:"mountOptions,omitempty"`
	AllowVolumeExpansion bool                    `protobuf:"varint,6,opt,name=allowVolumeExpansion,proto3" json:"allowVolumeExpansion,omitempty"`
	AllowedTopologies    *StorageClassTopologies `protobuf:"bytes,7,opt,name=allowedTopologies,proto3" json:"allowedTopologies,omitempty"`
	VolumeBindingMode    string                  `protobuf:"bytes,8,opt,name=volumeBindingMode,proto3" json:"volumeBindingMode,omitempty"`
	Tags                 []string                `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *StorageClass) Reset()         { *m = StorageClass{} }
func (m *StorageClass) String() string { return proto.CompactTextString(m) }
func (*StorageClass) ProtoMessage()    {}
func (*StorageClass) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{206}
}
func (m *StorageClass) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageClass) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StorageClass.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StorageClass) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageClass.Merge(m, src)
}
func (m *StorageClass) XXX_Size() int {
	return m.Size()
}
func (m *StorageClass) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageClass.DiscardUnknown(m)
}

var xxx_messageInfo_StorageClass proto.InternalMessageInfo

func (m *StorageClass) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *StorageClass) GetProvisioner() string {
	if m != nil {
		return m.Provisioner
	}
	return ""
}

func (m *StorageClass) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *StorageClass) GetReclaimPolicy() string {
	if m != nil {
		return m.ReclaimPolicy
	}
	return ""
}

func (m *StorageClass) GetMountOptions() []string {
	if m != nil {
		return m.MountOptions
	}
	return nil
}

func (m *StorageClass) GetAllowVolumeExpansion() bool {
	if m != nil {
		return m.AllowVolumeExpansion
	}
	return false
}

func (m *StorageClass) GetAllowedTopologies() *StorageClassTopologies {
	if m != nil {
		return m.AllowedTopologies
	}
	return nil
}

func (m *StorageClass) GetVolumeBindingMode() string {
	if m != nil {
		return m.VolumeBindingMode
	}
	return ""
}

func (m *StorageClass) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type StorageClassTopologies struct {
	LabelSelectors []*TopologyLabelSelector `protobuf:"bytes,1,rep,name=labelSelectors,proto3" json:"labelSelectors,omitempty"`
}

func (m *StorageClassTopologies) Reset()         { *m = StorageClassTopologies{} }
func (m *StorageClassTopologies) String() string { return proto.CompactTextString(m) }
func (*StorageClassTopologies) ProtoMessage()    {}
func (*StorageClassTopologies) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{207}
}
func (m *StorageClassTopologies) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageClassTopologies) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StorageClassTopologies.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StorageClassTopologies) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageClassTopologies.Merge(m, src)
}
func (m *StorageClassTopologies) XXX_Size() int {
	return m.Size()
}
func (m *StorageClassTopologies) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageClassTopologies.DiscardUnknown(m)
}

var xxx_messageInfo_StorageClassTopologies proto.InternalMessageInfo

func (m *StorageClassTopologies) GetLabelSelectors() []*TopologyLabelSelector {
	if m != nil {
		return m.LabelSelectors
	}
	return nil
}

type TopologyLabelSelector struct {
	Key    string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Values []string `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
}

func (m *TopologyLabelSelector) Reset()         { *m = TopologyLabelSelector{} }
func (m *TopologyLabelSelector) String() string { return proto.CompactTextString(m) }
func (*TopologyLabelSelector) ProtoMessage()    {}
func (*TopologyLabelSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_69b34851fbf62631, []int{208}
}
func (m *TopologyLabelSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TopologyLabelSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TopologyLabelSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TopologyLabelSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TopologyLabelSelector.Merge(m, src)
}
func (m *TopologyLabelSelector) XXX_Size() int {
	return m.Size()
}
func (m *TopologyLabelSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_TopologyLabelSelector.DiscardUnknown(m)
}

var xxx_messageInfo_TopologyLabelSelector proto.InternalMessageInfo

func (m *TopologyLabelSelector) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *TopologyLabelSelector) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func init() {
	proto.RegisterEnum("datadog.process_agent.ContainerHostType", ContainerHostType_name, ContainerHostType_value)
	proto.RegisterEnum("datadog.process_agent.Language", Language_name, Language_value)
	proto.RegisterEnum("datadog.process_agent.ServiceNameSource", ServiceNameSource_name, ServiceNameSource_value)
	proto.RegisterEnum("datadog.process_agent.ContainerState", ContainerState_name, ContainerState_value)
	proto.RegisterEnum("datadog.process_agent.ContainerHealth", ContainerHealth_name, ContainerHealth_value)
	proto.RegisterEnum("datadog.process_agent.ProcessState", ProcessState_name, ProcessState_value)
	proto.RegisterEnum("datadog.process_agent.ConnectionType", ConnectionType_name, ConnectionType_value)
	proto.RegisterEnum("datadog.process_agent.OrchestratorResource", OrchestratorResource_name, OrchestratorResource_value)
	proto.RegisterEnum("datadog.process_agent.ResourceRequirementsType", ResourceRequirementsType_name, ResourceRequirementsType_value)
	proto.RegisterEnum("datadog.process_agent.PostgresOperation", PostgresOperation_name, PostgresOperation_value)
	proto.RegisterEnum("datadog.process_agent.RedisCommand", RedisCommand_name, RedisCommand_value)
	proto.RegisterEnum("datadog.process_agent.RedisErrorType", RedisErrorType_name, RedisErrorType_value)
	proto.RegisterEnum("datadog.process_agent.HTTPResponseStatus", HTTPResponseStatus_name, HTTPResponseStatus_value)
	proto.RegisterEnum("datadog.process_agent.HTTPMethod", HTTPMethod_name, HTTPMethod_value)
	proto.RegisterEnum("datadog.process_agent.IntOrString_Type", IntOrString_Type_name, IntOrString_Type_value)
	proto.RegisterType((*ResCollector)(nil), "datadog.process_agent.ResCollector")
	proto.RegisterType((*ResCollector_Header)(nil), "datadog.process_agent.ResCollector.Header")
	proto.RegisterType((*CollectorProc)(nil), "datadog.process_agent.CollectorProc")
	proto.RegisterType((*CollectorProcDiscovery)(nil), "datadog.process_agent.CollectorProcDiscovery")
	proto.RegisterType((*CollectorRealTime)(nil), "datadog.process_agent.CollectorRealTime")
	proto.RegisterType((*CollectorContainer)(nil), "datadog.process_agent.CollectorContainer")
	proto.RegisterType((*CollectorContainerRealTime)(nil), "datadog.process_agent.CollectorContainerRealTime")
	proto.RegisterType((*CollectorReqStatus)(nil), "datadog.process_agent.CollectorReqStatus")
	proto.RegisterType((*CollectorECSTask)(nil), "datadog.process_agent.CollectorECSTask")
	proto.RegisterType((*ECSTask)(nil), "datadog.process_agent.ECSTask")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.ECSTask.EphemeralStorageMetricsEntry")
	proto.RegisterMapType((map[string]float64)(nil), "datadog.process_agent.ECSTask.LimitsEntry")
	proto.RegisterType((*ECSContainer)(nil), "datadog.process_agent.ECSContainer")
	proto.RegisterMapType((map[string]float64)(nil), "datadog.process_agent.ECSContainer.LimitsEntry")
	proto.RegisterMapType((map[string]string)(nil), "datadog.process_agent.ECSContainer.LogOptionsEntry")
	proto.RegisterType((*ECSContainerNetwork)(nil), "datadog.process_agent.ECSContainerNetwork")
	proto.RegisterType((*ECSContainerPort)(nil), "datadog.process_agent.ECSContainerPort")
	proto.RegisterType((*ECSContainerVolume)(nil), "datadog.process_agent.ECSContainerVolume")
	proto.RegisterType((*ECSContainerHealth)(nil), "datadog.process_agent.ECSContainerHealth")
	proto.RegisterType((*ECSContainerExitCode)(nil), "datadog.process_agent.ECSContainerExitCode")
	proto.RegisterType((*CollectorPod)(nil), "datadog.process_agent.CollectorPod")
	proto.RegisterType((*CollectorPodDisruptionBudget)(nil), "datadog.process_agent.CollectorPodDisruptionBudget")
	proto.RegisterType((*CollectorReplicaSet)(nil), "datadog.process_agent.CollectorReplicaSet")
	proto.RegisterType((*CollectorDeployment)(nil), "datadog.process_agent.CollectorDeployment")
	proto.RegisterType((*CollectorService)(nil), "datadog.process_agent.CollectorService")
	proto.RegisterType((*CollectorNode)(nil), "datadog.process_agent.CollectorNode")
	proto.RegisterMapType((map[string]*Host)(nil), "datadog.process_agent.CollectorNode.HostAliasMappingEntry")
	proto.RegisterType((*CollectorCluster)(nil), "datadog.process_agent.CollectorCluster")
	proto.RegisterType((*CollectorManifest)(nil), "datadog.process_agent.CollectorManifest")
	proto.RegisterType((*CollectorManifestCRD)(nil), "datadog.process_agent.CollectorManifestCRD")
	proto.RegisterType((*CollectorManifestCR)(nil), "datadog.process_agent.CollectorManifestCR")
	proto.RegisterType((*CollectorNamespace)(nil), "datadog.process_agent.CollectorNamespace")
	proto.RegisterType((*CollectorJob)(nil), "datadog.process_agent.CollectorJob")
	proto.RegisterType((*CollectorCronJob)(nil), "datadog.process_agent.CollectorCronJob")
	proto.RegisterType((*CollectorDaemonSet)(nil), "datadog.process_agent.CollectorDaemonSet")
	proto.RegisterType((*CollectorStatefulSet)(nil), "datadog.process_agent.CollectorStatefulSet")
	proto.RegisterType((*CollectorPersistentVolume)(nil), "datadog.process_agent.CollectorPersistentVolume")
	proto.RegisterType((*CollectorPersistentVolumeClaim)(nil), "datadog.process_agent.CollectorPersistentVolumeClaim")
	proto.RegisterType((*CollectorRole)(nil), "datadog.process_agent.CollectorRole")
	proto.RegisterType((*CollectorRoleBinding)(nil), "datadog.process_agent.CollectorRoleBinding")
	proto.RegisterType((*CollectorClusterRole)(nil), "datadog.process_agent.CollectorClusterRole")
	proto.RegisterType((*CollectorClusterRoleBinding)(nil), "datadog.process_agent.CollectorClusterRoleBinding")
	proto.RegisterType((*CollectorServiceAccount)(nil), "datadog.process_agent.CollectorServiceAccount")
	proto.RegisterType((*CollectorIngress)(nil), "datadog.process_agent.CollectorIngress")
	proto.RegisterType((*CollectorVerticalPodAutoscaler)(nil), "datadog.process_agent.CollectorVerticalPodAutoscaler")
	proto.RegisterType((*CollectorHorizontalPodAutoscaler)(nil), "datadog.process_agent.CollectorHorizontalPodAutoscaler")
	proto.RegisterType((*CollectorNetworkPolicy)(nil), "datadog.process_agent.CollectorNetworkPolicy")
	proto.RegisterType((*CollectorLimitRange)(nil), "datadog.process_agent.CollectorLimitRange")
	proto.RegisterType((*CollectorStorageClass)(nil), "datadog.process_agent.CollectorStorageClass")
	proto.RegisterType((*AgentVersion)(nil), "datadog.process_agent.AgentVersion")
	proto.RegisterType((*CollectorStatus)(nil), "datadog.process_agent.CollectorStatus")
	proto.RegisterType((*TracerMetadata)(nil), "datadog.process_agent.TracerMetadata")
	proto.RegisterType((*PortInfo)(nil), "datadog.process_agent.PortInfo")
	proto.RegisterType((*Process)(nil), "datadog.process_agent.Process")
	proto.RegisterType((*ServiceDiscovery)(nil), "datadog.process_agent.ServiceDiscovery")
	proto.RegisterType((*ServiceName)(nil), "datadog.process_agent.ServiceName")
	proto.RegisterType((*ProcessDiscovery)(nil), "datadog.process_agent.ProcessDiscovery")
	proto.RegisterType((*Command)(nil), "datadog.process_agent.Command")
	proto.RegisterType((*ProcessUser)(nil), "datadog.process_agent.ProcessUser")
	proto.RegisterType((*ProcessNetworks)(nil), "datadog.process_agent.ProcessNetworks")
	proto.RegisterType((*ContainerAddr)(nil), "datadog.process_agent.ContainerAddr")
	proto.RegisterType((*Container)(nil), "datadog.process_agent.Container")
	proto.RegisterType((*ProcessStat)(nil), "datadog.process_agent.ProcessStat")
	proto.RegisterType((*ProcStatsWithPerm)(nil), "datadog.process_agent.ProcStatsWithPerm")
	proto.RegisterType((*ProcStatsWithPermByPID)(nil), "datadog.process_agent.ProcStatsWithPermByPID")
	proto.RegisterMapType((map[int32]*ProcStatsWithPerm)(nil), "datadog.process_agent.ProcStatsWithPermByPID.StatsByPIDEntry")
	proto.RegisterType((*ContainerStat)(nil), "datadog.process_agent.ContainerStat")
	proto.RegisterType((*SystemInfo)(nil), "datadog.process_agent.SystemInfo")
	proto.RegisterType((*OSInfo)(nil), "datadog.process_agent.OSInfo")
	proto.RegisterType((*IOStat)(nil), "datadog.process_agent.IOStat")
	proto.RegisterType((*MemoryStat)(nil), "datadog.process_agent.MemoryStat")
	proto.RegisterType((*CPUStat)(nil), "datadog.process_agent.CPUStat")
	proto.RegisterType((*SingleCPUStat)(nil), "datadog.process_agent.SingleCPUStat")
	proto.RegisterType((*CPUInfo)(nil), "datadog.process_agent.CPUInfo")
	proto.RegisterType((*Host)(nil), "datadog.process_agent.Host")
	proto.RegisterType((*Cluster)(nil), "datadog.process_agent.Cluster")
	proto.RegisterMapType((map[string]int32)(nil), "datadog.process_agent.Cluster.ApiServerVersionsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.Cluster.ExtendedResourcesAllocatableEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.Cluster.ExtendedResourcesCapacityEntry")
	proto.RegisterMapType((map[string]int32)(nil), "datadog.process_agent.Cluster.KubeletVersionsEntry")
	proto.RegisterType((*ClusterNodeInfo)(nil), "datadog.process_agent.ClusterNodeInfo")
	proto.RegisterMapType((map[string]string)(nil), "datadog.process_agent.ClusterNodeInfo.ResourceAllocatableEntry")
	proto.RegisterMapType((map[string]string)(nil), "datadog.process_agent.ClusterNodeInfo.ResourceCapacityEntry")
	proto.RegisterType((*Metadata)(nil), "datadog.process_agent.Metadata")
	proto.RegisterType((*OwnerReference)(nil), "datadog.process_agent.OwnerReference")
	proto.RegisterType((*ObjectReference)(nil), "datadog.process_agent.ObjectReference")
	proto.RegisterType((*ServicePort)(nil), "datadog.process_agent.ServicePort")
	proto.RegisterType((*ServiceSessionAffinityConfig)(nil), "datadog.process_agent.ServiceSessionAffinityConfig")
	proto.RegisterType((*Node)(nil), "datadog.process_agent.Node")
	proto.RegisterType((*NodeStatus)(nil), "datadog.process_agent.NodeStatus")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.NodeStatus.AllocatableEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.NodeStatus.CapacityEntry")
	proto.RegisterMapType((map[string]string)(nil), "datadog.process_agent.NodeStatus.NodeAddressesEntry")
	proto.RegisterType((*NodeCondition)(nil), "datadog.process_agent.NodeCondition")
	proto.RegisterType((*ContainerImage)(nil), "datadog.process_agent.ContainerImage")
	proto.RegisterType((*Taint)(nil), "datadog.process_agent.Taint")
	proto.RegisterType((*ServiceSpec)(nil), "datadog.process_agent.ServiceSpec")
	proto.RegisterType((*ServiceStatus)(nil), "datadog.process_agent.ServiceStatus")
	proto.RegisterType((*Service)(nil), "datadog.process_agent.Service")
	proto.RegisterType((*DeploymentCondition)(nil), "datadog.process_agent.DeploymentCondition")
	proto.RegisterType((*Deployment)(nil), "datadog.process_agent.Deployment")
	proto.RegisterType((*ReplicaSetCondition)(nil), "datadog.process_agent.ReplicaSetCondition")
	proto.RegisterType((*ReplicaSet)(nil), "datadog.process_agent.ReplicaSet")
	proto.RegisterType((*LabelSelectorRequirement)(nil), "datadog.process_agent.LabelSelectorRequirement")
	proto.RegisterType((*PodDisruptionBudget)(nil), "datadog.process_agent.PodDisruptionBudget")
	proto.RegisterType((*PodDisruptionBudgetSpec)(nil), "datadog.process_agent.PodDisruptionBudgetSpec")
	proto.RegisterType((*PodDisruptionBudgetStatus)(nil), "datadog.process_agent.PodDisruptionBudgetStatus")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.PodDisruptionBudgetStatus.DisruptedPodsEntry")
	proto.RegisterType((*IntOrString)(nil), "datadog.process_agent.IntOrString")
	proto.RegisterType((*Condition)(nil), "datadog.process_agent.Condition")
	proto.RegisterType((*Pod)(nil), "datadog.process_agent.Pod")
	proto.RegisterType((*PodCondition)(nil), "datadog.process_agent.PodCondition")
	proto.RegisterType((*ContainerStatus)(nil), "datadog.process_agent.ContainerStatus")
	proto.RegisterType((*NodeAffinity)(nil), "datadog.process_agent.NodeAffinity")
	proto.RegisterType((*NodeSelector)(nil), "datadog.process_agent.NodeSelector")
	proto.RegisterType((*PreferredSchedulingTerm)(nil), "datadog.process_agent.PreferredSchedulingTerm")
	proto.RegisterType((*Manifest)(nil), "datadog.process_agent.Manifest")
	proto.RegisterType((*NamespaceCondition)(nil), "datadog.process_agent.NamespaceCondition")
	proto.RegisterType((*Namespace)(nil), "datadog.process_agent.Namespace")
	proto.RegisterType((*ResourceRequirements)(nil), "datadog.process_agent.ResourceRequirements")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.ResourceRequirements.LimitsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.ResourceRequirements.RequestsEntry")
	proto.RegisterType((*ResourceMetrics)(nil), "datadog.process_agent.ResourceMetrics")
	proto.RegisterMapType((map[string]float64)(nil), "datadog.process_agent.ResourceMetrics.MetricValuesEntry")
	proto.RegisterType((*JobSpec)(nil), "datadog.process_agent.JobSpec")
	proto.RegisterType((*JobStatus)(nil), "datadog.process_agent.JobStatus")
	proto.RegisterType((*JobCondition)(nil), "datadog.process_agent.JobCondition")
	proto.RegisterType((*Job)(nil), "datadog.process_agent.Job")
	proto.RegisterType((*CronJobSpec)(nil), "datadog.process_agent.CronJobSpec")
	proto.RegisterType((*CronJobStatus)(nil), "datadog.process_agent.CronJobStatus")
	proto.RegisterType((*CronJob)(nil), "datadog.process_agent.CronJob")
	proto.RegisterType((*DaemonSetSpec)(nil), "datadog.process_agent.DaemonSetSpec")
	proto.RegisterType((*DaemonSetStatus)(nil), "datadog.process_agent.DaemonSetStatus")
	proto.RegisterType((*DaemonSetCondition)(nil), "datadog.process_agent.DaemonSetCondition")
	proto.RegisterType((*DaemonSet)(nil), "datadog.process_agent.DaemonSet")
	proto.RegisterType((*StatefulSetSpec)(nil), "datadog.process_agent.StatefulSetSpec")
	proto.RegisterType((*StatefulSetStatus)(nil), "datadog.process_agent.StatefulSetStatus")
	proto.RegisterType((*StatefulSetCondition)(nil), "datadog.process_agent.StatefulSetCondition")
	proto.RegisterType((*StatefulSet)(nil), "datadog.process_agent.StatefulSet")
	proto.RegisterType((*PersistentVolume)(nil), "datadog.process_agent.PersistentVolume")
	proto.RegisterType((*PersistentVolumeSpec)(nil), "datadog.process_agent.PersistentVolumeSpec")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.PersistentVolumeSpec.CapacityEntry")
	proto.RegisterType((*PersistentVolumeSource)(nil), "datadog.process_agent.PersistentVolumeSource")
	proto.RegisterType((*GCEPersistentDiskVolumeSource)(nil), "datadog.process_agent.GCEPersistentDiskVolumeSource")
	proto.RegisterType((*AWSElasticBlockStoreVolumeSource)(nil), "datadog.process_agent.AWSElasticBlockStoreVolumeSource")
	proto.RegisterType((*AzureFilePersistentVolumeSource)(nil), "datadog.process_agent.AzureFilePersistentVolumeSource")
	proto.RegisterType((*AzureDiskVolumeSource)(nil), "datadog.process_agent.AzureDiskVolumeSource")
	proto.RegisterType((*CSIVolumeSource)(nil), "datadog.process_agent.CSIVolumeSource")
	proto.RegisterMapType((map[string]string)(nil), "datadog.process_agent.CSIVolumeSource.VolumeAttributesEntry")
	proto.RegisterType((*SecretReference)(nil), "datadog.process_agent.SecretReference")
	proto.RegisterType((*PersistentVolumeStatus)(nil), "datadog.process_agent.PersistentVolumeStatus")
	proto.RegisterType((*NodeSelectorTerm)(nil), "datadog.process_agent.NodeSelectorTerm")
	proto.RegisterType((*PersistentVolumeClaim)(nil), "datadog.process_agent.PersistentVolumeClaim")
	proto.RegisterType((*PersistentVolumeClaimStatus)(nil), "datadog.process_agent.PersistentVolumeClaimStatus")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.PersistentVolumeClaimStatus.CapacityEntry")
	proto.RegisterType((*PersistentVolumeClaimSpec)(nil), "datadog.process_agent.PersistentVolumeClaimSpec")
	proto.RegisterType((*TypedLocalObjectReference)(nil), "datadog.process_agent.TypedLocalObjectReference")
	proto.RegisterType((*PersistentVolumeClaimCondition)(nil), "datadog.process_agent.PersistentVolumeClaimCondition")
	proto.RegisterType((*PolicyRule)(nil), "datadog.process_agent.PolicyRule")
	proto.RegisterType((*Subject)(nil), "datadog.process_agent.Subject")
	proto.RegisterType((*Role)(nil), "datadog.process_agent.Role")
	proto.RegisterType((*RoleBinding)(nil), "datadog.process_agent.RoleBinding")
	proto.RegisterType((*ClusterRole)(nil), "datadog.process_agent.ClusterRole")
	proto.RegisterType((*ClusterRoleBinding)(nil), "datadog.process_agent.ClusterRoleBinding")
	proto.RegisterType((*ServiceAccount)(nil), "datadog.process_agent.ServiceAccount")
	proto.RegisterType((*IngressServiceBackend)(nil), "datadog.process_agent.IngressServiceBackend")
	proto.RegisterType((*IngressBackend)(nil), "datadog.process_agent.IngressBackend")
	proto.RegisterType((*IngressTLS)(nil), "datadog.process_agent.IngressTLS")
	proto.RegisterType((*HTTPIngressPath)(nil), "datadog.process_agent.HTTPIngressPath")
	proto.RegisterType((*IngressRule)(nil), "datadog.process_agent.IngressRule")
	proto.RegisterType((*IngressSpec)(nil), "datadog.process_agent.IngressSpec")
	proto.RegisterType((*PortStatus)(nil), "datadog.process_agent.PortStatus")
	proto.RegisterType((*LoadBalancerIngress)(nil), "datadog.process_agent.LoadBalancerIngress")
	proto.RegisterType((*IngressStatus)(nil), "datadog.process_agent.IngressStatus")
	proto.RegisterType((*Ingress)(nil), "datadog.process_agent.Ingress")
	proto.RegisterType((*KafkaStats)(nil), "datadog.process_agent.KafkaStats")
	proto.RegisterType((*KafkaRequestHeader)(nil), "datadog.process_agent.KafkaRequestHeader")
	proto.RegisterType((*KafkaAggregation)(nil), "datadog.process_agent.KafkaAggregation")
	proto.RegisterMapType((map[int32]*KafkaStats)(nil), "datadog.process_agent.KafkaAggregation.StatsByErrorCodeEntry")
	proto.RegisterType((*DataStreamsAggregations)(nil), "datadog.process_agent.DataStreamsAggregations")
	proto.RegisterType((*PostgresStats)(nil), "datadog.process_agent.PostgresStats")
	proto.RegisterType((*RedisStats)(nil), "datadog.process_agent.RedisStats")
	proto.RegisterMapType((map[int32]*RedisStatsEntry)(nil), "datadog.process_agent.RedisStats.ErrorToStatsEntry")
	proto.RegisterType((*RedisStatsEntry)(nil), "datadog.process_agent.RedisStatsEntry")
	proto.RegisterType((*DatabaseStats)(nil), "datadog.process_agent.DatabaseStats")
	proto.RegisterType((*DatabaseAggregations)(nil), "datadog.process_agent.DatabaseAggregations")
	proto.RegisterType((*HTTPAggregations)(nil), "datadog.process_agent.HTTPAggregations")
	proto.RegisterType((*HTTP2Aggregations)(nil), "datadog.process_agent.HTTP2Aggregations")
	proto.RegisterType((*HTTPStats)(nil), "datadog.process_agent.HTTPStats")
	proto.RegisterMapType((map[int32]*HTTPStats_Data)(nil), "datadog.process_agent.HTTPStats.StatsByStatusCodeEntry")
	proto.RegisterType((*HTTPStats_Data)(nil), "datadog.process_agent.HTTPStats.Data")
	proto.RegisterType((*DNSDatabaseEntry)(nil), "datadog.process_agent.DNSDatabaseEntry")
	proto.RegisterType((*ResourceList)(nil), "datadog.process_agent.ResourceList")
	proto.RegisterMapType((map[string]float64)(nil), "datadog.process_agent.ResourceList.MetricValuesEntry")
	proto.RegisterType((*VerticalPodAutoscaler)(nil), "datadog.process_agent.VerticalPodAutoscaler")
	proto.RegisterType((*VerticalPodAutoscalerCondition)(nil), "datadog.process_agent.VerticalPodAutoscalerCondition")
	proto.RegisterType((*VerticalPodAutoscalerSpec)(nil), "datadog.process_agent.VerticalPodAutoscalerSpec")
	proto.RegisterType((*VerticalPodAutoscalerTarget)(nil), "datadog.process_agent.VerticalPodAutoscalerTarget")
	proto.RegisterType((*ContainerResourcePolicy)(nil), "datadog.process_agent.ContainerResourcePolicy")
	proto.RegisterType((*VerticalPodAutoscalerStatus)(nil), "datadog.process_agent.VerticalPodAutoscalerStatus")
	proto.RegisterType((*ContainerRecommendation)(nil), "datadog.process_agent.ContainerRecommendation")
	proto.RegisterType((*VPACondition)(nil), "datadog.process_agent.VPACondition")
	proto.RegisterType((*HorizontalPodAutoscaler)(nil), "datadog.process_agent.HorizontalPodAutoscaler")
	proto.RegisterType((*HorizontalPodAutoscalerSpec)(nil), "datadog.process_agent.HorizontalPodAutoscalerSpec")
	proto.RegisterType((*HorizontalPodAutoscalerTarget)(nil), "datadog.process_agent.HorizontalPodAutoscalerTarget")
	proto.RegisterType((*HorizontalPodAutoscalerMetricSpec)(nil), "datadog.process_agent.HorizontalPodAutoscalerMetricSpec")
	proto.RegisterType((*ObjectMetricSource)(nil), "datadog.process_agent.ObjectMetricSource")
	proto.RegisterType((*MetricTarget)(nil), "datadog.process_agent.MetricTarget")
	proto.RegisterType((*MetricIdentifier)(nil), "datadog.process_agent.MetricIdentifier")
	proto.RegisterType((*PodsMetricSource)(nil), "datadog.process_agent.PodsMetricSource")
	proto.RegisterType((*ResourceMetricSource)(nil), "datadog.process_agent.ResourceMetricSource")
	proto.RegisterType((*ContainerResourceMetricSource)(nil), "datadog.process_agent.ContainerResourceMetricSource")
	proto.RegisterType((*ExternalMetricSource)(nil), "datadog.process_agent.ExternalMetricSource")
	proto.RegisterType((*HorizontalPodAutoscalerBehavior)(nil), "datadog.process_agent.HorizontalPodAutoscalerBehavior")
	proto.RegisterType((*HPAScalingRules)(nil), "datadog.process_agent.HPAScalingRules")
	proto.RegisterType((*HPAScalingPolicy)(nil), "datadog.process_agent.HPAScalingPolicy")
	proto.RegisterType((*HorizontalPodAutoscalerStatus)(nil), "datadog.process_agent.HorizontalPodAutoscalerStatus")
	proto.RegisterType((*HorizontalPodAutoscalerCondition)(nil), "datadog.process_agent.HorizontalPodAutoscalerCondition")
	proto.RegisterType((*HorizontalPodAutoscalerMetricStatus)(nil), "datadog.process_agent.HorizontalPodAutoscalerMetricStatus")
	proto.RegisterType((*ObjectMetricStatus)(nil), "datadog.process_agent.ObjectMetricStatus")
	proto.RegisterType((*PodsMetricStatus)(nil), "datadog.process_agent.PodsMetricStatus")
	proto.RegisterType((*ResourceMetricStatus)(nil), "datadog.process_agent.ResourceMetricStatus")
	proto.RegisterType((*ContainerResourceMetricStatus)(nil), "datadog.process_agent.ContainerResourceMetricStatus")
	proto.RegisterType((*ExternalMetricStatus)(nil), "datadog.process_agent.ExternalMetricStatus")
	proto.RegisterType((*NetworkPolicy)(nil), "datadog.process_agent.NetworkPolicy")
	proto.RegisterType((*NetworkPolicySpec)(nil), "datadog.process_agent.NetworkPolicySpec")
	proto.RegisterType((*NetworkPolicyIPBlock)(nil), "datadog.process_agent.NetworkPolicyIPBlock")
	proto.RegisterType((*NetworkPolicyIngressRule)(nil), "datadog.process_agent.NetworkPolicyIngressRule")
	proto.RegisterType((*NetworkPolicyEgressRule)(nil), "datadog.process_agent.NetworkPolicyEgressRule")
	proto.RegisterType((*NetworkPolicyPeer)(nil), "datadog.process_agent.NetworkPolicyPeer")
	proto.RegisterType((*NetworkPolicyPort)(nil), "datadog.process_agent.NetworkPolicyPort")
	proto.RegisterType((*LimitRange)(nil), "datadog.process_agent.LimitRange")
	proto.RegisterType((*LimitRangeSpec)(nil), "datadog.process_agent.LimitRangeSpec")
	proto.RegisterType((*LimitRangeItem)(nil), "datadog.process_agent.LimitRangeItem")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.LimitRangeItem.DefaultEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.LimitRangeItem.DefaultRequestEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.LimitRangeItem.MaxEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.LimitRangeItem.MaxLimitRequestRatioEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.LimitRangeItem.MinEntry")
	proto.RegisterType((*StorageClass)(nil), "datadog.process_agent.StorageClass")
	proto.RegisterMapType((map[string]string)(nil), "datadog.process_agent.StorageClass.ParametersEntry")
	proto.RegisterType((*StorageClassTopologies)(nil), "datadog.process_agent.StorageClassTopologies")
	proto.RegisterType((*TopologyLabelSelector)(nil), "datadog.process_agent.TopologyLabelSelector")
}

func init() { proto.RegisterFile("proto/process/agent.proto", fileDescriptor_69b34851fbf62631) }

var fileDescriptor_69b34851fbf62631 = []byte{
	// 13680 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x7d, 0x6b, 0x8c, 0x24, 0x49,
	0x7a, 0xd0, 0x64, 0x3d, 0xba, 0xaa, 0xbe, 0x7e, 0x65, 0xc7, 0x74, 0xcf, 0xd4, 0xf4, 0xce, 0xce,
	0xcd, 0xe6, 0xee, 0xed, 0xce, 0xcd, 0xed, 0xf5, 0xae, 0xe7, 0xf6, 0xf6, 0x66, 0xdf, 0xdb, 0x5d,
	0x5d, 0x33, 0xd3, 0x33, 0xfd, 0xa8, 0xcb, 0xea, 0x9e, 0xf1, 0xed, 0xdd, 0x79, 0x2f, 0x3b, 0x33,
	0xba, 0x3b, 0xaf, 0xab, 0x32, 0xeb, 0x32, 0xb3, 0x7a, 0xa6, 0xd7, 0xf0, 0x03, 0x0e, 0x23, 0x10,
	0x0f, 0x9f, 0x38, 0xc3, 0xd9, 0x3f, 0xb0, 0x30, 0xc6, 0xc8, 0x0f, 0x7c, 0xb6, 0x41, 0xc2, 0x0f,
	0x84, 0x0c, 0x06, 0xcb, 0x08, 0x4b, 0x60, 0x64, 0x23, 0x8c, 0x90, 0x25, 0xfb, 0x0e, 0x4b, 0xf6,
	0x0f, 0x10, 0x48, 0x60, 0x24, 0x2c, 0x01, 0x8a, 0x57, 0x66, 0xe4, 0xab, 0x1e, 0xdd, 0xd3, 0x3b,
	0x7b, 0xe2, 0x57, 0x55, 0x7c, 0x11, 0xdf, 0x17, 0x91, 0x5f, 0x44, 0x7c, 0xf1, 0x45, 0xc4, 0xf7,
	0x7d, 0x01, 0x97, 0x7a, 0x9e, 0x1b, 0xb8, 0x2f, 0xf5, 0x3c, 0xd7, 0xc4, 0xbe, 0xff, 0x92, 0xb1,
	0x8f, 0x9d, 0x60, 0x89, 0xc2, 0xd0, 0x82, 0x65, 0x04, 0x86, 0xe5, 0xee, 0x2f, 0xf1, 0xcc, 0xf7,
	0x69, 0xa6, 0xf6, 0xaf, 0x15, 0x98, 0xd2, 0xb1, 0xdf, 0x70, 0x3b, 0x1d, 0x6c, 0x06, 0xae, 0x87,
	0x56, 0x60, 0xe2, 0x00, 0x1b, 0x16, 0xf6, 0xea, 0xca, 0x55, 0xe5, 0xda, 0xe4, 0x8d, 0xeb, 0x4b,
	0x99, 0x88, 0x4b, 0x32, 0xd2, 0xd2, 0x1d, 0x8a, 0xa1, 0x73, 0x4c, 0x54, 0x87, 0x4a, 0x17, 0xfb,
	0xbe, 0xb1, 0x8f, 0xeb, 0x85, 0xab, 0xca, 0xb5, 0x9a, 0x2e, 0x92, 0xe8, 0x6d, 0x98, 0xf0, 0x03,
	0x23, 0xe8, 0xfb, 0xf5, 0x22, 0xa5, 0xfe, 0x7c, 0x0e, 0xf5, 0x90, 0x74, 0x9b, 0x96, 0xd6, 0x39,
	0xd6, 0xe2, 0x65, 0x98, 0x60, 0x75, 0x21, 0x04, 0xa5, 0xe0, 0xb8, 0x87, 0xeb, 0xa5, 0xab, 0xca,
	0xb5, 0xb2, 0x4e, 0xff, 0x6b, 0xff, 0xbb, 0x08, 0xd3, 0x21, 0x66, 0xcb, 0x73, 0x4d, 0xb4, 0x08,
	0xd5, 0x03, 0xd7, 0x0f, 0x36, 0x8d, 0xae, 0x68, 0x4a, 0x98, 0x46, 0x97, 0xa1, 0xe6, 0xe0, 0xe0,
	0xa1, 0xeb, 0x1d, 0xae, 0x59, 0xf5, 0x49, 0x9a, 0x19, 0x01, 0xd0, 0x9b, 0x50, 0xe3, 0x4d, 0xc2,
	0xa4, 0xb1, 0xc5, 0x6b, 0x93, 0x37, 0xae, 0xe4, 0x34, 0xb6, 0xc5, 0x52, 0x7a, 0x84, 0x80, 0x5e,
	0x82, 0x12, 0xa9, 0x87, 0xb6, 0x6e, 0xf2, 0xc6, 0x53, 0x39, 0x88, 0x77, 0x5c, 0x3f, 0xd0, 0x69,
	0x41, 0xf4, 0x19, 0x28, 0xd9, 0xce, 0x9e, 0x5b, 0x2f, 0x53, 0x84, 0x67, 0x72, 0x10, 0xda, 0xc7,
	0x7e, 0x80, 0xbb, 0x6b, 0xce, 0x9e, 0xab, 0xd3, 0xe2, 0x84, 0xd3, 0xfb, 0x9e, 0xdb, 0xef, 0xad,
	0x59, 0xf5, 0x09, 0xca, 0x08, 0x91, 0x24, 0x5f, 0x47, 0xff, 0xb6, 0xed, 0x0f, 0x70, 0xbd, 0x42,
	0xf3, 0x22, 0x00, 0x7a, 0x17, 0xc0, 0x74, 0x9d, 0xc0, 0xb0, 0x1d, 0xec, 0xf9, 0x75, 0xa0, 0x9f,
	0x77, 0x35, 0xb7, 0x2f, 0x78, 0x41, 0x5d, 0xc2, 0x41, 0xf7, 0x61, 0x2e, 0x4c, 0x91, 0xef, 0xd8,
	0x26, 0x9d, 0x31, 0x75, 0x55, 0xb9, 0x36, 0x73, 0xe3, 0xda, 0x30, 0x42, 0xa2, 0xbc, 0x9e, 0x26,
	0x81, 0x2e, 0x43, 0xf5, 0xc0, 0x76, 0x82, 0x0d, 0xc3, 0x3f, 0xac, 0xcf, 0x90, 0x66, 0xdf, 0x39,
	0xa7, 0x87, 0x90, 0x95, 0x0a, 0x94, 0xc9, 0x7f, 0xff, 0x6e, 0xa9, 0x3a, 0xad, 0xce, 0xdc, 0x2d,
	0x55, 0xab, 0x6a, 0xed, 0x6e, 0xa9, 0x5a, 0x53, 0x41, 0xfb, 0x13, 0x05, 0x2e, 0xc4, 0x3a, 0x7f,
	0xd5, 0xf6, 0x4d, 0xf7, 0x08, 0x7b, 0xc7, 0xb1, 0x51, 0xa0, 0x24, 0x46, 0x81, 0xc4, 0xc1, 0xc2,
	0x00, 0x0e, 0x16, 0x93, 0x1c, 0x7c, 0x00, 0x88, 0x7f, 0x9d, 0xa8, 0xc7, 0xc6, 0x7e, 0xbd, 0x44,
	0x39, 0xf9, 0xc2, 0xe0, 0x81, 0x12, 0x36, 0x4c, 0xcf, 0x20, 0x11, 0x0e, 0x9d, 0xf2, 0x88, 0x43,
	0x47, 0xfb, 0x85, 0x22, 0xcc, 0x85, 0x1f, 0xae, 0x63, 0xa3, 0xb3, 0x6d, 0x77, 0xf1, 0xc0, 0x91,
	0x7f, 0x13, 0xca, 0x64, 0x3e, 0x89, 0x71, 0xad, 0x0d, 0x6e, 0x2e, 0x99, 0x82, 0x3a, 0x43, 0x40,
	0x17, 0x60, 0x82, 0x50, 0x59, 0xb3, 0xe8, 0xc8, 0x2e, 0xea, 0x3c, 0x85, 0xe6, 0xa1, 0xec, 0x7a,
	0xfb, 0x6b, 0x16, 0x6d, 0x75, 0x59, 0x67, 0x89, 0x13, 0x8f, 0xce, 0x3a, 0x54, 0x9c, 0x7e, 0xb7,
	0xd1, 0xeb, 0xfb, 0xf5, 0x2a, 0xc3, 0xe3, 0x49, 0x74, 0x15, 0x26, 0x03, 0x37, 0x30, 0x3a, 0x1b,
	0xb8, 0xeb, 0x7a, 0xc7, 0xf5, 0x1a, 0x6d, 0x84, 0x0c, 0x42, 0xeb, 0x30, 0x13, 0x0e, 0xaa, 0x36,
	0xfd, 0x48, 0x36, 0xba, 0x9f, 0x1b, 0x36, 0x28, 0xe9, 0x67, 0x26, 0x70, 0xb3, 0x47, 0xf9, 0xe4,
	0xa9, 0x47, 0xb9, 0xf6, 0x43, 0x45, 0x40, 0x61, 0x9f, 0x85, 0x18, 0x03, 0x07, 0xea, 0x60, 0x71,
	0x25, 0xe4, 0x47, 0x61, 0x3c, 0xf9, 0x11, 0x97, 0x03, 0xc5, 0x13, 0xc8, 0x01, 0xa9, 0x8f, 0x4b,
	0x03, 0xfa, 0xb8, 0x9c, 0xec, 0x63, 0x31, 0xcc, 0xab, 0xa3, 0x4a, 0xc8, 0xcc, 0xae, 0xa8, 0x9d,
	0xba, 0x2b, 0xee, 0x96, 0xaa, 0x13, 0x6a, 0xe5, 0x6e, 0xa9, 0x5a, 0x51, 0xab, 0xda, 0xef, 0x16,
	0x60, 0x31, 0xdd, 0x2d, 0x99, 0x73, 0x2a, 0xd9, 0x3d, 0xaf, 0x8b, 0x39, 0x55, 0x18, 0x63, 0xb8,
	0xf1, 0x59, 0x25, 0x8d, 0xf7, 0xe2, 0xc0, 0xf1, 0x5e, 0x4a, 0x8f, 0xf7, 0x68, 0x46, 0x96, 0x63,
	0x33, 0xf2, 0xa4, 0x73, 0x2f, 0x93, 0xcd, 0xd5, 0xd3, 0x8f, 0xf8, 0x97, 0xa5, 0x01, 0xaf, 0xe3,
	0xaf, 0xb2, 0x75, 0x7d, 0x90, 0x94, 0xd2, 0x7e, 0xaf, 0x08, 0x6a, 0x88, 0xd2, 0x6c, 0xb4, 0xb7,
	0x0d, 0xff, 0x10, 0x69, 0x30, 0x65, 0x3c, 0xf4, 0x97, 0x4d, 0xd3, 0xed, 0x3b, 0xc1, 0xda, 0x2a,
	0xed, 0x86, 0xa2, 0x1e, 0x83, 0x11, 0xa6, 0x99, 0x9d, 0xbe, 0x1f, 0x60, 0x4f, 0xa2, 0x2b, 0x83,
	0x08, 0x0b, 0x78, 0x72, 0xcd, 0xa2, 0x2c, 0xaf, 0xe9, 0x11, 0x80, 0xb0, 0xd4, 0xc3, 0xfb, 0xb6,
	0xeb, 0x50, 0x7e, 0xd7, 0x74, 0x9e, 0x92, 0x59, 0x5a, 0x1e, 0xc0, 0xd2, 0x89, 0x24, 0x4b, 0x5f,
	0x81, 0x72, 0x60, 0xf8, 0x87, 0x7e, 0xbd, 0x32, 0x50, 0x8d, 0xe0, 0x9f, 0xa8, 0xb3, 0xc2, 0x54,
	0xc1, 0x31, 0xf6, 0x89, 0x04, 0x2c, 0x5e, 0xab, 0xe9, 0xf4, 0x7f, 0x38, 0x69, 0x6a, 0xa3, 0x4e,
	0x1a, 0x99, 0xbf, 0x90, 0x18, 0xb1, 0x42, 0x64, 0x4c, 0x8e, 0x27, 0x32, 0x6e, 0xc3, 0x14, 0xcd,
	0xb9, 0x8f, 0x3d, 0x9f, 0xf0, 0x68, 0x8a, 0xa2, 0x3f, 0x9b, 0x83, 0xbe, 0x2c, 0x15, 0xd5, 0x63,
	0x88, 0xda, 0x0f, 0x56, 0xa1, 0x22, 0xba, 0x55, 0x85, 0xa2, 0xe1, 0x39, 0x7c, 0x52, 0x91, 0xbf,
	0xe8, 0x1a, 0xcc, 0x7a, 0xd8, 0x77, 0xfb, 0x9e, 0x89, 0x45, 0x4d, 0xac, 0x23, 0x93, 0x60, 0x74,
	0x05, 0xa0, 0x63, 0xf4, 0x1d, 0xf3, 0x80, 0x0e, 0x55, 0xd6, 0x9b, 0x12, 0x04, 0x3d, 0x07, 0xd3,
	0x16, 0xf6, 0x6d, 0x0f, 0x5b, 0x6c, 0xd0, 0xf1, 0x5e, 0x8d, 0x03, 0xc9, 0xa0, 0x39, 0x74, 0xdc,
	0x87, 0x0e, 0x2f, 0x53, 0x66, 0x83, 0x46, 0x02, 0x91, 0x61, 0xb1, 0x67, 0x74, 0xed, 0xce, 0x31,
	0xed, 0xe1, 0x9a, 0xce, 0x53, 0x64, 0x58, 0x1c, 0xf1, 0x16, 0x56, 0x98, 0xb6, 0xcb, 0x93, 0xe8,
	0x3a, 0xa8, 0xc6, 0x91, 0x61, 0x77, 0x8c, 0x5d, 0xbb, 0x63, 0x07, 0xc7, 0xef, 0xb9, 0x0e, 0x9b,
	0x4a, 0x35, 0x3d, 0x05, 0x27, 0x7a, 0x77, 0xc7, 0xee, 0xda, 0x81, 0x5f, 0xaf, 0xd1, 0x51, 0x72,
	0x7d, 0xf0, 0x28, 0x59, 0x5a, 0xa7, 0x85, 0x9b, 0x4e, 0xe0, 0x1d, 0xeb, 0x1c, 0x13, 0xf5, 0xe1,
	0x22, 0xee, 0x1d, 0xe0, 0x2e, 0xf6, 0x8c, 0x4e, 0x3b, 0x70, 0x3d, 0x63, 0x1f, 0x6f, 0xe0, 0xc0,
	0xb3, 0x4d, 0xb1, 0x08, 0xbe, 0x31, 0x84, 0x68, 0x33, 0x1b, 0x9b, 0xd5, 0x92, 0x47, 0x9b, 0xb0,
	0xce, 0xc7, 0xde, 0x91, 0x6d, 0x62, 0x3a, 0xce, 0xd8, 0xda, 0x24, 0x83, 0x88, 0x7a, 0x70, 0xd4,
	0x33, 0xd7, 0x2c, 0x3a, 0x58, 0x6a, 0x3a, 0x4b, 0x90, 0x8e, 0xe9, 0xf5, 0x3b, 0x9d, 0x76, 0x60,
	0x78, 0x01, 0xb6, 0x96, 0x83, 0xfa, 0x34, 0x9d, 0xcc, 0x71, 0x60, 0x54, 0xca, 0xed, 0xf5, 0x68,
	0xa9, 0x19, 0xb9, 0x14, 0x07, 0xa2, 0x25, 0x40, 0xf8, 0x11, 0x36, 0xfb, 0x81, 0xed, 0x3a, 0x51,
	0xd1, 0x59, 0x5a, 0x34, 0x23, 0x07, 0x35, 0x62, 0x0b, 0x9f, 0x4a, 0xb9, 0xf3, 0x6c, 0x3e, 0x77,
	0xb2, 0xd7, 0x3e, 0x31, 0x45, 0xe7, 0xa4, 0x29, 0x5a, 0x87, 0x0a, 0x36, 0xfd, 0x6d, 0x02, 0x46,
	0x14, 0x2c, 0x92, 0xe8, 0x15, 0x58, 0x08, 0x71, 0xd7, 0x1c, 0x3f, 0x30, 0x1c, 0x13, 0xd3, 0x72,
	0xe7, 0x69, 0xb9, 0xec, 0xcc, 0x70, 0xca, 0xcf, 0x8f, 0x3a, 0xe5, 0x6f, 0xc0, 0x7c, 0x8a, 0xd2,
	0xb2, 0xe7, 0xd4, 0x17, 0x28, 0xeb, 0x33, 0xf3, 0x16, 0x5f, 0x83, 0x49, 0x69, 0x3c, 0x91, 0xd9,
	0x78, 0x88, 0x8f, 0xc5, 0x6c, 0x3c, 0xc4, 0xc7, 0xb4, 0x03, 0x8d, 0x4e, 0x9f, 0x09, 0x53, 0x45,
	0x67, 0x89, 0xd7, 0x0b, 0x37, 0x95, 0xc5, 0xbb, 0x70, 0x79, 0xd0, 0xa8, 0x19, 0x46, 0xab, 0x28,
	0xd1, 0xd2, 0xfe, 0x61, 0x15, 0xa6, 0x64, 0x66, 0x13, 0xf1, 0x65, 0xb9, 0xe6, 0x21, 0xf6, 0xb8,
	0xa4, 0xaf, 0xe9, 0x61, 0x9a, 0x4c, 0x7b, 0xf6, 0x5f, 0x12, 0xf2, 0x12, 0x84, 0x74, 0x8e, 0x43,
	0x72, 0x98, 0x40, 0xa0, 0xff, 0x49, 0xd5, 0x76, 0x97, 0x6c, 0x4b, 0x99, 0x08, 0x60, 0x09, 0xd2,
	0x65, 0xf4, 0xcf, 0xda, 0x2a, 0x9f, 0xf6, 0x22, 0x49, 0xd7, 0x09, 0x0f, 0x1b, 0x6c, 0x74, 0x4e,
	0xd0, 0xe6, 0x46, 0x00, 0x92, 0xeb, 0x87, 0x63, 0xb7, 0xc2, 0x72, 0x43, 0x00, 0x69, 0xdf, 0x9e,
	0xed, 0xd8, 0xfe, 0x01, 0xcd, 0xae, 0xd2, 0x6c, 0x09, 0x92, 0x16, 0x4b, 0xb5, 0x11, 0xc4, 0x12,
	0xa4, 0xc5, 0xd2, 0x6d, 0xa8, 0xe2, 0x47, 0x76, 0xd0, 0x70, 0x2d, 0xcc, 0x45, 0xf9, 0x27, 0x47,
	0x18, 0xc7, 0x4d, 0x8e, 0xa2, 0x87, 0xc8, 0xe1, 0x8e, 0x9a, 0xcd, 0x51, 0xfa, 0x9f, 0x7c, 0x62,
	0xc7, 0xdd, 0x5f, 0xf5, 0xec, 0x23, 0xec, 0xd1, 0xe9, 0x59, 0xd3, 0x23, 0x00, 0x6a, 0x03, 0x74,
	0xdc, 0xfd, 0xad, 0x1e, 0x99, 0x5a, 0x7e, 0x7d, 0x86, 0x4e, 0xa2, 0x4f, 0x8f, 0x50, 0xf9, 0xd2,
	0x7a, 0x88, 0xc5, 0x44, 0x8b, 0x44, 0x86, 0xac, 0xf0, 0xe1, 0x18, 0x25, 0xe3, 0x76, 0x96, 0xd6,
	0x1a, 0x83, 0xa1, 0xb7, 0xa0, 0xdc, 0x73, 0xbd, 0x40, 0x4c, 0xdc, 0x17, 0x46, 0xa8, 0xb3, 0xe5,
	0x7a, 0x81, 0xce, 0xb0, 0xd0, 0x2d, 0xa8, 0x72, 0xcd, 0x99, 0xcd, 0xdd, 0x81, 0xd2, 0x36, 0xa4,
	0xb0, 0xc9, 0x50, 0xf4, 0x10, 0x17, 0x35, 0xa0, 0x72, 0xe4, 0x76, 0xfa, 0x5d, 0xcc, 0xe6, 0xfa,
	0xe4, 0x8d, 0x4f, 0x8c, 0x40, 0xe6, 0x3e, 0xc5, 0xd0, 0x05, 0x26, 0x5a, 0xa6, 0x07, 0x2e, 0x9d,
	0xe0, 0xa0, 0x7e, 0x9e, 0xf6, 0xde, 0x28, 0x34, 0xee, 0x50, 0x04, 0x9d, 0x23, 0x92, 0x95, 0xa9,
	0x63, 0xec, 0xe2, 0x8e, 0x5f, 0x9f, 0xa7, 0xa2, 0x84, 0xa7, 0xd0, 0xed, 0x70, 0x4d, 0x59, 0xa0,
	0xcd, 0x7b, 0x69, 0xa4, 0xbe, 0xc9, 0x58, 0x58, 0x88, 0x84, 0x77, 0x8c, 0x9e, 0x7f, 0xe0, 0x06,
	0x01, 0xf6, 0xea, 0x17, 0xb8, 0x84, 0x8f, 0x40, 0x8b, 0x6f, 0xc1, 0x6c, 0xa2, 0x53, 0x87, 0xcd,
	0xfc, 0x9a, 0x2c, 0x45, 0x4e, 0x2e, 0x80, 0xb4, 0xaf, 0x29, 0x70, 0x3e, 0xa3, 0x9b, 0x48, 0x9b,
	0x79, 0x47, 0x6d, 0x90, 0xa9, 0xc1, 0x68, 0xc9, 0x20, 0x32, 0x03, 0xed, 0xde, 0xd1, 0x2b, 0xcb,
	0x96, 0xe5, 0xb1, 0x63, 0x9e, 0x02, 0xe5, 0x5e, 0x1c, 0xc8, 0x4b, 0xbd, 0x1a, 0x95, 0x2a, 0x86,
	0xa5, 0x22, 0xa0, 0xf6, 0x97, 0x14, 0x50, 0x93, 0xc3, 0x8d, 0xa0, 0x9a, 0x32, 0x80, 0x36, 0xa2,
	0xac, 0xc7, 0x81, 0x44, 0xc8, 0xd1, 0x23, 0x3a, 0xd3, 0xed, 0x08, 0x1d, 0x58, 0xa4, 0x43, 0xed,
	0xbe, 0xc7, 0xc5, 0x18, 0x4f, 0x09, 0xbd, 0x8e, 0x12, 0x65, 0xdb, 0xae, 0x30, 0xad, 0x39, 0x80,
	0xd2, 0xe3, 0x2d, 0x21, 0x2e, 0x95, 0x94, 0xb8, 0xbc, 0x00, 0x13, 0x4c, 0xad, 0xe2, 0x6d, 0xe0,
	0x29, 0xc2, 0x46, 0x0b, 0xfb, 0x81, 0xed, 0x18, 0xa4, 0x6b, 0x79, 0x33, 0x64, 0x90, 0xf6, 0xe3,
	0x4a, 0xbc, 0xc2, 0x3b, 0xe1, 0xa0, 0xe4, 0x47, 0x7d, 0x0a, 0x27, 0xc8, 0xe4, 0xd5, 0x3c, 0x94,
	0x7d, 0xdb, 0x31, 0x43, 0xf1, 0x4f, 0x13, 0x31, 0x29, 0x56, 0x3c, 0x8d, 0x14, 0xbb, 0x00, 0x13,
	0x6e, 0x3f, 0xe8, 0xf5, 0x03, 0xa1, 0xbc, 0xb3, 0x94, 0x76, 0x03, 0xe6, 0xb3, 0x30, 0x09, 0x27,
	0x63, 0x15, 0x97, 0x23, 0x5a, 0xda, 0x3f, 0x29, 0xc2, 0x54, 0x74, 0xa4, 0xe4, 0x5a, 0x03, 0x37,
	0x80, 0xa7, 0xdd, 0x75, 0x9c, 0x74, 0x23, 0xbd, 0x04, 0xa5, 0x9e, 0x6b, 0xf9, 0xf5, 0x09, 0x3a,
	0xc5, 0x17, 0xf3, 0xce, 0x72, 0x5c, 0x4b, 0xa7, 0xe5, 0x42, 0x85, 0xa2, 0x32, 0xaa, 0x42, 0x91,
	0xb5, 0x11, 0x11, 0x7b, 0x87, 0xda, 0x78, 0x7b, 0x07, 0x0d, 0xa6, 0x6c, 0x7f, 0x1b, 0x7b, 0x5d,
	0x32, 0x76, 0xb0, 0x45, 0x97, 0xb3, 0xaa, 0x1e, 0x83, 0xa5, 0xf6, 0x17, 0x93, 0x27, 0xdd, 0x5f,
	0xfc, 0x76, 0x01, 0x2e, 0xcb, 0xbd, 0xb7, 0x6a, 0xfb, 0x5e, 0x9f, 0x0a, 0xa8, 0x95, 0xbe, 0xb5,
	0x8f, 0x83, 0x64, 0x8f, 0x29, 0x43, 0x7a, 0xac, 0x30, 0xa0, 0xc7, 0x8a, 0xf1, 0x1e, 0xfb, 0x3e,
	0x98, 0xef, 0xa5, 0x2b, 0x14, 0xc7, 0x83, 0xd7, 0xf3, 0xfb, 0x28, 0x89, 0xa2, 0x67, 0xd2, 0x09,
	0xbb, 0xa4, 0x2c, 0x75, 0xc9, 0xe0, 0x3d, 0x68, 0x92, 0xab, 0x95, 0x93, 0x72, 0xf5, 0xe7, 0x0a,
	0x70, 0x5e, 0xda, 0xc8, 0xf7, 0x3a, 0xb6, 0x69, 0xb4, 0xcf, 0x94, 0x99, 0xb1, 0x0f, 0x2b, 0x25,
	0x3f, 0xac, 0x01, 0x93, 0x5e, 0xd8, 0x0a, 0xc6, 0x91, 0xfc, 0x01, 0x19, 0xb5, 0x57, 0x97, 0xb1,
	0x42, 0x7e, 0x4e, 0x48, 0xfc, 0x3c, 0x1b, 0x8e, 0xad, 0xe2, 0x5e, 0xc7, 0x3d, 0xee, 0x62, 0xe7,
	0x89, 0x72, 0xcc, 0x0a, 0x5b, 0x31, 0x8c, 0x63, 0x51, 0x7b, 0x75, 0x19, 0xeb, 0x6c, 0x39, 0xf6,
	0xe3, 0x05, 0xe9, 0xe4, 0xa7, 0xcd, 0xf6, 0x91, 0x4f, 0x8c, 0x5d, 0xaf, 0x43, 0x95, 0x6f, 0x65,
	0x05, 0xaf, 0xf2, 0x0e, 0x70, 0x78, 0x4b, 0xf5, 0xb0, 0xfc, 0xd9, 0x72, 0xe9, 0x0f, 0xe4, 0xdb,
	0xae, 0x4d, 0xb2, 0x96, 0x3d, 0x29, 0x16, 0x7d, 0x0f, 0x94, 0x1d, 0xd7, 0x0a, 0xf9, 0x93, 0xb7,
	0xa6, 0x90, 0x36, 0xea, 0xac, 0x64, 0x26, 0x67, 0xf6, 0x40, 0x25, 0x0b, 0xce, 0x72, 0xc7, 0x36,
	0xfc, 0x0d, 0xa3, 0xd7, 0xb3, 0x9d, 0x7d, 0x7e, 0x64, 0xf6, 0xfa, 0xb0, 0x6b, 0x42, 0x42, 0x9a,
	0xae, 0x59, 0x32, 0x32, 0xd3, 0x61, 0x53, 0x34, 0x53, 0x3d, 0x50, 0x3d, 0x61, 0x0f, 0x2c, 0x7e,
	0x19, 0x16, 0x32, 0xeb, 0xcc, 0xd0, 0x5f, 0xbf, 0x47, 0xd6, 0x5f, 0x87, 0x2c, 0xbb, 0x92, 0x72,
	0xfb, 0x63, 0xf2, 0x4c, 0x68, 0xb0, 0x8e, 0x7a, 0x62, 0xdd, 0x7c, 0x13, 0x2a, 0x9c, 0x08, 0xbf,
	0x9c, 0xca, 0x9b, 0x08, 0xbc, 0xa1, 0xba, 0x28, 0x7e, 0xb6, 0xf3, 0xe0, 0x5f, 0x14, 0xa4, 0xfb,
	0xaf, 0x0d, 0xc3, 0xb1, 0xf7, 0xb0, 0xff, 0xe4, 0xa4, 0xeb, 0x5b, 0x50, 0xeb, 0xf2, 0x36, 0x88,
	0xf9, 0xf0, 0xb1, 0x9c, 0x6f, 0x12, 0x6d, 0xd5, 0x23, 0x8c, 0x4c, 0x4e, 0xc9, 0x5a, 0x67, 0x25,
	0xa1, 0x75, 0x3e, 0xae, 0xb1, 0xac, 0xf5, 0x60, 0x3e, 0xc5, 0xc4, 0x86, 0xbe, 0x8a, 0x56, 0xa1,
	0x2a, 0x5a, 0xc7, 0x2d, 0x02, 0xae, 0x0d, 0x9b, 0x8c, 0xe1, 0x77, 0x85, 0x98, 0xe1, 0x67, 0x15,
	0xa2, 0xcf, 0xd2, 0x5c, 0x69, 0x59, 0x8c, 0x6a, 0x3c, 0xc3, 0x0a, 0x7f, 0xa6, 0x20, 0xdd, 0x41,
	0x10, 0xee, 0xf9, 0x3d, 0xe3, 0x09, 0x2e, 0x2c, 0xef, 0x02, 0x38, 0xa2, 0x11, 0x62, 0xa8, 0xe4,
	0xdd, 0xbd, 0x85, 0xad, 0xd5, 0x25, 0x9c, 0xb3, 0x9d, 0x56, 0xdf, 0x28, 0x48, 0x9b, 0x9f, 0xbb,
	0xee, 0xee, 0x13, 0xe3, 0xd3, 0x12, 0x94, 0xbe, 0xe2, 0xee, 0x0a, 0x0e, 0xe5, 0x6d, 0x70, 0xee,
	0xba, 0xbb, 0x3a, 0x2d, 0xf7, 0x21, 0xaa, 0x26, 0x0d, 0xcf, 0x75, 0x9e, 0x24, 0x67, 0x5e, 0x87,
	0xaa, 0xc9, 0x9a, 0x30, 0x4c, 0x35, 0xe1, 0x2d, 0xd5, 0xc3, 0xf2, 0x67, 0xcb, 0xa5, 0xd8, 0x4c,
	0x5b, 0x35, 0x70, 0xd7, 0x75, 0x9e, 0xe4, 0x1e, 0xe1, 0x5d, 0x00, 0x4b, 0x34, 0x62, 0xd8, 0x4c,
	0x0b, 0x5b, 0xab, 0x4b, 0x38, 0x67, 0xcb, 0xad, 0x7f, 0x54, 0x90, 0x64, 0x6f, 0x3b, 0x30, 0x02,
	0xbc, 0xd7, 0xef, 0x3c, 0x49, 0x7e, 0xdd, 0x82, 0x29, 0x3f, 0x6a, 0x86, 0xe0, 0x58, 0x9e, 0x99,
	0x88, 0xd4, 0x62, 0x3d, 0x86, 0x77, 0xb6, 0x5c, 0xfb, 0x8d, 0x02, 0x5c, 0x8a, 0xb6, 0xf7, 0x04,
	0xe8, 0x07, 0x24, 0x9b, 0x1d, 0x77, 0x3d, 0x29, 0xd6, 0xed, 0xc0, 0x5c, 0x2f, 0xd1, 0x16, 0xc1,
	0xbf, 0x5c, 0xab, 0xa0, 0x44, 0x79, 0x3d, 0x4d, 0xe1, 0x6c, 0x39, 0xf9, 0x9f, 0x0a, 0x70, 0x25,
	0x97, 0x93, 0x8d, 0x8e, 0x61, 0x77, 0x9f, 0x18, 0x3b, 0x2d, 0xb8, 0xd0, 0xcb, 0x6a, 0x90, 0xe0,
	0xe9, 0x8b, 0x23, 0xf2, 0x94, 0x22, 0xe9, 0x39, 0xb4, 0xce, 0x96, 0xbb, 0xdf, 0x2c, 0x48, 0xdb,
	0x34, 0xdd, 0xed, 0x3c, 0xd1, 0x6d, 0x9a, 0xe7, 0x76, 0x86, 0x6e, 0xd3, 0x48, 0x1b, 0x75, 0x56,
	0xf2, 0x43, 0x94, 0x7b, 0xa4, 0xd6, 0x15, 0xdb, 0xb1, 0xc8, 0x06, 0xed, 0x09, 0xca, 0x3d, 0x2f,
	0x6a, 0xc6, 0x30, 0xb9, 0x27, 0xb5, 0x58, 0x8f, 0xe1, 0x7d, 0x88, 0x5c, 0x13, 0x3b, 0xad, 0x27,
	0x39, 0xac, 0x6e, 0xc1, 0x94, 0x19, 0x35, 0x63, 0x18, 0xd7, 0xa4, 0x16, 0xeb, 0x31, 0xbc, 0xb3,
	0xe5, 0xda, 0xbf, 0x2d, 0xc0, 0x53, 0x59, 0x5c, 0x7b, 0xd2, 0x43, 0xee, 0x0b, 0x70, 0xde, 0x4c,
	0xb5, 0x46, 0xf0, 0xf0, 0x13, 0xc3, 0x79, 0x28, 0x06, 0x60, 0x16, 0x95, 0xb3, 0xe5, 0xe8, 0xaf,
	0x16, 0xe0, 0x62, 0xf2, 0x90, 0x8e, 0xdb, 0x60, 0x3d, 0x31, 0x6e, 0x6e, 0xc1, 0xac, 0x1f, 0x6b,
	0x89, 0xe0, 0xe4, 0xc7, 0x07, 0x1f, 0xd9, 0xf1, 0xd2, 0x7a, 0x12, 0xfb, 0x6c, 0x39, 0xf8, 0x13,
	0xf2, 0x5e, 0x62, 0xcd, 0xd9, 0xf7, 0xb0, 0xef, 0x3f, 0x31, 0xd6, 0xbd, 0x09, 0x35, 0x9b, 0x35,
	0x61, 0xe8, 0x39, 0x27, 0x6f, 0xaa, 0x1e, 0x21, 0x7c, 0x88, 0xfa, 0xc9, 0x7d, 0xec, 0x05, 0xb6,
	0x69, 0x74, 0x5a, 0xae, 0xb5, 0xdc, 0x0f, 0x5c, 0xdf, 0x34, 0x3a, 0x4f, 0xf0, 0x48, 0xcc, 0x82,
	0x0b, 0x47, 0x59, 0x0d, 0x1a, 0xa6, 0x9f, 0x64, 0x7e, 0x85, 0x9e, 0x43, 0xeb, 0x6c, 0xb9, 0xfb,
	0x9d, 0x02, 0x5c, 0x0d, 0xb9, 0x7b, 0xc7, 0xf5, 0xec, 0x0f, 0x5c, 0x27, 0xf8, 0xa8, 0xf0, 0xf7,
	0x2b, 0x50, 0x3f, 0xc8, 0x6e, 0x92, 0xe0, 0xf0, 0x52, 0xee, 0x49, 0x6a, 0x26, 0x9a, 0x9e, 0x4b,
	0xef, 0x6c, 0xb9, 0xfc, 0x4f, 0x0b, 0x92, 0x77, 0x02, 0x37, 0x51, 0x68, 0xb9, 0x1d, 0xdb, 0x3c,
	0x7e, 0x62, 0xbc, 0xdd, 0x84, 0x59, 0x47, 0x6a, 0x88, 0x1d, 0xce, 0xfb, 0x3c, 0xdb, 0xe5, 0x58,
	0xb3, 0xf5, 0x24, 0xf2, 0x87, 0x78, 0x89, 0x46, 0x4d, 0x45, 0x74, 0xc3, 0xd9, 0xc7, 0x4f, 0xf2,
	0x12, 0xad, 0x13, 0xb6, 0x62, 0xd8, 0x25, 0x5a, 0xd4, 0x5e, 0x5d, 0xc6, 0x3a, 0x5b, 0x8e, 0xfd,
	0x72, 0x01, 0x16, 0xa4, 0x53, 0x05, 0x6a, 0x99, 0xd7, 0xe8, 0x18, 0x4f, 0x70, 0x89, 0xb9, 0x07,
	0x33, 0xbe, 0xd4, 0x8e, 0x90, 0x6d, 0xcf, 0xe6, 0x1e, 0x2c, 0x44, 0x85, 0xf5, 0x04, 0xea, 0xd9,
	0xf2, 0xee, 0xaf, 0x2b, 0x30, 0x25, 0x67, 0xa3, 0x79, 0x28, 0x6f, 0x18, 0x5f, 0x71, 0x3d, 0x6e,
	0x6f, 0xce, 0x12, 0x14, 0x6a, 0x3b, 0xae, 0x27, 0x4c, 0x59, 0x68, 0x82, 0x40, 0x5b, 0x46, 0x60,
	0x1e, 0x50, 0xe6, 0x14, 0x75, 0x96, 0x40, 0x2a, 0x14, 0x5b, 0x9e, 0x30, 0x3c, 0x24, 0x7f, 0xc9,
	0x17, 0x6c, 0xe0, 0xc0, 0xe0, 0x36, 0x87, 0xf4, 0x3f, 0xba, 0x00, 0x13, 0x0d, 0xb7, 0xdb, 0xb5,
	0x03, 0x61, 0x63, 0xcc, 0x52, 0x5a, 0x1b, 0x66, 0x13, 0x2e, 0x71, 0xe8, 0x39, 0x98, 0x36, 0xcc,
	0xc0, 0x3e, 0xc2, 0x8d, 0x8e, 0x4d, 0x2f, 0x72, 0xb9, 0x71, 0x51, 0x0c, 0x88, 0x16, 0xa1, 0x6a,
	0x3b, 0x01, 0xf6, 0x8e, 0x8c, 0x0e, 0xf7, 0x6f, 0x0a, 0xd3, 0x5a, 0x0b, 0x66, 0xb6, 0x3d, 0xc3,
	0xc4, 0x1e, 0xa9, 0x9a, 0xf0, 0x88, 0xf4, 0x9f, 0xd7, 0x77, 0x02, 0xbb, 0x8b, 0xd7, 0x2c, 0x3e,
	0x2e, 0x22, 0x40, 0xd2, 0xce, 0xb7, 0x90, 0xb2, 0xf3, 0xd5, 0x96, 0xa0, 0xda, 0x72, 0xbd, 0x60,
	0xcd, 0xd9, 0x73, 0xc9, 0x07, 0x07, 0x66, 0xaf, 0xae, 0x5c, 0x2d, 0x5e, 0x2b, 0xeb, 0xe4, 0x2f,
	0x81, 0xf4, 0xad, 0x1e, 0x3d, 0x92, 0x2f, 0xeb, 0xe4, 0xaf, 0xf6, 0x43, 0x35, 0xa8, 0x70, 0x2f,
	0x23, 0xf9, 0xce, 0x6c, 0x9a, 0xdd, 0x99, 0xa9, 0x50, 0xec, 0xd9, 0xc2, 0x2d, 0x8b, 0xfc, 0x25,
	0xac, 0x75, 0xfc, 0x96, 0x6d, 0x51, 0x6b, 0xd8, 0xb2, 0xce, 0x12, 0xa1, 0x45, 0x4b, 0x71, 0x54,
	0x8b, 0x96, 0x9b, 0x50, 0x31, 0xdd, 0x6e, 0xd7, 0x70, 0x2c, 0xee, 0xa0, 0x97, 0x7b, 0x6c, 0xca,
	0x4a, 0xe9, 0xa2, 0x38, 0x7a, 0x15, 0x4a, 0x7d, 0x3f, 0xbc, 0xff, 0x1a, 0xe2, 0x38, 0xb5, 0xe3,
	0x63, 0x4f, 0xa7, 0xe5, 0xd1, 0x6b, 0x30, 0xd1, 0x65, 0x2e, 0x1c, 0x95, 0x81, 0x16, 0x33, 0xcc,
	0xa9, 0x83, 0xfa, 0x86, 0x70, 0x04, 0xf4, 0x32, 0x14, 0xcd, 0x5e, 0x9f, 0x5f, 0xec, 0xe4, 0x36,
	0xb4, 0xb5, 0x43, 0x91, 0x48, 0x51, 0x74, 0x05, 0x80, 0x19, 0xa9, 0x6e, 0xdb, 0x5d, 0xcc, 0x7d,
	0xa4, 0x24, 0x08, 0x7a, 0x1b, 0x6a, 0xa1, 0x05, 0x1a, 0x35, 0xc1, 0x19, 0xc5, 0xe7, 0x27, 0x42,
	0x21, 0xe3, 0xc0, 0xed, 0x61, 0xe7, 0x96, 0xd5, 0x20, 0x4a, 0x32, 0x35, 0xd0, 0x29, 0xeb, 0x32,
	0x08, 0xbd, 0xc6, 0x9c, 0x61, 0x84, 0x43, 0xe0, 0xb3, 0xc3, 0x1d, 0xcc, 0x30, 0xf3, 0x85, 0xc1,
	0xe8, 0x33, 0x30, 0x61, 0xbb, 0x04, 0x42, 0xcd, 0x4d, 0x27, 0x6f, 0x3c, 0x9d, 0xa7, 0x84, 0x6e,
	0x31, 0x2e, 0xb1, 0xc2, 0x54, 0xa6, 0x85, 0x96, 0xcd, 0x16, 0xb5, 0x11, 0x27, 0x32, 0x2d, 0x02,
	0xc5, 0xec, 0x4a, 0xef, 0xe1, 0x63, 0x6a, 0x57, 0x3a, 0xad, 0xc7, 0x60, 0xe8, 0x06, 0xcc, 0x1f,
	0xb9, 0x9d, 0xbe, 0x13, 0x18, 0xde, 0x71, 0x23, 0x78, 0xd4, 0x7e, 0x68, 0x07, 0xe6, 0x01, 0xf6,
	0xeb, 0xea, 0x55, 0xe5, 0x5a, 0x49, 0xcf, 0xcc, 0x43, 0xaf, 0xc2, 0x05, 0xdb, 0xc9, 0xc4, 0x9a,
	0xa3, 0x58, 0x39, 0xb9, 0x44, 0x8a, 0xee, 0x1e, 0x07, 0x98, 0x34, 0x05, 0x5d, 0x55, 0xae, 0x4d,
	0xe9, 0x22, 0x89, 0xae, 0x83, 0x1a, 0xb6, 0x6a, 0x85, 0x17, 0x39, 0x4f, 0x8b, 0xa4, 0xe0, 0x68,
	0x45, 0x32, 0x65, 0x5d, 0x18, 0xe8, 0x52, 0xcb, 0x99, 0xcd, 0x17, 0x71, 0x5f, 0x32, 0x63, 0x7d,
	0x1e, 0x66, 0x78, 0x51, 0xd2, 0xdd, 0xf8, 0x51, 0x50, 0xbf, 0x40, 0x85, 0x6a, 0x02, 0x1a, 0x8a,
	0xdc, 0x8b, 0x92, 0xc8, 0x7d, 0x03, 0xaa, 0x1d, 0xc3, 0xd9, 0xef, 0x1b, 0xfb, 0xb8, 0x5e, 0xa7,
	0x9d, 0x9d, 0x77, 0xdb, 0xb9, 0xce, 0x8b, 0xe9, 0x21, 0x02, 0x41, 0xee, 0x71, 0x71, 0x51, 0xbf,
	0x44, 0x1b, 0xff, 0xb1, 0x5c, 0xd3, 0x28, 0x56, 0x4c, 0x0f, 0x11, 0x50, 0x1b, 0x54, 0x2e, 0x7a,
	0x42, 0x7f, 0xca, 0xfa, 0x22, 0x25, 0xf2, 0xc2, 0xe0, 0xcd, 0x5e, 0xe4, 0x7e, 0x99, 0x22, 0xc0,
	0x9c, 0xc1, 0xb4, 0x6f, 0x14, 0x41, 0x4d, 0x16, 0x46, 0xf7, 0x61, 0x7e, 0x1f, 0x3b, 0xd8, 0x33,
	0x02, 0x6c, 0xb5, 0x25, 0x31, 0xa8, 0x0c, 0x14, 0x05, 0x52, 0x49, 0x3d, 0x13, 0x1f, 0xdd, 0x81,
	0x69, 0x2b, 0x46, 0xb0, 0x30, 0x32, 0xc1, 0x38, 0x22, 0xfa, 0x3e, 0xa8, 0x1b, 0x96, 0x65, 0x07,
	0xb6, 0xeb, 0x18, 0x9d, 0xdb, 0xa2, 0x2e, 0x7a, 0x75, 0x38, 0xc4, 0xd3, 0x53, 0x26, 0x9a, 0x4b,
	0x03, 0x6d, 0xc0, 0x4c, 0x10, 0x5b, 0x2f, 0xb8, 0x3d, 0x5b, 0xde, 0xe6, 0x3a, 0xbe, 0xb8, 0xe8,
	0x09, 0x64, 0xb4, 0x04, 0xc8, 0xe8, 0x75, 0xd7, 0x1c, 0x3f, 0xf0, 0xfa, 0x5d, 0xec, 0x04, 0xcc,
	0xc0, 0xb4, 0x4c, 0x4d, 0x02, 0x33, 0x72, 0x34, 0x13, 0x26, 0xe5, 0xaf, 0x15, 0xf6, 0xfd, 0x8a,
	0x64, 0xdf, 0xff, 0x6e, 0xcc, 0x88, 0x35, 0xdf, 0x63, 0x4d, 0xa2, 0xd3, 0xa6, 0xe5, 0x85, 0xb9,
	0xab, 0xf6, 0xcd, 0x02, 0xa8, 0x49, 0x37, 0x5d, 0xb1, 0x10, 0x29, 0x19, 0x0b, 0x51, 0xe1, 0xbb,
	0x6c, 0x21, 0x8a, 0xaf, 0x0d, 0x13, 0xa9, 0xb5, 0x41, 0x92, 0x4a, 0x95, 0x98, 0x54, 0xd2, 0x7e,
	0x56, 0x81, 0x0a, 0x6f, 0x06, 0xe1, 0xbd, 0xe1, 0xed, 0xfb, 0x74, 0x71, 0xaf, 0xe9, 0xf4, 0x3f,
	0x61, 0x92, 0xf9, 0x50, 0xd8, 0xb5, 0x92, 0xbf, 0xa4, 0x94, 0xe7, 0xba, 0xc2, 0x10, 0x97, 0xfe,
	0xa7, 0xe6, 0xb9, 0xce, 0xaa, 0xed, 0x1f, 0xf2, 0x8e, 0xe6, 0x29, 0x52, 0xb6, 0x47, 0x78, 0xcc,
	0x0c, 0x17, 0xe9, 0x7f, 0x52, 0xb6, 0x47, 0xb5, 0x47, 0xee, 0xa5, 0xc8, 0x53, 0xa4, 0x26, 0xfc,
	0x48, 0x78, 0x52, 0x91, 0xbf, 0x04, 0x9b, 0x30, 0x86, 0xbb, 0x50, 0xd0, 0xff, 0xda, 0xdf, 0x54,
	0x60, 0x52, 0xfa, 0xfe, 0xcc, 0xf1, 0x42, 0x34, 0x92, 0x48, 0xc3, 0xe8, 0xdb, 0x16, 0x81, 0xec,
	0xdb, 0x42, 0xaf, 0x25, 0x7f, 0x09, 0x1e, 0x26, 0x85, 0x78, 0xa0, 0x01, 0xf2, 0x9f, 0xc2, 0x48,
	0xb1, 0x32, 0x87, 0xf1, 0x72, 0x7e, 0x3f, 0xfa, 0x02, 0x9f, 0x97, 0xf3, 0x49, 0xb9, 0x0a, 0x87,
	0xed, 0xdb, 0x96, 0xf6, 0x00, 0x66, 0x13, 0xa2, 0x98, 0x08, 0x60, 0xd3, 0x75, 0x1c, 0x6c, 0x92,
	0x71, 0xae, 0x93, 0x75, 0x93, 0x34, 0xb2, 0xa0, 0x27, 0xa0, 0x44, 0x3d, 0x23, 0xbd, 0xe1, 0xd3,
	0x22, 0x05, 0x5a, 0x24, 0x02, 0x68, 0x47, 0x30, 0x1d, 0x2e, 0xd7, 0xcb, 0x96, 0xe5, 0xa1, 0x19,
	0x28, 0xd8, 0x3d, 0xfe, 0xbd, 0x05, 0xbb, 0x47, 0x79, 0xec, 0x7a, 0x01, 0xff, 0x5c, 0xfa, 0x1f,
	0x2d, 0x4b, 0xc6, 0xe7, 0x45, 0x3a, 0x67, 0x3e, 0x9e, 0xaf, 0x0a, 0xf0, 0xb6, 0x50, 0x17, 0xcf,
	0x10, 0x4d, 0xfb, 0xe5, 0x2a, 0xd4, 0x22, 0x97, 0x1d, 0xe1, 0x45, 0xa2, 0x48, 0x5e, 0x24, 0xa4,
	0x21, 0x62, 0x1f, 0x51, 0x60, 0x6c, 0x19, 0xd1, 0x35, 0x67, 0x11, 0xaa, 0x66, 0xaf, 0x4f, 0xf7,
	0x4f, 0x94, 0xd9, 0x05, 0x3d, 0x4c, 0x93, 0x25, 0x9f, 0xa9, 0x48, 0x2c, 0x7b, 0x82, 0xae, 0xb6,
	0x32, 0x08, 0xbd, 0x21, 0xd4, 0x90, 0xea, 0xb0, 0x2f, 0x8b, 0x7c, 0x72, 0x43, 0x45, 0xe4, 0xed,
	0xd0, 0x2f, 0x83, 0x39, 0x19, 0x3f, 0x3f, 0xd4, 0xfb, 0x35, 0xee, 0x94, 0x51, 0x87, 0x0a, 0x77,
	0x15, 0xa2, 0x3a, 0x56, 0x51, 0x17, 0x49, 0x3a, 0x2f, 0x76, 0x7b, 0x3e, 0x55, 0x9c, 0x0a, 0x3a,
	0xfd, 0x4f, 0x60, 0x0f, 0x09, 0x6c, 0x8a, 0xc1, 0xc8, 0x7f, 0xa1, 0x11, 0x4f, 0x47, 0x1a, 0x31,
	0xf3, 0x01, 0xd7, 0xcd, 0x23, 0xab, 0xe5, 0x53, 0x1d, 0xa7, 0xa0, 0x47, 0x00, 0x9e, 0xdb, 0xc6,
	0x4e, 0xd0, 0xf2, 0xa9, 0x7a, 0xc3, 0x72, 0x19, 0x80, 0xcc, 0x7c, 0x5e, 0x74, 0xa5, 0xc7, 0x34,
	0x9a, 0x82, 0x2e, 0x41, 0x78, 0x3e, 0x29, 0x4c, 0xf2, 0xe7, 0xc2, 0x7c, 0x0e, 0x21, 0xdf, 0x43,
	0x24, 0x48, 0xcb, 0x0c, 0xa8, 0xbe, 0x52, 0xd0, 0x45, 0x92, 0xfa, 0x41, 0x51, 0x4b, 0x6f, 0x92,
	0x77, 0x9e, 0xd5, 0x1b, 0x02, 0x48, 0x17, 0x52, 0x7f, 0x65, 0x92, 0x39, 0xcf, 0xba, 0x50, 0xa4,
	0xc9, 0x0c, 0xef, 0xe2, 0xae, 0xee, 0x33, 0xdd, 0xa5, 0xa4, 0xf3, 0x14, 0xc1, 0xe9, 0xe2, 0x6e,
	0xc3, 0x30, 0x0f, 0x30, 0x75, 0x36, 0x29, 0xe9, 0x61, 0x3a, 0x14, 0xb2, 0x17, 0x47, 0x15, 0xb2,
	0x75, 0xa8, 0x70, 0xaf, 0x2c, 0xaa, 0xa1, 0x14, 0x75, 0x91, 0x94, 0x85, 0xdd, 0xa5, 0xb8, 0x0a,
	0x26, 0x54, 0x9d, 0x45, 0x49, 0xd5, 0x59, 0x81, 0x9a, 0x11, 0x3a, 0x81, 0x3c, 0x35, 0x9a, 0x97,
	0x37, 0x99, 0x87, 0x7a, 0x84, 0x46, 0xfd, 0xb9, 0x0f, 0x3c, 0x6c, 0x70, 0xd5, 0xf9, 0x32, 0x1b,
	0xb3, 0x12, 0x28, 0x2a, 0xc1, 0x46, 0xf5, 0xd3, 0x72, 0x09, 0x36, 0xaa, 0x19, 0x73, 0x76, 0x68,
	0x78, 0x95, 0x2b, 0x21, 0x73, 0x68, 0x9a, 0x8a, 0xf7, 0x5e, 0x9f, 0xfe, 0xdf, 0xf4, 0xeb, 0x1f,
	0x63, 0x9d, 0x18, 0x41, 0x88, 0x12, 0xdc, 0xc5, 0x5d, 0x7e, 0xbc, 0x8d, 0xad, 0xfa, 0x55, 0x8a,
	0x1f, 0x83, 0x71, 0x1a, 0x3a, 0xfe, 0x6a, 0x1f, 0xfb, 0x41, 0xfd, 0x99, 0x90, 0x06, 0x87, 0x90,
	0x8d, 0x27, 0x9b, 0x64, 0xa2, 0x88, 0x46, 0x89, 0xc4, 0x81, 0x84, 0x8a, 0x87, 0x7b, 0xee, 0xaa,
	0xbd, 0x4f, 0x8a, 0x3c, 0xcb, 0xfc, 0x4d, 0x22, 0x08, 0x77, 0xb8, 0xff, 0xd3, 0x6a, 0x28, 0xa4,
	0xa9, 0x1a, 0x9f, 0x5e, 0x69, 0xe3, 0x0b, 0x56, 0x21, 0xb5, 0x60, 0x45, 0x3b, 0xab, 0xe2, 0x09,
	0x77, 0x56, 0xa5, 0xd1, 0x77, 0x56, 0x44, 0x70, 0xd9, 0xa6, 0x70, 0xc2, 0xa0, 0xff, 0xc9, 0x20,
	0x62, 0xbd, 0xe3, 0x73, 0x31, 0x2f, 0x92, 0xc9, 0x7d, 0x52, 0x35, 0xbd, 0x4f, 0xe2, 0x33, 0xbc,
	0x16, 0xcd, 0xf0, 0xc4, 0x3e, 0x06, 0xd2, 0xfb, 0x98, 0x8d, 0x44, 0x80, 0x0b, 0x11, 0x8f, 0x62,
	0x44, 0xe9, 0x96, 0x40, 0x46, 0xb7, 0x61, 0xaa, 0x27, 0x6d, 0xc3, 0xc6, 0xd9, 0xb1, 0xc5, 0x10,
	0xa5, 0x8d, 0xdb, 0xf9, 0x71, 0x36, 0x6e, 0xf2, 0x06, 0xe6, 0xf2, 0x09, 0x37, 0x30, 0x2d, 0x98,
	0x35, 0xe3, 0x52, 0x98, 0x8a, 0xbf, 0xd1, 0x65, 0x76, 0x12, 0x3d, 0xe6, 0xb9, 0xa5, 0xef, 0x86,
	0xf2, 0x32, 0x0e, 0x8c, 0x95, 0x7a, 0xb0, 0x1b, 0x4a, 0xcd, 0x38, 0x30, 0xb5, 0xf1, 0x44, 0x19,
	0x1b, 0xcf, 0x25, 0x40, 0xa6, 0xe4, 0xc0, 0xc6, 0x25, 0x3c, 0x13, 0x97, 0x19, 0x39, 0xc9, 0xf2,
	0x5c, 0xe6, 0x2f, 0xa4, 0xcb, 0x73, 0xe1, 0xff, 0x32, 0x9c, 0x4f, 0x52, 0x21, 0x52, 0xfe, 0x02,
	0x45, 0xc8, 0xca, 0x4a, 0x62, 0x88, 0x75, 0xe1, 0x62, 0x1a, 0x43, 0x2c, 0x10, 0x79, 0x9b, 0xe7,
	0xfa, 0x89, 0x36, 0xcf, 0x97, 0x46, 0xdd, 0x3c, 0x2f, 0x0e, 0xdf, 0x3c, 0x3f, 0x95, 0xbd, 0x79,
	0xd6, 0x7e, 0x41, 0x81, 0x39, 0x32, 0xaa, 0x68, 0xac, 0x97, 0x07, 0x76, 0x70, 0xd0, 0xc2, 0x5e,
	0x37, 0x9c, 0xb6, 0xab, 0x6c, 0xda, 0x2a, 0xd2, 0xb4, 0x65, 0x20, 0x7a, 0x4c, 0x16, 0xca, 0x70,
	0x26, 0x92, 0x22, 0x00, 0x91, 0x58, 0x0f, 0x3d, 0x3b, 0xc0, 0x2c, 0x9b, 0x1d, 0x02, 0x4a, 0x10,
	0x81, 0x4d, 0x1a, 0xe1, 0xf3, 0x88, 0x1e, 0x11, 0x20, 0xc4, 0x66, 0xd9, 0x65, 0x09, 0x9b, 0x42,
	0xb4, 0xdf, 0x57, 0xe0, 0x42, 0xaa, 0xcd, 0x2b, 0xc7, 0xad, 0xb5, 0x55, 0xf4, 0x25, 0x00, 0x1a,
	0x4f, 0x84, 0xa6, 0xa8, 0x6e, 0x3e, 0x79, 0xe3, 0xad, 0x01, 0x93, 0x29, 0x4d, 0x82, 0xda, 0x72,
	0x31, 0x7c, 0xee, 0x98, 0x1b, 0x11, 0x5c, 0xdc, 0x87, 0xd9, 0x44, 0xb6, 0x7c, 0x66, 0x57, 0x66,
	0xf2, 0xeb, 0xed, 0xb8, 0x9d, 0xfb, 0xb5, 0x51, 0xab, 0x97, 0x8d, 0xde, 0x7f, 0x7e, 0x42, 0xd2,
	0x64, 0xa9, 0x90, 0x60, 0x0a, 0xa4, 0x12, 0x2a, 0x90, 0x92, 0x2e, 0x52, 0x18, 0xa0, 0x8b, 0x14,
	0x07, 0xe9, 0x22, 0xa5, 0x84, 0x2e, 0x32, 0x48, 0xd5, 0x8c, 0xf4, 0x94, 0x89, 0x5c, 0x3d, 0xa5,
	0x92, 0xd0, 0x53, 0x58, 0x1e, 0xa3, 0x57, 0x0d, 0xf3, 0x18, 0x3d, 0xa1, 0x01, 0xd6, 0x32, 0x34,
	0x40, 0x90, 0x34, 0xc0, 0x98, 0xbe, 0x37, 0x39, 0x50, 0xdf, 0x9b, 0x1a, 0xac, 0xef, 0x4d, 0x0f,
	0xd1, 0xf7, 0x66, 0x52, 0xfa, 0x5e, 0xa8, 0x3c, 0xcf, 0x9e, 0x4a, 0x79, 0x56, 0x4f, 0xa4, 0x3c,
	0xf3, 0x81, 0x35, 0x17, 0x2d, 0x8c, 0x92, 0x16, 0x87, 0x72, 0xb5, 0xb8, 0xf3, 0x71, 0x59, 0x90,
	0xd0, 0xb6, 0xe6, 0x87, 0x6a, 0x5b, 0x0b, 0x83, 0xb5, 0xad, 0x0b, 0x03, 0xb5, 0xad, 0x8b, 0x43,
	0xb5, 0xad, 0xfa, 0x50, 0x6d, 0xeb, 0xd2, 0x70, 0x6d, 0x6b, 0x31, 0x43, 0xdb, 0xd2, 0x7e, 0x46,
	0x01, 0x88, 0xbc, 0x2d, 0xc9, 0x58, 0xea, 0xf7, 0xc3, 0x19, 0x43, 0xff, 0xa3, 0x4f, 0x41, 0xc1,
	0xf5, 0xf9, 0xb4, 0xcc, 0x5b, 0x9b, 0xb7, 0xda, 0xf4, 0x90, 0xad, 0xe0, 0x12, 0x69, 0x5e, 0x32,
	0x59, 0x40, 0xa2, 0xe2, 0x60, 0xed, 0x88, 0xb9, 0x77, 0x9a, 0x19, 0xd1, 0x8a, 0xca, 0xa9, 0x68,
	0x45, 0x77, 0x4b, 0xd5, 0x92, 0x5a, 0xd6, 0xbe, 0xae, 0xc0, 0x04, 0xab, 0x2a, 0x73, 0x57, 0xbe,
	0x08, 0xd5, 0x5e, 0xc7, 0x08, 0xf6, 0x5c, 0xaf, 0x1b, 0x3a, 0x44, 0xf3, 0xb4, 0x14, 0x84, 0xa5,
	0x98, 0x17, 0x84, 0xa5, 0x14, 0x0f, 0xc2, 0xf2, 0x1c, 0x4c, 0x1f, 0x62, 0xcf, 0xc1, 0x1d, 0x71,
	0x2b, 0xc4, 0xee, 0x5b, 0xe2, 0x40, 0xda, 0x24, 0xa6, 0x99, 0x90, 0xea, 0x49, 0xf7, 0x4b, 0xfb,
	0xf0, 0x30, 0x4d, 0xa6, 0x1c, 0x95, 0xc5, 0xf2, 0x0e, 0x3c, 0x04, 0x90, 0xaa, 0x42, 0x41, 0x4e,
	0x4b, 0x30, 0x01, 0x14, 0x07, 0x92, 0xdd, 0x7e, 0x24, 0xcf, 0x69, 0x31, 0x26, 0x8a, 0x12, 0x50,
	0xed, 0x1f, 0x28, 0x00, 0x91, 0xd6, 0x4a, 0xa6, 0x84, 0xe7, 0xb3, 0x5b, 0x9e, 0x92, 0x4e, 0xfe,
	0x12, 0xc8, 0x51, 0x97, 0x75, 0x69, 0x49, 0x27, 0x7f, 0xe9, 0x79, 0xc3, 0x43, 0x83, 0x39, 0x8b,
	0x97, 0x74, 0xfa, 0x9f, 0xfa, 0x61, 0x1f, 0x18, 0x1e, 0x66, 0x27, 0x18, 0x25, 0x9d, 0xa7, 0xe8,
	0x16, 0x07, 0x3f, 0x62, 0xb2, 0xae, 0xa4, 0xd3, 0xff, 0x84, 0x62, 0xc7, 0xde, 0xe5, 0x42, 0x8e,
	0xfc, 0x25, 0xa5, 0xe8, 0x49, 0x1f, 0x93, 0x6e, 0xf4, 0x3f, 0xd9, 0xaa, 0x5b, 0xb6, 0x17, 0x1c,
	0x73, 0xb1, 0xc6, 0x12, 0xda, 0x8f, 0x15, 0xa0, 0xc2, 0x95, 0x65, 0xd2, 0x1b, 0x1d, 0xc3, 0x0f,
	0x1a, 0xbd, 0x3e, 0xef, 0x58, 0x91, 0x8c, 0x49, 0xe0, 0x42, 0x42, 0x02, 0x4b, 0x52, 0xbd, 0x38,
	0x40, 0xaa, 0x97, 0x92, 0x52, 0x9d, 0x48, 0xb2, 0x7e, 0x77, 0x9b, 0x2b, 0xe1, 0x4c, 0x37, 0x97,
	0x20, 0xe8, 0x26, 0x1f, 0xca, 0x13, 0x03, 0xf7, 0x6c, 0x6d, 0xdb, 0xd9, 0xef, 0x60, 0xa1, 0xee,
	0xb3, 0x01, 0x2d, 0xf4, 0xfd, 0x8a, 0xa4, 0xef, 0x2f, 0x42, 0x95, 0x34, 0x8b, 0x6e, 0x47, 0x58,
	0x54, 0x8f, 0x30, 0x4d, 0x5a, 0xc2, 0x9a, 0x25, 0xdf, 0xbc, 0x44, 0x10, 0xed, 0x1d, 0x98, 0x8e,
	0x55, 0x93, 0x37, 0xfc, 0xf3, 0x58, 0xa4, 0xfd, 0xa1, 0x42, 0x99, 0x4c, 0xa7, 0xce, 0x05, 0x98,
	0x70, 0xfa, 0xdd, 0x5d, 0x1e, 0xa9, 0xb3, 0xac, 0xf3, 0x14, 0x81, 0x1f, 0x61, 0xc7, 0xe2, 0xd7,
	0x92, 0x35, 0x9d, 0xa7, 0x72, 0xa7, 0xce, 0x3c, 0x94, 0xbb, 0xae, 0x85, 0x3b, 0xe2, 0xe4, 0x85,
	0x26, 0xc8, 0xa7, 0xf4, 0x0e, 0x8e, 0x7d, 0xdb, 0x34, 0x3a, 0x3c, 0xde, 0x55, 0x4d, 0x97, 0x20,
	0x84, 0x9a, 0xe9, 0x7a, 0x98, 0x87, 0x17, 0xab, 0xe9, 0x3c, 0x45, 0xa8, 0x91, 0x7f, 0x62, 0x33,
	0xc4, 0x12, 0x64, 0x60, 0x75, 0x0f, 0x3e, 0xe0, 0xfc, 0x22, 0x7f, 0xe9, 0x15, 0x33, 0x59, 0x27,
	0xe9, 0x55, 0x71, 0x8d, 0x5d, 0x15, 0x87, 0x00, 0xed, 0xdb, 0x0a, 0x94, 0xc8, 0x16, 0x5e, 0x5a,
	0xf9, 0x8b, 0x74, 0xe5, 0x0f, 0x03, 0x0d, 0x16, 0xe4, 0x40, 0x83, 0x59, 0x07, 0x4a, 0x75, 0xa8,
	0x18, 0x9d, 0xce, 0x76, 0x74, 0x47, 0x2c, 0x92, 0x72, 0xb8, 0xb5, 0xca, 0xc0, 0x70, 0x6b, 0xd5,
	0x74, 0xb8, 0x35, 0xd2, 0x39, 0xc6, 0xfe, 0x9a, 0x63, 0xe1, 0x47, 0xbc, 0xd5, 0x61, 0x9a, 0x88,
	0xfb, 0xc0, 0xd8, 0xf7, 0x37, 0x5c, 0xcb, 0xde, 0xb3, 0xc3, 0x63, 0x9f, 0x18, 0x8c, 0x09, 0xc0,
	0xbb, 0xa5, 0x6a, 0x59, 0x9d, 0xd0, 0xfe, 0xa4, 0x06, 0x15, 0xe1, 0xd3, 0x47, 0xd6, 0x72, 0xd7,
	0xc2, 0xb2, 0xca, 0x19, 0x01, 0xd0, 0x97, 0x60, 0xf6, 0xb0, 0xbf, 0x8b, 0x3b, 0x58, 0x5c, 0x48,
	0x8b, 0x30, 0x73, 0x9f, 0x1e, 0x6c, 0x21, 0xb8, 0x74, 0x2f, 0x8e, 0xc5, 0x94, 0xba, 0x24, 0x2d,
	0x64, 0xc2, 0x9c, 0xd1, 0xb3, 0xdb, 0xd8, 0x3b, 0xc2, 0x5e, 0x58, 0x01, 0x13, 0xfc, 0x9f, 0x19,
	0x52, 0xc1, 0x72, 0x12, 0x8f, 0x55, 0x91, 0xa6, 0x47, 0x78, 0xdb, 0x73, 0xad, 0x86, 0xd1, 0x33,
	0x4c, 0x3b, 0x60, 0xa1, 0xec, 0xa6, 0x75, 0x19, 0x44, 0xef, 0xa1, 0x5c, 0x6b, 0xb9, 0xd3, 0x71,
	0x4d, 0x23, 0x30, 0x76, 0x3b, 0x6c, 0x9f, 0x3d, 0xad, 0x27, 0xa0, 0xe8, 0x45, 0x98, 0x63, 0xab,
	0x9f, 0x5c, 0x94, 0xc9, 0xac, 0x74, 0x06, 0xa1, 0xca, 0x80, 0x61, 0xd5, 0x4c, 0x96, 0x25, 0xa0,
	0xf4, 0x10, 0xb6, 0xd7, 0x97, 0x49, 0x32, 0xf1, 0x96, 0x80, 0xd2, 0x1d, 0x7a, 0xaf, 0x1f, 0x12,
	0xab, 0x31, 0x95, 0x41, 0x02, 0x65, 0x85, 0x2e, 0x83, 0xec, 0xd0, 0x65, 0x2f, 0xc2, 0x1c, 0x3d,
	0xca, 0xb0, 0x5d, 0x87, 0xc8, 0x07, 0x3f, 0x30, 0xba, 0x3d, 0xaa, 0xe7, 0x15, 0xf5, 0x74, 0x46,
	0x78, 0x28, 0x35, 0x25, 0x1d, 0x4a, 0xbd, 0x0b, 0x95, 0x2e, 0x0f, 0xf1, 0x35, 0x3d, 0x70, 0xf7,
	0xac, 0xf3, 0xaa, 0x79, 0x70, 0x26, 0x5d, 0xa0, 0xa1, 0xbf, 0xa0, 0xc0, 0x65, 0xfc, 0x28, 0xc0,
	0x8e, 0x85, 0x2d, 0x51, 0xc8, 0x97, 0xd9, 0xc0, 0xe2, 0xfa, 0xbc, 0x3b, 0x64, 0x20, 0x34, 0x07,
	0x90, 0x60, 0x63, 0x62, 0x60, 0x2d, 0xe8, 0xfb, 0xe1, 0x52, 0x2a, 0x3f, 0x64, 0xf2, 0xec, 0xc0,
	0xbd, 0x4c, 0x6e, 0x13, 0x04, 0x3e, 0xab, 0x3f, 0x9f, 0x3e, 0x5a, 0x65, 0xb3, 0xcf, 0xa7, 0x37,
	0x91, 0x2c, 0xa6, 0xd0, 0xf3, 0x83, 0x2b, 0xdb, 0x74, 0x2d, 0x4c, 0x35, 0x9f, 0x08, 0x71, 0x71,
	0x05, 0xe6, 0xb3, 0xe6, 0xdb, 0xb0, 0x68, 0x36, 0x65, 0x39, 0x10, 0xce, 0x2a, 0x5c, 0xc8, 0x9e,
	0x52, 0x63, 0x51, 0xd9, 0x82, 0x67, 0x86, 0xf6, 0xc7, 0x38, 0x91, 0xb9, 0x16, 0xd7, 0xe1, 0xca,
	0x60, 0xee, 0x8e, 0x15, 0xe7, 0xeb, 0xdf, 0x97, 0x61, 0x36, 0xc1, 0xc7, 0xcc, 0x95, 0x30, 0x0a,
	0xc4, 0x58, 0x88, 0x05, 0x62, 0xd4, 0x60, 0xca, 0x16, 0x31, 0xd2, 0xa2, 0x98, 0x7f, 0x31, 0x18,
	0x99, 0x84, 0x6e, 0x0f, 0x7b, 0x46, 0x60, 0x3b, 0xfb, 0x4c, 0x33, 0xe6, 0xeb, 0x5b, 0x12, 0x8c,
	0x6e, 0xc0, 0x7c, 0x02, 0xb4, 0x46, 0x2f, 0x22, 0xd8, 0x9a, 0x97, 0x99, 0x47, 0xc3, 0x50, 0x7a,
	0xe6, 0x81, 0x1d, 0x60, 0x33, 0xe8, 0x7b, 0x98, 0xaf, 0x81, 0x31, 0x58, 0x5a, 0xf1, 0xac, 0x64,
	0x28, 0x9e, 0xe8, 0x26, 0x5c, 0x8c, 0x0e, 0x95, 0x98, 0xa9, 0x8d, 0xec, 0xcb, 0x5b, 0xd3, 0xf3,
	0xb2, 0x89, 0xc0, 0x8a, 0x0b, 0x72, 0x7e, 0xfd, 0x95, 0x80, 0xa2, 0xaf, 0xc2, 0x79, 0x21, 0x77,
	0xe4, 0x69, 0xcd, 0x22, 0x02, 0xbe, 0x33, 0xda, 0x30, 0x0f, 0xc5, 0x47, 0x6a, 0x56, 0x67, 0xd1,
	0x46, 0x07, 0xa0, 0x0a, 0x70, 0x38, 0x87, 0x27, 0x69, 0x7d, 0x6f, 0x8e, 0x59, 0x5f, 0x7c, 0x0a,
	0xa7, 0xa8, 0x2e, 0xde, 0x82, 0x7a, 0x5e, 0xd3, 0xc6, 0x0a, 0x40, 0xd5, 0x80, 0x85, 0xcc, 0x2a,
	0xc7, 0x21, 0xa2, 0xfd, 0x6a, 0x11, 0xaa, 0xe1, 0xf5, 0x76, 0xd6, 0x80, 0x26, 0xab, 0xbc, 0x70,
	0xdf, 0x15, 0x76, 0x75, 0x21, 0x40, 0xdc, 0x46, 0xf2, 0x1b, 0x54, 0xb2, 0x67, 0xcb, 0x5c, 0x1f,
	0x4a, 0x79, 0xeb, 0xc3, 0x8b, 0x30, 0x67, 0x91, 0x8e, 0x8f, 0x95, 0x66, 0x9b, 0xb0, 0x74, 0x86,
	0x14, 0x34, 0x6c, 0x22, 0x16, 0x34, 0xec, 0x2a, 0x4c, 0x1a, 0x8e, 0xe3, 0xb2, 0x4b, 0x77, 0x16,
	0xb3, 0xb4, 0xa6, 0xcb, 0x20, 0xb4, 0x05, 0xb3, 0xee, 0x43, 0x1a, 0x17, 0x77, 0x0f, 0x7b, 0xd8,
	0x31, 0x31, 0x8b, 0x0d, 0x94, 0x6f, 0x08, 0xb0, 0x15, 0x2b, 0xad, 0x27, 0xb1, 0xb3, 0x16, 0xcc,
	0x5a, 0x6e, 0xac, 0xcf, 0x3d, 0xdb, 0x31, 0x3a, 0xf6, 0x07, 0x22, 0x6e, 0x79, 0x4d, 0x97, 0x20,
	0xe8, 0x6d, 0x58, 0x14, 0x5f, 0x7a, 0xdb, 0x33, 0x4c, 0xdc, 0xc2, 0x9e, 0xed, 0x5a, 0x6d, 0x6c,
	0xba, 0x8e, 0xe5, 0xf3, 0x95, 0x75, 0x40, 0x09, 0xed, 0x2e, 0xcc, 0xc4, 0x1b, 0x3b, 0xec, 0xda,
	0x98, 0x77, 0x14, 0x82, 0xd2, 0xa1, 0xed, 0x88, 0xbe, 0xa3, 0xff, 0xb5, 0x7f, 0xa7, 0xc0, 0xec,
	0xd6, 0xee, 0x57, 0xb0, 0x19, 0xc4, 0xa8, 0xd1, 0x72, 0x4a, 0x54, 0x6e, 0xc8, 0xa0, 0xc8, 0x52,
	0x6d, 0x79, 0xfd, 0xa5, 0xa8, 0xfe, 0x2b, 0x00, 0x46, 0xcf, 0x8e, 0xef, 0x70, 0x25, 0x48, 0x16,
	0x87, 0x27, 0xb2, 0x39, 0x7c, 0x19, 0x6a, 0x7b, 0x36, 0xee, 0x58, 0x2d, 0x23, 0x38, 0xe0, 0x12,
	0x2b, 0x02, 0x68, 0x7f, 0x4d, 0x09, 0x8d, 0x30, 0x68, 0xec, 0xb2, 0xbc, 0xed, 0x7b, 0x5e, 0x3c,
	0x33, 0x71, 0x05, 0x5d, 0x94, 0xae, 0xa0, 0xaf, 0x00, 0x04, 0x86, 0xb7, 0x8f, 0xa3, 0x68, 0x66,
	0x35, 0x5d, 0x82, 0x10, 0x7a, 0x64, 0x8d, 0xa5, 0xb9, 0x6c, 0x73, 0x17, 0xa6, 0xb5, 0xfb, 0x70,
	0x99, 0x37, 0xa7, 0x8d, 0x7d, 0xd2, 0xfe, 0xe5, 0xbd, 0x3d, 0xdb, 0xb1, 0x83, 0xe3, 0x86, 0xeb,
	0xec, 0xd9, 0xfb, 0xe8, 0x55, 0xb8, 0x60, 0x52, 0x4b, 0xc8, 0xb5, 0x16, 0x19, 0xf9, 0x6e, 0x3f,
	0x10, 0x63, 0x81, 0xe9, 0xd8, 0x39, 0xb9, 0xda, 0x1f, 0x16, 0xa1, 0x44, 0x43, 0xaa, 0xbc, 0x01,
	0xd5, 0xae, 0xb0, 0x76, 0x51, 0x06, 0x9a, 0x28, 0x85, 0x76, 0x2e, 0x21, 0x02, 0xd9, 0x68, 0x10,
	0xfd, 0x76, 0x6d, 0x55, 0x17, 0xef, 0x20, 0xf0, 0x24, 0xe5, 0x11, 0xfb, 0x2b, 0xe2, 0xc9, 0x85,
	0x69, 0xb2, 0x6e, 0xf4, 0x1d, 0xdf, 0x3c, 0xc0, 0x56, 0xbf, 0x43, 0x25, 0x75, 0x89, 0x5a, 0x4a,
	0xc4, 0x81, 0xe8, 0x15, 0x98, 0x20, 0xab, 0x42, 0xe8, 0xe1, 0x72, 0x39, 0xcf, 0x08, 0x87, 0x14,
	0xd2, 0x79, 0x59, 0xf4, 0x5a, 0x18, 0x94, 0x6d, 0x62, 0xe0, 0x6d, 0x19, 0xf9, 0xf6, 0xf8, 0xd3,
	0x0b, 0xe8, 0x02, 0x94, 0x8e, 0x8d, 0x6e, 0x87, 0x99, 0x85, 0xac, 0x14, 0xea, 0x8a, 0x4e, 0xd3,
	0x44, 0x1c, 0x32, 0xaf, 0x42, 0x16, 0x1f, 0x2c, 0xe1, 0x38, 0x58, 0x93, 0x74, 0x55, 0xb2, 0xa5,
	0xf4, 0xdc, 0x23, 0xdb, 0xa2, 0xf1, 0x3c, 0x81, 0x6f, 0x29, 0x43, 0x48, 0x78, 0xb3, 0x3b, 0x39,
	0xea, 0xcd, 0xae, 0xa4, 0xfc, 0x4e, 0x9d, 0x48, 0xf9, 0xd5, 0xbe, 0x56, 0x01, 0x88, 0xbe, 0x15,
	0xdd, 0x83, 0xaa, 0x29, 0xd6, 0x2b, 0x65, 0x60, 0xc8, 0xc4, 0x08, 0x69, 0x29, 0xbe, 0x44, 0x85,
	0x04, 0xd0, 0x36, 0x4c, 0x1a, 0xd2, 0x7a, 0xcb, 0x36, 0x6c, 0x37, 0x86, 0xd3, 0x4b, 0x2d, 0xb1,
	0x32, 0x19, 0xf4, 0x1e, 0x4c, 0x93, 0xd1, 0x1f, 0x0f, 0x47, 0x38, 0x79, 0xe3, 0x95, 0xe1, 0x74,
	0x37, 0x65, 0x34, 0x46, 0x39, 0x4e, 0x4a, 0x0a, 0xd9, 0x57, 0x8a, 0x85, 0xec, 0x4b, 0x6b, 0x1a,
	0xe5, 0x4c, 0x4d, 0x63, 0x95, 0x06, 0xd5, 0x65, 0xd6, 0x63, 0xc3, 0x8e, 0x5b, 0x36, 0xe9, 0xe6,
	0x96, 0x17, 0xd6, 0x25, 0x3c, 0xf4, 0x16, 0x4c, 0x50, 0xe3, 0x0f, 0x11, 0x2f, 0x7b, 0xe8, 0xc9,
	0x33, 0x55, 0xc9, 0x74, 0x8e, 0x84, 0xae, 0x83, 0x4a, 0x9a, 0xd5, 0xf2, 0xdc, 0x47, 0xc7, 0x71,
	0x4d, 0x2a, 0x05, 0xcf, 0x52, 0x12, 0x6b, 0xd9, 0x4a, 0x62, 0x52, 0xe1, 0x83, 0x51, 0x14, 0xbe,
	0xc9, 0x2c, 0x85, 0xaf, 0x0e, 0x15, 0xd7, 0x67, 0x1a, 0x26, 0x8b, 0xb4, 0x2a, 0x92, 0x83, 0x54,
	0xc1, 0xe9, 0x81, 0xaa, 0xe0, 0xe2, 0x1b, 0x30, 0x7d, 0x62, 0x6d, 0x7c, 0xf1, 0x6d, 0x50, 0x4f,
	0xb5, 0x37, 0x78, 0x17, 0x50, 0x7a, 0x68, 0x8d, 0xa5, 0x37, 0xfd, 0x6d, 0x05, 0xa6, 0x63, 0xe3,
	0x21, 0xd3, 0x8a, 0x28, 0x1a, 0x9d, 0x85, 0xd8, 0xe8, 0x5c, 0x02, 0xd4, 0x31, 0xfc, 0x60, 0xdb,
	0x33, 0x1c, 0xdf, 0x16, 0x3a, 0x0e, 0xbf, 0x77, 0xcb, 0xc8, 0x61, 0xbb, 0x0a, 0xc3, 0x97, 0xc3,
	0xbb, 0x93, 0x94, 0xfc, 0x6a, 0x4d, 0x39, 0xf6, 0x6a, 0x8d, 0xb6, 0x0a, 0x33, 0xf1, 0xc1, 0x46,
	0xed, 0xff, 0xa8, 0x5d, 0x25, 0xb3, 0x80, 0x63, 0x09, 0x7a, 0x4c, 0x69, 0x7f, 0xc0, 0xaf, 0xee,
	0xf8, 0xbd, 0x60, 0x08, 0xd0, 0x30, 0x94, 0xa9, 0x30, 0x1e, 0x95, 0x35, 0xa4, 0xa1, 0x78, 0x6f,
	0x0f, 0xf3, 0xe3, 0xd0, 0x9a, 0xce, 0x53, 0xa4, 0x1a, 0xd2, 0xf9, 0xcb, 0x96, 0x85, 0xc5, 0x3b,
	0x1c, 0x11, 0x40, 0xfb, 0x8d, 0x72, 0xb8, 0x44, 0xb7, 0x7b, 0xd8, 0x44, 0x37, 0x45, 0xac, 0x5c,
	0x65, 0x14, 0x13, 0x50, 0x39, 0x4c, 0xee, 0x06, 0xd4, 0x7c, 0xcc, 0x7c, 0x0e, 0xc4, 0x79, 0xd3,
	0x4b, 0xb9, 0xc6, 0xbd, 0xbb, 0xb8, 0xd3, 0xc6, 0x61, 0x78, 0xff, 0xbe, 0xed, 0x61, 0x1a, 0x34,
	0x2e, 0xa2, 0x20, 0x3b, 0x95, 0xb4, 0x92, 0xe1, 0x2f, 0x5b, 0xb1, 0xf7, 0x7c, 0x44, 0x8f, 0x5f,
	0x85, 0x49, 0xb2, 0x67, 0xf7, 0x1c, 0xa3, 0xb3, 0xd6, 0x12, 0xd1, 0x0e, 0x65, 0x10, 0x99, 0xc0,
	0x7e, 0x7c, 0xe1, 0x17, 0x7a, 0x4d, 0x02, 0x4c, 0x64, 0x58, 0xc7, 0x35, 0xac, 0x15, 0xa3, 0x43,
	0xb6, 0x88, 0xa4, 0x09, 0x4c, 0xb9, 0x49, 0x40, 0xd1, 0xeb, 0x50, 0x97, 0x21, 0xdc, 0x3c, 0x94,
	0x79, 0xf9, 0xb0, 0x15, 0x2e, 0x37, 0x9f, 0x08, 0x09, 0xd1, 0x38, 0x6a, 0xc9, 0xcb, 0x64, 0x49,
	0x0c, 0x86, 0x5e, 0x81, 0x05, 0x91, 0xde, 0xf6, 0x8c, 0xbd, 0x3d, 0xdb, 0x64, 0xfe, 0x54, 0x5c,
	0xa2, 0x64, 0x67, 0xa2, 0x97, 0xe1, 0x3c, 0xbb, 0x19, 0x6b, 0x1c, 0x60, 0xf3, 0x70, 0x53, 0xa8,
	0x43, 0xcc, 0xf4, 0x3e, 0x2b, 0x8b, 0x7c, 0x47, 0xaf, 0xbf, 0xdb, 0xb1, 0xfd, 0x83, 0x4d, 0x37,
	0xd0, 0xb1, 0x61, 0x1d, 0x47, 0x4b, 0xc6, 0x14, 0x55, 0x28, 0x72, 0xf3, 0x91, 0x0d, 0x0b, 0x7e,
	0x96, 0x3a, 0xc5, 0x8f, 0x98, 0x3e, 0x3d, 0x78, 0x08, 0x65, 0x6a, 0x62, 0x7a, 0x36, 0x45, 0xea,
	0x9f, 0xd2, 0xbb, 0xc5, 0x8e, 0xa5, 0x99, 0xd1, 0x7e, 0x98, 0xd6, 0x96, 0x61, 0x5a, 0x90, 0x64,
	0x33, 0xfd, 0x65, 0x38, 0x1f, 0xeb, 0x2d, 0xe6, 0x7e, 0xca, 0xc3, 0xaf, 0x67, 0x65, 0x69, 0x3f,
	0x5d, 0x80, 0x8a, 0x08, 0x20, 0x78, 0x2a, 0x55, 0xee, 0x55, 0x28, 0xf9, 0x3d, 0x6c, 0x8e, 0x66,
	0x9c, 0x4d, 0xe6, 0x9d, 0x4e, 0xcb, 0xa3, 0x37, 0x13, 0x0f, 0x5e, 0x3d, 0x37, 0x04, 0x33, 0x5b,
	0xe7, 0x2a, 0x25, 0x74, 0xae, 0xac, 0xf8, 0x9f, 0x92, 0x32, 0x34, 0x71, 0x32, 0x65, 0xe8, 0x37,
	0x15, 0x38, 0x1f, 0xc5, 0x7b, 0x3c, 0x99, 0x30, 0x26, 0xd3, 0xcc, 0xf0, 0x83, 0x9d, 0x9e, 0x15,
	0xb7, 0x31, 0x4e, 0x40, 0x73, 0x84, 0x76, 0xe5, 0x31, 0x0a, 0xed, 0x3f, 0x98, 0x00, 0x90, 0xa2,
	0x6d, 0x9e, 0xaa, 0xf7, 0xe9, 0xf6, 0x89, 0x86, 0x0b, 0xf5, 0x57, 0x59, 0x78, 0x76, 0x7e, 0xe6,
	0x96, 0x04, 0x93, 0xef, 0x8a, 0xc2, 0x64, 0xb6, 0x03, 0xcf, 0x08, 0xf0, 0xbe, 0xb8, 0x70, 0xc9,
	0xc8, 0xa1, 0xa7, 0xd3, 0xc6, 0xa3, 0x1d, 0x87, 0xbf, 0x07, 0xd1, 0x11, 0x02, 0x30, 0x01, 0xa5,
	0xd7, 0xd0, 0xc6, 0xa3, 0x76, 0xdf, 0x0b, 0x3f, 0x34, 0x4c, 0x53, 0x3b, 0x69, 0xa3, 0xef, 0x63,
	0x76, 0x15, 0x53, 0xd5, 0x79, 0x2a, 0x2e, 0xbf, 0x2b, 0xa7, 0x96, 0xdf, 0xf4, 0x5e, 0x94, 0x7d,
	0x2d, 0xb7, 0x65, 0x0b, 0xd3, 0x84, 0x41, 0x7d, 0xda, 0xb9, 0x96, 0x2e, 0x8a, 0xb0, 0xdb, 0x91,
	0x24, 0x58, 0xdc, 0x91, 0x1e, 0x87, 0xe5, 0x80, 0xb9, 0xad, 0xc5, 0x80, 0xe8, 0x45, 0x98, 0x0b,
	0xbf, 0x3d, 0x2c, 0xc9, 0xa4, 0x5d, 0x3a, 0x83, 0xc8, 0x85, 0xbe, 0x93, 0x2e, 0x3f, 0xc5, 0xa4,
	0x63, 0x46, 0x16, 0xb7, 0x12, 0x62, 0xe3, 0x7b, 0x83, 0x8f, 0x1f, 0xa6, 0x63, 0xa5, 0xe0, 0xe8,
	0x7d, 0x98, 0x17, 0x9b, 0x64, 0x89, 0x33, 0x22, 0xf6, 0xfc, 0x27, 0x87, 0xcc, 0x32, 0x19, 0x45,
	0xcf, 0x24, 0x14, 0xce, 0xf2, 0x99, 0x9c, 0x59, 0x3e, 0x9b, 0x3d, 0xcb, 0xe7, 0x4e, 0x76, 0xde,
	0x7f, 0x37, 0xa6, 0xa4, 0xa3, 0x81, 0x11, 0x89, 0x33, 0xa4, 0x81, 0xac, 0xaa, 0x6b, 0x3f, 0xae,
	0xc0, 0xf9, 0x28, 0xa6, 0xee, 0x47, 0x55, 0x7d, 0xfb, 0x73, 0x65, 0x00, 0x29, 0x52, 0xf1, 0x87,
	0x24, 0x09, 0x62, 0xb3, 0xaf, 0xf8, 0x58, 0x67, 0x5f, 0x29, 0x31, 0xfb, 0x6e, 0xc0, 0xfc, 0x5e,
	0xbf, 0xd3, 0x39, 0xa6, 0x74, 0xa4, 0x29, 0xc8, 0x4e, 0x4b, 0x32, 0xf3, 0xd2, 0xf3, 0x70, 0x62,
	0xe4, 0x79, 0x58, 0xc9, 0x9b, 0x87, 0x79, 0x33, 0x05, 0x1e, 0xf7, 0x4c, 0xa9, 0xe6, 0xcc, 0x94,
	0x5a, 0xf6, 0x4c, 0x99, 0x7c, 0x1c, 0x33, 0x65, 0x6a, 0xe0, 0x4c, 0xc9, 0x98, 0x05, 0xb1, 0x99,
	0xf2, 0x65, 0xa8, 0xe7, 0xf5, 0x72, 0xc6, 0x7e, 0x60, 0x11, 0xaa, 0x6c, 0x03, 0x1a, 0x5e, 0xe2,
	0x87, 0x69, 0x7a, 0xbd, 0x4f, 0xb6, 0x07, 0xe2, 0xe0, 0x88, 0xa7, 0xb4, 0xff, 0xa1, 0xc0, 0xf9,
	0xac, 0x28, 0xe7, 0xa7, 0x1a, 0xee, 0x2b, 0x31, 0xb5, 0x67, 0x69, 0xf4, 0xc0, 0xe5, 0x92, 0x0a,
	0x74, 0x27, 0xa1, 0x02, 0xbd, 0x3c, 0x06, 0x95, 0xb8, 0x3a, 0x24, 0xba, 0xb9, 0x24, 0x05, 0xf5,
	0xfc, 0x95, 0x02, 0x5c, 0xcc, 0xa9, 0x1f, 0xdd, 0x82, 0xa9, 0xae, 0xed, 0x2c, 0x87, 0x4b, 0xeb,
	0x60, 0x57, 0xbd, 0x35, 0x27, 0xd8, 0xf2, 0xda, 0x81, 0x47, 0xe3, 0x39, 0xc9, 0x78, 0xe8, 0x1e,
	0x54, 0xc5, 0x44, 0x3c, 0xe9, 0x3e, 0x28, 0x24, 0x80, 0xee, 0xa6, 0x56, 0xfc, 0xe2, 0xc8, 0xcd,
	0x4a, 0x6a, 0x05, 0x6f, 0xc3, 0x62, 0xdf, 0x61, 0xda, 0xff, 0x71, 0xcb, 0xb5, 0x9a, 0x47, 0x36,
	0x75, 0xd0, 0xe1, 0x3b, 0x0a, 0x26, 0x1f, 0x07, 0x94, 0xd0, 0xbe, 0x55, 0x84, 0x4b, 0xb9, 0x6c,
	0x47, 0x36, 0x4c, 0x5b, 0x2c, 0x07, 0x5b, 0x2d, 0xd7, 0x12, 0x3b, 0xc8, 0xc6, 0xb8, 0xfd, 0xb7,
	0xb4, 0x2a, 0x53, 0xe1, 0x27, 0x4f, 0x31, 0xca, 0x54, 0x6d, 0x0a, 0x71, 0xe9, 0x55, 0xe5, 0xc3,
	0x50, 0xb2, 0x66, 0xe4, 0xd0, 0xcb, 0xfa, 0xbe, 0xe7, 0x61, 0x27, 0x60, 0x86, 0x83, 0xc7, 0xfc,
	0x44, 0x39, 0x01, 0x25, 0xe5, 0xf8, 0x7b, 0x3a, 0xa2, 0x1c, 0x93, 0x9d, 0x09, 0x28, 0xdb, 0xb9,
	0xf5, 0xb0, 0x29, 0xbe, 0x94, 0x49, 0xce, 0x18, 0x8c, 0xbf, 0x95, 0x18, 0x3f, 0xdd, 0x1a, 0xe0,
	0x37, 0x9d, 0x16, 0x02, 0x8b, 0xef, 0x02, 0x4a, 0xb3, 0x62, 0xac, 0x9b, 0xd3, 0x6f, 0x2a, 0x30,
	0x29, 0x0d, 0x08, 0xf4, 0x86, 0xb4, 0xd0, 0xce, 0xe4, 0x3a, 0xbe, 0x4a, 0x18, 0x4b, 0xd4, 0x79,
	0x2b, 0x5c, 0x91, 0x6d, 0x27, 0xb8, 0x1f, 0x46, 0x06, 0xe0, 0x29, 0xb6, 0x52, 0x7b, 0x04, 0x5e,
	0x14, 0x2b, 0x35, 0x49, 0x69, 0x4f, 0x41, 0x89, 0x5e, 0xad, 0x56, 0xa0, 0xb8, 0xe6, 0x04, 0xea,
	0x39, 0x04, 0x30, 0xc1, 0xa8, 0xaa, 0x8a, 0xf6, 0x23, 0x0a, 0xf5, 0x02, 0xfb, 0x48, 0x2a, 0x00,
	0xdf, 0xae, 0x40, 0xb1, 0xe5, 0x5a, 0xa7, 0x13, 0x85, 0x33, 0x50, 0x58, 0x6b, 0x09, 0x27, 0xb6,
	0xb5, 0x16, 0x59, 0x1a, 0x1d, 0x97, 0x3f, 0x5a, 0x41, 0x76, 0xdd, 0x9b, 0xd1, 0x2d, 0x4d, 0x3a,
	0x43, 0x5c, 0x62, 0xd0, 0x42, 0xac, 0xd9, 0x61, 0x9a, 0x74, 0x77, 0xef, 0xc0, 0xf0, 0x45, 0xb3,
	0x59, 0x82, 0x0c, 0x49, 0x0f, 0x53, 0x1b, 0x57, 0x66, 0x14, 0xc4, 0xd6, 0xe7, 0x18, 0x0c, 0x6d,
	0x4b, 0x8f, 0x35, 0xb2, 0xb9, 0x16, 0x9e, 0x9a, 0x3e, 0x3f, 0x8a, 0xbd, 0x6e, 0xdf, 0xd7, 0xd3,
	0x04, 0xd0, 0x17, 0x61, 0x81, 0x6c, 0xd1, 0x1b, 0x29, 0xca, 0x33, 0x63, 0x51, 0xce, 0x26, 0x92,
	0xa9, 0x7a, 0x57, 0x73, 0x54, 0xef, 0x68, 0xc8, 0xd4, 0x62, 0x43, 0x46, 0xe8, 0x01, 0x90, 0xa3,
	0x07, 0x4c, 0x66, 0xbc, 0x99, 0x38, 0x35, 0xea, 0xad, 0x42, 0x9e, 0x16, 0x33, 0xfd, 0xb8, 0xb4,
	0x98, 0x45, 0xa8, 0x7e, 0x6e, 0xab, 0x4d, 0x03, 0x99, 0xf0, 0xd7, 0xad, 0xc2, 0x34, 0x7d, 0xed,
	0xce, 0xb3, 0x5d, 0xcf, 0x0e, 0x8e, 0x59, 0x01, 0x95, 0x9d, 0x21, 0xc7, 0x80, 0x8f, 0x61, 0x17,
	0x20, 0xde, 0x2e, 0xa3, 0x73, 0x0d, 0x49, 0x6f, 0x97, 0xd1, 0x29, 0xf6, 0x1c, 0x4c, 0xf3, 0xbb,
	0x26, 0x6c, 0xd1, 0x12, 0xe7, 0xd9, 0x9b, 0x7b, 0x31, 0x20, 0x7f, 0x43, 0x4f, 0x08, 0xc4, 0xf9,
	0x81, 0xb1, 0x5c, 0x5a, 0xae, 0x95, 0x7d, 0xda, 0x7f, 0x1b, 0xa6, 0xe8, 0x25, 0x84, 0x38, 0xbe,
	0x5b, 0x18, 0x18, 0xb3, 0x65, 0x53, 0x2a, 0xaa, 0xc7, 0x10, 0xb5, 0x5f, 0x53, 0x60, 0x4a, 0xae,
	0x65, 0x2c, 0x19, 0xf4, 0x1c, 0x4c, 0x13, 0x49, 0xd3, 0xf2, 0xdc, 0x5d, 0x2c, 0x89, 0x9f, 0x38,
	0x30, 0x47, 0x52, 0x95, 0x46, 0x90, 0x54, 0xe5, 0x3c, 0x49, 0x35, 0x91, 0x38, 0xb4, 0x50, 0x60,
	0x36, 0x31, 0x65, 0x32, 0xef, 0x58, 0x63, 0x6e, 0x62, 0xab, 0xe1, 0x63, 0x43, 0x11, 0x88, 0x5e,
	0xcb, 0x11, 0x55, 0x9e, 0x7e, 0x49, 0x55, 0x67, 0x89, 0x94, 0x50, 0x29, 0x65, 0x08, 0x95, 0x79,
	0x61, 0xf8, 0xcf, 0xc5, 0x11, 0xb3, 0xe8, 0xcf, 0x6d, 0x73, 0xe4, 0xb9, 0x5b, 0xc9, 0x79, 0x54,
	0xaf, 0x1a, 0x7b, 0x54, 0x4f, 0xfb, 0xc5, 0x02, 0x4c, 0xc9, 0xfd, 0x88, 0xfe, 0x8a, 0x02, 0x4b,
	0x1e, 0x9b, 0x20, 0xd6, 0x6a, 0x9f, 0xac, 0x27, 0x6d, 0x36, 0xce, 0x6c, 0x67, 0x7f, 0x6d, 0xdf,
	0x71, 0x43, 0x70, 0x53, 0xbc, 0xe3, 0xc8, 0xa5, 0xf7, 0xa0, 0x51, 0x12, 0x2a, 0x61, 0x63, 0x92,
	0x46, 0x3f, 0xac, 0xc0, 0x4b, 0x3d, 0x0f, 0xef, 0x61, 0x6f, 0xf4, 0xe6, 0x14, 0x06, 0x86, 0x22,
	0x6b, 0x09, 0x6a, 0x11, 0x9d, 0x6d, 0xec, 0x75, 0xf5, 0x71, 0xab, 0xd1, 0x30, 0x63, 0x9c, 0xf8,
	0x34, 0xb4, 0x43, 0x96, 0xa0, 0x28, 0x4d, 0x88, 0x0a, 0x25, 0xed, 0x85, 0x11, 0x58, 0x43, 0x1b,
	0x91, 0xa6, 0xa0, 0x7d, 0x00, 0x17, 0x73, 0x9a, 0x4c, 0x46, 0xf4, 0x43, 0x6c, 0xef, 0x1f, 0x08,
	0x1b, 0x55, 0x9e, 0x42, 0xb7, 0x01, 0xd8, 0xc7, 0x60, 0xf1, 0xb2, 0xd7, 0x18, 0x4d, 0x90, 0x50,
	0xb5, 0x3f, 0x2e, 0x40, 0x75, 0x43, 0x0e, 0xe2, 0x2f, 0x66, 0x30, 0x7f, 0xe3, 0x7f, 0x8c, 0x77,
	0x61, 0xd3, 0xe6, 0x34, 0x75, 0xa8, 0x90, 0x29, 0x82, 0xf9, 0xc0, 0x9f, 0xd2, 0x45, 0x52, 0xcc,
	0x27, 0xec, 0xb0, 0xf7, 0x8e, 0xcb, 0xd1, 0x7c, 0xe2, 0x20, 0xd9, 0xc1, 0x60, 0x22, 0xee, 0x60,
	0x20, 0x16, 0x9d, 0x8a, 0xb4, 0xe8, 0x24, 0x1f, 0xba, 0xaa, 0x66, 0x3c, 0x74, 0x15, 0xb7, 0xd9,
	0xa8, 0xa5, 0x6c, 0x36, 0x64, 0x95, 0x01, 0x12, 0x2a, 0x83, 0xb0, 0x23, 0x99, 0x94, 0xec, 0x48,
	0xc6, 0x5d, 0xe8, 0xb4, 0xbf, 0xab, 0x00, 0x0a, 0x1f, 0x16, 0xf8, 0xa8, 0xea, 0x6e, 0x5f, 0x2b,
	0x40, 0x2d, 0x7a, 0xab, 0xe1, 0x54, 0x1a, 0x5c, 0xde, 0x47, 0x64, 0x69, 0x24, 0xc5, 0x5c, 0x8d,
	0x64, 0xf4, 0x13, 0xf9, 0xb5, 0x8c, 0x0d, 0xc3, 0x27, 0x86, 0x3d, 0xf0, 0x90, 0x7d, 0x7c, 0xf0,
	0x83, 0x45, 0x98, 0xcf, 0xd2, 0x30, 0xd0, 0x56, 0xf8, 0xc4, 0x23, 0x9b, 0xf7, 0x9f, 0x1d, 0x43,
	0x3d, 0xc9, 0x7c, 0xea, 0x71, 0x07, 0xaa, 0x1e, 0x73, 0x2a, 0x12, 0x77, 0x7e, 0xaf, 0x8d, 0x43,
	0x92, 0x3b, 0x24, 0x71, 0xa2, 0x21, 0xa9, 0x4c, 0x33, 0xa6, 0x86, 0x74, 0xe5, 0x37, 0x93, 0xbb,
	0xa5, 0xce, 0xaa, 0x26, 0xda, 0xc4, 0x8c, 0xf9, 0x72, 0x64, 0xec, 0xe2, 0xfa, 0x0d, 0x98, 0x8e,
	0x35, 0x77, 0xac, 0x9d, 0xd8, 0xcf, 0x2b, 0x30, 0x9b, 0xd0, 0xae, 0xd0, 0x17, 0x61, 0x8a, 0xe9,
	0x57, 0xf7, 0xd9, 0x01, 0x0d, 0xeb, 0x92, 0x9b, 0xa3, 0xe9, 0x66, 0x4b, 0x1b, 0x12, 0x2a, 0x63,
	0x5f, 0x8c, 0xda, 0xe2, 0x3b, 0x30, 0x97, 0x2a, 0x32, 0xd6, 0x4b, 0x99, 0xff, 0xb7, 0x00, 0x95,
	0xbb, 0xee, 0x2e, 0x3d, 0x1a, 0xb9, 0x0a, 0x93, 0x3d, 0xc3, 0x33, 0x3a, 0x1d, 0xdc, 0xb1, 0xfd,
	0xae, 0x70, 0x72, 0x95, 0x40, 0x4c, 0x24, 0x76, 0x7b, 0xcc, 0x54, 0xce, 0xe7, 0x5b, 0x44, 0x19,
	0x84, 0x5e, 0x81, 0x05, 0x16, 0x6c, 0x6e, 0x15, 0x1b, 0x56, 0xc7, 0x76, 0xb0, 0xb0, 0xad, 0x62,
	0xf3, 0x3f, 0x3b, 0x93, 0x88, 0xc6, 0x5d, 0xc3, 0x3c, 0x74, 0xf7, 0xf6, 0x98, 0xcf, 0x1d, 0x57,
	0x41, 0x64, 0x58, 0xfc, 0xec, 0xb4, 0x7c, 0xea, 0xb3, 0x53, 0x7a, 0xc9, 0xe2, 0xf4, 0x8d, 0xb0,
	0x1c, 0xbf, 0x28, 0x49, 0x40, 0x73, 0x35, 0xff, 0xca, 0x63, 0xd2, 0xfc, 0xb5, 0xdf, 0x54, 0xa0,
	0x46, 0x7a, 0x20, 0x5f, 0xee, 0x28, 0x39, 0x72, 0x27, 0xa6, 0xaf, 0x17, 0x92, 0xfa, 0x3a, 0x0d,
	0x20, 0x23, 0x3a, 0x46, 0x12, 0xc1, 0x09, 0x28, 0x91, 0x80, 0xac, 0x53, 0x38, 0xd7, 0x79, 0x8a,
	0x52, 0xef, 0x9b, 0x26, 0xc6, 0x16, 0x16, 0x41, 0x6d, 0x22, 0x00, 0x73, 0x1c, 0xb2, 0x3b, 0x58,
	0xc4, 0xb6, 0xe1, 0x29, 0xaa, 0x71, 0xdf, 0x75, 0x77, 0xbf, 0xbb, 0x35, 0xee, 0x1f, 0x2b, 0x40,
	0xf1, 0xae, 0xbb, 0x7b, 0xba, 0x95, 0xe5, 0x46, 0xec, 0x98, 0xf4, 0x4a, 0xfe, 0x13, 0x35, 0xd2,
	0xb1, 0xe8, 0xcd, 0xc4, 0xb1, 0xe8, 0xd5, 0x01, 0x58, 0x27, 0xbf, 0x15, 0x6e, 0x64, 0xac, 0x41,
	0xcf, 0xe6, 0xd7, 0x94, 0xbd, 0xfa, 0xfc, 0x9d, 0x22, 0x4c, 0xf2, 0x17, 0x64, 0xa8, 0xf0, 0x58,
	0x84, 0xaa, 0xd8, 0x09, 0x8a, 0x67, 0x50, 0x45, 0x1a, 0xdd, 0x84, 0x8b, 0x74, 0x5c, 0xda, 0xce,
	0x7e, 0x52, 0x2c, 0xb0, 0x61, 0x9b, 0x97, 0x4d, 0x8d, 0x9d, 0x5d, 0x87, 0x1d, 0xe0, 0x99, 0xc7,
	0xfc, 0x0c, 0x93, 0x1f, 0xa8, 0xa4, 0x32, 0xa8, 0x3f, 0x70, 0xdf, 0xef, 0x61, 0x1e, 0x3a, 0xab,
	0xaa, 0x8b, 0x24, 0x7a, 0x1b, 0x16, 0xe9, 0xd8, 0xf5, 0xfd, 0xbd, 0x7e, 0xe7, 0xae, 0xbb, 0xeb,
	0xdf, 0xb1, 0xfd, 0x20, 0x0c, 0x13, 0xc4, 0x46, 0xf7, 0x80, 0x12, 0xe8, 0x55, 0xb8, 0xc0, 0x06,
	0x78, 0x0a, 0x97, 0x0d, 0xff, 0x9c, 0xdc, 0x33, 0x97, 0x1e, 0xd4, 0xf7, 0xcc, 0xee, 0xe2, 0xf7,
	0x5c, 0x47, 0x9c, 0x98, 0x84, 0x69, 0xed, 0x67, 0x14, 0x98, 0x16, 0x5d, 0xc4, 0x46, 0xc9, 0xdb,
	0xe1, 0x5c, 0x57, 0x06, 0x1e, 0xdb, 0x24, 0x4c, 0x94, 0x43, 0x99, 0x70, 0x1d, 0x54, 0x32, 0xc1,
	0xf8, 0x06, 0x40, 0x0e, 0xbf, 0x92, 0x82, 0x8b, 0x69, 0xda, 0x0e, 0x99, 0x9a, 0x54, 0x03, 0xe3,
	0x39, 0xda, 0x1f, 0x29, 0x50, 0x11, 0x8f, 0x27, 0x7d, 0x08, 0x66, 0x19, 0xd2, 0xd8, 0x1d, 0xd3,
	0x2c, 0x23, 0xc6, 0xd2, 0x93, 0x4c, 0x40, 0xed, 0x7f, 0x16, 0x60, 0x3a, 0x7c, 0x53, 0x88, 0xce,
	0x9e, 0xd8, 0xe2, 0xa6, 0x9c, 0x7a, 0x71, 0xcb, 0xb6, 0x38, 0x28, 0x8c, 0x61, 0x71, 0x50, 0xcc,
	0xb4, 0x38, 0xb8, 0x06, 0xb3, 0x5d, 0xdb, 0xa1, 0x96, 0x41, 0x62, 0x02, 0xb3, 0x45, 0x23, 0x09,
	0x46, 0x37, 0xc8, 0xc0, 0x3f, 0xb2, 0xc9, 0xa6, 0x25, 0x63, 0xaa, 0x65, 0xe6, 0xe5, 0x4e, 0x96,
	0x89, 0xc7, 0xb5, 0xd4, 0x7e, 0xa7, 0x00, 0xb3, 0x11, 0xdf, 0x59, 0xbf, 0xbd, 0x0a, 0x17, 0xf8,
	0xfd, 0xc0, 0x26, 0x75, 0x95, 0x15, 0x63, 0xd8, 0x0a, 0xad, 0xc1, 0x33, 0x73, 0x09, 0x8b, 0x99,
	0x6f, 0xed, 0x86, 0xed, 0x87, 0x47, 0x60, 0xe2, 0x76, 0x22, 0x9d, 0x43, 0xea, 0xe1, 0xf7, 0x0b,
	0xc9, 0x7a, 0xd8, 0x2d, 0x45, 0x4e, 0x2e, 0x7d, 0xb2, 0x9c, 0x82, 0x28, 0x7b, 0x39, 0xbb, 0x65,
	0x10, 0xa1, 0xcc, 0x0d, 0x2a, 0x92, 0x94, 0xb9, 0x6c, 0xca, 0xce, 0x25, 0x9d, 0xc9, 0xc8, 0x44,
	0x97, 0x61, 0xec, 0x16, 0x37, 0x09, 0xa6, 0xc7, 0xda, 0x14, 0x24, 0x8f, 0x10, 0x66, 0xee, 0x91,
	0xce, 0xa0, 0x5b, 0xc8, 0x90, 0xcb, 0x1f, 0xd5, 0x2d, 0xe4, 0x9f, 0x16, 0xa0, 0x16, 0x3d, 0x42,
	0x76, 0x2a, 0x79, 0x73, 0x33, 0x26, 0x6f, 0x9e, 0x1b, 0xf6, 0x86, 0x98, 0x24, 0x71, 0xde, 0x4e,
	0x48, 0x9c, 0xe7, 0x87, 0xe2, 0x3e, 0x41, 0x53, 0xb0, 0xc4, 0xd6, 0xb5, 0x32, 0x70, 0xeb, 0x9a,
	0xee, 0xff, 0x98, 0xf2, 0xf0, 0x03, 0x45, 0x16, 0x37, 0x86, 0xbf, 0x0a, 0x46, 0x45, 0xe0, 0x35,
	0x98, 0xe5, 0x53, 0x20, 0x34, 0x2a, 0x60, 0x33, 0x30, 0x09, 0x7e, 0xdc, 0x36, 0xa8, 0x89, 0x10,
	0xd6, 0xc5, 0x54, 0x08, 0x6b, 0xf4, 0x32, 0x9c, 0xef, 0xb9, 0xd6, 0x86, 0xe1, 0x18, 0xfb, 0x14,
	0x3b, 0x76, 0x97, 0x9a, 0x95, 0x45, 0x04, 0x2a, 0x9b, 0x75, 0xa1, 0xf0, 0xe5, 0xd6, 0xf1, 0x71,
	0x28, 0x51, 0xb2, 0x7b, 0x44, 0xf3, 0x09, 0xc4, 0x19, 0x52, 0x59, 0x8f, 0x00, 0x67, 0xbf, 0xf7,
	0xf8, 0x29, 0x05, 0xe6, 0xe4, 0x7e, 0x60, 0xc3, 0x4a, 0x36, 0x2b, 0x51, 0x12, 0x66, 0x25, 0x29,
	0x13, 0x91, 0x42, 0x96, 0x89, 0xc8, 0x35, 0x98, 0xe5, 0x62, 0x33, 0x2c, 0xc7, 0xa4, 0x5c, 0x12,
	0x9c, 0x65, 0x24, 0x56, 0xca, 0x34, 0x12, 0xd3, 0xfe, 0x9e, 0x02, 0xf3, 0x52, 0x5b, 0x3f, 0xb2,
	0x67, 0x53, 0x45, 0x98, 0x94, 0xdf, 0xeb, 0x3b, 0x95, 0x68, 0x79, 0x3d, 0x26, 0x5a, 0x9e, 0x1f,
	0xfe, 0xd8, 0x9e, 0x24, 0x5c, 0xde, 0x4d, 0x08, 0x97, 0x6b, 0x23, 0x60, 0x3f, 0x49, 0xf1, 0x72,
	0x2f, 0x43, 0xbc, 0x7c, 0x72, 0x78, 0x9b, 0xb3, 0x05, 0xcc, 0xd7, 0x0a, 0xa0, 0xa6, 0xde, 0xff,
	0x3b, 0x55, 0x57, 0xbc, 0x13, 0xeb, 0x8a, 0x4f, 0x8e, 0xf8, 0xc6, 0x9c, 0xd4, 0x1f, 0xcd, 0x44,
	0x7f, 0x7c, 0x6a, 0x54, 0x12, 0x27, 0xd7, 0x33, 0xbf, 0x55, 0x86, 0xf9, 0xac, 0x16, 0xa1, 0x9d,
	0x94, 0x4f, 0xd3, 0x6b, 0x63, 0x7c, 0x50, 0xae, 0x77, 0xd3, 0x0d, 0x98, 0x4f, 0xbe, 0xa6, 0x47,
	0x8f, 0xce, 0xd9, 0x1c, 0xcc, 0xcc, 0xa3, 0xae, 0xa5, 0x74, 0x1f, 0xb0, 0x41, 0x5f, 0x0b, 0x2f,
	0x72, 0xd7, 0xd2, 0x08, 0x84, 0x56, 0xa0, 0x6a, 0xd2, 0xa7, 0xfa, 0xf0, 0x1e, 0x8f, 0xcb, 0x38,
	0xea, 0xb6, 0x25, 0xc4, 0x43, 0xab, 0xf0, 0x74, 0xb2, 0x76, 0x1d, 0xd3, 0x5c, 0x2e, 0xcb, 0xd9,
	0x2c, 0x1e, 0x5c, 0x88, 0x6c, 0x7f, 0xe4, 0x17, 0x27, 0xe8, 0x72, 0xc1, 0x8e, 0x0e, 0x52, 0x70,
	0x1a, 0xe7, 0xc9, 0xed, 0x3b, 0xc1, 0x56, 0x4f, 0xf6, 0x99, 0x8d, 0xc1, 0xd0, 0x15, 0x80, 0x23,
	0x5a, 0x0d, 0xf9, 0x50, 0xbe, 0x7d, 0x93, 0x20, 0xe8, 0x5e, 0xe2, 0x1e, 0xb4, 0x36, 0xde, 0x35,
	0x4e, 0x0c, 0x19, 0xe1, 0xf4, 0xb3, 0x89, 0xcc, 0x51, 0x81, 0x87, 0xfb, 0x1f, 0x79, 0x3c, 0xb2,
	0x65, 0x24, 0x87, 0xd8, 0xa9, 0xdc, 0x8e, 0xb4, 0x5f, 0x2f, 0xc2, 0x85, 0xec, 0xfa, 0xd0, 0x2e,
	0xcc, 0xed, 0x53, 0xcf, 0x5c, 0x9e, 0x49, 0xe3, 0x45, 0xb3, 0x59, 0x9c, 0xe7, 0xe7, 0x76, 0xbb,
	0xd1, 0x8c, 0x97, 0x8f, 0x7d, 0x40, 0x9a, 0x1c, 0x3a, 0x84, 0x79, 0xe3, 0xa1, 0xdf, 0x24, 0xeb,
	0x80, 0x6d, 0xae, 0x74, 0x5c, 0xf3, 0xb0, 0x1d, 0xb8, 0x9e, 0xb8, 0xbb, 0xca, 0x3b, 0x46, 0x5f,
	0x7e, 0xd0, 0x4e, 0xa1, 0xc4, 0x6a, 0xca, 0x24, 0x8a, 0xb6, 0xa1, 0x66, 0x7c, 0xd0, 0xf7, 0xf0,
	0x2d, 0x3b, 0x34, 0xf7, 0x7a, 0x35, 0xaf, 0x06, 0x51, 0x2e, 0xa7, 0x2f, 0x22, 0x42, 0xe8, 0x2e,
	0xa7, 0x4a, 0xd9, 0xc3, 0x66, 0xcb, 0x8b, 0x83, 0xa8, 0xa6, 0xd8, 0x12, 0xa1, 0xa3, 0x9b, 0x50,
	0x34, 0x7d, 0x9b, 0x87, 0x13, 0xcf, 0xb5, 0xf0, 0x68, 0xaf, 0xc5, 0xf0, 0x09, 0x8a, 0xf6, 0x97,
	0x15, 0x78, 0x7a, 0x20, 0xf7, 0xa9, 0x7d, 0xba, 0x25, 0x3d, 0x35, 0xc3, 0x53, 0xf4, 0x5c, 0xd1,
	0x97, 0x84, 0x06, 0x4f, 0xc5, 0x15, 0xa5, 0x62, 0x52, 0x51, 0xe2, 0xe1, 0xb9, 0xb6, 0x9c, 0xce,
	0x31, 0x3f, 0xf9, 0x09, 0xd3, 0xda, 0xd7, 0x15, 0xb8, 0x3a, 0xac, 0x8b, 0x08, 0x01, 0x36, 0xef,
	0x68, 0x90, 0x44, 0x7a, 0x8c, 0x22, 0xd2, 0x67, 0xd0, 0xa4, 0x9f, 0x50, 0xe0, 0x63, 0x43, 0xfa,
	0x94, 0x86, 0x8d, 0xc2, 0xa6, 0x87, 0x03, 0x89, 0x49, 0x12, 0x84, 0x1e, 0xcf, 0x1e, 0x18, 0x9e,
	0xfc, 0xec, 0x4a, 0x04, 0x88, 0xd5, 0x5e, 0x8c, 0xd7, 0xce, 0xfc, 0xa3, 0x04, 0x1d, 0xe6, 0x61,
	0x5e, 0x12, 0xfe, 0x51, 0x31, 0xb0, 0xf6, 0x8b, 0x0a, 0x2c, 0x64, 0x8e, 0x12, 0x42, 0xdf, 0xb2,
	0xfd, 0x43, 0xa9, 0x6d, 0x61, 0x9a, 0xe8, 0x46, 0xe4, 0xff, 0x8e, 0xbe, 0x26, 0x3c, 0x9c, 0x79,
	0x92, 0x5e, 0x1f, 0x18, 0xe6, 0x81, 0xed, 0xec, 0x53, 0x81, 0xc7, 0x35, 0x6d, 0x09, 0x24, 0xf1,
	0xba, 0x14, 0xe3, 0xb5, 0xfc, 0x3d, 0xe5, 0xc4, 0xf7, 0x88, 0x7b, 0xcf, 0x09, 0xc9, 0xcf, 0xfe,
	0xaf, 0x4e, 0xc0, 0x6c, 0x62, 0x64, 0x12, 0xda, 0x96, 0x67, 0x1f, 0xf1, 0xd8, 0x58, 0x35, 0x9d,
	0xa7, 0x88, 0xa4, 0x66, 0x7d, 0x7d, 0xc7, 0x70, 0xac, 0x8e, 0x60, 0x66, 0x0c, 0x36, 0x90, 0x9f,
	0x79, 0x6d, 0x3e, 0x00, 0x95, 0xd1, 0x58, 0x0e, 0x02, 0xcf, 0xde, 0xed, 0x07, 0xe1, 0xe3, 0x46,
	0x6f, 0x8e, 0x36, 0x97, 0x96, 0xee, 0x27, 0xd0, 0x79, 0xc0, 0x8b, 0x24, 0x55, 0xb4, 0x07, 0x8b,
	0xa6, 0xeb, 0x04, 0x9e, 0xdb, 0xe9, 0x60, 0xaf, 0xc5, 0x3c, 0xb8, 0xda, 0xb4, 0x2f, 0xc9, 0x9a,
	0x39, 0x58, 0x1f, 0x0b, 0xcb, 0xf1, 0x35, 0x73, 0x00, 0x25, 0x74, 0x1f, 0x90, 0xc3, 0x7c, 0x87,
	0xf7, 0x71, 0x44, 0xbf, 0x32, 0x16, 0xfd, 0x0c, 0x0a, 0xe8, 0x3d, 0x98, 0xa7, 0xde, 0xfb, 0xc9,
	0x96, 0x57, 0xc7, 0xa2, 0x9c, 0x49, 0x03, 0x59, 0x70, 0x29, 0xfa, 0xa2, 0xe6, 0xa3, 0x9e, 0xe1,
	0x58, 0x51, 0x05, 0xb5, 0xb1, 0x2a, 0xc8, 0x27, 0x84, 0xbe, 0x17, 0xce, 0x93, 0xda, 0x93, 0xf4,
	0x61, 0x2c, 0xfa, 0x59, 0x24, 0x16, 0x1b, 0xb0, 0x90, 0x39, 0x0c, 0xc6, 0x72, 0xa6, 0x6d, 0xc0,
	0x6c, 0xa2, 0xb2, 0xf1, 0x43, 0x91, 0x68, 0x5f, 0xce, 0x58, 0x9b, 0x99, 0x4e, 0x1a, 0x1a, 0x2b,
	0x2a, 0xb2, 0xb1, 0xa2, 0xb4, 0x47, 0x2a, 0xc4, 0xad, 0x83, 0xa2, 0x5d, 0x55, 0x51, 0xde, 0x55,
	0x69, 0xbf, 0xa6, 0x80, 0x9a, 0xd4, 0x62, 0xd0, 0x17, 0x40, 0xed, 0x1a, 0x81, 0x79, 0xd0, 0x7c,
	0xd4, 0xf3, 0x98, 0xbb, 0xe0, 0x89, 0x4f, 0x48, 0x53, 0x84, 0xd0, 0xe7, 0x60, 0x92, 0xc2, 0x6e,
	0xd9, 0xb8, 0x63, 0x9d, 0xf8, 0x30, 0x41, 0xa6, 0xa1, 0xfd, 0x8d, 0x02, 0x2c, 0x64, 0x3f, 0x98,
	0x7d, 0xaa, 0xfd, 0xc7, 0x6a, 0x6c, 0xff, 0xf1, 0xf2, 0x38, 0x6f, 0x5c, 0x4b, 0x9b, 0x90, 0xbb,
	0x89, 0x4d, 0xc8, 0x8d, 0xb1, 0xe8, 0x9c, 0x7c, 0x27, 0xf2, 0x1b, 0x05, 0x78, 0x6a, 0x00, 0xcd,
	0x9c, 0x11, 0x94, 0xd8, 0x1b, 0x14, 0xd2, 0x7b, 0x83, 0x2f, 0x4a, 0x1b, 0x99, 0xe2, 0xc0, 0x98,
	0x64, 0x03, 0x6a, 0xcf, 0xdd, 0xcf, 0xec, 0xc4, 0xb6, 0xa4, 0xa5, 0x81, 0xc1, 0xef, 0x32, 0xe9,
	0x67, 0x9b, 0x7c, 0x9f, 0x4a, 0x45, 0xfe, 0x46, 0x11, 0x2e, 0xe5, 0xf6, 0x72, 0x92, 0x63, 0x4a,
	0x9a, 0x63, 0x6b, 0x50, 0x13, 0x47, 0x41, 0xfe, 0x90, 0xcd, 0x6c, 0xe6, 0x41, 0x52, 0x84, 0x1d,
	0x6d, 0x5f, 0xa4, 0x73, 0x33, 0x09, 0x12, 0x73, 0x91, 0x28, 0x9d, 0xd6, 0x45, 0x22, 0x6b, 0xef,
	0x55, 0xce, 0xd9, 0x7b, 0xc5, 0xf7, 0x55, 0x13, 0xa9, 0x7d, 0x55, 0x0b, 0x80, 0xb4, 0x83, 0x6f,
	0x7f, 0x2a, 0x03, 0x67, 0x14, 0x59, 0xca, 0xad, 0x75, 0xd7, 0x34, 0x3a, 0xc9, 0xdd, 0xa5, 0x44,
	0x43, 0x7b, 0x1f, 0x2e, 0xe5, 0x16, 0x24, 0xca, 0x83, 0xd1, 0xb3, 0x6f, 0xd3, 0x57, 0x6b, 0xb8,
	0xb2, 0x24, 0xd2, 0xa1, 0xf2, 0x52, 0x90, 0x8c, 0xb6, 0x32, 0xec, 0x62, 0xb4, 0xdf, 0x51, 0xe0,
	0xca, 0xe0, 0x21, 0xf6, 0x5d, 0x79, 0xd3, 0xfe, 0x2d, 0x05, 0x80, 0xbf, 0x1d, 0xda, 0xef, 0x50,
	0xb3, 0xd1, 0x23, 0xec, 0xed, 0x86, 0x21, 0x14, 0x68, 0x82, 0x2c, 0x4b, 0x82, 0x5f, 0x42, 0x08,
	0x44, 0x00, 0x16, 0x3a, 0x5d, 0x0c, 0x68, 0x76, 0x7c, 0x20, 0x8d, 0x51, 0x7a, 0x5e, 0xc9, 0x12,
	0xec, 0xd1, 0x2b, 0xe6, 0x27, 0x14, 0x07, 0xd2, 0xab, 0x10, 0xd7, 0x11, 0xe3, 0x7d, 0x47, 0x5f,
	0x17, 0xd2, 0x2b, 0x09, 0xd6, 0x0e, 0xa1, 0xd2, 0xee, 0xd3, 0xfe, 0xcd, 0x8c, 0xdb, 0x24, 0x77,
	0x75, 0x21, 0xdd, 0xd5, 0x29, 0x73, 0xa7, 0xd8, 0x8a, 0x5b, 0x4a, 0xae, 0xb8, 0x3f, 0xa9, 0x40,
	0x89, 0x3e, 0xe3, 0x7e, 0xaa, 0x95, 0xe3, 0xb3, 0x50, 0xf6, 0xfa, 0x1d, 0x2c, 0x56, 0xb7, 0x67,
	0x72, 0xad, 0xb1, 0x45, 0x37, 0xe8, 0xac, 0x7c, 0x28, 0xe0, 0x8b, 0x39, 0x02, 0x5e, 0x76, 0xb9,
	0xfa, 0x3f, 0x0a, 0x4c, 0xca, 0x6f, 0xa7, 0x9f, 0xf2, 0xd8, 0xb3, 0xea, 0x33, 0x26, 0x8b, 0x46,
	0xe7, 0x99, 0x4f, 0xf0, 0xbe, 0xd0, 0xc3, 0xf2, 0xe8, 0x2e, 0x54, 0x3c, 0xb7, 0x83, 0x89, 0xf6,
	0x55, 0x3c, 0xe1, 0xc4, 0x16, 0x04, 0xc6, 0x5a, 0xe1, 0xfe, 0x4d, 0x01, 0x26, 0xe5, 0x97, 0xf7,
	0x9f, 0x4c, 0x97, 0x7d, 0x01, 0x54, 0x63, 0x7f, 0xdf, 0xc3, 0xfb, 0x34, 0x2c, 0x9b, 0x4e, 0x69,
	0x9c, 0xd0, 0xcf, 0x34, 0x45, 0xe8, 0x43, 0x8e, 0x3c, 0xf0, 0x03, 0x05, 0x40, 0x19, 0x8f, 0xf2,
	0xff, 0x7f, 0x37, 0xb0, 0x7e, 0xaf, 0x00, 0x33, 0x89, 0xa7, 0xf4, 0x4f, 0xc5, 0x83, 0x77, 0xa1,
	0xc2, 0xf6, 0xf9, 0x82, 0x05, 0xa3, 0x9e, 0xa6, 0x0a, 0x34, 0xf4, 0x45, 0x50, 0xa9, 0xdd, 0x7e,
	0xab, 0xdf, 0xe9, 0xb4, 0x39, 0x29, 0x36, 0xc8, 0xc6, 0x67, 0x49, 0x8a, 0x12, 0x5a, 0x81, 0xcb,
	0x46, 0x3f, 0x70, 0xe9, 0x41, 0x69, 0xfc, 0xbb, 0xb7, 0xdd, 0x43, 0xec, 0xf0, 0xc3, 0x94, 0x81,
	0x65, 0x42, 0xfe, 0x96, 0x73, 0xf8, 0x2b, 0x3d, 0x10, 0xac, 0xf5, 0x61, 0x81, 0x47, 0x06, 0xe1,
	0x94, 0x56, 0x0c, 0xf3, 0x10, 0x3b, 0xa9, 0xa7, 0x6d, 0x95, 0xf4, 0xbd, 0xe0, 0x22, 0x7b, 0xab,
	0x52, 0x3a, 0x82, 0x09, 0xd3, 0x34, 0xb0, 0x19, 0xf9, 0xcf, 0xa2, 0x71, 0xb3, 0xe3, 0x21, 0x09,
	0xa2, 0xfd, 0x7d, 0x05, 0x66, 0x78, 0xbd, 0xa2, 0xc2, 0x5b, 0xa4, 0x67, 0x28, 0x75, 0xde, 0xab,
	0x2f, 0x0e, 0x7e, 0x6c, 0x3f, 0xde, 0x5e, 0x5d, 0x20, 0xa3, 0x75, 0xa8, 0x8a, 0xe5, 0x6d, 0xc8,
	0x76, 0x21, 0xbf, 0x5f, 0x42, 0x0a, 0xda, 0x0a, 0x00, 0xaf, 0x6f, 0x7b, 0xbd, 0x4d, 0x56, 0xe8,
	0x03, 0xd7, 0x0f, 0xc2, 0x15, 0x9a, 0x26, 0x12, 0x87, 0x55, 0x85, 0xe4, 0x61, 0x95, 0xf6, 0xe7,
	0x15, 0x98, 0xbd, 0xb3, 0xbd, 0xdd, 0xe2, 0x84, 0x5a, 0x46, 0x70, 0x40, 0xc3, 0xfe, 0x19, 0xc1,
	0x81, 0x58, 0x3e, 0xc9, 0x7f, 0xca, 0x50, 0x23, 0x38, 0x90, 0x02, 0xb8, 0x86, 0x69, 0xf4, 0x0e,
	0x54, 0x76, 0xd9, 0x97, 0xf2, 0x8f, 0xfa, 0xf8, 0x60, 0xee, 0x84, 0x6c, 0xe1, 0x58, 0xda, 0x3e,
	0x4c, 0xf2, 0x2c, 0xaa, 0x6b, 0x20, 0x6e, 0x1a, 0xcf, 0xeb, 0xa7, 0x6e, 0x5e, 0xab, 0x50, 0x3b,
	0x08, 0x82, 0x1e, 0x69, 0xdf, 0xb0, 0xd9, 0x91, 0xf8, 0x1c, 0x3d, 0x42, 0xd4, 0xfe, 0x97, 0x12,
	0xd6, 0xc4, 0x8d, 0x7b, 0x66, 0x2c, 0xbc, 0x67, 0xf4, 0x3b, 0x01, 0x6f, 0x13, 0xef, 0xde, 0x11,
	0x3f, 0x20, 0x81, 0x8c, 0x3e, 0x0d, 0xc5, 0xa0, 0x33, 0x6c, 0x69, 0x88, 0xba, 0x4c, 0x27, 0xa5,
	0xd1, 0x4d, 0xb1, 0xa2, 0x0c, 0x7e, 0xf4, 0x53, 0x62, 0x90, 0x58, 0x52, 0xae, 0x83, 0x6a, 0x33,
	0x68, 0xa4, 0x78, 0x33, 0x4d, 0x25, 0x05, 0xd7, 0x74, 0xa2, 0xcd, 0x79, 0x41, 0xe4, 0xa4, 0x44,
	0x03, 0x3b, 0x2a, 0x52, 0x60, 0xc7, 0x41, 0x81, 0x20, 0xe7, 0xa1, 0x8c, 0x3d, 0xcf, 0xf5, 0x78,
	0xd7, 0xb3, 0x84, 0xf6, 0x01, 0x9c, 0x5f, 0x4f, 0x47, 0xf1, 0x49, 0x3d, 0x64, 0xb8, 0x08, 0x55,
	0xd2, 0x85, 0x8e, 0x34, 0x17, 0x45, 0x9a, 0x2c, 0xa7, 0x2c, 0xdc, 0x55, 0x69, 0xc8, 0x72, 0x2a,
	0x9a, 0xce, 0xa3, 0x5d, 0x69, 0x3b, 0x30, 0x2d, 0x3a, 0x92, 0x7d, 0xd2, 0x2a, 0x54, 0xf8, 0x47,
	0xf3, 0x33, 0x88, 0x3c, 0xdf, 0xff, 0x8c, 0x26, 0xeb, 0x02, 0x95, 0x9a, 0xba, 0x89, 0xef, 0xf8,
	0x10, 0x4c, 0xdd, 0xa4, 0xb1, 0x38, 0xa6, 0xa9, 0x5b, 0xec, 0xe3, 0x4f, 0xb4, 0xf1, 0xef, 0x01,
	0xdc, 0x33, 0xf6, 0x0e, 0x0d, 0xfa, 0xb0, 0x0f, 0x7b, 0x08, 0x40, 0x44, 0xb3, 0x9f, 0xd6, 0x59,
	0x82, 0x28, 0xc1, 0x1d, 0x23, 0xc0, 0x8e, 0x69, 0xf3, 0x2d, 0xe9, 0x94, 0x1e, 0x01, 0xc8, 0x26,
	0x64, 0xcf, 0xf6, 0xfc, 0x60, 0x9d, 0x42, 0x8e, 0xdb, 0x46, 0xb7, 0xc7, 0x2f, 0x4c, 0x14, 0x3d,
	0x23, 0x47, 0xfb, 0x32, 0x20, 0x5a, 0x23, 0x37, 0xe3, 0xbf, 0x83, 0x0d, 0x0b, 0x7b, 0xe8, 0x19,
	0x98, 0xe2, 0x7e, 0x07, 0xef, 0x87, 0x9b, 0xa4, 0x69, 0x7d, 0x92, 0xc3, 0xa8, 0x80, 0x79, 0x01,
	0x66, 0x45, 0x91, 0x23, 0xc9, 0x8b, 0x68, 0x5a, 0x9f, 0xe1, 0x60, 0xf1, 0x2e, 0xc8, 0xef, 0x16,
	0x40, 0xa5, 0x55, 0x2c, 0x47, 0x1a, 0x12, 0x5a, 0xa6, 0xaf, 0xdb, 0x58, 0xfc, 0x74, 0x39, 0xdf,
	0x32, 0x26, 0xdd, 0x36, 0x9d, 0x23, 0x12, 0xee, 0x04, 0x6e, 0xcf, 0x36, 0xc5, 0xf9, 0x1d, 0x4d,
	0x20, 0x9b, 0x6c, 0x7c, 0xe9, 0x13, 0x4b, 0x4d, 0x32, 0x1f, 0x1a, 0x64, 0x4b, 0x5b, 0x1a, 0x18,
	0xfb, 0x3c, 0xd9, 0x36, 0xf1, 0x82, 0x53, 0x88, 0xcf, 0xcf, 0x91, 0x93, 0x64, 0x51, 0x5d, 0x74,
	0x0f, 0xe1, 0xee, 0x34, 0xed, 0x59, 0x06, 0x58, 0xdc, 0x83, 0x85, 0x4c, 0x22, 0x19, 0xaf, 0x3d,
	0x7d, 0x36, 0xfe, 0xda, 0xd3, 0x33, 0x83, 0x1a, 0x49, 0x69, 0xca, 0xa7, 0x1b, 0x7f, 0x06, 0x2e,
	0xae, 0x92, 0x5d, 0x75, 0xe0, 0x61, 0xa3, 0xeb, 0x4b, 0xdf, 0xe0, 0xa3, 0x1d, 0x98, 0x3b, 0x4c,
	0x7c, 0x98, 0x90, 0x66, 0x2f, 0x8c, 0xc8, 0x08, 0x3d, 0x4d, 0xe1, 0x6e, 0xa9, 0xaa, 0xa8, 0x85,
	0xbb, 0xa5, 0x6a, 0x41, 0x2d, 0x6a, 0xff, 0x51, 0x81, 0xe9, 0x96, 0xeb, 0x07, 0x64, 0xd0, 0xb3,
	0x01, 0x7b, 0x19, 0x6a, 0x34, 0x02, 0xa2, 0xa4, 0x01, 0x44, 0x00, 0x74, 0x0b, 0x6a, 0x3c, 0x26,
	0x24, 0x1f, 0x2b, 0xf9, 0xaf, 0x0b, 0x0b, 0xb2, 0x5b, 0xa2, 0xbc, 0x1e, 0xa1, 0xc6, 0x27, 0x40,
	0x71, 0xb4, 0x09, 0x50, 0xca, 0x9b, 0x00, 0xd1, 0x24, 0x2b, 0x4b, 0x93, 0x4c, 0xfb, 0xf5, 0x02,
	0x80, 0x8e, 0x2d, 0x9b, 0x7f, 0xd8, 0x5b, 0xd1, 0x2b, 0xc3, 0xca, 0xc0, 0xd7, 0xfd, 0x28, 0x4e,
	0xea, 0xa9, 0xe1, 0x3a, 0x54, 0x0e, 0xf1, 0xb1, 0xb4, 0xda, 0x8b, 0x24, 0xe5, 0x98, 0xd7, 0x77,
	0x4c, 0xea, 0xe2, 0xc6, 0xae, 0x4a, 0x22, 0x00, 0x7a, 0x00, 0x53, 0x54, 0xaa, 0x6f, 0xd3, 0x87,
	0xfe, 0x84, 0x40, 0xfe, 0xf4, 0xa0, 0xba, 0x69, 0xc1, 0xa5, 0xa6, 0x84, 0xc5, 0x1d, 0x61, 0x64,
	0x42, 0x8b, 0xfb, 0x30, 0x97, 0x2a, 0x92, 0x31, 0x38, 0xdf, 0x8c, 0x0f, 0xce, 0xe7, 0x87, 0x56,
	0xcc, 0xea, 0x92, 0x46, 0x68, 0x1f, 0x66, 0x13, 0xb9, 0xf1, 0xee, 0x53, 0x46, 0xeb, 0xbe, 0xc2,
	0xf0, 0xee, 0x2b, 0xca, 0xdd, 0xf7, 0x23, 0x0a, 0x4c, 0x93, 0x99, 0xb1, 0x6b, 0xf8, 0x98, 0xf5,
	0xe0, 0x0a, 0x51, 0x3e, 0xd9, 0xa0, 0xe2, 0x22, 0xe7, 0xb9, 0x21, 0x63, 0x8f, 0xe2, 0xdd, 0x39,
	0xa7, 0x87, 0x78, 0xe8, 0x35, 0x28, 0x7b, 0xe4, 0x63, 0x86, 0xcc, 0xd5, 0xe8, 0x83, 0xef, 0x9c,
	0xd3, 0x19, 0xc6, 0x4a, 0x0d, 0x2a, 0x16, 0xb5, 0x81, 0xf6, 0xb5, 0x2f, 0xc3, 0xbc, 0x68, 0x5a,
	0x6c, 0xc6, 0xde, 0x81, 0x29, 0x43, 0x9e, 0xac, 0xca, 0xc0, 0xe0, 0xaf, 0xb1, 0xaf, 0xd3, 0x63,
	0x98, 0x9a, 0x03, 0x2a, 0xd1, 0xb7, 0x62, 0xd4, 0xb7, 0x61, 0x1e, 0x3b, 0x56, 0xcf, 0xb5, 0x9d,
	0x20, 0x26, 0x12, 0x0a, 0x03, 0x83, 0x70, 0x10, 0x32, 0xac, 0x86, 0x4c, 0x6c, 0x26, 0x0e, 0x34,
	0x1b, 0xe6, 0x48, 0xc1, 0x1b, 0x23, 0x55, 0xa8, 0x9c, 0xa6, 0x42, 0xed, 0x47, 0x4a, 0x50, 0x0b,
	0xcb, 0x84, 0x4a, 0x71, 0x49, 0x52, 0x8a, 0xe9, 0x6b, 0xa6, 0xc1, 0x81, 0xcb, 0xbc, 0x70, 0x66,
	0x72, 0x7b, 0x89, 0x50, 0xd9, 0xa0, 0x05, 0x75, 0x8e, 0x40, 0x94, 0xa2, 0xbd, 0x7e, 0xa7, 0x43,
	0xe3, 0x76, 0x33, 0xf7, 0xa6, 0x30, 0x8d, 0xbe, 0x00, 0x0b, 0x7c, 0x01, 0xd0, 0xb1, 0xdf, 0x73,
	0x1d, 0x9f, 0xdf, 0xe6, 0xf0, 0xef, 0xf9, 0xf8, 0xb0, 0xef, 0xa1, 0x1d, 0xa6, 0x67, 0xd3, 0x40,
	0x18, 0xe6, 0x78, 0x06, 0x03, 0xd0, 0x55, 0xab, 0x30, 0xd0, 0x1b, 0x31, 0x22, 0xdc, 0x4e, 0x62,
	0xf2, 0xf7, 0x63, 0x52, 0x14, 0x17, 0x0f, 0xe1, 0x42, 0x76, 0xe1, 0x8c, 0xa9, 0xff, 0x46, 0x7c,
	0xea, 0x8f, 0xf8, 0x7d, 0x92, 0x6b, 0x60, 0x0f, 0x4a, 0xab, 0xfc, 0xa9, 0xab, 0xc7, 0xa4, 0xc4,
	0xe4, 0xca, 0xf0, 0xbb, 0xa5, 0x6a, 0x51, 0x2d, 0x69, 0x37, 0x41, 0x5d, 0xdd, 0x6c, 0x8b, 0x89,
	0xc1, 0x3e, 0xec, 0x39, 0x98, 0x24, 0x3a, 0xed, 0xd6, 0xde, 0x9e, 0x8f, 0xf9, 0x36, 0xac, 0xbc,
	0x52, 0x50, 0xcf, 0xe9, 0x32, 0x58, 0xfb, 0x69, 0x05, 0xa6, 0xc4, 0xc9, 0xca, 0xba, 0xed, 0x07,
	0xe8, 0xf3, 0x99, 0x6e, 0x88, 0x9f, 0x19, 0x72, 0x28, 0x43, 0x50, 0xcf, 0xde, 0x07, 0xf1, 0x8f,
	0x0b, 0xb0, 0x70, 0x1f, 0x7b, 0x81, 0x6d, 0x1a, 0x9d, 0x96, 0x6b, 0x2d, 0xf7, 0x03, 0xd7, 0x37,
	0x8d, 0x0e, 0xf6, 0x3e, 0x8c, 0x1b, 0xb3, 0xcc, 0x8a, 0x4f, 0x70, 0x63, 0x96, 0x4d, 0xe7, 0xe4,
	0x06, 0x95, 0x3b, 0x19, 0x4e, 0x5a, 0x9f, 0x19, 0xa7, 0xee, 0x6c, 0xc3, 0xc8, 0x6f, 0x29, 0x70,
	0x65, 0x70, 0xf1, 0x8f, 0x98, 0x3d, 0xed, 0x77, 0x14, 0xb8, 0x94, 0xdb, 0x47, 0xa4, 0x77, 0xd8,
	0xab, 0x00, 0x7c, 0x78, 0x8c, 0xd5, 0x3b, 0xdb, 0x14, 0x53, 0xe7, 0x14, 0xd0, 0x15, 0x00, 0x66,
	0x73, 0xbc, 0xc1, 0x84, 0x15, 0x3d, 0xc4, 0x88, 0x20, 0xe8, 0xbd, 0xe8, 0x01, 0x13, 0x7a, 0xf0,
	0x6a, 0x87, 0xbb, 0xe9, 0xa5, 0x61, 0xd1, 0x6f, 0x74, 0x19, 0x4f, 0x7a, 0xb2, 0x44, 0xd0, 0xd1,
	0x9a, 0xf0, 0xd4, 0x80, 0x26, 0x66, 0x5e, 0x35, 0x88, 0xeb, 0x84, 0x82, 0x74, 0x4b, 0xf4, 0xcb,
	0x05, 0xb8, 0x98, 0x53, 0x69, 0xec, 0x61, 0x62, 0x49, 0x9d, 0x8d, 0x03, 0x09, 0xd5, 0x6e, 0xf4,
	0xf9, 0xf4, 0x3f, 0x6a, 0x00, 0x74, 0x6d, 0x47, 0x04, 0xe0, 0x2a, 0x0e, 0x0c, 0xb3, 0x21, 0x4b,
	0x0e, 0x5d, 0x42, 0xa3, 0x44, 0x8c, 0x47, 0x82, 0x48, 0x69, 0x1c, 0x22, 0x21, 0x9a, 0x78, 0xe2,
	0x98, 0xda, 0x60, 0x84, 0x8f, 0x0e, 0xf1, 0x69, 0x93, 0x91, 0x23, 0x1e, 0xfe, 0x65, 0x50, 0x2e,
	0xf9, 0x26, 0x42, 0x6f, 0xda, 0x18, 0x5c, 0xfb, 0xaf, 0x4a, 0x4e, 0x1f, 0x44, 0x81, 0x86, 0xd7,
	0x0d, 0x3f, 0xd0, 0x31, 0xd1, 0x81, 0xe9, 0xab, 0x47, 0xab, 0xe2, 0x35, 0xc8, 0xa2, 0x9e, 0x95,
	0x85, 0xbe, 0x97, 0x6c, 0x28, 0x39, 0x28, 0xa6, 0x9c, 0x8c, 0x30, 0x5e, 0x64, 0x34, 0x3d, 0x49,
	0x26, 0xe1, 0xc1, 0x59, 0x1c, 0xe8, 0xc1, 0x79, 0xbf, 0xb5, 0x9c, 0x2d, 0x0a, 0x7e, 0x3b, 0x3e,
	0x58, 0xe4, 0x1a, 0x46, 0x1c, 0x2c, 0x6f, 0x84, 0xb3, 0xaf, 0x30, 0x7a, 0x7f, 0x8a, 0xe9, 0xd6,
	0x00, 0x20, 0x9d, 0xea, 0xad, 0xb8, 0x7d, 0x67, 0xbc, 0x51, 0x15, 0xa1, 0x11, 0x22, 0xfd, 0x5e,
	0x4f, 0x10, 0x19, 0x67, 0x54, 0x45, 0x68, 0xe8, 0x1e, 0xcc, 0x90, 0xfd, 0x49, 0xaf, 0x87, 0x2d,
	0x36, 0xdf, 0xb8, 0xc9, 0xe3, 0x48, 0x84, 0x12, 0xa8, 0xda, 0x3f, 0x53, 0x60, 0x4a, 0x66, 0x39,
	0x61, 0x65, 0x98, 0xd8, 0x8e, 0xe4, 0x6a, 0x1c, 0x88, 0xae, 0xd1, 0x18, 0x3f, 0x0c, 0xd0, 0x96,
	0x25, 0x6d, 0x12, 0x4c, 0xe6, 0xc0, 0x7a, 0xae, 0xc8, 0x5d, 0xcf, 0x14, 0xb9, 0x7a, 0x4c, 0xe4,
	0xea, 0xa1, 0xc8, 0xdd, 0x88, 0x8b, 0x5c, 0x9e, 0xd4, 0xfe, 0x7b, 0x01, 0x2e, 0xde, 0x71, 0x3d,
	0xfb, 0x03, 0xd2, 0xd9, 0x8f, 0x73, 0x45, 0xbe, 0x15, 0x5b, 0x91, 0x6f, 0xe4, 0x46, 0x23, 0xc9,
	0xac, 0x5a, 0x5a, 0x93, 0xd7, 0x13, 0x6b, 0xf2, 0x2b, 0x63, 0x52, 0x3a, 0xf9, 0xaa, 0xfc, 0x20,
	0x63, 0x55, 0xfe, 0xec, 0x78, 0xb5, 0x67, 0x4f, 0xc6, 0xff, 0x50, 0x80, 0xa7, 0x06, 0x7c, 0x38,
	0xf9, 0xe4, 0xd8, 0x42, 0x37, 0xe6, 0x27, 0x27, 0x96, 0xba, 0xab, 0x30, 0x49, 0x1d, 0x36, 0x63,
	0x3e, 0x3c, 0x32, 0x88, 0x96, 0x30, 0x1e, 0x25, 0xbc, 0x77, 0x64, 0x10, 0xd2, 0xa3, 0x1b, 0xbe,
	0xd2, 0xc0, 0x98, 0x16, 0x39, 0x4d, 0x62, 0x3a, 0x23, 0xed, 0xd5, 0xd0, 0x07, 0x44, 0x87, 0xea,
	0x2e, 0x3e, 0x30, 0x8e, 0x6c, 0xd7, 0xe3, 0x73, 0xf0, 0xd5, 0xf1, 0x88, 0xae, 0x70, 0x6c, 0x3d,
	0xa4, 0xa3, 0xdd, 0x86, 0xa7, 0x07, 0x32, 0x65, 0xe4, 0xc5, 0xf5, 0x67, 0x8b, 0xf0, 0xcc, 0xd0,
	0x6f, 0xc9, 0xd4, 0x9e, 0x96, 0x61, 0xc2, 0xa5, 0xf7, 0x2b, 0x7c, 0xe4, 0x7f, 0x62, 0xe0, 0x8d,
	0x1b, 0x27, 0xc6, 0x4c, 0x6f, 0x38, 0x22, 0x7a, 0x03, 0x4a, 0x3d, 0xd7, 0x12, 0x03, 0xfe, 0x85,
	0xfc, 0x88, 0x6a, 0x7e, 0x0c, 0x9d, 0x22, 0xa1, 0xdb, 0xd2, 0x85, 0x50, 0x69, 0x24, 0x93, 0x9f,
	0x18, 0x91, 0x10, 0x19, 0xed, 0x4a, 0xb1, 0x05, 0xa5, 0xe5, 0x77, 0xd0, 0x80, 0x4c, 0xa9, 0x23,
	0x31, 0xd2, 0x69, 0x72, 0xa4, 0xb1, 0xe2, 0xbd, 0x03, 0x7e, 0x75, 0x9c, 0xd7, 0xd8, 0x26, 0x2f,
	0x16, 0x6f, 0xac, 0x40, 0xd6, 0xfe, 0xb3, 0x02, 0x28, 0xcd, 0x51, 0xd4, 0xa2, 0x7e, 0x86, 0xa6,
	0x67, 0xef, 0x62, 0x8b, 0x65, 0xf3, 0x29, 0x35, 0xea, 0x3d, 0x68, 0x12, 0x7d, 0xe4, 0x65, 0x90,
	0x35, 0x23, 0x31, 0x15, 0xdf, 0xa1, 0xbb, 0x7b, 0xcf, 0x36, 0x87, 0x74, 0x2d, 0x43, 0x5e, 0xb3,
	0xb0, 0x13, 0xd8, 0x7b, 0x36, 0xf6, 0x74, 0x8e, 0xa6, 0xdd, 0x84, 0x29, 0x99, 0x70, 0xe6, 0x00,
	0xcc, 0x34, 0x27, 0xd3, 0xfe, 0x2c, 0xa8, 0x49, 0xaa, 0x99, 0x66, 0xa1, 0x3b, 0x30, 0xdd, 0x91,
	0xad, 0x04, 0x4e, 0x6a, 0x26, 0x19, 0xa7, 0xa2, 0x7d, 0x5d, 0x01, 0x35, 0x39, 0x60, 0x25, 0x76,
	0x28, 0x27, 0x62, 0xc7, 0xa9, 0x3a, 0x43, 0x7b, 0x18, 0x45, 0x54, 0x8a, 0xb5, 0x8a, 0x85, 0xc8,
	0x0b, 0x0d, 0x86, 0x38, 0x77, 0x62, 0xb0, 0xd3, 0x55, 0xfc, 0xa3, 0x0a, 0x3c, 0x3d, 0x70, 0xa6,
	0x9c, 0x79, 0x13, 0xe8, 0x53, 0x2c, 0xa2, 0x05, 0xe1, 0x53, 0x2c, 0x02, 0xa0, 0xfd, 0x90, 0x02,
	0xf3, 0x59, 0xf3, 0xed, 0x09, 0x77, 0xd8, 0x4f, 0x29, 0xf0, 0xb1, 0x21, 0x4b, 0x01, 0x35, 0x78,
	0x20, 0x90, 0x9d, 0xde, 0x90, 0x89, 0x7e, 0xa7, 0xb5, 0xdc, 0x36, 0x8d, 0x8e, 0xed, 0xec, 0x53,
	0x7b, 0x17, 0x5d, 0xa0, 0xa1, 0x55, 0xa8, 0xd1, 0xbf, 0xab, 0xee, 0x43, 0x67, 0xc8, 0xc9, 0x71,
	0x92, 0x46, 0x84, 0xa8, 0xfd, 0x8a, 0x02, 0xb3, 0x89, 0x6c, 0x1a, 0x97, 0x24, 0x30, 0x76, 0xed,
	0x8e, 0xfd, 0x01, 0x55, 0xbc, 0x1f, 0xd8, 0x8e, 0xe5, 0x3e, 0x8c, 0xbf, 0x47, 0x37, 0xa0, 0x04,
	0x19, 0x15, 0xcc, 0x42, 0x92, 0xbb, 0xb1, 0x71, 0xdf, 0x05, 0x19, 0x86, 0x1a, 0x50, 0xed, 0xc5,
	0xf7, 0xab, 0x2f, 0x0c, 0x6d, 0x3c, 0xdf, 0xa8, 0x86, 0x88, 0xda, 0x2e, 0xa8, 0xc9, 0xdc, 0xe1,
	0x92, 0x46, 0xbc, 0x3f, 0x4b, 0x23, 0x98, 0xc6, 0x5e, 0x5d, 0x64, 0xfa, 0x44, 0x1c, 0xa8, 0xfd,
	0x6c, 0x21, 0x77, 0xa9, 0x8e, 0x74, 0x5f, 0x77, 0xd7, 0xc7, 0xde, 0x11, 0xb6, 0x6e, 0x63, 0x47,
	0xdc, 0xbc, 0xb0, 0x2d, 0x58, 0x46, 0x8e, 0x30, 0x73, 0x24, 0xcd, 0x96, 0x83, 0x95, 0xc4, 0x81,
	0xe3, 0x79, 0x2b, 0x27, 0x7d, 0xd4, 0x4b, 0xd9, 0x3e, 0xea, 0xbb, 0x61, 0x30, 0x6a, 0x6e, 0xd8,
	0xc4, 0x5d, 0x3f, 0x5e, 0x3f, 0x91, 0x92, 0xc4, 0x14, 0xd6, 0x04, 0x45, 0xed, 0x77, 0x14, 0xb8,
	0x3a, 0x4c, 0xc9, 0xe4, 0x3b, 0xb9, 0xf4, 0xf6, 0xc3, 0x4c, 0x6e, 0x3f, 0xcc, 0xec, 0xed, 0x87,
	0x99, 0xde, 0x7e, 0x9c, 0xf1, 0x89, 0xcf, 0xcf, 0x15, 0xe1, 0xd9, 0x11, 0xd8, 0xf1, 0xf8, 0x34,
	0x2d, 0xbe, 0x1d, 0x38, 0xa9, 0xa6, 0xc5, 0xd0, 0x4f, 0xa9, 0x69, 0x31, 0x22, 0x67, 0xa2, 0x69,
	0x25, 0x63, 0x3a, 0x9f, 0x5e, 0xd3, 0xe2, 0x8d, 0x0d, 0x35, 0xad, 0x7f, 0x9e, 0xd4, 0xb4, 0x58,
	0x07, 0x3d, 0x7e, 0x4d, 0xab, 0x0e, 0x15, 0x3e, 0x07, 0xf8, 0x4c, 0x16, 0xc9, 0xd3, 0xab, 0x51,
	0xdd, 0x98, 0x32, 0xc2, 0x3e, 0xe0, 0xd4, 0x6b, 0x5b, 0x6e, 0x7b, 0xb5, 0xed, 0x94, 0xa6, 0xc1,
	0xaa, 0x1c, 0x65, 0x99, 0xcf, 0xa7, 0xfa, 0xfd, 0xf9, 0x5a, 0xc4, 0x63, 0x20, 0x3f, 0x44, 0x45,
	0xf8, 0x6a, 0x4a, 0x43, 0x38, 0x73, 0x2e, 0xfe, 0x63, 0x05, 0xa6, 0x37, 0x71, 0xf0, 0xd0, 0xf5,
	0x0e, 0xf9, 0x9a, 0x74, 0xaa, 0xf3, 0x89, 0x37, 0x63, 0xe7, 0x13, 0x79, 0x57, 0xf9, 0xb1, 0x0a,
	0xa5, 0x53, 0x89, 0x71, 0xcc, 0xa5, 0xbf, 0x59, 0x80, 0xb9, 0x14, 0x9d, 0xc7, 0x1d, 0x05, 0x6a,
	0x2d, 0x32, 0x56, 0x1a, 0xac, 0xb1, 0xc7, 0x5a, 0x22, 0x9b, 0x80, 0x09, 0x7c, 0x74, 0x0b, 0x26,
	0x30, 0xa3, 0x34, 0xf8, 0xc4, 0x3b, 0x46, 0xa9, 0x19, 0x11, 0xe2, 0xd8, 0x34, 0xc4, 0x24, 0xcd,
	0x23, 0xab, 0x8e, 0x60, 0x89, 0x0c, 0xd2, 0x56, 0x60, 0x3e, 0xde, 0x9c, 0x16, 0x75, 0xd9, 0x25,
	0x5c, 0x34, 0x6d, 0x4b, 0xf8, 0x6e, 0xd2, 0xff, 0xf4, 0x31, 0xc4, 0x47, 0x26, 0xee, 0x05, 0xdc,
	0x2b, 0x80, 0xa7, 0xb4, 0x1f, 0x56, 0xa0, 0x9e, 0xf7, 0x4d, 0xe8, 0xed, 0xf8, 0xdb, 0x87, 0x23,
	0xf5, 0xb2, 0xfc, 0x02, 0xe2, 0x9b, 0x50, 0xda, 0xf3, 0xdc, 0x2e, 0x67, 0xe9, 0x68, 0xe8, 0x18,
	0x7b, 0x3a, 0xc5, 0xd2, 0xbe, 0xa1, 0xc0, 0xc5, 0x1c, 0x26, 0x9d, 0xba, 0x65, 0x37, 0xa1, 0x10,
	0xb8, 0x63, 0xb7, 0xab, 0x10, 0xb8, 0xda, 0x1f, 0x25, 0x87, 0x23, 0xc9, 0x41, 0x9f, 0x23, 0x9d,
	0x65, 0x85, 0xbb, 0xbe, 0x13, 0x0e, 0x48, 0x99, 0x06, 0xfa, 0x12, 0xcc, 0x85, 0xee, 0x0d, 0xa7,
	0xdd, 0x4e, 0xa6, 0x29, 0xa1, 0x26, 0x54, 0xec, 0x1e, 0x1d, 0x2f, 0x7c, 0x19, 0xf8, 0xe4, 0x48,
	0x23, 0x9e, 0x0d, 0x31, 0x5d, 0xe0, 0xa2, 0xe7, 0x61, 0xe6, 0xc0, 0xf0, 0x5b, 0xd2, 0xb7, 0x33,
	0xa3, 0xe3, 0x04, 0x14, 0xdd, 0x80, 0xf9, 0x03, 0xc3, 0xdf, 0x4c, 0x7d, 0x10, 0xf3, 0x50, 0xce,
	0xcc, 0xd3, 0xbe, 0x94, 0xe4, 0x74, 0xd2, 0x2a, 0x52, 0xc9, 0x79, 0x1e, 0xbb, 0x20, 0x59, 0x51,
	0xd6, 0xa1, 0x82, 0x1d, 0xab, 0x15, 0xbd, 0x9a, 0x2d, 0x92, 0xda, 0x2f, 0x29, 0x00, 0x34, 0x9a,
	0x1a, 0x7d, 0x7e, 0xf2, 0x74, 0xe2, 0xf0, 0xb5, 0x98, 0x38, 0xcc, 0xbb, 0x30, 0x8f, 0x6a, 0x93,
	0x64, 0xe1, 0x15, 0x00, 0x1a, 0x3b, 0x98, 0x4d, 0x73, 0xe6, 0x95, 0x23, 0x41, 0x32, 0x65, 0xe2,
	0x16, 0xcc, 0xc4, 0x69, 0xa1, 0xb7, 0x12, 0x81, 0x8c, 0x87, 0x37, 0x61, 0x2d, 0xc0, 0x5d, 0x11,
	0xb6, 0x58, 0xfb, 0x8b, 0x13, 0x32, 0x45, 0x92, 0x95, 0xa9, 0x33, 0xae, 0x43, 0x85, 0x5b, 0xd8,
	0x0e, 0x79, 0x8f, 0x39, 0x4e, 0x6b, 0x69, 0x95, 0x21, 0xb1, 0x2b, 0x71, 0x41, 0x02, 0x19, 0xa1,
	0xb1, 0x2f, 0x37, 0xf2, 0xe3, 0x12, 0xf3, 0xb5, 0xb1, 0x88, 0x72, 0x5c, 0x46, 0x3b, 0x41, 0x10,
	0xbd, 0x0b, 0xc5, 0xae, 0xf1, 0x88, 0x9f, 0xba, 0x2e, 0x8d, 0x46, 0x77, 0xc3, 0x78, 0xc4, 0x88,
	0x11, 0x54, 0x4a, 0xc1, 0x76, 0xf8, 0x96, 0x64, 0x54, 0x0a, 0xb6, 0x23, 0x28, 0xd8, 0x0e, 0xf2,
	0x61, 0xbe, 0x6b, 0x3c, 0x62, 0x45, 0x58, 0xb3, 0x74, 0xb2, 0xe5, 0xe2, 0x47, 0xe2, 0xef, 0x8c,
	0xdc, 0xa8, 0x14, 0x05, 0x56, 0x47, 0x26, 0xf1, 0xc5, 0xd7, 0x61, 0x4a, 0x66, 0xfa, 0x58, 0x81,
	0x9d, 0x97, 0xe1, 0x7c, 0x06, 0x6f, 0xc7, 0x22, 0xf1, 0x2a, 0x54, 0x05, 0x1b, 0xc7, 0xc6, 0xe3,
	0xcc, 0x1b, 0x0b, 0xef, 0x36, 0x5c, 0xca, 0xe5, 0xd0, 0x58, 0x3e, 0xa3, 0x3f, 0x5a, 0x82, 0xa9,
	0xb6, 0xe4, 0x24, 0x79, 0x3a, 0xb1, 0x40, 0xd6, 0x70, 0xcf, 0x65, 0xf1, 0x1b, 0xb1, 0x78, 0x8b,
	0x4c, 0x06, 0xa1, 0x36, 0x40, 0xcf, 0xf0, 0x8c, 0x2e, 0x0e, 0x70, 0xf8, 0xce, 0x5d, 0xee, 0x03,
	0xb1, 0x52, 0xbb, 0x96, 0x5a, 0x21, 0x16, 0x1b, 0x06, 0x12, 0x19, 0xe6, 0xc9, 0x27, 0x87, 0xec,
	0x61, 0xfb, 0xc9, 0x38, 0x30, 0x15, 0x76, 0xa7, 0x9c, 0x11, 0x76, 0xe7, 0x06, 0xcc, 0x1b, 0x9d,
	0x8e, 0xfb, 0x90, 0x79, 0x51, 0x52, 0x87, 0xfb, 0x30, 0x86, 0x7f, 0x55, 0xcf, 0xcc, 0x43, 0x5f,
	0x80, 0x39, 0x83, 0x5d, 0x42, 0x6f, 0xbb, 0x3d, 0xb7, 0xe3, 0xee, 0xdb, 0xd8, 0xe7, 0x9e, 0xa3,
	0x9f, 0x1a, 0xe1, 0xcb, 0x22, 0x24, 0x3d, 0x4d, 0x07, 0xbd, 0x08, 0x73, 0xcc, 0x3b, 0x95, 0x3b,
	0x39, 0x49, 0xe1, 0x80, 0xd2, 0x19, 0x59, 0x0f, 0xdb, 0x2d, 0xbe, 0x05, 0xb3, 0x09, 0xde, 0x8d,
	0x15, 0x1f, 0xc0, 0x81, 0x0b, 0xd9, 0xad, 0x45, 0xdb, 0x30, 0x13, 0x3b, 0xb5, 0x15, 0xa2, 0x38,
	0xcf, 0x35, 0x85, 0xa3, 0x1e, 0xc7, 0x57, 0xed, 0x04, 0x0d, 0x6d, 0x19, 0x16, 0x32, 0x0b, 0x66,
	0x34, 0x3a, 0x7a, 0xda, 0xae, 0x20, 0x3f, 0x6d, 0x77, 0xbd, 0x09, 0x73, 0xe1, 0x56, 0xe7, 0x8e,
	0xcb, 0x4d, 0xb8, 0x55, 0x98, 0x72, 0x5c, 0x1a, 0x04, 0x8d, 0xec, 0x20, 0x2c, 0xf5, 0x1c, 0x9a,
	0x01, 0xd8, 0x33, 0xbc, 0x7d, 0x23, 0xc0, 0xcd, 0x46, 0x5b, 0x55, 0xe4, 0xf4, 0xbd, 0xb6, 0x5a,
	0xb8, 0xfe, 0x4b, 0x0a, 0x54, 0xd7, 0x0d, 0x67, 0xbf, 0xcf, 0x5e, 0x2d, 0x51, 0xd7, 0x97, 0x37,
	0x6f, 0xef, 0x2c, 0xdf, 0x6e, 0xbe, 0xbf, 0xb3, 0x79, 0x6f, 0x73, 0xeb, 0xc1, 0xa6, 0x7a, 0x0e,
	0xcd, 0xc1, 0x74, 0x08, 0xbd, 0xbb, 0x7c, 0x7f, 0x59, 0x55, 0x62, 0xa0, 0xcd, 0xad, 0xd5, 0xa6,
	0x5a, 0x40, 0xe7, 0x61, 0x36, 0x04, 0xb5, 0x3e, 0xbf, 0x7d, 0x67, 0x6b, 0x53, 0x2d, 0xc6, 0xca,
	0xe9, 0x3b, 0x2b, 0x9f, 0x57, 0x4b, 0xb1, 0x72, 0xab, 0x5b, 0xdb, 0x9b, 0xcd, 0x6d, 0xb5, 0x8c,
	0x66, 0x61, 0x32, 0x04, 0xde, 0xde, 0x52, 0x27, 0xc8, 0x87, 0x84, 0x80, 0x46, 0xab, 0xa5, 0x56,
	0x62, 0x90, 0xd6, 0x9d, 0x96, 0x5a, 0xbd, 0xfe, 0x2f, 0x8b, 0x30, 0xd7, 0x8e, 0xbc, 0x91, 0xf8,
	0x79, 0xec, 0xc7, 0xe0, 0xa9, 0x76, 0x53, 0xbf, 0xbf, 0xd6, 0x68, 0xbe, 0xbf, 0xb9, 0xbc, 0xd1,
	0x7c, 0xbf, 0xbd, 0xb5, 0xa3, 0x37, 0xe4, 0xcf, 0xd1, 0xe0, 0x4a, 0x56, 0x81, 0xd5, 0xd5, 0xf7,
	0x39, 0x58, 0x55, 0xd0, 0x73, 0x70, 0x35, 0xab, 0x4c, 0x63, 0x6b, 0x63, 0x63, 0x79, 0x73, 0xf5,
	0xfd, 0xf5, 0xb5, 0x4d, 0xf2, 0xc9, 0x39, 0x55, 0xad, 0x2f, 0xeb, 0xcb, 0xf7, 0x9b, 0xeb, 0x6a,
	0x11, 0x5d, 0x81, 0xc5, 0xac, 0x02, 0x9c, 0x3d, 0xa5, 0xbc, 0x7c, 0xc2, 0xd1, 0xbb, 0x6d, 0xb5,
	0x8c, 0xae, 0xc2, 0xe5, 0xac, 0xfc, 0xdb, 0x3b, 0x9b, 0x6b, 0x8d, 0x2d, 0x7d, 0x53, 0x9d, 0x40,
	0x4f, 0xc3, 0xa5, 0xac, 0x12, 0xfa, 0xf2, 0xda, 0x7a, 0x5b, 0xad, 0xe4, 0x55, 0xd0, 0x6e, 0xe9,
	0x6b, 0x9b, 0xb7, 0xd5, 0x6a, 0x1e, 0xfa, 0xdd, 0x95, 0xad, 0x76, 0x5b, 0xad, 0xe5, 0xa1, 0x6f,
	0x6f, 0x6d, 0x34, 0x96, 0xb7, 0x55, 0xc8, 0x6b, 0xdf, 0x83, 0xe6, 0xca, 0xfa, 0xd6, 0xed, 0xb5,
	0x86, 0x3a, 0x89, 0x9e, 0x81, 0xa7, 0x73, 0x4a, 0xb4, 0x5b, 0x77, 0x9a, 0x7a, 0x53, 0x9d, 0xba,
	0x6e, 0x4b, 0x0f, 0xc9, 0xd3, 0xb8, 0x76, 0x68, 0x12, 0x2a, 0x7d, 0xe7, 0xd0, 0x71, 0x1f, 0x3a,
	0xea, 0x39, 0x92, 0x30, 0x3d, 0x6c, 0x04, 0xd8, 0x62, 0xa3, 0x97, 0x3f, 0xcb, 0x63, 0x3b, 0xfb,
	0x6a, 0x81, 0x64, 0x7a, 0x7d, 0xc7, 0x21, 0x89, 0x22, 0x02, 0xf1, 0xe4, 0xaf, 0x5a, 0x22, 0xff,
	0xf1, 0x23, 0x9b, 0x20, 0x95, 0x51, 0x15, 0x4a, 0x16, 0x36, 0x2c, 0x75, 0xe2, 0xfa, 0xa6, 0xf4,
	0x90, 0x10, 0x7b, 0xe5, 0x8e, 0x8c, 0x50, 0x5e, 0x17, 0x03, 0xa8, 0xe7, 0xd0, 0x14, 0x54, 0xc3,
	0x2a, 0x14, 0x52, 0x05, 0x7f, 0x2a, 0x50, 0x2d, 0xa0, 0x69, 0xa8, 0x85, 0x2f, 0x07, 0xaa, 0xc5,
	0xeb, 0xb7, 0x60, 0xaa, 0xc5, 0x66, 0x3f, 0x6b, 0x78, 0x19, 0x94, 0x1d, 0xf5, 0x1c, 0xf9, 0x59,
	0x55, 0x15, 0xf2, 0xa3, 0xab, 0x05, 0xf2, 0xd3, 0x56, 0x8b, 0xe4, 0x67, 0x5b, 0x2d, 0x91, 0x9f,
	0x07, 0x6a, 0x99, 0xfc, 0x7c, 0xaf, 0x3a, 0x41, 0x7e, 0xde, 0x53, 0x2b, 0xd7, 0x35, 0xca, 0x02,
	0x07, 0x9b, 0xe1, 0x79, 0x64, 0x05, 0x8a, 0x81, 0xd9, 0x53, 0xcf, 0x91, 0x3f, 0x7d, 0xab, 0xa7,
	0x2a, 0xd7, 0xff, 0x5b, 0x11, 0xe6, 0xb7, 0x3c, 0xf3, 0x00, 0xfb, 0x01, 0x7d, 0xf3, 0x32, 0x3c,
	0xc5, 0x7a, 0x0e, 0xae, 0x66, 0xc1, 0xdf, 0xdf, 0xd9, 0x6c, 0xb7, 0x9a, 0x8d, 0xb5, 0x5b, 0x6b,
	0xcd, 0x55, 0x46, 0xa7, 0xb5, 0xb5, 0xca, 0x58, 0xa8, 0x37, 0x5b, 0xeb, 0x6b, 0x8d, 0xe5, 0x76,
	0x73, 0x9b, 0xb1, 0x50, 0x8c, 0xfb, 0x22, 0x61, 0x15, 0x9d, 0xce, 0x25, 0x02, 0x6e, 0xac, 0xef,
	0xb4, 0xb7, 0x9b, 0xba, 0x5a, 0x26, 0xc8, 0x77, 0xb7, 0x56, 0xd4, 0x09, 0x0a, 0xd5, 0xb7, 0x36,
	0x49, 0xa2, 0x42, 0x98, 0xb1, 0xba, 0xdc, 0xdc, 0xd8, 0xda, 0x24, 0x84, 0xaa, 0x64, 0x0e, 0xb7,
	0xb7, 0x97, 0xb7, 0x9b, 0xb7, 0x76, 0xd6, 0x09, 0xa0, 0x46, 0xa4, 0x49, 0xab, 0xa9, 0xb7, 0xd7,
	0xda, 0xdb, 0xcd, 0xcd, 0xed, 0xfb, 0x5b, 0xeb, 0x3b, 0x1b, 0x4d, 0x15, 0xd0, 0x25, 0x58, 0x48,
	0x42, 0x1b, 0xeb, 0xcb, 0x6b, 0x1b, 0xea, 0x24, 0xa9, 0x5d, 0xdf, 0x5a, 0x6f, 0xaa, 0x53, 0x84,
	0x16, 0xf9, 0xb7, 0xb2, 0xb6, 0xb9, 0x4a, 0x06, 0xea, 0x34, 0x01, 0xf0, 0xe6, 0xd0, 0x12, 0x33,
	0xe8, 0x02, 0x20, 0x09, 0x20, 0x0a, 0xce, 0x22, 0x04, 0x33, 0xfc, 0x73, 0x96, 0x1b, 0x8d, 0xad,
	0x9d, 0xcd, 0x6d, 0x55, 0x25, 0xad, 0x5e, 0xdb, 0xbc, 0xad, 0x37, 0xdb, 0x6d, 0x75, 0x8e, 0x7c,
	0xff, 0x6a, 0xb3, 0xb5, 0xbe, 0xf5, 0xf9, 0x8d, 0xe6, 0xe6, 0xb6, 0x8a, 0xc8, 0x57, 0x90, 0x91,
	0xd9, 0x6e, 0x2d, 0x37, 0x9a, 0xea, 0x79, 0xf2, 0xa9, 0x0d, 0x7d, 0x55, 0x9d, 0x47, 0x13, 0x50,
	0x68, 0xe8, 0xea, 0x02, 0x69, 0xef, 0xfd, 0xa6, 0xbe, 0xbd, 0xd6, 0x58, 0x5e, 0x6f, 0x6d, 0xad,
	0x2e, 0xef, 0x6c, 0x6f, 0xb5, 0x1b, 0xcb, 0xeb, 0x4d, 0x5d, 0xbd, 0x80, 0x9e, 0x82, 0x8b, 0x77,
	0xb6, 0xf4, 0xb5, 0xf7, 0xb6, 0x36, 0xb7, 0x93, 0x99, 0x17, 0xc9, 0xc0, 0xda, 0x6c, 0x6e, 0x3f,
	0xd8, 0xd2, 0xef, 0xb5, 0xb6, 0xd6, 0xd7, 0x1a, 0x9f, 0x57, 0xeb, 0xa4, 0xea, 0xf5, 0xb5, 0x8d,
	0xb5, 0x6d, 0x7d, 0x79, 0xf3, 0x76, 0x53, 0xbd, 0x44, 0x44, 0x5a, 0x7b, 0x7b, 0x4b, 0x5f, 0xbe,
	0x4d, 0x38, 0xd0, 0x6e, 0xab, 0x8b, 0x68, 0x0a, 0x2a, 0xcd, 0x46, 0x7b, 0x7b, 0xb9, 0x7d, 0x4f,
	0xfd, 0x5b, 0xca, 0xf5, 0x47, 0x50, 0xcf, 0x7b, 0xe8, 0x83, 0x30, 0x84, 0x8f, 0x5b, 0x92, 0x54,
	0xcf, 0x91, 0xef, 0x08, 0x8f, 0xa2, 0x98, 0x84, 0x8e, 0x3d, 0x35, 0xa7, 0x16, 0x08, 0xcb, 0x70,
	0xef, 0x00, 0x77, 0xb1, 0x67, 0x74, 0x22, 0x38, 0x15, 0xd2, 0x8e, 0x11, 0xd8, 0x47, 0xb8, 0x6d,
	0x5b, 0xd8, 0x34, 0x3c, 0xb5, 0x74, 0xfd, 0xbf, 0x28, 0x30, 0x97, 0xf2, 0xd8, 0x40, 0x0b, 0x11,
	0x70, 0x87, 0xd5, 0xbd, 0x45, 0x86, 0x28, 0xe9, 0x67, 0x61, 0x61, 0x4f, 0xd7, 0xb1, 0xad, 0x9e,
	0xaa, 0xc8, 0xd0, 0x35, 0xc7, 0xc7, 0x1e, 0x81, 0x16, 0x64, 0x28, 0x7b, 0xf8, 0x7c, 0xab, 0xa7,
	0x16, 0x65, 0xe8, 0x2a, 0xee, 0x60, 0x0a, 0xa5, 0x2b, 0x85, 0x80, 0x2e, 0x77, 0x02, 0xec, 0x6d,
	0xf5, 0xd4, 0xb2, 0x5c, 0xb4, 0x41, 0xc5, 0xc2, 0x56, 0x4f, 0x9d, 0x20, 0xbd, 0x1e, 0x12, 0xf0,
	0xdc, 0xde, 0x56, 0x4f, 0xad, 0x90, 0xcf, 0x15, 0xb0, 0x6d, 0xee, 0x7f, 0xb1, 0xd5, 0x53, 0xab,
	0x72, 0xd9, 0xf6, 0x81, 0xfb, 0x70, 0xab, 0xa7, 0xd6, 0xae, 0x7f, 0x0e, 0xa6, 0x64, 0x3f, 0x0f,
	0x74, 0x11, 0xce, 0xd3, 0x34, 0xff, 0x4c, 0x0e, 0x56, 0xcf, 0x91, 0x36, 0xd1, 0x8c, 0xdb, 0x38,
	0x10, 0x40, 0x25, 0x04, 0xb6, 0x23, 0x60, 0xe1, 0xfa, 0x4f, 0x96, 0x60, 0x86, 0x42, 0x99, 0x5b,
	0x06, 0x5f, 0x9d, 0x29, 0x64, 0xd3, 0xa5, 0x30, 0xf5, 0x1c, 0x19, 0x5c, 0xf1, 0x32, 0xbc, 0x42,
	0x55, 0xa1, 0x53, 0x80, 0x67, 0x35, 0x3d, 0xd2, 0x7d, 0x0b, 0x30, 0x27, 0x00, 0x0f, 0x3c, 0xd7,
	0xd9, 0xa7, 0xfd, 0x5e, 0x24, 0x9f, 0x23, 0xc0, 0x9b, 0xee, 0x72, 0x3f, 0x38, 0x50, 0x4b, 0x71,
	0x58, 0x0b, 0x7b, 0x5d, 0xb5, 0x1c, 0x56, 0xde, 0xf4, 0xbc, 0x95, 0xbe, 0x7f, 0xac, 0x4e, 0x10,
	0x56, 0x46, 0xa5, 0xda, 0xa6, 0x67, 0xf7, 0x02, 0xb5, 0x12, 0x7e, 0x4c, 0xd3, 0xf3, 0xd6, 0x5d,
	0x83, 0x28, 0x5d, 0x6a, 0x55, 0x2e, 0xaa, 0xf3, 0xb0, 0x5f, 0x6a, 0x4d, 0x6e, 0x51, 0xf3, 0x11,
	0x36, 0x97, 0x77, 0x5d, 0x2f, 0x50, 0x81, 0x30, 0x5e, 0x80, 0x37, 0x0c, 0x3f, 0xc0, 0xde, 0x2a,
	0xf9, 0xa2, 0x49, 0x99, 0xf2, 0x86, 0xed, 0x9b, 0xae, 0xb3, 0xa7, 0x4e, 0xc9, 0x34, 0x1a, 0x9e,
	0xeb, 0xfb, 0xed, 0x8e, 0x1b, 0xa8, 0xd3, 0x72, 0x85, 0xdb, 0xde, 0xf1, 0xf2, 0xbe, 0x61, 0x3b,
	0xea, 0x8c, 0xcc, 0x93, 0x65, 0xff, 0x50, 0x9d, 0x25, 0x43, 0x37, 0x24, 0xe9, 0x1e, 0x61, 0x4b,
	0x55, 0xc3, 0xae, 0x23, 0x04, 0x99, 0xf7, 0x3c, 0xad, 0x7e, 0x4e, 0x6e, 0xd6, 0xa6, 0x2b, 0xee,
	0xa9, 0x54, 0x24, 0x13, 0xdd, 0x72, 0xbb, 0xea, 0xf9, 0x38, 0x5f, 0x3e, 0xd7, 0x77, 0xbd, 0x7e,
	0x57, 0x9d, 0x97, 0x5b, 0x4f, 0xf8, 0x77, 0x0f, 0x1f, 0xab, 0x0b, 0x72, 0xeb, 0x77, 0x9c, 0xdd,
	0x8e, 0x6b, 0x1e, 0x62, 0x4b, 0xbd, 0x90, 0xea, 0xaa, 0x96, 0xe1, 0xfb, 0xea, 0x45, 0xb9, 0x05,
	0x6b, 0xce, 0x91, 0xd1, 0xb1, 0xad, 0xad, 0xdd, 0xaf, 0xa8, 0xf5, 0xeb, 0x0f, 0x00, 0xdd, 0xd9,
	0xde, 0x6e, 0x25, 0x5c, 0x08, 0xaa, 0x50, 0x5a, 0x73, 0xf6, 0x5c, 0xb6, 0x04, 0xf2, 0xb7, 0x02,
	0x54, 0x85, 0xac, 0x4e, 0x84, 0x88, 0x87, 0xcd, 0x80, 0x2d, 0x48, 0x8d, 0x8e, 0x8d, 0x9d, 0x80,
	0x8c, 0x91, 0x22, 0x49, 0x12, 0x8d, 0x08, 0xd3, 0x21, 0x53, 0xba, 0xee, 0x00, 0x44, 0x4e, 0x11,
	0x84, 0xcc, 0x4e, 0xb8, 0xac, 0x56, 0xa0, 0x78, 0x1b, 0x07, 0xaa, 0x42, 0xaa, 0x21, 0xd3, 0x41,
	0x2d, 0xd0, 0x25, 0xa2, 0x1f, 0xb0, 0x85, 0x94, 0x4d, 0x43, 0xb5, 0x44, 0xb2, 0xef, 0x90, 0xc5,
	0xb3, 0x4c, 0xd0, 0xf9, 0x06, 0x42, 0x9d, 0x40, 0x35, 0x28, 0xb7, 0x8c, 0xc0, 0x3c, 0x50, 0x2b,
	0xe4, 0xef, 0xb6, 0x67, 0x98, 0x58, 0xad, 0xae, 0x34, 0xff, 0xd5, 0xb7, 0xaf, 0x28, 0xbf, 0xf5,
	0xed, 0x2b, 0xca, 0xef, 0x7f, 0xfb, 0x8a, 0xf2, 0xf5, 0xef, 0x5c, 0x39, 0xf7, 0x5b, 0xdf, 0xb9,
	0x72, 0xee, 0x77, 0xbf, 0x73, 0xe5, 0xdc, 0x7b, 0x9f, 0xdc, 0xb7, 0x83, 0x83, 0xfe, 0xee, 0x92,
	0xe9, 0x76, 0x5f, 0x5a, 0x35, 0x02, 0x63, 0xd5, 0xdd, 0x7f, 0x89, 0x2a, 0xcc, 0x9f, 0xea, 0x19,
	0xc7, 0x1d, 0xd7, 0xb0, 0x5e, 0x3a, 0xfa, 0xcc, 0x4b, 0x5c, 0x93, 0xde, 0x9d, 0xa0, 0x67, 0x3f,
	0x9f, 0xfe, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x85, 0x87, 0x6f, 0xc8, 0xba, 0xed, 0x00, 0x00,
}

func (m *ResCollector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResCollector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResCollector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResCollector_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResCollector_Header) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResCollector_Header) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x20
	}
	return len(dAtA) - i, nil
}

func (m *CollectorProc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorProc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorProc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size := m.Hints.Size()
			i -= size
			if _, err := m.Hints.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.ContainerHostType != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerHostType))
		i--
		dAtA[i] = 0x60
	}
	if len(m.NetworkId) > 0 {
		i -= len(m.NetworkId)
		copy(dAtA[i:], m.NetworkId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.NetworkId)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Containers) > 0 {
		for iNdEx := len(m.Containers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Containers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x38
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x30
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Processes) > 0 {
		for iNdEx := len(m.Processes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Processes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *CollectorProc_HintMask) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorProc_HintMask) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintAgent(dAtA, i, uint64(m.HintMask))
	i--
	dAtA[i] = 0x70
	return len(dAtA) - i, nil
}
func (m *CollectorProcDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorProcDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorProcDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ProcessDiscoveries) > 0 {
		for iNdEx := len(m.ProcessDiscoveries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ProcessDiscoveries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x18
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorRealTime) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorRealTime) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorRealTime) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ContainerHostType != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerHostType))
		i--
		dAtA[i] = 0x58
	}
	if len(m.ContainerStats) > 0 {
		for iNdEx := len(m.ContainerStats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ContainerStats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.TotalMemory != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TotalMemory))
		i--
		dAtA[i] = 0x48
	}
	if m.NumCpus != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumCpus))
		i--
		dAtA[i] = 0x40
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x38
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x30
	}
	if m.OrgId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.OrgId))
		i--
		dAtA[i] = 0x28
	}
	if m.HostId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.HostId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Stats) > 0 {
		for iNdEx := len(m.Stats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Stats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *CollectorContainer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorContainer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorContainer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NetworkId) > 0 {
		i -= len(m.NetworkId)
		copy(dAtA[i:], m.NetworkId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.NetworkId)))
		i--
		dAtA[i] = 0x5a
	}
	if m.ContainerHostType != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerHostType))
		i--
		dAtA[i] = 0x48
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x28
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Containers) > 0 {
		for iNdEx := len(m.Containers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Containers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorContainerRealTime) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorContainerRealTime) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorContainerRealTime) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ContainerHostType != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerHostType))
		i--
		dAtA[i] = 0x40
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x38
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x30
	}
	if m.HostId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.HostId))
		i--
		dAtA[i] = 0x28
	}
	if m.TotalMemory != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TotalMemory))
		i--
		dAtA[i] = 0x20
	}
	if m.NumCpus != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumCpus))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Stats) > 0 {
		for iNdEx := len(m.Stats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Stats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorReqStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorReqStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorReqStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *CollectorECSTask) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorECSTask) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorECSTask) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x52
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Tasks) > 0 {
		for iNdEx := len(m.Tasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x30
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Region) > 0 {
		i -= len(m.Region)
		copy(dAtA[i:], m.Region)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Region)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x12
	}
	if m.AwsAccountID != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.AwsAccountID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ECSTask) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECSTask) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECSTask) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerInstanceArn) > 0 {
		i -= len(m.ContainerInstanceArn)
		copy(dAtA[i:], m.ContainerInstanceArn)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerInstanceArn)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.ContainerInstanceTags) > 0 {
		for iNdEx := len(m.ContainerInstanceTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ContainerInstanceTags[iNdEx])
			copy(dAtA[i:], m.ContainerInstanceTags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerInstanceTags[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x9a
		}
	}
	if len(m.EcsTags) > 0 {
		for iNdEx := len(m.EcsTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EcsTags[iNdEx])
			copy(dAtA[i:], m.EcsTags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.EcsTags[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x8a
		}
	}
	if len(m.Containers) > 0 {
		for iNdEx := len(m.Containers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Containers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x82
		}
	}
	if m.ExecutionStoppedAt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ExecutionStoppedAt))
		i--
		dAtA[i] = 0x78
	}
	if m.PullStoppedAt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.PullStoppedAt))
		i--
		dAtA[i] = 0x70
	}
	if m.PullStartedAt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.PullStartedAt))
		i--
		dAtA[i] = 0x68
	}
	if len(m.VpcId) > 0 {
		i -= len(m.VpcId)
		copy(dAtA[i:], m.VpcId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VpcId)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.ServiceName) > 0 {
		i -= len(m.ServiceName)
		copy(dAtA[i:], m.ServiceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ServiceName)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.EphemeralStorageMetrics) > 0 {
		for k := range m.EphemeralStorageMetrics {
			v := m.EphemeralStorageMetrics[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.Limits) > 0 {
		for k := range m.Limits {
			v := m.Limits[k]
			baseI := i
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i--
			dAtA[i] = 0x11
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.AvailabilityZone) > 0 {
		i -= len(m.AvailabilityZone)
		copy(dAtA[i:], m.AvailabilityZone)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.AvailabilityZone)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Family) > 0 {
		i -= len(m.Family)
		copy(dAtA[i:], m.Family)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Family)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.KnownStatus) > 0 {
		i -= len(m.KnownStatus)
		copy(dAtA[i:], m.KnownStatus)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KnownStatus)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.DesiredStatus) > 0 {
		i -= len(m.DesiredStatus)
		copy(dAtA[i:], m.DesiredStatus)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DesiredStatus)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.LaunchType) > 0 {
		i -= len(m.LaunchType)
		copy(dAtA[i:], m.LaunchType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.LaunchType)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ResourceVersion) > 0 {
		i -= len(m.ResourceVersion)
		copy(dAtA[i:], m.ResourceVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceVersion)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Arn) > 0 {
		i -= len(m.Arn)
		copy(dAtA[i:], m.Arn)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Arn)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ECSContainer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECSContainer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECSContainer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Snapshotter) > 0 {
		i -= len(m.Snapshotter)
		copy(dAtA[i:], m.Snapshotter)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Snapshotter)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if len(m.Limits) > 0 {
		for k := range m.Limits {
			v := m.Limits[k]
			baseI := i
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i--
			dAtA[i] = 0x11
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xaa
		}
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Labels[iNdEx])
			copy(dAtA[i:], m.Labels[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Labels[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.Health != nil {
		{
			size, err := m.Health.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.Volumes) > 0 {
		for iNdEx := len(m.Volumes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Volumes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.Networks) > 0 {
		for iNdEx := len(m.Networks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Networks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x8a
		}
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.ContainerArn) > 0 {
		i -= len(m.ContainerArn)
		copy(dAtA[i:], m.ContainerArn)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerArn)))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.LogOptions) > 0 {
		for k := range m.LogOptions {
			v := m.LogOptions[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.LogDriver) > 0 {
		i -= len(m.LogDriver)
		copy(dAtA[i:], m.LogDriver)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.LogDriver)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x62
	}
	if m.ExitCode != nil {
		{
			size, err := m.ExitCode.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.KnownStatus) > 0 {
		i -= len(m.KnownStatus)
		copy(dAtA[i:], m.KnownStatus)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KnownStatus)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.DesiredStatus) > 0 {
		i -= len(m.DesiredStatus)
		copy(dAtA[i:], m.DesiredStatus)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DesiredStatus)))
		i--
		dAtA[i] = 0x4a
	}
	if m.FinishedAt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.FinishedAt))
		i--
		dAtA[i] = 0x40
	}
	if m.StartedAt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.StartedAt))
		i--
		dAtA[i] = 0x38
	}
	if m.CreatedAt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CreatedAt))
		i--
		dAtA[i] = 0x30
	}
	if len(m.ImageID) > 0 {
		i -= len(m.ImageID)
		copy(dAtA[i:], m.ImageID)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ImageID)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Image) > 0 {
		i -= len(m.Image)
		copy(dAtA[i:], m.Image)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Image)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DockerName) > 0 {
		i -= len(m.DockerName)
		copy(dAtA[i:], m.DockerName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DockerName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DockerID) > 0 {
		i -= len(m.DockerID)
		copy(dAtA[i:], m.DockerID)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DockerID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ECSContainerNetwork) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECSContainerNetwork) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECSContainerNetwork) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ipv6Addresses) > 0 {
		for iNdEx := len(m.Ipv6Addresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ipv6Addresses[iNdEx])
			copy(dAtA[i:], m.Ipv6Addresses[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Ipv6Addresses[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Ipv4Addresses) > 0 {
		for iNdEx := len(m.Ipv4Addresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ipv4Addresses[iNdEx])
			copy(dAtA[i:], m.Ipv4Addresses[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Ipv4Addresses[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.NetworkMode) > 0 {
		i -= len(m.NetworkMode)
		copy(dAtA[i:], m.NetworkMode)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.NetworkMode)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ECSContainerPort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECSContainerPort) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECSContainerPort) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HostPort != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.HostPort))
		i--
		dAtA[i] = 0x20
	}
	if len(m.HostIp) > 0 {
		i -= len(m.HostIp)
		copy(dAtA[i:], m.HostIp)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostIp)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x12
	}
	if m.ContainerPort != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerPort))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ECSContainerVolume) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECSContainerVolume) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECSContainerVolume) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Destination) > 0 {
		i -= len(m.Destination)
		copy(dAtA[i:], m.Destination)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Destination)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DockerName) > 0 {
		i -= len(m.DockerName)
		copy(dAtA[i:], m.DockerName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DockerName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ECSContainerHealth) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECSContainerHealth) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECSContainerHealth) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Output) > 0 {
		i -= len(m.Output)
		copy(dAtA[i:], m.Output)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Output)))
		i--
		dAtA[i] = 0x22
	}
	if m.ExitCode != nil {
		{
			size, err := m.ExitCode.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Since != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Since))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ECSContainerExitCode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECSContainerExitCode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECSContainerExitCode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExitCode != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ExitCode))
		i--
		dAtA[i] = 0x18
	}
	return len(dAtA) - i, nil
}

func (m *CollectorPod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorPod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorPod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.IsTerminated {
		i--
		if m.IsTerminated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Pods) > 0 {
		for iNdEx := len(m.Pods) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Pods[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x28
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorPodDisruptionBudget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorPodDisruptionBudget) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorPodDisruptionBudget) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.PodDisruptionBudgets) > 0 {
		for iNdEx := len(m.PodDisruptionBudgets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PodDisruptionBudgets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorReplicaSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorReplicaSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorReplicaSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ReplicaSets) > 0 {
		for iNdEx := len(m.ReplicaSets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicaSets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorDeployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorDeployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorDeployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Deployments) > 0 {
		for iNdEx := len(m.Deployments) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Deployments[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorService) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorService) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Services) > 0 {
		for iNdEx := len(m.Services) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Services[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorNode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorNode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.HostAliasMapping) > 0 {
		for k := range m.HostAliasMapping {
			v := m.HostAliasMapping[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintAgent(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Nodes) > 0 {
		for iNdEx := len(m.Nodes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Nodes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorCluster) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorCluster) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Cluster != nil {
		{
			size, err := m.Cluster.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorManifest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorManifest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorManifest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Manifests) > 0 {
		for iNdEx := len(m.Manifests) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Manifests[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorManifestCRD) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorManifestCRD) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorManifestCRD) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Manifest != nil {
		{
			size, err := m.Manifest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorManifestCR) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorManifestCR) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorManifestCR) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Manifest != nil {
		{
			size, err := m.Manifest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorNamespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorNamespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorNamespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Namespaces) > 0 {
		for iNdEx := len(m.Namespaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Namespaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorJob) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorJob) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorJob) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Jobs) > 0 {
		for iNdEx := len(m.Jobs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Jobs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorCronJob) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorCronJob) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorCronJob) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.CronJobs) > 0 {
		for iNdEx := len(m.CronJobs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CronJobs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorDaemonSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorDaemonSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorDaemonSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.DaemonSets) > 0 {
		for iNdEx := len(m.DaemonSets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DaemonSets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorStatefulSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorStatefulSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorStatefulSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.StatefulSets) > 0 {
		for iNdEx := len(m.StatefulSets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StatefulSets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorPersistentVolume) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorPersistentVolume) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorPersistentVolume) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.PersistentVolumes) > 0 {
		for iNdEx := len(m.PersistentVolumes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PersistentVolumes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorPersistentVolumeClaim) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorPersistentVolumeClaim) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorPersistentVolumeClaim) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.PersistentVolumeClaims) > 0 {
		for iNdEx := len(m.PersistentVolumeClaims) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PersistentVolumeClaims[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorRole) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorRole) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorRole) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Roles) > 0 {
		for iNdEx := len(m.Roles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Roles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorRoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorRoleBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorRoleBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.RoleBindings) > 0 {
		for iNdEx := len(m.RoleBindings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.RoleBindings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorClusterRole) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorClusterRole) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorClusterRole) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ClusterRoles) > 0 {
		for iNdEx := len(m.ClusterRoles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ClusterRoles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorClusterRoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorClusterRoleBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorClusterRoleBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ClusterRoleBindings) > 0 {
		for iNdEx := len(m.ClusterRoleBindings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ClusterRoleBindings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorServiceAccount) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorServiceAccount) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorServiceAccount) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ServiceAccounts) > 0 {
		for iNdEx := len(m.ServiceAccounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ServiceAccounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorIngress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorIngress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorIngress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Ingresses) > 0 {
		for iNdEx := len(m.Ingresses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ingresses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorVerticalPodAutoscaler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorVerticalPodAutoscaler) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorVerticalPodAutoscaler) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.VerticalPodAutoscalers) > 0 {
		for iNdEx := len(m.VerticalPodAutoscalers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VerticalPodAutoscalers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorHorizontalPodAutoscaler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorHorizontalPodAutoscaler) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorHorizontalPodAutoscaler) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.HorizontalPodAutoscalers) > 0 {
		for iNdEx := len(m.HorizontalPodAutoscalers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HorizontalPodAutoscalers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorNetworkPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorNetworkPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorNetworkPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.NetworkPolicies) > 0 {
		for iNdEx := len(m.NetworkPolicies) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NetworkPolicies[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorLimitRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorLimitRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorLimitRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.LimitRanges) > 0 {
		for iNdEx := len(m.LimitRanges) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LimitRanges[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CollectorStorageClass) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorStorageClass) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorStorageClass) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AgentVersion != nil {
		{
			size, err := m.AgentVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.StorageClasses) > 0 {
		for iNdEx := len(m.StorageClasses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StorageClasses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x20
	}
	if m.GroupId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AgentVersion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentVersion) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AgentVersion) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Commit) > 0 {
		i -= len(m.Commit)
		copy(dAtA[i:], m.Commit)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Commit)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Meta) > 0 {
		i -= len(m.Meta)
		copy(dAtA[i:], m.Meta)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Meta)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Pre) > 0 {
		i -= len(m.Pre)
		copy(dAtA[i:], m.Pre)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Pre)))
		i--
		dAtA[i] = 0x22
	}
	if m.Patch != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Patch))
		i--
		dAtA[i] = 0x18
	}
	if m.Minor != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Minor))
		i--
		dAtA[i] = 0x10
	}
	if m.Major != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Major))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CollectorStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Interval != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Interval))
		i--
		dAtA[i] = 0x10
	}
	if m.ActiveClients != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ActiveClients))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TracerMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TracerMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TracerMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ServiceName) > 0 {
		i -= len(m.ServiceName)
		copy(dAtA[i:], m.ServiceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ServiceName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.RuntimeId) > 0 {
		i -= len(m.RuntimeId)
		copy(dAtA[i:], m.RuntimeId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.RuntimeId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PortInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Udp) > 0 {
		dAtA48 := make([]byte, len(m.Udp)*10)
		var j47 int
		for _, num1 := range m.Udp {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA48[j47] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j47++
			}
			dAtA48[j47] = uint8(num)
			j47++
		}
		i -= j47
		copy(dAtA[i:], dAtA48[:j47])
		i = encodeVarintAgent(dAtA, i, uint64(j47))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tcp) > 0 {
		dAtA50 := make([]byte, len(m.Tcp)*10)
		var j49 int
		for _, num1 := range m.Tcp {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA50[j49] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j49++
			}
			dAtA50[j49] = uint8(num)
			j49++
		}
		i -= j49
		copy(dAtA[i:], dAtA50[:j49])
		i = encodeVarintAgent(dAtA, i, uint64(j49))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Process) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Process) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Process) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ServiceDiscovery != nil {
		{
			size, err := m.ServiceDiscovery.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if m.PortInfo != nil {
		{
			size, err := m.PortInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if m.Language != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Language))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xba
		}
	}
	if len(m.ProcessContext) > 0 {
		for iNdEx := len(m.ProcessContext) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ProcessContext[iNdEx])
			copy(dAtA[i:], m.ProcessContext[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.ProcessContext[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xb2
		}
	}
	if m.Networks != nil {
		{
			size, err := m.Networks.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.NsPid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NsPid))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.ContainerByteKey) > 0 {
		i -= len(m.ContainerByteKey)
		copy(dAtA[i:], m.ContainerByteKey)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerByteKey)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.ByteKey) > 0 {
		i -= len(m.ByteKey)
		copy(dAtA[i:], m.ByteKey)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ByteKey)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.InvoluntaryCtxSwitches != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.InvoluntaryCtxSwitches))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.VoluntaryCtxSwitches != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.VoluntaryCtxSwitches))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.ContainerKey != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerKey))
		i--
		dAtA[i] = 0x78
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x72
	}
	if m.IoStat != nil {
		{
			size, err := m.IoStat.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.State != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x60
	}
	if m.OpenFdCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.OpenFdCount))
		i--
		dAtA[i] = 0x58
	}
	if m.Container != nil {
		{
			size, err := m.Container.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.CreateTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CreateTime))
		i--
		dAtA[i] = 0x48
	}
	if m.Cpu != nil {
		{
			size, err := m.Cpu.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.Memory != nil {
		{
			size, err := m.Memory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.User != nil {
		{
			size, err := m.User.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Command != nil {
		{
			size, err := m.Command.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Pid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x10
	}
	if m.Key != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Key))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ServiceDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ApmInstrumentation {
		i--
		if m.ApmInstrumentation {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.TracerMetadata) > 0 {
		for iNdEx := len(m.TracerMetadata) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TracerMetadata[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.AdditionalGeneratedNames) > 0 {
		for iNdEx := len(m.AdditionalGeneratedNames) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AdditionalGeneratedNames[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.DdServiceName != nil {
		{
			size, err := m.DdServiceName.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.GeneratedServiceName != nil {
		{
			size, err := m.GeneratedServiceName.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceName) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceName) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceName) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Source != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Source))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ByteKey) > 0 {
		i -= len(m.ByteKey)
		copy(dAtA[i:], m.ByteKey)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ByteKey)))
		i--
		dAtA[i] = 0x3a
	}
	if m.CreateTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CreateTime))
		i--
		dAtA[i] = 0x30
	}
	if m.User != nil {
		{
			size, err := m.User.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Command != nil {
		{
			size, err := m.Command.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.NsPid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NsPid))
		i--
		dAtA[i] = 0x10
	}
	if m.Pid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Command) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Command) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Command) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Comm) > 0 {
		i -= len(m.Comm)
		copy(dAtA[i:], m.Comm)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Comm)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Exe) > 0 {
		i -= len(m.Exe)
		copy(dAtA[i:], m.Exe)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Exe)))
		i--
		dAtA[i] = 0x42
	}
	if m.Pgroup != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Pgroup))
		i--
		dAtA[i] = 0x38
	}
	if m.Ppid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Ppid))
		i--
		dAtA[i] = 0x30
	}
	if m.OnDisk {
		i--
		if m.OnDisk {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Root) > 0 {
		i -= len(m.Root)
		copy(dAtA[i:], m.Root)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Root)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Cwd) > 0 {
		i -= len(m.Cwd)
		copy(dAtA[i:], m.Cwd)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Cwd)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Args[iNdEx])
			copy(dAtA[i:], m.Args[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Args[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProcessUser) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessUser) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessUser) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Sgid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Sgid))
		i--
		dAtA[i] = 0x38
	}
	if m.Suid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Suid))
		i--
		dAtA[i] = 0x30
	}
	if m.Egid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Egid))
		i--
		dAtA[i] = 0x28
	}
	if m.Euid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Euid))
		i--
		dAtA[i] = 0x20
	}
	if m.Gid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Gid))
		i--
		dAtA[i] = 0x18
	}
	if m.Uid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Uid))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessNetworks) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessNetworks) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessNetworks) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.BytesRate != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.BytesRate))))
		i--
		dAtA[i] = 0x15
	}
	if m.ConnectionRate != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ConnectionRate))))
		i--
		dAtA[i] = 0xd
	}
	return len(dAtA) - i, nil
}

func (m *ContainerAddr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerAddr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerAddr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Protocol != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x18
	}
	if m.Port != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Ip) > 0 {
		i -= len(m.Ip)
		copy(dAtA[i:], m.Ip)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Ip)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Container) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Container) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Container) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RepoDigest) > 0 {
		i -= len(m.RepoDigest)
		copy(dAtA[i:], m.RepoDigest)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.RepoDigest)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if m.MemoryRequest != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemoryRequest))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x90
	}
	if m.CpuRequest != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.CpuRequest))))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x8d
	}
	if m.MemAccounted != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemAccounted))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x80
	}
	if m.CpuUsageNs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.CpuUsageNs))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfd
	}
	if m.MemUsage != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemUsage))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf0
	}
	if m.ThreadLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ThreadLimit))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe8
	}
	if m.ThreadCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ThreadCount))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe0
	}
	if len(m.Addresses) > 0 {
		for iNdEx := len(m.Addresses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Addresses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xda
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xd2
		}
	}
	if len(m.ByteKey) > 0 {
		i -= len(m.ByteKey)
		copy(dAtA[i:], m.ByteKey)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ByteKey)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if m.Started != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Started))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if m.MemCache != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemCache))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.MemRss != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemRss))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.TotalPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TotalPct))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa5
	}
	if m.SystemPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.SystemPct))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9d
	}
	if m.UserPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.UserPct))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x95
	}
	if m.NetSentBps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetSentBps))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8d
	}
	if m.NetRcvdBps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetRcvdBps))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x85
	}
	if m.NetSentPs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetSentPs))))
		i--
		dAtA[i] = 0x7d
	}
	if m.NetRcvdPs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetRcvdPs))))
		i--
		dAtA[i] = 0x75
	}
	if m.Key != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Key))
		i--
		dAtA[i] = 0x68
	}
	if m.Wbps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Wbps))))
		i--
		dAtA[i] = 0x65
	}
	if m.Rbps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Rbps))))
		i--
		dAtA[i] = 0x5d
	}
	if m.Created != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Created))
		i--
		dAtA[i] = 0x50
	}
	if m.Health != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Health))
		i--
		dAtA[i] = 0x48
	}
	if m.State != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x40
	}
	if m.MemoryLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemoryLimit))
		i--
		dAtA[i] = 0x30
	}
	if m.CpuLimit != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.CpuLimit))))
		i--
		dAtA[i] = 0x2d
	}
	if len(m.Image) > 0 {
		i -= len(m.Image)
		copy(dAtA[i:], m.Image)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Image)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessStat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessStat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Networks != nil {
		{
			size, err := m.Networks.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if len(m.ContainerByteKey) > 0 {
		i -= len(m.ContainerByteKey)
		copy(dAtA[i:], m.ContainerByteKey)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerByteKey)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if len(m.ByteKey) > 0 {
		i -= len(m.ByteKey)
		copy(dAtA[i:], m.ByteKey)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ByteKey)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if m.InvoluntaryCtxSwitches != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.InvoluntaryCtxSwitches))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if m.VoluntaryCtxSwitches != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.VoluntaryCtxSwitches))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.ContainerNetSentBps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ContainerNetSentBps))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xbd
	}
	if m.ContainerNetRcvdBps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ContainerNetRcvdBps))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb5
	}
	if m.ContainerNetSentPs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ContainerNetSentPs))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xad
	}
	if m.ContainerNetRcvdPs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ContainerNetRcvdPs))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa5
	}
	if m.IoStat != nil {
		{
			size, err := m.IoStat.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if m.ContainerKey != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerKey))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.ContainerWbps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ContainerWbps))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8d
	}
	if m.ContainerRbps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ContainerRbps))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x85
	}
	if m.ContainerHealth != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerHealth))
		i--
		dAtA[i] = 0x78
	}
	if m.ProcessState != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ProcessState))
		i--
		dAtA[i] = 0x60
	}
	if m.ContainerState != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerState))
		i--
		dAtA[i] = 0x58
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x52
	}
	if m.Key != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Key))
		i--
		dAtA[i] = 0x48
	}
	if m.OpenFdCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.OpenFdCount))
		i--
		dAtA[i] = 0x40
	}
	if m.Threads != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Threads))
		i--
		dAtA[i] = 0x38
	}
	if m.Nice != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Nice))
		i--
		dAtA[i] = 0x28
	}
	if m.Cpu != nil {
		{
			size, err := m.Cpu.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Memory != nil {
		{
			size, err := m.Memory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.CreateTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CreateTime))
		i--
		dAtA[i] = 0x10
	}
	if m.Pid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProcStatsWithPerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcStatsWithPerm) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcStatsWithPerm) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WriteBytes != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.WriteBytes))
		i--
		dAtA[i] = 0x28
	}
	if m.ReadBytes != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ReadBytes))
		i--
		dAtA[i] = 0x20
	}
	if m.WriteCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.WriteCount))
		i--
		dAtA[i] = 0x18
	}
	if m.ReadCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ReadCount))
		i--
		dAtA[i] = 0x10
	}
	if m.OpenFDCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.OpenFDCount))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProcStatsWithPermByPID) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcStatsWithPermByPID) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcStatsWithPermByPID) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.StatsByPID) > 0 {
		for k := range m.StatsByPID {
			v := m.StatsByPID[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintAgent(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintAgent(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MemoryRequest != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemoryRequest))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.CpuRequest != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.CpuRequest))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xcd
	}
	if m.MemAccounted != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemAccounted))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.CpuUsageNs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.CpuUsageNs))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xbd
	}
	if m.MemUsage != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemUsage))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.ThreadLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ThreadLimit))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.ThreadCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ThreadCount))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.ByteKey) > 0 {
		i -= len(m.ByteKey)
		copy(dAtA[i:], m.ByteKey)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ByteKey)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if m.Started != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Started))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.Key != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Key))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.Health != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Health))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.State != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x78
	}
	if m.NetSentBps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetSentBps))))
		i--
		dAtA[i] = 0x75
	}
	if m.NetRcvdBps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetRcvdBps))))
		i--
		dAtA[i] = 0x6d
	}
	if m.NetSentPs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetSentPs))))
		i--
		dAtA[i] = 0x65
	}
	if m.NetRcvdPs != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.NetRcvdPs))))
		i--
		dAtA[i] = 0x5d
	}
	if m.Wbps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Wbps))))
		i--
		dAtA[i] = 0x55
	}
	if m.Rbps != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Rbps))))
		i--
		dAtA[i] = 0x4d
	}
	if m.MemLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemLimit))
		i--
		dAtA[i] = 0x40
	}
	if m.MemCache != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemCache))
		i--
		dAtA[i] = 0x38
	}
	if m.MemRss != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemRss))
		i--
		dAtA[i] = 0x30
	}
	if m.CpuLimit != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.CpuLimit))))
		i--
		dAtA[i] = 0x2d
	}
	if m.TotalPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TotalPct))))
		i--
		dAtA[i] = 0x25
	}
	if m.SystemPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.SystemPct))))
		i--
		dAtA[i] = 0x1d
	}
	if m.UserPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.UserPct))))
		i--
		dAtA[i] = 0x15
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SystemInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SystemInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TotalMemory != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TotalMemory))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Cpus) > 0 {
		for iNdEx := len(m.Cpus) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Cpus[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Os != nil {
		{
			size, err := m.Os.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Uuid) > 0 {
		i -= len(m.Uuid)
		copy(dAtA[i:], m.Uuid)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Uuid)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OSInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OSInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OSInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.KernelVersion) > 0 {
		i -= len(m.KernelVersion)
		copy(dAtA[i:], m.KernelVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KernelVersion)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Family) > 0 {
		i -= len(m.Family)
		copy(dAtA[i:], m.Family)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Family)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Platform) > 0 {
		i -= len(m.Platform)
		copy(dAtA[i:], m.Platform)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Platform)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IOStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IOStat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IOStat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WriteBytesRate != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.WriteBytesRate))))
		i--
		dAtA[i] = 0x25
	}
	if m.ReadBytesRate != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ReadBytesRate))))
		i--
		dAtA[i] = 0x1d
	}
	if m.WriteRate != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.WriteRate))))
		i--
		dAtA[i] = 0x15
	}
	if m.ReadRate != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ReadRate))))
		i--
		dAtA[i] = 0xd
	}
	return len(dAtA) - i, nil
}

func (m *MemoryStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemoryStat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemoryStat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Dirty != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Dirty))
		i--
		dAtA[i] = 0x40
	}
	if m.Data != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Data))
		i--
		dAtA[i] = 0x38
	}
	if m.Lib != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Lib))
		i--
		dAtA[i] = 0x30
	}
	if m.Text != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Text))
		i--
		dAtA[i] = 0x28
	}
	if m.Shared != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Shared))
		i--
		dAtA[i] = 0x20
	}
	if m.Swap != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Swap))
		i--
		dAtA[i] = 0x18
	}
	if m.Vms != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Vms))
		i--
		dAtA[i] = 0x10
	}
	if m.Rss != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Rss))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CPUStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CPUStat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CPUStat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SystemTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.SystemTime))
		i--
		dAtA[i] = 0x48
	}
	if m.UserTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.UserTime))
		i--
		dAtA[i] = 0x40
	}
	if m.Nice != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Nice))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Cpus) > 0 {
		for iNdEx := len(m.Cpus) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Cpus[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.NumThreads != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumThreads))
		i--
		dAtA[i] = 0x28
	}
	if m.SystemPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.SystemPct))))
		i--
		dAtA[i] = 0x25
	}
	if m.UserPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.UserPct))))
		i--
		dAtA[i] = 0x1d
	}
	if m.TotalPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TotalPct))))
		i--
		dAtA[i] = 0x15
	}
	if len(m.LastCpu) > 0 {
		i -= len(m.LastCpu)
		copy(dAtA[i:], m.LastCpu)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.LastCpu)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SingleCPUStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SingleCPUStat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SingleCPUStat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TotalPct != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TotalPct))))
		i--
		dAtA[i] = 0x15
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CPUInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CPUInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CPUInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CacheSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CacheSize))
		i--
		dAtA[i] = 0x48
	}
	if m.Mhz != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Mhz))
		i--
		dAtA[i] = 0x40
	}
	if m.Cores != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Cores))
		i--
		dAtA[i] = 0x38
	}
	if len(m.CoreId) > 0 {
		i -= len(m.CoreId)
		copy(dAtA[i:], m.CoreId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.CoreId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.PhysicalId) > 0 {
		i -= len(m.PhysicalId)
		copy(dAtA[i:], m.PhysicalId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PhysicalId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Model) > 0 {
		i -= len(m.Model)
		copy(dAtA[i:], m.Model)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Model)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Family) > 0 {
		i -= len(m.Family)
		copy(dAtA[i:], m.Family)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Family)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Vendor) > 0 {
		i -= len(m.Vendor)
		copy(dAtA[i:], m.Vendor)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Vendor)))
		i--
		dAtA[i] = 0x12
	}
	if m.Number != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Number))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Host) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Host) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Host) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TagsModified != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TagsModified))
		i--
		dAtA[i] = 0x50
	}
	if m.TagIndex != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TagIndex))
		i--
		dAtA[i] = 0x48
	}
	if m.TotalMemory != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TotalMemory))
		i--
		dAtA[i] = 0x40
	}
	if m.NumCpus != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumCpus))
		i--
		dAtA[i] = 0x38
	}
	if len(m.AllTags) > 0 {
		for iNdEx := len(m.AllTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AllTags[iNdEx])
			copy(dAtA[i:], m.AllTags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.AllTags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if m.OrgId != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.OrgId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Cluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Cluster) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NodesInfo) > 0 {
		for iNdEx := len(m.NodesInfo) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NodesInfo[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.ExtendedResourcesCapacity) > 0 {
		for k := range m.ExtendedResourcesCapacity {
			v := m.ExtendedResourcesCapacity[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x7a
		}
	}
	if len(m.ExtendedResourcesAllocatable) > 0 {
		for k := range m.ExtendedResourcesAllocatable {
			v := m.ExtendedResourcesAllocatable[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x72
		}
	}
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.CreationTimestamp != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CreationTimestamp))
		i--
		dAtA[i] = 0x58
	}
	if len(m.ResourceVersion) > 0 {
		i -= len(m.ResourceVersion)
		copy(dAtA[i:], m.ResourceVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceVersion)))
		i--
		dAtA[i] = 0x52
	}
	if m.CpuCapacity != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CpuCapacity))
		i--
		dAtA[i] = 0x48
	}
	if m.CpuAllocatable != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CpuAllocatable))
		i--
		dAtA[i] = 0x40
	}
	if m.MemoryCapacity != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemoryCapacity))
		i--
		dAtA[i] = 0x38
	}
	if m.MemoryAllocatable != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemoryAllocatable))
		i--
		dAtA[i] = 0x30
	}
	if m.PodAllocatable != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.PodAllocatable))
		i--
		dAtA[i] = 0x28
	}
	if m.PodCapacity != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.PodCapacity))
		i--
		dAtA[i] = 0x20
	}
	if len(m.ApiServerVersions) > 0 {
		for k := range m.ApiServerVersions {
			v := m.ApiServerVersions[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.KubeletVersions) > 0 {
		for k := range m.KubeletVersions {
			v := m.KubeletVersions[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.NodeCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NodeCount))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ClusterNodeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterNodeInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterNodeInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceCapacity) > 0 {
		for k := range m.ResourceCapacity {
			v := m.ResourceCapacity[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.ResourceAllocatable) > 0 {
		for k := range m.ResourceAllocatable {
			v := m.ResourceAllocatable[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.KubeletVersion) > 0 {
		i -= len(m.KubeletVersion)
		copy(dAtA[i:], m.KubeletVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KubeletVersion)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.ContainerRuntimeVersion) > 0 {
		i -= len(m.ContainerRuntimeVersion)
		copy(dAtA[i:], m.ContainerRuntimeVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerRuntimeVersion)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.KernelVersion) > 0 {
		i -= len(m.KernelVersion)
		copy(dAtA[i:], m.KernelVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KernelVersion)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Architecture) > 0 {
		i -= len(m.Architecture)
		copy(dAtA[i:], m.Architecture)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Architecture)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.OperatingSystemImage) > 0 {
		i -= len(m.OperatingSystemImage)
		copy(dAtA[i:], m.OperatingSystemImage)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.OperatingSystemImage)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.OperatingSystem) > 0 {
		i -= len(m.OperatingSystem)
		copy(dAtA[i:], m.OperatingSystem)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.OperatingSystem)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.InstanceType) > 0 {
		i -= len(m.InstanceType)
		copy(dAtA[i:], m.InstanceType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.InstanceType)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Region) > 0 {
		i -= len(m.Region)
		copy(dAtA[i:], m.Region)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Region)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DeletionGracePeriodSeconds != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DeletionGracePeriodSeconds))
		i--
		dAtA[i] = 0x58
	}
	if len(m.Finalizers) > 0 {
		for iNdEx := len(m.Finalizers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Finalizers[iNdEx])
			copy(dAtA[i:], m.Finalizers[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Finalizers[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.ResourceVersion) > 0 {
		i -= len(m.ResourceVersion)
		copy(dAtA[i:], m.ResourceVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceVersion)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.OwnerReferences) > 0 {
		for iNdEx := len(m.OwnerReferences) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.OwnerReferences[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Annotations) > 0 {
		for iNdEx := len(m.Annotations) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Annotations[iNdEx])
			copy(dAtA[i:], m.Annotations[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Annotations[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Labels[iNdEx])
			copy(dAtA[i:], m.Labels[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Labels[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if m.DeletionTimestamp != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DeletionTimestamp))
		i--
		dAtA[i] = 0x28
	}
	if m.CreationTimestamp != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CreationTimestamp))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Uid) > 0 {
		i -= len(m.Uid)
		copy(dAtA[i:], m.Uid)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Uid)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OwnerReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OwnerReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OwnerReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Uid) > 0 {
		i -= len(m.Uid)
		copy(dAtA[i:], m.Uid)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Uid)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ObjectReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObjectReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ObjectReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.FieldPath) > 0 {
		i -= len(m.FieldPath)
		copy(dAtA[i:], m.FieldPath)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.FieldPath)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ResourceVersion) > 0 {
		i -= len(m.ResourceVersion)
		copy(dAtA[i:], m.ResourceVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceVersion)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ApiVersion) > 0 {
		i -= len(m.ApiVersion)
		copy(dAtA[i:], m.ApiVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ApiVersion)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Uid) > 0 {
		i -= len(m.Uid)
		copy(dAtA[i:], m.Uid)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Uid)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServicePort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServicePort) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServicePort) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NodePort != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NodePort))
		i--
		dAtA[i] = 0x28
	}
	if len(m.TargetPort) > 0 {
		i -= len(m.TargetPort)
		copy(dAtA[i:], m.TargetPort)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.TargetPort)))
		i--
		dAtA[i] = 0x22
	}
	if m.Port != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceSessionAffinityConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceSessionAffinityConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceSessionAffinityConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ClientIPTimeoutSeconds != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ClientIPTimeoutSeconds))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Node) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ProviderID) > 0 {
		i -= len(m.ProviderID)
		copy(dAtA[i:], m.ProviderID)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ProviderID)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Roles) > 0 {
		for iNdEx := len(m.Roles) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Roles[iNdEx])
			copy(dAtA[i:], m.Roles[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Roles[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Taints) > 0 {
		for iNdEx := len(m.Taints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Taints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Unschedulable {
		i--
		if m.Unschedulable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.PodCIDRs) > 0 {
		for iNdEx := len(m.PodCIDRs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PodCIDRs[iNdEx])
			copy(dAtA[i:], m.PodCIDRs[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.PodCIDRs[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.PodCIDR) > 0 {
		i -= len(m.PodCIDR)
		copy(dAtA[i:], m.PodCIDR)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PodCIDR)))
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerRuntimeVersion) > 0 {
		i -= len(m.ContainerRuntimeVersion)
		copy(dAtA[i:], m.ContainerRuntimeVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerRuntimeVersion)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.OsImage) > 0 {
		i -= len(m.OsImage)
		copy(dAtA[i:], m.OsImage)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.OsImage)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.KernelVersion) > 0 {
		i -= len(m.KernelVersion)
		copy(dAtA[i:], m.KernelVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KernelVersion)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Architecture) > 0 {
		i -= len(m.Architecture)
		copy(dAtA[i:], m.Architecture)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Architecture)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.OperatingSystem) > 0 {
		i -= len(m.OperatingSystem)
		copy(dAtA[i:], m.OperatingSystem)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.OperatingSystem)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.KubeProxyVersion) > 0 {
		i -= len(m.KubeProxyVersion)
		copy(dAtA[i:], m.KubeProxyVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KubeProxyVersion)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Images) > 0 {
		for iNdEx := len(m.Images) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Images[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.KubeletVersion) > 0 {
		i -= len(m.KubeletVersion)
		copy(dAtA[i:], m.KubeletVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KubeletVersion)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.NodeAddresses) > 0 {
		for k := range m.NodeAddresses {
			v := m.NodeAddresses[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Allocatable) > 0 {
		for k := range m.Allocatable {
			v := m.Allocatable[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Capacity) > 0 {
		for k := range m.Capacity {
			v := m.Capacity[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NodeCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerImage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerImage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerImage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SizeBytes != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.SizeBytes))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Taint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Taint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Taint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TimeAdded != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TimeAdded))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Effect) > 0 {
		i -= len(m.Effect)
		copy(dAtA[i:], m.Effect)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Effect)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.IpFamily) > 0 {
		i -= len(m.IpFamily)
		copy(dAtA[i:], m.IpFamily)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.IpFamily)))
		i--
		dAtA[i] = 0x72
	}
	if m.SessionAffinityConfig != nil {
		{
			size, err := m.SessionAffinityConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.PublishNotReadyAddresses {
		i--
		if m.PublishNotReadyAddresses {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.HealthCheckNodePort != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.HealthCheckNodePort))
		i--
		dAtA[i] = 0x58
	}
	if len(m.ExternalTrafficPolicy) > 0 {
		i -= len(m.ExternalTrafficPolicy)
		copy(dAtA[i:], m.ExternalTrafficPolicy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExternalTrafficPolicy)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ExternalName) > 0 {
		i -= len(m.ExternalName)
		copy(dAtA[i:], m.ExternalName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExternalName)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.LoadBalancerSourceRanges) > 0 {
		for iNdEx := len(m.LoadBalancerSourceRanges) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LoadBalancerSourceRanges[iNdEx])
			copy(dAtA[i:], m.LoadBalancerSourceRanges[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.LoadBalancerSourceRanges[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.LoadBalancerIP) > 0 {
		i -= len(m.LoadBalancerIP)
		copy(dAtA[i:], m.LoadBalancerIP)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.LoadBalancerIP)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.SessionAffinity) > 0 {
		i -= len(m.SessionAffinity)
		copy(dAtA[i:], m.SessionAffinity)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.SessionAffinity)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ExternalIPs) > 0 {
		for iNdEx := len(m.ExternalIPs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExternalIPs[iNdEx])
			copy(dAtA[i:], m.ExternalIPs[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.ExternalIPs[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterIP) > 0 {
		i -= len(m.ClusterIP)
		copy(dAtA[i:], m.ClusterIP)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ClusterIP)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Selectors) > 0 {
		for iNdEx := len(m.Selectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ServiceStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LoadBalancerIngress) > 0 {
		for iNdEx := len(m.LoadBalancerIngress) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LoadBalancerIngress[iNdEx])
			copy(dAtA[i:], m.LoadBalancerIngress[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.LoadBalancerIngress[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x8a
		}
	}
	return len(dAtA) - i, nil
}

func (m *Service) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Service) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Service) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x38
	}
	if m.LastUpdateTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastUpdateTime))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x92
		}
	}
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if len(m.ResourceRequirements) > 0 {
		for iNdEx := len(m.ResourceRequirements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceRequirements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x7a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.ConditionMessage) > 0 {
		i -= len(m.ConditionMessage)
		copy(dAtA[i:], m.ConditionMessage)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionMessage)))
		i--
		dAtA[i] = 0x6a
	}
	if m.UnavailableReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.UnavailableReplicas))
		i--
		dAtA[i] = 0x60
	}
	if m.AvailableReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.AvailableReplicas))
		i--
		dAtA[i] = 0x58
	}
	if m.ReadyReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ReadyReplicas))
		i--
		dAtA[i] = 0x50
	}
	if m.UpdatedReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.UpdatedReplicas))
		i--
		dAtA[i] = 0x48
	}
	if m.Replicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Replicas))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Selectors) > 0 {
		for iNdEx := len(m.Selectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Paused {
		i--
		if m.Paused {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.MaxSurge) > 0 {
		i -= len(m.MaxSurge)
		copy(dAtA[i:], m.MaxSurge)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.MaxSurge)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.MaxUnavailable) > 0 {
		i -= len(m.MaxUnavailable)
		copy(dAtA[i:], m.MaxUnavailable)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.MaxUnavailable)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DeploymentStrategy) > 0 {
		i -= len(m.DeploymentStrategy)
		copy(dAtA[i:], m.DeploymentStrategy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DeploymentStrategy)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ReplicasDesired != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ReplicasDesired))
		i--
		dAtA[i] = 0x10
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicaSetCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaSetCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicaSetCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicaSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicaSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ResourceRequirements) > 0 {
		for iNdEx := len(m.ResourceRequirements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceRequirements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x42
	}
	if m.AvailableReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.AvailableReplicas))
		i--
		dAtA[i] = 0x38
	}
	if m.ReadyReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ReadyReplicas))
		i--
		dAtA[i] = 0x30
	}
	if m.FullyLabeledReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.FullyLabeledReplicas))
		i--
		dAtA[i] = 0x28
	}
	if m.Replicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Replicas))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Selectors) > 0 {
		for iNdEx := len(m.Selectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.ReplicasDesired != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ReplicasDesired))
		i--
		dAtA[i] = 0x10
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LabelSelectorRequirement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelSelectorRequirement) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelSelectorRequirement) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Operator) > 0 {
		i -= len(m.Operator)
		copy(dAtA[i:], m.Operator)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Operator)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodDisruptionBudget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodDisruptionBudget) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodDisruptionBudget) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodDisruptionBudgetSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodDisruptionBudgetSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodDisruptionBudgetSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.UnhealthyPodEvictionPolicy) > 0 {
		i -= len(m.UnhealthyPodEvictionPolicy)
		copy(dAtA[i:], m.UnhealthyPodEvictionPolicy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.UnhealthyPodEvictionPolicy)))
		i--
		dAtA[i] = 0x22
	}
	if m.MaxUnavailable != nil {
		{
			size, err := m.MaxUnavailable.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Selector) > 0 {
		for iNdEx := len(m.Selector) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selector[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.MinAvailable != nil {
		{
			size, err := m.MinAvailable.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodDisruptionBudgetStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodDisruptionBudgetStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodDisruptionBudgetStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.ExpectedPods != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ExpectedPods))
		i--
		dAtA[i] = 0x28
	}
	if m.DesiredHealthy != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DesiredHealthy))
		i--
		dAtA[i] = 0x20
	}
	if m.CurrentHealthy != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CurrentHealthy))
		i--
		dAtA[i] = 0x18
	}
	if m.DisruptionsAllowed != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DisruptionsAllowed))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DisruptedPods) > 0 {
		for k := range m.DisruptedPods {
			v := m.DisruptedPods[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IntOrString) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntOrString) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntOrString) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.StrVal) > 0 {
		i -= len(m.StrVal)
		copy(dAtA[i:], m.StrVal)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.StrVal)))
		i--
		dAtA[i] = 0x1a
	}
	if m.IntVal != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.IntVal))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Condition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Condition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Condition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Pod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Pod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Pod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NodeAffinity != nil {
		{
			size, err := m.NodeAffinity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.ScheduledTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ScheduledTime))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.StartTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.StartTime))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if len(m.PriorityClass) > 0 {
		i -= len(m.PriorityClass)
		copy(dAtA[i:], m.PriorityClass)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PriorityClass)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.QOSClass) > 0 {
		i -= len(m.QOSClass)
		copy(dAtA[i:], m.QOSClass)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.QOSClass)))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.InitContainerStatuses) > 0 {
		for iNdEx := len(m.InitContainerStatuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.InitContainerStatuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.ResourceRequirements) > 0 {
		for iNdEx := len(m.ResourceRequirements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceRequirements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6a
		}
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.ConditionMessage) > 0 {
		i -= len(m.ConditionMessage)
		copy(dAtA[i:], m.ConditionMessage)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionMessage)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.ContainerStatuses) > 0 {
		for iNdEx := len(m.ContainerStatuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ContainerStatuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.RestartCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RestartCount))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Phase) > 0 {
		i -= len(m.Phase)
		copy(dAtA[i:], m.Phase)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Phase)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.NominatedNodeName) > 0 {
		i -= len(m.NominatedNodeName)
		copy(dAtA[i:], m.NominatedNodeName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.NominatedNodeName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.IP) > 0 {
		i -= len(m.IP)
		copy(dAtA[i:], m.IP)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.IP)))
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x2a
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x20
	}
	if m.LastProbeTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastProbeTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ImageID) > 0 {
		i -= len(m.ImageID)
		copy(dAtA[i:], m.ImageID)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ImageID)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Image) > 0 {
		i -= len(m.Image)
		copy(dAtA[i:], m.Image)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Image)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.State) > 0 {
		i -= len(m.State)
		copy(dAtA[i:], m.State)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.State)))
		i--
		dAtA[i] = 0x2a
	}
	if m.RestartCount != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RestartCount))
		i--
		dAtA[i] = 0x20
	}
	if m.Ready {
		i--
		if m.Ready {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.ContainerID) > 0 {
		i -= len(m.ContainerID)
		copy(dAtA[i:], m.ContainerID)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeAffinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeAffinity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeAffinity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for iNdEx := len(m.PreferredDuringSchedulingIgnoredDuringExecution) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PreferredDuringSchedulingIgnoredDuringExecution[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		{
			size, err := m.RequiredDuringSchedulingIgnoredDuringExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSelector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NodeSelectorTerms) > 0 {
		for iNdEx := len(m.NodeSelectorTerms) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NodeSelectorTerms[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PreferredSchedulingTerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PreferredSchedulingTerm) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PreferredSchedulingTerm) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Preference != nil {
		{
			size, err := m.Preference.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Weight != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Weight))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Manifest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Manifest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Manifest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ApiVersion) > 0 {
		i -= len(m.ApiVersion)
		copy(dAtA[i:], m.ApiVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ApiVersion)))
		i--
		dAtA[i] = 0x4a
	}
	if m.IsTerminated {
		i--
		if m.IsTerminated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ContentType) > 0 {
		i -= len(m.ContentType)
		copy(dAtA[i:], m.ContentType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContentType)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Content) > 0 {
		i -= len(m.Content)
		copy(dAtA[i:], m.Content)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Content)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Uid) > 0 {
		i -= len(m.Uid)
		copy(dAtA[i:], m.Uid)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Uid)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ResourceVersion) > 0 {
		i -= len(m.ResourceVersion)
		copy(dAtA[i:], m.ResourceVersion)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceVersion)))
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ConditionMessage) > 0 {
		i -= len(m.ConditionMessage)
		copy(dAtA[i:], m.ConditionMessage)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionMessage)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResourceRequirements) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceRequirements) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceRequirements) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Requests) > 0 {
		for k := range m.Requests {
			v := m.Requests[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Limits) > 0 {
		for k := range m.Limits {
			v := m.Limits[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ResourceMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MetricValues) > 0 {
		for k := range m.MetricValues {
			v := m.MetricValues[k]
			baseI := i
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i--
			dAtA[i] = 0x11
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *JobSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JobSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceRequirements) > 0 {
		for iNdEx := len(m.ResourceRequirements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceRequirements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.ManualSelector {
		i--
		if m.ManualSelector {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Selectors) > 0 {
		for iNdEx := len(m.Selectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.BackoffLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.BackoffLimit))
		i--
		dAtA[i] = 0x20
	}
	if m.ActiveDeadlineSeconds != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ActiveDeadlineSeconds))
		i--
		dAtA[i] = 0x18
	}
	if m.Completions != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Completions))
		i--
		dAtA[i] = 0x10
	}
	if m.Parallelism != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Parallelism))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *JobStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JobStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Failed != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Failed))
		i--
		dAtA[i] = 0x30
	}
	if m.Succeeded != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Succeeded))
		i--
		dAtA[i] = 0x28
	}
	if m.Active != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Active))
		i--
		dAtA[i] = 0x20
	}
	if m.CompletionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CompletionTime))
		i--
		dAtA[i] = 0x18
	}
	if m.StartTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.StartTime))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ConditionMessage) > 0 {
		i -= len(m.ConditionMessage)
		copy(dAtA[i:], m.ConditionMessage)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionMessage)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *JobCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JobCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x2a
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x20
	}
	if m.LastProbeTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastProbeTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Job) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Job) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Job) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CronJobSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CronJobSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CronJobSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TimeZone) > 0 {
		i -= len(m.TimeZone)
		copy(dAtA[i:], m.TimeZone)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.TimeZone)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.ResourceRequirements) > 0 {
		for iNdEx := len(m.ResourceRequirements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceRequirements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.FailedJobsHistoryLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.FailedJobsHistoryLimit))
		i--
		dAtA[i] = 0x30
	}
	if m.SuccessfulJobsHistoryLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.SuccessfulJobsHistoryLimit))
		i--
		dAtA[i] = 0x28
	}
	if m.Suspend {
		i--
		if m.Suspend {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.ConcurrencyPolicy) > 0 {
		i -= len(m.ConcurrencyPolicy)
		copy(dAtA[i:], m.ConcurrencyPolicy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConcurrencyPolicy)))
		i--
		dAtA[i] = 0x1a
	}
	if m.StartingDeadlineSeconds != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.StartingDeadlineSeconds))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Schedule) > 0 {
		i -= len(m.Schedule)
		copy(dAtA[i:], m.Schedule)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Schedule)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CronJobStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CronJobStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CronJobStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastSuccessfulTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastSuccessfulTime))
		i--
		dAtA[i] = 0x18
	}
	if m.LastScheduleTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastScheduleTime))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Active) > 0 {
		for iNdEx := len(m.Active) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Active[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CronJob) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CronJob) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CronJob) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DaemonSetSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DaemonSetSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DaemonSetSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceRequirements) > 0 {
		for iNdEx := len(m.ResourceRequirements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceRequirements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.RevisionHistoryLimit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RevisionHistoryLimit))
		i--
		dAtA[i] = 0x28
	}
	if m.MinReadySeconds != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MinReadySeconds))
		i--
		dAtA[i] = 0x20
	}
	if len(m.MaxUnavailable) > 0 {
		i -= len(m.MaxUnavailable)
		copy(dAtA[i:], m.MaxUnavailable)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.MaxUnavailable)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DeploymentStrategy) > 0 {
		i -= len(m.DeploymentStrategy)
		copy(dAtA[i:], m.DeploymentStrategy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DeploymentStrategy)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Selectors) > 0 {
		for iNdEx := len(m.Selectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DaemonSetStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DaemonSetStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DaemonSetStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NumberUnavailable != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumberUnavailable))
		i--
		dAtA[i] = 0x40
	}
	if m.NumberAvailable != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumberAvailable))
		i--
		dAtA[i] = 0x38
	}
	if m.UpdatedNumberScheduled != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.UpdatedNumberScheduled))
		i--
		dAtA[i] = 0x30
	}
	if m.NumberReady != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumberReady))
		i--
		dAtA[i] = 0x20
	}
	if m.DesiredNumberScheduled != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DesiredNumberScheduled))
		i--
		dAtA[i] = 0x18
	}
	if m.NumberMisscheduled != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NumberMisscheduled))
		i--
		dAtA[i] = 0x10
	}
	if m.CurrentNumberScheduled != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CurrentNumberScheduled))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DaemonSetCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DaemonSetCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DaemonSetCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DaemonSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DaemonSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DaemonSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StatefulSetSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatefulSetSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatefulSetSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceRequirements) > 0 {
		for iNdEx := len(m.ResourceRequirements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceRequirements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Partition != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Partition))
		i--
		dAtA[i] = 0x30
	}
	if len(m.UpdateStrategy) > 0 {
		i -= len(m.UpdateStrategy)
		copy(dAtA[i:], m.UpdateStrategy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.UpdateStrategy)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.PodManagementPolicy) > 0 {
		i -= len(m.PodManagementPolicy)
		copy(dAtA[i:], m.PodManagementPolicy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PodManagementPolicy)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ServiceName) > 0 {
		i -= len(m.ServiceName)
		copy(dAtA[i:], m.ServiceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ServiceName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Selectors) > 0 {
		for iNdEx := len(m.Selectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.DesiredReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DesiredReplicas))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *StatefulSetStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatefulSetStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatefulSetStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UpdatedReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.UpdatedReplicas))
		i--
		dAtA[i] = 0x20
	}
	if m.CurrentReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CurrentReplicas))
		i--
		dAtA[i] = 0x18
	}
	if m.ReadyReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ReadyReplicas))
		i--
		dAtA[i] = 0x10
	}
	if m.Replicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Replicas))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *StatefulSetCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatefulSetCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatefulSetCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StatefulSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatefulSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatefulSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolume) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolume) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolume) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolumeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolumeSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PersistentVolumeSource != nil {
		{
			size, err := m.PersistentVolumeSource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.NodeAffinity) > 0 {
		for iNdEx := len(m.NodeAffinity) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NodeAffinity[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.VolumeMode) > 0 {
		i -= len(m.VolumeMode)
		copy(dAtA[i:], m.VolumeMode)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VolumeMode)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.MountOptions) > 0 {
		for iNdEx := len(m.MountOptions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MountOptions[iNdEx])
			copy(dAtA[i:], m.MountOptions[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.MountOptions[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.StorageClassName) > 0 {
		i -= len(m.StorageClassName)
		copy(dAtA[i:], m.StorageClassName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.StorageClassName)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.PersistentVolumeReclaimPolicy) > 0 {
		i -= len(m.PersistentVolumeReclaimPolicy)
		copy(dAtA[i:], m.PersistentVolumeReclaimPolicy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PersistentVolumeReclaimPolicy)))
		i--
		dAtA[i] = 0x2a
	}
	if m.ClaimRef != nil {
		{
			size, err := m.ClaimRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.AccessModes) > 0 {
		for iNdEx := len(m.AccessModes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AccessModes[iNdEx])
			copy(dAtA[i:], m.AccessModes[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.AccessModes[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.PersistentVolumeType) > 0 {
		i -= len(m.PersistentVolumeType)
		copy(dAtA[i:], m.PersistentVolumeType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PersistentVolumeType)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Capacity) > 0 {
		for k := range m.Capacity {
			v := m.Capacity[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Csi != nil {
		{
			size, err := m.Csi.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.AzureDisk != nil {
		{
			size, err := m.AzureDisk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.AzureFile != nil {
		{
			size, err := m.AzureFile.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.AwsElasticBlockStore != nil {
		{
			size, err := m.AwsElasticBlockStore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.GcePersistentDisk != nil {
		{
			size, err := m.GcePersistentDisk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GCEPersistentDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCEPersistentDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GCEPersistentDiskVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ReadOnly {
		i--
		if m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Partition != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Partition))
		i--
		dAtA[i] = 0x18
	}
	if len(m.FsType) > 0 {
		i -= len(m.FsType)
		copy(dAtA[i:], m.FsType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.FsType)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PdName) > 0 {
		i -= len(m.PdName)
		copy(dAtA[i:], m.PdName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PdName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AWSElasticBlockStoreVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AWSElasticBlockStoreVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AWSElasticBlockStoreVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ReadOnly {
		i--
		if m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Partition != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Partition))
		i--
		dAtA[i] = 0x18
	}
	if len(m.FsType) > 0 {
		i -= len(m.FsType)
		copy(dAtA[i:], m.FsType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.FsType)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.VolumeID) > 0 {
		i -= len(m.VolumeID)
		copy(dAtA[i:], m.VolumeID)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VolumeID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AzureFilePersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureFilePersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AzureFilePersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SecretNamespace) > 0 {
		i -= len(m.SecretNamespace)
		copy(dAtA[i:], m.SecretNamespace)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.SecretNamespace)))
		i--
		dAtA[i] = 0x22
	}
	if m.ReadOnly {
		i--
		if m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.ShareName) > 0 {
		i -= len(m.ShareName)
		copy(dAtA[i:], m.ShareName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ShareName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SecretName) > 0 {
		i -= len(m.SecretName)
		copy(dAtA[i:], m.SecretName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.SecretName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AzureDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AzureDiskVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0x32
	}
	if m.ReadOnly {
		i--
		if m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.FsType) > 0 {
		i -= len(m.FsType)
		copy(dAtA[i:], m.FsType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.FsType)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.CachingMode) > 0 {
		i -= len(m.CachingMode)
		copy(dAtA[i:], m.CachingMode)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.CachingMode)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DiskURI) > 0 {
		i -= len(m.DiskURI)
		copy(dAtA[i:], m.DiskURI)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DiskURI)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DiskName) > 0 {
		i -= len(m.DiskName)
		copy(dAtA[i:], m.DiskName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.DiskName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CSIVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CSIVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CSIVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NodeExpandSecretRef != nil {
		{
			size, err := m.NodeExpandSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.ControllerExpandSecretRef != nil {
		{
			size, err := m.ControllerExpandSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.NodePublishSecretRef != nil {
		{
			size, err := m.NodePublishSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.NodeStageSecretRef != nil {
		{
			size, err := m.NodeStageSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.ControllerPublishSecretRef != nil {
		{
			size, err := m.ControllerPublishSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.VolumeAttributes) > 0 {
		for k := range m.VolumeAttributes {
			v := m.VolumeAttributes[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.FsType) > 0 {
		i -= len(m.FsType)
		copy(dAtA[i:], m.FsType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.FsType)))
		i--
		dAtA[i] = 0x22
	}
	if m.ReadOnly {
		i--
		if m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.VolumeHandle) > 0 {
		i -= len(m.VolumeHandle)
		copy(dAtA[i:], m.VolumeHandle)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VolumeHandle)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Driver) > 0 {
		i -= len(m.Driver)
		copy(dAtA[i:], m.Driver)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Driver)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecretReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecretReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolumeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolumeStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Phase) > 0 {
		i -= len(m.Phase)
		copy(dAtA[i:], m.Phase)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Phase)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeSelectorTerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelectorTerm) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSelectorTerm) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MatchFields) > 0 {
		for iNdEx := len(m.MatchFields) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MatchFields[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.MatchExpressions) > 0 {
		for iNdEx := len(m.MatchExpressions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MatchExpressions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolumeClaim) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaim) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolumeClaim) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolumeClaimStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolumeClaimStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Capacity) > 0 {
		for k := range m.Capacity {
			v := m.Capacity[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.AccessModes) > 0 {
		for iNdEx := len(m.AccessModes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AccessModes[iNdEx])
			copy(dAtA[i:], m.AccessModes[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.AccessModes[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Phase) > 0 {
		i -= len(m.Phase)
		copy(dAtA[i:], m.Phase)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Phase)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolumeClaimSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolumeClaimSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DataSource != nil {
		{
			size, err := m.DataSource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.VolumeMode) > 0 {
		i -= len(m.VolumeMode)
		copy(dAtA[i:], m.VolumeMode)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VolumeMode)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.StorageClassName) > 0 {
		i -= len(m.StorageClassName)
		copy(dAtA[i:], m.StorageClassName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.StorageClassName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Selector) > 0 {
		for iNdEx := len(m.Selector) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selector[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.VolumeName) > 0 {
		i -= len(m.VolumeName)
		copy(dAtA[i:], m.VolumeName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VolumeName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.AccessModes) > 0 {
		for iNdEx := len(m.AccessModes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AccessModes[iNdEx])
			copy(dAtA[i:], m.AccessModes[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.AccessModes[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TypedLocalObjectReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TypedLocalObjectReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TypedLocalObjectReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ApiGroup) > 0 {
		i -= len(m.ApiGroup)
		copy(dAtA[i:], m.ApiGroup)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ApiGroup)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PersistentVolumeClaimCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentVolumeClaimCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x2a
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x20
	}
	if m.LastProbeTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastProbeTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PolicyRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PolicyRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PolicyRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NonResourceURLs) > 0 {
		for iNdEx := len(m.NonResourceURLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NonResourceURLs[iNdEx])
			copy(dAtA[i:], m.NonResourceURLs[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.NonResourceURLs[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ResourceNames) > 0 {
		for iNdEx := len(m.ResourceNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ResourceNames[iNdEx])
			copy(dAtA[i:], m.ResourceNames[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceNames[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Resources[iNdEx])
			copy(dAtA[i:], m.Resources[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Resources[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ApiGroups) > 0 {
		for iNdEx := len(m.ApiGroups) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ApiGroups[iNdEx])
			copy(dAtA[i:], m.ApiGroups[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.ApiGroups[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Verbs) > 0 {
		for iNdEx := len(m.Verbs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Verbs[iNdEx])
			copy(dAtA[i:], m.Verbs[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Verbs[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Subject) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subject) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Subject) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ApiGroup) > 0 {
		i -= len(m.ApiGroup)
		copy(dAtA[i:], m.ApiGroup)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ApiGroup)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Role) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Role) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Role) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RoleBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.RoleRef != nil {
		{
			size, err := m.RoleRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Subjects) > 0 {
		for iNdEx := len(m.Subjects) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Subjects[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClusterRole) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterRole) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterRole) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.AggregationRules) > 0 {
		for iNdEx := len(m.AggregationRules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AggregationRules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClusterRoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterRoleBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterRoleBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.RoleRef != nil {
		{
			size, err := m.RoleRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Subjects) > 0 {
		for iNdEx := len(m.Subjects) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Subjects[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceAccount) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceAccount) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceAccount) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x2a
	}
	if m.AutomountServiceAccountToken {
		i--
		if m.AutomountServiceAccountToken {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.ImagePullSecrets) > 0 {
		for iNdEx := len(m.ImagePullSecrets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ImagePullSecrets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Secrets) > 0 {
		for iNdEx := len(m.Secrets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Secrets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IngressServiceBackend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IngressServiceBackend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IngressServiceBackend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PortNumber != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x18
	}
	if len(m.PortName) > 0 {
		i -= len(m.PortName)
		copy(dAtA[i:], m.PortName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PortName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ServiceName) > 0 {
		i -= len(m.ServiceName)
		copy(dAtA[i:], m.ServiceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ServiceName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IngressBackend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IngressBackend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IngressBackend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Service != nil {
		{
			size, err := m.Service.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IngressTLS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IngressTLS) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IngressTLS) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SecretName) > 0 {
		i -= len(m.SecretName)
		copy(dAtA[i:], m.SecretName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.SecretName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Hosts) > 0 {
		for iNdEx := len(m.Hosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hosts[iNdEx])
			copy(dAtA[i:], m.Hosts[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Hosts[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTPIngressPath) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPIngressPath) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPIngressPath) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PathType) > 0 {
		i -= len(m.PathType)
		copy(dAtA[i:], m.PathType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.PathType)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Backend != nil {
		{
			size, err := m.Backend.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IngressRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IngressRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IngressRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HttpPaths) > 0 {
		for iNdEx := len(m.HttpPaths) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HttpPaths[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IngressSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IngressSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IngressSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.IngressClassName) > 0 {
		i -= len(m.IngressClassName)
		copy(dAtA[i:], m.IngressClassName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.IngressClassName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Tls) > 0 {
		for iNdEx := len(m.Tls) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tls[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.DefaultBackend != nil {
		{
			size, err := m.DefaultBackend.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PortStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x12
	}
	if m.Port != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LoadBalancerIngress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerIngress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerIngress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Hostname) > 0 {
		i -= len(m.Hostname)
		copy(dAtA[i:], m.Hostname)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Hostname)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Ip) > 0 {
		i -= len(m.Ip)
		copy(dAtA[i:], m.Ip)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Ip)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IngressStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IngressStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IngressStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ingress) > 0 {
		for iNdEx := len(m.Ingress) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ingress[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Ingress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Ingress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Ingress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KafkaStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KafkaStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KafkaStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FirstLatencySample != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.FirstLatencySample))))
		i--
		dAtA[i] = 0x19
	}
	if len(m.Latencies) > 0 {
		i -= len(m.Latencies)
		copy(dAtA[i:], m.Latencies)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Latencies)))
		i--
		dAtA[i] = 0x12
	}
	if m.Count != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *KafkaRequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KafkaRequestHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KafkaRequestHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RequestVersion != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RequestVersion))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestType != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RequestType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *KafkaAggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KafkaAggregation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KafkaAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.StatsByErrorCode) > 0 {
		for k := range m.StatsByErrorCode {
			v := m.StatsByErrorCode[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintAgent(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintAgent(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Count != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0x12
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DataStreamsAggregations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataStreamsAggregations) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataStreamsAggregations) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.KafkaAggregations) > 0 {
		for iNdEx := len(m.KafkaAggregations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.KafkaAggregations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	return len(dAtA) - i, nil
}

func (m *PostgresStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PostgresStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PostgresStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Count != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x28
	}
	if m.FirstLatencySample != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.FirstLatencySample))))
		i--
		dAtA[i] = 0x21
	}
	if len(m.Latencies) > 0 {
		i -= len(m.Latencies)
		copy(dAtA[i:], m.Latencies)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Latencies)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Operation != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Operation))
		i--
		dAtA[i] = 0x10
	}
	if len(m.TableName) > 0 {
		i -= len(m.TableName)
		copy(dAtA[i:], m.TableName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.TableName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RedisStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RedisStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ErrorToStats) > 0 {
		for k := range m.ErrorToStats {
			v := m.ErrorToStats[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintAgent(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintAgent(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Truncated {
		i--
		if m.Truncated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.KeyName) > 0 {
		i -= len(m.KeyName)
		copy(dAtA[i:], m.KeyName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.KeyName)))
		i--
		dAtA[i] = 0x12
	}
	if m.Command != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Command))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RedisStatsEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisStatsEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RedisStatsEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Count != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x18
	}
	if m.FirstLatencySample != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.FirstLatencySample))))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Latencies) > 0 {
		i -= len(m.Latencies)
		copy(dAtA[i:], m.Latencies)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Latencies)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DatabaseStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DatabaseStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DbStats != nil {
		{
			size := m.DbStats.Size()
			i -= size
			if _, err := m.DbStats.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *DatabaseStats_Postgres) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DatabaseStats_Postgres) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Postgres != nil {
		{
			size, err := m.Postgres.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *DatabaseStats_Redis) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DatabaseStats_Redis) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Redis != nil {
		{
			size, err := m.Redis.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *DatabaseAggregations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseAggregations) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DatabaseAggregations) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Aggregations) > 0 {
		for iNdEx := len(m.Aggregations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Aggregations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTPAggregations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPAggregations) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPAggregations) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.EndpointAggregations) > 0 {
		for iNdEx := len(m.EndpointAggregations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EndpointAggregations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTP2Aggregations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTP2Aggregations) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTP2Aggregations) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.EndpointAggregations) > 0 {
		for iNdEx := len(m.EndpointAggregations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EndpointAggregations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTPStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FullPath {
		i--
		if m.FullPath {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Method != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Method))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.StatsByStatusCode) > 0 {
		for k := range m.StatsByStatusCode {
			v := m.StatsByStatusCode[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintAgent(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintAgent(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.StatsByResponseStatus) > 0 {
		for iNdEx := len(m.StatsByResponseStatus) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StatsByResponseStatus[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTPStats_Data) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPStats_Data) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPStats_Data) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FirstLatencySample != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.FirstLatencySample))))
		i--
		dAtA[i] = 0x21
	}
	if len(m.Latencies) > 0 {
		i -= len(m.Latencies)
		copy(dAtA[i:], m.Latencies)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Latencies)))
		i--
		dAtA[i] = 0x12
	}
	if m.Count != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DNSDatabaseEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSDatabaseEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSDatabaseEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NameOffsets) > 0 {
		for iNdEx := len(m.NameOffsets) - 1; iNdEx >= 0; iNdEx-- {
			i = encodeVarintAgent(dAtA, i, uint64(m.NameOffsets[iNdEx]))
			i--
			dAtA[i] = 0x8
		}
	}
	return len(dAtA) - i, nil
}

func (m *ResourceList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MetricValues) > 0 {
		for k := range m.MetricValues {
			v := m.MetricValues[k]
			baseI := i
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i--
			dAtA[i] = 0x11
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *VerticalPodAutoscaler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerticalPodAutoscaler) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerticalPodAutoscaler) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VerticalPodAutoscalerCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerticalPodAutoscalerCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerticalPodAutoscalerCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VerticalPodAutoscalerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerticalPodAutoscalerSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerticalPodAutoscalerSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourcePolicies) > 0 {
		for iNdEx := len(m.ResourcePolicies) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourcePolicies[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.UpdateMode) > 0 {
		i -= len(m.UpdateMode)
		copy(dAtA[i:], m.UpdateMode)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.UpdateMode)))
		i--
		dAtA[i] = 0x12
	}
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VerticalPodAutoscalerTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerticalPodAutoscalerTarget) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerticalPodAutoscalerTarget) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerResourcePolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerResourcePolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerResourcePolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ControlledValues) > 0 {
		i -= len(m.ControlledValues)
		copy(dAtA[i:], m.ControlledValues)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ControlledValues)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ControlledResource) > 0 {
		for iNdEx := len(m.ControlledResource) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ControlledResource[iNdEx])
			copy(dAtA[i:], m.ControlledResource[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.ControlledResource[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.MaxAllowed != nil {
		{
			size, err := m.MaxAllowed.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.MinAllowed != nil {
		{
			size, err := m.MinAllowed.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Mode) > 0 {
		i -= len(m.Mode)
		copy(dAtA[i:], m.Mode)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Mode)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerName) > 0 {
		i -= len(m.ContainerName)
		copy(dAtA[i:], m.ContainerName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VerticalPodAutoscalerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerticalPodAutoscalerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerticalPodAutoscalerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Recommendations) > 0 {
		for iNdEx := len(m.Recommendations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Recommendations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.LastRecommendedDate != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastRecommendedDate))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ContainerRecommendation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerRecommendation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerRecommendation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UncappedTarget != nil {
		{
			size, err := m.UncappedTarget.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.UpperBound != nil {
		{
			size, err := m.UpperBound.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.LowerBound != nil {
		{
			size, err := m.LowerBound.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerName) > 0 {
		i -= len(m.ContainerName)
		copy(dAtA[i:], m.ContainerName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VPACondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VPACondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VPACondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ConditionStatus) > 0 {
		i -= len(m.ConditionStatus)
		copy(dAtA[i:], m.ConditionStatus)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionStatus)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ConditionType) > 0 {
		i -= len(m.ConditionType)
		copy(dAtA[i:], m.ConditionType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscaler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscaler) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscaler) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscalerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscalerSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscalerSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Behavior != nil {
		{
			size, err := m.Behavior.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Metrics) > 0 {
		for iNdEx := len(m.Metrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.MaxReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MaxReplicas))
		i--
		dAtA[i] = 0x18
	}
	if m.MinReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MinReplicas))
		i--
		dAtA[i] = 0x10
	}
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscalerTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscalerTarget) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscalerTarget) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscalerMetricSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscalerMetricSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscalerMetricSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.External != nil {
		{
			size, err := m.External.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.ContainerResource != nil {
		{
			size, err := m.ContainerResource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Pods != nil {
		{
			size, err := m.Pods.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Object != nil {
		{
			size, err := m.Object.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ObjectMetricSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObjectMetricSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ObjectMetricSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Metric != nil {
		{
			size, err := m.Metric.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.DescribedObject != nil {
		{
			size, err := m.DescribedObject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MetricTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricTarget) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricTarget) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MetricIdentifier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricIdentifier) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricIdentifier) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSelector) > 0 {
		for iNdEx := len(m.LabelSelector) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LabelSelector[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodsMetricSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodsMetricSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodsMetricSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metric != nil {
		{
			size, err := m.Metric.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResourceMetricSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetricSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetricSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ResourceName) > 0 {
		i -= len(m.ResourceName)
		copy(dAtA[i:], m.ResourceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerResourceMetricSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerResourceMetricSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerResourceMetricSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Container) > 0 {
		i -= len(m.Container)
		copy(dAtA[i:], m.Container)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Container)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ResourceName) > 0 {
		i -= len(m.ResourceName)
		copy(dAtA[i:], m.ResourceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExternalMetricSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalMetricSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExternalMetricSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metric != nil {
		{
			size, err := m.Metric.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscalerBehavior) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscalerBehavior) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscalerBehavior) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ScaleDown != nil {
		{
			size, err := m.ScaleDown.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ScaleUp != nil {
		{
			size, err := m.ScaleUp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HPAScalingRules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HPAScalingRules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HPAScalingRules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Policies) > 0 {
		for iNdEx := len(m.Policies) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Policies[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.SelectPolicy) > 0 {
		i -= len(m.SelectPolicy)
		copy(dAtA[i:], m.SelectPolicy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.SelectPolicy)))
		i--
		dAtA[i] = 0x12
	}
	if m.StabilizationWindowSeconds != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.StabilizationWindowSeconds))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HPAScalingPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HPAScalingPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HPAScalingPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PeriodSeconds != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.PeriodSeconds))
		i--
		dAtA[i] = 0x18
	}
	if m.Value != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscalerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscalerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscalerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CurrentMetrics) > 0 {
		for iNdEx := len(m.CurrentMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CurrentMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.DesiredReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DesiredReplicas))
		i--
		dAtA[i] = 0x20
	}
	if m.CurrentReplicas != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.CurrentReplicas))
		i--
		dAtA[i] = 0x18
	}
	if m.LastScaleTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastScaleTime))
		i--
		dAtA[i] = 0x10
	}
	if m.ObservedGeneration != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ObservedGeneration))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscalerCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscalerCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscalerCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastTransitionTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.LastTransitionTime))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ConditionStatus) > 0 {
		i -= len(m.ConditionStatus)
		copy(dAtA[i:], m.ConditionStatus)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionStatus)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ConditionType) > 0 {
		i -= len(m.ConditionType)
		copy(dAtA[i:], m.ConditionType)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ConditionType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HorizontalPodAutoscalerMetricStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HorizontalPodAutoscalerMetricStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HorizontalPodAutoscalerMetricStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.External != nil {
		{
			size, err := m.External.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.ContainerResource != nil {
		{
			size, err := m.ContainerResource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Pods != nil {
		{
			size, err := m.Pods.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Object != nil {
		{
			size, err := m.Object.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ObjectMetricStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObjectMetricStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ObjectMetricStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Metric != nil {
		{
			size, err := m.Metric.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Current != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Current))
		i--
		dAtA[i] = 0x10
	}
	if m.DescribedObject != nil {
		{
			size, err := m.DescribedObject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodsMetricStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodsMetricStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodsMetricStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Current != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Current))
		i--
		dAtA[i] = 0x10
	}
	if m.Metric != nil {
		{
			size, err := m.Metric.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResourceMetricStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetricStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetricStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Current != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Current))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ResourceName) > 0 {
		i -= len(m.ResourceName)
		copy(dAtA[i:], m.ResourceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerResourceMetricStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerResourceMetricStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerResourceMetricStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Container) > 0 {
		i -= len(m.Container)
		copy(dAtA[i:], m.Container)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Container)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Current != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Current))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ResourceName) > 0 {
		i -= len(m.ResourceName)
		copy(dAtA[i:], m.ResourceName)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ResourceName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExternalMetricStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalMetricStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExternalMetricStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Current != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Current))
		i--
		dAtA[i] = 0x10
	}
	if m.Metric != nil {
		{
			size, err := m.Metric.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicySpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicySpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicySpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PolicyTypes) > 0 {
		for iNdEx := len(m.PolicyTypes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PolicyTypes[iNdEx])
			copy(dAtA[i:], m.PolicyTypes[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.PolicyTypes[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Egress) > 0 {
		for iNdEx := len(m.Egress) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Egress[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Ingress) > 0 {
		for iNdEx := len(m.Ingress) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ingress[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Selectors) > 0 {
		for iNdEx := len(m.Selectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Selectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicyIPBlock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicyIPBlock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicyIPBlock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Except) > 0 {
		for iNdEx := len(m.Except) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Except[iNdEx])
			copy(dAtA[i:], m.Except[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Except[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Cidr) > 0 {
		i -= len(m.Cidr)
		copy(dAtA[i:], m.Cidr)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Cidr)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicyIngressRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicyIngressRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicyIngressRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.From) > 0 {
		for iNdEx := len(m.From) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.From[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicyEgressRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicyEgressRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicyEgressRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.To) > 0 {
		for iNdEx := len(m.To) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.To[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicyPeer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicyPeer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicyPeer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HasNamespaceSelector {
		i--
		if m.HasNamespaceSelector {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.HasPodSelector {
		i--
		if m.HasPodSelector {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.IpBlock != nil {
		{
			size, err := m.IpBlock.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NamespaceSelector) > 0 {
		for iNdEx := len(m.NamespaceSelector) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NamespaceSelector[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.PodSelector) > 0 {
		for iNdEx := len(m.PodSelector) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PodSelector[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicyPort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicyPort) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicyPort) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EndPort != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.EndPort))
		i--
		dAtA[i] = 0x18
	}
	if m.Port != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LimitRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.LimitTypes) > 0 {
		for iNdEx := len(m.LimitTypes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LimitTypes[iNdEx])
			copy(dAtA[i:], m.LimitTypes[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.LimitTypes[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LimitRangeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitRangeSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for iNdEx := len(m.Limits) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Limits[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LimitRangeItem) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeItem) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitRangeItem) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MaxLimitRequestRatio) > 0 {
		for k := range m.MaxLimitRequestRatio {
			v := m.MaxLimitRequestRatio[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Min) > 0 {
		for k := range m.Min {
			v := m.Min[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Max) > 0 {
		for k := range m.Max {
			v := m.Max[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.DefaultRequest) > 0 {
		for k := range m.DefaultRequest {
			v := m.DefaultRequest[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Default) > 0 {
		for k := range m.Default {
			v := m.Default[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StorageClass) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageClass) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageClass) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.VolumeBindingMode) > 0 {
		i -= len(m.VolumeBindingMode)
		copy(dAtA[i:], m.VolumeBindingMode)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VolumeBindingMode)))
		i--
		dAtA[i] = 0x42
	}
	if m.AllowedTopologies != nil {
		{
			size, err := m.AllowedTopologies.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.AllowVolumeExpansion {
		i--
		if m.AllowVolumeExpansion {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.MountOptions) > 0 {
		for iNdEx := len(m.MountOptions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MountOptions[iNdEx])
			copy(dAtA[i:], m.MountOptions[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.MountOptions[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ReclaimPolicy) > 0 {
		i -= len(m.ReclaimPolicy)
		copy(dAtA[i:], m.ReclaimPolicy)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ReclaimPolicy)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Parameters) > 0 {
		for k := range m.Parameters {
			v := m.Parameters[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Provisioner) > 0 {
		i -= len(m.Provisioner)
		copy(dAtA[i:], m.Provisioner)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Provisioner)))
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StorageClassTopologies) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageClassTopologies) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageClassTopologies) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSelectors) > 0 {
		for iNdEx := len(m.LabelSelectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LabelSelectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TopologyLabelSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TopologyLabelSelector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TopologyLabelSelector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAgent(dAtA []byte, offset int, v uint64) int {
	offset -= sovAgent(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ResCollector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ResCollector_Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovAgent(uint64(m.Type))
	}
	return n
}

func (m *CollectorProc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Processes) > 0 {
		for _, e := range m.Processes {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	l = len(m.NetworkId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ContainerHostType != 0 {
		n += 1 + sovAgent(uint64(m.ContainerHostType))
	}
	if m.Hints != nil {
		n += m.Hints.Size()
	}
	return n
}

func (m *CollectorProc_HintMask) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.HintMask))
	return n
}
func (m *CollectorProcDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.ProcessDiscoveries) > 0 {
		for _, e := range m.ProcessDiscoveries {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorRealTime) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Stats) > 0 {
		for _, e := range m.Stats {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.HostId != 0 {
		n += 1 + sovAgent(uint64(m.HostId))
	}
	if m.OrgId != 0 {
		n += 1 + sovAgent(uint64(m.OrgId))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if m.NumCpus != 0 {
		n += 1 + sovAgent(uint64(m.NumCpus))
	}
	if m.TotalMemory != 0 {
		n += 1 + sovAgent(uint64(m.TotalMemory))
	}
	if len(m.ContainerStats) > 0 {
		for _, e := range m.ContainerStats {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.ContainerHostType != 0 {
		n += 1 + sovAgent(uint64(m.ContainerHostType))
	}
	return n
}

func (m *CollectorContainer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ContainerHostType != 0 {
		n += 1 + sovAgent(uint64(m.ContainerHostType))
	}
	l = len(m.NetworkId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorContainerRealTime) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Stats) > 0 {
		for _, e := range m.Stats {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.NumCpus != 0 {
		n += 1 + sovAgent(uint64(m.NumCpus))
	}
	if m.TotalMemory != 0 {
		n += 1 + sovAgent(uint64(m.TotalMemory))
	}
	if m.HostId != 0 {
		n += 1 + sovAgent(uint64(m.HostId))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if m.ContainerHostType != 0 {
		n += 1 + sovAgent(uint64(m.ContainerHostType))
	}
	return n
}

func (m *CollectorReqStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorECSTask) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AwsAccountID != 0 {
		n += 1 + sovAgent(uint64(m.AwsAccountID))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ECSTask) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Arn)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ResourceVersion)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.LaunchType)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.DesiredStatus)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.KnownStatus)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Family)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.AvailabilityZone)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Limits) > 0 {
		for k, v := range m.Limits {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + 8
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	if len(m.EphemeralStorageMetrics) > 0 {
		for k, v := range m.EphemeralStorageMetrics {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + sovAgent(uint64(v))
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	l = len(m.ServiceName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.VpcId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.PullStartedAt != 0 {
		n += 1 + sovAgent(uint64(m.PullStartedAt))
	}
	if m.PullStoppedAt != 0 {
		n += 1 + sovAgent(uint64(m.PullStoppedAt))
	}
	if m.ExecutionStoppedAt != 0 {
		n += 1 + sovAgent(uint64(m.ExecutionStoppedAt))
	}
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if len(m.EcsTags) > 0 {
		for _, s := range m.EcsTags {
			l = len(s)
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if len(m.ContainerInstanceTags) > 0 {
		for _, s := range m.ContainerInstanceTags {
			l = len(s)
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 2 + l + sovAgent(uint64(l))
	}
	l = len(m.ContainerInstanceArn)
	if l > 0 {
		n += 2 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ECSContainer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DockerID)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.DockerName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Image)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ImageID)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.CreatedAt != 0 {
		n += 1 + sovAgent(uint64(m.CreatedAt))
	}
	if m.StartedAt != 0 {
		n += 1 + sovAgent(uint64(m.StartedAt))
	}
	if m.FinishedAt != 0 {
		n += 1 + sovAgent(uint64(m.FinishedAt))
	}
	l = len(m.DesiredStatus)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.KnownStatus)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ExitCode != nil {
		l = m.ExitCode.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.LogDriver)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.LogOptions) > 0 {
		for k, v := range m.LogOptions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + len(v) + sovAgent(uint64(len(v)))
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	l = len(m.ContainerArn)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if m.Health != nil {
		l = m.Health.Size()
		n += 2 + l + sovAgent(uint64(l))
	}
	if len(m.Labels) > 0 {
		for _, s := range m.Labels {
			l = len(s)
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Limits) > 0 {
		for k, v := range m.Limits {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + 8
			n += mapEntrySize + 2 + sovAgent(uint64(mapEntrySize))
		}
	}
	l = len(m.Snapshotter)
	if l > 0 {
		n += 2 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ECSContainerNetwork) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NetworkMode)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Ipv4Addresses) > 0 {
		for _, s := range m.Ipv4Addresses {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Ipv6Addresses) > 0 {
		for _, s := range m.Ipv6Addresses {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *ECSContainerPort) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ContainerPort != 0 {
		n += 1 + sovAgent(uint64(m.ContainerPort))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.HostIp)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.HostPort != 0 {
		n += 1 + sovAgent(uint64(m.HostPort))
	}
	return n
}

func (m *ECSContainerVolume) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DockerName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Destination)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ECSContainerHealth) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Since != 0 {
		n += 1 + sovAgent(uint64(m.Since))
	}
	if m.ExitCode != nil {
		l = m.ExitCode.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Output)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ECSContainerExitCode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExitCode != 0 {
		n += 1 + sovAgent(uint64(m.ExitCode))
	}
	return n
}

func (m *CollectorPod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Pods) > 0 {
		for _, e := range m.Pods {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.IsTerminated {
		n += 2
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorPodDisruptionBudget) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if len(m.PodDisruptionBudgets) > 0 {
		for _, e := range m.PodDisruptionBudgets {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorReplicaSet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.ReplicaSets) > 0 {
		for _, e := range m.ReplicaSets {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorDeployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Deployments) > 0 {
		for _, e := range m.Deployments {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorService) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Services) > 0 {
		for _, e := range m.Services {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorNode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.HostAliasMapping) > 0 {
		for k, v := range m.HostAliasMapping {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovAgent(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorCluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorManifest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Manifests) > 0 {
		for _, e := range m.Manifests {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorManifestCRD) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Manifest != nil {
		l = m.Manifest.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *CollectorManifestCR) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Manifest != nil {
		l = m.Manifest.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *CollectorNamespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Namespaces) > 0 {
		for _, e := range m.Namespaces {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorJob) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Jobs) > 0 {
		for _, e := range m.Jobs {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorCronJob) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.CronJobs) > 0 {
		for _, e := range m.CronJobs {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorDaemonSet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.DaemonSets) > 0 {
		for _, e := range m.DaemonSets {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorStatefulSet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.StatefulSets) > 0 {
		for _, e := range m.StatefulSets {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorPersistentVolume) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.PersistentVolumes) > 0 {
		for _, e := range m.PersistentVolumes {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorPersistentVolumeClaim) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.PersistentVolumeClaims) > 0 {
		for _, e := range m.PersistentVolumeClaims {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorRole) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Roles) > 0 {
		for _, e := range m.Roles {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorRoleBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.RoleBindings) > 0 {
		for _, e := range m.RoleBindings {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorClusterRole) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.ClusterRoles) > 0 {
		for _, e := range m.ClusterRoles {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorClusterRoleBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.ClusterRoleBindings) > 0 {
		for _, e := range m.ClusterRoleBindings {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorServiceAccount) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.ServiceAccounts) > 0 {
		for _, e := range m.ServiceAccounts {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorIngress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.Ingresses) > 0 {
		for _, e := range m.Ingresses {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorVerticalPodAutoscaler) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.VerticalPodAutoscalers) > 0 {
		for _, e := range m.VerticalPodAutoscalers {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorHorizontalPodAutoscaler) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.HorizontalPodAutoscalers) > 0 {
		for _, e := range m.HorizontalPodAutoscalers {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorNetworkPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.NetworkPolicies) > 0 {
		for _, e := range m.NetworkPolicies {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorLimitRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.LimitRanges) > 0 {
		for _, e := range m.LimitRanges {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorStorageClass) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GroupId != 0 {
		n += 1 + sovAgent(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovAgent(uint64(m.GroupSize))
	}
	if len(m.StorageClasses) > 0 {
		for _, e := range m.StorageClasses {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.AgentVersion != nil {
		l = m.AgentVersion.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *AgentVersion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Major != 0 {
		n += 1 + sovAgent(uint64(m.Major))
	}
	if m.Minor != 0 {
		n += 1 + sovAgent(uint64(m.Minor))
	}
	if m.Patch != 0 {
		n += 1 + sovAgent(uint64(m.Patch))
	}
	l = len(m.Pre)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Meta)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Commit)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *CollectorStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ActiveClients != 0 {
		n += 1 + sovAgent(uint64(m.ActiveClients))
	}
	if m.Interval != 0 {
		n += 1 + sovAgent(uint64(m.Interval))
	}
	return n
}

func (m *TracerMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RuntimeId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ServiceName)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *PortInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tcp) > 0 {
		l = 0
		for _, e := range m.Tcp {
			l += sovAgent(uint64(e))
		}
		n += 1 + sovAgent(uint64(l)) + l
	}
	if len(m.Udp) > 0 {
		l = 0
		for _, e := range m.Udp {
			l += sovAgent(uint64(e))
		}
		n += 1 + sovAgent(uint64(l)) + l
	}
	return n
}

func (m *Process) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != 0 {
		n += 1 + sovAgent(uint64(m.Key))
	}
	if m.Pid != 0 {
		n += 1 + sovAgent(uint64(m.Pid))
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.User != nil {
		l = m.User.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Cpu != nil {
		l = m.Cpu.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.CreateTime != 0 {
		n += 1 + sovAgent(uint64(m.CreateTime))
	}
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.OpenFdCount != 0 {
		n += 1 + sovAgent(uint64(m.OpenFdCount))
	}
	if m.State != 0 {
		n += 1 + sovAgent(uint64(m.State))
	}
	if m.IoStat != nil {
		l = m.IoStat.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ContainerKey != 0 {
		n += 1 + sovAgent(uint64(m.ContainerKey))
	}
	if m.VoluntaryCtxSwitches != 0 {
		n += 2 + sovAgent(uint64(m.VoluntaryCtxSwitches))
	}
	if m.InvoluntaryCtxSwitches != 0 {
		n += 2 + sovAgent(uint64(m.InvoluntaryCtxSwitches))
	}
	l = len(m.ByteKey)
	if l > 0 {
		n += 2 + l + sovAgent(uint64(l))
	}
	l = len(m.ContainerByteKey)
	if l > 0 {
		n += 2 + l + sovAgent(uint64(l))
	}
	if m.NsPid != 0 {
		n += 2 + sovAgent(uint64(m.NsPid))
	}
	if m.Networks != nil {
		l = m.Networks.Size()
		n += 2 + l + sovAgent(uint64(l))
	}
	if len(m.ProcessContext) > 0 {
		for _, s := range m.ProcessContext {
			l = len(s)
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 2 + l + sovAgent(uint64(l))
		}
	}
	if m.Language != 0 {
		n += 2 + sovAgent(uint64(m.Language))
	}
	if m.PortInfo != nil {
		l = m.PortInfo.Size()
		n += 2 + l + sovAgent(uint64(l))
	}
	if m.ServiceDiscovery != nil {
		l = m.ServiceDiscovery.Size()
		n += 2 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ServiceDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GeneratedServiceName != nil {
		l = m.GeneratedServiceName.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.DdServiceName != nil {
		l = m.DdServiceName.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.AdditionalGeneratedNames) > 0 {
		for _, e := range m.AdditionalGeneratedNames {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.TracerMetadata) > 0 {
		for _, e := range m.TracerMetadata {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.ApmInstrumentation {
		n += 2
	}
	return n
}

func (m *ServiceName) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Source != 0 {
		n += 1 + sovAgent(uint64(m.Source))
	}
	return n
}

func (m *ProcessDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Pid != 0 {
		n += 1 + sovAgent(uint64(m.Pid))
	}
	if m.NsPid != 0 {
		n += 1 + sovAgent(uint64(m.NsPid))
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.User != nil {
		l = m.User.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.CreateTime != 0 {
		n += 1 + sovAgent(uint64(m.CreateTime))
	}
	l = len(m.ByteKey)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Command) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	l = len(m.Cwd)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Root)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.OnDisk {
		n += 2
	}
	if m.Ppid != 0 {
		n += 1 + sovAgent(uint64(m.Ppid))
	}
	if m.Pgroup != 0 {
		n += 1 + sovAgent(uint64(m.Pgroup))
	}
	l = len(m.Exe)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Comm)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ProcessUser) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Uid != 0 {
		n += 1 + sovAgent(uint64(m.Uid))
	}
	if m.Gid != 0 {
		n += 1 + sovAgent(uint64(m.Gid))
	}
	if m.Euid != 0 {
	